<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
/**
 *
 * Portfolio Service Widget .
 *
 */
class Realar_Portfolio_Service extends Widget_Base {

	public function get_name() {
		return 'realarportfolioservice';
	}

	public function get_title() {
		return __( 'Realar Property Details', 'realar' );
	}

	public function get_icon() {
		return 'th-icon';
    }

	public function get_categories() {
		return [ 'realar' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'features_section',
			[
				'label'     => __( 'realar', 'realar' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );


       

		$this->add_control(
			'features', [
				'label' 		=> __( 'Features', 'realar' ),
				'type' 			=> Controls_Manager::WYSIWYG,
				'default' 		=> __( 'Rubaida Kanom' , 'realar' ),
				'label_block' 	=> true,
			]
        );
        
		
        //----------------------------feddback repeter start--------------------------------//

		$repeater = new Repeater();

		$repeater->add_control(
			'title', [
				'label' 		=> __( 'Title', 'realar' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Rubaida Kanom' , 'realar' ),
				'label_block' 	=> true,
			]
        );
        $repeater->add_control(
			'tab_name',
			[
				'label' 	=> __( 'Tab Name', 'realar' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'The Title', 'realar' ),
			]
        );
        $repeater->add_control(
			'realar_tab_build_option',
			[
				'label'     => __( 'Tab Name', 'realar' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => $this->realar_tab_choose_option(),
				'default'	=> ''
			]
		);
       
		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Details', 'realar' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'title_field' 	=> '{{{ title }}}',
			]
		);

		$this->end_controls_section();

       



    }
    public function realar_tab_choose_option(){

		$realar_post_query = new WP_Query( array(
			'post_type'				=> 'realar_tab_build',
			'posts_per_page'	    => -1,
		) );

		$realar_tab_title = array();
		$realar_tab_title[''] = __( 'Select a Tab','Realar');

		while( $realar_post_query->have_posts() ) {
			$realar_post_query->the_post();
			$realar_tab_title[ get_the_ID() ] =  get_the_title();
		}
		wp_reset_postdata();

		return $realar_tab_title;

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        echo '<!------------------------------- Features Area start ------------------------------->';







        	echo '<ul class="nav nav-tabs property-plan-tabs" id="propertyTab" role="tablist">';

                $k = 0;
				foreach( $settings['slides'] as $single_data ){
					$k++;

					$active_class = $k == 1 ? 'active' : '';
					$is_true = $k == 1 ? 'true' : 'false';

	                echo '<li class="nav-item" role="presentation">';
	                    echo '<button class="nav-link '.esc_attr( $active_class ).'" id="property-tab'.esc_attr( $k ).'" data-bs-toggle="tab" data-bs-target="#propertyTab'.esc_attr( $k ).'" type="button" role="tab" aria-controls="propertyTab'.esc_attr( $k ).'" aria-selected="'.esc_attr( $is_true ).'">'.esc_html($single_data['tab_name']).'</button>';
	                echo '</li>';
	            }

               
            echo '</ul>';
            echo '<div class="property-plan-tab-content">';
                echo '<div class="row gx-60 gy-40">';
                    echo '<div class="col-lg-6">';
                    	if( !empty(  $settings['features'] ) ){
	                        echo '<div class="property-plan-details">';
	                            echo wp_kses_post( $settings['features'] );

	                        echo '</div>';
	                    }
                    echo '</div>';
                    echo '<div class="col-lg-6">';
                        echo '<div class="tab-content" id="propertyTabContent">';

                        	$k = 0;
							foreach( $settings['slides'] as $single_data ){
								$k++;

								$show_active = $k == 1 ? 'show active' : '';
								$is_true = $k == 1 ? 'true' : 'false';

	                            echo '<div class="tab-pane fade '.esc_attr( $show_active ).'" id="propertyTab'.esc_attr( $k ).'" role="tabpanel" aria-labelledby="property-tab'.esc_attr( $k ).'">';
	                                
	                                $elementor = \Elementor\Plugin::instance();
									if( ! empty( $single_data['realar_tab_build_option'] ) ){
									    echo $elementor->frontend->get_builder_content_for_display( $single_data['realar_tab_build_option'] );
									}

	                            echo '</div>';
	                        }
                            
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        

		

		echo '<!--------------------------------- Features Area end --------------------------------->';
	}
}