<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Realar_Image extends Widget_Base {

	public function get_name() {
		return 'realarimage';
	}
	public function get_title() {
		return __( 'Image', 'realar' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'realar' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image', 'realar' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		realar_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five','Style Six','Style Seven','Style Eight','Style Nine','Style Ten','Style Eleven','Style Twelve','Style Thirteen','Style Fourteen'] );

		realar_media_fields( $this, 'image1', 'Choose Image' );
		realar_media_fields( $this, 'image2', 'Choose Image' ,[ '3','4','5','9','10','13' ]);
		realar_media_fields( $this, 'image3', 'Choose Image' ,[ '9','10' ]);
		realar_media_fields( $this, 'image4', 'Choose Image' ,[ '9' ]);
		realar_general_fields( $this, 'years', 'Years', 'TEXT', ' 28', ['14' ] );
		realar_general_fields( $this, 'title', 'Title', 'TEXT', 'Realar Agent Realar Living Solutions', [ '2','4','5','6','9','10','14' ] );
		realar_general_fields( $this, 'title2', 'Title 2', 'TEXT', ' Solutions', ['14' ] );
		realar_general_fields( $this, 'url', 'Video Url', 'TEXTAREA2', '35', [  '5','10' ] );

		realar_general_fields($this, 'button_text', 'Button Text', 'TEXT', 'Button Text' , [ '6' ]);
		realar_url_fields($this, 'button_url', 'Button URL' , [ '6' ]);

		realar_gallery_fields( $this, 'brand_logo', 'Brand' , [ '8' ] );
		// realar_media_fields( $this, 'image2', 'Choose Image', ['1', '4', '5'] );
		// realar_media_fields( $this, 'image3', 'Choose Image', ['4', '5'] );
		// realar_general_fields( $this, 'name', 'Name', 'TEXTAREA2', 'Benjamin Dowd', [ '5', '9'] );
		// realar_general_fields( $this, 'desig', 'Designatin', 'TEXTAREA2', 'Founder of Konta', ['5'] );

       $this->end_controls_section();

      	//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Title Style-------
		// realar_common_style_fields( $this, 'num', 'Number', '{{WRAPPER}} .num', ['1'] );
		// realar_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .title', ['1'] );

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
       
		if( $settings['layout_style'] == '1' ){
			if(!empty($settings['image1']['url'])){
				echo '<div class="img-box1">';
	                echo '<div class="img1 img-shine" data-mask-src="'.REALAR_PLUGDIRURI . 'assets/img/about-1-mask.png">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            echo '</div>';
	        }
		}elseif( $settings['layout_style'] == '2' ){

			echo '<div class="about-tag">';
				if(!empty($settings['title'])){
	                echo '<div class="about-experience-tag">';
	                    echo '<span class="circle-title-anime">'.wp_kses_post( $settings['title'] ).'</span>';
	                echo '</div>';
	            }
                echo '<div class="about-tag-thumb">';
                    echo realar_img_tag( array(
						'url'   => esc_url( $settings['image1']['url'] ),
					));
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="testi-thumb-wrap">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2 jump">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			echo '<div class="img-box5">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
                
                echo '<div class="client-group-wrap jump">';
                	if(!empty($settings['title'])){
	                    echo '<h5 class="box-title">';
	                      	echo wp_kses_post( $settings['title'] );
	                    echo '</h5>';
	                }
                    if(!empty($settings['image2']['url'])){
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="img-box6">';
                if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
                echo '<div class="img2">';
                    if(!empty($settings['image2']['url'])){
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                }
                echo '</div>';
                if(!empty($settings['title'])){
	                echo '<div class="about-tag">';
	                    echo '<div class="about-experience-tag">';
	                        echo '<span class="circle-title-anime">'.esc_html( $settings['title'] ).'</span>';
	                    echo '</div>';
	                    if(!empty($settings['url'])){
		                    echo '<a href="'.esc_url( $settings['url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
		                }
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="contact-thumb5-1">';
				if(!empty($settings['image1']['url'])){
	                echo realar_img_tag( array(
						'url'   => esc_url( $settings['image1']['url'] ),
					));
	            }
                echo '<div class="contact-cta-wrap">';
                	if(!empty($settings['title'])){
	                    echo '<h4 class="box-title">'.esc_html( $settings['title'] ).'</h4>';
	                }
	                if( ! empty( $settings['button_text'] ) ) {
	                    echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style5">'.esc_html( $settings['button_text'] ).'<span class="btn-icon"><i class="fas fa-paper-plane"></i></span></a>';
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="main-container">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="image-container"></div>';
	                echo '<img class="panorama-img" src="'.esc_url( $settings['image1']['url'] ).'" alt="Panorama Image" style="display: none;" />';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '8' ){
			echo '<div class="row gy-4">';
				foreach ( $settings['brand_logo'] as $single_data ) {
		            echo '<div class="col-lg-6">';
		                echo '<div class="property-plan-gallery-thumb">';
		                    echo realar_img_tag( array(
								'url'   => esc_url( $single_data['url']  ),
							));
		                echo '</div>';
		            echo '</div>';
		        }
	        echo '</div>';
		}elseif( $settings['layout_style'] == '9' ){
			echo '<div class="img-box9 mb-50 mb-xl-0">';
                echo '<div class="img1">';
                    if(!empty($settings['image1']['url'])){
		                echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
		            }
                    echo '<div class="img2">';
                        if(!empty($settings['image2']['url'])){
			                echo realar_img_tag( array(
								'url'   => esc_url( $settings['image2']['url'] ),
							));
			            }
                    echo '</div>';
                echo '</div>';
                echo '<div class="img3">';
                    if(!empty($settings['image3']['url'])){
		                echo realar_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
		            }
                echo '</div>';
                echo '<div class="client-group-wrap">';
                	if(!empty( $settings['title'] )){
	                    echo '<h5 class="box-title">'.wp_kses_post( $settings['title'] ).'</h5>';
	                }
                    if(!empty($settings['image4']['url'])){
		                echo realar_img_tag( array(
							'url'   => esc_url( $settings['image4']['url'] ),
						));
		            }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '10' ){
			echo '<div class="img-box10">';
                echo '<div class="img1">';
                    if(!empty($settings['image1']['url'])){
		                echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
		            }
                echo '</div>';
                echo '<div class="img2">';
                    if(!empty($settings['image2']['url'])){
		                echo realar_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
		            }
                echo '</div>';
                echo '<div class="img3">';
                    if(!empty($settings['image3']['url'])){
		                echo realar_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						));
		            }
                echo '</div>';
                echo '<div class="about-tag">';
                	if(!empty( $settings['title'] )){
	                    echo '<div class="about-experience-tag">';
	                        echo '<span class="circle-title-anime">'.wp_kses_post( $settings['title'] ).'</span>';
	                    echo '</div>';
	                }
	                if(!empty( $settings['url'] )){
	                    echo '<a href="'.esc_url( $settings['url'] ).'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
	                }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '11' ){
			echo '<div class="why-img-box2">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '12' ){
			echo '<div class="testi-thumb-wrap7">';
                if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}elseif( $settings['layout_style'] == '13' ){
			echo '<div class="img-box11">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="img1">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image1']['url'] ),
						));
	                echo '</div>';
	            }
	            if(!empty($settings['image2']['url'])){
	                echo '<div class="img2 moving">';
	                    echo realar_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
	                echo '</div>';
	            }
            echo '</div>';
		}else{
			echo '<div class="about-experience-wrap">';
				if(!empty($settings['image1']['url'])){
	                echo '<div class="box-number" data-bg-src="'.esc_url( $settings['image1']['url'] ).'">'.esc_html( $settings['years'] ).'</div>';
	            }
                echo '<div class="box-content">';
                	if(!empty($settings['title'])){
	                    echo '<span class="box-text">'.esc_html( $settings['title'] ).'</span>';
	                }
	                if(!empty($settings['title2'])){
	                    echo '<span class="border-text">'.esc_html( $settings['title2'] ).'</span>';
	                }
                echo '</div>';
            echo '</div>';
		}
	}
}