<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Tour Destinations Widget .
 *
 */
class Realar_Destinations extends Widget_Base {

	public function get_name() {
		return 'realardestinations';
	}
	public function get_title() {
		return __( 'Destinations', 'realar' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'realar' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Destinations', 'realar' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		realar_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One','Style Two'] );


		$fields_to_include = [ 'image' => ['Thumb Image'], 'title' => ['Title'], 'url' => ['URL'] ];
		realar_repeater_fields( $this, 'cat_list', 'Tour Destinations Lists', $fields_to_include, ['1'] );

		$fields_to_include2 = [ 'image' => ['Thumb Image'], 'title' => ['Title','Number'], 'url' => ['URL'] ];
		realar_repeater_fields( $this, 'cat_list2', 'Tour Destinations Lists', $fields_to_include2, ['2'] );

		realar_general_fields($this, 'arrow_id', 'Arrow ID or Class', 'TEXT', 'serviceSlider2');


        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start

		realar_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .title a', ['1','2'] );

		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){
			echo '<div class="container-fluid">';
	            echo '<div class="destination-wrap1">';
	                echo '<div class="swiper th-slider destination-slider1" id="'.esc_attr( $settings['arrow_id'] ).'" data-slider-options=\'{"spaceBetween":"24","breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"3"},"1200":{"slidesPerView":"4"}}}\'>';
	                    echo '<div class="swiper-wrapper">';
	                        foreach( $settings['cat_list'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="destination-card">';
		                                echo '<div class="card-thumb">';
		                                    if(!empty($data['thumb_image']['url'])){
				                                echo realar_img_tag( array(
													'url'   => esc_url( $data['thumb_image']['url'] ),
												));
				                            }
		                                echo '</div>';
		                                if(!empty($data['title'])){
		                                	echo '<div class="card-details">';
		                                        echo '<h4 class="box-title title">';
		                                            echo '<a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a>';
		                                        echo '</h4>';
	                                        echo '</div>';
	                                    }

		                            echo '</div>';
		                        echo '</div>';
		                    }
	                        
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';
		}else{
			echo '<div class="row gy-4">';

			$counter = 1;

			foreach( $settings['cat_list2'] as $data ){

			    $column_class = ($counter === 3 || $counter === 4) ? 'col-xl-6 col-md-6' : 'col-xl-3 col-md-6';
			    echo '<div class="' . esc_attr( $column_class ) . '">';
			        echo '<div class="destination-card style2">';
			            echo '<div class="card-thumb">';
			                if(!empty($data['thumb_image']['url'])){
			                    echo realar_img_tag( array(
			                        'url'   => esc_url( $data['thumb_image']['url'] ),
			                    ));
			                }
			            echo '</div>';
			            echo '<div class="card-details text-start">';
			                if(!empty($data['title'])){
			                    echo '<h4 class="box-title title">';
			                        echo '<a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a>';
			                    echo '</h4>';
			                }
			                if(!empty($data['number'])){
			                    echo '<p class="box-text">'.esc_html($data['number']).'</p>';
			                }
			            echo '</div>';
			        echo '</div>';
			    echo '</div>';

			    $counter++;
			}

			echo '</div>';

		}
	}
}