<?php
/**
 * @Packge     : Realar
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

// Block direct access
if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! function_exists( 'realar_setup' ) ){
    function realar_setup() {

    	$selected_options   =   get_option('et_selected_realar_demo_plugin');

        // content width
        $GLOBALS['content_width'] = apply_filters( 'realar_content_width', 751 );

        // language file
		load_theme_textdomain( 'realar', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		// title tag
		add_theme_support( 'title-tag' );

		// post thumbnails
		add_theme_support( 'post-thumbnails' );

        add_image_size( 'realar-shop-single',580,580,true );
        add_image_size( 'realar-shop-thumb',100,106,true );
        add_image_size( 'realar-shop-small-image',294,312,true ); 
        add_image_size( 'realar_85X85',85,85,true );

        register_nav_menus( array(
            'primary-menu'      => esc_html__( 'Primary Menu', 'realar' ),
        ) );

		//support html5
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'script',
				'style'
			)
		);


        // support post format
        add_theme_support( 'post-formats', array( 'audio', 'video', 'gallery', 'quote') );

		// Custom logo
		add_theme_support( 'custom-logo' );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( 'assets/css/style-editor.css' );

		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );

		if($selected_options == 'with_woocommerce'){
	        // support woocommerce
	        add_theme_support( 'woocommerce' );
	        add_theme_support( 'wc-product-gallery-zoom' );
	        add_theme_support( 'wc-product-gallery-slider' );
	    }

	}
}
add_action( 'after_setup_theme', 'realar_setup' );


function remove_directorist_scripts_from_output($buffer) {
    return preg_replace('/<script[^>]*src=["\'].*directorist\/assets\/vendor-js\/swiper(\.min)?\.js[^>]*><\/script>/i', '', $buffer);
}

function start_buffering_output() {
    ob_start('remove_directorist_scripts_from_output');
}

function end_buffering_output() {
    if (ob_get_length()) ob_end_flush();
}

add_action('wp_head', 'start_buffering_output', 1);
add_action('wp_footer', 'end_buffering_output', 100);