<?php
/**
 * realar Dashboard Install Plugins Page
 *
 * @package realar
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$realar_my_theme = wp_get_theme();
if ( $realar_my_theme->parent_theme ) {
	$realar_my_theme = wp_get_theme( basename( get_template_directory() ) );
}

?>

<div class="wrap about-wrap et-admin-wrap">

	<div class="et-header">
		<h1><?php echo esc_html__( 'Welcome to ', 'realar' ) . esc_html( $realar_my_theme->Name ); ?> <?php printf( esc_html__( 'V%s', 'realar' ), esc_html( $realar_my_theme->Version ) ); ?></h1>
		<div class="about-text"><?php echo esc_html( $realar_my_theme->Name ) . esc_html__( ' is now installed and ready to use!', 'realar' ); ?></div>
		<h2>Developed By <a href="<?php echo esc_url( 'https://themeforest.net/user/themeholy/portfolio' ); ?>" target="_blank"><?php esc_html_e( 'Themeholy', 'realar' ); ?></a></h2>
	</div>

	<h2 class="nav-tab-wrapper wp-clearfix">
		<a class="nav-tab" href="<?php echo esc_url( self_admin_url( 'admin.php?page=realar-dashboard' ) ); ?>"><?php esc_html_e( 'Dashboard', 'realar' ); ?></a>
		<a class="nav-tab nav-tab-active" href="<?php echo esc_url( self_admin_url( 'admin.php?page=realar-admin-plugins' ) ); ?>"><?php esc_html_e( 'Install Plugins', 'realar' ); ?></a>
		<a class="nav-tab" href="<?php echo esc_url( self_admin_url( 'themes.php?page=realar-demo-import' ) ); ?>"><?php esc_html_e( 'Demo Importer', 'realar' ); ?></a>
	</h2>
	<?php
    if ( isset($_POST['realar_demo']) ) {
		echo "<meta http-equiv='refresh' content='0'>";
        update_option('et_realar_demo_plugin_name', $_POST['realar_demo'], 'yes');
    }
    $realar_demo = get_option( 'et_realar_demo_plugin_name' );
    if($realar_demo):
        update_option('et_selected_realar_demo_plugin', $realar_demo, 'yes');
    else:
        update_option('et_selected_realar_demo_plugin', 'without_woocommerce', 'yes');
    endif;
    ?>

    <form action="" method="post" id="et-realar_demo-check" class="et-theme-register-form">
        <div class="realar_demo-plugin">
            <h3><?php echo esc_html__('Please select the preferred version of the theme you would like to use.', 'realar'); ?></h3>
            <ul>
                <li>
                    <input type="radio" id="with_woocommerce" name="realar_demo" value="with_woocommerce" <?php if($realar_demo == 'with_woocommerce'): ?>checked<?php endif; ?>>
                    <label for="with_woocommerce"><?php echo esc_html__('With WooCommerce', 'realar'); ?></label>
                </li>
                <li>
                    <input type="radio" id="without_woocommerce" name="realar_demo" value="without_woocommerce" <?php if($realar_demo == 'without_woocommerce'): ?>checked<?php endif; ?>>
                    <label for="without_woocommerce"><?php echo esc_html__('Without WooCommerce', 'realar'); ?></label>
                </li>
            </ul>
        </div>

		

        <input type="submit" class="et-realar_demo-btn" value='Save'>
    </form>

	<div id="realar-dashboard" class="wrap about-wrap">
		<div class="welcome-content w-clearfix extra">
			<div class="realar-plugins realar-theme-browser-wrap">
				<div class="theme-browser rendered">
					<div class="whi-install-plugins-wrap">
						<h3><?php echo esc_html__( 'These below plugins are required', 'realar' ); ?></h3>
						<a href="#" class="realar-admin-btn whi-install-plugins"><?php echo esc_html__( 'Activate all plugins', 'realar' ); ?></a>
						

						
					</div>
					<div class="realar-plugins-wrap realar-plugins">

					<?php

					$tgmpa_list_table = new TGMPA_List_Table();
					$plugins          = TGM_Plugin_Activation::$instance->plugins;

					foreach ( $plugins as $plugin ) :

						$plugin_status              = '';
						$plugin['type']             = isset( $plugin['type'] ) ? $plugin['type'] : 'recommended';
						$plugin['sanitized_plugin'] = $plugin['name'];

						$plugin_action = $tgmpa_list_table->actions_plugin( $plugin );

						if ( strpos( $plugin_action, 'deactivate' ) !== false ) {
							$plugin_status = 'active';
							$plugin_action = '<div class="row-actions visible active"><span class="activate"><a class="button realar-admin-btn">' . esc_html__( 'Activated', 'realar' ) . '</a></span></div>';
						}

						?>
						<div class="realar-plugin wp-clearfix <?php echo esc_attr( $plugin_status ); ?>" data-plugin-name="<?php echo esc_html( $plugin['name'] ); ?>">
							<h4><?php echo esc_html( $plugin['name'] ); ?></h4>
							<?php echo '' . $plugin_action; ?>
						</div>

					<?php endforeach; ?>

					</div>
				</div>
			</div>
		</div>
	</div>

</div> <!-- end wrap -->
