<?php
/**
 * @Packge     : Realar
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

// Block direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Include File
 *
 */

$selected_options   =   get_option('et_selected_realar_demo_plugin');

// Constants
require_once get_parent_theme_file_path() . '/inc/realar-constants.php';

//theme setup
require_once REALAR_DIR_PATH_INC . 'theme-setup.php';

//essential scripts
require_once REALAR_DIR_PATH_INC . 'essential-scripts.php';


if($selected_options == 'with_woocommerce'){
    // Woo Hooks
    require_once REALAR_DIR_PATH_INC . 'woo-hooks/realar-woo-hooks.php';

    // Woo Hooks Functions
    require_once REALAR_DIR_PATH_INC . 'woo-hooks/realar-woo-hooks-functions.php';
}

// plugin activation
require_once REALAR_DIR_PATH_FRAM . 'plugins-activation/realar-active-plugins.php';

// theme dynamic css
require_once REALAR_DIR_PATH_INC . 'realar-commoncss.php';

// meta options
require_once REALAR_DIR_PATH_FRAM . 'realar-meta/realar-config.php';

// page breadcrumbs
require_once REALAR_DIR_PATH_INC . 'realar-breadcrumbs.php';

// sidebar register
require_once REALAR_DIR_PATH_INC . 'realar-widgets-reg.php';

//essential functions
require_once REALAR_DIR_PATH_INC . 'realar-functions.php';

// helper function
require_once REALAR_DIR_PATH_INC . 'wp-html-helper.php';

// Demo Data
require_once REALAR_DEMO_DIR_PATH . 'demo-import.php';

// pagination
require_once REALAR_DIR_PATH_INC . 'wp_bootstrap_pagination.php';

// realar options
require_once REALAR_DIR_PATH_FRAM . 'realar-options/realar-options.php';

// hooks
require_once REALAR_DIR_PATH_HOOKS . 'hooks.php';

// hooks funtion
require_once REALAR_DIR_PATH_HOOKS . 'hooks-functions.php'; 







add_action('wp_ajax_update_cart_count', 'update_cart_count');
add_action('wp_ajax_nopriv_update_cart_count', 'update_cart_count');





function update_cart_count() {
    if (class_exists('woocommerce')) {
        global $woocommerce;
        $product_id = intval($_POST['product_id']);
        $woocommerce->cart->add_to_cart($product_id); // Add the product to the cart

        $cart_count = $woocommerce->cart->cart_contents_count;
        echo esc_html($cart_count);
    }
    wp_die();
}

function dequeue_elementor_swiper() {
    if (is_admin()) return; // Avoid affecting admin panel

    wp_dequeue_script('swiper'); // Dequeue Elementor's Swiper.js
    wp_deregister_script('swiper'); // Unregister it completely
}
add_action('wp_enqueue_scripts', 'dequeue_elementor_swiper', 20);




if ( is_admin() ) {
    include_once get_template_directory() . '/inc/realar-dashboard/et-admin.php';
}

function realar_enqueue_scripts() {
    wp_enqueue_style(
        'realar-admin-styles',
        get_template_directory_uri() . '/inc/realar-dashboard/css/admin-pages.css',
        array(),
        time()
    );
}
add_action( 'admin_enqueue_scripts', 'realar_enqueue_scripts' );

function realar_dashboard_submenu_page() {

    if(!function_exists('realar_init')) {
        add_menu_page(
            esc_html__( 'ThemeHoly', 'realar' ),
            esc_html__( 'ThemeHoly', 'realar' ),
            'manage_options',
            'realar-dashboard',
            '',
            get_template_directory_uri() . '/inc/realar-dashboard/images/favicon.png',
            2
        );
    }
    
    add_submenu_page(
        'realar-dashboard',
        esc_html__( 'Dashboard', 'realar' ),
        esc_html__( 'Dashboard', 'realar' ),
        'manage_options',
        'realar-dashboard',
        'realar_screen_welcome'
    );
}
add_action( 'admin_menu', 'realar_dashboard_submenu_page' );

function realar_screen_welcome() {
    echo '<div class="wrap" style="height:0;overflow:hidden;"><h2></h2></div>';
    require_once get_parent_theme_file_path( '/inc/realar-dashboard/welcome.php' );
}

function realar_plugins_submenu_page() {

    add_submenu_page(
        'realar-dashboard',
        esc_html__( 'Install Plugins', 'realar' ),
        esc_html__( 'Install Plugins', 'realar' ),
        'manage_options',
        'realar-admin-plugins',
        'realar_screen_plugin'
    );

}
add_action( 'admin_menu', 'realar_plugins_submenu_page' );

function realar_screen_plugin() {
    echo '<div class="wrap" style="height:0;overflow:hidden;"><h2></h2></div>';
    require_once get_parent_theme_file_path( '/inc/realar-dashboard/install-plugins.php' );
}


