<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Widget .
 *
 */
class Realar_Workprocess extends Widget_Base {

	public function get_name() {
		return 'realarwp';
	}
	public function get_title() {
		return __( 'Work Process', 'realar' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'realar' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Work Process', 'realar' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		realar_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One'] );

		realar_media_fields( $this, 'image', 'Mask Image' );

		$fields_to_include2 = [ 'title' => ['Title','Description'] ];
		realar_repeater_fields( $this, 'service_list2', 'Feature Lists', $fields_to_include2, ['1'] );


        $this->end_controls_section();

		realar_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .box-title', ['1', '2'] );
		realar_common2_style_fields( $this, 'title3', 'Title', '{{WRAPPER}} .t_title', ['3'] );
		realar_common2_style_fields( $this, 'title4', 'Description', '{{WRAPPER}} .desc', ['1', '2','3'] );

		realar_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .th_btn', ['3']);


	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="row gy-4 justify-content-center">';

                $i = 0;
                foreach( $settings['service_list2'] as $data ){ 
                	$i++;
            		$k = str_pad($i, 2, '0', STR_PAD_LEFT); 
            		$mask = $settings['image']['url']  ? $settings['image']['url']  : '#';

	                echo '<div class="col-xxl-3 col-xl-4 col-md-6">';
	                    echo '<div class="process-card">';
	                        echo '<div class="box-number">'.esc_html( $k ).'</div>';
		                        echo '<div class="box-content" data-mask-src="'.esc_url( $mask ).'">';
		                            if(!empty($data['title'])){
			                            echo '<h3 class="box-title">'.wp_kses_post($data['title']).'</h3>';
			                        }
			                        if(!empty($data['description'])){
				                        echo '<p class="box-text desc">'.esc_html($data['description']).'</p>';
				                    }
		                        echo '</div>';
	                    echo '</div>';
	                echo '</div>';
	            }
            echo '</div>';
		}
	}
}