<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Counter Up Widget .
 *
 */
class realar_SliderText extends Widget_Base {

	public function get_name() {
		return 'realarslidertext';
	}
	public function get_title() {
		return __( 'slidertext', 'realar' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'realar' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Slider Text', 'realar' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		realar_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One'] ); 

		

		realar_media_fields( $this, 'image', 'Choose Image' );

		$fields_to_include = [ 'title' => ['Title', 'URL'] ];
		realar_repeater_fields( $this, 'counter_lists', 'Sliding Text', $fields_to_include, ['1'] );


		$this->end_controls_section();

       
		//-------Title Style-------
		realar_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} a');
		

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			$img = $settings['image']['url'] ? $settings['image']['url'] : '#';
			echo '<div class=" overflow-hidden">';
		        echo '<div class="container-fluid p-0">';
		            echo '<div class="swiper th-slider marquee-slider1" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":"auto"}},"autoplay":{"delay":0,"disableOnInteraction":false},"noSwiping":"true","speed":10000,"spaceBetween":30}\'>';
		                echo '<div class="swiper-wrapper">';
		                    foreach( $settings['counter_lists'] as $data ){
			                    echo '<div class="swiper-slide">';
			                    	if( !empty( $data['title'] ) ){
			                    		echo '<div class="marquee-card">';
				                            echo '<a target="_blank" href="'.esc_url( $data['url'] ).'"><img class="spin" src="'.esc_url( $img ).'" alt="img"> '.esc_html( $data['title'] ).'</a>';
				                        echo '</div>';
			                    	}
			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}