<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Feature Widget .
 *
 */
class realar_CustoM_Listing extends Widget_Base {

	public function get_name() {
		return 'realarcustomlisting';
	}
	public function get_title() {
		return __( 'Realar Custom Listing', 'realar' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'realar' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Listing', 'realar' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		realar_select_field( $this, 'layout_style', 'Layout Style',[ 'Style One', 'Style Two','Style Three','Style Four','Style Five','Style Six','Style Seven','Style Eight'] );

		$fields_to_include = [ 'image' => ['Thumb Image'], 'title' => ['Title','Price','Location','Bed','Bath','Size','Button Text'], 'url' => ['URL'],'desc' => ['Description'] ];
		realar_repeater_fields( $this, 'service_list', 'Feature Lists', $fields_to_include, ['1','3','5','8'] );


		$fields_to_include2 = [ 'image' => ['Thumb Image', 'Admin Image'], 'title' => ['Title','Price','Location','Bed','Bath','Size','Button Text','Admin Name'], 'url' => ['URL'],'desc' => ['Description'] ];
		realar_repeater_fields( $this, 'service_list2', 'Feature Lists', $fields_to_include2, ['2','4','7'] );



		$fields_to_include3 = [ 'image' => ['Thumb Image'], 'title' => ['Title','Price','Location','Bed','Bath','Size','Parking', 'Rent or Sell'], 'url' => ['URL'] ];
		realar_repeater_fields( $this, 'service_list3', 'Feature Lists', $fields_to_include3, ['6'] );

		realar_switcher_fields( $this, 'show_list', 'Show as Slider?', ['4'] );


        $this->end_controls_section();

		realar_common2_style_fields( $this, 'title2', 'Title', '{{WRAPPER}} .property-card-title a', ['1','2','4','7','8'] );


		realar_common2_style_fields( $this, 'title3', 'Title', '{{WRAPPER}} H4 a', ['6'] );
		realar_common2_style_fields( $this, 'location', 'Location', '{{WRAPPER}} .property-card-location', ['2','4', '6','7','8'] );
		realar_common2_style_fields( $this, 'content', 'Description', '{{WRAPPER}} .property-card-text', ['2','4','7'] );



	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="slider-area property-slider2 slider-drag-wrap">';
                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1500":{"slidesPerView":"4"}},"grabCursor":"true","slideToClickedSlide":"true"}\'>';
                    echo '<div class="swiper-wrapper">';

                    	foreach( $settings['service_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="property-card2">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="property-card-thumb img-shine">';
		                                    echo realar_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="property-card-meta">';
	                                	if(!empty($data['bed'])){
		                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
		                                }
		                                if(!empty($data['bath'])){
		                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
		                                }
		                                if(!empty($data['size'])){
		                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
		                                }
	                                echo '</div>';
	                                echo '<div class="property-card-details">';
	                                    echo '<div class="media-left">';
	                                    	if(!empty($data['title'])){
		                                        echo '<h4 class="property-card-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
		                                    }
		                                    if(!empty($data['price'])){
		                                        echo '<h5 class="property-card-price">'.esc_html($data['price']).'</h5>';
		                                    }
		                                    if(!empty($data['location'])){
		                                        echo '<p class="property-card-location">'.esc_html($data['location']).'</p>';
		                                    }
	                                    echo '</div>';
	                                    if(!empty($data['button_text'])){
		                                    echo '<div class="btn-wrap">';
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style-border2 th-btn-icon">'.esc_html($data['button_text']).'</a>';
		                                    echo '</div>';
		                                }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }

                        
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){
			echo '<div class="slider-area property-slider2 slider-drag-wrap z-index-common" data-pos-for=".about-area-5" data-sec-pos="bottom-half">';
                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1500":{"slidesPerView":"3"}},"grabCursor":"true","slideToClickedSlide":"true"}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['service_list2'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="property-card3">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="property-card-thumb img-shine">';
		                                    echo realar_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="property-card-details">';
	                                	if(!empty($data['title'])){
	                                        echo '<h4 class="property-card-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
	                                    }
	                                    if(!empty($data['location'])){
		                                    echo '<p class="property-card-location"><i class="far fa-map-marker-alt me-2"></i>'.esc_html($data['location']).'</p>';
		                                }
		                                if(!empty($data['description'])){
		                                    echo '<p class="property-card-text">'.esc_html($data['description']).'</p>';
		                                }
	                                    echo '<div class="property-card-meta">';
	                                        if(!empty($data['bed'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
			                                }
			                                if(!empty($data['bath'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
			                                }
			                                if(!empty($data['size'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
			                                }
	                                    echo '</div>';
	                                    echo '<div class="property-btn-wrap">';
	                                        echo '<div class="property-author-wrap">';
	                                        	if(!empty($data['admin_image']['url'])){
		                                            echo realar_img_tag( array(
														'url'   => esc_url( $data['admin_image']['url'] ),
													));
		                                        }
		                                        if(!empty($data['admin_name'])){
		                                            echo '<a href="property-details.html">'.esc_html($data['admin_name']).'</a>';
		                                        }
	                                        echo '</div>';
	                                        echo '<div class="btn-wrap">';
	                                            echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style-border2 th-btn-icon">'.esc_html($data['button_text']).'</a>';
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';

	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){
			echo '<div class="container-fluid p-lg-0">';
	            echo '<div class="slider-area project-slider4 slider-drag-wrap">';
	                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"2.5"},"1500":{"slidesPerView":"2.5"}},"grabCursor":"true","slideToClickedSlide":"true","centeredSlides": "true"}\'>';
	                    echo '<div class="swiper-wrapper">';

	                    	foreach( $settings['service_list'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="portfolio-card style4">';
		                            	if(!empty($data['thumb_image']['url'])){
			                                echo '<div class="portfolio-img">';
			                                    echo realar_img_tag( array(
													'url'   => esc_url( $data['thumb_image']['url'] ),
												));
			                                echo '</div>';
			                            }
		                                echo '<div class="portfolio-content">';
		                                	if(!empty($data['title'])){
			                                    echo '<h3 class="portfolio-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
			                                }
		                                    echo '<p class="portfolio-location">California</p>';
		                                    echo '<div class="property-card-meta">';
		                                        if(!empty($data['bed'])){
				                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
				                                }
				                                if(!empty($data['bath'])){
				                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
				                                }
				                                if(!empty($data['size'])){
				                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
				                                }
		                                    echo '</div>';
		                                    if(!empty($data['description'])){
			                                    echo '<p class="portfolio-text">'.esc_html($data['description']).'</p>';
			                                }
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                    echo '<div class="slider-pagination style3 d-sm-block d-none"></div>';
	                echo '</div>';
	            echo '</div>';
	            
	        echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){

			$arrw_wrap = $settings['show_list'] == 'yes' ? 'slider-drag-wrap' : '';
			echo '<div class="slider-area property-slider2 '.esc_attr( $arrw_wrap ).' z-index-common">';
				if($settings['show_list'] == 'yes'){
	                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1500":{"slidesPerView":"3"}},"grabCursor":"true","slideToClickedSlide":"true"}\'>';
	                    echo '<div class="swiper-wrapper">';
	                }else{
	                	echo '<div class="row gy-30">';
	                }
                        foreach( $settings['service_list2'] as $data ){
	                        if($settings['show_list'] == 'yes'){
	                        	echo '<div class="swiper-slide">';
	                        }else{
	                        	echo '<div class="col-lg-4 col-md-6">';
	                        }
	                            echo '<div class="property-card3 style-border">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="property-card-thumb img-shine">';
		                                    echo realar_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="property-card-details">';
	                                	if(!empty($data['title'])){
	                                        echo '<h4 class="property-card-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
	                                    }
	                                    if(!empty($data['location'])){
		                                    echo '<p class="property-card-location"><i class="far fa-map-marker-alt me-2"></i>'.esc_html($data['location']).'</p>';
		                                }
		                                if(!empty($data['description'])){
		                                    echo '<p class="property-card-text">'.esc_html($data['description']).'</p>';
		                                }
	                                    echo '<div class="property-card-meta">';
	                                        if(!empty($data['bed'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
			                                }
			                                if(!empty($data['bath'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
			                                }
			                                if(!empty($data['size'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
			                                }
	                                    echo '</div>';
	                                    echo '<div class="property-btn-wrap">';
	                                        echo '<div class="property-author-wrap">';
	                                        	if(!empty($data['admin_image']['url'])){
		                                            echo realar_img_tag( array(
														'url'   => esc_url( $data['admin_image']['url'] ),
													));
		                                        }
		                                        if(!empty($data['admin_name'])){
		                                            echo '<a href="#">'.esc_html($data['admin_name']).'</a>';
		                                        }
	                                        echo '</div>';
	                                        echo '<div class="btn-wrap">';
	                                            echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style-border2 th-btn-icon">'.esc_html($data['button_text']).'</a>';
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';

	                            echo '</div>';
	                        echo '</div>';
	                    }
	                    if($settings['show_list'] == 'yes'){
                    	echo '</div>';
                    }
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="container-fluid p-lg-0">';
	            echo '<div class="slider-area project-slider4-1 slider-drag-wrap">';
	                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"2.5"},"1500":{"slidesPerView":"2.5"}},"grabCursor":"true","slideToClickedSlide":"true","centeredSlides": "true"}\'>';
	                    echo '<div class="swiper-wrapper">';

	                    	foreach( $settings['service_list'] as $data ){
		                        echo '<div class="swiper-slide">';
		                            echo '<div class="portfolio-card style4">';
		                            	if(!empty($data['thumb_image']['url'])){
			                                echo '<div class="portfolio-img">';
			                                    echo realar_img_tag( array(
													'url'   => esc_url( $data['thumb_image']['url'] ),
												));
			                                echo '</div>';
			                            }
		                                echo '<div class="portfolio-content">';
		                                	if(!empty($data['title'])){
			                                    echo '<h3 class="portfolio-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h3>';
			                                }
		                                    echo '<p class="portfolio-location">California</p>';
		                                    echo '<div class="property-card-meta">';
		                                        if(!empty($data['bed'])){
				                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
				                                }
				                                if(!empty($data['bath'])){
				                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
				                                }
				                                if(!empty($data['size'])){
				                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
				                                }
		                                    echo '</div>';
		                                    if(!empty($data['description'])){
			                                    echo '<p class="portfolio-text">'.esc_html($data['description']).'</p>';
			                                }
		                                echo '</div>';
		                            echo '</div>';
		                        echo '</div>';
		                    }
	                    echo '</div>';
	                echo '</div>';
	            echo '</div>';
	            
	        echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="slider-area property-slider2">';
                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1500":{"slidesPerView":"3"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                        foreach( $settings['service_list3'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="property-card4">';
	                                echo '<div class="property-card-thumb">';
	                                	if(!empty($data['thumb_image']['url'])){
		                                    echo realar_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                }
		                                if(!empty($data['rent_or_sell'])){
		                                    echo '<div class="property-card-tag">'.esc_html($data['rent_or_sell']).'</div>';
		                                }
	                                    if(!empty( $data['url']['url'] )){
		                                    echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style-white2 th-btn-icon"></a>';
		                                }
	                                    echo '<div class="property-card-hover-wrap">';
	                                    	if(!empty( $data['url']['url'] )){
			                                    echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style4 th-btn-icon"></a>';
			                                }
			                                if(!empty($data['price'])){
		                                        echo '<div class="property-card-price">'.wp_kses_post($data['price']).'</div>';
		                                    }
	                                        echo '<div class="property-card-meta">';
	                                        	if(!empty($data['size'])){
		                                            echo '<span class="meta-wrap">';
		                                                echo '<p class="meta-title">'.esc_html__('Size', 'realar').'</p>';
		                                                echo '<h6 class="meta-content">'.esc_html($data['size']).'</h6>';
		                                            echo '</span>';
		                                        }
		                                        if(!empty($data['bed'])){
		                                            echo '<span class="meta-wrap">';
		                                                echo '<p class="meta-title">'.esc_html__('Bed', 'realar').'</p>';
		                                                echo '<h6 class="meta-content">'.esc_html($data['bed']).'</h6>';
		                                            echo '</span>';
		                                        }
		                                        if(!empty($data['bath'])){
		                                            echo '<span class="meta-wrap">';
		                                                echo '<p class="meta-title">'.esc_html__('Bath', 'realar').'</p>';
		                                                echo '<h6 class="meta-content">'.esc_html($data['bath']).'</h6>';
		                                            echo '</span>';
		                                        }
		                                        if(!empty($data['parking'])){
		                                            echo '<span class="meta-wrap">';
		                                                echo '<p class="meta-title">'.esc_html__('Parking', 'realar').'</p>';
		                                                echo '<h6 class="meta-content">'.esc_html($data['parking']).'</h6>';
		                                            echo '</span>';
		                                        }
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';
	                                echo '<div class="property-card-details">';
	                                	if(!empty($data['location'])){
		                                    echo '<p class="property-card-location location">'.esc_html($data['location']).'</p>';
		                                }
		                                if(!empty($data['title'])){
	                                        echo '<h4 class="box-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
	                                    }
	                                echo '</div>';

	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="slider-area property-slider2 z-index-common">';
                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1500":{"slidesPerView":"3"}},"spaceBetween":"24"}\'>';
                    echo '<div class="swiper-wrapper">';

                        foreach( $settings['service_list2'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="property-card6">';
	                                if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="property-card-thumb img-shine">';
		                                    echo realar_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="property-card-details">';
	                                	if(!empty($data['title'])){
	                                        echo '<h4 class="property-card-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
	                                    }
	                                    if(!empty($data['location'])){
		                                    echo '<p class="property-card-location"><i class="far fa-map-marker-alt me-2"></i>'.esc_html($data['location']).'</p>';
		                                }
		                                if(!empty($data['description'])){
		                                    echo '<p class="property-card-text">'.esc_html($data['description']).'</p>';
		                                }
	                                    echo '<div class="property-card-meta">';
	                                        if(!empty($data['bed'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
			                                }
			                                if(!empty($data['bath'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
			                                }
			                                if(!empty($data['size'])){
			                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
			                                }
	                                    echo '</div>';
	                                    echo '<div class="property-btn-wrap">';
		                                    if(!empty($data['price'])){
		                                        echo '<div class="property-card-price">';
		                                            echo '<a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['price']).'</a>';
		                                        echo '</div>';
		                                    }
	                                        echo '<div class="btn-wrap">';
	                                            echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style-border2 th-btn-icon">'.esc_html($data['button_text']).'</a>';
	                                        echo '</div>';
	                                    echo '</div>';
	                                echo '</div>';

	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}else{
			echo '<div class="slider-area property-slider2 slider-drag-wrap">';
                echo '<div class="swiper th-slider" data-slider-options=\'{"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1500":{"slidesPerView":"4"}},"spaceBetween":"32","grabCursor":"true","slideToClickedSlide":"true"}\'>';
                    echo '<div class="swiper-wrapper">';
                    	foreach( $settings['service_list'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="property-card7">';
	                            	if(!empty($data['thumb_image']['url'])){
		                                echo '<div class="property-card-thumb img-shine">';
		                                    echo realar_img_tag( array(
												'url'   => esc_url( $data['thumb_image']['url'] ),
											));
		                                echo '</div>';
		                            }
	                                echo '<div class="property-card-meta">';
	                                	if(!empty($data['bed'])){
		                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-1.svg" alt="img">'.esc_html($data['bed']).'</span>';
		                                }
		                                if(!empty($data['bath'])){
		                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-2.svg" alt="img">'.esc_html($data['bath']).'</span>';
		                                }
		                                if(!empty($data['size'])){
		                                    echo '<span><img src="'.REALAR_PLUGDIRURI . 'assets/img/property-icon1-3.svg" alt="img">'.esc_html($data['size']).'</span>';
		                                }
	                                echo '</div>';
	                                echo '<div class="property-card-details">';
	                                    echo '<div class="media-left">';
	                                    	if(!empty($data['title'])){
		                                        echo '<h4 class="property-card-title"><a href="'.esc_url( $data['url']['url'] ).'">'.esc_html($data['title']).'</a></h4>';
		                                    }
		                                    if(!empty($data['price'])){
		                                        echo '<h5 class="property-card-price">'.esc_html($data['price']).'</h5>';
		                                    }
		                                    if(!empty($data['location'])){
		                                        echo '<p class="property-card-location">'.esc_html($data['location']).'</p>';
		                                    }
	                                    echo '</div>';
	                                    if(!empty($data['button_text'])){
		                                    echo '<div class="btn-wrap">';
		                                        echo '<a href="'.esc_url( $data['url']['url'] ).'" class="th-btn style-border th-btn-icon">'.esc_html($data['button_text']).'</a>';
		                                    echo '</div>';
		                                }
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
	                    }
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}
	}
}