<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class Realar_Banners extends Widget_Base {

	public function get_name() {
		return 'realarbanners';
	}
	public function get_title() {
		return __( 'Realar Banners', 'realar' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'realar_header_elements' ];
	}



	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'realar' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'realar' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'banner_section',
			[
				'label' 	=> __( 'Banner', 'realar' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		realar_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One', 'Style Two', 'Style Three', 'Style Four', 'Style Five' , 'Style Six', 'Style Seven' , 'Style Eight', 'Style Nine', 'Style Ten' ] );


		$fields_to_include = [ 'image' => ['Background'], 'title' => ['Title', 'Subtitle','Shadow Title'], 'desc' => ['Description'], 'btn' => ['Button Text'], 'url' => ['Button URL','Video URL'] ];
		realar_repeater_fields( $this, 'banners1', 'Banner Info', $fields_to_include, ['1','2'] );



		$fields_to_include3 = [ 'image' => ['Background'], 'title' => ['Title', 'Subtitle'], 'btn' => ['Button Text','Button Text 2','Button Text 3','Button Text 4' ], 'url' => ['Button URL', 'Button URL 2', 'Button URL 3', 'Button URL 4'] ];
		realar_repeater_fields( $this, 'banners3', 'Banner Info', $fields_to_include3, ['5'] );


		$fields_to_include5 = [ 'image' => ['Thumb'], 'title' => ['Title', 'Subtitle'],  'desc' => ['Description'], 'btn' => ['Button Text','Button Text 2'], 'url' => ['Button URL', 'Button URL 2'] ];
		realar_repeater_fields( $this, 'banners5', 'Banner Info', $fields_to_include5, ['7'] );


		$fields_to_include6 = [ 'image' => ['Background'], 'title' => ['Title', 'Subtitle'], 'desc' => ['Description'], 'btn' => ['Button Text'], 'url' => ['Button URL'] ];
		realar_repeater_fields( $this, 'banners6', 'Banner Info', $fields_to_include6, ['9','10'] );




		$fields_to_include2 = [ 'title' => ['Button Text', 'Button url']] ;
		realar_repeater_fields( $this, 'buttons', 'Buttons', $fields_to_include2, ['3'] );


		$fields_to_include4 = [ 'title' => ['Text', 'url']] ;
		realar_repeater_fields( $this, 'socials', 'Social Media', $fields_to_include4, ['5'] );

		realar_media_fields( $this, 'mask', 'Mask Image', ['1'] );
		realar_social_fields($this, 'social_icon_list', 'Social List', ['1'] );	

		realar_media_fields( $this, 'bg', 'Bg Image', ['4','6','8','10'] );
		realar_media_fields( $this, 'bg2', 'Bg Image 2', ['10'] );
		realar_media_fields( $this, 'image', 'Avatar/ Image', ['2','3','4','6','8'] );
		realar_media_fields( $this, 'image2', 'Image 2', ['6'] );
		realar_media_fields( $this, 'shape', 'Shape Image', ['2'] );
		realar_general_fields( $this, 'curve_text', 'Curve Text', 'TEXT', 'Need Help?', ['2','6','7','9','10'] );
		realar_general_fields( $this, 'curve_text2', 'Curve Text 2', 'TEXT', 'Need Help?', ['10'] );
		realar_general_fields( $this, 'heading', 'Heading', 'TEXT', 'Need Help?', ['4','6','8'] );
		realar_general_fields( $this, 'title', 'Tittle', 'TEXT', 'Need Help?', ['3','4','6','8'] );
		realar_general_fields( $this, 'desc', 'Description', 'TEXTAREA2', 'Need Help?', ['6','8'] );
		realar_general_fields( $this, 'title2', 'Tittle 2', 'TEXT', 'Need Help?', ['4'] );
		realar_general_fields( $this, 'video_url', 'Video Url', 'TEXT', '#', ['3','6'] );
		realar_general_fields( $this, 'idss', 'Scroll ID', 'TEXT', 'about-sec', ['1','3','5','9'] );

		realar_general_fields($this, 'button_text', 'Button Text', 'TEXT', 'Button Text', [ '8' ]);
		realar_url_fields($this, 'button_url', 'Button URL', [ '8' ]);


		$this->add_control(
            'realar_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'realar' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
                'condition'	=> ['layout_style' => ['6']]
            ]
        );


		$repeater = new Repeater();

		$fields_to_include4 = [ 'title' => ['Title','Number', 'After Prefix'] ];
		realar_repeater_fields( $this, 'counter_lists', 'Counter List', $fields_to_include4, ['4'] );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------Subtitle Style-------
		realar_common_style_fields($this, 'subtitle', 'Subtitle', '{{WRAPPER}} .title2', ['1','2']);
		realar_common_style_fields($this, 'subtitle2', 'Subtitle', '{{WRAPPER}} .title2', ['3','5','8'],'--white-color');
		//-------Title Style-------
		realar_common_style_fields($this, 'title', 'Title', '{{WRAPPER}} .title1', ['1','2']);
		realar_common_style_fields($this, 'title3', 'Title', '{{WRAPPER}} .title1', ['5'],'--white-color');
		//-------Description Style-------
		realar_common_style_fields($this, 'desc1', 'Description', '{{WRAPPER}} .hero-text', ['1'],'--white-color');
		realar_common_style_fields($this, 'desc2', 'Description', '{{WRAPPER}} .hero-text', ['2','8']);
		//------Button Style-------
		realar_button_style_fields($this, '10', 'Button Styling', '{{WRAPPER}} .btn-mask', ['1']);
		realar_button_style_fields($this, '11', 'Button Styling', '{{WRAPPER}} .th-btn', ['2','7','8']);

		realar_common_style_fields($this, 'counter_number', 'Counter Number', '{{WRAPPER}} .num', ['4']);
		//-------Title Style-------
		realar_common_style_fields($this, 'counter_title', 'Counter Title', '{{WRAPPER}} .desc', ['4']);



		realar_common_style_fields($this, '6_title', 'Title', '{{WRAPPER}} span', ['6','7']);
		realar_common_style_fields($this, '6_subtitle', 'Subtitle', '{{WRAPPER}} h1', ['6'],'--theme-color');
		realar_common_style_fields($this, '6_desc', 'Description', '{{WRAPPER}} p', ['6','7']);


    }

	protected function render() {

    $settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

			echo '<div class="hero-1" id="hero">';
		        echo '<div class="swiper th-slider hero-slider1" id="heroSlide1" data-slider-options=\'{"effect":"fade", "autoHeight":"true"}\'>';
		            echo '<div class="swiper-wrapper">';
		            	foreach( $settings['banners1'] as  $data ){
			                echo '<div class="swiper-slide">';
			                
			                	$mask_image = $settings['mask']['url'] ?  $settings['mask']['url'] : ''.REALAR_PLUGDIRURI . 'assets/img/hero_1_bg_mask.png';

			                    echo '<div class="hero-inner" data-mask-src="'.REALAR_PLUGDIRURI . 'assets/img/hero_1_bg_mask.png">';
			                    	if(!empty( $data['background']['url'] )){
				                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['background']['url']  ).'"></div>';
				                    }
				                    if(!empty($data['shadow_title'])){
				                        echo '<div class="hero-big-text">'.esc_html($data['shadow_title']).'</div>';
				                    }
			                        echo '<div class="container">';
			                            echo '<div class="row align-items-center">';
			                                echo '<div class="col-lg-6">';
			                                    echo '<div class="hero-style1">';
			                                        echo '<h1 class="hero-title text-white">';
			                                        	if(!empty($data['title'])){
				                                            echo '<span class="title1" data-ani="slideindown" data-ani-delay="0.3s">'.esc_html($data['title']).'</span>';
				                                        }
			                                            if(!empty($data['subtitle'])){    
				                                            echo '<span class="title2" data-ani="slideindown" data-ani-delay="0.4s">'.esc_html($data['subtitle']).'</span>';
				                                        }
		
			                                        echo '</h1>';
			                                        if(!empty($data['description'])){  
				                                        echo '<p class="hero-text text-white" data-ani="slideinup" data-ani-delay="0.5s">'.esc_html($data['description']).'</p>';
				                                    }
				                                    if(!empty($data['button_text'])){  
				                                        echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn btn-mask th-btn-icon" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['button_text']).'</a>';
				                                    }
			                                    echo '</div>';
			                                echo '</div>';
			                                if(!empty($data['video_url']['url'])){  
				                                echo '<div class="col-lg-6">';
				                                    echo '<div class="hero-video-wrap text-center" data-ani="slideinright" data-ani-delay="0.4s">';
				                                        echo '<a href="'.esc_url( $data['video_url']['url'] ).'" class="play-btn style2 popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
				                                    echo '</div>';
				                                echo '</div>';
				                            }
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		           	echo ' </div>';
		            echo '<div class="slider-pagination"></div>';
		        echo '</div>';
		        echo '<div class="hero-social-link">';
		            echo '<div class="social-wrap">';

		            	foreach( $settings['social_icon_list'] as $social_icon ){
							$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
							$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';

							echo '<a '.wp_kses_post( $social_target.$social_nofollow ).' href="'.esc_url( $social_icon['icon_link']['url'] ).'">';

							echo esc_html( $social_icon['name'] );

							echo '</a> ';
						}
		            echo '</div>';
		        echo '</div>';
		        if( !empty( $settings['idss'] ) ){
			        echo '<div class="scroll-down">';
			            echo '<a href="'.esc_attr( $settings['idss'] ).'" class="hero-scroll-wrap"><i class="fal fa-long-arrow-left"></i>Scroll</a>';
			        echo '</div>';
			    }
		    echo '</div>';
		}elseif( $settings['layout_style'] == '2' ){

			echo '<div class="th-hero-wrapper hero-2" id="hero">';
		        echo '<div class="container">';
		            echo '<div class="swiper th-slider hero-slider1" id="heroSlide1" data-slider-options=\'{"effect":"fade","loop":false,"thumbs":{"swiper":".hero-grid-thumb"}}\'>';
		                echo '<div class="swiper-wrapper">';

		                	foreach( $settings['banners1'] as  $data ){
			                    echo '<div class="swiper-slide">';
			                        echo '<div class="hero-inner">';
			                            echo '<div class="row gx-60 gy-50">';
			                                echo '<div class="col-xl-5">';
			                                	if(!empty(  $data['background']['url'] )){
				                                    echo '<div class="hero-thumb2-1">';
				                                        echo '<img src="'.esc_url( $data['background']['url']  ).'" alt="img">';
				                                    echo '</div>';
				                                }
			                                echo '</div>';
			                                echo '<div class="col-xl-7">';
			                                    echo '<div class="hero-style2">';
			                                        echo '<h1 class="hero-title">';
			                                        	if(!empty($data['title'])){
				                                            echo '<span class="title1" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['title']).'</span>';
				                                        }
			                                            if(!empty($data['subtitle'])){    
				                                            echo '<span class="title2" data-ani="slideinup" data-ani-delay="0.5s">'.esc_html($data['subtitle']).'</span>';
				                                        }
			                                        echo '</h1>';
			                                        if(!empty($data['description'])){  
				                                        echo '<p class="hero-text" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['description']).'</p>';
				                                    }
				                                    if(!empty($data['button_text'])){  
				                                        echo '<div class="btn-wrap" data-ani="slideinup" data-ani-delay="0.7s">';
				                                            echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 th-btn-icon">'.esc_html($data['button_text']).'</a>';

				                                        echo '</div>';
				                                    }
			                                    echo '</div>';
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';

		            echo '<div class="row gx-60 justify-content-end">';
		                echo '<div class="col-xl-7">';
		                    echo '<div class="slider-area hero-slider-thumb-wrap">';
		                        echo '<div class="swiper th-slider hero-grid-thumb" data-slider-options=\'{"effect":"slide","loop":false,"slidesPerView":"3"}\'>';
		                            echo '<div class="swiper-wrapper">';
		                            	$i = 0;
		                            	foreach( $settings['banners1'] as  $data ){
		                            		$i++;
		                            		$k = str_pad($i, 2, '0', STR_PAD_LEFT);

			                                echo '<div class="swiper-slide">';
			                                    echo '<div class="box-img">';
			                                        echo '<img src="'. esc_url( $data['background']['url']  ).'" alt="Image">';
			                                        echo '<span class="slider-number">'.esc_html( $k ).'</span>';
			                                    echo '</div>';
			                                echo '</div>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<button data-slider-prev="#heroSlide1" class="slider-arrow style2"><img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-left.svg" alt="img"></button>';
		                        echo '<button data-slider-next="#heroSlide1" class="slider-arrow style2 slider-next"><img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-right.svg" alt="img"></button>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="about-tag">';
		        	if(!empty($settings['curve_text'])){  
			            echo '<div class="about-experience-tag">';
			                echo '<span class="circle-title-anime">'.esc_html( $settings['curve_text'] ).'</span>';
			            echo '</div>';
			        }
			        if(!empty(  $settings['image']['url'] )){
			            echo '<div class="about-tag-thumb">';
			                echo '<img src="'. esc_url( $settings['image']['url']  ).'" alt="img">';
			            echo '</div>';
			        }
		        echo '</div>';
		        if(!empty(  $settings['shape']['url'] )){
			        echo '<div class="hero-bg-shape2-1 spin shape-mockup" data-top="14%" data-left="1%">';
			            echo '<img src="'. esc_url( $settings['shape']['url']  ).'" alt="img">';
			        echo '</div>';
			    }
		    echo '</div>';
		}elseif( $settings['layout_style'] == '3' ){

			$bg = $settings['image']['url'] ?  $settings['image']['url'] : '#';
			$video_url = $settings['video_url'] ?  $settings['video_url'] : '#';

			echo '<div class="th-hero-wrapper hero-3" id="hero" data-bg-src="'.esc_url( $bg ).'">';
		        echo '<video class="hero-video" id="video" src="'.esc_url( $video_url ).'" loop="" muted="" autoplay=""></video>';
		        echo '<div class="container">';
		            echo '<div class="row gy-5 justify-content-center">';
		                echo '<div class="col-12">';
		                    echo '<div class="hero-style3 text-center">';
		                        echo '<div class="btn-wrap justify-content-center">';
		                        	foreach( $settings['buttons'] as  $data ){
			                            echo '<a href="'.esc_url($data['button_url']).'" class="th-btn style-border th-btn-icon">'.esc_html($data['button_text']).'</a>';
			                        }
		                            
		                        echo '</div>';
		                        if(!empty($settings['title'])){
			                        echo '<h1 class="hero-title text-white title2">'.esc_html($settings['title']).'</h1>';
			                    }
		                        echo '<div class="property-search-form-custom">';
		                            
		                        	echo do_shortcode( '[directorist_search_listing]' );
		                        echo '</div>';
		                        if( !empty( $settings['idss'] ) ){
			                        echo '<div class="scroll-down">';
			                            echo '<a href="'.esc_attr( $settings['idss'] ).'" class="hero-scroll-wrap"></a>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '4' ){
			$bg_image = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';
			echo '<div class="th-hero-wrapper hero-4" id="hero" data-bg-src="'.esc_url( $bg_image ).'">';
		        echo '<div class="container">';
		            echo '<div class="hero-style4">';
		            	if(!empty($settings['heading'])){
			                echo '<span class="sub-title">'.esc_html($settings['heading']).'</span>';
			            }
			            if(!empty($settings['title'])){
			                echo '<h1 class="hero-title text-theme">'.esc_html($settings['title']).'</h1>';
			            }
			            if(!empty($settings['title2'])){
			                echo '<h1 class="hero-title text-theme">'.esc_html($settings['title2']).'</h1>';
			            }
		                echo '<div class="search-form2">';
			            echo do_shortcode( '[directorist_search_listing]' );
			            echo '</div>';

		                echo '<div class="counter-card-wrap">';
		                    foreach( $settings['counter_lists'] as $data ){
			                    echo '<div class="counter-card">';
			                        echo '<div class="media-body">';
			                        	if(!empty($data['number'])){
					                        echo '<h2 class="box-number"><span class="counter-number num">'.esc_html( $data['number'] ).'</span>'.esc_html( $data['after_prefix'] ).'</h2>';
					                    }
			                            if(!empty($data['title'])){
					                        echo '<p class="box-text desc">'.esc_html( $data['title'] ).'</p>';
					                    }
			                        echo '</div>';
			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        if(!empty(  $settings['image']['url'] )){
			        echo '<div class="hero-thumb4-1" data-overlay="black" data-opacity="2">';
			            echo '<img src="'. esc_url( $settings['image']['url']  ).'" alt="img">';
			        echo '</div>';
			    }
		    echo '</div>';
		}elseif( $settings['layout_style'] == '5' ){
			echo '<div class="hero-5" id="hero">';
		        echo '<div class="swiper th-slider hero-slider5" id="heroSlide5" data-slider-options=\'{"effect":"fade", "autoHeight": "true"}\'>';
		            echo '<div class="swiper-wrapper">';
		            	foreach( $settings['banners3'] as $data ){
			                echo '<div class="swiper-slide">';
			                    echo '<div class="hero-inner">';
			                    	if(!empty( $data['background']['url'] )){
				                        echo '<div class="th-hero-bg" data-bg-src="'.esc_url( $data['background']['url']  ).'"></div>';
				                    }
			                        echo '<div class="container">';
			                            echo '<div class="row align-items-center justify-content-center">';
			                                echo '<div class="col-lg-10">';
			                                    echo '<div class="hero-style5 text-center">';
			                                        echo '<div class="btn-wrap justify-content-center" data-ani="slideindown" data-ani-delay="0.3s">';
			                                        	if(!empty($data['button_text'])){  
					                                        echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-border th-btn-icon">'.esc_html($data['button_text']).'</a>';
					                                    }
					                                    if(!empty($data['button_text_2'])){  
					                                        echo '<a href="'.esc_url( $data['button_url_2']['url'] ).'" class="th-btn style-border th-btn-icon">'.esc_html($data['button_text_2']).'</a>';
					                                    }
					                                    if(!empty($data['button_text_3'])){  
					                                        echo '<a href="'.esc_url( $data['button_url_3']['url'] ).'" class="th-btn style-border th-btn-icon">'.esc_html($data['button_text_3']).'</a>';
					                                    }
			                                        echo '</div>';
			                                        echo '<h1 class="hero-title text-white">';
			                                        	if(!empty($data['title'])){
				                                            echo '<span class="title1" data-ani="slideindown" data-ani-delay="0.3s">'.esc_html($data['title']).'</span>';
				                                        }
				                                        if(!empty($data['subtitle'])){
				                                            echo '<span class="title2" data-ani="slideindown" data-ani-delay="0.4s">'.esc_html($data['subtitle']).'</span>';
				                                        }
			                                        echo '</h1>';
			                                        if(!empty($data['button_text_4'])){  
				                                        echo '<a href="'.esc_url( $data['button_url_4']['url'] ).'" class="th-btn style4 th-btn-icon" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['button_text_4']).'</a>';
				                                    }
			                                    echo '</div>';
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';

			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		            echo '<div class="slider-pagination style4"></div>';
		        echo '</div>';
		        echo '<div class="hero-social-link">';
		            echo '<div class="social-wrap">';
		            	foreach( $settings['socials'] as $data ){
			                echo '<a href="'.esc_url( $data['url'] ).'">'.esc_html( $data['text'] ).'</a>';
			            }
		                
		            echo '</div>';
		        echo '</div>';
		        if( !empty( $settings['idss'] ) ){
			        echo '<div class="scroll-down">';
			            echo '<a href="'.esc_attr( $settings['idss'] ).'" class="hero-scroll-wrap"></a>';
			        echo '</div>';
			    }
		    echo '</div>';
		}elseif( $settings['layout_style'] == '6' ){
			echo '<div class="th-hero-wrapper hero-6" id="hero">';
		        echo '<div class="container">';
		            echo '<div class="row flex-row-reverse">';
		                echo '<div class="col-xxl-6 col-xl-5 align-self-center">';
		                    echo '<div class="hero-thumb6-1">';
		                    	if(!empty(  $settings['image']['url'] )){
			                        echo '<div class="img1">';
			                            echo '<img src="'. esc_url( $settings['image']['url']  ).'" alt="img">';
			                        echo '</div>';
			                    }
			                    if(!empty(  $settings['image2']['url'] )){
			                        echo '<div class="img2">';
			                            echo '<img src="'. esc_url( $settings['image2']['url']  ).'" alt="img">';
			                        echo '</div>';
			                    }
			                    if(!empty($settings['curve_text'])){  
			                        echo '<div class="about-tag">';
			                            echo '<div class="about-experience-tag">';
			                                echo '<span class="circle-title-anime">'.esc_html( $settings['curve_text'] ).'</span>';
			                            echo '</div>';
			                            echo '<div class="about-tag-icon">';
			                                echo '<img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-long-top2.svg" alt="img">';
			                            echo '</div>';
			                        echo '</div>';
			                    }
		                    echo '</div>';
		                echo '</div>';
		                echo '<div class="col-xxl-6 col-xl-7">';
		                    echo '<div class="hero-style6">';
		                    	if(!empty($settings['heading'])){
			                        echo '<span class="sub-title2">'.esc_html($settings['heading']).'</span>';
			                    }
			                    if(!empty($settings['title'])){
			                        echo '<h1 class="hero-title text-theme">'.esc_html($settings['title']).'</h1>';
			                    }
			                    if(!empty($settings['desc'])){
			                        echo '<p class="hero-text">'.esc_html($settings['desc']).'</p>';
			                    }

		                    echo '</div>';
		                echo '</div>';

		            echo '</div>';
		            echo '<div class="hero-form-wrap">';
		                
		            	if( !empty($settings['realar_select_contact_form']) ){
			                echo do_shortcode( '[contact-form-7  id="'.$settings['realar_select_contact_form'].'"]' ); 
			            }else{
			                echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'realar' ). '</p></div>';
			            }

		            	if(!empty(  $settings['bg']['url'] )){
			                echo '<div class="hero-thumb6-2">';
			                    echo '<img src="'. esc_url( $settings['bg']['url']  ).'" alt="img">';
			                    if(!empty($settings['video_url'])){  
				                    echo '<a href="'.esc_url( $settings['video_url'] ).'" class="play-btn style6 popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>';
				                }
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '7' ){
			echo '<div class="th-hero-wrapper hero-8" id="hero">';
		        echo '<div class="container">';
		            echo '<div class="swiper th-slider hero-slider8" id="heroSlide8" data-slider-options=\'{"effect":"fade","loop":false,"autoHeight": true,"thumbs":{"swiper":".hero-grid-thumb"}}\'>';
		                echo '<div class="swiper-wrapper">';

		                	foreach( $settings['banners5'] as $data ){
			                    echo '<div class="swiper-slide">';
			                        echo '<div class="hero-inner">';
			                            echo '<div class="row gy-50 align-items-center">';
			                                echo '<div class="col-xl-6">';
			                                    echo '<div class="hero-style8">';
			                                    	if(!empty($data['subtitle'])){
				                                        echo '<span class="sub-title3 before-none" data-ani="slideinup" data-ani-delay="0.3s">'.esc_html($data['subtitle']).'</span>';
				                                    }
			                                        if(!empty($data['title'])){
				                                        echo '<h1 class="hero-title text-theme">';
				                                            echo '<span class="title1" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['title']).'</span>';
				                                        echo '</h1>';
				                                    }
				                                    if(!empty($data['description'])){
				                                        echo '<p class="hero-text text-theme" data-ani="slideinup" data-ani-delay="0.6s">'.esc_html($data['description']).'</p>';
				                                    }
			                                        echo '<div class="btn-wrap" data-ani="slideinup" data-ani-delay="0.7s">';
			                                        	if(!empty($data['button_text'])){  
					                                        echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style2 th-btn-icon">'.esc_html($data['button_text']).'</a>';
					                                    }
					                                    if(!empty($data['button_text_2'])){  
					                                        echo '<a href="'.esc_url( $data['button_url_2']['url'] ).'" class="th-btn style-border4 th-btn-icon">'.esc_html($data['button_text_2']).'</a>';
					                                    }
			                                        echo '</div>';
			                                    echo '</div>';
			                                echo '</div>';
			                                echo '<div class="col-xl-6">';
			                                	if(!empty( $data['thumb']['url'] )){
				                                    echo '<div class="hero-thumb8-1">';
				                                        echo '<div class="thumb" data-mask-src="'.REALAR_PLUGDIRURI . 'assets/img/hero_thumb_8_1_mask.png">';
				                                            echo '<img src="'.esc_url( $data['thumb']['url']  ).'" alt="img">';
				                                        echo '</div>';
				                                        echo '<div class="about-tag">';
				                                        	if(!empty($settings['curve_text'])){  
					                                            echo '<div class="about-experience-tag">';
					                                                echo '<span class="circle-title-anime">'.esc_html($settings['curve_text']).'</span>';
					                                            echo '</div>';
					                                        }
				                                            echo '<div class="about-tag-thumb">';
				                                                echo '<img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-long-top2.svg" alt="img">';
				                                            echo '</div>';
				                                        echo '</div>';
				                                    echo '</div>';
				                                }
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';

			                    echo '</div>';
			                }
		                echo '</div>';
		            echo '</div>';

		            echo '<div class="row gx-60 justify-content-end">';
		                echo '<div class="col-xl-6">';
		                    echo '<div class="slider-area hero-slider-thumb-wrap">';
		                        echo '<div class="swiper th-slider hero-grid-thumb" data-slider-options=\'{"effect":"slide","loop":false,"slidesPerView":"3"}\'>';
		                            echo '<div class="swiper-wrapper">';

		                            	$i = 0;
		                            	foreach( $settings['banners5'] as $data ){
		                            		$i++;
		                            		$k = str_pad($i, 2, '0', STR_PAD_LEFT);

			                                echo '<div class="swiper-slide">';
			                                    echo '<div class="box-img">';
			                                        echo '<img src="'.esc_url( $data['thumb']['url']  ).'" alt="Image">';
			                                        echo '<span class="slider-number">'.esc_html( $k ).'</span>';
			                                    echo '</div>';
			                                echo '</div>';
			                            }
		                                
		                            echo '</div>';
		                        echo '</div>';
		                        echo '<button data-slider-prev="#heroSlide8" class="slider-arrow style3"><img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-left.svg" alt="img"></button>';
		                        echo '<button data-slider-next="#heroSlide8" class="slider-arrow style3 slider-next"><img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-right.svg" alt="img"></button>';
		                    echo '</div>';
		                echo '</div>';
		            echo '</div>';

		            echo do_shortcode( '[directorist_search_listing]' );
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '8' ){
			$bg = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';
			echo '<div class="th-hero-wrapper hero-9" id="hero" data-bg-src="'.esc_url( $bg ).'" data-overlay="theme" data-opacity="8">';
		        echo '<div class="container">';
		            echo '<div class="row gx-80 flex-row-reverse align-items-center">';
		            	if(!empty(  $settings['image']['url'] )){
			                echo '<div class="col-xl-5">';
			                    echo '<div class="hero-thumb9-1">';
			                        echo '<div class="img1">';
			                            echo '<img src="'. esc_url( $settings['image']['url']  ).'" alt="img">';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		                echo '<div class="col-xl-7">';
		                    echo '<div class="hero-style9">';
		                    	if(!empty($settings['heading'])){
			                        echo '<span class="sub-title4">'.esc_html($settings['heading']).'</span>';
			                    }
			                    if(!empty($settings['title'])){
			                        echo '<h1 class="hero-title title2 text-white">'.esc_html($settings['title']).'</h1>';
			                    }
			                    if(!empty($settings['desc'])){
			                        echo '<p class="hero-text">'.esc_html($settings['desc']).'</p>';
			                    }
			                    if( ! empty( $settings['button_text'] ) ) {
			                        echo '<div class="btn-wrap">';
			                            echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn style-border th-btn-icon">'.esc_html( $settings['button_text'] ).'</a>';
			                        echo '</div>';
			                    }
		                        
		                        echo do_shortcode( '[directorist_search_listing]' );
		                        
		                    echo '</div>';
		                echo '</div>';

		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif( $settings['layout_style'] == '9' ){
			echo '<div class="th-hero-wrapper hero-10" id="hero">';
		        echo '<div class="swiper th-slider hero-slider10" id="heroSlide10" data-slider-options=\'{"effect":"fade","loop":false,"autoHeight": true,"thumbs":{"swiper":".hero-thumb-content"}}\'>';
		            echo '<div class="swiper-wrapper">';
		            	foreach( $settings['banners6'] as $data ){

		            		$bg = $data['background']['url'] ?  $data['background']['url'] : '#';
		            		
			                echo '<div class="swiper-slide" data-bg-src="'.esc_url( $bg ).'">';
			                    echo '<div class="container">';
			                        echo '<div class="hero-inner">';
			                            echo '<div class="row">';
			                                echo '<div class="col-xl-7">';
			                                    echo '<div class="hero-style10">';
			                                    	if(!empty($data['subtitle'])){
				                                        echo '<h1 class="hero-title text-white">';
				                                            echo '<span class="title1" data-ani="slideinup" data-ani-delay="0.4s">'.esc_html($data['subtitle']).'</span>';
				                                        echo '</h1>';
				                                    }
				                                    if(!empty($data['button_text'])){  
				                                        echo '<div class="btn-wrap" data-ani="slideinup" data-ani-delay="0.7s">';
				                                            echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-border th-btn-icon">'.esc_html($data['button_text']).'</a>';
				                                        echo '</div>';
				                                    }
			                                    echo '</div>';
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                echo '</div>';
			            }
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="hero-bottom-wrap">';
		            echo '<div class="container">';
		                echo '<div class="row align-items-center gy-30">';
		                    echo '<div class="col-xl-5">';
		                        echo '<div class="slider-area hero-slider-thumb-wrap">';
		                            echo '<div class="swiper th-slider hero-grid-thumb" data-slider-options=\'{"effect":"slide","loop":true,"slidesPerView":"3", "spaceBetween":"16px","centeredSlides": true,"thumbs":{"swiper":".hero-slider10"}}\'>';
		                                echo '<div class="swiper-wrapper">';
		                                	foreach( $settings['banners6'] as $data ){
			                                    echo '<div class="swiper-slide">';
			                                        echo '<div class="box-img">';
			                                        	if(!empty($data['title'])){
				                                            echo '<span class="thumb-slider-title">'.esc_html($data['title']).'</span>';
				                                        }
				                                        if(!empty(  $data['background']['url'] )){
				                                            echo '<img src="'.esc_url( $data['background']['url'] ).'" alt="Image">';
				                                        }
			                                        echo '</div>';
			                                    echo '</div>';
			                                }
		                                echo '</div>';
		                            echo '</div>';
		                            echo '<button data-slider-prev=".hero-grid-thumb" class="slider-arrow style3"><img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-left.svg" alt="img"></button>';
		                            echo '<button data-slider-next=".hero-grid-thumb" class="slider-arrow style3 slider-next"><img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-right.svg" alt="img"></button>';
		                        echo '</div>';
		                    echo '</div>';
		                   echo ' <div class="col-xl-7">';
		                        echo '<div class="slider-area hero-slider-content-wrap">';
		                            echo '<div class="swiper th-slider hero-thumb-content" data-slider-options=\'{"effect":"slide","loop":false,"slidesPerView":"1","autoHeight": true}\'>';
		                                echo '<div class="swiper-wrapper">';
		                                    foreach( $settings['banners6'] as $data ){
			                                    echo '<div class="swiper-slide">';
			                                        echo '<div class="hero-slider-content">';

			                                            if(!empty($data['description'])){
					                                        echo '<p>'.esc_html($data['description']).'</p>';
					                                    }
			                                        echo '</div>';
			                                    echo '</div>';
			                                }
		                                echo '</div>';
		                            echo '</div>';
		                            echo '<div class="about-tag">';
		                            	if(!empty( $settings['curve_text'] )){
			                                echo '<div class="about-experience-tag">';
			                                    echo '<span class="circle-title-anime">'.esc_html( $settings['curve_text'] ).'</span>';
			                                echo '</div>';
			                            }
			                            if( !empty( $settings['idss'] ) ){
			                                echo '<div class="about-tag-thumb scroll-down">';
			                                    echo '<a href="'.esc_attr( $settings['idss'] ).'" class="hero-scroll-wrap"></a>';
			                                echo '</div>';
			                            }
		                            echo '</div>';
		                        echo '</div>';
		                   echo ' </div>';
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}else{
			echo '<div class="th-hero-wrapper hero-11" id="hero">';
		        echo '<div class="slider-area">';
		            echo '<div class="swiper th-slider hero-slider11" id="heroSlide11" data-slider-options=\'{"effect":"fade","loop":true,"autoHeight": true}\'>';
		                echo '<div class="swiper-wrapper">';
		                	$shape = $settings['bg']['url'] ?  $settings['bg']['url'] : '#';
		                	$shape2 = $settings['bg2']['url'] ?  $settings['bg2']['url'] : '#';
		                	foreach( $settings['banners6'] as $data ){

			            		


			                    echo '<div class="swiper-slide">';
			                        echo '<div class="container">';
			                            echo '<div class="hero-inner" data-bg-src="'.esc_url( $shape ).'">';
			                                echo '<div class="row justify-content-center">';
			                                    echo '<div class="col-xl-8">';
			                                        echo '<div class="hero-style11 text-center">';
			                                            echo '<div class="hero-border" data-bg-src="'.esc_url( $shape2 ).'"></div>';
			                                            echo '<h1 class="hero-title">';
			                                            	if(!empty($data['title'])){
				                                                echo '<span class="title">'.esc_html($data['title']).'</span>';
				                                            }
				                                            if(!empty($data['subtitle'])){
				                                                echo '<span class="title">'.esc_html($data['subtitle']).'</span>';
				                                            }
			                                            echo '</h1>';
			                                            if(!empty($data['button_text'])){ 
				                                            echo '<div class="btn-wrap justify-content-center">';
				                                                echo '<a href="'.esc_url( $data['button_url']['url'] ).'" class="th-btn style-border5 th-btn-icon">'.esc_html($data['button_text']).'</a>';
				                                            echo '</div>';
				                                        }
			                                        echo '</div>';
			                                    echo '</div>';
			                                echo '</div>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</div>';
			                }
		                    


		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		        echo '<div class="hero-bottom-wrap">';
		            echo '<div class="container-fluid p-0">';
		                echo '<div class="slider-area hero-slider-thumb-wrap">';
		                    echo '<div class="swiper th-slider hero-grid-thumb" data-slider-options=\'{"effect":"slide","loop":true,"slidesPerView":"1.8", "spaceBetween":"24px","centeredSlides": true,"thumbs":{"swiper":".hero-slider11"},"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1.8"}}}\'>';
		                        echo '<div class="swiper-wrapper">';

		                            foreach( $settings['banners6'] as $data ){

				            			$bg = $data['background']['url'] ?  $data['background']['url'] : '#';
			                            echo '<div class="swiper-slide">';
			                                echo '<div class="box-img">';
			                                    echo '<img src="'.esc_url( $bg ).'" alt="Image">';
			                                echo '</div>';
			                            echo '</div>';
			                        }
		                            

		                        echo '</div>';
		                    echo '</div>';
		                    if(!empty( $settings['curve_text'] )){
			                    echo '<button data-slider-prev=".hero-grid-thumb" class="slider-arrow slider-prev">';
			                       echo ' <img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-left.svg" alt="img">';
			                        echo '<div class="circle-tag">';
			                            echo '<div class="about-experience-tag">';
			                                echo '<span class="circle-title-anime">'.esc_html( $settings['curve_text'] ).'</span>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</button>';
			                }
			                if(!empty( $settings['curve_text2'] )){
			                    echo '<button data-slider-next=".hero-grid-thumb" class="slider-arrow slider-next">';
			                        echo '<img src="'.REALAR_PLUGDIRURI . 'assets/img/arrow-right.svg" alt="img">';
			                        echo '<div class="circle-tag">';
			                            echo '<div class="about-experience-tag">';
			                                echo '<span class="circle-title-anime">'.esc_html( $settings['curve_text2'] ).'</span>';
			                            echo '</div>';
			                        echo '</div>';
			                    echo '</button>';
			                }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	}
}