<?php

/**
 * Plugin Name: Duplicator Pro
 * Plugin URI: https://duplicator.com/
 * Description: Create, schedule and transfer a copy of your WordPress files and database. Duplicate and move a site from one location to another quickly.
 * Version: 4.5.23.1
 * Requires at least: 5.3
 * Tested up to: 6.8
 * Requires PHP: 7.4
 * Author: Duplicator
 * Author URI: https://duplicator.com/
 * Network: true
 * Update URI: https://duplicator.com/
 * Text Domain: duplicator-pro
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 *
 * Copyright 2011-2022  Snapcreek LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

defined('ABSPATH') || exit;

// CHECK PHP VERSION
define('DUPLICATOR_PRO_PHP_MINIMUM_VERSION', '7.4');
define('DUPLICATOR_PRO_PHP_SUGGESTED_VERSION', '8.3');
require_once dirname(__FILE__) . "/src/Utils/DuplicatorPhpVersionCheck.php";
if (DuplicatorPhpVersionCheck::check(DUPLICATOR_PRO_PHP_MINIMUM_VERSION, DUPLICATOR_PRO_PHP_SUGGESTED_VERSION) === false) {
    return;
}
$currentPluginBootFile = __FILE__;

update_option('duplicator_pro_license_key', 'e15c59b3922bdb33ca612476e4613157');
add_filter('pre_http_request', function ($pre, $parsed_args, $url) {
	if (strpos($url, 'https://duplicator.com') === 0 && isset($parsed_args['body']['edd_action'])) {
		$action = $parsed_args['body']['edd_action'];
		
		$responseData = [
			'success' => true,
			'license' => 'valid',
			'expires' => 'lifetime',
			'license_limit' => 99,
			'site_count' => 1,
			'activations_left' => 'unlimited',
			'customer_name' => 'Licensed User',
			'customer_email' => 'user@example.com',
			'checksum' => 'e15c59b3922bdb33ca612476e4613157',
			'item_id' => 999,
			'item_name' => 'Duplicator Pro',
			'price_id' => 11,
			'payment_id' => 12345,
			'license_key' => 'e15c59b3922bdb33ca612476e4613157',
			'activeSubscription' => true,
			'license_type' => 11,
			'capabilities' => [1000, 1001, 1002, 1003, 1004, 1005, 1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015],
		];
		
		// Customize response based on action
		switch ($action) {
			case 'check_license':
				$responseData['license'] = 'valid';
				break;
			case 'activate_license':
				$responseData['license'] = 'valid';
				$responseData['success'] = true;
				break;
			case 'deactivate_license':
				$responseData['license'] = 'deactivated';
				$responseData['success'] = true;
				break;
		}
		
		return [
			'response' => ['code' => 200, 'message' => 'OK'],
			'body' => json_encode($responseData),
			'headers' => ['content-type' => 'application/json']
		];
	}
	return $pre;
}, 50, 3);

require_once dirname(__FILE__) . '/duplicator-pro-main.php';


