/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-23 12:27:35 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wplp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=33192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=57134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=84962 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_loginizer_logs` (
  `username` varchar(255) NOT NULL DEFAULT '',
  `time` int(10) NOT NULL DEFAULT 0,
  `count` int(10) NOT NULL DEFAULT 0,
  `lockout` int(10) NOT NULL DEFAULT 0,
  `ip` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=67442 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7052 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=4930 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=147 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfauditevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint(20) unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM AUTO_INCREMENT=115 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=MyISAM AUTO_INCREMENT=311 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=1477 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15750 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=MyISAM AUTO_INCREMENT=123 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfsecurityevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=194 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=12972 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE IF NOT EXISTS `wplp_wfwaffailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wplp_users` VALUES 
("1","admin","$wp$2y$10$4oibz/tNdQpyyTIwLJlQCeykJwQVG02hHQzG/Py5joR.hh.qteez2","admin","admin@test.ibrayadevelopers.com","https://ibrayadevelopers.com","2025-04-19 06:50:40","","0","admin");

INSERT IGNORE INTO `wplp_usermeta` VALUES 
("1","1","nickname","admin"),
("2","1","first_name","salman"),
("3","1","last_name","khalid"),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wplp_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","wplp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:1:{s:64:\"aeff385ae6c92aac290f3168c4f5429d42481caf14fe39fdd3fd6f46b7888e0b\";a:4:{s:10:\"expiration\";i:1766663420;s:2:\"ip\";s:13:\"139.135.59.84\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1766490620;}}"),
("17","1","elementor_introduction","a:2:{s:27:\"ai-get-started-announcement\";b:1;s:20:\"globals_introduction\";b:1;}"),
("18","1","wplp_user-settings","libraryContent=browse&editor=tinymce"),
("19","1","wplp_user-settings-time","1760696041"),
("20","1","wplp_elementor_connect_common_data","a:3:{s:9:\"client_id\";s:32:\"7mT0gvvikgCaQw9RclDGlQ5abCEpC5u2\";s:11:\"auth_secret\";s:32:\"7pN9DWZBPn89yuoTfEEngayQ3CS4G6c7\";s:5:\"state\";s:12:\"tsP4xYPZJs2I\";}"),
("21","1","wplp_elementor_enable_ai","1"),
("22","1","wplp_elementor_pro_enable_notes_notifications","1"),
("23","1","_new_email","a:2:{s:4:\"hash\";s:32:\"b5bf16e3f2e9e6cca9b5d5017cb303c8\";s:8:\"newemail\";s:25:\"Salmankhalid055@gmail.com\";}"),
("24","1","wplp_dashboard_quick_press_last_post_id","4929"),
("25","1","community-events-location","a:1:{s:2:\"ip\";s:12:\"139.135.59.0\";}"),
("26","1","elementor_admin_notices","a:1:{s:20:\"experiment_promotion\";a:2:{s:9:\"is_viewed\";b:1;s:4:\"meta\";a:0:{}}}"),
("27","1","image_optimizer_dismissed_pointers","a:3:{s:24:\"image-optimizer-settings\";b:1;s:29:\"image-optimizer-not-connected\";b:1;s:25:\"image-optimizer-list-view\";b:1;}"),
("28","1","wplp_persisted_preferences","a:3:{s:4:\"core\";a:1:{s:26:\"isComplementaryAreaVisible\";b:1;}s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2025-04-29T11:42:16.773Z\";}"),
("29","1","wfls-last-login","1766490621");

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("4878","action_scheduler/migration_hook","failed","2025-04-25 13:38:59","2025-04-25 13:38:59","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745588339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745588339;}","3","1","2025-04-25 13:39:00","2025-04-25 13:39:00","0",NULL),
("4910","image-optimization/cleanup/stuck-operation","failed","2025-04-26 06:06:53","2025-04-26 06:06:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745647613;s:18:\"\0*\0first_timestamp\";i:1745588214;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745647613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-04-26 06:10:35","2025-04-26 06:10:35","101",NULL),
("12353","image-optimization/cleanup/stuck-operation","failed","2025-07-28 08:57:23","2025-07-28 08:57:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1753693043;s:18:\"\0*\0first_timestamp\";i:1746119974;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1753693043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-07-28 09:01:17","2025-07-28 09:01:17","10398",NULL),
("17919","image-optimization/cleanup/stuck-operation","failed","2025-10-08 10:04:46","2025-10-08 10:04:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759917886;s:18:\"\0*\0first_timestamp\";i:1745648161;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759917886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-10-08 10:05:25","2025-10-08 10:05:25","15533",NULL),
("20573","image-optimization/cleanup/stuck-operation","failed","2025-10-21 11:44:53","2025-10-21 11:44:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761047093;s:18:\"\0*\0first_timestamp\";i:1755635570;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761047093;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-10-21 11:45:39","2025-10-21 11:45:39","26342",NULL),
("20952","image-optimization/cleanup/stuck-operation","failed","2025-10-23 02:33:16","2025-10-23 02:33:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1761186796;s:18:\"\0*\0first_timestamp\";i:1761047494;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1761186796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-10-23 02:33:16","2025-10-23 02:33:16","28141",NULL),
("29993","image-optimization/cleanup/stuck-operation","failed","2025-11-16 09:55:49","2025-11-16 09:55:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763286949;s:18:\"\0*\0first_timestamp\";i:1761582536;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763286949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-16 09:56:44","2025-11-16 09:56:44","49496",NULL),
("31146","image-optimization/cleanup/stuck-operation","complete","2025-11-22 12:27:33","2025-11-22 12:27:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763814453;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763814453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 12:27:52","2025-11-22 12:27:52","0",NULL),
("31147","image-optimization/cleanup/stuck-operation","complete","2025-11-22 12:32:52","2025-11-22 12:32:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763814772;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763814772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 12:37:08","2025-11-22 12:37:08","0",NULL),
("31148","image-optimization/cleanup/stuck-operation","complete","2025-11-22 12:42:08","2025-11-22 12:42:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763815328;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763815328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 12:43:33","2025-11-22 12:43:33","0",NULL),
("31149","image-optimization/cleanup/stuck-operation","complete","2025-11-22 12:48:33","2025-11-22 12:48:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763815713;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763815713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 12:49:35","2025-11-22 12:49:35","0",NULL),
("31150","image-optimization/cleanup/stuck-operation","complete","2025-11-22 12:54:35","2025-11-22 12:54:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763816075;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763816075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 12:55:35","2025-11-22 12:55:35","0",NULL),
("31151","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:00:35","2025-11-22 13:00:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763816435;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763816435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:03:24","2025-11-22 13:03:24","0",NULL),
("31152","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:08:24","2025-11-22 13:08:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763816904;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763816904;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:10:38","2025-11-22 13:10:38","0",NULL),
("31153","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:15:38","2025-11-22 13:15:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763817338;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763817338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:19:45","2025-11-22 13:19:45","0",NULL),
("31154","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:24:45","2025-11-22 13:24:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763817885;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763817885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:26:57","2025-11-22 13:26:57","0",NULL),
("31155","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:31:57","2025-11-22 13:31:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763818317;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763818317;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:41:48","2025-11-22 13:41:48","0",NULL),
("31156","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:46:48","2025-11-22 13:46:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763819208;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763819208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:47:24","2025-11-22 13:47:24","0",NULL),
("31157","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:52:24","2025-11-22 13:52:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763819544;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763819544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 13:54:14","2025-11-22 13:54:14","0",NULL),
("31158","image-optimization/cleanup/stuck-operation","complete","2025-11-22 13:59:14","2025-11-22 13:59:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763819954;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763819954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:00:07","2025-11-22 14:00:07","0",NULL),
("31159","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:05:07","2025-11-22 14:05:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763820307;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763820307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:11:46","2025-11-22 14:11:46","0",NULL),
("31160","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:16:46","2025-11-22 14:16:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763821006;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763821006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:18:52","2025-11-22 14:18:52","0",NULL),
("31161","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:23:52","2025-11-22 14:23:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763821432;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763821432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:28:56","2025-11-22 14:28:56","0",NULL),
("31162","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:33:56","2025-11-22 14:33:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763822036;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763822036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:38:07","2025-11-22 14:38:07","0",NULL),
("31163","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:43:07","2025-11-22 14:43:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763822587;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763822587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:46:32","2025-11-22 14:46:32","0",NULL),
("31164","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:51:32","2025-11-22 14:51:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763823092;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763823092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:52:00","2025-11-22 14:52:00","0",NULL),
("31165","image-optimization/cleanup/stuck-operation","complete","2025-11-22 14:57:00","2025-11-22 14:57:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763823420;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763823420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 14:57:59","2025-11-22 14:57:59","0",NULL),
("31166","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:02:59","2025-11-22 15:02:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763823779;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763823779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:08:55","2025-11-22 15:08:55","0",NULL),
("31167","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:13:55","2025-11-22 15:13:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763824435;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763824435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:15:00","2025-11-22 15:15:00","0",NULL),
("31168","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:20:00","2025-11-22 15:20:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763824800;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763824800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:22:15","2025-11-22 15:22:15","0",NULL),
("31169","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:27:15","2025-11-22 15:27:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763825235;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763825235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:27:46","2025-11-22 15:27:46","0",NULL),
("31170","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:32:46","2025-11-22 15:32:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763825566;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763825566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:36:06","2025-11-22 15:36:06","0",NULL),
("31171","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:41:06","2025-11-22 15:41:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763826066;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763826066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:46:46","2025-11-22 15:46:46","0",NULL),
("31172","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:51:46","2025-11-22 15:51:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763826706;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763826706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 15:52:07","2025-11-22 15:52:07","0",NULL),
("31173","image-optimization/cleanup/stuck-operation","complete","2025-11-22 15:57:07","2025-11-22 15:57:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763827027;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763827027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:00:13","2025-11-22 16:00:13","0",NULL),
("31174","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:05:13","2025-11-22 16:05:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763827513;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763827513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:06:59","2025-11-22 16:06:59","0",NULL),
("31175","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:11:59","2025-11-22 16:11:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763827919;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763827919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:13:53","2025-11-22 16:13:53","0",NULL),
("31176","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:18:53","2025-11-22 16:18:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763828333;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763828333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:19:17","2025-11-22 16:19:17","0",NULL),
("31177","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:24:17","2025-11-22 16:24:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763828657;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763828657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:25:42","2025-11-22 16:25:42","0",NULL),
("31178","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:30:42","2025-11-22 16:30:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763829042;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763829042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:31:03","2025-11-22 16:31:03","0",NULL),
("31179","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:36:03","2025-11-22 16:36:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763829363;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763829363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:38:17","2025-11-22 16:38:17","0",NULL),
("31180","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:43:17","2025-11-22 16:43:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763829797;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763829797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:44:49","2025-11-22 16:44:49","0",NULL),
("31181","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:49:49","2025-11-22 16:49:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763830189;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763830189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 16:50:46","2025-11-22 16:50:46","0",NULL),
("31182","image-optimization/cleanup/stuck-operation","complete","2025-11-22 16:55:46","2025-11-22 16:55:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763830546;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763830546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:00:12","2025-11-22 17:00:12","0",NULL),
("31183","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:05:12","2025-11-22 17:05:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831112;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:06:11","2025-11-22 17:06:11","0",NULL),
("31184","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:11:11","2025-11-22 17:11:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831471;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831471;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:11:55","2025-11-22 17:11:55","0",NULL),
("31185","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:16:55","2025-11-22 17:16:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763831815;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763831815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:19:08","2025-11-22 17:19:08","0",NULL),
("31186","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:24:08","2025-11-22 17:24:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763832248;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763832248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:28:19","2025-11-22 17:28:19","0",NULL),
("31187","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:33:19","2025-11-22 17:33:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763832799;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763832799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:37:13","2025-11-22 17:37:13","0",NULL),
("31188","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:42:13","2025-11-22 17:42:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763833333;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763833333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 17:53:36","2025-11-22 17:53:36","0",NULL),
("31189","image-optimization/cleanup/stuck-operation","complete","2025-11-22 17:58:36","2025-11-22 17:58:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763834316;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763834316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:03:55","2025-11-22 18:03:55","0",NULL),
("31190","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:08:55","2025-11-22 18:08:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763834935;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763834935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:12:57","2025-11-22 18:12:57","0",NULL),
("31191","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:17:57","2025-11-22 18:17:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835477;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835477;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:19:53","2025-11-22 18:19:53","0",NULL),
("31192","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:24:53","2025-11-22 18:24:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763835893;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763835893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:26:21","2025-11-22 18:26:21","0",NULL),
("31193","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:31:21","2025-11-22 18:31:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763836281;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763836281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:31:44","2025-11-22 18:31:44","0",NULL),
("31194","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:36:44","2025-11-22 18:36:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763836604;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763836604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:38:43","2025-11-22 18:38:43","0",NULL),
("31195","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:43:43","2025-11-22 18:43:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763837023;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763837023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:48:55","2025-11-22 18:48:55","0",NULL),
("31196","image-optimization/cleanup/stuck-operation","complete","2025-11-22 18:53:55","2025-11-22 18:53:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763837635;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763837635;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 18:55:41","2025-11-22 18:55:41","0",NULL),
("31197","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:00:41","2025-11-22 19:00:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763838041;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763838041;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:02:28","2025-11-22 19:02:28","0",NULL),
("31198","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:07:28","2025-11-22 19:07:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763838448;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763838448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:11:26","2025-11-22 19:11:26","0",NULL),
("31199","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:16:26","2025-11-22 19:16:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763838986;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763838986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:22:47","2025-11-22 19:22:47","0",NULL),
("31200","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:27:47","2025-11-22 19:27:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763839667;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763839667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:33:11","2025-11-22 19:33:11","0",NULL),
("31201","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:38:11","2025-11-22 19:38:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763840291;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763840291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:39:41","2025-11-22 19:39:41","0",NULL),
("31202","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:44:41","2025-11-22 19:44:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763840681;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763840681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:45:48","2025-11-22 19:45:48","0",NULL),
("31203","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:51:00","2025-11-22 19:51:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763841060;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763841060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 19:53:01","2025-11-22 19:53:01","0",NULL),
("31204","image-optimization/cleanup/stuck-operation","complete","2025-11-22 19:58:01","2025-11-22 19:58:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763841481;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763841481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 20:00:17","2025-11-22 20:00:17","0",NULL),
("31205","image-optimization/cleanup/stuck-operation","complete","2025-11-22 20:05:17","2025-11-22 20:05:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763841917;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763841917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 20:08:37","2025-11-22 20:08:37","0",NULL),
("31206","image-optimization/cleanup/stuck-operation","complete","2025-11-22 20:13:37","2025-11-22 20:13:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763842417;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763842417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 20:19:55","2025-11-22 20:19:55","0",NULL),
("31207","image-optimization/cleanup/stuck-operation","complete","2025-11-22 20:24:55","2025-11-22 20:24:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763843095;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763843095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 20:32:41","2025-11-22 20:32:41","0",NULL),
("31208","image-optimization/cleanup/stuck-operation","complete","2025-11-22 20:37:41","2025-11-22 20:37:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763843861;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763843861;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 20:41:58","2025-11-22 20:41:58","0",NULL),
("31209","image-optimization/cleanup/stuck-operation","complete","2025-11-22 20:46:58","2025-11-22 20:46:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763844418;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763844418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 20:47:19","2025-11-22 20:47:19","0",NULL),
("31210","image-optimization/cleanup/stuck-operation","complete","2025-11-22 20:52:19","2025-11-22 20:52:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763844739;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763844739;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:00:00","2025-11-22 21:00:00","0",NULL),
("31211","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:05:00","2025-11-22 21:05:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763845500;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763845500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:06:33","2025-11-22 21:06:33","0",NULL),
("31212","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:11:33","2025-11-22 21:11:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763845893;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763845893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:15:13","2025-11-22 21:15:13","0",NULL),
("31213","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:20:13","2025-11-22 21:20:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763846413;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763846413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:20:53","2025-11-22 21:20:53","0",NULL),
("31214","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:25:53","2025-11-22 21:25:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763846753;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763846753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:32:35","2025-11-22 21:32:35","0",NULL),
("31215","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:37:35","2025-11-22 21:37:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763847455;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763847455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:39:38","2025-11-22 21:39:38","0",NULL),
("31216","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:44:38","2025-11-22 21:44:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763847878;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763847878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:51:23","2025-11-22 21:51:23","0",NULL),
("31217","image-optimization/cleanup/stuck-operation","complete","2025-11-22 21:56:23","2025-11-22 21:56:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763848583;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763848583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 21:57:00","2025-11-22 21:57:00","0",NULL),
("31218","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:02:00","2025-11-22 22:02:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763848920;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763848920;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 22:05:15","2025-11-22 22:05:15","0",NULL),
("31219","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:10:15","2025-11-22 22:10:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763849415;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763849415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 22:22:15","2025-11-22 22:22:15","0",NULL),
("31220","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:27:15","2025-11-22 22:27:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763850435;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763850435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 22:28:18","2025-11-22 22:28:18","0",NULL),
("31221","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:33:18","2025-11-22 22:33:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763850798;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763850798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 22:39:12","2025-11-22 22:39:12","0",NULL),
("31222","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:44:12","2025-11-22 22:44:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763851452;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763851452;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 22:46:28","2025-11-22 22:46:28","0",NULL),
("31223","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:51:28","2025-11-22 22:51:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763851888;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763851888;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 22:54:18","2025-11-22 22:54:18","0",NULL),
("31224","image-optimization/cleanup/stuck-operation","complete","2025-11-22 22:59:18","2025-11-22 22:59:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763852358;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763852358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:00:35","2025-11-22 23:00:35","0",NULL),
("31225","image-optimization/cleanup/stuck-operation","complete","2025-11-22 23:05:35","2025-11-22 23:05:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763852735;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763852735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:10:39","2025-11-22 23:10:39","0",NULL),
("31226","image-optimization/cleanup/stuck-operation","complete","2025-11-22 23:15:39","2025-11-22 23:15:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763853339;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763853339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:22:17","2025-11-22 23:22:17","0",NULL),
("31227","image-optimization/cleanup/stuck-operation","complete","2025-11-22 23:27:17","2025-11-22 23:27:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763854037;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763854037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:29:52","2025-11-22 23:29:52","0",NULL),
("31228","image-optimization/cleanup/stuck-operation","complete","2025-11-22 23:34:52","2025-11-22 23:34:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763854492;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763854492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:38:43","2025-11-22 23:38:43","0",NULL),
("31229","image-optimization/cleanup/stuck-operation","complete","2025-11-22 23:43:43","2025-11-22 23:43:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763855023;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763855023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:46:38","2025-11-22 23:46:38","0",NULL),
("31230","image-optimization/cleanup/stuck-operation","complete","2025-11-22 23:51:38","2025-11-22 23:51:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763855498;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763855498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-22 23:58:38","2025-11-22 23:58:38","0",NULL),
("31231","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:03:38","2025-11-23 00:03:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763856218;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763856218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:06:19","2025-11-23 00:06:19","0",NULL),
("31232","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:11:19","2025-11-23 00:11:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763856679;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763856679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:16:22","2025-11-23 00:16:22","0",NULL),
("31233","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:21:22","2025-11-23 00:21:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763857282;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763857282;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:24:03","2025-11-23 00:24:03","0",NULL),
("31234","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:29:03","2025-11-23 00:29:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763857743;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763857743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:29:42","2025-11-23 00:29:42","0",NULL),
("31235","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:34:42","2025-11-23 00:34:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763858082;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763858082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:36:55","2025-11-23 00:36:55","0",NULL),
("31236","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:41:55","2025-11-23 00:41:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763858515;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763858515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:45:07","2025-11-23 00:45:07","0",NULL),
("31237","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:50:07","2025-11-23 00:50:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763859007;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763859007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 00:54:13","2025-11-23 00:54:13","0",NULL),
("31238","image-optimization/cleanup/stuck-operation","complete","2025-11-23 00:59:13","2025-11-23 00:59:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763859553;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763859553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:01:24","2025-11-23 01:01:24","0",NULL),
("31239","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:06:24","2025-11-23 01:06:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763859984;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763859984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:06:50","2025-11-23 01:06:50","0",NULL),
("31240","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:11:50","2025-11-23 01:11:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763860310;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763860310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:13:32","2025-11-23 01:13:32","0",NULL),
("31241","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:18:32","2025-11-23 01:18:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763860712;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763860712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:19:07","2025-11-23 01:19:07","0",NULL),
("31242","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:24:07","2025-11-23 01:24:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763861047;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763861047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:28:35","2025-11-23 01:28:35","0",NULL),
("31243","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:33:35","2025-11-23 01:33:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763861615;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763861615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:34:15","2025-11-23 01:34:15","0",NULL),
("31244","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:39:15","2025-11-23 01:39:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763861955;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763861955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:41:08","2025-11-23 01:41:08","0",NULL),
("31245","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:46:08","2025-11-23 01:46:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763862368;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763862368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:47:11","2025-11-23 01:47:11","0",NULL),
("31246","image-optimization/cleanup/stuck-operation","complete","2025-11-23 01:52:11","2025-11-23 01:52:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763862731;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763862731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 01:59:38","2025-11-23 01:59:38","0",NULL),
("31247","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:04:38","2025-11-23 02:04:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763863478;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763863478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:06:58","2025-11-23 02:06:58","0",NULL),
("31248","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:11:58","2025-11-23 02:11:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763863918;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763863918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:13:04","2025-11-23 02:13:04","0",NULL),
("31249","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:18:04","2025-11-23 02:18:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763864284;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763864284;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:18:35","2025-11-23 02:18:35","0",NULL),
("31250","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:23:35","2025-11-23 02:23:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763864615;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763864615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:23:52","2025-11-23 02:23:52","0",NULL),
("31251","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:28:52","2025-11-23 02:28:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763864932;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763864932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:31:28","2025-11-23 02:31:28","0",NULL),
("31252","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:36:28","2025-11-23 02:36:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763865388;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763865388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:37:51","2025-11-23 02:37:51","0",NULL),
("31253","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:42:51","2025-11-23 02:42:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763865771;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763865771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:48:15","2025-11-23 02:48:15","0",NULL),
("31254","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:53:15","2025-11-23 02:53:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763866395;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763866395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:53:34","2025-11-23 02:53:34","0",NULL),
("31255","image-optimization/cleanup/stuck-operation","complete","2025-11-23 02:58:34","2025-11-23 02:58:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763866714;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763866714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 02:59:53","2025-11-23 02:59:53","0",NULL),
("31256","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:04:53","2025-11-23 03:04:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763867093;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763867093;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 03:08:27","2025-11-23 03:08:27","0",NULL),
("31257","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:13:27","2025-11-23 03:13:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763867607;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763867607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 03:17:07","2025-11-23 03:17:07","0",NULL),
("31258","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:22:07","2025-11-23 03:22:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763868127;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763868127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 03:23:07","2025-11-23 03:23:07","0",NULL),
("31259","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:28:07","2025-11-23 03:28:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763868487;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763868487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 03:31:19","2025-11-23 03:31:19","0",NULL),
("31260","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:36:19","2025-11-23 03:36:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763868979;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763868979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 03:36:49","2025-11-23 03:36:49","0",NULL),
("31261","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:41:49","2025-11-23 03:41:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763869309;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763869309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 03:54:03","2025-11-23 03:54:03","0",NULL),
("31262","image-optimization/cleanup/stuck-operation","complete","2025-11-23 03:59:03","2025-11-23 03:59:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763870343;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763870343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:03:03","2025-11-23 04:03:03","0",NULL),
("31263","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:08:03","2025-11-23 04:08:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763870883;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763870883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:09:20","2025-11-23 04:09:20","0",NULL),
("31264","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:14:20","2025-11-23 04:14:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763871260;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763871260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:22:51","2025-11-23 04:22:51","0",NULL),
("31265","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:27:51","2025-11-23 04:27:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763872071;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763872071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:31:53","2025-11-23 04:31:53","0",NULL),
("31266","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:36:53","2025-11-23 04:36:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763872613;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763872613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:37:43","2025-11-23 04:37:43","0",NULL),
("31267","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:42:43","2025-11-23 04:42:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763872963;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763872963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:46:08","2025-11-23 04:46:08","0",NULL),
("31268","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:51:08","2025-11-23 04:51:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763873468;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763873468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 04:54:38","2025-11-23 04:54:38","0",NULL),
("31269","image-optimization/cleanup/stuck-operation","complete","2025-11-23 04:59:38","2025-11-23 04:59:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763873978;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763873978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:02:21","2025-11-23 05:02:21","0",NULL),
("31270","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:07:21","2025-11-23 05:07:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763874441;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763874441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:08:26","2025-11-23 05:08:26","0",NULL),
("31271","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:13:26","2025-11-23 05:13:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763874806;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763874806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:14:25","2025-11-23 05:14:25","0",NULL),
("31272","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:19:25","2025-11-23 05:19:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763875165;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763875165;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:22:18","2025-11-23 05:22:18","0",NULL),
("31273","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:27:18","2025-11-23 05:27:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763875638;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763875638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:29:18","2025-11-23 05:29:18","0",NULL),
("31274","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:34:18","2025-11-23 05:34:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763876058;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763876058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:38:19","2025-11-23 05:38:19","0",NULL),
("31275","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:43:19","2025-11-23 05:43:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763876599;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763876599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:46:35","2025-11-23 05:46:35","0",NULL),
("31276","image-optimization/cleanup/stuck-operation","complete","2025-11-23 05:51:35","2025-11-23 05:51:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763877095;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763877095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 05:56:38","2025-11-23 05:56:38","0",NULL),
("31277","image-optimization/cleanup/stuck-operation","complete","2025-11-23 06:01:38","2025-11-23 06:01:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763877698;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763877698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 06:02:53","2025-11-23 06:02:53","0",NULL),
("31278","image-optimization/cleanup/stuck-operation","complete","2025-11-23 06:07:53","2025-11-23 06:07:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763878073;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763878073;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 06:28:32","2025-11-23 06:28:32","0",NULL),
("31279","image-optimization/cleanup/stuck-operation","complete","2025-11-23 06:33:32","2025-11-23 06:33:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763879612;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763879612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 06:35:13","2025-11-23 06:35:13","0",NULL),
("31280","image-optimization/cleanup/stuck-operation","complete","2025-11-23 06:40:13","2025-11-23 06:40:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763880013;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763880013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 06:44:58","2025-11-23 06:44:58","0",NULL),
("31281","image-optimization/cleanup/stuck-operation","complete","2025-11-23 06:49:58","2025-11-23 06:49:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763880598;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763880598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 06:59:44","2025-11-23 06:59:44","0",NULL),
("31282","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:04:44","2025-11-23 07:04:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763881484;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763881484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:09:18","2025-11-23 07:09:18","0",NULL),
("31283","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:14:18","2025-11-23 07:14:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763882058;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763882058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:16:39","2025-11-23 07:16:39","0",NULL),
("31284","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:21:39","2025-11-23 07:21:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763882499;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763882499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:23:52","2025-11-23 07:23:52","0",NULL),
("31285","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:28:52","2025-11-23 07:28:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763882932;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763882932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:30:35","2025-11-23 07:30:35","0",NULL),
("31286","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:35:35","2025-11-23 07:35:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763883335;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763883335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:38:11","2025-11-23 07:38:11","0",NULL),
("31287","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:43:11","2025-11-23 07:43:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763883791;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763883791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:44:56","2025-11-23 07:44:56","0",NULL),
("31288","image-optimization/cleanup/stuck-operation","complete","2025-11-23 07:49:56","2025-11-23 07:49:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763884196;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763884196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 07:56:05","2025-11-23 07:56:05","0",NULL),
("31289","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:01:05","2025-11-23 08:01:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763884865;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763884865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:01:41","2025-11-23 08:01:41","0",NULL),
("31290","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:06:41","2025-11-23 08:06:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763885201;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763885201;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:10:00","2025-11-23 08:10:00","0",NULL),
("31291","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:15:00","2025-11-23 08:15:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763885700;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763885700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:16:15","2025-11-23 08:16:15","0",NULL),
("31292","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:21:15","2025-11-23 08:21:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763886075;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763886075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:25:41","2025-11-23 08:25:41","0",NULL),
("31293","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:30:41","2025-11-23 08:30:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763886641;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763886641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:35:23","2025-11-23 08:35:23","0",NULL),
("31294","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:40:23","2025-11-23 08:40:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763887223;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763887223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:40:46","2025-11-23 08:40:46","0",NULL),
("31295","image-optimization/cleanup/stuck-operation","complete","2025-11-23 08:45:46","2025-11-23 08:45:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763887546;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763887546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 08:59:52","2025-11-23 08:59:52","0",NULL),
("31296","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:04:52","2025-11-23 09:04:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763888692;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763888692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:13:29","2025-11-23 09:13:29","0",NULL),
("31297","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:18:29","2025-11-23 09:18:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763889509;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763889509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:18:56","2025-11-23 09:18:56","0",NULL),
("31298","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:23:56","2025-11-23 09:23:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763889836;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763889836;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:24:32","2025-11-23 09:24:32","0",NULL),
("31299","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:29:32","2025-11-23 09:29:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763890172;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763890172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:33:38","2025-11-23 09:33:38","0",NULL),
("31300","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:38:38","2025-11-23 09:38:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763890718;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763890718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:44:55","2025-11-23 09:44:55","0",NULL),
("31301","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:49:55","2025-11-23 09:49:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763891395;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763891395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:50:16","2025-11-23 09:50:16","0",NULL),
("31302","image-optimization/cleanup/stuck-operation","complete","2025-11-23 09:55:16","2025-11-23 09:55:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763891716;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763891716;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 09:55:35","2025-11-23 09:55:35","0",NULL),
("31303","image-optimization/cleanup/stuck-operation","complete","2025-11-23 10:00:35","2025-11-23 10:00:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763892035;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763892035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 10:01:03","2025-11-23 10:01:03","0",NULL),
("31304","image-optimization/cleanup/stuck-operation","complete","2025-11-23 10:06:03","2025-11-23 10:06:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763892363;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763892363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 10:06:35","2025-11-23 10:06:35","0",NULL),
("31305","image-optimization/cleanup/stuck-operation","complete","2025-11-23 10:11:35","2025-11-23 10:11:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763892695;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763892695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 10:32:47","2025-11-23 10:32:47","0",NULL),
("31306","image-optimization/cleanup/stuck-operation","complete","2025-11-23 10:37:47","2025-11-23 10:37:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763894267;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763894267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 10:38:29","2025-11-23 10:38:29","0",NULL),
("31307","image-optimization/cleanup/stuck-operation","complete","2025-11-23 10:43:29","2025-11-23 10:43:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763894609;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763894609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 10:48:22","2025-11-23 10:48:22","0",NULL),
("31308","image-optimization/cleanup/stuck-operation","complete","2025-11-23 10:53:22","2025-11-23 10:53:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763895202;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763895202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 10:58:33","2025-11-23 10:58:33","0",NULL),
("31309","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:03:33","2025-11-23 11:03:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763895813;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763895813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:10:22","2025-11-23 11:10:22","0",NULL),
("31310","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:15:22","2025-11-23 11:15:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763896522;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763896522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:17:41","2025-11-23 11:17:41","0",NULL),
("31311","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:22:41","2025-11-23 11:22:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763896961;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763896961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:26:26","2025-11-23 11:26:26","0",NULL),
("31312","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:31:26","2025-11-23 11:31:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763897486;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763897486;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:38:09","2025-11-23 11:38:09","0",NULL),
("31313","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:43:09","2025-11-23 11:43:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763898189;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763898189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:45:09","2025-11-23 11:45:09","0",NULL),
("31314","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:50:09","2025-11-23 11:50:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763898609;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763898609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:50:37","2025-11-23 11:50:37","0",NULL),
("31315","image-optimization/cleanup/stuck-operation","complete","2025-11-23 11:55:37","2025-11-23 11:55:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763898937;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763898937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 11:58:58","2025-11-23 11:58:58","0",NULL),
("31316","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:03:58","2025-11-23 12:03:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763899438;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763899438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:05:38","2025-11-23 12:05:38","0",NULL),
("31317","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:10:38","2025-11-23 12:10:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763899838;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763899838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:11:51","2025-11-23 12:11:51","0",NULL),
("31318","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:16:51","2025-11-23 12:16:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763900211;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763900211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:18:26","2025-11-23 12:18:26","0",NULL),
("31319","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:23:26","2025-11-23 12:23:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763900606;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763900606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:24:21","2025-11-23 12:24:21","0",NULL),
("31320","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:29:21","2025-11-23 12:29:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763900961;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763900961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:31:24","2025-11-23 12:31:24","0",NULL),
("31321","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:36:24","2025-11-23 12:36:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763901384;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763901384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:40:32","2025-11-23 12:40:32","0",NULL),
("31322","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:45:32","2025-11-23 12:45:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763901932;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763901932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:49:03","2025-11-23 12:49:03","0",NULL),
("31323","image-optimization/cleanup/stuck-operation","complete","2025-11-23 12:54:03","2025-11-23 12:54:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763902443;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763902443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 12:56:44","2025-11-23 12:56:44","0",NULL),
("31324","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:01:44","2025-11-23 13:01:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763902904;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763902904;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:06:46","2025-11-23 13:06:46","0",NULL),
("31325","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:11:46","2025-11-23 13:11:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763903506;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763903506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:12:09","2025-11-23 13:12:09","0",NULL),
("31326","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:17:09","2025-11-23 13:17:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763903829;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763903829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:19:22","2025-11-23 13:19:22","0",NULL),
("31327","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:24:22","2025-11-23 13:24:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763904262;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763904262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:26:28","2025-11-23 13:26:28","0",NULL),
("31328","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:31:28","2025-11-23 13:31:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763904688;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763904688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:35:34","2025-11-23 13:35:34","0",NULL),
("31329","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:40:34","2025-11-23 13:40:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763905234;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763905234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:42:56","2025-11-23 13:42:56","0",NULL),
("31330","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:47:56","2025-11-23 13:47:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763905676;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763905676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:48:51","2025-11-23 13:48:51","0",NULL),
("31331","image-optimization/cleanup/stuck-operation","complete","2025-11-23 13:53:51","2025-11-23 13:53:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763906031;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763906031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 13:55:14","2025-11-23 13:55:14","0",NULL),
("31332","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:00:14","2025-11-23 14:00:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763906414;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763906414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:02:46","2025-11-23 14:02:46","0",NULL),
("31333","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:07:46","2025-11-23 14:07:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763906866;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763906866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:08:15","2025-11-23 14:08:15","0",NULL),
("31334","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:13:15","2025-11-23 14:13:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763907195;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763907195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:15:04","2025-11-23 14:15:04","0",NULL),
("31335","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:20:04","2025-11-23 14:20:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763907604;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763907604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:27:31","2025-11-23 14:27:31","0",NULL),
("31336","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:32:31","2025-11-23 14:32:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763908351;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763908351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:38:29","2025-11-23 14:38:29","0",NULL),
("31337","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:43:29","2025-11-23 14:43:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763909009;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763909009;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:45:56","2025-11-23 14:45:56","0",NULL),
("31338","image-optimization/cleanup/stuck-operation","complete","2025-11-23 14:50:56","2025-11-23 14:50:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763909456;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763909456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 14:56:22","2025-11-23 14:56:22","0",NULL),
("31339","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:01:22","2025-11-23 15:01:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763910082;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763910082;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:01:58","2025-11-23 15:01:58","0",NULL),
("31340","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:06:58","2025-11-23 15:06:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763910418;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763910418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:08:25","2025-11-23 15:08:25","0",NULL),
("31341","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:13:25","2025-11-23 15:13:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763910805;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763910805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:15:48","2025-11-23 15:15:48","0",NULL),
("31342","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:20:48","2025-11-23 15:20:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763911248;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763911248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:22:11","2025-11-23 15:22:11","0",NULL),
("31343","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:27:11","2025-11-23 15:27:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763911631;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763911631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:29:50","2025-11-23 15:29:50","0",NULL),
("31344","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:34:50","2025-11-23 15:34:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763912090;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763912090;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:36:38","2025-11-23 15:36:38","0",NULL),
("31345","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:41:38","2025-11-23 15:41:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763912498;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763912498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:43:59","2025-11-23 15:43:59","0",NULL),
("31346","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:48:59","2025-11-23 15:48:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763912939;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763912939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 15:52:53","2025-11-23 15:52:53","0",NULL),
("31347","image-optimization/cleanup/stuck-operation","complete","2025-11-23 15:57:53","2025-11-23 15:57:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763913473;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763913473;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:02:00","2025-11-23 16:02:00","0",NULL),
("31348","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:07:00","2025-11-23 16:07:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763914020;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763914020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:10:41","2025-11-23 16:10:41","0",NULL),
("31349","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:15:41","2025-11-23 16:15:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763914541;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763914541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:18:58","2025-11-23 16:18:58","0",NULL),
("31350","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:23:58","2025-11-23 16:23:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763915038;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763915038;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:25:31","2025-11-23 16:25:31","0",NULL),
("31351","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:30:31","2025-11-23 16:30:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763915431;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763915431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:34:21","2025-11-23 16:34:21","0",NULL),
("31352","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:39:21","2025-11-23 16:39:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763915961;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763915961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:42:22","2025-11-23 16:42:22","0",NULL),
("31353","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:47:22","2025-11-23 16:47:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763916442;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763916442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 16:50:41","2025-11-23 16:50:41","0",NULL),
("31354","image-optimization/cleanup/stuck-operation","complete","2025-11-23 16:55:41","2025-11-23 16:55:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763916941;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763916941;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:03:45","2025-11-23 17:03:45","0",NULL),
("31355","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:08:45","2025-11-23 17:08:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763917725;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763917725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:13:46","2025-11-23 17:13:46","0",NULL),
("31356","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:18:46","2025-11-23 17:18:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763918326;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763918326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:19:07","2025-11-23 17:19:07","0",NULL),
("31357","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:24:07","2025-11-23 17:24:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763918647;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763918647;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:27:37","2025-11-23 17:27:37","0",NULL),
("31358","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:32:37","2025-11-23 17:32:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763919157;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763919157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:33:49","2025-11-23 17:33:49","0",NULL),
("31359","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:38:49","2025-11-23 17:38:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763919529;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763919529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:39:57","2025-11-23 17:39:57","0",NULL),
("31360","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:44:57","2025-11-23 17:44:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763919897;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763919897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:46:50","2025-11-23 17:46:50","0",NULL),
("31361","image-optimization/cleanup/stuck-operation","complete","2025-11-23 17:51:50","2025-11-23 17:51:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763920310;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763920310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 17:55:59","2025-11-23 17:55:59","0",NULL),
("31362","image-optimization/cleanup/stuck-operation","complete","2025-11-23 18:00:59","2025-11-23 18:00:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763920859;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763920859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 18:11:26","2025-11-23 18:11:26","0",NULL),
("31363","image-optimization/cleanup/stuck-operation","complete","2025-11-23 18:16:26","2025-11-23 18:16:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763921786;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763921786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 18:21:30","2025-11-23 18:21:30","0",NULL),
("31364","image-optimization/cleanup/stuck-operation","complete","2025-11-23 18:26:30","2025-11-23 18:26:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763922390;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763922390;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 18:27:52","2025-11-23 18:27:52","0",NULL),
("31365","image-optimization/cleanup/stuck-operation","complete","2025-11-23 18:32:52","2025-11-23 18:32:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763922772;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763922772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 18:33:49","2025-11-23 18:33:49","0",NULL),
("31366","image-optimization/cleanup/stuck-operation","complete","2025-11-23 18:38:49","2025-11-23 18:38:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763923129;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763923129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 18:40:17","2025-11-23 18:40:17","0",NULL),
("31367","image-optimization/cleanup/stuck-operation","complete","2025-11-23 18:45:17","2025-11-23 18:45:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763923517;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763923517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:00:47","2025-11-23 19:00:47","0",NULL),
("31368","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:05:47","2025-11-23 19:05:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763924747;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763924747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:06:08","2025-11-23 19:06:08","0",NULL),
("31369","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:11:08","2025-11-23 19:11:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763925068;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763925068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:20:35","2025-11-23 19:20:35","0",NULL),
("31370","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:25:35","2025-11-23 19:25:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763925935;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763925935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:26:10","2025-11-23 19:26:10","0",NULL),
("31371","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:31:10","2025-11-23 19:31:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763926270;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763926270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:32:11","2025-11-23 19:32:11","0",NULL),
("31372","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:37:11","2025-11-23 19:37:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763926631;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763926631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:44:04","2025-11-23 19:44:04","0",NULL),
("31373","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:49:04","2025-11-23 19:49:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763927344;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763927344;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:49:21","2025-11-23 19:49:21","0",NULL),
("31374","image-optimization/cleanup/stuck-operation","complete","2025-11-23 19:54:21","2025-11-23 19:54:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763927661;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763927661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 19:55:13","2025-11-23 19:55:13","0",NULL),
("31375","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:00:13","2025-11-23 20:00:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763928013;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763928013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:08:47","2025-11-23 20:08:47","0",NULL),
("31376","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:13:47","2025-11-23 20:13:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763928827;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763928827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:17:15","2025-11-23 20:17:15","0",NULL),
("31377","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:22:15","2025-11-23 20:22:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763929335;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763929335;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:25:21","2025-11-23 20:25:21","0",NULL),
("31378","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:30:21","2025-11-23 20:30:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763929821;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763929821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:35:35","2025-11-23 20:35:35","0",NULL),
("31379","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:40:35","2025-11-23 20:40:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763930435;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763930435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:43:18","2025-11-23 20:43:18","0",NULL),
("31380","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:48:18","2025-11-23 20:48:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763930898;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763930898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:50:19","2025-11-23 20:50:19","0",NULL),
("31381","image-optimization/cleanup/stuck-operation","complete","2025-11-23 20:55:19","2025-11-23 20:55:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763931319;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763931319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 20:57:09","2025-11-23 20:57:09","0",NULL),
("31382","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:02:09","2025-11-23 21:02:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763931729;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763931729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:03:08","2025-11-23 21:03:08","0",NULL),
("31383","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:08:08","2025-11-23 21:08:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763932088;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763932088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:09:18","2025-11-23 21:09:18","0",NULL),
("31384","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:14:18","2025-11-23 21:14:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763932458;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763932458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:17:10","2025-11-23 21:17:10","0",NULL),
("31385","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:22:10","2025-11-23 21:22:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763932930;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763932930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:24:33","2025-11-23 21:24:33","0",NULL),
("31386","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:29:33","2025-11-23 21:29:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763933373;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763933373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:32:20","2025-11-23 21:32:20","0",NULL),
("31387","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:37:20","2025-11-23 21:37:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763933840;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763933840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:37:42","2025-11-23 21:37:42","0",NULL),
("31388","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:42:42","2025-11-23 21:42:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763934162;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763934162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:43:23","2025-11-23 21:43:23","0",NULL),
("31389","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:48:23","2025-11-23 21:48:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763934503;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763934503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:52:02","2025-11-23 21:52:02","0",NULL),
("31390","image-optimization/cleanup/stuck-operation","complete","2025-11-23 21:57:02","2025-11-23 21:57:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763935022;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763935022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 21:57:58","2025-11-23 21:57:58","0",NULL),
("31391","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:02:58","2025-11-23 22:02:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763935378;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763935378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:05:30","2025-11-23 22:05:30","0",NULL),
("31392","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:10:30","2025-11-23 22:10:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763935830;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763935830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:12:53","2025-11-23 22:12:53","0",NULL),
("31393","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:17:53","2025-11-23 22:17:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763936273;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763936273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:18:06","2025-11-23 22:18:06","0",NULL),
("31394","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:23:06","2025-11-23 22:23:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763936586;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763936586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:27:38","2025-11-23 22:27:38","0",NULL),
("31395","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:32:38","2025-11-23 22:32:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763937158;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763937158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:38:37","2025-11-23 22:38:37","0",NULL),
("31396","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:43:37","2025-11-23 22:43:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763937817;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763937817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:46:27","2025-11-23 22:46:27","0",NULL),
("31397","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:51:27","2025-11-23 22:51:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763938287;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763938287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:54:03","2025-11-23 22:54:03","0",NULL),
("31398","image-optimization/cleanup/stuck-operation","complete","2025-11-23 22:59:03","2025-11-23 22:59:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763938743;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763938743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 22:59:56","2025-11-23 22:59:56","0",NULL),
("31399","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:04:56","2025-11-23 23:04:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763939096;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763939096;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:05:10","2025-11-23 23:05:10","0",NULL),
("31400","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:10:10","2025-11-23 23:10:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763939410;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763939410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:15:14","2025-11-23 23:15:14","0",NULL),
("31401","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:20:14","2025-11-23 23:20:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763940014;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763940014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:20:58","2025-11-23 23:20:58","0",NULL),
("31402","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:25:58","2025-11-23 23:25:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763940358;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763940358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:27:35","2025-11-23 23:27:35","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("31403","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:32:35","2025-11-23 23:32:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763940755;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763940755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:32:52","2025-11-23 23:32:52","0",NULL),
("31404","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:37:52","2025-11-23 23:37:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763941072;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763941072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:45:43","2025-11-23 23:45:43","0",NULL),
("31405","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:50:43","2025-11-23 23:50:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763941843;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763941843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:51:26","2025-11-23 23:51:26","0",NULL),
("31406","image-optimization/cleanup/stuck-operation","complete","2025-11-23 23:56:26","2025-11-23 23:56:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763942186;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763942186;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-23 23:57:22","2025-11-23 23:57:22","0",NULL),
("31407","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:02:22","2025-11-24 00:02:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763942542;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763942542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 00:04:55","2025-11-24 00:04:55","0",NULL),
("31408","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:09:55","2025-11-24 00:09:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763942995;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763942995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 00:15:00","2025-11-24 00:15:00","0",NULL),
("31409","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:20:00","2025-11-24 00:20:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763943600;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763943600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 00:21:54","2025-11-24 00:21:54","0",NULL),
("31410","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:26:54","2025-11-24 00:26:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763944014;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763944014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 00:27:32","2025-11-24 00:27:32","0",NULL),
("31411","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:32:32","2025-11-24 00:32:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763944352;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763944352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 00:35:07","2025-11-24 00:35:07","0",NULL),
("31412","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:40:07","2025-11-24 00:40:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763944807;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763944807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 00:44:22","2025-11-24 00:44:22","0",NULL),
("31413","image-optimization/cleanup/stuck-operation","complete","2025-11-24 00:49:22","2025-11-24 00:49:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763945362;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763945362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:00:44","2025-11-24 01:00:44","0",NULL),
("31414","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:05:47","2025-11-24 01:05:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763946347;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763946347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:08:21","2025-11-24 01:08:21","0",NULL),
("31415","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:13:21","2025-11-24 01:13:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763946801;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763946801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:14:45","2025-11-24 01:14:45","0",NULL),
("31416","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:19:45","2025-11-24 01:19:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763947185;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763947185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:20:43","2025-11-24 01:20:43","0",NULL),
("31417","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:25:43","2025-11-24 01:25:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763947543;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763947543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:27:54","2025-11-24 01:27:54","0",NULL),
("31418","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:32:54","2025-11-24 01:32:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763947974;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763947974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:34:16","2025-11-24 01:34:16","0",NULL),
("31419","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:39:16","2025-11-24 01:39:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763948356;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763948356;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 01:39:49","2025-11-24 01:39:49","0",NULL),
("31420","image-optimization/cleanup/stuck-operation","complete","2025-11-24 01:44:49","2025-11-24 01:44:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763948689;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763948689;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:00:32","2025-11-24 02:00:32","0",NULL),
("31421","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:05:32","2025-11-24 02:05:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763949932;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763949932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:07:40","2025-11-24 02:07:40","0",NULL),
("31422","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:12:40","2025-11-24 02:12:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763950360;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763950360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:15:40","2025-11-24 02:15:40","0",NULL),
("31423","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:20:40","2025-11-24 02:20:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763950840;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763950840;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:22:33","2025-11-24 02:22:33","0",NULL),
("31424","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:27:33","2025-11-24 02:27:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763951253;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763951253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:29:21","2025-11-24 02:29:21","0",NULL),
("31425","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:34:21","2025-11-24 02:34:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763951661;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763951661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:37:45","2025-11-24 02:37:45","0",NULL),
("31426","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:42:45","2025-11-24 02:42:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763952165;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763952165;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:50:02","2025-11-24 02:50:02","0",NULL),
("31427","image-optimization/cleanup/stuck-operation","complete","2025-11-24 02:55:02","2025-11-24 02:55:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763952902;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763952902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 02:56:53","2025-11-24 02:56:53","0",NULL),
("31428","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:01:53","2025-11-24 03:01:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763953313;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763953313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:08:06","2025-11-24 03:08:06","0",NULL),
("31429","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:13:06","2025-11-24 03:13:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763953986;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763953986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:15:05","2025-11-24 03:15:05","0",NULL),
("31430","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:20:05","2025-11-24 03:20:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763954405;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763954405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:22:43","2025-11-24 03:22:43","0",NULL),
("31431","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:27:43","2025-11-24 03:27:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763954863;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763954863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:31:27","2025-11-24 03:31:27","0",NULL),
("31432","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:36:27","2025-11-24 03:36:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763955387;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763955387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:38:38","2025-11-24 03:38:38","0",NULL),
("31433","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:43:38","2025-11-24 03:43:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763955818;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763955818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:45:42","2025-11-24 03:45:42","0",NULL),
("31434","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:50:42","2025-11-24 03:50:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763956242;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763956242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 03:52:52","2025-11-24 03:52:52","0",NULL),
("31435","image-optimization/cleanup/stuck-operation","complete","2025-11-24 03:57:52","2025-11-24 03:57:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763956672;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763956672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:00:01","2025-11-24 04:00:01","0",NULL),
("31436","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:05:01","2025-11-24 04:05:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763957101;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763957101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:09:03","2025-11-24 04:09:03","0",NULL),
("31437","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:14:16","2025-11-24 04:14:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763957656;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763957656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:15:32","2025-11-24 04:15:32","0",NULL),
("31438","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:20:32","2025-11-24 04:20:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763958032;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763958032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:25:08","2025-11-24 04:25:08","0",NULL),
("31439","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:30:08","2025-11-24 04:30:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763958608;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763958608;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:31:38","2025-11-24 04:31:38","0",NULL),
("31440","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:36:38","2025-11-24 04:36:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763958998;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763958998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:40:16","2025-11-24 04:40:16","0",NULL),
("31441","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:45:16","2025-11-24 04:45:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763959516;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763959516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:49:06","2025-11-24 04:49:06","0",NULL),
("31442","image-optimization/cleanup/stuck-operation","complete","2025-11-24 04:54:06","2025-11-24 04:54:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763960046;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763960046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 04:55:53","2025-11-24 04:55:53","0",NULL),
("31443","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:00:53","2025-11-24 05:00:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763960453;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763960453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:01:21","2025-11-24 05:01:21","0",NULL),
("31444","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:06:21","2025-11-24 05:06:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763960781;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763960781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:09:55","2025-11-24 05:09:55","0",NULL),
("31445","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:14:55","2025-11-24 05:14:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763961295;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763961295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:27:28","2025-11-24 05:27:28","0",NULL),
("31446","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:32:28","2025-11-24 05:32:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763962348;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763962348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:32:52","2025-11-24 05:32:52","0",NULL),
("31447","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:37:52","2025-11-24 05:37:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763962672;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763962672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:40:06","2025-11-24 05:40:06","0",NULL),
("31448","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:45:09","2025-11-24 05:45:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763963109;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763963109;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:47:13","2025-11-24 05:47:13","0",NULL),
("31449","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:52:13","2025-11-24 05:52:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763963533;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763963533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 05:53:12","2025-11-24 05:53:12","0",NULL),
("31450","image-optimization/cleanup/stuck-operation","complete","2025-11-24 05:58:12","2025-11-24 05:58:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763963892;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763963892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 06:02:44","2025-11-24 06:02:44","0",NULL),
("31451","image-optimization/cleanup/stuck-operation","complete","2025-11-24 06:07:44","2025-11-24 06:07:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763964464;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763964464;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 06:17:52","2025-11-24 06:17:52","0",NULL),
("31452","image-optimization/cleanup/stuck-operation","complete","2025-11-24 06:22:52","2025-11-24 06:22:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763965372;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763965372;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 06:27:31","2025-11-24 06:27:31","0",NULL),
("31453","image-optimization/cleanup/stuck-operation","complete","2025-11-24 06:32:31","2025-11-24 06:32:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763965951;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763965951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 06:37:21","2025-11-24 06:37:21","0",NULL),
("31454","image-optimization/cleanup/stuck-operation","complete","2025-11-24 06:42:21","2025-11-24 06:42:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763966541;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763966541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 06:45:52","2025-11-24 06:45:52","0",NULL),
("31455","image-optimization/cleanup/stuck-operation","complete","2025-11-24 06:50:52","2025-11-24 06:50:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763967052;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763967052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 06:58:45","2025-11-24 06:58:45","0",NULL),
("31456","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:03:45","2025-11-24 07:03:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763967825;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763967825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:06:20","2025-11-24 07:06:20","0",NULL),
("31457","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:11:20","2025-11-24 07:11:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763968280;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763968280;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:11:45","2025-11-24 07:11:45","0",NULL),
("31458","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:16:45","2025-11-24 07:16:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763968605;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763968605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:18:49","2025-11-24 07:18:49","0",NULL),
("31459","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:23:49","2025-11-24 07:23:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763969029;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763969029;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:26:44","2025-11-24 07:26:44","0",NULL),
("31460","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:31:44","2025-11-24 07:31:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763969504;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763969504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:32:09","2025-11-24 07:32:09","0",NULL),
("31461","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:37:09","2025-11-24 07:37:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763969829;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763969829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:39:20","2025-11-24 07:39:20","0",NULL),
("31462","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:44:20","2025-11-24 07:44:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763970260;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763970260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:45:41","2025-11-24 07:45:41","0",NULL),
("31463","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:50:41","2025-11-24 07:50:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763970641;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763970641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 07:53:04","2025-11-24 07:53:04","0",NULL),
("31464","image-optimization/cleanup/stuck-operation","complete","2025-11-24 07:58:04","2025-11-24 07:58:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763971084;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763971084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:02:37","2025-11-24 08:02:37","0",NULL),
("31465","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:07:37","2025-11-24 08:07:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763971657;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763971657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:12:43","2025-11-24 08:12:43","0",NULL),
("31466","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:17:43","2025-11-24 08:17:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763972263;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763972263;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:17:56","2025-11-24 08:17:56","0",NULL),
("31467","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:22:56","2025-11-24 08:22:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763972576;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763972576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:24:18","2025-11-24 08:24:18","0",NULL),
("31468","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:29:18","2025-11-24 08:29:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763972958;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763972958;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:30:34","2025-11-24 08:30:34","0",NULL),
("31469","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:35:34","2025-11-24 08:35:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763973334;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763973334;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:36:05","2025-11-24 08:36:05","0",NULL),
("31470","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:41:05","2025-11-24 08:41:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763973665;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763973665;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:42:56","2025-11-24 08:42:56","0",NULL),
("31471","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:47:56","2025-11-24 08:47:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763974076;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763974076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:48:47","2025-11-24 08:48:47","0",NULL),
("31472","image-optimization/cleanup/stuck-operation","complete","2025-11-24 08:53:47","2025-11-24 08:53:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763974427;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763974427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 08:56:15","2025-11-24 08:56:15","0",NULL),
("31473","image-optimization/cleanup/stuck-operation","complete","2025-11-24 09:01:15","2025-11-24 09:01:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763974875;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763974875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 09:01:37","2025-11-24 09:01:37","0",NULL),
("31474","image-optimization/cleanup/stuck-operation","complete","2025-11-24 09:06:37","2025-11-24 09:06:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763975197;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763975197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 09:11:06","2025-11-24 09:11:06","0",NULL),
("31475","image-optimization/cleanup/stuck-operation","complete","2025-11-24 09:16:06","2025-11-24 09:16:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763975766;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763975766;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 09:21:17","2025-11-24 09:21:17","0",NULL),
("31476","image-optimization/cleanup/stuck-operation","complete","2025-11-24 09:26:17","2025-11-24 09:26:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763976377;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763976377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 09:30:52","2025-11-24 09:30:52","0",NULL),
("31477","image-optimization/cleanup/stuck-operation","complete","2025-11-24 09:35:52","2025-11-24 09:35:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763976952;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763976952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 09:37:49","2025-11-24 09:37:49","0",NULL),
("31478","image-optimization/cleanup/stuck-operation","complete","2025-11-24 09:42:49","2025-11-24 09:42:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763977369;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763977369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 10:05:23","2025-11-24 10:05:23","0",NULL),
("31479","image-optimization/cleanup/stuck-operation","complete","2025-11-24 10:10:23","2025-11-24 10:10:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763979023;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763979023;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 10:14:59","2025-11-24 10:14:59","0",NULL),
("31480","image-optimization/cleanup/stuck-operation","complete","2025-11-24 10:19:59","2025-11-24 10:19:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763979599;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763979599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 10:35:23","2025-11-24 10:35:23","0",NULL),
("31481","image-optimization/cleanup/stuck-operation","complete","2025-11-24 10:40:23","2025-11-24 10:40:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763980823;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763980823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 10:42:05","2025-11-24 10:42:05","0",NULL),
("31482","image-optimization/cleanup/stuck-operation","complete","2025-11-24 10:47:05","2025-11-24 10:47:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763981225;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763981225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 10:54:04","2025-11-24 10:54:04","0",NULL),
("31483","image-optimization/cleanup/stuck-operation","complete","2025-11-24 10:59:04","2025-11-24 10:59:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763981944;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763981944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:03:15","2025-11-24 11:03:15","0",NULL),
("31484","image-optimization/cleanup/stuck-operation","complete","2025-11-24 11:08:15","2025-11-24 11:08:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763982495;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763982495;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:10:59","2025-11-24 11:10:59","0",NULL),
("31485","image-optimization/cleanup/stuck-operation","complete","2025-11-24 11:15:59","2025-11-24 11:15:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763982959;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763982959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:18:21","2025-11-24 11:18:21","0",NULL),
("31486","image-optimization/cleanup/stuck-operation","complete","2025-11-24 11:23:21","2025-11-24 11:23:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763983401;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763983401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:30:36","2025-11-24 11:30:36","0",NULL),
("31487","image-optimization/cleanup/stuck-operation","complete","2025-11-24 11:35:36","2025-11-24 11:35:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763984136;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763984136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:39:52","2025-11-24 11:39:52","0",NULL),
("31488","image-optimization/cleanup/stuck-operation","complete","2025-11-24 11:44:52","2025-11-24 11:44:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763984692;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763984692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:46:50","2025-11-24 11:46:50","0",NULL),
("31489","image-optimization/cleanup/stuck-operation","complete","2025-11-24 11:51:50","2025-11-24 11:51:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763985110;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763985110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 11:55:19","2025-11-24 11:55:19","0",NULL),
("31490","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:00:19","2025-11-24 12:00:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763985619;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763985619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:03:52","2025-11-24 12:03:52","0",NULL),
("31491","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:08:52","2025-11-24 12:08:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763986132;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763986132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:10:34","2025-11-24 12:10:34","0",NULL),
("31492","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:15:34","2025-11-24 12:15:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763986534;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763986534;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:16:35","2025-11-24 12:16:35","0",NULL),
("31493","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:21:35","2025-11-24 12:21:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763986895;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763986895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:24:28","2025-11-24 12:24:28","0",NULL),
("31494","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:29:31","2025-11-24 12:29:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763987371;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763987371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:30:05","2025-11-24 12:30:05","0",NULL),
("31495","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:35:05","2025-11-24 12:35:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763987705;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763987705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:36:27","2025-11-24 12:36:27","0",NULL),
("31496","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:41:27","2025-11-24 12:41:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763988087;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763988087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:46:03","2025-11-24 12:46:03","0",NULL),
("31497","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:51:03","2025-11-24 12:51:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763988663;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763988663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:51:52","2025-11-24 12:51:52","0",NULL),
("31498","image-optimization/cleanup/stuck-operation","complete","2025-11-24 12:56:52","2025-11-24 12:56:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763989012;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763989012;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 12:59:27","2025-11-24 12:59:27","0",NULL),
("31499","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:04:27","2025-11-24 13:04:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763989467;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763989467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:12:27","2025-11-24 13:12:27","0",NULL),
("31500","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:17:27","2025-11-24 13:17:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763990247;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763990247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:17:53","2025-11-24 13:17:53","0",NULL),
("31501","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:22:53","2025-11-24 13:22:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763990573;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763990573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:23:49","2025-11-24 13:23:49","0",NULL),
("31502","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:28:49","2025-11-24 13:28:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763990929;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763990929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:29:57","2025-11-24 13:29:57","0",NULL),
("31503","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:34:57","2025-11-24 13:34:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763991297;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763991297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:38:24","2025-11-24 13:38:24","0",NULL),
("31504","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:43:24","2025-11-24 13:43:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763991804;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763991804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:44:13","2025-11-24 13:44:13","0",NULL),
("31505","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:49:13","2025-11-24 13:49:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763992153;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763992153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:50:31","2025-11-24 13:50:31","0",NULL),
("31506","image-optimization/cleanup/stuck-operation","complete","2025-11-24 13:55:31","2025-11-24 13:55:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763992531;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763992531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 13:56:25","2025-11-24 13:56:25","0",NULL),
("31507","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:01:25","2025-11-24 14:01:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763992885;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763992885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:06:17","2025-11-24 14:06:17","0",NULL),
("31508","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:11:17","2025-11-24 14:11:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763993477;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763993477;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:11:48","2025-11-24 14:11:48","0",NULL),
("31509","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:16:48","2025-11-24 14:16:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763993808;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763993808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:20:26","2025-11-24 14:20:26","0",NULL),
("31510","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:25:26","2025-11-24 14:25:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763994326;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763994326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:30:48","2025-11-24 14:30:48","0",NULL),
("31511","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:35:48","2025-11-24 14:35:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763994948;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763994948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:36:44","2025-11-24 14:36:44","0",NULL),
("31512","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:41:44","2025-11-24 14:41:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763995304;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763995304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:47:39","2025-11-24 14:47:39","0",NULL),
("31513","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:52:39","2025-11-24 14:52:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763995959;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763995959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:54:06","2025-11-24 14:54:06","0",NULL),
("31514","image-optimization/cleanup/stuck-operation","complete","2025-11-24 14:59:06","2025-11-24 14:59:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763996346;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763996346;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 14:59:46","2025-11-24 14:59:46","0",NULL),
("31515","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:04:46","2025-11-24 15:04:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763996686;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763996686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:07:23","2025-11-24 15:07:23","0",NULL),
("31516","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:12:23","2025-11-24 15:12:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763997143;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763997143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:17:30","2025-11-24 15:17:30","0",NULL),
("31517","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:22:30","2025-11-24 15:22:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763997750;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763997750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:22:55","2025-11-24 15:22:55","0",NULL),
("31518","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:27:55","2025-11-24 15:27:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763998075;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763998075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:30:41","2025-11-24 15:30:41","0",NULL),
("31519","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:35:41","2025-11-24 15:35:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763998541;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763998541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:36:41","2025-11-24 15:36:41","0",NULL),
("31520","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:41:41","2025-11-24 15:41:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763998901;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763998901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:41:55","2025-11-24 15:41:55","0",NULL),
("31521","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:46:55","2025-11-24 15:46:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763999215;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763999215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 15:49:00","2025-11-24 15:49:00","0",NULL),
("31522","image-optimization/cleanup/stuck-operation","complete","2025-11-24 15:54:00","2025-11-24 15:54:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1763999640;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1763999640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 16:03:18","2025-11-24 16:03:18","0",NULL),
("31523","image-optimization/cleanup/stuck-operation","complete","2025-11-24 16:08:18","2025-11-24 16:08:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764000498;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764000498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 16:13:59","2025-11-24 16:13:59","0",NULL),
("31524","image-optimization/cleanup/stuck-operation","complete","2025-11-24 16:18:59","2025-11-24 16:18:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764001139;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764001139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 16:24:41","2025-11-24 16:24:41","0",NULL),
("31525","image-optimization/cleanup/stuck-operation","complete","2025-11-24 16:29:41","2025-11-24 16:29:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764001781;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764001781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 16:31:21","2025-11-24 16:31:21","0",NULL),
("31526","image-optimization/cleanup/stuck-operation","complete","2025-11-24 16:36:21","2025-11-24 16:36:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764002181;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764002181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 16:51:45","2025-11-24 16:51:45","0",NULL),
("31527","image-optimization/cleanup/stuck-operation","complete","2025-11-24 16:56:45","2025-11-24 16:56:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764003405;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764003405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 16:59:24","2025-11-24 16:59:24","0",NULL),
("31528","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:04:24","2025-11-24 17:04:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764003864;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764003864;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:04:52","2025-11-24 17:04:52","0",NULL),
("31529","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:09:52","2025-11-24 17:09:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764004192;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764004192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:10:26","2025-11-24 17:10:26","0",NULL),
("31530","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:15:26","2025-11-24 17:15:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764004526;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764004526;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:18:45","2025-11-24 17:18:45","0",NULL),
("31531","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:23:45","2025-11-24 17:23:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764005025;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764005025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:25:33","2025-11-24 17:25:33","0",NULL),
("31532","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:30:33","2025-11-24 17:30:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764005433;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764005433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:37:12","2025-11-24 17:37:12","0",NULL),
("31533","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:42:12","2025-11-24 17:42:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764006132;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764006132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:42:29","2025-11-24 17:42:29","0",NULL),
("31534","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:47:29","2025-11-24 17:47:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764006449;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764006449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:48:54","2025-11-24 17:48:54","0",NULL),
("31535","image-optimization/cleanup/stuck-operation","complete","2025-11-24 17:53:54","2025-11-24 17:53:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764006834;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764006834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 17:55:52","2025-11-24 17:55:52","0",NULL),
("31536","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:00:52","2025-11-24 18:00:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764007252;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764007252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:01:59","2025-11-24 18:01:59","0",NULL),
("31537","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:06:59","2025-11-24 18:06:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764007619;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764007619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:10:00","2025-11-24 18:10:00","0",NULL),
("31538","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:15:00","2025-11-24 18:15:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764008100;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764008100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:17:50","2025-11-24 18:17:50","0",NULL),
("31539","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:22:50","2025-11-24 18:22:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764008570;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764008570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:23:59","2025-11-24 18:23:59","0",NULL),
("31540","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:28:59","2025-11-24 18:28:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764008939;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764008939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:36:47","2025-11-24 18:36:47","0",NULL),
("31541","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:41:47","2025-11-24 18:41:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764009707;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764009707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:49:54","2025-11-24 18:49:54","0",NULL),
("31542","image-optimization/cleanup/stuck-operation","complete","2025-11-24 18:54:54","2025-11-24 18:54:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764010494;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764010494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 18:55:21","2025-11-24 18:55:21","0",NULL),
("31543","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:00:21","2025-11-24 19:00:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764010821;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764010821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:01:58","2025-11-24 19:01:58","0",NULL),
("31544","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:06:58","2025-11-24 19:06:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764011218;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764011218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:07:34","2025-11-24 19:07:34","0",NULL),
("31545","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:12:34","2025-11-24 19:12:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764011554;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764011554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:15:37","2025-11-24 19:15:37","0",NULL),
("31546","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:20:37","2025-11-24 19:20:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764012037;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764012037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:25:09","2025-11-24 19:25:09","0",NULL),
("31547","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:30:09","2025-11-24 19:30:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764012609;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764012609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:30:58","2025-11-24 19:30:58","0",NULL),
("31548","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:35:58","2025-11-24 19:35:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764012958;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764012958;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:38:40","2025-11-24 19:38:40","0",NULL),
("31549","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:43:40","2025-11-24 19:43:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764013420;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764013420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:44:04","2025-11-24 19:44:04","0",NULL),
("31550","image-optimization/cleanup/stuck-operation","complete","2025-11-24 19:49:04","2025-11-24 19:49:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764013744;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764013744;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 19:58:49","2025-11-24 19:58:49","0",NULL),
("31551","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:03:49","2025-11-24 20:03:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764014629;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764014629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:05:33","2025-11-24 20:05:33","0",NULL),
("31552","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:10:33","2025-11-24 20:10:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764015033;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764015033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:12:07","2025-11-24 20:12:07","0",NULL),
("31553","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:17:07","2025-11-24 20:17:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764015427;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764015427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:18:34","2025-11-24 20:18:34","0",NULL),
("31554","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:23:34","2025-11-24 20:23:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764015814;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764015814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:25:14","2025-11-24 20:25:14","0",NULL),
("31555","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:30:14","2025-11-24 20:30:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764016214;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764016214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:34:01","2025-11-24 20:34:01","0",NULL),
("31556","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:39:01","2025-11-24 20:39:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764016741;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764016741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:49:56","2025-11-24 20:49:56","0",NULL),
("31557","image-optimization/cleanup/stuck-operation","complete","2025-11-24 20:54:56","2025-11-24 20:54:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764017696;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764017696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 20:56:58","2025-11-24 20:56:58","0",NULL),
("31558","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:01:58","2025-11-24 21:01:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764018118;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764018118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:03:27","2025-11-24 21:03:27","0",NULL),
("31559","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:08:35","2025-11-24 21:08:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764018515;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764018515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:11:05","2025-11-24 21:11:05","0",NULL),
("31560","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:16:05","2025-11-24 21:16:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764018965;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764018965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:17:00","2025-11-24 21:17:00","0",NULL),
("31561","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:22:00","2025-11-24 21:22:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764019320;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764019320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:22:32","2025-11-24 21:22:32","0",NULL),
("31562","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:27:32","2025-11-24 21:27:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764019652;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764019652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:27:55","2025-11-24 21:27:55","0",NULL),
("31563","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:32:55","2025-11-24 21:32:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764019975;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764019975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:33:50","2025-11-24 21:33:50","0",NULL),
("31564","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:38:50","2025-11-24 21:38:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764020330;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764020330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:39:20","2025-11-24 21:39:20","0",NULL),
("31565","image-optimization/cleanup/stuck-operation","complete","2025-11-24 21:44:20","2025-11-24 21:44:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764020660;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764020660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 21:55:50","2025-11-24 21:55:50","0",NULL),
("31566","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:00:50","2025-11-24 22:00:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764021650;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764021650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:02:41","2025-11-24 22:02:41","0",NULL),
("31567","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:07:41","2025-11-24 22:07:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764022061;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764022061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:10:06","2025-11-24 22:10:06","0",NULL),
("31568","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:15:06","2025-11-24 22:15:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764022506;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764022506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:16:05","2025-11-24 22:16:05","0",NULL),
("31569","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:21:05","2025-11-24 22:21:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764022865;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764022865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:23:12","2025-11-24 22:23:12","0",NULL),
("31570","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:28:12","2025-11-24 22:28:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764023292;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764023292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:32:07","2025-11-24 22:32:07","0",NULL),
("31571","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:37:08","2025-11-24 22:37:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764023828;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764023828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:38:20","2025-11-24 22:38:20","0",NULL),
("31572","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:43:20","2025-11-24 22:43:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764024200;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764024200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:44:00","2025-11-24 22:44:00","0",NULL),
("31573","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:49:00","2025-11-24 22:49:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764024540;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764024540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:50:19","2025-11-24 22:50:19","0",NULL),
("31574","image-optimization/cleanup/stuck-operation","complete","2025-11-24 22:55:19","2025-11-24 22:55:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764024919;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764024919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 22:57:23","2025-11-24 22:57:23","0",NULL),
("31575","image-optimization/cleanup/stuck-operation","complete","2025-11-24 23:02:23","2025-11-24 23:02:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764025343;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764025343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 23:05:09","2025-11-24 23:05:09","0",NULL),
("31576","image-optimization/cleanup/stuck-operation","complete","2025-11-24 23:10:09","2025-11-24 23:10:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764025809;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764025809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 23:14:20","2025-11-24 23:14:20","0",NULL),
("31577","image-optimization/cleanup/stuck-operation","complete","2025-11-24 23:19:20","2025-11-24 23:19:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764026360;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764026360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 23:37:16","2025-11-24 23:37:16","0",NULL),
("31578","image-optimization/cleanup/stuck-operation","complete","2025-11-24 23:42:16","2025-11-24 23:42:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764027736;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764027736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 23:43:31","2025-11-24 23:43:31","0",NULL),
("31579","image-optimization/cleanup/stuck-operation","complete","2025-11-24 23:48:31","2025-11-24 23:48:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764028111;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764028111;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 23:49:15","2025-11-24 23:49:15","0",NULL),
("31580","image-optimization/cleanup/stuck-operation","complete","2025-11-24 23:54:15","2025-11-24 23:54:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764028455;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764028455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-24 23:56:55","2025-11-24 23:56:55","0",NULL),
("31581","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:01:55","2025-11-25 00:01:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764028915;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764028915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:04:11","2025-11-25 00:04:11","0",NULL),
("31582","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:09:11","2025-11-25 00:09:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764029351;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764029351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:15:31","2025-11-25 00:15:31","0",NULL),
("31583","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:20:31","2025-11-25 00:20:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764030031;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764030031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:23:43","2025-11-25 00:23:43","0",NULL),
("31584","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:28:43","2025-11-25 00:28:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764030523;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764030523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:30:52","2025-11-25 00:30:52","0",NULL),
("31585","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:35:52","2025-11-25 00:35:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764030952;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764030952;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:37:08","2025-11-25 00:37:08","0",NULL),
("31586","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:42:08","2025-11-25 00:42:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764031328;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764031328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:44:13","2025-11-25 00:44:13","0",NULL),
("31587","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:49:13","2025-11-25 00:49:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764031753;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764031753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:51:32","2025-11-25 00:51:32","0",NULL),
("31588","image-optimization/cleanup/stuck-operation","complete","2025-11-25 00:56:32","2025-11-25 00:56:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764032192;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764032192;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 00:57:33","2025-11-25 00:57:33","0",NULL),
("31589","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:02:33","2025-11-25 01:02:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764032553;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764032553;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:03:07","2025-11-25 01:03:07","0",NULL),
("31590","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:08:07","2025-11-25 01:08:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764032887;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764032887;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:15:44","2025-11-25 01:15:44","0",NULL),
("31591","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:20:44","2025-11-25 01:20:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764033644;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764033644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:22:45","2025-11-25 01:22:45","0",NULL),
("31592","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:27:45","2025-11-25 01:27:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764034065;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764034065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:30:27","2025-11-25 01:30:27","0",NULL),
("31593","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:35:27","2025-11-25 01:35:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764034527;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764034527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:37:59","2025-11-25 01:37:59","0",NULL),
("31594","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:42:59","2025-11-25 01:42:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764034979;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764034979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:43:15","2025-11-25 01:43:15","0",NULL),
("31595","image-optimization/cleanup/stuck-operation","complete","2025-11-25 01:48:15","2025-11-25 01:48:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764035295;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764035295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 01:55:11","2025-11-25 01:55:11","0",NULL),
("31596","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:00:11","2025-11-25 02:00:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764036011;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764036011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:01:43","2025-11-25 02:01:43","0",NULL),
("31597","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:06:43","2025-11-25 02:06:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764036403;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764036403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:09:05","2025-11-25 02:09:05","0",NULL),
("31598","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:14:05","2025-11-25 02:14:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764036845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764036845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:16:43","2025-11-25 02:16:43","0",NULL),
("31599","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:21:43","2025-11-25 02:21:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764037303;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764037303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:25:17","2025-11-25 02:25:17","0",NULL),
("31600","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:30:17","2025-11-25 02:30:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764037817;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764037817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:31:28","2025-11-25 02:31:28","0",NULL),
("31601","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:36:28","2025-11-25 02:36:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764038188;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764038188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:38:13","2025-11-25 02:38:13","0",NULL),
("31602","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:43:13","2025-11-25 02:43:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764038593;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764038593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:44:08","2025-11-25 02:44:08","0",NULL),
("31603","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:49:08","2025-11-25 02:49:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764038948;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764038948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 02:52:48","2025-11-25 02:52:48","0",NULL),
("31604","image-optimization/cleanup/stuck-operation","complete","2025-11-25 02:57:48","2025-11-25 02:57:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764039468;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764039468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:01:45","2025-11-25 03:01:45","0",NULL),
("31605","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:06:45","2025-11-25 03:06:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764040005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764040005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:11:15","2025-11-25 03:11:15","0",NULL),
("31606","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:16:15","2025-11-25 03:16:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764040575;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764040575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:17:54","2025-11-25 03:17:54","0",NULL),
("31607","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:22:54","2025-11-25 03:22:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764040974;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764040974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:24:19","2025-11-25 03:24:19","0",NULL),
("31608","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:29:19","2025-11-25 03:29:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764041359;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764041359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:29:52","2025-11-25 03:29:52","0",NULL),
("31609","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:34:52","2025-11-25 03:34:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764041692;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764041692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:39:04","2025-11-25 03:39:04","0",NULL),
("31610","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:44:04","2025-11-25 03:44:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764042244;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764042244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:44:51","2025-11-25 03:44:51","0",NULL),
("31611","image-optimization/cleanup/stuck-operation","complete","2025-11-25 03:49:51","2025-11-25 03:49:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764042591;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764042591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 03:55:34","2025-11-25 03:55:34","0",NULL),
("31612","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:00:34","2025-11-25 04:00:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764043234;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764043234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:02:10","2025-11-25 04:02:10","0",NULL),
("31613","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:07:10","2025-11-25 04:07:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764043630;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764043630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:09:16","2025-11-25 04:09:16","0",NULL),
("31614","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:14:16","2025-11-25 04:14:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764044056;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764044056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:14:35","2025-11-25 04:14:35","0",NULL),
("31615","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:19:35","2025-11-25 04:19:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764044375;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764044375;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:27:38","2025-11-25 04:27:38","0",NULL),
("31616","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:32:38","2025-11-25 04:32:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764045158;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764045158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:33:38","2025-11-25 04:33:38","0",NULL),
("31617","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:38:38","2025-11-25 04:38:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764045518;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764045518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:45:23","2025-11-25 04:45:23","0",NULL),
("31618","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:50:23","2025-11-25 04:50:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764046223;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764046223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:50:38","2025-11-25 04:50:38","0",NULL),
("31619","image-optimization/cleanup/stuck-operation","complete","2025-11-25 04:55:38","2025-11-25 04:55:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764046538;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764046538;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 04:58:41","2025-11-25 04:58:41","0",NULL),
("31620","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:03:41","2025-11-25 05:03:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764047021;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764047021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:04:29","2025-11-25 05:04:29","0",NULL),
("31621","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:09:29","2025-11-25 05:09:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764047369;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764047369;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:11:47","2025-11-25 05:11:47","0",NULL),
("31622","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:16:47","2025-11-25 05:16:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764047807;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764047807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:20:32","2025-11-25 05:20:32","0",NULL),
("31623","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:25:32","2025-11-25 05:25:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764048332;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764048332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:26:54","2025-11-25 05:26:54","0",NULL),
("31624","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:31:54","2025-11-25 05:31:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764048714;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764048714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:32:24","2025-11-25 05:32:24","0",NULL),
("31625","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:37:24","2025-11-25 05:37:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764049044;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764049044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:41:19","2025-11-25 05:41:19","0",NULL),
("31626","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:46:19","2025-11-25 05:46:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764049579;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764049579;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 05:50:19","2025-11-25 05:50:19","0",NULL),
("31627","image-optimization/cleanup/stuck-operation","complete","2025-11-25 05:55:19","2025-11-25 05:55:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764050119;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764050119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:04:35","2025-11-25 06:04:35","0",NULL),
("31628","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:09:35","2025-11-25 06:09:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764050975;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764050975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:10:46","2025-11-25 06:10:46","0",NULL),
("31629","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:15:46","2025-11-25 06:15:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764051346;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764051346;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:17:30","2025-11-25 06:17:30","0",NULL),
("31630","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:22:30","2025-11-25 06:22:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764051750;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764051750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:23:51","2025-11-25 06:23:51","0",NULL),
("31631","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:28:51","2025-11-25 06:28:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764052131;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764052131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:36:44","2025-11-25 06:36:44","0",NULL),
("31632","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:41:44","2025-11-25 06:41:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764052904;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764052904;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:42:12","2025-11-25 06:42:12","0",NULL),
("31633","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:47:12","2025-11-25 06:47:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764053232;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764053232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 06:48:14","2025-11-25 06:48:14","0",NULL),
("31634","image-optimization/cleanup/stuck-operation","complete","2025-11-25 06:53:14","2025-11-25 06:53:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764053594;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764053594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:02:06","2025-11-25 07:02:06","0",NULL),
("31635","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:07:12","2025-11-25 07:07:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764054432;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764054432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:08:35","2025-11-25 07:08:35","0",NULL),
("31636","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:13:35","2025-11-25 07:13:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764054815;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764054815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:15:08","2025-11-25 07:15:08","0",NULL),
("31637","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:20:08","2025-11-25 07:20:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764055208;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764055208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:21:43","2025-11-25 07:21:43","0",NULL),
("31638","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:26:43","2025-11-25 07:26:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764055603;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764055603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:30:31","2025-11-25 07:30:31","0",NULL),
("31639","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:35:31","2025-11-25 07:35:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764056131;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764056131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:38:48","2025-11-25 07:38:48","0",NULL),
("31640","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:43:49","2025-11-25 07:43:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764056629;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764056629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:44:09","2025-11-25 07:44:09","0",NULL),
("31641","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:49:09","2025-11-25 07:49:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764056949;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764056949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:50:07","2025-11-25 07:50:07","0",NULL),
("31642","image-optimization/cleanup/stuck-operation","complete","2025-11-25 07:55:07","2025-11-25 07:55:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764057307;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764057307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 07:56:02","2025-11-25 07:56:02","0",NULL),
("31643","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:01:02","2025-11-25 08:01:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764057662;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764057662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:03:05","2025-11-25 08:03:05","0",NULL),
("31644","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:08:05","2025-11-25 08:08:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764058085;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764058085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:09:41","2025-11-25 08:09:41","0",NULL),
("31645","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:14:41","2025-11-25 08:14:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764058481;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764058481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:19:08","2025-11-25 08:19:08","0",NULL),
("31646","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:24:08","2025-11-25 08:24:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764059048;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764059048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:29:26","2025-11-25 08:29:26","0",NULL),
("31647","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:34:26","2025-11-25 08:34:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764059666;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764059666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:37:27","2025-11-25 08:37:27","0",NULL),
("31648","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:42:27","2025-11-25 08:42:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764060147;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764060147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:46:01","2025-11-25 08:46:01","0",NULL),
("31649","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:51:01","2025-11-25 08:51:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764060661;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764060661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 08:52:46","2025-11-25 08:52:46","0",NULL),
("31650","image-optimization/cleanup/stuck-operation","complete","2025-11-25 08:57:46","2025-11-25 08:57:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764061066;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764061066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:01:03","2025-11-25 09:01:03","0",NULL),
("31651","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:06:03","2025-11-25 09:06:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764061563;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764061563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:06:59","2025-11-25 09:06:59","0",NULL),
("31652","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:11:59","2025-11-25 09:11:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764061919;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764061919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:15:11","2025-11-25 09:15:11","0",NULL),
("31653","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:20:11","2025-11-25 09:20:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764062411;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764062411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:26:34","2025-11-25 09:26:34","0",NULL),
("31654","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:31:34","2025-11-25 09:31:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764063094;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764063094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:33:10","2025-11-25 09:33:10","0",NULL),
("31655","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:38:10","2025-11-25 09:38:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764063490;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764063490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:41:45","2025-11-25 09:41:45","0",NULL),
("31656","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:46:45","2025-11-25 09:46:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764064005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764064005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 09:48:14","2025-11-25 09:48:14","0",NULL),
("31657","image-optimization/cleanup/stuck-operation","complete","2025-11-25 09:53:14","2025-11-25 09:53:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764064394;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764064394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:02:16","2025-11-25 10:02:16","0",NULL),
("31658","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:07:16","2025-11-25 10:07:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764065236;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764065236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:09:12","2025-11-25 10:09:12","0",NULL),
("31659","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:14:12","2025-11-25 10:14:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764065652;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764065652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:14:49","2025-11-25 10:14:49","0",NULL),
("31660","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:19:49","2025-11-25 10:19:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764065989;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764065989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:20:26","2025-11-25 10:20:26","0",NULL),
("31661","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:25:26","2025-11-25 10:25:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764066326;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764066326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:41:05","2025-11-25 10:41:05","0",NULL),
("31662","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:46:10","2025-11-25 10:46:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764067570;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764067570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:47:30","2025-11-25 10:47:30","0",NULL),
("31663","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:52:30","2025-11-25 10:52:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764067950;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764067950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 10:54:09","2025-11-25 10:54:09","0",NULL),
("31664","image-optimization/cleanup/stuck-operation","complete","2025-11-25 10:59:09","2025-11-25 10:59:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764068349;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764068349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:01:40","2025-11-25 11:01:40","0",NULL),
("31665","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:06:40","2025-11-25 11:06:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764068800;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764068800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:10:16","2025-11-25 11:10:16","0",NULL),
("31666","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:15:16","2025-11-25 11:15:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764069316;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764069316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:16:22","2025-11-25 11:16:22","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("31667","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:21:22","2025-11-25 11:21:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764069682;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764069682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:23:55","2025-11-25 11:23:55","0",NULL),
("31668","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:28:55","2025-11-25 11:28:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764070135;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764070135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:30:11","2025-11-25 11:30:11","0",NULL),
("31669","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:35:11","2025-11-25 11:35:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764070511;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764070511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:37:09","2025-11-25 11:37:09","0",NULL),
("31670","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:42:09","2025-11-25 11:42:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764070929;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764070929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:46:10","2025-11-25 11:46:10","0",NULL),
("31671","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:51:10","2025-11-25 11:51:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764071470;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764071470;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 11:51:53","2025-11-25 11:51:53","0",NULL),
("31672","image-optimization/cleanup/stuck-operation","complete","2025-11-25 11:56:53","2025-11-25 11:56:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764071813;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764071813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:03:34","2025-11-25 12:03:34","0",NULL),
("31673","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:08:35","2025-11-25 12:08:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764072515;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764072515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:11:21","2025-11-25 12:11:21","0",NULL),
("31674","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:16:21","2025-11-25 12:16:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764072981;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764072981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:18:55","2025-11-25 12:18:55","0",NULL),
("31675","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:23:55","2025-11-25 12:23:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764073435;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764073435;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:25:07","2025-11-25 12:25:07","0",NULL),
("31676","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:30:07","2025-11-25 12:30:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764073807;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764073807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:32:05","2025-11-25 12:32:05","0",NULL),
("31677","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:37:05","2025-11-25 12:37:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764074225;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764074225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:46:45","2025-11-25 12:46:45","0",NULL),
("31678","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:51:45","2025-11-25 12:51:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764075105;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764075105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 12:54:30","2025-11-25 12:54:30","0",NULL),
("31679","image-optimization/cleanup/stuck-operation","complete","2025-11-25 12:59:30","2025-11-25 12:59:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764075570;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764075570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:00:18","2025-11-25 13:00:18","0",NULL),
("31680","image-optimization/cleanup/stuck-operation","complete","2025-11-25 13:05:31","2025-11-25 13:05:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764075931;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764075931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:06:18","2025-11-25 13:06:18","0",NULL),
("31681","image-optimization/cleanup/stuck-operation","complete","2025-11-25 13:11:18","2025-11-25 13:11:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764076278;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764076278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:20:04","2025-11-25 13:20:04","0",NULL),
("31682","image-optimization/cleanup/stuck-operation","complete","2025-11-25 13:25:04","2025-11-25 13:25:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764077104;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764077104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:32:38","2025-11-25 13:32:38","0",NULL),
("31683","image-optimization/cleanup/stuck-operation","complete","2025-11-25 13:37:38","2025-11-25 13:37:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764077858;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764077858;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:41:37","2025-11-25 13:41:37","0",NULL),
("31684","image-optimization/cleanup/stuck-operation","complete","2025-11-25 13:46:37","2025-11-25 13:46:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764078397;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764078397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:49:55","2025-11-25 13:49:55","0",NULL),
("31685","image-optimization/cleanup/stuck-operation","complete","2025-11-25 13:54:55","2025-11-25 13:54:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764078895;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764078895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 13:55:23","2025-11-25 13:55:23","0",NULL),
("31686","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:00:23","2025-11-25 14:00:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764079223;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764079223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:00:40","2025-11-25 14:00:40","0",NULL),
("31687","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:05:40","2025-11-25 14:05:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764079540;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764079540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:05:52","2025-11-25 14:05:52","0",NULL),
("31688","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:10:52","2025-11-25 14:10:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764079852;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764079852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:13:44","2025-11-25 14:13:44","0",NULL),
("31689","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:18:44","2025-11-25 14:18:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764080324;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764080324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:20:16","2025-11-25 14:20:16","0",NULL),
("31690","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:25:42","2025-11-25 14:25:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764080742;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764080742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:26:51","2025-11-25 14:26:51","0",NULL),
("31691","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:31:51","2025-11-25 14:31:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764081111;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764081111;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:33:25","2025-11-25 14:33:25","0",NULL),
("31692","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:38:25","2025-11-25 14:38:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764081505;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764081505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:41:31","2025-11-25 14:41:31","0",NULL),
("31693","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:46:31","2025-11-25 14:46:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764081991;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764081991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:48:00","2025-11-25 14:48:00","0",NULL),
("31694","image-optimization/cleanup/stuck-operation","complete","2025-11-25 14:53:00","2025-11-25 14:53:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764082380;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764082380;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 14:58:57","2025-11-25 14:58:57","0",NULL),
("31695","image-optimization/cleanup/stuck-operation","complete","2025-11-25 15:03:57","2025-11-25 15:03:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764083037;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764083037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 15:07:32","2025-11-25 15:07:32","0",NULL),
("31696","image-optimization/cleanup/stuck-operation","complete","2025-11-25 15:12:32","2025-11-25 15:12:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764083552;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764083552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 15:15:25","2025-11-25 15:15:25","0",NULL),
("31697","image-optimization/cleanup/stuck-operation","complete","2025-11-25 15:20:25","2025-11-25 15:20:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084025;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 15:22:00","2025-11-25 15:22:00","0",NULL),
("31698","image-optimization/cleanup/stuck-operation","complete","2025-11-25 15:27:00","2025-11-25 15:27:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764084420;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764084420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 15:37:41","2025-11-25 15:37:41","0",NULL),
("31699","image-optimization/cleanup/stuck-operation","complete","2025-11-25 15:42:41","2025-11-25 15:42:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764085361;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764085361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 15:47:24","2025-11-25 15:47:24","0",NULL),
("31700","image-optimization/cleanup/stuck-operation","complete","2025-11-25 15:52:24","2025-11-25 15:52:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764085944;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764085944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 15:58:36","2025-11-25 15:58:36","0",NULL),
("31701","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:03:36","2025-11-25 16:03:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764086616;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764086616;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:05:43","2025-11-25 16:05:43","0",NULL),
("31702","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:10:43","2025-11-25 16:10:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764087043;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764087043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:19:36","2025-11-25 16:19:36","0",NULL),
("31703","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:24:36","2025-11-25 16:24:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764087876;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764087876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:26:36","2025-11-25 16:26:36","0",NULL),
("31704","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:31:36","2025-11-25 16:31:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764088296;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764088296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:36:08","2025-11-25 16:36:08","0",NULL),
("31705","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:41:08","2025-11-25 16:41:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764088868;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764088868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:41:23","2025-11-25 16:41:23","0",NULL),
("31706","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:46:23","2025-11-25 16:46:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764089183;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764089183;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:46:57","2025-11-25 16:46:57","0",NULL),
("31707","image-optimization/cleanup/stuck-operation","complete","2025-11-25 16:51:57","2025-11-25 16:51:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764089517;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764089517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 16:55:46","2025-11-25 16:55:46","0",NULL),
("31708","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:00:46","2025-11-25 17:00:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764090046;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764090046;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:01:08","2025-11-25 17:01:08","0",NULL),
("31709","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:06:08","2025-11-25 17:06:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764090368;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764090368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:10:37","2025-11-25 17:10:37","0",NULL),
("31710","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:15:37","2025-11-25 17:15:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764090937;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764090937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:16:44","2025-11-25 17:16:44","0",NULL),
("31711","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:21:44","2025-11-25 17:21:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764091304;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764091304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:21:57","2025-11-25 17:21:57","0",NULL),
("31712","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:26:57","2025-11-25 17:26:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764091617;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764091617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:27:23","2025-11-25 17:27:23","0",NULL),
("31713","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:32:23","2025-11-25 17:32:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764091943;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764091943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:35:29","2025-11-25 17:35:29","0",NULL),
("31714","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:40:29","2025-11-25 17:40:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764092429;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764092429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:42:46","2025-11-25 17:42:46","0",NULL),
("31715","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:47:46","2025-11-25 17:47:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764092866;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764092866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:50:21","2025-11-25 17:50:21","0",NULL),
("31716","image-optimization/cleanup/stuck-operation","complete","2025-11-25 17:55:21","2025-11-25 17:55:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764093321;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764093321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 17:56:08","2025-11-25 17:56:08","0",NULL),
("31717","image-optimization/cleanup/stuck-operation","complete","2025-11-25 18:01:08","2025-11-25 18:01:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764093668;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764093668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 18:03:37","2025-11-25 18:03:37","0",NULL),
("31718","image-optimization/cleanup/stuck-operation","complete","2025-11-25 18:08:37","2025-11-25 18:08:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764094117;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764094117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 18:10:34","2025-11-25 18:10:34","0",NULL),
("31719","image-optimization/cleanup/stuck-operation","complete","2025-11-25 18:15:34","2025-11-25 18:15:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764094534;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764094534;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 18:16:56","2025-11-25 18:16:56","0",NULL),
("31720","image-optimization/cleanup/stuck-operation","complete","2025-11-25 18:21:56","2025-11-25 18:21:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764094916;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764094916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 18:28:01","2025-11-25 18:28:01","0",NULL),
("31721","image-optimization/cleanup/stuck-operation","complete","2025-11-25 18:33:01","2025-11-25 18:33:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764095581;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764095581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 18:36:11","2025-11-25 18:36:11","0",NULL),
("31722","image-optimization/cleanup/stuck-operation","complete","2025-11-25 18:41:11","2025-11-25 18:41:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764096071;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764096071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 18:56:43","2025-11-25 18:56:43","0",NULL),
("31723","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:01:43","2025-11-25 19:01:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764097303;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764097303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:05:30","2025-11-25 19:05:30","0",NULL),
("31724","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:10:30","2025-11-25 19:10:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764097830;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764097830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:17:21","2025-11-25 19:17:21","0",NULL),
("31725","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:22:21","2025-11-25 19:22:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764098541;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764098541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:26:08","2025-11-25 19:26:08","0",NULL),
("31726","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:31:08","2025-11-25 19:31:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764099068;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764099068;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:32:14","2025-11-25 19:32:14","0",NULL),
("31727","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:37:14","2025-11-25 19:37:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764099434;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764099434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:37:44","2025-11-25 19:37:44","0",NULL),
("31728","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:42:44","2025-11-25 19:42:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764099764;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764099764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:44:08","2025-11-25 19:44:08","0",NULL),
("31729","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:49:08","2025-11-25 19:49:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764100148;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764100148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 19:50:35","2025-11-25 19:50:35","0",NULL),
("31730","image-optimization/cleanup/stuck-operation","complete","2025-11-25 19:55:35","2025-11-25 19:55:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764100535;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764100535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:03:53","2025-11-25 20:03:53","0",NULL),
("31731","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:08:53","2025-11-25 20:08:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764101333;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764101333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:11:48","2025-11-25 20:11:48","0",NULL),
("31732","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:16:48","2025-11-25 20:16:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764101808;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764101808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:20:06","2025-11-25 20:20:06","0",NULL),
("31733","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:25:06","2025-11-25 20:25:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764102306;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764102306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:31:13","2025-11-25 20:31:13","0",NULL),
("31734","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:36:13","2025-11-25 20:36:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764102973;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764102973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:36:38","2025-11-25 20:36:38","0",NULL),
("31735","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:41:38","2025-11-25 20:41:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764103298;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764103298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:42:35","2025-11-25 20:42:35","0",NULL),
("31736","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:47:35","2025-11-25 20:47:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764103655;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764103655;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:49:02","2025-11-25 20:49:02","0",NULL),
("31737","image-optimization/cleanup/stuck-operation","complete","2025-11-25 20:54:02","2025-11-25 20:54:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764104042;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764104042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 20:56:52","2025-11-25 20:56:52","0",NULL),
("31738","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:01:52","2025-11-25 21:01:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764104512;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764104512;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:03:05","2025-11-25 21:03:05","0",NULL),
("31739","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:08:05","2025-11-25 21:08:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764104885;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764104885;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:13:05","2025-11-25 21:13:05","0",NULL),
("31740","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:18:05","2025-11-25 21:18:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764105485;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764105485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:23:58","2025-11-25 21:23:58","0",NULL),
("31741","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:28:58","2025-11-25 21:28:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764106138;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764106138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:30:49","2025-11-25 21:30:49","0",NULL),
("31742","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:35:49","2025-11-25 21:35:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764106549;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764106549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:36:38","2025-11-25 21:36:38","0",NULL),
("31743","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:41:38","2025-11-25 21:41:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764106898;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764106898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:45:20","2025-11-25 21:45:20","0",NULL),
("31744","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:50:20","2025-11-25 21:50:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764107420;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764107420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:51:28","2025-11-25 21:51:28","0",NULL),
("31745","image-optimization/cleanup/stuck-operation","complete","2025-11-25 21:56:28","2025-11-25 21:56:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764107788;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764107788;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 21:59:35","2025-11-25 21:59:35","0",NULL),
("31746","image-optimization/cleanup/stuck-operation","complete","2025-11-25 22:04:35","2025-11-25 22:04:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764108275;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764108275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 22:07:03","2025-11-25 22:07:03","0",NULL),
("31747","image-optimization/cleanup/stuck-operation","complete","2025-11-25 22:12:03","2025-11-25 22:12:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764108723;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764108723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 22:19:52","2025-11-25 22:19:52","0",NULL),
("31748","image-optimization/cleanup/stuck-operation","complete","2025-11-25 22:24:52","2025-11-25 22:24:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764109492;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764109492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 22:32:37","2025-11-25 22:32:37","0",NULL),
("31749","image-optimization/cleanup/stuck-operation","complete","2025-11-25 22:37:37","2025-11-25 22:37:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764110257;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764110257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 22:39:33","2025-11-25 22:39:33","0",NULL),
("31750","image-optimization/cleanup/stuck-operation","complete","2025-11-25 22:44:33","2025-11-25 22:44:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764110673;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764110673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 22:46:58","2025-11-25 22:46:58","0",NULL),
("31751","image-optimization/cleanup/stuck-operation","complete","2025-11-25 22:51:58","2025-11-25 22:51:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764111118;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764111118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 23:03:26","2025-11-25 23:03:26","0",NULL),
("31752","image-optimization/cleanup/stuck-operation","complete","2025-11-25 23:08:26","2025-11-25 23:08:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764112106;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764112106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 23:15:45","2025-11-25 23:15:45","0",NULL),
("31753","image-optimization/cleanup/stuck-operation","complete","2025-11-25 23:20:45","2025-11-25 23:20:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764112845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764112845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 23:27:09","2025-11-25 23:27:09","0",NULL),
("31754","image-optimization/cleanup/stuck-operation","complete","2025-11-25 23:32:09","2025-11-25 23:32:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764113529;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764113529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 23:40:31","2025-11-25 23:40:31","0",NULL),
("31755","image-optimization/cleanup/stuck-operation","complete","2025-11-25 23:45:31","2025-11-25 23:45:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764114331;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764114331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 23:50:15","2025-11-25 23:50:15","0",NULL),
("31756","image-optimization/cleanup/stuck-operation","complete","2025-11-25 23:55:15","2025-11-25 23:55:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764114915;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764114915;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-25 23:58:04","2025-11-25 23:58:04","0",NULL),
("31757","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:03:04","2025-11-26 00:03:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764115384;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764115384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:03:38","2025-11-26 00:03:38","0",NULL),
("31758","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:08:38","2025-11-26 00:08:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764115718;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764115718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:11:28","2025-11-26 00:11:28","0",NULL),
("31759","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:16:28","2025-11-26 00:16:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764116188;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764116188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:16:40","2025-11-26 00:16:40","0",NULL),
("31760","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:21:40","2025-11-26 00:21:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764116500;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764116500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:22:30","2025-11-26 00:22:30","0",NULL),
("31761","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:27:30","2025-11-26 00:27:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764116850;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764116850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:28:59","2025-11-26 00:28:59","0",NULL),
("31762","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:33:59","2025-11-26 00:33:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764117239;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764117239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:36:34","2025-11-26 00:36:34","0",NULL),
("31763","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:41:34","2025-11-26 00:41:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764117694;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764117694;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 00:46:26","2025-11-26 00:46:26","0",NULL),
("31764","image-optimization/cleanup/stuck-operation","complete","2025-11-26 00:51:26","2025-11-26 00:51:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764118286;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764118286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:00:13","2025-11-26 01:00:13","0",NULL),
("31765","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:05:13","2025-11-26 01:05:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764119113;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764119113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:07:58","2025-11-26 01:07:58","0",NULL),
("31766","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:12:58","2025-11-26 01:12:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764119578;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764119578;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:14:45","2025-11-26 01:14:45","0",NULL),
("31767","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:19:45","2025-11-26 01:19:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764119985;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764119985;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:21:46","2025-11-26 01:21:46","0",NULL),
("31768","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:26:46","2025-11-26 01:26:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764120406;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764120406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:27:32","2025-11-26 01:27:32","0",NULL),
("31769","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:32:32","2025-11-26 01:32:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764120752;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764120752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:33:59","2025-11-26 01:33:59","0",NULL),
("31770","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:38:59","2025-11-26 01:38:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764121139;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764121139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:41:51","2025-11-26 01:41:51","0",NULL),
("31771","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:46:51","2025-11-26 01:46:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764121611;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764121611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:50:52","2025-11-26 01:50:52","0",NULL),
("31772","image-optimization/cleanup/stuck-operation","complete","2025-11-26 01:55:52","2025-11-26 01:55:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764122152;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764122152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 01:56:06","2025-11-26 01:56:06","0",NULL),
("31773","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:01:06","2025-11-26 02:01:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764122466;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764122466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:02:11","2025-11-26 02:02:11","0",NULL),
("31774","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:07:11","2025-11-26 02:07:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764122831;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764122831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:07:28","2025-11-26 02:07:28","0",NULL),
("31775","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:12:28","2025-11-26 02:12:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764123148;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764123148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:15:06","2025-11-26 02:15:06","0",NULL),
("31776","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:20:06","2025-11-26 02:20:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764123606;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764123606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:22:19","2025-11-26 02:22:19","0",NULL),
("31777","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:27:19","2025-11-26 02:27:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764124039;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764124039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:29:08","2025-11-26 02:29:08","0",NULL),
("31778","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:34:08","2025-11-26 02:34:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764124448;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764124448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:35:23","2025-11-26 02:35:23","0",NULL),
("31779","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:40:23","2025-11-26 02:40:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764124823;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764124823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:41:08","2025-11-26 02:41:08","0",NULL),
("31780","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:46:08","2025-11-26 02:46:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764125168;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764125168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:46:33","2025-11-26 02:46:33","0",NULL),
("31781","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:51:33","2025-11-26 02:51:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764125493;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764125493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 02:54:06","2025-11-26 02:54:06","0",NULL),
("31782","image-optimization/cleanup/stuck-operation","complete","2025-11-26 02:59:06","2025-11-26 02:59:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764125946;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764125946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:02:17","2025-11-26 03:02:17","0",NULL),
("31783","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:07:17","2025-11-26 03:07:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764126437;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764126437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:08:02","2025-11-26 03:08:02","0",NULL),
("31784","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:13:02","2025-11-26 03:13:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764126782;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764126782;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:13:45","2025-11-26 03:13:45","0",NULL),
("31785","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:18:45","2025-11-26 03:18:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764127125;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764127125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:20:51","2025-11-26 03:20:51","0",NULL),
("31786","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:25:51","2025-11-26 03:25:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764127551;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764127551;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:26:42","2025-11-26 03:26:42","0",NULL),
("31787","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:31:42","2025-11-26 03:31:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764127902;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764127902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:35:39","2025-11-26 03:35:39","0",NULL),
("31788","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:40:39","2025-11-26 03:40:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764128439;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764128439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:43:31","2025-11-26 03:43:31","0",NULL),
("31789","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:48:31","2025-11-26 03:48:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764128911;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764128911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:48:43","2025-11-26 03:48:43","0",NULL),
("31790","image-optimization/cleanup/stuck-operation","complete","2025-11-26 03:53:43","2025-11-26 03:53:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764129223;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764129223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 03:59:43","2025-11-26 03:59:43","0",NULL),
("31791","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:04:43","2025-11-26 04:04:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764129883;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764129883;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:05:39","2025-11-26 04:05:39","0",NULL),
("31792","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:10:39","2025-11-26 04:10:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764130239;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764130239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:11:46","2025-11-26 04:11:46","0",NULL),
("31793","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:16:46","2025-11-26 04:16:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764130606;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764130606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:17:39","2025-11-26 04:17:39","0",NULL),
("31794","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:22:39","2025-11-26 04:22:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764130959;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764130959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:24:28","2025-11-26 04:24:28","0",NULL),
("31795","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:29:28","2025-11-26 04:29:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764131368;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764131368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:31:04","2025-11-26 04:31:04","0",NULL),
("31796","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:36:04","2025-11-26 04:36:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764131764;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764131764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:36:29","2025-11-26 04:36:29","0",NULL),
("31797","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:41:29","2025-11-26 04:41:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764132089;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764132089;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:43:51","2025-11-26 04:43:51","0",NULL),
("31798","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:48:51","2025-11-26 04:48:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764132531;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764132531;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:49:51","2025-11-26 04:49:51","0",NULL),
("31799","image-optimization/cleanup/stuck-operation","complete","2025-11-26 04:54:51","2025-11-26 04:54:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764132891;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764132891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 04:56:52","2025-11-26 04:56:52","0",NULL),
("31800","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:01:52","2025-11-26 05:01:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764133312;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764133312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:02:39","2025-11-26 05:02:39","0",NULL),
("31801","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:07:39","2025-11-26 05:07:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764133659;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764133659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:07:53","2025-11-26 05:07:53","0",NULL),
("31802","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:12:53","2025-11-26 05:12:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764133973;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764133973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:18:20","2025-11-26 05:18:20","0",NULL),
("31803","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:23:20","2025-11-26 05:23:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764134600;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764134600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:25:49","2025-11-26 05:25:49","0",NULL),
("31804","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:30:49","2025-11-26 05:30:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764135049;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764135049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:31:44","2025-11-26 05:31:44","0",NULL),
("31805","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:36:44","2025-11-26 05:36:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764135404;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764135404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:38:46","2025-11-26 05:38:46","0",NULL),
("31806","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:43:46","2025-11-26 05:43:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764135826;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764135826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:48:54","2025-11-26 05:48:54","0",NULL),
("31807","image-optimization/cleanup/stuck-operation","complete","2025-11-26 05:53:54","2025-11-26 05:53:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764136434;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764136434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 05:55:03","2025-11-26 05:55:03","0",NULL),
("31808","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:00:03","2025-11-26 06:00:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764136803;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764136803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:04:57","2025-11-26 06:04:57","0",NULL),
("31809","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:09:57","2025-11-26 06:09:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764137397;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764137397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:11:01","2025-11-26 06:11:01","0",NULL),
("31810","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:16:01","2025-11-26 06:16:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764137761;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764137761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:18:22","2025-11-26 06:18:22","0",NULL),
("31811","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:23:22","2025-11-26 06:23:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764138202;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764138202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:26:38","2025-11-26 06:26:38","0",NULL),
("31812","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:31:38","2025-11-26 06:31:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764138698;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764138698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:45:28","2025-11-26 06:45:28","0",NULL),
("31813","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:50:28","2025-11-26 06:50:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764139828;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764139828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:51:11","2025-11-26 06:51:11","0",NULL),
("31814","image-optimization/cleanup/stuck-operation","complete","2025-11-26 06:56:11","2025-11-26 06:56:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764140171;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764140171;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 06:57:09","2025-11-26 06:57:09","0",NULL),
("31815","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:02:09","2025-11-26 07:02:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764140529;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764140529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:02:27","2025-11-26 07:02:27","0",NULL),
("31816","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:07:27","2025-11-26 07:07:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764140847;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764140847;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:11:18","2025-11-26 07:11:18","0",NULL),
("31817","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:16:18","2025-11-26 07:16:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764141378;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764141378;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:17:07","2025-11-26 07:17:07","0",NULL),
("31818","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:22:07","2025-11-26 07:22:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764141727;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764141727;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:27:07","2025-11-26 07:27:07","0",NULL),
("31819","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:32:07","2025-11-26 07:32:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764142327;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764142327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:36:10","2025-11-26 07:36:10","0",NULL),
("31820","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:41:10","2025-11-26 07:41:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764142870;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764142870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:43:12","2025-11-26 07:43:12","0",NULL),
("31821","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:48:12","2025-11-26 07:48:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764143292;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764143292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 07:50:40","2025-11-26 07:50:40","0",NULL),
("31822","image-optimization/cleanup/stuck-operation","complete","2025-11-26 07:55:40","2025-11-26 07:55:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764143740;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764143740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:04:49","2025-11-26 08:04:49","0",NULL),
("31823","image-optimization/cleanup/stuck-operation","complete","2025-11-26 08:09:49","2025-11-26 08:09:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764144589;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764144589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:13:32","2025-11-26 08:13:32","0",NULL),
("31824","image-optimization/cleanup/stuck-operation","complete","2025-11-26 08:18:32","2025-11-26 08:18:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764145112;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764145112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:19:15","2025-11-26 08:19:15","0",NULL),
("31825","image-optimization/cleanup/stuck-operation","complete","2025-11-26 08:24:15","2025-11-26 08:24:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764145455;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764145455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:26:51","2025-11-26 08:26:51","0",NULL),
("31826","image-optimization/cleanup/stuck-operation","complete","2025-11-26 08:31:51","2025-11-26 08:31:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764145911;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764145911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:32:17","2025-11-26 08:32:17","0",NULL),
("31827","image-optimization/cleanup/stuck-operation","complete","2025-11-26 08:37:17","2025-11-26 08:37:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764146237;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764146237;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:48:26","2025-11-26 08:48:26","0",NULL),
("31828","image-optimization/cleanup/stuck-operation","complete","2025-11-26 08:53:26","2025-11-26 08:53:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764147206;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764147206;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 08:56:16","2025-11-26 08:56:16","0",NULL),
("31829","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:01:16","2025-11-26 09:01:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764147676;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764147676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:01:41","2025-11-26 09:01:41","0",NULL),
("31830","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:06:41","2025-11-26 09:06:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764148001;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764148001;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:08:38","2025-11-26 09:08:38","0",NULL),
("31831","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:13:38","2025-11-26 09:13:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764148418;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764148418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:14:56","2025-11-26 09:14:56","0",NULL),
("31832","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:19:56","2025-11-26 09:19:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764148796;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764148796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:22:16","2025-11-26 09:22:16","0",NULL),
("31833","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:27:16","2025-11-26 09:27:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764149236;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764149236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:28:34","2025-11-26 09:28:34","0",NULL),
("31834","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:33:34","2025-11-26 09:33:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764149614;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764149614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:35:47","2025-11-26 09:35:47","0",NULL),
("31835","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:40:47","2025-11-26 09:40:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764150047;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764150047;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:43:43","2025-11-26 09:43:43","0",NULL),
("31836","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:48:43","2025-11-26 09:48:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764150523;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764150523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:49:41","2025-11-26 09:49:41","0",NULL),
("31837","image-optimization/cleanup/stuck-operation","complete","2025-11-26 09:54:41","2025-11-26 09:54:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764150881;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764150881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 09:58:57","2025-11-26 09:58:57","0",NULL),
("31838","image-optimization/cleanup/stuck-operation","complete","2025-11-26 10:03:57","2025-11-26 10:03:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764151437;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764151437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 10:10:41","2025-11-26 10:10:41","0",NULL),
("31839","image-optimization/cleanup/stuck-operation","complete","2025-11-26 10:15:41","2025-11-26 10:15:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764152141;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764152141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 10:20:57","2025-11-26 10:20:57","0",NULL),
("31840","image-optimization/cleanup/stuck-operation","complete","2025-11-26 10:25:57","2025-11-26 10:25:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764152757;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764152757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 10:31:24","2025-11-26 10:31:24","0",NULL),
("31841","image-optimization/cleanup/stuck-operation","complete","2025-11-26 10:36:24","2025-11-26 10:36:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764153384;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764153384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 10:40:47","2025-11-26 10:40:47","0",NULL),
("31842","image-optimization/cleanup/stuck-operation","complete","2025-11-26 10:45:47","2025-11-26 10:45:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764153947;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764153947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 10:46:59","2025-11-26 10:46:59","0",NULL),
("31843","image-optimization/cleanup/stuck-operation","complete","2025-11-26 10:51:59","2025-11-26 10:51:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764154319;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764154319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 10:57:45","2025-11-26 10:57:45","0",NULL),
("31844","image-optimization/cleanup/stuck-operation","complete","2025-11-26 11:02:45","2025-11-26 11:02:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764154965;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764154965;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 11:12:25","2025-11-26 11:12:25","0",NULL),
("31845","image-optimization/cleanup/stuck-operation","complete","2025-11-26 11:17:25","2025-11-26 11:17:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764155845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764155845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 11:17:40","2025-11-26 11:17:40","0",NULL),
("31846","image-optimization/cleanup/stuck-operation","complete","2025-11-26 11:22:40","2025-11-26 11:22:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764156160;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764156160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 11:25:32","2025-11-26 11:25:32","0",NULL),
("31847","image-optimization/cleanup/stuck-operation","complete","2025-11-26 11:30:32","2025-11-26 11:30:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764156632;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764156632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 11:35:40","2025-11-26 11:35:40","0",NULL),
("31848","image-optimization/cleanup/stuck-operation","complete","2025-11-26 11:40:40","2025-11-26 11:40:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764157240;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764157240;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 11:49:39","2025-11-26 11:49:39","0",NULL),
("31849","image-optimization/cleanup/stuck-operation","complete","2025-11-26 11:54:39","2025-11-26 11:54:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764158079;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764158079;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 11:55:23","2025-11-26 11:55:23","0",NULL),
("31850","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:00:23","2025-11-26 12:00:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764158423;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764158423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:02:00","2025-11-26 12:02:00","0",NULL),
("31851","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:07:00","2025-11-26 12:07:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764158820;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764158820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:07:21","2025-11-26 12:07:21","0",NULL),
("31852","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:12:21","2025-11-26 12:12:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764159141;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764159141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:12:36","2025-11-26 12:12:36","0",NULL),
("31853","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:17:36","2025-11-26 12:17:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764159456;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764159456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:20:19","2025-11-26 12:20:19","0",NULL),
("31854","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:25:19","2025-11-26 12:25:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764159919;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764159919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:26:36","2025-11-26 12:26:36","0",NULL),
("31855","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:31:36","2025-11-26 12:31:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764160296;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764160296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:36:20","2025-11-26 12:36:20","0",NULL),
("31856","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:41:20","2025-11-26 12:41:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764160880;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764160880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:44:31","2025-11-26 12:44:31","0",NULL),
("31857","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:49:31","2025-11-26 12:49:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764161371;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764161371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 12:52:00","2025-11-26 12:52:00","0",NULL),
("31858","image-optimization/cleanup/stuck-operation","complete","2025-11-26 12:57:00","2025-11-26 12:57:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764161820;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764161820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:13:03","2025-11-26 13:13:03","0",NULL),
("31859","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:18:03","2025-11-26 13:18:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764163083;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764163083;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:19:38","2025-11-26 13:19:38","0",NULL),
("31860","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:24:38","2025-11-26 13:24:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764163478;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764163478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:26:24","2025-11-26 13:26:24","0",NULL),
("31861","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:31:24","2025-11-26 13:31:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764163884;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764163884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:32:04","2025-11-26 13:32:04","0",NULL),
("31862","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:37:04","2025-11-26 13:37:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764164224;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764164224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:39:02","2025-11-26 13:39:02","0",NULL),
("31863","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:44:02","2025-11-26 13:44:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764164642;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764164642;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:44:56","2025-11-26 13:44:56","0",NULL),
("31864","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:49:56","2025-11-26 13:49:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764164996;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764164996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 13:53:21","2025-11-26 13:53:21","0",NULL),
("31865","image-optimization/cleanup/stuck-operation","complete","2025-11-26 13:58:21","2025-11-26 13:58:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764165501;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764165501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:01:06","2025-11-26 14:01:06","0",NULL),
("31866","image-optimization/cleanup/stuck-operation","complete","2025-11-26 14:06:06","2025-11-26 14:06:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764165966;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764165966;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:12:11","2025-11-26 14:12:11","0",NULL),
("31867","image-optimization/cleanup/stuck-operation","complete","2025-11-26 14:17:11","2025-11-26 14:17:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764166631;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764166631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:23:59","2025-11-26 14:23:59","0",NULL),
("31868","image-optimization/cleanup/stuck-operation","complete","2025-11-26 14:28:59","2025-11-26 14:28:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764167339;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764167339;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:31:43","2025-11-26 14:31:43","0",NULL),
("31869","image-optimization/cleanup/stuck-operation","complete","2025-11-26 14:36:43","2025-11-26 14:36:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764167803;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764167803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:39:08","2025-11-26 14:39:08","0",NULL),
("31870","image-optimization/cleanup/stuck-operation","complete","2025-11-26 14:44:08","2025-11-26 14:44:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764168248;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764168248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:51:09","2025-11-26 14:51:09","0",NULL),
("31871","image-optimization/cleanup/stuck-operation","complete","2025-11-26 14:56:09","2025-11-26 14:56:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764168969;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764168969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 14:58:39","2025-11-26 14:58:39","0",NULL),
("31872","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:03:39","2025-11-26 15:03:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764169419;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764169419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:05:05","2025-11-26 15:05:05","0",NULL),
("31873","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:10:05","2025-11-26 15:10:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764169805;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764169805;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:10:19","2025-11-26 15:10:19","0",NULL),
("31874","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:15:19","2025-11-26 15:15:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170119;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:16:43","2025-11-26 15:16:43","0",NULL),
("31875","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:21:43","2025-11-26 15:21:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170503;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:23:39","2025-11-26 15:23:39","0",NULL),
("31876","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:28:39","2025-11-26 15:28:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764170919;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764170919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:30:06","2025-11-26 15:30:06","0",NULL),
("31877","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:35:06","2025-11-26 15:35:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764171306;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764171306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:37:25","2025-11-26 15:37:25","0",NULL),
("31878","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:42:25","2025-11-26 15:42:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764171745;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764171745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:43:24","2025-11-26 15:43:24","0",NULL),
("31879","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:48:24","2025-11-26 15:48:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764172104;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764172104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:50:55","2025-11-26 15:50:55","0",NULL),
("31880","image-optimization/cleanup/stuck-operation","complete","2025-11-26 15:55:55","2025-11-26 15:55:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764172555;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764172555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 15:57:24","2025-11-26 15:57:24","0",NULL),
("31881","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:02:24","2025-11-26 16:02:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764172944;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764172944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:03:28","2025-11-26 16:03:28","0",NULL),
("31882","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:08:28","2025-11-26 16:08:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764173308;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764173308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:08:59","2025-11-26 16:08:59","0",NULL),
("31883","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:13:59","2025-11-26 16:13:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764173639;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764173639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:20:16","2025-11-26 16:20:16","0",NULL),
("31884","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:25:16","2025-11-26 16:25:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764174316;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764174316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:30:48","2025-11-26 16:30:48","0",NULL),
("31885","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:35:48","2025-11-26 16:35:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764174948;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764174948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:36:51","2025-11-26 16:36:51","0",NULL),
("31886","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:41:51","2025-11-26 16:41:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764175311;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764175311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:45:25","2025-11-26 16:45:25","0",NULL),
("31887","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:50:25","2025-11-26 16:50:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764175825;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764175825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:51:09","2025-11-26 16:51:09","0",NULL),
("31888","image-optimization/cleanup/stuck-operation","complete","2025-11-26 16:56:09","2025-11-26 16:56:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764176169;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764176169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 16:57:46","2025-11-26 16:57:46","0",NULL),
("31889","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:02:46","2025-11-26 17:02:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764176566;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764176566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:08:08","2025-11-26 17:08:08","0",NULL),
("31890","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:13:08","2025-11-26 17:13:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764177188;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764177188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:14:04","2025-11-26 17:14:04","0",NULL),
("31891","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:19:04","2025-11-26 17:19:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764177544;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764177544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:21:23","2025-11-26 17:21:23","0",NULL),
("31892","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:26:23","2025-11-26 17:26:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764177983;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764177983;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:31:43","2025-11-26 17:31:43","0",NULL),
("31893","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:36:43","2025-11-26 17:36:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764178603;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764178603;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:37:51","2025-11-26 17:37:51","0",NULL),
("31894","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:42:51","2025-11-26 17:42:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764178971;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764178971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:47:23","2025-11-26 17:47:23","0",NULL),
("31895","image-optimization/cleanup/stuck-operation","complete","2025-11-26 17:52:23","2025-11-26 17:52:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764179543;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764179543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 17:55:11","2025-11-26 17:55:11","0",NULL),
("31896","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:00:11","2025-11-26 18:00:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764180011;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764180011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 18:03:27","2025-11-26 18:03:27","0",NULL),
("31897","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:08:27","2025-11-26 18:08:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764180507;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764180507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 18:09:29","2025-11-26 18:09:29","0",NULL),
("31898","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:14:29","2025-11-26 18:14:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764180869;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764180869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 18:25:11","2025-11-26 18:25:11","0",NULL),
("31899","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:30:11","2025-11-26 18:30:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764181811;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764181811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 18:32:41","2025-11-26 18:32:41","0",NULL),
("31900","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:37:41","2025-11-26 18:37:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764182261;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764182261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 18:39:52","2025-11-26 18:39:52","0",NULL),
("31901","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:44:52","2025-11-26 18:44:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764182692;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764182692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 18:47:52","2025-11-26 18:47:52","0",NULL),
("31902","image-optimization/cleanup/stuck-operation","complete","2025-11-26 18:52:52","2025-11-26 18:52:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764183172;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764183172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:03:27","2025-11-26 19:03:27","0",NULL),
("31903","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:08:27","2025-11-26 19:08:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764184107;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764184107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:11:36","2025-11-26 19:11:36","0",NULL),
("31904","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:16:36","2025-11-26 19:16:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764184596;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764184596;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:24:49","2025-11-26 19:24:49","0",NULL),
("31905","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:29:49","2025-11-26 19:29:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764185389;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764185389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:30:50","2025-11-26 19:30:50","0",NULL),
("31906","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:35:50","2025-11-26 19:35:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764185750;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764185750;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:37:03","2025-11-26 19:37:03","0",NULL),
("31907","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:42:03","2025-11-26 19:42:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764186123;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764186123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:43:36","2025-11-26 19:43:36","0",NULL),
("31908","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:48:36","2025-11-26 19:48:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764186516;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764186516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:50:39","2025-11-26 19:50:39","0",NULL),
("31909","image-optimization/cleanup/stuck-operation","complete","2025-11-26 19:55:39","2025-11-26 19:55:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764186939;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764186939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 19:56:39","2025-11-26 19:56:39","0",NULL),
("31910","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:01:39","2025-11-26 20:01:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764187299;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764187299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:05:04","2025-11-26 20:05:04","0",NULL),
("31911","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:10:04","2025-11-26 20:10:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764187804;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764187804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:10:37","2025-11-26 20:10:37","0",NULL),
("31912","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:15:37","2025-11-26 20:15:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764188137;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764188137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:20:34","2025-11-26 20:20:34","0",NULL),
("31913","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:25:34","2025-11-26 20:25:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764188734;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764188734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:28:55","2025-11-26 20:28:55","0",NULL),
("31914","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:33:55","2025-11-26 20:33:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764189235;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764189235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:34:46","2025-11-26 20:34:46","0",NULL),
("31915","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:39:46","2025-11-26 20:39:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764189586;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764189586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:41:29","2025-11-26 20:41:29","0",NULL),
("31916","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:46:29","2025-11-26 20:46:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764189989;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764189989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:46:40","2025-11-26 20:46:40","0",NULL),
("31917","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:51:40","2025-11-26 20:51:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764190300;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764190300;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 20:54:45","2025-11-26 20:54:45","0",NULL),
("31918","image-optimization/cleanup/stuck-operation","complete","2025-11-26 20:59:45","2025-11-26 20:59:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764190785;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764190785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:07:25","2025-11-26 21:07:25","0",NULL),
("31919","image-optimization/cleanup/stuck-operation","complete","2025-11-26 21:12:25","2025-11-26 21:12:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764191545;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764191545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:12:34","2025-11-26 21:12:34","0",NULL),
("31920","image-optimization/cleanup/stuck-operation","complete","2025-11-26 21:17:34","2025-11-26 21:17:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764191854;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764191854;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:18:30","2025-11-26 21:18:30","0",NULL),
("31921","image-optimization/cleanup/stuck-operation","complete","2025-11-26 21:23:30","2025-11-26 21:23:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764192210;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764192210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:30:07","2025-11-26 21:30:07","0",NULL),
("31922","image-optimization/cleanup/stuck-operation","complete","2025-11-26 21:35:07","2025-11-26 21:35:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764192907;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764192907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:38:22","2025-11-26 21:38:22","0",NULL),
("31923","image-optimization/cleanup/stuck-operation","complete","2025-11-26 21:43:22","2025-11-26 21:43:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764193402;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764193402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:46:43","2025-11-26 21:46:43","0",NULL),
("31924","image-optimization/cleanup/stuck-operation","complete","2025-11-26 21:51:43","2025-11-26 21:51:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764193903;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764193903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 21:58:46","2025-11-26 21:58:46","0",NULL),
("31925","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:03:46","2025-11-26 22:03:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764194626;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764194626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:05:55","2025-11-26 22:05:55","0",NULL),
("31926","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:10:55","2025-11-26 22:10:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764195055;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764195055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:12:16","2025-11-26 22:12:16","0",NULL),
("31927","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:17:16","2025-11-26 22:17:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764195436;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764195436;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:23:36","2025-11-26 22:23:36","0",NULL),
("31928","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:28:36","2025-11-26 22:28:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764196116;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764196116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:30:29","2025-11-26 22:30:29","0",NULL),
("31929","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:35:29","2025-11-26 22:35:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764196529;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764196529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:36:12","2025-11-26 22:36:12","0",NULL),
("31930","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:41:12","2025-11-26 22:41:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764196872;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764196872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:44:23","2025-11-26 22:44:23","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("31931","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:49:23","2025-11-26 22:49:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764197363;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764197363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 22:54:29","2025-11-26 22:54:29","0",NULL),
("31932","image-optimization/cleanup/stuck-operation","complete","2025-11-26 22:59:29","2025-11-26 22:59:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764197969;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764197969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:01:46","2025-11-26 23:01:46","0",NULL),
("31933","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:06:46","2025-11-26 23:06:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764198406;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764198406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:09:56","2025-11-26 23:09:56","0",NULL),
("31934","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:14:56","2025-11-26 23:14:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764198896;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764198896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:16:33","2025-11-26 23:16:33","0",NULL),
("31935","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:21:33","2025-11-26 23:21:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764199293;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764199293;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:23:16","2025-11-26 23:23:16","0",NULL),
("31936","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:28:16","2025-11-26 23:28:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764199696;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764199696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:30:17","2025-11-26 23:30:17","0",NULL),
("31937","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:35:17","2025-11-26 23:35:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764200117;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764200117;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:37:14","2025-11-26 23:37:14","0",NULL),
("31938","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:42:14","2025-11-26 23:42:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764200534;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764200534;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:43:34","2025-11-26 23:43:34","0",NULL),
("31939","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:48:34","2025-11-26 23:48:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764200914;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764200914;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:49:46","2025-11-26 23:49:46","0",NULL),
("31940","image-optimization/cleanup/stuck-operation","complete","2025-11-26 23:54:46","2025-11-26 23:54:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764201286;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764201286;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-26 23:55:30","2025-11-26 23:55:30","0",NULL),
("31941","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:00:30","2025-11-27 00:00:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764201630;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764201630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 00:04:21","2025-11-27 00:04:21","0",NULL),
("31942","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:09:21","2025-11-27 00:09:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764202161;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764202161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 00:09:40","2025-11-27 00:09:40","0",NULL),
("31943","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:14:40","2025-11-27 00:14:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764202480;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764202480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 00:20:55","2025-11-27 00:20:55","0",NULL),
("31944","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:25:55","2025-11-27 00:25:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764203155;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764203155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 00:26:43","2025-11-27 00:26:43","0",NULL),
("31945","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:31:43","2025-11-27 00:31:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764203503;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764203503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 00:33:42","2025-11-27 00:33:42","0",NULL),
("31946","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:38:42","2025-11-27 00:38:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764203922;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764203922;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 00:43:05","2025-11-27 00:43:05","0",NULL),
("31947","image-optimization/cleanup/stuck-operation","complete","2025-11-27 00:48:05","2025-11-27 00:48:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764204485;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764204485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:02:32","2025-11-27 01:02:32","0",NULL),
("31948","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:07:32","2025-11-27 01:07:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764205652;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764205652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:08:34","2025-11-27 01:08:34","0",NULL),
("31949","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:13:34","2025-11-27 01:13:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764206014;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764206014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:18:27","2025-11-27 01:18:27","0",NULL),
("31950","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:23:27","2025-11-27 01:23:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764206607;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764206607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:25:19","2025-11-27 01:25:19","0",NULL),
("31951","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:30:19","2025-11-27 01:30:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764207019;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764207019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:32:58","2025-11-27 01:32:58","0",NULL),
("31952","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:37:58","2025-11-27 01:37:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764207478;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764207478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:38:31","2025-11-27 01:38:31","0",NULL),
("31953","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:43:31","2025-11-27 01:43:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764207811;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764207811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:47:51","2025-11-27 01:47:51","0",NULL),
("31954","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:52:51","2025-11-27 01:52:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764208371;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764208371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 01:54:50","2025-11-27 01:54:50","0",NULL),
("31955","image-optimization/cleanup/stuck-operation","complete","2025-11-27 01:59:50","2025-11-27 01:59:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764208790;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764208790;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:01:49","2025-11-27 02:01:49","0",NULL),
("31956","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:06:49","2025-11-27 02:06:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764209209;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764209209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:08:32","2025-11-27 02:08:32","0",NULL),
("31957","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:13:32","2025-11-27 02:13:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764209612;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764209612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:15:18","2025-11-27 02:15:18","0",NULL),
("31958","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:20:18","2025-11-27 02:20:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764210018;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764210018;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:21:54","2025-11-27 02:21:54","0",NULL),
("31959","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:26:54","2025-11-27 02:26:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764210414;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764210414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:28:46","2025-11-27 02:28:46","0",NULL),
("31960","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:33:46","2025-11-27 02:33:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764210826;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764210826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:35:34","2025-11-27 02:35:34","0",NULL),
("31961","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:40:34","2025-11-27 02:40:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764211234;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764211234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:41:31","2025-11-27 02:41:31","0",NULL),
("31962","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:46:31","2025-11-27 02:46:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764211591;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764211591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:48:47","2025-11-27 02:48:47","0",NULL),
("31963","image-optimization/cleanup/stuck-operation","complete","2025-11-27 02:53:47","2025-11-27 02:53:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764212027;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764212027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 02:55:19","2025-11-27 02:55:19","0",NULL),
("31964","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:00:19","2025-11-27 03:00:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764212419;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764212419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:04:05","2025-11-27 03:04:05","0",NULL),
("31965","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:09:05","2025-11-27 03:09:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764212945;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764212945;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:12:10","2025-11-27 03:12:10","0",NULL),
("31966","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:17:10","2025-11-27 03:17:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764213430;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764213430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:20:44","2025-11-27 03:20:44","0",NULL),
("31967","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:25:44","2025-11-27 03:25:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764213944;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764213944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:26:13","2025-11-27 03:26:13","0",NULL),
("31968","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:31:13","2025-11-27 03:31:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764214273;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764214273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:31:30","2025-11-27 03:31:30","0",NULL),
("31969","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:36:30","2025-11-27 03:36:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764214590;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764214590;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:37:25","2025-11-27 03:37:25","0",NULL),
("31970","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:42:25","2025-11-27 03:42:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764214945;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764214945;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:43:11","2025-11-27 03:43:11","0",NULL),
("31971","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:48:11","2025-11-27 03:48:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764215291;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764215291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:52:03","2025-11-27 03:52:03","0",NULL),
("31972","image-optimization/cleanup/stuck-operation","complete","2025-11-27 03:57:03","2025-11-27 03:57:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764215823;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764215823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 03:58:01","2025-11-27 03:58:01","0",NULL),
("31973","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:03:01","2025-11-27 04:03:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764216181;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764216181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:04:09","2025-11-27 04:04:09","0",NULL),
("31974","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:09:09","2025-11-27 04:09:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764216549;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764216549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:10:46","2025-11-27 04:10:46","0",NULL),
("31975","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:15:46","2025-11-27 04:15:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764216946;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764216946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:16:50","2025-11-27 04:16:50","0",NULL),
("31976","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:21:50","2025-11-27 04:21:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764217310;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764217310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:22:47","2025-11-27 04:22:47","0",NULL),
("31977","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:27:47","2025-11-27 04:27:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764217667;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764217667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:30:26","2025-11-27 04:30:26","0",NULL),
("31978","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:35:26","2025-11-27 04:35:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764218126;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764218126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:35:45","2025-11-27 04:35:45","0",NULL),
("31979","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:40:45","2025-11-27 04:40:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764218445;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764218445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:44:07","2025-11-27 04:44:07","0",NULL),
("31980","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:49:07","2025-11-27 04:49:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764218947;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764218947;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:51:26","2025-11-27 04:51:26","0",NULL),
("31981","image-optimization/cleanup/stuck-operation","complete","2025-11-27 04:56:26","2025-11-27 04:56:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764219386;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764219386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 04:59:20","2025-11-27 04:59:20","0",NULL),
("31982","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:04:20","2025-11-27 05:04:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764219860;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764219860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:09:06","2025-11-27 05:09:06","0",NULL),
("31983","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:14:06","2025-11-27 05:14:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764220446;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764220446;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:21:34","2025-11-27 05:21:34","0",NULL),
("31984","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:26:34","2025-11-27 05:26:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764221194;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764221194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:31:43","2025-11-27 05:31:43","0",NULL),
("31985","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:36:43","2025-11-27 05:36:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764221803;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764221803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:37:27","2025-11-27 05:37:27","0",NULL),
("31986","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:42:27","2025-11-27 05:42:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764222147;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764222147;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:46:31","2025-11-27 05:46:31","0",NULL),
("31987","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:51:31","2025-11-27 05:51:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764222691;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764222691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:53:50","2025-11-27 05:53:50","0",NULL),
("31988","image-optimization/cleanup/stuck-operation","complete","2025-11-27 05:58:50","2025-11-27 05:58:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764223130;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764223130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 05:59:27","2025-11-27 05:59:27","0",NULL),
("31989","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:04:27","2025-11-27 06:04:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764223467;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764223467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:07:50","2025-11-27 06:07:50","0",NULL),
("31990","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:12:50","2025-11-27 06:12:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764223970;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764223970;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:16:51","2025-11-27 06:16:51","0",NULL),
("31991","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:21:51","2025-11-27 06:21:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764224511;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764224511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:25:50","2025-11-27 06:25:50","0",NULL),
("31992","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:30:50","2025-11-27 06:30:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764225050;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764225050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:31:35","2025-11-27 06:31:35","0",NULL),
("31993","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:36:35","2025-11-27 06:36:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764225395;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764225395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:37:35","2025-11-27 06:37:35","0",NULL),
("31994","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:42:35","2025-11-27 06:42:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764225755;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764225755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:43:36","2025-11-27 06:43:36","0",NULL),
("31995","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:48:36","2025-11-27 06:48:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764226116;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764226116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:49:38","2025-11-27 06:49:38","0",NULL),
("31996","image-optimization/cleanup/stuck-operation","complete","2025-11-27 06:54:38","2025-11-27 06:54:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764226478;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764226478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 06:55:51","2025-11-27 06:55:51","0",NULL),
("31997","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:00:51","2025-11-27 07:00:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764226851;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764226851;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:01:58","2025-11-27 07:01:58","0",NULL),
("31998","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:06:58","2025-11-27 07:06:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764227218;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764227218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:07:36","2025-11-27 07:07:36","0",NULL),
("31999","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:12:36","2025-11-27 07:12:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764227556;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764227556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:14:36","2025-11-27 07:14:36","0",NULL),
("32000","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:19:36","2025-11-27 07:19:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764227976;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764227976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:20:41","2025-11-27 07:20:41","0",NULL),
("32001","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:25:41","2025-11-27 07:25:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764228341;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764228341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:27:16","2025-11-27 07:27:16","0",NULL),
("32002","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:32:39","2025-11-27 07:32:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764228759;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764228759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:34:32","2025-11-27 07:34:32","0",NULL),
("32003","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:39:32","2025-11-27 07:39:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764229172;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764229172;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:42:32","2025-11-27 07:42:32","0",NULL),
("32004","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:47:32","2025-11-27 07:47:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764229652;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764229652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:49:55","2025-11-27 07:49:55","0",NULL),
("32005","image-optimization/cleanup/stuck-operation","complete","2025-11-27 07:54:55","2025-11-27 07:54:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764230095;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764230095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 07:57:03","2025-11-27 07:57:03","0",NULL),
("32006","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:02:03","2025-11-27 08:02:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764230523;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764230523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:02:46","2025-11-27 08:02:46","0",NULL),
("32007","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:07:46","2025-11-27 08:07:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764230866;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764230866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:11:19","2025-11-27 08:11:19","0",NULL),
("32008","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:16:20","2025-11-27 08:16:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764231380;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764231380;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:16:57","2025-11-27 08:16:57","0",NULL),
("32009","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:21:57","2025-11-27 08:21:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764231717;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764231717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:23:00","2025-11-27 08:23:00","0",NULL),
("32010","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:28:00","2025-11-27 08:28:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764232080;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764232080;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:28:42","2025-11-27 08:28:42","0",NULL),
("32011","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:33:42","2025-11-27 08:33:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764232422;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764232422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:35:50","2025-11-27 08:35:50","0",NULL),
("32012","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:40:50","2025-11-27 08:40:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764232850;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764232850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:41:58","2025-11-27 08:41:58","0",NULL),
("32013","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:46:58","2025-11-27 08:46:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764233218;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764233218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:47:53","2025-11-27 08:47:53","0",NULL),
("32014","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:52:53","2025-11-27 08:52:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764233573;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764233573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 08:54:56","2025-11-27 08:54:56","0",NULL),
("32015","image-optimization/cleanup/stuck-operation","complete","2025-11-27 08:59:56","2025-11-27 08:59:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764233996;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764233996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:02:09","2025-11-27 09:02:09","0",NULL),
("32016","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:07:09","2025-11-27 09:07:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764234429;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764234429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:08:40","2025-11-27 09:08:40","0",NULL),
("32017","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:13:40","2025-11-27 09:13:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764234820;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764234820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:14:10","2025-11-27 09:14:10","0",NULL),
("32018","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:19:10","2025-11-27 09:19:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764235150;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764235150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:22:13","2025-11-27 09:22:13","0",NULL),
("32019","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:27:18","2025-11-27 09:27:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764235638;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764235638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:27:58","2025-11-27 09:27:58","0",NULL),
("32020","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:32:58","2025-11-27 09:32:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764235978;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764235978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:34:14","2025-11-27 09:34:14","0",NULL),
("32021","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:39:14","2025-11-27 09:39:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764236354;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764236354;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:42:26","2025-11-27 09:42:26","0",NULL),
("32022","image-optimization/cleanup/stuck-operation","complete","2025-11-27 09:47:26","2025-11-27 09:47:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764236846;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764236846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 09:56:01","2025-11-27 09:56:01","0",NULL),
("32023","image-optimization/cleanup/stuck-operation","complete","2025-11-27 10:01:01","2025-11-27 10:01:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764237661;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764237661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 10:04:14","2025-11-27 10:04:14","0",NULL),
("32024","image-optimization/cleanup/stuck-operation","complete","2025-11-27 10:09:14","2025-11-27 10:09:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764238154;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764238154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 10:27:15","2025-11-27 10:27:15","0",NULL),
("32025","image-optimization/cleanup/stuck-operation","complete","2025-11-27 10:32:15","2025-11-27 10:32:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764239535;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764239535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 10:34:49","2025-11-27 10:34:49","0",NULL),
("32026","image-optimization/cleanup/stuck-operation","complete","2025-11-27 10:39:49","2025-11-27 10:39:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764239989;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764239989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 10:46:37","2025-11-27 10:46:37","0",NULL),
("32027","image-optimization/cleanup/stuck-operation","complete","2025-11-27 10:51:37","2025-11-27 10:51:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764240697;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764240697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 10:53:11","2025-11-27 10:53:11","0",NULL),
("32028","image-optimization/cleanup/stuck-operation","complete","2025-11-27 10:58:11","2025-11-27 10:58:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764241091;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764241091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:02:59","2025-11-27 11:02:59","0",NULL),
("32029","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:07:59","2025-11-27 11:07:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764241679;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764241679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:08:27","2025-11-27 11:08:27","0",NULL),
("32030","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:13:27","2025-11-27 11:13:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764242007;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764242007;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:14:21","2025-11-27 11:14:21","0",NULL),
("32031","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:19:21","2025-11-27 11:19:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764242361;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764242361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:25:05","2025-11-27 11:25:05","0",NULL),
("32032","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:30:05","2025-11-27 11:30:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764243005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764243005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:33:23","2025-11-27 11:33:23","0",NULL),
("32033","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:38:23","2025-11-27 11:38:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764243503;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764243503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:38:34","2025-11-27 11:38:34","0",NULL),
("32034","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:43:34","2025-11-27 11:43:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764243814;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764243814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:46:41","2025-11-27 11:46:41","0",NULL),
("32035","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:51:41","2025-11-27 11:51:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764244301;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764244301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:52:03","2025-11-27 11:52:03","0",NULL),
("32036","image-optimization/cleanup/stuck-operation","complete","2025-11-27 11:57:03","2025-11-27 11:57:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764244623;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764244623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 11:58:20","2025-11-27 11:58:20","0",NULL),
("32037","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:03:20","2025-11-27 12:03:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764245000;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764245000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:06:38","2025-11-27 12:06:38","0",NULL),
("32038","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:11:38","2025-11-27 12:11:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764245498;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764245498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:13:44","2025-11-27 12:13:44","0",NULL),
("32039","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:18:44","2025-11-27 12:18:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764245924;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764245924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:20:19","2025-11-27 12:20:19","0",NULL),
("32040","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:25:19","2025-11-27 12:25:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764246319;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764246319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:28:14","2025-11-27 12:28:14","0",NULL),
("32041","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:33:14","2025-11-27 12:33:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764246794;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764246794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:41:45","2025-11-27 12:41:45","0",NULL),
("32042","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:46:45","2025-11-27 12:46:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764247605;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764247605;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:48:01","2025-11-27 12:48:01","0",NULL),
("32043","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:53:01","2025-11-27 12:53:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764247981;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764247981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 12:54:43","2025-11-27 12:54:43","0",NULL),
("32044","image-optimization/cleanup/stuck-operation","complete","2025-11-27 12:59:43","2025-11-27 12:59:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764248383;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764248383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 13:11:05","2025-11-27 13:11:05","0",NULL),
("32045","image-optimization/cleanup/stuck-operation","complete","2025-11-27 13:16:05","2025-11-27 13:16:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764249365;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764249365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 13:24:08","2025-11-27 13:24:08","0",NULL),
("32046","image-optimization/cleanup/stuck-operation","complete","2025-11-27 13:29:08","2025-11-27 13:29:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764250148;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764250148;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 13:32:41","2025-11-27 13:32:41","0",NULL),
("32047","image-optimization/cleanup/stuck-operation","complete","2025-11-27 13:37:41","2025-11-27 13:37:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764250661;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764250661;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 13:42:41","2025-11-27 13:42:41","0",NULL),
("32048","image-optimization/cleanup/stuck-operation","complete","2025-11-27 13:47:41","2025-11-27 13:47:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764251261;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764251261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 13:49:54","2025-11-27 13:49:54","0",NULL),
("32049","image-optimization/cleanup/stuck-operation","complete","2025-11-27 13:54:54","2025-11-27 13:54:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764251694;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764251694;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 13:59:31","2025-11-27 13:59:31","0",NULL),
("32050","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:04:31","2025-11-27 14:04:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764252271;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764252271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:09:39","2025-11-27 14:09:39","0",NULL),
("32051","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:14:39","2025-11-27 14:14:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764252879;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764252879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:15:59","2025-11-27 14:15:59","0",NULL),
("32052","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:20:59","2025-11-27 14:20:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764253259;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764253259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:23:42","2025-11-27 14:23:42","0",NULL),
("32053","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:28:42","2025-11-27 14:28:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764253722;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764253722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:30:00","2025-11-27 14:30:00","0",NULL),
("32054","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:35:00","2025-11-27 14:35:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764254100;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764254100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:40:28","2025-11-27 14:40:28","0",NULL),
("32055","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:45:28","2025-11-27 14:45:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764254728;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764254728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:48:19","2025-11-27 14:48:19","0",NULL),
("32056","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:53:19","2025-11-27 14:53:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764255199;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764255199;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:53:37","2025-11-27 14:53:37","0",NULL),
("32057","image-optimization/cleanup/stuck-operation","complete","2025-11-27 14:58:37","2025-11-27 14:58:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764255517;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764255517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 14:58:55","2025-11-27 14:58:55","0",NULL),
("32058","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:03:55","2025-11-27 15:03:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764255835;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764255835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:07:06","2025-11-27 15:07:06","0",NULL),
("32059","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:12:06","2025-11-27 15:12:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764256326;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764256326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:13:40","2025-11-27 15:13:40","0",NULL),
("32060","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:18:40","2025-11-27 15:18:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764256720;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764256720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:20:12","2025-11-27 15:20:12","0",NULL),
("32061","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:25:12","2025-11-27 15:25:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257112;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:26:42","2025-11-27 15:26:42","0",NULL),
("32062","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:31:42","2025-11-27 15:31:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257502;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:32:26","2025-11-27 15:32:26","0",NULL),
("32063","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:37:26","2025-11-27 15:37:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764257846;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764257846;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:39:48","2025-11-27 15:39:48","0",NULL),
("32064","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:44:48","2025-11-27 15:44:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764258288;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764258288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:49:03","2025-11-27 15:49:03","0",NULL),
("32065","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:54:03","2025-11-27 15:54:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764258843;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764258843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 15:54:40","2025-11-27 15:54:40","0",NULL),
("32066","image-optimization/cleanup/stuck-operation","complete","2025-11-27 15:59:40","2025-11-27 15:59:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764259180;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764259180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:05:50","2025-11-27 16:05:50","0",NULL),
("32067","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:10:50","2025-11-27 16:10:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764259850;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764259850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:12:12","2025-11-27 16:12:12","0",NULL),
("32068","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:17:12","2025-11-27 16:17:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764260232;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764260232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:19:22","2025-11-27 16:19:22","0",NULL),
("32069","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:24:22","2025-11-27 16:24:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764260662;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764260662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:25:32","2025-11-27 16:25:32","0",NULL),
("32070","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:30:32","2025-11-27 16:30:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764261032;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764261032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:31:57","2025-11-27 16:31:57","0",NULL),
("32071","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:36:57","2025-11-27 16:36:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764261417;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764261417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:38:26","2025-11-27 16:38:26","0",NULL),
("32072","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:43:26","2025-11-27 16:43:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764261806;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764261806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:49:25","2025-11-27 16:49:25","0",NULL),
("32073","image-optimization/cleanup/stuck-operation","complete","2025-11-27 16:54:25","2025-11-27 16:54:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764262465;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764262465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 16:55:09","2025-11-27 16:55:09","0",NULL),
("32074","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:00:09","2025-11-27 17:00:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764262809;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764262809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:01:14","2025-11-27 17:01:14","0",NULL),
("32075","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:06:14","2025-11-27 17:06:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764263174;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764263174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:07:30","2025-11-27 17:07:30","0",NULL),
("32076","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:12:30","2025-11-27 17:12:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764263550;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764263550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:17:09","2025-11-27 17:17:09","0",NULL),
("32077","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:22:22","2025-11-27 17:22:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764264142;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764264142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:26:49","2025-11-27 17:26:49","0",NULL),
("32078","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:31:49","2025-11-27 17:31:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764264709;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764264709;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:39:35","2025-11-27 17:39:35","0",NULL),
("32079","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:44:35","2025-11-27 17:44:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764265475;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764265475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:46:11","2025-11-27 17:46:11","0",NULL),
("32080","image-optimization/cleanup/stuck-operation","complete","2025-11-27 17:51:11","2025-11-27 17:51:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764265871;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764265871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 17:55:33","2025-11-27 17:55:33","0",NULL),
("32081","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:00:33","2025-11-27 18:00:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764266433;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764266433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:01:38","2025-11-27 18:01:38","0",NULL),
("32082","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:06:38","2025-11-27 18:06:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764266798;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764266798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:07:23","2025-11-27 18:07:23","0",NULL),
("32083","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:12:23","2025-11-27 18:12:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764267143;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764267143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:13:10","2025-11-27 18:13:10","0",NULL),
("32084","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:18:10","2025-11-27 18:18:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764267490;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764267490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:20:36","2025-11-27 18:20:36","0",NULL),
("32085","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:25:36","2025-11-27 18:25:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764267936;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764267936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:30:30","2025-11-27 18:30:30","0",NULL),
("32086","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:35:30","2025-11-27 18:35:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764268530;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764268530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:36:15","2025-11-27 18:36:15","0",NULL),
("32087","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:41:15","2025-11-27 18:41:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764268875;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764268875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:41:59","2025-11-27 18:41:59","0",NULL),
("32088","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:46:59","2025-11-27 18:46:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764269219;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764269219;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:48:00","2025-11-27 18:48:00","0",NULL),
("32089","image-optimization/cleanup/stuck-operation","complete","2025-11-27 18:53:00","2025-11-27 18:53:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764269580;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764269580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 18:56:41","2025-11-27 18:56:41","0",NULL),
("32090","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:01:41","2025-11-27 19:01:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764270101;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764270101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:02:58","2025-11-27 19:02:58","0",NULL),
("32091","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:07:58","2025-11-27 19:07:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764270478;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764270478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:08:40","2025-11-27 19:08:40","0",NULL),
("32092","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:13:40","2025-11-27 19:13:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764270820;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764270820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:13:58","2025-11-27 19:13:58","0",NULL),
("32093","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:18:58","2025-11-27 19:18:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764271138;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764271138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:23:04","2025-11-27 19:23:04","0",NULL),
("32094","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:28:04","2025-11-27 19:28:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764271684;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764271684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:33:20","2025-11-27 19:33:20","0",NULL),
("32095","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:38:20","2025-11-27 19:38:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764272300;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764272300;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:40:24","2025-11-27 19:40:24","0",NULL),
("32096","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:45:24","2025-11-27 19:45:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764272724;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764272724;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:49:30","2025-11-27 19:49:30","0",NULL),
("32097","image-optimization/cleanup/stuck-operation","complete","2025-11-27 19:54:30","2025-11-27 19:54:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764273270;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764273270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 19:56:31","2025-11-27 19:56:31","0",NULL),
("32098","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:01:31","2025-11-27 20:01:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764273691;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764273691;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 20:03:01","2025-11-27 20:03:01","0",NULL),
("32099","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:08:01","2025-11-27 20:08:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764274081;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764274081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 20:12:13","2025-11-27 20:12:13","0",NULL),
("32100","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:17:13","2025-11-27 20:17:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764274633;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764274633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 20:21:40","2025-11-27 20:21:40","0",NULL),
("32101","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:26:40","2025-11-27 20:26:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764275200;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764275200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 20:32:33","2025-11-27 20:32:33","0",NULL),
("32102","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:37:33","2025-11-27 20:37:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764275853;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764275853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 20:39:32","2025-11-27 20:39:32","0",NULL),
("32103","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:44:32","2025-11-27 20:44:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764276272;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764276272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 20:51:09","2025-11-27 20:51:09","0",NULL),
("32104","image-optimization/cleanup/stuck-operation","complete","2025-11-27 20:56:09","2025-11-27 20:56:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764276969;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764276969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:01:13","2025-11-27 21:01:13","0",NULL),
("32105","image-optimization/cleanup/stuck-operation","complete","2025-11-27 21:06:13","2025-11-27 21:06:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764277573;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764277573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:15:06","2025-11-27 21:15:06","0",NULL),
("32106","image-optimization/cleanup/stuck-operation","complete","2025-11-27 21:20:06","2025-11-27 21:20:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764278406;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764278406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:21:10","2025-11-27 21:21:10","0",NULL),
("32107","image-optimization/cleanup/stuck-operation","complete","2025-11-27 21:26:10","2025-11-27 21:26:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764278770;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764278770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:26:26","2025-11-27 21:26:26","0",NULL),
("32108","image-optimization/cleanup/stuck-operation","complete","2025-11-27 21:31:26","2025-11-27 21:31:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764279086;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764279086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:32:08","2025-11-27 21:32:08","0",NULL),
("32109","image-optimization/cleanup/stuck-operation","complete","2025-11-27 21:37:08","2025-11-27 21:37:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764279428;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764279428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:53:33","2025-11-27 21:53:33","0",NULL),
("32110","image-optimization/cleanup/stuck-operation","complete","2025-11-27 21:58:33","2025-11-27 21:58:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764280713;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764280713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 21:59:24","2025-11-27 21:59:24","0",NULL),
("32111","image-optimization/cleanup/stuck-operation","complete","2025-11-27 22:04:24","2025-11-27 22:04:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764281064;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764281064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 22:07:54","2025-11-27 22:07:54","0",NULL),
("32112","image-optimization/cleanup/stuck-operation","complete","2025-11-27 22:12:54","2025-11-27 22:12:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764281574;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764281574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 22:21:48","2025-11-27 22:21:48","0",NULL),
("32113","image-optimization/cleanup/stuck-operation","complete","2025-11-27 22:26:48","2025-11-27 22:26:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764282408;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764282408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 22:28:58","2025-11-27 22:28:58","0",NULL),
("32114","image-optimization/cleanup/stuck-operation","complete","2025-11-27 22:33:58","2025-11-27 22:33:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764282838;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764282838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 22:34:21","2025-11-27 22:34:21","0",NULL),
("32115","image-optimization/cleanup/stuck-operation","complete","2025-11-27 22:39:21","2025-11-27 22:39:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764283161;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764283161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 22:49:09","2025-11-27 22:49:09","0",NULL),
("32116","image-optimization/cleanup/stuck-operation","complete","2025-11-27 22:54:09","2025-11-27 22:54:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764284049;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764284049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:01:23","2025-11-27 23:01:23","0",NULL),
("32117","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:06:23","2025-11-27 23:06:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764284783;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764284783;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:12:22","2025-11-27 23:12:22","0",NULL),
("32118","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:17:22","2025-11-27 23:17:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764285442;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764285442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:21:22","2025-11-27 23:21:22","0",NULL),
("32119","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:26:22","2025-11-27 23:26:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764285982;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764285982;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:26:56","2025-11-27 23:26:56","0",NULL),
("32120","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:31:56","2025-11-27 23:31:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764286316;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764286316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:33:22","2025-11-27 23:33:22","0",NULL),
("32121","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:38:22","2025-11-27 23:38:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764286702;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764286702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:43:36","2025-11-27 23:43:36","0",NULL),
("32122","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:48:36","2025-11-27 23:48:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764287316;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764287316;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:52:49","2025-11-27 23:52:49","0",NULL),
("32123","image-optimization/cleanup/stuck-operation","complete","2025-11-27 23:57:49","2025-11-27 23:57:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764287869;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764287869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-27 23:59:05","2025-11-27 23:59:05","0",NULL),
("32124","image-optimization/cleanup/stuck-operation","complete","2025-11-28 00:04:05","2025-11-28 00:04:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764288245;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764288245;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 00:07:15","2025-11-28 00:07:15","0",NULL),
("32125","image-optimization/cleanup/stuck-operation","complete","2025-11-28 00:12:15","2025-11-28 00:12:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764288735;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764288735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 00:18:37","2025-11-28 00:18:37","0",NULL),
("32126","image-optimization/cleanup/stuck-operation","complete","2025-11-28 00:23:37","2025-11-28 00:23:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764289417;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764289417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 00:27:12","2025-11-28 00:27:12","0",NULL),
("32127","image-optimization/cleanup/stuck-operation","complete","2025-11-28 00:32:12","2025-11-28 00:32:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764289932;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764289932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 00:37:14","2025-11-28 00:37:14","0",NULL),
("32128","image-optimization/cleanup/stuck-operation","complete","2025-11-28 00:42:14","2025-11-28 00:42:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764290534;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764290534;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 00:47:43","2025-11-28 00:47:43","0",NULL),
("32129","image-optimization/cleanup/stuck-operation","complete","2025-11-28 00:52:43","2025-11-28 00:52:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764291163;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764291163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 00:55:34","2025-11-28 00:55:34","0",NULL),
("32130","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:00:34","2025-11-28 01:00:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764291634;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764291634;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:05:21","2025-11-28 01:05:21","0",NULL),
("32131","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:10:21","2025-11-28 01:10:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764292221;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764292221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:12:57","2025-11-28 01:12:57","0",NULL),
("32132","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:17:57","2025-11-28 01:17:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764292677;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764292677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:19:52","2025-11-28 01:19:52","0",NULL),
("32133","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:24:52","2025-11-28 01:24:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764293092;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764293092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:27:04","2025-11-28 01:27:04","0",NULL),
("32134","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:32:04","2025-11-28 01:32:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764293524;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764293524;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:37:17","2025-11-28 01:37:17","0",NULL),
("32135","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:42:17","2025-11-28 01:42:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764294137;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764294137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:47:15","2025-11-28 01:47:15","0",NULL),
("32136","image-optimization/cleanup/stuck-operation","complete","2025-11-28 01:52:15","2025-11-28 01:52:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764294735;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764294735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 01:56:52","2025-11-28 01:56:52","0",NULL),
("32137","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:01:52","2025-11-28 02:01:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764295312;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764295312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:02:16","2025-11-28 02:02:16","0",NULL),
("32138","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:07:16","2025-11-28 02:07:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764295636;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764295636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:09:36","2025-11-28 02:09:36","0",NULL),
("32139","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:14:36","2025-11-28 02:14:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764296076;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764296076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:17:16","2025-11-28 02:17:16","0",NULL),
("32140","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:22:16","2025-11-28 02:22:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764296536;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764296536;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:22:50","2025-11-28 02:22:50","0",NULL),
("32141","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:27:50","2025-11-28 02:27:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764296870;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764296870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:28:01","2025-11-28 02:28:01","0",NULL),
("32142","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:33:01","2025-11-28 02:33:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764297181;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764297181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:36:43","2025-11-28 02:36:43","0",NULL),
("32143","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:41:43","2025-11-28 02:41:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764297703;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764297703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:47:16","2025-11-28 02:47:16","0",NULL),
("32144","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:52:16","2025-11-28 02:52:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764298336;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764298336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 02:53:24","2025-11-28 02:53:24","0",NULL),
("32145","image-optimization/cleanup/stuck-operation","complete","2025-11-28 02:58:24","2025-11-28 02:58:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764298704;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764298704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 03:00:42","2025-11-28 03:00:42","0",NULL),
("32146","image-optimization/cleanup/stuck-operation","complete","2025-11-28 03:05:42","2025-11-28 03:05:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764299142;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764299142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 03:10:42","2025-11-28 03:10:42","0",NULL),
("32147","image-optimization/cleanup/stuck-operation","complete","2025-11-28 03:15:42","2025-11-28 03:15:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764299742;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764299742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 03:25:18","2025-11-28 03:25:18","0",NULL),
("32148","image-optimization/cleanup/stuck-operation","complete","2025-11-28 03:30:18","2025-11-28 03:30:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764300618;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764300618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 03:36:07","2025-11-28 03:36:07","0",NULL),
("32149","image-optimization/cleanup/stuck-operation","complete","2025-11-28 03:41:07","2025-11-28 03:41:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764301267;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764301267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 03:43:30","2025-11-28 03:43:30","0",NULL),
("32150","image-optimization/cleanup/stuck-operation","complete","2025-11-28 03:48:30","2025-11-28 03:48:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764301710;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764301710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 03:52:27","2025-11-28 03:52:27","0",NULL),
("32151","image-optimization/cleanup/stuck-operation","complete","2025-11-28 03:57:27","2025-11-28 03:57:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764302247;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764302247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:00:46","2025-11-28 04:00:46","0",NULL),
("32152","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:05:46","2025-11-28 04:05:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764302746;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764302746;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:10:01","2025-11-28 04:10:01","0",NULL),
("32153","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:15:01","2025-11-28 04:15:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764303301;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764303301;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:17:42","2025-11-28 04:17:42","0",NULL),
("32154","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:22:42","2025-11-28 04:22:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764303762;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764303762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:26:21","2025-11-28 04:26:21","0",NULL),
("32155","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:31:21","2025-11-28 04:31:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764304281;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764304281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:34:55","2025-11-28 04:34:55","0",NULL),
("32156","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:39:55","2025-11-28 04:39:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764304795;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764304795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:43:32","2025-11-28 04:43:32","0",NULL),
("32157","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:48:32","2025-11-28 04:48:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764305312;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764305312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 04:52:36","2025-11-28 04:52:36","0",NULL),
("32158","image-optimization/cleanup/stuck-operation","complete","2025-11-28 04:57:36","2025-11-28 04:57:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764305856;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764305856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:09:17","2025-11-28 05:09:17","0",NULL),
("32159","image-optimization/cleanup/stuck-operation","complete","2025-11-28 05:14:17","2025-11-28 05:14:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764306857;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764306857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:15:20","2025-11-28 05:15:20","0",NULL),
("32160","image-optimization/cleanup/stuck-operation","complete","2025-11-28 05:20:20","2025-11-28 05:20:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764307220;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764307220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:26:00","2025-11-28 05:26:00","0",NULL),
("32161","image-optimization/cleanup/stuck-operation","complete","2025-11-28 05:31:00","2025-11-28 05:31:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764307860;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764307860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:33:43","2025-11-28 05:33:43","0",NULL),
("32162","image-optimization/cleanup/stuck-operation","complete","2025-11-28 05:38:43","2025-11-28 05:38:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764308323;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764308323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:45:06","2025-11-28 05:45:06","0",NULL),
("32163","image-optimization/cleanup/stuck-operation","complete","2025-11-28 05:50:06","2025-11-28 05:50:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764309006;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764309006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:52:07","2025-11-28 05:52:07","0",NULL),
("32164","image-optimization/cleanup/stuck-operation","complete","2025-11-28 05:57:07","2025-11-28 05:57:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764309427;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764309427;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 05:59:39","2025-11-28 05:59:39","0",NULL),
("32165","image-optimization/cleanup/stuck-operation","complete","2025-11-28 06:04:39","2025-11-28 06:04:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764309879;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764309879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 06:05:44","2025-11-28 06:05:44","0",NULL),
("32166","image-optimization/cleanup/stuck-operation","complete","2025-11-28 06:10:44","2025-11-28 06:10:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764310244;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764310244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 06:11:41","2025-11-28 06:11:41","0",NULL),
("32167","image-optimization/cleanup/stuck-operation","complete","2025-11-28 06:16:41","2025-11-28 06:16:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764310601;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764310601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 06:21:21","2025-11-28 06:21:21","0",NULL),
("32168","image-optimization/cleanup/stuck-operation","complete","2025-11-28 06:26:21","2025-11-28 06:26:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764311181;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764311181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 06:35:05","2025-11-28 06:35:05","0",NULL),
("32169","image-optimization/cleanup/stuck-operation","complete","2025-11-28 06:40:05","2025-11-28 06:40:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764312005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764312005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 06:56:18","2025-11-28 06:56:18","0",NULL),
("32170","image-optimization/cleanup/stuck-operation","complete","2025-11-28 07:01:18","2025-11-28 07:01:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764313278;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764313278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 07:07:04","2025-11-28 07:07:04","0",NULL),
("32171","image-optimization/cleanup/stuck-operation","complete","2025-11-28 07:12:04","2025-11-28 07:12:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764313924;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764313924;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 07:17:57","2025-11-28 07:17:57","0",NULL),
("32172","image-optimization/cleanup/stuck-operation","complete","2025-11-28 07:22:57","2025-11-28 07:22:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764314577;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764314577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 07:47:01","2025-11-28 07:47:01","0",NULL),
("32173","image-optimization/cleanup/stuck-operation","complete","2025-11-28 07:52:01","2025-11-28 07:52:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764316321;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764316321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 07:56:14","2025-11-28 07:56:14","0",NULL),
("32174","image-optimization/cleanup/stuck-operation","complete","2025-11-28 08:01:14","2025-11-28 08:01:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764316874;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764316874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 08:05:41","2025-11-28 08:05:41","0",NULL),
("32175","image-optimization/cleanup/stuck-operation","complete","2025-11-28 08:10:41","2025-11-28 08:10:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764317441;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764317441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 08:27:55","2025-11-28 08:27:55","0",NULL),
("32176","image-optimization/cleanup/stuck-operation","complete","2025-11-28 08:32:55","2025-11-28 08:32:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764318775;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764318775;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 08:33:46","2025-11-28 08:33:46","0",NULL),
("32177","image-optimization/cleanup/stuck-operation","complete","2025-11-28 08:38:46","2025-11-28 08:38:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764319126;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764319126;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 08:55:55","2025-11-28 08:55:55","0",NULL),
("32178","image-optimization/cleanup/stuck-operation","complete","2025-11-28 09:00:55","2025-11-28 09:00:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764320455;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764320455;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 09:18:55","2025-11-28 09:18:55","0",NULL),
("32179","image-optimization/cleanup/stuck-operation","complete","2025-11-28 09:23:55","2025-11-28 09:23:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764321835;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764321835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 09:36:12","2025-11-28 09:36:12","0",NULL),
("32180","image-optimization/cleanup/stuck-operation","complete","2025-11-28 09:41:12","2025-11-28 09:41:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764322872;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764322872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 10:08:38","2025-11-28 10:08:38","0",NULL),
("32181","image-optimization/cleanup/stuck-operation","complete","2025-11-28 10:13:38","2025-11-28 10:13:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764324818;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764324818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 10:28:22","2025-11-28 10:28:22","0",NULL),
("32182","image-optimization/cleanup/stuck-operation","complete","2025-11-28 10:33:22","2025-11-28 10:33:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764326002;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764326002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 10:36:49","2025-11-28 10:36:49","0",NULL),
("32183","image-optimization/cleanup/stuck-operation","complete","2025-11-28 10:41:49","2025-11-28 10:41:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764326509;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764326509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 10:46:33","2025-11-28 10:46:33","0",NULL),
("32184","image-optimization/cleanup/stuck-operation","complete","2025-11-28 10:51:33","2025-11-28 10:51:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764327093;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764327093;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 10:52:14","2025-11-28 10:52:14","0",NULL),
("32185","image-optimization/cleanup/stuck-operation","complete","2025-11-28 10:57:14","2025-11-28 10:57:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764327434;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764327434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 10:59:30","2025-11-28 10:59:30","0",NULL),
("32186","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:04:30","2025-11-28 11:04:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764327870;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764327870;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:05:53","2025-11-28 11:05:53","0",NULL),
("32187","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:10:53","2025-11-28 11:10:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764328253;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764328253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:11:10","2025-11-28 11:11:10","0",NULL),
("32188","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:16:10","2025-11-28 11:16:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764328570;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764328570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:17:30","2025-11-28 11:17:30","0",NULL),
("32189","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:22:30","2025-11-28 11:22:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764328950;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764328950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:26:32","2025-11-28 11:26:32","0",NULL),
("32190","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:31:32","2025-11-28 11:31:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764329492;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764329492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:34:31","2025-11-28 11:34:31","0",NULL),
("32191","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:39:31","2025-11-28 11:39:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764329971;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764329971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:46:17","2025-11-28 11:46:17","0",NULL),
("32192","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:51:17","2025-11-28 11:51:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764330677;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764330677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:53:49","2025-11-28 11:53:49","0",NULL),
("32193","image-optimization/cleanup/stuck-operation","complete","2025-11-28 11:58:49","2025-11-28 11:58:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764331129;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764331129;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 11:59:07","2025-11-28 11:59:07","0",NULL),
("32194","image-optimization/cleanup/stuck-operation","complete","2025-11-28 12:04:07","2025-11-28 12:04:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764331447;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764331447;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 12:07:41","2025-11-28 12:07:41","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("32195","image-optimization/cleanup/stuck-operation","complete","2025-11-28 12:12:41","2025-11-28 12:12:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764331961;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764331961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 12:16:27","2025-11-28 12:16:27","0",NULL),
("32196","image-optimization/cleanup/stuck-operation","complete","2025-11-28 12:21:27","2025-11-28 12:21:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764332487;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764332487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 12:22:03","2025-11-28 12:22:03","0",NULL),
("32197","image-optimization/cleanup/stuck-operation","complete","2025-11-28 12:27:03","2025-11-28 12:27:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764332823;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764332823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 12:43:59","2025-11-28 12:43:59","0",NULL),
("32198","image-optimization/cleanup/stuck-operation","complete","2025-11-28 12:48:59","2025-11-28 12:48:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764334139;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764334139;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 13:07:48","2025-11-28 13:07:48","0",NULL),
("32199","image-optimization/cleanup/stuck-operation","complete","2025-11-28 13:12:48","2025-11-28 13:12:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764335568;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764335568;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 13:58:58","2025-11-28 13:58:58","0",NULL),
("32200","image-optimization/cleanup/stuck-operation","complete","2025-11-28 14:03:58","2025-11-28 14:03:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764338638;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764338638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 14:18:26","2025-11-28 14:18:26","0",NULL),
("32201","image-optimization/cleanup/stuck-operation","complete","2025-11-28 14:23:26","2025-11-28 14:23:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764339806;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764339806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 15:18:53","2025-11-28 15:18:53","0",NULL),
("32202","image-optimization/cleanup/stuck-operation","complete","2025-11-28 15:23:53","2025-11-28 15:23:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764343433;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764343433;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 15:32:59","2025-11-28 15:32:59","0",NULL),
("32203","image-optimization/cleanup/stuck-operation","complete","2025-11-28 15:37:59","2025-11-28 15:37:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764344279;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764344279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 16:08:49","2025-11-28 16:08:49","0",NULL),
("32204","image-optimization/cleanup/stuck-operation","complete","2025-11-28 16:13:49","2025-11-28 16:13:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764346429;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764346429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 16:23:49","2025-11-28 16:23:49","0",NULL),
("32205","image-optimization/cleanup/stuck-operation","complete","2025-11-28 16:28:49","2025-11-28 16:28:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764347329;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764347329;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 16:43:03","2025-11-28 16:43:03","0",NULL),
("32206","image-optimization/cleanup/stuck-operation","complete","2025-11-28 16:48:03","2025-11-28 16:48:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764348483;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764348483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 16:57:02","2025-11-28 16:57:02","0",NULL),
("32207","image-optimization/cleanup/stuck-operation","complete","2025-11-28 17:02:02","2025-11-28 17:02:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764349322;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764349322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 17:07:47","2025-11-28 17:07:47","0",NULL),
("32208","image-optimization/cleanup/stuck-operation","complete","2025-11-28 17:12:47","2025-11-28 17:12:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764349967;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764349967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 18:09:59","2025-11-28 18:09:59","0",NULL),
("32209","image-optimization/cleanup/stuck-operation","complete","2025-11-28 18:14:59","2025-11-28 18:14:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764353699;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764353699;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 18:25:52","2025-11-28 18:25:52","0",NULL),
("32210","image-optimization/cleanup/stuck-operation","complete","2025-11-28 18:30:52","2025-11-28 18:30:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764354652;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764354652;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 18:32:29","2025-11-28 18:32:29","0",NULL),
("32211","image-optimization/cleanup/stuck-operation","complete","2025-11-28 18:37:29","2025-11-28 18:37:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764355049;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764355049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 18:55:38","2025-11-28 18:55:38","0",NULL),
("32212","image-optimization/cleanup/stuck-operation","complete","2025-11-28 19:00:38","2025-11-28 19:00:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764356438;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764356438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 19:15:38","2025-11-28 19:15:38","0",NULL),
("32213","image-optimization/cleanup/stuck-operation","complete","2025-11-28 19:20:50","2025-11-28 19:20:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764357650;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764357650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 19:26:10","2025-11-28 19:26:10","0",NULL),
("32214","image-optimization/cleanup/stuck-operation","complete","2025-11-28 19:31:10","2025-11-28 19:31:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764358270;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764358270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 19:44:51","2025-11-28 19:44:51","0",NULL),
("32215","image-optimization/cleanup/stuck-operation","complete","2025-11-28 19:49:51","2025-11-28 19:49:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764359391;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764359391;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 20:08:16","2025-11-28 20:08:16","0",NULL),
("32216","image-optimization/cleanup/stuck-operation","complete","2025-11-28 20:13:16","2025-11-28 20:13:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764360796;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764360796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 20:20:57","2025-11-28 20:20:57","0",NULL),
("32217","image-optimization/cleanup/stuck-operation","complete","2025-11-28 20:25:57","2025-11-28 20:25:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764361557;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764361557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 20:37:32","2025-11-28 20:37:32","0",NULL),
("32218","image-optimization/cleanup/stuck-operation","complete","2025-11-28 20:42:32","2025-11-28 20:42:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764362552;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764362552;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 20:47:56","2025-11-28 20:47:56","0",NULL),
("32219","image-optimization/cleanup/stuck-operation","complete","2025-11-28 20:52:56","2025-11-28 20:52:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764363176;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764363176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 21:02:34","2025-11-28 21:02:34","0",NULL),
("32220","image-optimization/cleanup/stuck-operation","complete","2025-11-28 21:07:34","2025-11-28 21:07:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764364054;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764364054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 21:22:32","2025-11-28 21:22:32","0",NULL),
("32221","image-optimization/cleanup/stuck-operation","complete","2025-11-28 21:27:32","2025-11-28 21:27:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764365252;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764365252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 21:39:55","2025-11-28 21:39:55","0",NULL),
("32222","image-optimization/cleanup/stuck-operation","complete","2025-11-28 21:44:55","2025-11-28 21:44:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764366295;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764366295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 22:00:46","2025-11-28 22:00:46","0",NULL),
("32223","image-optimization/cleanup/stuck-operation","complete","2025-11-28 22:05:46","2025-11-28 22:05:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764367546;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764367546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 22:14:43","2025-11-28 22:14:43","0",NULL),
("32224","image-optimization/cleanup/stuck-operation","complete","2025-11-28 22:19:43","2025-11-28 22:19:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764368383;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764368383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 22:23:21","2025-11-28 22:23:21","0",NULL),
("32225","image-optimization/cleanup/stuck-operation","complete","2025-11-28 22:28:21","2025-11-28 22:28:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764368901;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764368901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 22:32:42","2025-11-28 22:32:42","0",NULL),
("32226","image-optimization/cleanup/stuck-operation","complete","2025-11-28 22:37:42","2025-11-28 22:37:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764369462;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764369462;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 22:50:20","2025-11-28 22:50:20","0",NULL),
("32227","image-optimization/cleanup/stuck-operation","complete","2025-11-28 22:55:20","2025-11-28 22:55:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764370520;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764370520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 22:58:25","2025-11-28 22:58:25","0",NULL),
("32228","image-optimization/cleanup/stuck-operation","complete","2025-11-28 23:03:25","2025-11-28 23:03:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764371005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764371005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 23:03:44","2025-11-28 23:03:44","0",NULL),
("32229","image-optimization/cleanup/stuck-operation","complete","2025-11-28 23:08:44","2025-11-28 23:08:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764371324;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764371324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 23:33:18","2025-11-28 23:33:18","0",NULL),
("32230","image-optimization/cleanup/stuck-operation","complete","2025-11-28 23:38:18","2025-11-28 23:38:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764373098;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764373098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 23:48:34","2025-11-28 23:48:34","0",NULL),
("32231","image-optimization/cleanup/stuck-operation","complete","2025-11-28 23:53:34","2025-11-28 23:53:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764374014;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764374014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-28 23:56:47","2025-11-28 23:56:47","0",NULL),
("32232","image-optimization/cleanup/stuck-operation","complete","2025-11-29 00:01:47","2025-11-29 00:01:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764374507;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764374507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 00:15:48","2025-11-29 00:15:48","0",NULL),
("32233","image-optimization/cleanup/stuck-operation","complete","2025-11-29 00:20:48","2025-11-29 00:20:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764375648;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764375648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 00:43:31","2025-11-29 00:43:31","0",NULL),
("32234","image-optimization/cleanup/stuck-operation","complete","2025-11-29 00:48:31","2025-11-29 00:48:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764377311;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764377311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 01:08:33","2025-11-29 01:08:33","0",NULL),
("32235","image-optimization/cleanup/stuck-operation","complete","2025-11-29 01:13:33","2025-11-29 01:13:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764378813;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764378813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 01:14:23","2025-11-29 01:14:23","0",NULL),
("32236","image-optimization/cleanup/stuck-operation","complete","2025-11-29 01:19:23","2025-11-29 01:19:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764379163;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764379163;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 01:25:39","2025-11-29 01:25:39","0",NULL),
("32237","image-optimization/cleanup/stuck-operation","complete","2025-11-29 01:30:39","2025-11-29 01:30:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764379839;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764379839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 01:33:31","2025-11-29 01:33:31","0",NULL),
("32238","image-optimization/cleanup/stuck-operation","complete","2025-11-29 01:38:31","2025-11-29 01:38:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764380311;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764380311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 01:52:34","2025-11-29 01:52:34","0",NULL),
("32239","image-optimization/cleanup/stuck-operation","complete","2025-11-29 01:57:34","2025-11-29 01:57:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764381454;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764381454;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 02:08:08","2025-11-29 02:08:08","0",NULL),
("32240","image-optimization/cleanup/stuck-operation","complete","2025-11-29 02:13:08","2025-11-29 02:13:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764382388;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764382388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 02:18:21","2025-11-29 02:18:21","0",NULL),
("32241","image-optimization/cleanup/stuck-operation","complete","2025-11-29 02:23:21","2025-11-29 02:23:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764383001;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764383001;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 02:34:24","2025-11-29 02:34:24","0",NULL),
("32242","image-optimization/cleanup/stuck-operation","complete","2025-11-29 02:39:24","2025-11-29 02:39:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764383964;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764383964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 02:42:36","2025-11-29 02:42:36","0",NULL),
("32243","image-optimization/cleanup/stuck-operation","complete","2025-11-29 02:47:36","2025-11-29 02:47:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764384456;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764384456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 03:20:24","2025-11-29 03:20:24","0",NULL),
("32244","image-optimization/cleanup/stuck-operation","complete","2025-11-29 03:25:24","2025-11-29 03:25:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764386724;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764386724;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 03:26:58","2025-11-29 03:26:58","0",NULL),
("32245","image-optimization/cleanup/stuck-operation","complete","2025-11-29 03:31:58","2025-11-29 03:31:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764387118;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764387118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 03:37:15","2025-11-29 03:37:15","0",NULL),
("32246","image-optimization/cleanup/stuck-operation","complete","2025-11-29 03:42:15","2025-11-29 03:42:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764387735;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764387735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 03:51:53","2025-11-29 03:51:53","0",NULL),
("32247","image-optimization/cleanup/stuck-operation","complete","2025-11-29 03:56:53","2025-11-29 03:56:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764388613;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764388613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 03:58:55","2025-11-29 03:58:55","0",NULL),
("32248","image-optimization/cleanup/stuck-operation","complete","2025-11-29 04:03:55","2025-11-29 04:03:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764389035;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764389035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 04:08:58","2025-11-29 04:08:58","0",NULL),
("32249","image-optimization/cleanup/stuck-operation","complete","2025-11-29 04:13:58","2025-11-29 04:13:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764389638;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764389638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 04:14:17","2025-11-29 04:14:17","0",NULL),
("32250","image-optimization/cleanup/stuck-operation","complete","2025-11-29 04:19:17","2025-11-29 04:19:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764389957;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764389957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 04:49:29","2025-11-29 04:49:29","0",NULL),
("32251","image-optimization/cleanup/stuck-operation","complete","2025-11-29 04:54:29","2025-11-29 04:54:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764392069;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764392069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 05:02:59","2025-11-29 05:02:59","0",NULL),
("32252","image-optimization/cleanup/stuck-operation","complete","2025-11-29 05:07:59","2025-11-29 05:07:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764392879;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764392879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 05:11:13","2025-11-29 05:11:13","0",NULL),
("32253","image-optimization/cleanup/stuck-operation","complete","2025-11-29 05:16:13","2025-11-29 05:16:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764393373;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764393373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 05:22:12","2025-11-29 05:22:12","0",NULL),
("32254","image-optimization/cleanup/stuck-operation","complete","2025-11-29 05:27:12","2025-11-29 05:27:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764394032;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764394032;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 05:47:19","2025-11-29 05:47:19","0",NULL),
("32255","image-optimization/cleanup/stuck-operation","complete","2025-11-29 05:52:27","2025-11-29 05:52:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764395547;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764395547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 06:00:24","2025-11-29 06:00:24","0",NULL),
("32256","image-optimization/cleanup/stuck-operation","complete","2025-11-29 06:05:24","2025-11-29 06:05:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764396324;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764396324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 06:13:48","2025-11-29 06:13:48","0",NULL),
("32257","image-optimization/cleanup/stuck-operation","complete","2025-11-29 06:18:48","2025-11-29 06:18:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764397128;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764397128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 06:42:07","2025-11-29 06:42:07","0",NULL),
("32258","image-optimization/cleanup/stuck-operation","complete","2025-11-29 06:47:07","2025-11-29 06:47:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764398827;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764398827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 06:55:18","2025-11-29 06:55:18","0",NULL),
("32259","image-optimization/cleanup/stuck-operation","complete","2025-11-29 07:00:18","2025-11-29 07:00:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764399618;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764399618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 07:07:33","2025-11-29 07:07:33","0",NULL),
("32260","image-optimization/cleanup/stuck-operation","complete","2025-11-29 07:12:33","2025-11-29 07:12:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764400353;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764400353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 07:18:46","2025-11-29 07:18:46","0",NULL),
("32261","image-optimization/cleanup/stuck-operation","complete","2025-11-29 07:23:46","2025-11-29 07:23:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764401026;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764401026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 07:31:40","2025-11-29 07:31:40","0",NULL),
("32262","image-optimization/cleanup/stuck-operation","complete","2025-11-29 07:36:40","2025-11-29 07:36:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764401800;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764401800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 07:46:50","2025-11-29 07:46:50","0",NULL),
("32263","image-optimization/cleanup/stuck-operation","complete","2025-11-29 07:51:50","2025-11-29 07:51:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764402710;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764402710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 07:54:19","2025-11-29 07:54:19","0",NULL),
("32264","image-optimization/cleanup/stuck-operation","complete","2025-11-29 07:59:19","2025-11-29 07:59:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764403159;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764403159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 08:09:11","2025-11-29 08:09:11","0",NULL),
("32265","image-optimization/cleanup/stuck-operation","complete","2025-11-29 08:14:11","2025-11-29 08:14:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764404051;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764404051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 08:27:18","2025-11-29 08:27:18","0",NULL),
("32266","image-optimization/cleanup/stuck-operation","complete","2025-11-29 08:32:18","2025-11-29 08:32:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764405138;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764405138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 08:38:31","2025-11-29 08:38:31","0",NULL),
("32267","image-optimization/cleanup/stuck-operation","complete","2025-11-29 08:43:31","2025-11-29 08:43:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764405811;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764405811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 08:53:51","2025-11-29 08:53:51","0",NULL),
("32268","image-optimization/cleanup/stuck-operation","complete","2025-11-29 08:58:51","2025-11-29 08:58:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764406731;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764406731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 08:59:18","2025-11-29 08:59:18","0",NULL),
("32269","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:04:18","2025-11-29 09:04:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764407058;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764407058;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:04:33","2025-11-29 09:04:33","0",NULL),
("32270","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:09:33","2025-11-29 09:09:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764407373;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764407373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:10:22","2025-11-29 09:10:22","0",NULL),
("32271","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:15:22","2025-11-29 09:15:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764407722;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764407722;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:21:23","2025-11-29 09:21:23","0",NULL),
("32272","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:26:23","2025-11-29 09:26:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764408383;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764408383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:32:37","2025-11-29 09:32:37","0",NULL),
("32273","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:37:37","2025-11-29 09:37:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764409057;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764409057;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:37:53","2025-11-29 09:37:53","0",NULL),
("32274","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:42:53","2025-11-29 09:42:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764409373;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764409373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:43:24","2025-11-29 09:43:24","0",NULL),
("32275","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:48:24","2025-11-29 09:48:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764409704;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764409704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 09:54:09","2025-11-29 09:54:09","0",NULL),
("32276","image-optimization/cleanup/stuck-operation","complete","2025-11-29 09:59:09","2025-11-29 09:59:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764410349;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764410349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 10:01:41","2025-11-29 10:01:41","0",NULL),
("32277","image-optimization/cleanup/stuck-operation","complete","2025-11-29 10:06:41","2025-11-29 10:06:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764410801;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764410801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 10:13:39","2025-11-29 10:13:39","0",NULL),
("32278","image-optimization/cleanup/stuck-operation","complete","2025-11-29 10:18:39","2025-11-29 10:18:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764411519;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764411519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 10:30:56","2025-11-29 10:30:56","0",NULL),
("32279","image-optimization/cleanup/stuck-operation","complete","2025-11-29 10:35:56","2025-11-29 10:35:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764412556;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764412556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 11:00:08","2025-11-29 11:00:08","0",NULL),
("32280","image-optimization/cleanup/stuck-operation","complete","2025-11-29 11:05:08","2025-11-29 11:05:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764414308;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764414308;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 11:26:01","2025-11-29 11:26:01","0",NULL),
("32281","image-optimization/cleanup/stuck-operation","complete","2025-11-29 11:31:01","2025-11-29 11:31:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764415861;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764415861;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 11:33:53","2025-11-29 11:33:53","0",NULL),
("32282","image-optimization/cleanup/stuck-operation","complete","2025-11-29 11:38:53","2025-11-29 11:38:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764416333;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764416333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 12:04:37","2025-11-29 12:04:37","0",NULL),
("32283","image-optimization/cleanup/stuck-operation","complete","2025-11-29 12:09:37","2025-11-29 12:09:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764418177;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764418177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 12:22:59","2025-11-29 12:22:59","0",NULL),
("32284","image-optimization/cleanup/stuck-operation","complete","2025-11-29 12:27:59","2025-11-29 12:27:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764419279;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764419279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 12:51:45","2025-11-29 12:51:45","0",NULL),
("32285","image-optimization/cleanup/stuck-operation","complete","2025-11-29 12:56:45","2025-11-29 12:56:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764421005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764421005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 14:43:43","2025-11-29 14:43:43","0",NULL),
("32286","image-optimization/cleanup/stuck-operation","complete","2025-11-29 14:48:43","2025-11-29 14:48:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764427723;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764427723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 14:50:25","2025-11-29 14:50:25","0",NULL),
("32287","image-optimization/cleanup/stuck-operation","complete","2025-11-29 14:55:25","2025-11-29 14:55:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764428125;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764428125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 15:40:54","2025-11-29 15:40:54","0",NULL),
("32288","image-optimization/cleanup/stuck-operation","complete","2025-11-29 15:45:54","2025-11-29 15:45:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764431154;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764431154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 16:01:53","2025-11-29 16:01:53","0",NULL),
("32289","image-optimization/cleanup/stuck-operation","complete","2025-11-29 16:06:53","2025-11-29 16:06:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764432413;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764432413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 16:12:24","2025-11-29 16:12:24","0",NULL),
("32290","image-optimization/cleanup/stuck-operation","complete","2025-11-29 16:17:24","2025-11-29 16:17:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764433044;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764433044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 16:18:58","2025-11-29 16:18:58","0",NULL),
("32291","image-optimization/cleanup/stuck-operation","complete","2025-11-29 16:23:58","2025-11-29 16:23:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764433438;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764433438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 16:29:21","2025-11-29 16:29:21","0",NULL),
("32292","image-optimization/cleanup/stuck-operation","complete","2025-11-29 16:34:21","2025-11-29 16:34:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764434061;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764434061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 17:37:30","2025-11-29 17:37:30","0",NULL),
("32293","image-optimization/cleanup/stuck-operation","complete","2025-11-29 17:42:30","2025-11-29 17:42:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764438150;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764438150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 17:43:59","2025-11-29 17:43:59","0",NULL),
("32294","image-optimization/cleanup/stuck-operation","complete","2025-11-29 17:48:59","2025-11-29 17:48:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764438539;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764438539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 17:50:45","2025-11-29 17:50:45","0",NULL),
("32295","image-optimization/cleanup/stuck-operation","complete","2025-11-29 17:55:45","2025-11-29 17:55:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764438945;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764438945;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 18:05:44","2025-11-29 18:05:44","0",NULL),
("32296","image-optimization/cleanup/stuck-operation","complete","2025-11-29 18:10:44","2025-11-29 18:10:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764439844;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764439844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 18:28:00","2025-11-29 18:28:00","0",NULL),
("32297","image-optimization/cleanup/stuck-operation","complete","2025-11-29 18:33:00","2025-11-29 18:33:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764441180;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764441180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 18:50:02","2025-11-29 18:50:02","0",NULL),
("32298","image-optimization/cleanup/stuck-operation","complete","2025-11-29 18:55:02","2025-11-29 18:55:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764442502;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764442502;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 18:56:20","2025-11-29 18:56:20","0",NULL),
("32299","image-optimization/cleanup/stuck-operation","complete","2025-11-29 19:01:20","2025-11-29 19:01:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764442880;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764442880;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 19:20:38","2025-11-29 19:20:38","0",NULL),
("32300","image-optimization/cleanup/stuck-operation","complete","2025-11-29 19:25:38","2025-11-29 19:25:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764444338;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764444338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 19:32:54","2025-11-29 19:32:54","0",NULL),
("32301","image-optimization/cleanup/stuck-operation","complete","2025-11-29 19:37:54","2025-11-29 19:37:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764445074;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764445074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 19:52:14","2025-11-29 19:52:14","0",NULL),
("32302","image-optimization/cleanup/stuck-operation","complete","2025-11-29 19:57:14","2025-11-29 19:57:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764446234;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764446234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 20:02:29","2025-11-29 20:02:29","0",NULL),
("32303","image-optimization/cleanup/stuck-operation","complete","2025-11-29 20:07:29","2025-11-29 20:07:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764446849;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764446849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 20:15:18","2025-11-29 20:15:18","0",NULL),
("32304","image-optimization/cleanup/stuck-operation","complete","2025-11-29 20:20:18","2025-11-29 20:20:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764447618;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764447618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 20:22:50","2025-11-29 20:22:50","0",NULL),
("32305","image-optimization/cleanup/stuck-operation","complete","2025-11-29 20:27:50","2025-11-29 20:27:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764448070;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764448070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 20:34:13","2025-11-29 20:34:13","0",NULL),
("32306","image-optimization/cleanup/stuck-operation","complete","2025-11-29 20:39:13","2025-11-29 20:39:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764448753;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764448753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 20:47:07","2025-11-29 20:47:07","0",NULL),
("32307","image-optimization/cleanup/stuck-operation","complete","2025-11-29 20:52:07","2025-11-29 20:52:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764449527;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764449527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 21:15:04","2025-11-29 21:15:04","0",NULL),
("32308","image-optimization/cleanup/stuck-operation","complete","2025-11-29 21:20:04","2025-11-29 21:20:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764451204;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764451204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 21:23:17","2025-11-29 21:23:17","0",NULL),
("32309","image-optimization/cleanup/stuck-operation","complete","2025-11-29 21:28:17","2025-11-29 21:28:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764451697;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764451697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 22:00:01","2025-11-29 22:00:01","0",NULL),
("32310","image-optimization/cleanup/stuck-operation","complete","2025-11-29 22:05:01","2025-11-29 22:05:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764453901;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764453901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 22:05:41","2025-11-29 22:05:41","0",NULL),
("32311","image-optimization/cleanup/stuck-operation","complete","2025-11-29 22:10:41","2025-11-29 22:10:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764454241;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764454241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 22:30:07","2025-11-29 22:30:07","0",NULL),
("32312","image-optimization/cleanup/stuck-operation","complete","2025-11-29 22:35:07","2025-11-29 22:35:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764455707;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764455707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 22:41:42","2025-11-29 22:41:42","0",NULL),
("32313","image-optimization/cleanup/stuck-operation","complete","2025-11-29 22:46:42","2025-11-29 22:46:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764456402;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764456402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 23:00:19","2025-11-29 23:00:19","0",NULL),
("32314","image-optimization/cleanup/stuck-operation","complete","2025-11-29 23:05:19","2025-11-29 23:05:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764457519;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764457519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 23:06:43","2025-11-29 23:06:43","0",NULL),
("32315","image-optimization/cleanup/stuck-operation","complete","2025-11-29 23:11:43","2025-11-29 23:11:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764457903;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764457903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 23:17:35","2025-11-29 23:17:35","0",NULL),
("32316","image-optimization/cleanup/stuck-operation","complete","2025-11-29 23:22:35","2025-11-29 23:22:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764458555;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764458555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 23:42:05","2025-11-29 23:42:05","0",NULL),
("32317","image-optimization/cleanup/stuck-operation","complete","2025-11-29 23:47:05","2025-11-29 23:47:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764460025;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764460025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-29 23:56:43","2025-11-29 23:56:43","0",NULL),
("32318","image-optimization/cleanup/stuck-operation","complete","2025-11-30 00:01:43","2025-11-30 00:01:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764460903;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764460903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 00:02:10","2025-11-30 00:02:10","0",NULL),
("32319","image-optimization/cleanup/stuck-operation","complete","2025-11-30 00:07:10","2025-11-30 00:07:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764461230;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764461230;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 00:21:42","2025-11-30 00:21:42","0",NULL),
("32320","image-optimization/cleanup/stuck-operation","complete","2025-11-30 00:26:42","2025-11-30 00:26:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764462402;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764462402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 00:33:01","2025-11-30 00:33:01","0",NULL),
("32321","image-optimization/cleanup/stuck-operation","complete","2025-11-30 00:38:01","2025-11-30 00:38:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764463081;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764463081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 00:51:43","2025-11-30 00:51:43","0",NULL),
("32322","image-optimization/cleanup/stuck-operation","complete","2025-11-30 00:56:43","2025-11-30 00:56:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764464203;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764464203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 01:01:16","2025-11-30 01:01:16","0",NULL),
("32323","image-optimization/cleanup/stuck-operation","complete","2025-11-30 01:06:16","2025-11-30 01:06:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764464776;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764464776;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 01:06:50","2025-11-30 01:06:50","0",NULL),
("32324","image-optimization/cleanup/stuck-operation","complete","2025-11-30 01:11:50","2025-11-30 01:11:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764465110;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764465110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 01:16:36","2025-11-30 01:16:36","0",NULL),
("32325","image-optimization/cleanup/stuck-operation","complete","2025-11-30 01:21:36","2025-11-30 01:21:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764465696;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764465696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 01:31:57","2025-11-30 01:31:57","0",NULL),
("32326","image-optimization/cleanup/stuck-operation","complete","2025-11-30 01:36:57","2025-11-30 01:36:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764466617;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764466617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 01:41:43","2025-11-30 01:41:43","0",NULL),
("32327","image-optimization/cleanup/stuck-operation","complete","2025-11-30 01:46:43","2025-11-30 01:46:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764467203;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764467203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 01:53:16","2025-11-30 01:53:16","0",NULL),
("32328","image-optimization/cleanup/stuck-operation","complete","2025-11-30 01:58:16","2025-11-30 01:58:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764467896;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764467896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 02:04:48","2025-11-30 02:04:48","0",NULL),
("32329","image-optimization/cleanup/stuck-operation","complete","2025-11-30 02:09:48","2025-11-30 02:09:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764468588;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764468588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 02:14:24","2025-11-30 02:14:24","0",NULL),
("32330","image-optimization/cleanup/stuck-operation","complete","2025-11-30 02:19:24","2025-11-30 02:19:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764469164;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764469164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 02:27:52","2025-11-30 02:27:52","0",NULL),
("32331","image-optimization/cleanup/stuck-operation","complete","2025-11-30 02:32:52","2025-11-30 02:32:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764469972;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764469972;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 02:39:26","2025-11-30 02:39:26","0",NULL),
("32332","image-optimization/cleanup/stuck-operation","complete","2025-11-30 02:44:26","2025-11-30 02:44:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764470666;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764470666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 02:49:26","2025-11-30 02:49:26","0",NULL),
("32333","image-optimization/cleanup/stuck-operation","complete","2025-11-30 02:54:26","2025-11-30 02:54:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764471266;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764471266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 02:55:33","2025-11-30 02:55:33","0",NULL),
("32334","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:00:33","2025-11-30 03:00:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764471633;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764471633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:00:50","2025-11-30 03:00:50","0",NULL),
("32335","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:05:50","2025-11-30 03:05:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764471950;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764471950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:06:59","2025-11-30 03:06:59","0",NULL),
("32336","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:11:59","2025-11-30 03:11:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764472319;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764472319;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:13:06","2025-11-30 03:13:06","0",NULL),
("32337","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:18:06","2025-11-30 03:18:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764472686;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764472686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:19:12","2025-11-30 03:19:12","0",NULL),
("32338","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:24:12","2025-11-30 03:24:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764473052;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764473052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:25:19","2025-11-30 03:25:19","0",NULL),
("32339","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:30:19","2025-11-30 03:30:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764473419;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764473419;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:31:27","2025-11-30 03:31:27","0",NULL),
("32340","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:36:27","2025-11-30 03:36:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764473787;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764473787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:37:33","2025-11-30 03:37:33","0",NULL),
("32341","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:42:33","2025-11-30 03:42:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764474153;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764474153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:43:41","2025-11-30 03:43:41","0",NULL),
("32342","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:48:41","2025-11-30 03:48:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764474521;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764474521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:49:49","2025-11-30 03:49:49","0",NULL),
("32343","image-optimization/cleanup/stuck-operation","complete","2025-11-30 03:54:49","2025-11-30 03:54:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764474889;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764474889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 03:56:47","2025-11-30 03:56:47","0",NULL),
("32344","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:01:47","2025-11-30 04:01:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764475307;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764475307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:03:09","2025-11-30 04:03:09","0",NULL),
("32345","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:08:09","2025-11-30 04:08:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764475689;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764475689;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:10:45","2025-11-30 04:10:45","0",NULL),
("32346","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:15:45","2025-11-30 04:15:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764476145;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764476145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:17:43","2025-11-30 04:17:43","0",NULL),
("32347","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:22:43","2025-11-30 04:22:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764476563;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764476563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:24:44","2025-11-30 04:24:44","0",NULL),
("32348","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:29:44","2025-11-30 04:29:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764476984;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764476984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:31:41","2025-11-30 04:31:41","0",NULL),
("32349","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:36:41","2025-11-30 04:36:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764477401;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764477401;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:38:38","2025-11-30 04:38:38","0",NULL),
("32350","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:43:38","2025-11-30 04:43:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764477818;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764477818;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:45:39","2025-11-30 04:45:39","0",NULL),
("32351","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:50:39","2025-11-30 04:50:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764478239;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764478239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:52:09","2025-11-30 04:52:09","0",NULL),
("32352","image-optimization/cleanup/stuck-operation","complete","2025-11-30 04:57:09","2025-11-30 04:57:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764478629;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764478629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 04:58:41","2025-11-30 04:58:41","0",NULL),
("32353","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:03:41","2025-11-30 05:03:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764479021;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764479021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:05:12","2025-11-30 05:05:12","0",NULL),
("32354","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:10:12","2025-11-30 05:10:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764479412;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764479412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:11:43","2025-11-30 05:11:43","0",NULL),
("32355","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:16:43","2025-11-30 05:16:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764479803;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764479803;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:18:15","2025-11-30 05:18:15","0",NULL),
("32356","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:23:15","2025-11-30 05:23:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764480195;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764480195;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:24:46","2025-11-30 05:24:46","0",NULL),
("32357","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:29:46","2025-11-30 05:29:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764480586;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764480586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:37:47","2025-11-30 05:37:47","0",NULL),
("32358","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:42:47","2025-11-30 05:42:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764481367;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764481367;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:45:38","2025-11-30 05:45:38","0",NULL),
("32359","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:50:38","2025-11-30 05:50:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764481838;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764481838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:50:52","2025-11-30 05:50:52","0",NULL),
("32360","image-optimization/cleanup/stuck-operation","complete","2025-11-30 05:55:52","2025-11-30 05:55:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764482152;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764482152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 05:56:29","2025-11-30 05:56:29","0",NULL),
("32361","image-optimization/cleanup/stuck-operation","complete","2025-11-30 06:01:29","2025-11-30 06:01:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764482489;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764482489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 06:03:20","2025-11-30 06:03:20","0",NULL),
("32362","image-optimization/cleanup/stuck-operation","complete","2025-11-30 06:08:20","2025-11-30 06:08:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764482900;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764482900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 06:11:14","2025-11-30 06:11:14","0",NULL),
("32363","image-optimization/cleanup/stuck-operation","complete","2025-11-30 06:16:14","2025-11-30 06:16:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764483374;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764483374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 06:21:25","2025-11-30 06:21:25","0",NULL),
("32364","image-optimization/cleanup/stuck-operation","complete","2025-11-30 06:26:25","2025-11-30 06:26:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764483985;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764483985;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 07:03:55","2025-11-30 07:03:55","0",NULL),
("32365","image-optimization/cleanup/stuck-operation","complete","2025-11-30 07:08:55","2025-11-30 07:08:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764486535;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764486535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 07:24:39","2025-11-30 07:24:39","0",NULL),
("32366","image-optimization/cleanup/stuck-operation","complete","2025-11-30 07:29:39","2025-11-30 07:29:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764487779;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764487779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 07:29:55","2025-11-30 07:29:55","0",NULL),
("32367","image-optimization/cleanup/stuck-operation","complete","2025-11-30 07:34:55","2025-11-30 07:34:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764488095;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764488095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 07:53:27","2025-11-30 07:53:27","0",NULL),
("32368","image-optimization/cleanup/stuck-operation","complete","2025-11-30 07:58:27","2025-11-30 07:58:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764489507;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764489507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 08:05:27","2025-11-30 08:05:27","0",NULL),
("32369","image-optimization/cleanup/stuck-operation","complete","2025-11-30 08:10:27","2025-11-30 08:10:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764490227;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764490227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 08:36:58","2025-11-30 08:36:58","0",NULL),
("32370","image-optimization/cleanup/stuck-operation","complete","2025-11-30 08:41:58","2025-11-30 08:41:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764492118;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764492118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 09:22:33","2025-11-30 09:22:33","0",NULL),
("32371","image-optimization/cleanup/stuck-operation","complete","2025-11-30 09:27:33","2025-11-30 09:27:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764494853;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764494853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 10:12:15","2025-11-30 10:12:15","0",NULL),
("32372","image-optimization/cleanup/stuck-operation","complete","2025-11-30 10:17:15","2025-11-30 10:17:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764497835;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764497835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 10:18:35","2025-11-30 10:18:35","0",NULL),
("32373","image-optimization/cleanup/stuck-operation","complete","2025-11-30 10:23:35","2025-11-30 10:23:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764498215;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764498215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 10:31:11","2025-11-30 10:31:11","0",NULL),
("32374","image-optimization/cleanup/stuck-operation","complete","2025-11-30 10:36:11","2025-11-30 10:36:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764498971;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764498971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 11:02:03","2025-11-30 11:02:03","0",NULL),
("32375","image-optimization/cleanup/stuck-operation","complete","2025-11-30 11:07:03","2025-11-30 11:07:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764500823;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764500823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 11:21:59","2025-11-30 11:21:59","0",NULL),
("32376","image-optimization/cleanup/stuck-operation","complete","2025-11-30 11:26:59","2025-11-30 11:26:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764502019;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764502019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 11:29:38","2025-11-30 11:29:38","0",NULL),
("32377","image-optimization/cleanup/stuck-operation","complete","2025-11-30 11:34:38","2025-11-30 11:34:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764502478;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764502478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 11:35:37","2025-11-30 11:35:37","0",NULL),
("32378","image-optimization/cleanup/stuck-operation","complete","2025-11-30 11:40:37","2025-11-30 11:40:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764502837;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764502837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 11:43:30","2025-11-30 11:43:30","0",NULL),
("32379","image-optimization/cleanup/stuck-operation","complete","2025-11-30 11:48:30","2025-11-30 11:48:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764503310;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764503310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 12:14:53","2025-11-30 12:14:53","0",NULL),
("32380","image-optimization/cleanup/stuck-operation","complete","2025-11-30 12:19:53","2025-11-30 12:19:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764505193;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764505193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 12:35:29","2025-11-30 12:35:29","0",NULL),
("32381","image-optimization/cleanup/stuck-operation","complete","2025-11-30 12:40:29","2025-11-30 12:40:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764506429;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764506429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 12:45:53","2025-11-30 12:45:53","0",NULL),
("32382","image-optimization/cleanup/stuck-operation","complete","2025-11-30 12:50:53","2025-11-30 12:50:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764507053;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764507053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 12:52:43","2025-11-30 12:52:43","0",NULL),
("32383","image-optimization/cleanup/stuck-operation","complete","2025-11-30 12:57:43","2025-11-30 12:57:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764507463;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764507463;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 13:00:07","2025-11-30 13:00:07","0",NULL),
("32384","image-optimization/cleanup/stuck-operation","complete","2025-11-30 13:05:07","2025-11-30 13:05:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764507907;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764507907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 13:32:33","2025-11-30 13:32:33","0",NULL),
("32385","image-optimization/cleanup/stuck-operation","complete","2025-11-30 13:37:33","2025-11-30 13:37:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764509853;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764509853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 13:57:22","2025-11-30 13:57:22","0",NULL),
("32386","image-optimization/cleanup/stuck-operation","complete","2025-11-30 14:02:22","2025-11-30 14:02:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764511342;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764511342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 14:04:32","2025-11-30 14:04:32","0",NULL),
("32387","image-optimization/cleanup/stuck-operation","complete","2025-11-30 14:09:32","2025-11-30 14:09:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764511772;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764511772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 14:48:33","2025-11-30 14:48:33","0",NULL),
("32388","image-optimization/cleanup/stuck-operation","complete","2025-11-30 14:53:33","2025-11-30 14:53:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764514413;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764514413;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:01:54","2025-11-30 15:01:54","0",NULL),
("32389","image-optimization/cleanup/stuck-operation","complete","2025-11-30 15:06:54","2025-11-30 15:06:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764515214;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764515214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:07:35","2025-11-30 15:07:35","0",NULL),
("32390","image-optimization/cleanup/stuck-operation","complete","2025-11-30 15:12:35","2025-11-30 15:12:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764515555;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764515555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:18:24","2025-11-30 15:18:24","0",NULL),
("32391","image-optimization/cleanup/stuck-operation","complete","2025-11-30 15:23:24","2025-11-30 15:23:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764516204;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764516204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:24:18","2025-11-30 15:24:18","0",NULL),
("32392","image-optimization/cleanup/stuck-operation","complete","2025-11-30 15:29:18","2025-11-30 15:29:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764516558;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764516558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:42:30","2025-11-30 15:42:30","0",NULL),
("32393","image-optimization/cleanup/stuck-operation","complete","2025-11-30 15:47:30","2025-11-30 15:47:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764517650;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764517650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:49:10","2025-11-30 15:49:10","0",NULL),
("32394","image-optimization/cleanup/stuck-operation","complete","2025-11-30 15:54:10","2025-11-30 15:54:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764518050;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764518050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 15:58:52","2025-11-30 15:58:52","0",NULL),
("32395","image-optimization/cleanup/stuck-operation","complete","2025-11-30 16:03:52","2025-11-30 16:03:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764518632;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764518632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 16:19:05","2025-11-30 16:19:05","0",NULL),
("32396","image-optimization/cleanup/stuck-operation","complete","2025-11-30 16:24:05","2025-11-30 16:24:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764519845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764519845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 16:28:09","2025-11-30 16:28:09","0",NULL),
("32397","image-optimization/cleanup/stuck-operation","complete","2025-11-30 16:33:09","2025-11-30 16:33:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764520389;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764520389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 16:33:28","2025-11-30 16:33:28","0",NULL),
("32398","image-optimization/cleanup/stuck-operation","complete","2025-11-30 16:38:28","2025-11-30 16:38:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764520708;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764520708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 17:00:13","2025-11-30 17:00:13","0",NULL),
("32399","image-optimization/cleanup/stuck-operation","complete","2025-11-30 17:05:13","2025-11-30 17:05:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764522313;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764522313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 17:11:20","2025-11-30 17:11:20","0",NULL),
("32400","image-optimization/cleanup/stuck-operation","complete","2025-11-30 17:16:20","2025-11-30 17:16:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764522980;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764522980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 17:19:57","2025-11-30 17:19:57","0",NULL),
("32401","image-optimization/cleanup/stuck-operation","complete","2025-11-30 17:24:57","2025-11-30 17:24:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764523497;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764523497;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 17:28:15","2025-11-30 17:28:15","0",NULL),
("32402","image-optimization/cleanup/stuck-operation","complete","2025-11-30 17:33:15","2025-11-30 17:33:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764523995;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764523995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 17:52:55","2025-11-30 17:52:55","0",NULL),
("32403","image-optimization/cleanup/stuck-operation","complete","2025-11-30 17:57:55","2025-11-30 17:57:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764525475;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764525475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 17:59:15","2025-11-30 17:59:15","0",NULL),
("32404","image-optimization/cleanup/stuck-operation","complete","2025-11-30 18:04:15","2025-11-30 18:04:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764525855;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764525855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 18:05:25","2025-11-30 18:05:25","0",NULL),
("32405","image-optimization/cleanup/stuck-operation","complete","2025-11-30 18:10:25","2025-11-30 18:10:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764526225;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764526225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 18:13:41","2025-11-30 18:13:41","0",NULL),
("32406","image-optimization/cleanup/stuck-operation","complete","2025-11-30 18:18:41","2025-11-30 18:18:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764526721;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764526721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 19:06:13","2025-11-30 19:06:13","0",NULL),
("32407","image-optimization/cleanup/stuck-operation","complete","2025-11-30 19:11:13","2025-11-30 19:11:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764529873;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764529873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 19:12:21","2025-11-30 19:12:21","0",NULL),
("32408","image-optimization/cleanup/stuck-operation","complete","2025-11-30 19:17:21","2025-11-30 19:17:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764530241;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764530241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 19:18:22","2025-11-30 19:18:22","0",NULL),
("32409","image-optimization/cleanup/stuck-operation","complete","2025-11-30 19:23:22","2025-11-30 19:23:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764530602;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764530602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 19:27:21","2025-11-30 19:27:21","0",NULL),
("32410","image-optimization/cleanup/stuck-operation","complete","2025-11-30 19:32:21","2025-11-30 19:32:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764531141;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764531141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 19:53:43","2025-11-30 19:53:43","0",NULL),
("32411","image-optimization/cleanup/stuck-operation","complete","2025-11-30 19:58:43","2025-11-30 19:58:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764532723;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764532723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 20:07:27","2025-11-30 20:07:27","0",NULL),
("32412","image-optimization/cleanup/stuck-operation","complete","2025-11-30 20:12:27","2025-11-30 20:12:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764533547;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764533547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 20:24:09","2025-11-30 20:24:09","0",NULL),
("32413","image-optimization/cleanup/stuck-operation","complete","2025-11-30 20:29:09","2025-11-30 20:29:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764534549;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764534549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 20:29:32","2025-11-30 20:29:32","0",NULL),
("32414","image-optimization/cleanup/stuck-operation","complete","2025-11-30 20:34:32","2025-11-30 20:34:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764534872;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764534872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 20:54:03","2025-11-30 20:54:03","0",NULL),
("32415","image-optimization/cleanup/stuck-operation","complete","2025-11-30 20:59:03","2025-11-30 20:59:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764536343;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764536343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:05:39","2025-11-30 21:05:39","0",NULL),
("32416","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:10:39","2025-11-30 21:10:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764537039;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764537039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:11:26","2025-11-30 21:11:26","0",NULL),
("32417","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:16:26","2025-11-30 21:16:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764537386;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764537386;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:22:16","2025-11-30 21:22:16","0",NULL),
("32418","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:27:16","2025-11-30 21:27:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764538036;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764538036;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:30:30","2025-11-30 21:30:30","0",NULL),
("32419","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:35:30","2025-11-30 21:35:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764538530;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764538530;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:37:41","2025-11-30 21:37:41","0",NULL),
("32420","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:42:41","2025-11-30 21:42:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764538961;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764538961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:44:18","2025-11-30 21:44:18","0",NULL),
("32421","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:49:18","2025-11-30 21:49:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764539358;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764539358;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 21:54:17","2025-11-30 21:54:17","0",NULL),
("32422","image-optimization/cleanup/stuck-operation","complete","2025-11-30 21:59:17","2025-11-30 21:59:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764539957;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764539957;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 22:17:22","2025-11-30 22:17:22","0",NULL),
("32423","image-optimization/cleanup/stuck-operation","complete","2025-11-30 22:22:22","2025-11-30 22:22:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764541342;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764541342;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 22:26:03","2025-11-30 22:26:03","0",NULL),
("32424","image-optimization/cleanup/stuck-operation","complete","2025-11-30 22:31:03","2025-11-30 22:31:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764541863;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764541863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 22:32:18","2025-11-30 22:32:18","0",NULL),
("32425","image-optimization/cleanup/stuck-operation","complete","2025-11-30 22:37:18","2025-11-30 22:37:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764542238;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764542238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 23:02:08","2025-11-30 23:02:08","0",NULL),
("32426","image-optimization/cleanup/stuck-operation","complete","2025-11-30 23:07:08","2025-11-30 23:07:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764544028;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764544028;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 23:14:30","2025-11-30 23:14:30","0",NULL),
("32427","image-optimization/cleanup/stuck-operation","complete","2025-11-30 23:19:30","2025-11-30 23:19:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764544770;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764544770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 23:23:17","2025-11-30 23:23:17","0",NULL),
("32428","image-optimization/cleanup/stuck-operation","complete","2025-11-30 23:28:17","2025-11-30 23:28:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764545297;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764545297;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-11-30 23:51:55","2025-11-30 23:51:55","0",NULL),
("32429","image-optimization/cleanup/stuck-operation","complete","2025-11-30 23:56:55","2025-11-30 23:56:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764547015;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764547015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 00:21:25","2025-12-01 00:21:25","0",NULL),
("32430","image-optimization/cleanup/stuck-operation","complete","2025-12-01 00:26:25","2025-12-01 00:26:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764548785;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764548785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 00:46:30","2025-12-01 00:46:30","0",NULL),
("32431","image-optimization/cleanup/stuck-operation","complete","2025-12-01 00:51:30","2025-12-01 00:51:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764550290;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764550290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 00:57:40","2025-12-01 00:57:40","0",NULL),
("32432","image-optimization/cleanup/stuck-operation","complete","2025-12-01 01:02:40","2025-12-01 01:02:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764550960;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764550960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 01:12:38","2025-12-01 01:12:38","0",NULL),
("32433","image-optimization/cleanup/stuck-operation","complete","2025-12-01 01:17:38","2025-12-01 01:17:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764551858;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764551858;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 01:27:32","2025-12-01 01:27:32","0",NULL),
("32434","image-optimization/cleanup/stuck-operation","complete","2025-12-01 01:32:32","2025-12-01 01:32:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764552752;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764552752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 01:36:35","2025-12-01 01:36:35","0",NULL),
("32435","image-optimization/cleanup/stuck-operation","complete","2025-12-01 01:41:35","2025-12-01 01:41:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764553295;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764553295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 01:48:00","2025-12-01 01:48:00","0",NULL),
("32436","image-optimization/cleanup/stuck-operation","complete","2025-12-01 01:53:00","2025-12-01 01:53:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764553980;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764553980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 02:19:08","2025-12-01 02:19:08","0",NULL),
("32437","image-optimization/cleanup/stuck-operation","complete","2025-12-01 02:24:08","2025-12-01 02:24:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764555848;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764555848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 02:28:40","2025-12-01 02:28:40","0",NULL),
("32438","image-optimization/cleanup/stuck-operation","complete","2025-12-01 02:33:40","2025-12-01 02:33:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764556420;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764556420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 04:03:07","2025-12-01 04:03:07","0",NULL),
("32439","image-optimization/cleanup/stuck-operation","complete","2025-12-01 04:08:07","2025-12-01 04:08:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764562087;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764562087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 04:13:10","2025-12-01 04:13:10","0",NULL),
("32440","image-optimization/cleanup/stuck-operation","complete","2025-12-01 04:18:10","2025-12-01 04:18:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764562690;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764562690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 04:36:53","2025-12-01 04:36:53","0",NULL),
("32441","image-optimization/cleanup/stuck-operation","complete","2025-12-01 04:41:53","2025-12-01 04:41:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764564113;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764564113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 04:56:16","2025-12-01 04:56:16","0",NULL),
("32442","image-optimization/cleanup/stuck-operation","complete","2025-12-01 05:01:16","2025-12-01 05:01:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764565276;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764565276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 05:09:02","2025-12-01 05:09:02","0",NULL),
("32443","image-optimization/cleanup/stuck-operation","complete","2025-12-01 05:14:02","2025-12-01 05:14:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764566042;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764566042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 05:31:16","2025-12-01 05:31:16","0",NULL),
("32444","image-optimization/cleanup/stuck-operation","complete","2025-12-01 05:36:16","2025-12-01 05:36:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764567376;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764567376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 05:57:20","2025-12-01 05:57:20","0",NULL),
("32445","image-optimization/cleanup/stuck-operation","complete","2025-12-01 06:02:20","2025-12-01 06:02:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764568940;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764568940;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 06:06:51","2025-12-01 06:06:51","0",NULL),
("32446","image-optimization/cleanup/stuck-operation","complete","2025-12-01 06:11:51","2025-12-01 06:11:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764569511;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764569511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 06:19:25","2025-12-01 06:19:25","0",NULL),
("32447","image-optimization/cleanup/stuck-operation","complete","2025-12-01 06:24:25","2025-12-01 06:24:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764570265;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764570265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 06:26:38","2025-12-01 06:26:38","0",NULL),
("32448","image-optimization/cleanup/stuck-operation","complete","2025-12-01 06:31:38","2025-12-01 06:31:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764570698;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764570698;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 06:31:46","2025-12-01 06:31:46","0",NULL),
("32449","image-optimization/cleanup/stuck-operation","complete","2025-12-01 06:36:46","2025-12-01 06:36:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764571006;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764571006;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 07:03:51","2025-12-01 07:03:51","0",NULL),
("32450","image-optimization/cleanup/stuck-operation","complete","2025-12-01 07:08:51","2025-12-01 07:08:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764572931;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764572931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 07:12:30","2025-12-01 07:12:30","0",NULL),
("32451","image-optimization/cleanup/stuck-operation","complete","2025-12-01 07:17:30","2025-12-01 07:17:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764573450;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764573450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 07:18:45","2025-12-01 07:18:45","0",NULL),
("32452","image-optimization/cleanup/stuck-operation","complete","2025-12-01 07:23:45","2025-12-01 07:23:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764573825;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764573825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 07:28:23","2025-12-01 07:28:23","0",NULL),
("32453","image-optimization/cleanup/stuck-operation","complete","2025-12-01 07:33:23","2025-12-01 07:33:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764574403;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764574403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 07:35:53","2025-12-01 07:35:53","0",NULL),
("32454","image-optimization/cleanup/stuck-operation","complete","2025-12-01 07:40:53","2025-12-01 07:40:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764574853;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764574853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 07:50:32","2025-12-01 07:50:32","0",NULL),
("32455","image-optimization/cleanup/stuck-operation","complete","2025-12-01 07:55:32","2025-12-01 07:55:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764575732;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764575732;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 08:02:21","2025-12-01 08:02:21","0",NULL),
("32456","image-optimization/cleanup/stuck-operation","complete","2025-12-01 08:07:21","2025-12-01 08:07:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764576441;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764576441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 08:08:29","2025-12-01 08:08:29","0",NULL),
("32457","image-optimization/cleanup/stuck-operation","complete","2025-12-01 08:13:29","2025-12-01 08:13:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764576809;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764576809;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 08:15:44","2025-12-01 08:15:44","0",NULL),
("32458","image-optimization/cleanup/stuck-operation","complete","2025-12-01 08:20:44","2025-12-01 08:20:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764577244;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764577244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 09:16:24","2025-12-01 09:16:24","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("32459","image-optimization/cleanup/stuck-operation","complete","2025-12-01 09:21:24","2025-12-01 09:21:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764580884;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764580884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 09:24:05","2025-12-01 09:24:05","0",NULL),
("32460","image-optimization/cleanup/stuck-operation","complete","2025-12-01 09:29:05","2025-12-01 09:29:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764581345;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764581345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 09:51:12","2025-12-01 09:51:12","0",NULL),
("32461","image-optimization/cleanup/stuck-operation","complete","2025-12-01 09:56:12","2025-12-01 09:56:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764582972;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764582972;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 10:53:55","2025-12-01 10:53:55","0",NULL),
("32462","image-optimization/cleanup/stuck-operation","complete","2025-12-01 10:58:55","2025-12-01 10:58:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764586735;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764586735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 11:08:49","2025-12-01 11:08:49","0",NULL),
("32463","image-optimization/cleanup/stuck-operation","complete","2025-12-01 11:13:49","2025-12-01 11:13:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764587629;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764587629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 12:42:47","2025-12-01 12:42:47","0",NULL),
("32464","image-optimization/cleanup/stuck-operation","complete","2025-12-01 12:47:47","2025-12-01 12:47:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764593267;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764593267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 12:48:07","2025-12-01 12:48:07","0",NULL),
("32465","image-optimization/cleanup/stuck-operation","complete","2025-12-01 12:53:07","2025-12-01 12:53:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764593587;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764593587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 13:10:44","2025-12-01 13:10:44","0",NULL),
("32466","image-optimization/cleanup/stuck-operation","complete","2025-12-01 13:15:44","2025-12-01 13:15:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764594944;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764594944;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 13:33:51","2025-12-01 13:33:51","0",NULL),
("32467","image-optimization/cleanup/stuck-operation","complete","2025-12-01 13:38:51","2025-12-01 13:38:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764596331;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764596331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 13:40:13","2025-12-01 13:40:13","0",NULL),
("32468","image-optimization/cleanup/stuck-operation","complete","2025-12-01 13:45:13","2025-12-01 13:45:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764596713;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764596713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 13:55:42","2025-12-01 13:55:42","0",NULL),
("32469","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:00:42","2025-12-01 14:00:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764597642;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764597642;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 14:01:43","2025-12-01 14:01:43","0",NULL),
("32470","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:06:43","2025-12-01 14:06:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764598003;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764598003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 14:07:12","2025-12-01 14:07:12","0",NULL),
("32471","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:12:12","2025-12-01 14:12:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764598332;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764598332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 14:13:19","2025-12-01 14:13:19","0",NULL),
("32472","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:18:19","2025-12-01 14:18:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764598699;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764598699;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 14:23:16","2025-12-01 14:23:16","0",NULL),
("32473","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:28:16","2025-12-01 14:28:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764599296;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764599296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 14:32:42","2025-12-01 14:32:42","0",NULL),
("32474","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:37:42","2025-12-01 14:37:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764599862;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764599862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 14:44:43","2025-12-01 14:44:43","0",NULL),
("32475","image-optimization/cleanup/stuck-operation","complete","2025-12-01 14:49:43","2025-12-01 14:49:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764600583;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764600583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 16:34:41","2025-12-01 16:34:41","0",NULL),
("32476","image-optimization/cleanup/stuck-operation","complete","2025-12-01 16:39:41","2025-12-01 16:39:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764607181;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764607181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-01 16:48:23","2025-12-01 16:48:23","0",NULL),
("32477","image-optimization/cleanup/stuck-operation","complete","2025-12-01 16:53:23","2025-12-01 16:53:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764608003;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764608003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 02:02:46","2025-12-02 02:02:46","0",NULL),
("32478","image-optimization/cleanup/stuck-operation","complete","2025-12-02 02:07:46","2025-12-02 02:07:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764641266;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764641266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 02:58:51","2025-12-02 02:58:51","0",NULL),
("32479","image-optimization/cleanup/stuck-operation","complete","2025-12-02 03:03:51","2025-12-02 03:03:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764644631;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764644631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 10:15:44","2025-12-02 10:15:44","0",NULL),
("32480","image-optimization/cleanup/stuck-operation","complete","2025-12-02 10:20:44","2025-12-02 10:20:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764670844;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764670844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 11:48:04","2025-12-02 11:48:04","0",NULL),
("32481","image-optimization/cleanup/stuck-operation","complete","2025-12-02 11:53:04","2025-12-02 11:53:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764676384;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764676384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 14:47:54","2025-12-02 14:47:54","0",NULL),
("32482","image-optimization/cleanup/stuck-operation","complete","2025-12-02 14:52:54","2025-12-02 14:52:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764687174;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764687174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 17:28:37","2025-12-02 17:28:37","0",NULL),
("32483","image-optimization/cleanup/stuck-operation","complete","2025-12-02 17:33:37","2025-12-02 17:33:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764696817;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764696817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 18:01:51","2025-12-02 18:01:51","0",NULL),
("32484","image-optimization/cleanup/stuck-operation","complete","2025-12-02 18:06:51","2025-12-02 18:06:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764698811;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764698811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 19:12:46","2025-12-02 19:12:46","0",NULL),
("32485","image-optimization/cleanup/stuck-operation","complete","2025-12-02 19:17:46","2025-12-02 19:17:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764703066;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764703066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 19:25:39","2025-12-02 19:25:39","0",NULL),
("32486","image-optimization/cleanup/stuck-operation","complete","2025-12-02 19:30:39","2025-12-02 19:30:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764703839;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764703839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 19:32:07","2025-12-02 19:32:07","0",NULL),
("32487","image-optimization/cleanup/stuck-operation","complete","2025-12-02 19:37:07","2025-12-02 19:37:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764704227;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764704227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 20:55:43","2025-12-02 20:55:43","0",NULL),
("32488","image-optimization/cleanup/stuck-operation","complete","2025-12-02 21:00:43","2025-12-02 21:00:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764709243;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764709243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-02 21:23:17","2025-12-02 21:23:17","0",NULL),
("32489","image-optimization/cleanup/stuck-operation","complete","2025-12-02 21:28:17","2025-12-02 21:28:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764710897;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764710897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 01:25:22","2025-12-03 01:25:22","0",NULL),
("32490","image-optimization/cleanup/stuck-operation","complete","2025-12-03 01:30:22","2025-12-03 01:30:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764725422;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764725422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 05:04:35","2025-12-03 05:04:35","0",NULL),
("32491","image-optimization/cleanup/stuck-operation","complete","2025-12-03 05:09:35","2025-12-03 05:09:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764738575;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764738575;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 10:25:02","2025-12-03 10:25:02","0",NULL),
("32492","image-optimization/cleanup/stuck-operation","complete","2025-12-03 10:30:02","2025-12-03 10:30:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764757802;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764757802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 11:34:51","2025-12-03 11:34:51","0",NULL),
("32493","image-optimization/cleanup/stuck-operation","complete","2025-12-03 11:39:51","2025-12-03 11:39:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764761991;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764761991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 12:05:31","2025-12-03 12:05:31","0",NULL),
("32494","image-optimization/cleanup/stuck-operation","complete","2025-12-03 12:10:31","2025-12-03 12:10:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764763831;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764763831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 12:54:03","2025-12-03 12:54:03","0",NULL),
("32495","image-optimization/cleanup/stuck-operation","complete","2025-12-03 12:59:03","2025-12-03 12:59:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764766743;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764766743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 13:44:59","2025-12-03 13:44:59","0",NULL),
("32496","image-optimization/cleanup/stuck-operation","complete","2025-12-03 13:50:01","2025-12-03 13:50:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764769801;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764769801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 14:54:37","2025-12-03 14:54:37","0",NULL),
("32497","image-optimization/cleanup/stuck-operation","complete","2025-12-03 14:59:37","2025-12-03 14:59:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764773977;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764773977;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 15:16:29","2025-12-03 15:16:29","0",NULL),
("32498","image-optimization/cleanup/stuck-operation","complete","2025-12-03 15:21:29","2025-12-03 15:21:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764775289;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764775289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 16:11:20","2025-12-03 16:11:20","0",NULL),
("32499","image-optimization/cleanup/stuck-operation","complete","2025-12-03 16:16:20","2025-12-03 16:16:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764778580;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764778580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 17:17:02","2025-12-03 17:17:02","0",NULL),
("32500","image-optimization/cleanup/stuck-operation","complete","2025-12-03 17:22:02","2025-12-03 17:22:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764782522;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764782522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 17:26:30","2025-12-03 17:26:30","0",NULL),
("32501","image-optimization/cleanup/stuck-operation","complete","2025-12-03 17:31:30","2025-12-03 17:31:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764783090;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764783090;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 18:00:05","2025-12-03 18:00:05","0",NULL),
("32502","image-optimization/cleanup/stuck-operation","complete","2025-12-03 18:05:05","2025-12-03 18:05:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764785105;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764785105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 19:14:31","2025-12-03 19:14:31","0",NULL),
("32503","image-optimization/cleanup/stuck-operation","complete","2025-12-03 19:19:31","2025-12-03 19:19:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764789571;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764789571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 19:43:19","2025-12-03 19:43:19","0",NULL),
("32504","image-optimization/cleanup/stuck-operation","complete","2025-12-03 19:48:19","2025-12-03 19:48:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764791299;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764791299;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 20:32:48","2025-12-03 20:32:48","0",NULL),
("32505","image-optimization/cleanup/stuck-operation","complete","2025-12-03 20:37:48","2025-12-03 20:37:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764794268;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764794268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 20:42:18","2025-12-03 20:42:18","0",NULL),
("32506","image-optimization/cleanup/stuck-operation","complete","2025-12-03 20:47:18","2025-12-03 20:47:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764794838;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764794838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 21:56:31","2025-12-03 21:56:31","0",NULL),
("32507","image-optimization/cleanup/stuck-operation","complete","2025-12-03 22:01:31","2025-12-03 22:01:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764799291;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764799291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 22:10:15","2025-12-03 22:10:15","0",NULL),
("32508","image-optimization/cleanup/stuck-operation","complete","2025-12-03 22:15:15","2025-12-03 22:15:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764800115;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764800115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 22:20:56","2025-12-03 22:20:56","0",NULL),
("32509","image-optimization/cleanup/stuck-operation","complete","2025-12-03 22:25:56","2025-12-03 22:25:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764800756;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764800756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 22:26:16","2025-12-03 22:26:16","0",NULL),
("32510","image-optimization/cleanup/stuck-operation","complete","2025-12-03 22:31:16","2025-12-03 22:31:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764801076;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764801076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 22:50:49","2025-12-03 22:50:49","0",NULL),
("32511","image-optimization/cleanup/stuck-operation","complete","2025-12-03 22:55:49","2025-12-03 22:55:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764802549;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764802549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-03 23:55:22","2025-12-03 23:55:22","0",NULL),
("32512","image-optimization/cleanup/stuck-operation","complete","2025-12-04 00:00:22","2025-12-04 00:00:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764806422;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764806422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 01:13:36","2025-12-04 01:13:36","0",NULL),
("32513","image-optimization/cleanup/stuck-operation","complete","2025-12-04 01:18:36","2025-12-04 01:18:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764811116;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764811116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 01:55:29","2025-12-04 01:55:29","0",NULL),
("32514","image-optimization/cleanup/stuck-operation","complete","2025-12-04 02:00:29","2025-12-04 02:00:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764813629;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764813629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 02:15:59","2025-12-04 02:15:59","0",NULL),
("32515","image-optimization/cleanup/stuck-operation","complete","2025-12-04 02:20:59","2025-12-04 02:20:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764814859;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764814859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 02:26:23","2025-12-04 02:26:23","0",NULL),
("32516","image-optimization/cleanup/stuck-operation","complete","2025-12-04 02:31:23","2025-12-04 02:31:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764815483;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764815483;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 03:56:07","2025-12-04 03:56:07","0",NULL),
("32517","image-optimization/cleanup/stuck-operation","complete","2025-12-04 04:01:07","2025-12-04 04:01:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764820867;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764820867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 04:02:04","2025-12-04 04:02:04","0",NULL),
("32518","image-optimization/cleanup/stuck-operation","complete","2025-12-04 04:07:04","2025-12-04 04:07:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764821224;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764821224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 04:10:49","2025-12-04 04:10:49","0",NULL),
("32519","image-optimization/cleanup/stuck-operation","complete","2025-12-04 04:15:49","2025-12-04 04:15:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764821749;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764821749;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 04:17:48","2025-12-04 04:17:48","0",NULL),
("32520","image-optimization/cleanup/stuck-operation","complete","2025-12-04 04:22:48","2025-12-04 04:22:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764822168;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764822168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 04:55:04","2025-12-04 04:55:04","0",NULL),
("32521","image-optimization/cleanup/stuck-operation","complete","2025-12-04 05:00:04","2025-12-04 05:00:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764824404;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764824404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 05:24:54","2025-12-04 05:24:54","0",NULL),
("32522","image-optimization/cleanup/stuck-operation","complete","2025-12-04 05:29:54","2025-12-04 05:29:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764826194;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764826194;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 05:36:14","2025-12-04 05:36:14","0",NULL),
("32523","image-optimization/cleanup/stuck-operation","complete","2025-12-04 05:41:14","2025-12-04 05:41:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764826874;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764826874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 05:42:23","2025-12-04 05:42:23","0",NULL),
("32524","image-optimization/cleanup/stuck-operation","complete","2025-12-04 05:47:23","2025-12-04 05:47:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764827243;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764827243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 05:58:22","2025-12-04 05:58:22","0",NULL),
("32525","image-optimization/cleanup/stuck-operation","complete","2025-12-04 06:03:22","2025-12-04 06:03:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764828202;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764828202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 06:32:12","2025-12-04 06:32:12","0",NULL),
("32526","image-optimization/cleanup/stuck-operation","complete","2025-12-04 06:37:12","2025-12-04 06:37:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764830232;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764830232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 06:57:33","2025-12-04 06:57:33","0",NULL),
("32527","image-optimization/cleanup/stuck-operation","complete","2025-12-04 07:02:33","2025-12-04 07:02:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764831753;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764831753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 07:09:59","2025-12-04 07:09:59","0",NULL),
("32528","image-optimization/cleanup/stuck-operation","complete","2025-12-04 07:14:59","2025-12-04 07:14:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764832499;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764832499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 07:17:51","2025-12-04 07:17:51","0",NULL),
("32529","image-optimization/cleanup/stuck-operation","complete","2025-12-04 07:22:51","2025-12-04 07:22:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764832971;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764832971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 07:25:20","2025-12-04 07:25:20","0",NULL),
("32530","image-optimization/cleanup/stuck-operation","complete","2025-12-04 07:30:20","2025-12-04 07:30:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764833420;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764833420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 07:57:48","2025-12-04 07:57:48","0",NULL),
("32531","image-optimization/cleanup/stuck-operation","complete","2025-12-04 08:02:48","2025-12-04 08:02:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764835368;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764835368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 09:35:05","2025-12-04 09:35:05","0",NULL),
("32532","image-optimization/cleanup/stuck-operation","complete","2025-12-04 09:40:05","2025-12-04 09:40:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764841205;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764841205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 09:51:13","2025-12-04 09:51:13","0",NULL),
("32533","image-optimization/cleanup/stuck-operation","complete","2025-12-04 09:56:13","2025-12-04 09:56:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764842173;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764842173;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 10:42:25","2025-12-04 10:42:25","0",NULL),
("32534","image-optimization/cleanup/stuck-operation","complete","2025-12-04 10:47:25","2025-12-04 10:47:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764845245;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764845245;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 10:56:26","2025-12-04 10:56:26","0",NULL),
("32535","image-optimization/cleanup/stuck-operation","complete","2025-12-04 11:01:26","2025-12-04 11:01:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764846086;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764846086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 11:37:38","2025-12-04 11:37:38","0",NULL),
("32536","image-optimization/cleanup/stuck-operation","complete","2025-12-04 11:42:38","2025-12-04 11:42:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764848558;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764848558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 11:46:44","2025-12-04 11:46:44","0",NULL),
("32537","image-optimization/cleanup/stuck-operation","complete","2025-12-04 11:51:44","2025-12-04 11:51:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764849104;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764849104;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 12:41:28","2025-12-04 12:41:28","0",NULL),
("32538","image-optimization/cleanup/stuck-operation","complete","2025-12-04 12:46:28","2025-12-04 12:46:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764852388;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764852388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 13:24:58","2025-12-04 13:24:58","0",NULL),
("32539","image-optimization/cleanup/stuck-operation","complete","2025-12-04 13:29:58","2025-12-04 13:29:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764854998;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764854998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 13:32:20","2025-12-04 13:32:20","0",NULL),
("32540","image-optimization/cleanup/stuck-operation","complete","2025-12-04 13:37:20","2025-12-04 13:37:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764855440;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764855440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 14:02:21","2025-12-04 14:02:21","0",NULL),
("32541","image-optimization/cleanup/stuck-operation","complete","2025-12-04 14:07:21","2025-12-04 14:07:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764857241;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764857241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 14:57:20","2025-12-04 14:57:20","0",NULL),
("32542","image-optimization/cleanup/stuck-operation","complete","2025-12-04 15:02:20","2025-12-04 15:02:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764860540;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764860540;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 15:16:12","2025-12-04 15:16:12","0",NULL),
("32543","image-optimization/cleanup/stuck-operation","complete","2025-12-04 15:21:12","2025-12-04 15:21:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764861672;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764861672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 16:16:21","2025-12-04 16:16:21","0",NULL),
("32544","image-optimization/cleanup/stuck-operation","complete","2025-12-04 16:21:21","2025-12-04 16:21:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764865281;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764865281;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 16:53:45","2025-12-04 16:53:45","0",NULL),
("32545","image-optimization/cleanup/stuck-operation","complete","2025-12-04 16:58:45","2025-12-04 16:58:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764867525;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764867525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 17:21:04","2025-12-04 17:21:04","0",NULL),
("32546","image-optimization/cleanup/stuck-operation","complete","2025-12-04 17:26:04","2025-12-04 17:26:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764869164;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764869164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 17:55:42","2025-12-04 17:55:42","0",NULL),
("32547","image-optimization/cleanup/stuck-operation","complete","2025-12-04 18:00:42","2025-12-04 18:00:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764871242;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764871242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 18:05:59","2025-12-04 18:05:59","0",NULL),
("32548","image-optimization/cleanup/stuck-operation","complete","2025-12-04 18:10:59","2025-12-04 18:10:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764871859;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764871859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 18:19:03","2025-12-04 18:19:03","0",NULL),
("32549","image-optimization/cleanup/stuck-operation","complete","2025-12-04 18:24:03","2025-12-04 18:24:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764872643;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764872643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 19:53:43","2025-12-04 19:53:43","0",NULL),
("32550","image-optimization/cleanup/stuck-operation","complete","2025-12-04 19:58:43","2025-12-04 19:58:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764878323;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764878323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 21:06:13","2025-12-04 21:06:13","0",NULL),
("32551","image-optimization/cleanup/stuck-operation","complete","2025-12-04 21:11:14","2025-12-04 21:11:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764882674;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764882674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 22:10:11","2025-12-04 22:10:11","0",NULL),
("32552","image-optimization/cleanup/stuck-operation","complete","2025-12-04 22:15:11","2025-12-04 22:15:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764886511;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764886511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 22:37:14","2025-12-04 22:37:14","0",NULL),
("32553","image-optimization/cleanup/stuck-operation","complete","2025-12-04 22:42:14","2025-12-04 22:42:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764888134;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764888134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 22:45:14","2025-12-04 22:45:14","0",NULL),
("32554","image-optimization/cleanup/stuck-operation","complete","2025-12-04 22:50:14","2025-12-04 22:50:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764888614;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764888614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 22:53:01","2025-12-04 22:53:01","0",NULL),
("32555","image-optimization/cleanup/stuck-operation","complete","2025-12-04 22:58:01","2025-12-04 22:58:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764889081;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764889081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-04 23:33:31","2025-12-04 23:33:31","0",NULL),
("32556","image-optimization/cleanup/stuck-operation","complete","2025-12-04 23:38:31","2025-12-04 23:38:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764891511;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764891511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 00:42:05","2025-12-05 00:42:05","0",NULL),
("32557","image-optimization/cleanup/stuck-operation","complete","2025-12-05 00:47:05","2025-12-05 00:47:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764895625;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764895625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 01:07:10","2025-12-05 01:07:10","0",NULL),
("32558","image-optimization/cleanup/stuck-operation","complete","2025-12-05 01:12:10","2025-12-05 01:12:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764897130;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764897130;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 01:39:09","2025-12-05 01:39:09","0",NULL),
("32559","image-optimization/cleanup/stuck-operation","complete","2025-12-05 01:44:09","2025-12-05 01:44:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764899049;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764899049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 01:49:32","2025-12-05 01:49:32","0",NULL),
("32560","image-optimization/cleanup/stuck-operation","complete","2025-12-05 01:54:32","2025-12-05 01:54:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764899672;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764899672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 02:26:14","2025-12-05 02:26:14","0",NULL),
("32561","image-optimization/cleanup/stuck-operation","complete","2025-12-05 02:31:14","2025-12-05 02:31:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764901874;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764901874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 03:38:10","2025-12-05 03:38:10","0",NULL),
("32562","image-optimization/cleanup/stuck-operation","complete","2025-12-05 03:43:10","2025-12-05 03:43:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764906190;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764906190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 03:59:53","2025-12-05 03:59:53","0",NULL),
("32563","image-optimization/cleanup/stuck-operation","complete","2025-12-05 04:04:53","2025-12-05 04:04:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764907493;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764907493;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 04:18:43","2025-12-05 04:18:43","0",NULL),
("32564","image-optimization/cleanup/stuck-operation","complete","2025-12-05 04:23:43","2025-12-05 04:23:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764908623;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764908623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 04:53:56","2025-12-05 04:53:56","0",NULL),
("32565","image-optimization/cleanup/stuck-operation","complete","2025-12-05 04:58:56","2025-12-05 04:58:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764910736;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764910736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 06:40:41","2025-12-05 06:40:41","0",NULL),
("32566","image-optimization/cleanup/stuck-operation","complete","2025-12-05 06:45:41","2025-12-05 06:45:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764917141;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764917141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 07:16:46","2025-12-05 07:16:46","0",NULL),
("32567","image-optimization/cleanup/stuck-operation","complete","2025-12-05 07:21:46","2025-12-05 07:21:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764919306;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764919306;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 07:42:42","2025-12-05 07:42:42","0",NULL),
("32568","image-optimization/cleanup/stuck-operation","complete","2025-12-05 07:47:42","2025-12-05 07:47:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764920862;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764920862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 07:58:43","2025-12-05 07:58:43","0",NULL),
("32569","image-optimization/cleanup/stuck-operation","complete","2025-12-05 08:03:43","2025-12-05 08:03:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764921823;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764921823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 08:46:06","2025-12-05 08:46:06","0",NULL),
("32570","image-optimization/cleanup/stuck-operation","complete","2025-12-05 08:51:06","2025-12-05 08:51:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764924666;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764924666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 08:51:31","2025-12-05 08:51:31","0",NULL),
("32571","image-optimization/cleanup/stuck-operation","complete","2025-12-05 08:56:31","2025-12-05 08:56:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764924991;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764924991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 08:58:45","2025-12-05 08:58:45","0",NULL),
("32572","image-optimization/cleanup/stuck-operation","complete","2025-12-05 09:03:45","2025-12-05 09:03:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764925425;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764925425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 09:38:34","2025-12-05 09:38:34","0",NULL),
("32573","image-optimization/cleanup/stuck-operation","complete","2025-12-05 09:43:34","2025-12-05 09:43:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764927814;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764927814;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 09:49:45","2025-12-05 09:49:45","0",NULL),
("32574","image-optimization/cleanup/stuck-operation","complete","2025-12-05 09:54:45","2025-12-05 09:54:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764928485;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764928485;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 09:55:22","2025-12-05 09:55:22","0",NULL),
("32575","image-optimization/cleanup/stuck-operation","complete","2025-12-05 10:00:22","2025-12-05 10:00:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764928822;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764928822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 10:54:11","2025-12-05 10:54:11","0",NULL),
("32576","image-optimization/cleanup/stuck-operation","complete","2025-12-05 10:59:11","2025-12-05 10:59:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764932351;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764932351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 11:00:41","2025-12-05 11:00:41","0",NULL),
("32577","image-optimization/cleanup/stuck-operation","complete","2025-12-05 11:05:41","2025-12-05 11:05:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764932741;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764932741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 11:46:35","2025-12-05 11:46:35","0",NULL),
("32578","image-optimization/cleanup/stuck-operation","complete","2025-12-05 11:51:35","2025-12-05 11:51:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764935495;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764935495;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 11:56:41","2025-12-05 11:56:41","0",NULL),
("32579","image-optimization/cleanup/stuck-operation","complete","2025-12-05 12:01:41","2025-12-05 12:01:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764936101;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764936101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 12:03:11","2025-12-05 12:03:11","0",NULL),
("32580","image-optimization/cleanup/stuck-operation","complete","2025-12-05 12:08:11","2025-12-05 12:08:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764936491;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764936491;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 12:08:41","2025-12-05 12:08:41","0",NULL),
("32581","image-optimization/cleanup/stuck-operation","complete","2025-12-05 12:13:41","2025-12-05 12:13:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764936821;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764936821;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 13:16:32","2025-12-05 13:16:32","0",NULL),
("32582","image-optimization/cleanup/stuck-operation","complete","2025-12-05 13:21:32","2025-12-05 13:21:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764940892;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764940892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 13:21:45","2025-12-05 13:21:45","0",NULL),
("32583","image-optimization/cleanup/stuck-operation","complete","2025-12-05 13:26:45","2025-12-05 13:26:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764941205;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764941205;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 13:58:01","2025-12-05 13:58:01","0",NULL),
("32584","image-optimization/cleanup/stuck-operation","complete","2025-12-05 14:03:01","2025-12-05 14:03:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764943381;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764943381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 14:05:30","2025-12-05 14:05:30","0",NULL),
("32585","image-optimization/cleanup/stuck-operation","complete","2025-12-05 14:10:30","2025-12-05 14:10:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764943830;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764943830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 14:30:23","2025-12-05 14:30:23","0",NULL),
("32586","image-optimization/cleanup/stuck-operation","complete","2025-12-05 14:35:23","2025-12-05 14:35:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764945323;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764945323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 14:46:53","2025-12-05 14:46:53","0",NULL),
("32587","image-optimization/cleanup/stuck-operation","complete","2025-12-05 14:51:53","2025-12-05 14:51:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764946313;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764946313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 14:53:35","2025-12-05 14:53:35","0",NULL),
("32588","image-optimization/cleanup/stuck-operation","complete","2025-12-05 14:58:35","2025-12-05 14:58:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764946715;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764946715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 15:00:54","2025-12-05 15:00:54","0",NULL),
("32589","image-optimization/cleanup/stuck-operation","complete","2025-12-05 15:05:54","2025-12-05 15:05:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764947154;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764947154;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 15:23:41","2025-12-05 15:23:41","0",NULL),
("32590","image-optimization/cleanup/stuck-operation","complete","2025-12-05 15:28:41","2025-12-05 15:28:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764948521;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764948521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 15:38:49","2025-12-05 15:38:49","0",NULL),
("32591","image-optimization/cleanup/stuck-operation","complete","2025-12-05 15:43:58","2025-12-05 15:43:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764949438;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764949438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 15:51:56","2025-12-05 15:51:56","0",NULL),
("32592","image-optimization/cleanup/stuck-operation","complete","2025-12-05 15:56:56","2025-12-05 15:56:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764950216;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764950216;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 17:12:51","2025-12-05 17:12:51","0",NULL),
("32593","image-optimization/cleanup/stuck-operation","complete","2025-12-05 17:17:51","2025-12-05 17:17:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764955071;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764955071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 17:21:16","2025-12-05 17:21:16","0",NULL),
("32594","image-optimization/cleanup/stuck-operation","complete","2025-12-05 17:26:16","2025-12-05 17:26:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764955576;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764955576;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 19:28:44","2025-12-05 19:28:44","0",NULL),
("32595","image-optimization/cleanup/stuck-operation","complete","2025-12-05 19:33:44","2025-12-05 19:33:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764963224;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764963224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 19:39:16","2025-12-05 19:39:16","0",NULL),
("32596","image-optimization/cleanup/stuck-operation","complete","2025-12-05 19:44:16","2025-12-05 19:44:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764963856;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764963856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 19:48:45","2025-12-05 19:48:45","0",NULL),
("32597","image-optimization/cleanup/stuck-operation","complete","2025-12-05 19:53:45","2025-12-05 19:53:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764964425;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764964425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 20:17:25","2025-12-05 20:17:25","0",NULL),
("32598","image-optimization/cleanup/stuck-operation","complete","2025-12-05 20:22:25","2025-12-05 20:22:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764966145;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764966145;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 21:59:12","2025-12-05 21:59:12","0",NULL),
("32599","image-optimization/cleanup/stuck-operation","complete","2025-12-05 22:04:12","2025-12-05 22:04:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764972252;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764972252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 22:45:37","2025-12-05 22:45:37","0",NULL),
("32600","image-optimization/cleanup/stuck-operation","complete","2025-12-05 22:50:37","2025-12-05 22:50:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764975037;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764975037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 23:16:29","2025-12-05 23:16:29","0",NULL),
("32601","image-optimization/cleanup/stuck-operation","complete","2025-12-05 23:21:29","2025-12-05 23:21:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764976889;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764976889;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 23:32:24","2025-12-05 23:32:24","0",NULL),
("32602","image-optimization/cleanup/stuck-operation","complete","2025-12-05 23:37:24","2025-12-05 23:37:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764977844;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764977844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-05 23:55:48","2025-12-05 23:55:48","0",NULL),
("32603","image-optimization/cleanup/stuck-operation","complete","2025-12-06 00:00:48","2025-12-06 00:00:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764979248;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764979248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 01:16:14","2025-12-06 01:16:14","0",NULL),
("32604","image-optimization/cleanup/stuck-operation","complete","2025-12-06 01:21:14","2025-12-06 01:21:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764984074;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764984074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 01:45:07","2025-12-06 01:45:07","0",NULL),
("32605","image-optimization/cleanup/stuck-operation","complete","2025-12-06 01:50:07","2025-12-06 01:50:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764985807;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764985807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 02:37:18","2025-12-06 02:37:18","0",NULL),
("32606","image-optimization/cleanup/stuck-operation","complete","2025-12-06 02:42:18","2025-12-06 02:42:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764988938;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764988938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 02:54:58","2025-12-06 02:54:58","0",NULL),
("32607","image-optimization/cleanup/stuck-operation","complete","2025-12-06 02:59:58","2025-12-06 02:59:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764989998;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764989998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 03:19:35","2025-12-06 03:19:35","0",NULL),
("32608","image-optimization/cleanup/stuck-operation","complete","2025-12-06 03:24:35","2025-12-06 03:24:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764991475;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764991475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 03:58:05","2025-12-06 03:58:05","0",NULL),
("32609","image-optimization/cleanup/stuck-operation","complete","2025-12-06 04:03:05","2025-12-06 04:03:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764993785;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764993785;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 04:42:05","2025-12-06 04:42:05","0",NULL),
("32610","image-optimization/cleanup/stuck-operation","complete","2025-12-06 04:47:05","2025-12-06 04:47:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764996425;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764996425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 05:04:13","2025-12-06 05:04:13","0",NULL),
("32611","image-optimization/cleanup/stuck-operation","complete","2025-12-06 05:09:13","2025-12-06 05:09:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764997753;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764997753;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 05:20:58","2025-12-06 05:20:58","0",NULL),
("32612","image-optimization/cleanup/stuck-operation","complete","2025-12-06 05:25:58","2025-12-06 05:25:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764998758;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764998758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 05:26:15","2025-12-06 05:26:15","0",NULL),
("32613","image-optimization/cleanup/stuck-operation","complete","2025-12-06 05:31:15","2025-12-06 05:31:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1764999075;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1764999075;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 05:46:07","2025-12-06 05:46:07","0",NULL),
("32614","image-optimization/cleanup/stuck-operation","complete","2025-12-06 05:51:08","2025-12-06 05:51:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765000268;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765000268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 06:58:43","2025-12-06 06:58:43","0",NULL),
("32615","image-optimization/cleanup/stuck-operation","complete","2025-12-06 07:03:43","2025-12-06 07:03:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765004623;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765004623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 07:14:54","2025-12-06 07:14:54","0",NULL),
("32616","image-optimization/cleanup/stuck-operation","complete","2025-12-06 07:19:54","2025-12-06 07:19:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765005594;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765005594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 08:01:14","2025-12-06 08:01:14","0",NULL),
("32617","image-optimization/cleanup/stuck-operation","complete","2025-12-06 08:06:14","2025-12-06 08:06:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765008374;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765008374;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 08:21:21","2025-12-06 08:21:21","0",NULL),
("32618","image-optimization/cleanup/stuck-operation","complete","2025-12-06 08:26:21","2025-12-06 08:26:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765009581;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765009581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 08:45:49","2025-12-06 08:45:49","0",NULL),
("32619","image-optimization/cleanup/stuck-operation","complete","2025-12-06 08:50:49","2025-12-06 08:50:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765011049;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765011049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 08:53:29","2025-12-06 08:53:29","0",NULL),
("32620","image-optimization/cleanup/stuck-operation","complete","2025-12-06 08:58:29","2025-12-06 08:58:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765011509;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765011509;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 09:09:10","2025-12-06 09:09:10","0",NULL),
("32621","image-optimization/cleanup/stuck-operation","complete","2025-12-06 09:14:10","2025-12-06 09:14:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765012450;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765012450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 10:01:11","2025-12-06 10:01:11","0",NULL),
("32622","image-optimization/cleanup/stuck-operation","complete","2025-12-06 10:06:11","2025-12-06 10:06:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765015571;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765015571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 10:12:30","2025-12-06 10:12:30","0",NULL),
("32623","image-optimization/cleanup/stuck-operation","complete","2025-12-06 10:17:30","2025-12-06 10:17:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765016250;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765016250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 10:18:18","2025-12-06 10:18:18","0",NULL),
("32624","image-optimization/cleanup/stuck-operation","complete","2025-12-06 10:23:18","2025-12-06 10:23:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765016598;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765016598;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 10:26:25","2025-12-06 10:26:25","0",NULL),
("32625","image-optimization/cleanup/stuck-operation","complete","2025-12-06 10:31:25","2025-12-06 10:31:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765017085;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765017085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 10:50:21","2025-12-06 10:50:21","0",NULL),
("32626","image-optimization/cleanup/stuck-operation","complete","2025-12-06 10:55:21","2025-12-06 10:55:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765018521;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765018521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 11:31:34","2025-12-06 11:31:34","0",NULL),
("32627","image-optimization/cleanup/stuck-operation","complete","2025-12-06 11:36:34","2025-12-06 11:36:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765020994;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765020994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 11:49:23","2025-12-06 11:49:23","0",NULL),
("32628","image-optimization/cleanup/stuck-operation","complete","2025-12-06 11:54:23","2025-12-06 11:54:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765022063;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765022063;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 12:32:46","2025-12-06 12:32:46","0",NULL),
("32629","image-optimization/cleanup/stuck-operation","complete","2025-12-06 12:37:46","2025-12-06 12:37:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765024666;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765024666;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 13:26:26","2025-12-06 13:26:26","0",NULL),
("32630","image-optimization/cleanup/stuck-operation","complete","2025-12-06 13:31:26","2025-12-06 13:31:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765027886;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765027886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 14:11:17","2025-12-06 14:11:17","0",NULL),
("32631","image-optimization/cleanup/stuck-operation","complete","2025-12-06 14:16:17","2025-12-06 14:16:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765030577;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765030577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 14:28:00","2025-12-06 14:28:00","0",NULL),
("32632","image-optimization/cleanup/stuck-operation","complete","2025-12-06 14:33:00","2025-12-06 14:33:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765031580;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765031580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 14:48:50","2025-12-06 14:48:50","0",NULL),
("32633","image-optimization/cleanup/stuck-operation","complete","2025-12-06 14:53:50","2025-12-06 14:53:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765032830;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765032830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 16:27:09","2025-12-06 16:27:09","0",NULL),
("32634","image-optimization/cleanup/stuck-operation","complete","2025-12-06 16:32:09","2025-12-06 16:32:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765038729;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765038729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 16:36:52","2025-12-06 16:36:52","0",NULL),
("32635","image-optimization/cleanup/stuck-operation","complete","2025-12-06 16:41:52","2025-12-06 16:41:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765039312;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765039312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 17:06:55","2025-12-06 17:06:55","0",NULL),
("32636","image-optimization/cleanup/stuck-operation","complete","2025-12-06 17:11:55","2025-12-06 17:11:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765041115;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765041115;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 17:15:17","2025-12-06 17:15:17","0",NULL),
("32637","image-optimization/cleanup/stuck-operation","complete","2025-12-06 17:20:17","2025-12-06 17:20:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765041617;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765041617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 18:35:23","2025-12-06 18:35:23","0",NULL),
("32638","image-optimization/cleanup/stuck-operation","complete","2025-12-06 18:40:23","2025-12-06 18:40:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765046423;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765046423;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 19:41:20","2025-12-06 19:41:20","0",NULL),
("32639","image-optimization/cleanup/stuck-operation","complete","2025-12-06 19:46:20","2025-12-06 19:46:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765050380;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765050380;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 19:48:24","2025-12-06 19:48:24","0",NULL),
("32640","image-optimization/cleanup/stuck-operation","complete","2025-12-06 19:53:24","2025-12-06 19:53:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765050804;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765050804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 20:21:56","2025-12-06 20:21:56","0",NULL),
("32641","image-optimization/cleanup/stuck-operation","complete","2025-12-06 20:26:56","2025-12-06 20:26:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765052816;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765052816;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 20:54:04","2025-12-06 20:54:04","0",NULL),
("32642","image-optimization/cleanup/stuck-operation","complete","2025-12-06 20:59:04","2025-12-06 20:59:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765054744;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765054744;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 21:33:42","2025-12-06 21:33:42","0",NULL),
("32643","image-optimization/cleanup/stuck-operation","complete","2025-12-06 21:38:42","2025-12-06 21:38:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765057122;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765057122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 21:55:57","2025-12-06 21:55:57","0",NULL),
("32644","image-optimization/cleanup/stuck-operation","complete","2025-12-06 22:00:57","2025-12-06 22:00:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765058457;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765058457;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-06 23:42:45","2025-12-06 23:42:45","0",NULL),
("32645","image-optimization/cleanup/stuck-operation","complete","2025-12-06 23:47:45","2025-12-06 23:47:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765064865;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765064865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 00:01:17","2025-12-07 00:01:17","0",NULL),
("32646","image-optimization/cleanup/stuck-operation","complete","2025-12-07 00:06:17","2025-12-07 00:06:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765065977;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765065977;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 00:10:17","2025-12-07 00:10:17","0",NULL),
("32647","image-optimization/cleanup/stuck-operation","complete","2025-12-07 00:15:17","2025-12-07 00:15:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765066517;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765066517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 00:48:22","2025-12-07 00:48:22","0",NULL),
("32648","image-optimization/cleanup/stuck-operation","complete","2025-12-07 00:53:22","2025-12-07 00:53:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765068802;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765068802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 02:36:58","2025-12-07 02:36:58","0",NULL),
("32649","image-optimization/cleanup/stuck-operation","complete","2025-12-07 02:41:58","2025-12-07 02:41:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765075318;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765075318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 03:45:32","2025-12-07 03:45:32","0",NULL),
("32650","image-optimization/cleanup/stuck-operation","complete","2025-12-07 03:50:32","2025-12-07 03:50:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765079432;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765079432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 05:34:45","2025-12-07 05:34:45","0",NULL),
("32651","image-optimization/cleanup/stuck-operation","complete","2025-12-07 05:39:45","2025-12-07 05:39:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765085985;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765085985;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 06:22:17","2025-12-07 06:22:17","0",NULL),
("32652","image-optimization/cleanup/stuck-operation","complete","2025-12-07 06:27:17","2025-12-07 06:27:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765088837;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765088837;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 07:01:49","2025-12-07 07:01:49","0",NULL),
("32653","image-optimization/cleanup/stuck-operation","complete","2025-12-07 07:06:49","2025-12-07 07:06:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765091209;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765091209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 08:22:30","2025-12-07 08:22:30","0",NULL),
("32654","image-optimization/cleanup/stuck-operation","complete","2025-12-07 08:27:30","2025-12-07 08:27:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765096050;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765096050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 10:17:40","2025-12-07 10:17:40","0",NULL),
("32655","image-optimization/cleanup/stuck-operation","complete","2025-12-07 10:22:40","2025-12-07 10:22:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765102960;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765102960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 10:33:36","2025-12-07 10:33:36","0",NULL),
("32656","image-optimization/cleanup/stuck-operation","complete","2025-12-07 10:38:36","2025-12-07 10:38:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765103916;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765103916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 10:59:55","2025-12-07 10:59:55","0",NULL),
("32657","image-optimization/cleanup/stuck-operation","complete","2025-12-07 11:04:55","2025-12-07 11:04:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765105495;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765105495;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 12:33:14","2025-12-07 12:33:14","0",NULL),
("32658","image-optimization/cleanup/stuck-operation","complete","2025-12-07 12:38:14","2025-12-07 12:38:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765111094;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765111094;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 13:55:37","2025-12-07 13:55:37","0",NULL),
("32659","image-optimization/cleanup/stuck-operation","complete","2025-12-07 14:00:37","2025-12-07 14:00:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765116037;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765116037;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 14:40:04","2025-12-07 14:40:04","0",NULL),
("32660","image-optimization/cleanup/stuck-operation","complete","2025-12-07 14:45:21","2025-12-07 14:45:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765118721;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765118721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 14:48:42","2025-12-07 14:48:42","0",NULL),
("32661","image-optimization/cleanup/stuck-operation","complete","2025-12-07 14:53:42","2025-12-07 14:53:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765119222;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765119222;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 17:17:38","2025-12-07 17:17:38","0",NULL),
("32662","image-optimization/cleanup/stuck-operation","complete","2025-12-07 17:22:38","2025-12-07 17:22:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765128158;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765128158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 17:26:19","2025-12-07 17:26:19","0",NULL),
("32663","image-optimization/cleanup/stuck-operation","complete","2025-12-07 17:31:19","2025-12-07 17:31:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765128679;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765128679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 17:48:25","2025-12-07 17:48:25","0",NULL),
("32664","image-optimization/cleanup/stuck-operation","complete","2025-12-07 17:53:25","2025-12-07 17:53:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765130005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765130005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 18:09:06","2025-12-07 18:09:06","0",NULL),
("32665","image-optimization/cleanup/stuck-operation","complete","2025-12-07 18:14:06","2025-12-07 18:14:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765131246;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765131246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 18:24:34","2025-12-07 18:24:34","0",NULL),
("32666","image-optimization/cleanup/stuck-operation","complete","2025-12-07 18:29:34","2025-12-07 18:29:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765132174;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765132174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 19:14:18","2025-12-07 19:14:18","0",NULL),
("32667","image-optimization/cleanup/stuck-operation","complete","2025-12-07 19:19:18","2025-12-07 19:19:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765135158;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765135158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 19:29:09","2025-12-07 19:29:09","0",NULL),
("32668","image-optimization/cleanup/stuck-operation","complete","2025-12-07 19:34:09","2025-12-07 19:34:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765136049;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765136049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 20:51:42","2025-12-07 20:51:42","0",NULL),
("32669","image-optimization/cleanup/stuck-operation","complete","2025-12-07 20:56:42","2025-12-07 20:56:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765141002;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765141002;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 21:09:17","2025-12-07 21:09:17","0",NULL),
("32670","image-optimization/cleanup/stuck-operation","complete","2025-12-07 21:14:17","2025-12-07 21:14:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765142057;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765142057;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 21:18:05","2025-12-07 21:18:05","0",NULL),
("32671","image-optimization/cleanup/stuck-operation","complete","2025-12-07 21:23:05","2025-12-07 21:23:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765142585;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765142585;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 21:51:13","2025-12-07 21:51:13","0",NULL),
("32672","image-optimization/cleanup/stuck-operation","complete","2025-12-07 21:56:13","2025-12-07 21:56:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765144573;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765144573;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 22:12:25","2025-12-07 22:12:25","0",NULL),
("32673","image-optimization/cleanup/stuck-operation","complete","2025-12-07 22:17:25","2025-12-07 22:17:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765145845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765145845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 22:47:36","2025-12-07 22:47:36","0",NULL),
("32674","image-optimization/cleanup/stuck-operation","complete","2025-12-07 22:52:36","2025-12-07 22:52:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765147956;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765147956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-07 23:45:46","2025-12-07 23:45:46","0",NULL),
("32675","image-optimization/cleanup/stuck-operation","complete","2025-12-07 23:50:46","2025-12-07 23:50:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765151446;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765151446;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 00:13:12","2025-12-08 00:13:12","0",NULL),
("32676","image-optimization/cleanup/stuck-operation","complete","2025-12-08 00:18:12","2025-12-08 00:18:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765153092;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765153092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 00:22:22","2025-12-08 00:22:22","0",NULL),
("32677","image-optimization/cleanup/stuck-operation","complete","2025-12-08 00:27:22","2025-12-08 00:27:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765153642;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765153642;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 01:31:56","2025-12-08 01:31:56","0",NULL),
("32678","image-optimization/cleanup/stuck-operation","complete","2025-12-08 01:36:56","2025-12-08 01:36:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765157816;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765157816;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 02:07:16","2025-12-08 02:07:16","0",NULL),
("32679","image-optimization/cleanup/stuck-operation","complete","2025-12-08 02:12:16","2025-12-08 02:12:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765159936;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765159936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 02:20:36","2025-12-08 02:20:36","0",NULL),
("32680","image-optimization/cleanup/stuck-operation","complete","2025-12-08 02:25:36","2025-12-08 02:25:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765160736;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765160736;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 02:52:43","2025-12-08 02:52:43","0",NULL),
("32681","image-optimization/cleanup/stuck-operation","complete","2025-12-08 02:57:43","2025-12-08 02:57:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765162663;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765162663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 03:17:12","2025-12-08 03:17:12","0",NULL),
("32682","image-optimization/cleanup/stuck-operation","complete","2025-12-08 03:22:12","2025-12-08 03:22:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765164132;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765164132;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 03:59:36","2025-12-08 03:59:36","0",NULL),
("32683","image-optimization/cleanup/stuck-operation","complete","2025-12-08 04:04:36","2025-12-08 04:04:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765166676;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765166676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 05:12:23","2025-12-08 05:12:23","0",NULL),
("32684","image-optimization/cleanup/stuck-operation","complete","2025-12-08 05:17:23","2025-12-08 05:17:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765171043;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765171043;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 05:28:37","2025-12-08 05:28:37","0",NULL),
("32685","image-optimization/cleanup/stuck-operation","complete","2025-12-08 05:33:37","2025-12-08 05:33:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765172017;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765172017;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 06:06:01","2025-12-08 06:06:01","0",NULL),
("32686","image-optimization/cleanup/stuck-operation","complete","2025-12-08 06:11:01","2025-12-08 06:11:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765174261;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765174261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 08:16:10","2025-12-08 08:16:10","0",NULL),
("32687","image-optimization/cleanup/stuck-operation","complete","2025-12-08 08:21:10","2025-12-08 08:21:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765182070;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765182070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 09:06:27","2025-12-08 09:06:27","0",NULL),
("32688","image-optimization/cleanup/stuck-operation","complete","2025-12-08 09:11:27","2025-12-08 09:11:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765185087;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765185087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 09:17:51","2025-12-08 09:17:51","0",NULL),
("32689","image-optimization/cleanup/stuck-operation","complete","2025-12-08 09:22:51","2025-12-08 09:22:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765185771;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765185771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 09:35:39","2025-12-08 09:35:39","0",NULL),
("32690","image-optimization/cleanup/stuck-operation","complete","2025-12-08 09:40:39","2025-12-08 09:40:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765186839;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765186839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 11:22:18","2025-12-08 11:22:18","0",NULL),
("32691","image-optimization/cleanup/stuck-operation","complete","2025-12-08 11:27:18","2025-12-08 11:27:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765193238;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765193238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 12:02:33","2025-12-08 12:02:33","0",NULL),
("32692","image-optimization/cleanup/stuck-operation","complete","2025-12-08 12:08:00","2025-12-08 12:08:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765195680;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765195680;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 12:16:47","2025-12-08 12:16:47","0",NULL),
("32693","image-optimization/cleanup/stuck-operation","complete","2025-12-08 12:21:47","2025-12-08 12:21:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765196507;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765196507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 13:03:43","2025-12-08 13:03:43","0",NULL),
("32694","image-optimization/cleanup/stuck-operation","complete","2025-12-08 13:08:43","2025-12-08 13:08:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765199323;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765199323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 13:11:05","2025-12-08 13:11:05","0",NULL),
("32695","image-optimization/cleanup/stuck-operation","complete","2025-12-08 13:16:05","2025-12-08 13:16:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765199765;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765199765;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 13:20:23","2025-12-08 13:20:23","0",NULL),
("32696","image-optimization/cleanup/stuck-operation","complete","2025-12-08 13:25:23","2025-12-08 13:25:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765200323;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765200323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 13:48:10","2025-12-08 13:48:10","0",NULL),
("32697","image-optimization/cleanup/stuck-operation","complete","2025-12-08 13:53:10","2025-12-08 13:53:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765201990;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765201990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 13:53:18","2025-12-08 13:53:18","0",NULL),
("32698","image-optimization/cleanup/stuck-operation","complete","2025-12-08 13:58:18","2025-12-08 13:58:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765202298;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765202298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 16:03:11","2025-12-08 16:03:11","0",NULL),
("32699","image-optimization/cleanup/stuck-operation","complete","2025-12-08 16:08:11","2025-12-08 16:08:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765210091;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765210091;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 16:23:44","2025-12-08 16:23:44","0",NULL),
("32700","image-optimization/cleanup/stuck-operation","complete","2025-12-08 16:28:44","2025-12-08 16:28:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765211324;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765211324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 16:50:23","2025-12-08 16:50:23","0",NULL),
("32701","image-optimization/cleanup/stuck-operation","complete","2025-12-08 16:55:23","2025-12-08 16:55:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765212923;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765212923;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 17:17:24","2025-12-08 17:17:24","0",NULL),
("32702","image-optimization/cleanup/stuck-operation","complete","2025-12-08 17:22:24","2025-12-08 17:22:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765214544;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765214544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 17:44:44","2025-12-08 17:44:44","0",NULL),
("32703","image-optimization/cleanup/stuck-operation","complete","2025-12-08 17:49:44","2025-12-08 17:49:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765216184;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765216184;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 18:05:29","2025-12-08 18:05:29","0",NULL),
("32704","image-optimization/cleanup/stuck-operation","complete","2025-12-08 18:10:29","2025-12-08 18:10:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765217429;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765217429;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 19:38:42","2025-12-08 19:38:42","0",NULL),
("32705","image-optimization/cleanup/stuck-operation","complete","2025-12-08 19:43:42","2025-12-08 19:43:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765223022;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765223022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 20:48:23","2025-12-08 20:48:23","0",NULL),
("32706","image-optimization/cleanup/stuck-operation","complete","2025-12-08 20:53:23","2025-12-08 20:53:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765227203;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765227203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 21:00:56","2025-12-08 21:00:56","0",NULL),
("32707","image-optimization/cleanup/stuck-operation","complete","2025-12-08 21:05:56","2025-12-08 21:05:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765227956;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765227956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-08 21:36:04","2025-12-08 21:36:04","0",NULL),
("32708","image-optimization/cleanup/stuck-operation","complete","2025-12-08 21:41:04","2025-12-08 21:41:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765230064;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765230064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 00:39:11","2025-12-09 00:39:11","0",NULL),
("32709","image-optimization/cleanup/stuck-operation","complete","2025-12-09 00:44:11","2025-12-09 00:44:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765241051;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765241051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 01:04:04","2025-12-09 01:04:04","0",NULL),
("32710","image-optimization/cleanup/stuck-operation","complete","2025-12-09 01:09:04","2025-12-09 01:09:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765242544;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765242544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 01:43:38","2025-12-09 01:43:38","0",NULL),
("32711","image-optimization/cleanup/stuck-operation","complete","2025-12-09 01:48:38","2025-12-09 01:48:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765244918;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765244918;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 01:59:15","2025-12-09 01:59:15","0",NULL),
("32712","image-optimization/cleanup/stuck-operation","complete","2025-12-09 02:04:15","2025-12-09 02:04:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765245855;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765245855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 02:06:57","2025-12-09 02:06:57","0",NULL),
("32713","image-optimization/cleanup/stuck-operation","complete","2025-12-09 02:11:57","2025-12-09 02:11:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765246317;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765246317;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 02:24:11","2025-12-09 02:24:11","0",NULL),
("32714","image-optimization/cleanup/stuck-operation","complete","2025-12-09 02:29:11","2025-12-09 02:29:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765247351;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765247351;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 02:33:52","2025-12-09 02:33:52","0",NULL),
("32715","image-optimization/cleanup/stuck-operation","complete","2025-12-09 02:38:52","2025-12-09 02:38:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765247932;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765247932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 02:54:58","2025-12-09 02:54:58","0",NULL),
("32716","image-optimization/cleanup/stuck-operation","complete","2025-12-09 02:59:58","2025-12-09 02:59:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765249198;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765249198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 03:30:27","2025-12-09 03:30:27","0",NULL),
("32717","image-optimization/cleanup/stuck-operation","complete","2025-12-09 03:35:27","2025-12-09 03:35:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765251327;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765251327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 03:57:39","2025-12-09 03:57:39","0",NULL),
("32718","image-optimization/cleanup/stuck-operation","complete","2025-12-09 04:02:39","2025-12-09 04:02:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765252959;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765252959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 04:04:04","2025-12-09 04:04:04","0",NULL),
("32719","image-optimization/cleanup/stuck-operation","complete","2025-12-09 04:09:04","2025-12-09 04:09:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765253344;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765253344;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 04:35:25","2025-12-09 04:35:25","0",NULL),
("32720","image-optimization/cleanup/stuck-operation","complete","2025-12-09 04:40:25","2025-12-09 04:40:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765255225;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765255225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 04:43:54","2025-12-09 04:43:54","0",NULL),
("32721","image-optimization/cleanup/stuck-operation","complete","2025-12-09 04:48:54","2025-12-09 04:48:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765255734;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765255734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 05:33:39","2025-12-09 05:33:39","0",NULL),
("32722","image-optimization/cleanup/stuck-operation","complete","2025-12-09 05:38:39","2025-12-09 05:38:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765258719;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765258719;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 06:24:17","2025-12-09 06:24:17","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("32723","image-optimization/cleanup/stuck-operation","complete","2025-12-09 06:29:17","2025-12-09 06:29:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765261757;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765261757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 07:20:19","2025-12-09 07:20:19","0",NULL),
("32724","image-optimization/cleanup/stuck-operation","complete","2025-12-09 07:25:19","2025-12-09 07:25:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765265119;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765265119;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 07:42:30","2025-12-09 07:42:30","0",NULL),
("32725","image-optimization/cleanup/stuck-operation","complete","2025-12-09 07:47:30","2025-12-09 07:47:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765266450;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765266450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 08:11:25","2025-12-09 08:11:25","0",NULL),
("32726","image-optimization/cleanup/stuck-operation","complete","2025-12-09 08:16:25","2025-12-09 08:16:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765268185;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765268185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 08:47:26","2025-12-09 08:47:26","0",NULL),
("32727","image-optimization/cleanup/stuck-operation","complete","2025-12-09 08:52:26","2025-12-09 08:52:26","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765270346;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765270346;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 10:00:55","2025-12-09 10:00:55","0",NULL),
("32728","image-optimization/cleanup/stuck-operation","complete","2025-12-09 10:05:55","2025-12-09 10:05:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765274755;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765274755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 10:52:30","2025-12-09 10:52:30","0",NULL),
("32729","image-optimization/cleanup/stuck-operation","complete","2025-12-09 10:57:30","2025-12-09 10:57:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765277850;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765277850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 11:48:52","2025-12-09 11:48:52","0",NULL),
("32730","image-optimization/cleanup/stuck-operation","complete","2025-12-09 11:53:52","2025-12-09 11:53:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765281232;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765281232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 14:06:09","2025-12-09 14:06:09","0",NULL),
("32731","image-optimization/cleanup/stuck-operation","complete","2025-12-09 14:11:09","2025-12-09 14:11:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765289469;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765289469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 14:31:31","2025-12-09 14:31:31","0",NULL),
("32732","image-optimization/cleanup/stuck-operation","complete","2025-12-09 14:36:31","2025-12-09 14:36:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765290991;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765290991;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 14:41:33","2025-12-09 14:41:33","0",NULL),
("32733","image-optimization/cleanup/stuck-operation","complete","2025-12-09 14:46:33","2025-12-09 14:46:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765291593;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765291593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 15:38:08","2025-12-09 15:38:08","0",NULL),
("32734","image-optimization/cleanup/stuck-operation","complete","2025-12-09 15:43:08","2025-12-09 15:43:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765294988;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765294988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 16:33:48","2025-12-09 16:33:48","0",NULL),
("32735","image-optimization/cleanup/stuck-operation","complete","2025-12-09 16:38:48","2025-12-09 16:38:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765298328;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765298328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 16:41:44","2025-12-09 16:41:44","0",NULL),
("32736","image-optimization/cleanup/stuck-operation","complete","2025-12-09 16:46:44","2025-12-09 16:46:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765298804;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765298804;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 16:50:53","2025-12-09 16:50:53","0",NULL),
("32737","image-optimization/cleanup/stuck-operation","complete","2025-12-09 16:55:53","2025-12-09 16:55:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765299353;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765299353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 16:57:01","2025-12-09 16:57:01","0",NULL),
("32738","image-optimization/cleanup/stuck-operation","complete","2025-12-09 17:02:01","2025-12-09 17:02:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765299721;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765299721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 17:02:54","2025-12-09 17:02:54","0",NULL),
("32739","image-optimization/cleanup/stuck-operation","complete","2025-12-09 17:07:54","2025-12-09 17:07:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765300074;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765300074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 17:31:47","2025-12-09 17:31:47","0",NULL),
("32740","image-optimization/cleanup/stuck-operation","complete","2025-12-09 17:36:47","2025-12-09 17:36:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765301807;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765301807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 18:01:52","2025-12-09 18:01:52","0",NULL),
("32741","image-optimization/cleanup/stuck-operation","complete","2025-12-09 18:06:52","2025-12-09 18:06:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765303612;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765303612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 18:11:36","2025-12-09 18:11:36","0",NULL),
("32742","image-optimization/cleanup/stuck-operation","complete","2025-12-09 18:16:36","2025-12-09 18:16:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765304196;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765304196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 18:44:17","2025-12-09 18:44:17","0",NULL),
("32743","image-optimization/cleanup/stuck-operation","complete","2025-12-09 18:49:17","2025-12-09 18:49:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765306157;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765306157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 19:12:13","2025-12-09 19:12:13","0",NULL),
("32744","image-optimization/cleanup/stuck-operation","complete","2025-12-09 19:17:13","2025-12-09 19:17:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765307833;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765307833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 19:59:00","2025-12-09 19:59:00","0",NULL),
("32745","image-optimization/cleanup/stuck-operation","complete","2025-12-09 20:04:00","2025-12-09 20:04:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765310640;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765310640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 20:07:30","2025-12-09 20:07:30","0",NULL),
("32746","image-optimization/cleanup/stuck-operation","complete","2025-12-09 20:12:30","2025-12-09 20:12:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765311150;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765311150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 20:49:23","2025-12-09 20:49:23","0",NULL),
("32747","image-optimization/cleanup/stuck-operation","complete","2025-12-09 20:54:23","2025-12-09 20:54:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765313663;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765313663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 20:58:23","2025-12-09 20:58:23","0",NULL),
("32748","image-optimization/cleanup/stuck-operation","complete","2025-12-09 21:03:23","2025-12-09 21:03:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765314203;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765314203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 21:13:44","2025-12-09 21:13:44","0",NULL),
("32749","image-optimization/cleanup/stuck-operation","complete","2025-12-09 21:18:44","2025-12-09 21:18:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765315124;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765315124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 21:21:21","2025-12-09 21:21:21","0",NULL),
("32750","image-optimization/cleanup/stuck-operation","complete","2025-12-09 21:26:21","2025-12-09 21:26:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765315581;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765315581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 21:29:34","2025-12-09 21:29:34","0",NULL),
("32751","image-optimization/cleanup/stuck-operation","complete","2025-12-09 21:34:34","2025-12-09 21:34:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765316074;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765316074;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 22:05:10","2025-12-09 22:05:10","0",NULL),
("32752","image-optimization/cleanup/stuck-operation","complete","2025-12-09 22:10:10","2025-12-09 22:10:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765318210;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765318210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 22:50:00","2025-12-09 22:50:00","0",NULL),
("32753","image-optimization/cleanup/stuck-operation","complete","2025-12-09 22:55:00","2025-12-09 22:55:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765320900;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765320900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 23:07:16","2025-12-09 23:07:16","0",NULL),
("32754","image-optimization/cleanup/stuck-operation","complete","2025-12-09 23:12:16","2025-12-09 23:12:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765321936;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765321936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 23:20:29","2025-12-09 23:20:29","0",NULL),
("32755","image-optimization/cleanup/stuck-operation","complete","2025-12-09 23:25:29","2025-12-09 23:25:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765322729;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765322729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-09 23:58:55","2025-12-09 23:58:55","0",NULL),
("32756","image-optimization/cleanup/stuck-operation","complete","2025-12-10 00:03:55","2025-12-10 00:03:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765325035;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765325035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 01:20:37","2025-12-10 01:20:37","0",NULL),
("32757","image-optimization/cleanup/stuck-operation","complete","2025-12-10 01:25:37","2025-12-10 01:25:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765329937;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765329937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 01:43:35","2025-12-10 01:43:35","0",NULL),
("32758","image-optimization/cleanup/stuck-operation","complete","2025-12-10 01:49:01","2025-12-10 01:49:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765331341;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765331341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 02:32:54","2025-12-10 02:32:54","0",NULL),
("32759","image-optimization/cleanup/stuck-operation","complete","2025-12-10 02:37:54","2025-12-10 02:37:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765334274;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765334274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 03:03:21","2025-12-10 03:03:21","0",NULL),
("32760","image-optimization/cleanup/stuck-operation","complete","2025-12-10 03:08:21","2025-12-10 03:08:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765336101;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765336101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 04:29:52","2025-12-10 04:29:52","0",NULL),
("32761","image-optimization/cleanup/stuck-operation","complete","2025-12-10 04:34:52","2025-12-10 04:34:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765341292;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765341292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 05:52:07","2025-12-10 05:52:07","0",NULL),
("32762","image-optimization/cleanup/stuck-operation","complete","2025-12-10 05:57:07","2025-12-10 05:57:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765346227;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765346227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 06:14:48","2025-12-10 06:14:48","0",NULL),
("32763","image-optimization/cleanup/stuck-operation","complete","2025-12-10 06:19:48","2025-12-10 06:19:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765347588;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765347588;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 06:32:11","2025-12-10 06:32:11","0",NULL),
("32764","image-optimization/cleanup/stuck-operation","complete","2025-12-10 06:37:11","2025-12-10 06:37:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765348631;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765348631;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 06:49:35","2025-12-10 06:49:35","0",NULL),
("32765","image-optimization/cleanup/stuck-operation","complete","2025-12-10 06:54:35","2025-12-10 06:54:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765349675;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765349675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 07:10:28","2025-12-10 07:10:28","0",NULL),
("32766","image-optimization/cleanup/stuck-operation","complete","2025-12-10 07:15:28","2025-12-10 07:15:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765350928;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765350928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 09:45:44","2025-12-10 09:45:44","0",NULL),
("32767","image-optimization/cleanup/stuck-operation","complete","2025-12-10 09:50:44","2025-12-10 09:50:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765360244;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765360244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 10:25:22","2025-12-10 10:25:22","0",NULL),
("32768","image-optimization/cleanup/stuck-operation","complete","2025-12-10 10:30:22","2025-12-10 10:30:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765362622;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765362622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 10:57:43","2025-12-10 10:57:43","0",NULL),
("32769","image-optimization/cleanup/stuck-operation","complete","2025-12-10 11:02:43","2025-12-10 11:02:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765364563;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765364563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 11:59:32","2025-12-10 11:59:32","0",NULL),
("32770","image-optimization/cleanup/stuck-operation","complete","2025-12-10 12:04:32","2025-12-10 12:04:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765368272;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765368272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 12:09:15","2025-12-10 12:09:15","0",NULL),
("32771","image-optimization/cleanup/stuck-operation","complete","2025-12-10 12:14:15","2025-12-10 12:14:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765368855;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765368855;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 12:38:46","2025-12-10 12:38:46","0",NULL),
("32772","image-optimization/cleanup/stuck-operation","complete","2025-12-10 12:43:46","2025-12-10 12:43:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765370626;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765370626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 13:29:27","2025-12-10 13:29:27","0",NULL),
("32773","image-optimization/cleanup/stuck-operation","complete","2025-12-10 13:34:27","2025-12-10 13:34:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765373667;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765373667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 14:15:17","2025-12-10 14:15:17","0",NULL),
("32774","image-optimization/cleanup/stuck-operation","complete","2025-12-10 14:20:17","2025-12-10 14:20:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765376417;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765376417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 15:11:57","2025-12-10 15:11:57","0",NULL),
("32775","image-optimization/cleanup/stuck-operation","complete","2025-12-10 15:16:57","2025-12-10 15:16:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765379817;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765379817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 15:21:45","2025-12-10 15:21:45","0",NULL),
("32776","image-optimization/cleanup/stuck-operation","complete","2025-12-10 15:26:45","2025-12-10 15:26:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765380405;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765380405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 15:34:19","2025-12-10 15:34:19","0",NULL),
("32777","image-optimization/cleanup/stuck-operation","complete","2025-12-10 15:39:19","2025-12-10 15:39:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765381159;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765381159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 15:50:58","2025-12-10 15:50:58","0",NULL),
("32778","image-optimization/cleanup/stuck-operation","complete","2025-12-10 15:55:58","2025-12-10 15:55:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765382158;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765382158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 17:14:58","2025-12-10 17:14:58","0",NULL),
("32779","image-optimization/cleanup/stuck-operation","complete","2025-12-10 17:19:58","2025-12-10 17:19:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765387198;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765387198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 18:29:17","2025-12-10 18:29:17","0",NULL),
("32780","image-optimization/cleanup/stuck-operation","complete","2025-12-10 18:34:17","2025-12-10 18:34:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765391657;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765391657;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 20:02:55","2025-12-10 20:02:55","0",NULL),
("32781","image-optimization/cleanup/stuck-operation","complete","2025-12-10 20:07:55","2025-12-10 20:07:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765397275;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765397275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 20:57:54","2025-12-10 20:57:54","0",NULL),
("32782","image-optimization/cleanup/stuck-operation","complete","2025-12-10 21:02:54","2025-12-10 21:02:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765400574;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765400574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 21:09:38","2025-12-10 21:09:38","0",NULL),
("32783","image-optimization/cleanup/stuck-operation","complete","2025-12-10 21:14:38","2025-12-10 21:14:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765401278;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765401278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 21:31:17","2025-12-10 21:31:17","0",NULL),
("32784","image-optimization/cleanup/stuck-operation","complete","2025-12-10 21:36:17","2025-12-10 21:36:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765402577;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765402577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 22:19:18","2025-12-10 22:19:18","0",NULL),
("32785","image-optimization/cleanup/stuck-operation","complete","2025-12-10 22:24:18","2025-12-10 22:24:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765405458;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765405458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-10 22:49:03","2025-12-10 22:49:03","0",NULL),
("32786","image-optimization/cleanup/stuck-operation","complete","2025-12-10 22:54:03","2025-12-10 22:54:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765407243;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765407243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 00:04:36","2025-12-11 00:04:36","0",NULL),
("32787","image-optimization/cleanup/stuck-operation","complete","2025-12-11 00:09:36","2025-12-11 00:09:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765411776;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765411776;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 00:48:35","2025-12-11 00:48:35","0",NULL),
("32788","image-optimization/cleanup/stuck-operation","complete","2025-12-11 00:53:35","2025-12-11 00:53:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765414415;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765414415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 01:00:25","2025-12-11 01:00:25","0",NULL),
("32789","image-optimization/cleanup/stuck-operation","complete","2025-12-11 01:05:25","2025-12-11 01:05:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765415125;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765415125;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 01:30:40","2025-12-11 01:30:40","0",NULL),
("32790","image-optimization/cleanup/stuck-operation","complete","2025-12-11 01:35:40","2025-12-11 01:35:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765416940;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765416940;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 01:59:53","2025-12-11 01:59:53","0",NULL),
("32791","image-optimization/cleanup/stuck-operation","complete","2025-12-11 02:04:53","2025-12-11 02:04:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765418693;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765418693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 02:22:05","2025-12-11 02:22:05","0",NULL),
("32792","image-optimization/cleanup/stuck-operation","complete","2025-12-11 02:27:05","2025-12-11 02:27:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765420025;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765420025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 02:48:53","2025-12-11 02:48:53","0",NULL),
("32793","image-optimization/cleanup/stuck-operation","complete","2025-12-11 02:53:53","2025-12-11 02:53:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765421633;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765421633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 03:01:16","2025-12-11 03:01:16","0",NULL),
("32794","image-optimization/cleanup/stuck-operation","complete","2025-12-11 03:06:16","2025-12-11 03:06:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765422376;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765422376;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 03:39:48","2025-12-11 03:39:48","0",NULL),
("32795","image-optimization/cleanup/stuck-operation","complete","2025-12-11 03:44:48","2025-12-11 03:44:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765424688;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765424688;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 03:48:29","2025-12-11 03:48:29","0",NULL),
("32796","image-optimization/cleanup/stuck-operation","complete","2025-12-11 03:53:29","2025-12-11 03:53:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765425209;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765425209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 04:14:46","2025-12-11 04:14:46","0",NULL),
("32797","image-optimization/cleanup/stuck-operation","complete","2025-12-11 04:19:46","2025-12-11 04:19:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765426786;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765426786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 04:59:25","2025-12-11 04:59:25","0",NULL),
("32798","image-optimization/cleanup/stuck-operation","complete","2025-12-11 05:04:25","2025-12-11 05:04:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765429465;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765429465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 05:05:45","2025-12-11 05:05:45","0",NULL),
("32799","image-optimization/cleanup/stuck-operation","complete","2025-12-11 05:10:45","2025-12-11 05:10:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765429845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765429845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 05:34:18","2025-12-11 05:34:18","0",NULL),
("32800","image-optimization/cleanup/stuck-operation","complete","2025-12-11 05:39:18","2025-12-11 05:39:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765431558;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765431558;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 05:44:34","2025-12-11 05:44:34","0",NULL),
("32801","image-optimization/cleanup/stuck-operation","complete","2025-12-11 05:49:34","2025-12-11 05:49:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765432174;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765432174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 05:54:37","2025-12-11 05:54:37","0",NULL),
("32802","image-optimization/cleanup/stuck-operation","complete","2025-12-11 05:59:37","2025-12-11 05:59:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765432777;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765432777;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 06:10:43","2025-12-11 06:10:43","0",NULL),
("32803","image-optimization/cleanup/stuck-operation","complete","2025-12-11 06:15:43","2025-12-11 06:15:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765433743;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765433743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 06:17:13","2025-12-11 06:17:13","0",NULL),
("32804","image-optimization/cleanup/stuck-operation","complete","2025-12-11 06:22:13","2025-12-11 06:22:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765434133;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765434133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 06:44:07","2025-12-11 06:44:07","0",NULL),
("32805","image-optimization/cleanup/stuck-operation","complete","2025-12-11 06:49:07","2025-12-11 06:49:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765435747;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765435747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 07:00:56","2025-12-11 07:00:56","0",NULL),
("32806","image-optimization/cleanup/stuck-operation","complete","2025-12-11 07:05:56","2025-12-11 07:05:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765436756;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765436756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 07:10:59","2025-12-11 07:10:59","0",NULL),
("32807","image-optimization/cleanup/stuck-operation","complete","2025-12-11 07:15:59","2025-12-11 07:15:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765437359;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765437359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 07:20:56","2025-12-11 07:20:56","0",NULL),
("32808","image-optimization/cleanup/stuck-operation","complete","2025-12-11 07:25:56","2025-12-11 07:25:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765437956;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765437956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 07:33:16","2025-12-11 07:33:16","0",NULL),
("32809","image-optimization/cleanup/stuck-operation","complete","2025-12-11 07:38:16","2025-12-11 07:38:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765438696;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765438696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 08:09:51","2025-12-11 08:09:51","0",NULL),
("32810","image-optimization/cleanup/stuck-operation","complete","2025-12-11 08:14:51","2025-12-11 08:14:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765440891;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765440891;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 08:23:17","2025-12-11 08:23:17","0",NULL),
("32811","image-optimization/cleanup/stuck-operation","complete","2025-12-11 08:28:17","2025-12-11 08:28:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765441697;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765441697;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 09:54:56","2025-12-11 09:54:56","0",NULL),
("32812","image-optimization/cleanup/stuck-operation","complete","2025-12-11 09:59:56","2025-12-11 09:59:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765447196;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765447196;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 10:16:21","2025-12-11 10:16:21","0",NULL),
("32813","image-optimization/cleanup/stuck-operation","complete","2025-12-11 10:21:21","2025-12-11 10:21:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765448481;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765448481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 10:49:36","2025-12-11 10:49:36","0",NULL),
("32814","image-optimization/cleanup/stuck-operation","complete","2025-12-11 10:54:36","2025-12-11 10:54:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765450476;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765450476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 11:07:36","2025-12-11 11:07:36","0",NULL),
("32815","image-optimization/cleanup/stuck-operation","complete","2025-12-11 11:12:36","2025-12-11 11:12:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765451556;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765451556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 11:19:18","2025-12-11 11:19:18","0",NULL),
("32816","image-optimization/cleanup/stuck-operation","complete","2025-12-11 11:24:18","2025-12-11 11:24:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765452258;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765452258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 11:35:50","2025-12-11 11:35:50","0",NULL),
("32817","image-optimization/cleanup/stuck-operation","complete","2025-12-11 11:40:50","2025-12-11 11:40:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765453250;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765453250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 12:09:12","2025-12-11 12:09:12","0",NULL),
("32818","image-optimization/cleanup/stuck-operation","complete","2025-12-11 12:14:12","2025-12-11 12:14:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765455252;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765455252;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 12:19:08","2025-12-11 12:19:08","0",NULL),
("32819","image-optimization/cleanup/stuck-operation","complete","2025-12-11 12:24:08","2025-12-11 12:24:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765455848;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765455848;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 12:52:49","2025-12-11 12:52:49","0",NULL),
("32820","image-optimization/cleanup/stuck-operation","complete","2025-12-11 12:57:49","2025-12-11 12:57:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765457869;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765457869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 14:46:42","2025-12-11 14:46:42","0",NULL),
("32821","image-optimization/cleanup/stuck-operation","complete","2025-12-11 14:51:42","2025-12-11 14:51:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765464702;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765464702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 14:56:28","2025-12-11 14:56:28","0",NULL),
("32822","image-optimization/cleanup/stuck-operation","complete","2025-12-11 15:01:28","2025-12-11 15:01:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765465288;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765465288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 16:18:28","2025-12-11 16:18:28","0",NULL),
("32823","image-optimization/cleanup/stuck-operation","complete","2025-12-11 16:23:28","2025-12-11 16:23:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765470208;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765470208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 17:15:56","2025-12-11 17:15:56","0",NULL),
("32824","image-optimization/cleanup/stuck-operation","complete","2025-12-11 17:20:56","2025-12-11 17:20:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765473656;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765473656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 18:30:00","2025-12-11 18:30:00","0",NULL),
("32825","image-optimization/cleanup/stuck-operation","complete","2025-12-11 18:35:00","2025-12-11 18:35:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765478100;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765478100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 18:45:35","2025-12-11 18:45:35","0",NULL),
("32826","image-optimization/cleanup/stuck-operation","complete","2025-12-11 18:50:35","2025-12-11 18:50:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765479035;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765479035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 19:27:35","2025-12-11 19:27:35","0",NULL),
("32827","image-optimization/cleanup/stuck-operation","complete","2025-12-11 19:32:35","2025-12-11 19:32:35","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765481555;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765481555;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 20:37:56","2025-12-11 20:37:56","0",NULL),
("32828","image-optimization/cleanup/stuck-operation","complete","2025-12-11 20:42:56","2025-12-11 20:42:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765485776;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765485776;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 22:46:12","2025-12-11 22:46:12","0",NULL),
("32829","image-optimization/cleanup/stuck-operation","complete","2025-12-11 22:51:12","2025-12-11 22:51:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765493472;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765493472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-11 23:44:37","2025-12-11 23:44:37","0",NULL),
("32830","image-optimization/cleanup/stuck-operation","complete","2025-12-11 23:49:37","2025-12-11 23:49:37","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765496977;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765496977;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 00:17:08","2025-12-12 00:17:08","0",NULL),
("32831","image-optimization/cleanup/stuck-operation","complete","2025-12-12 00:22:08","2025-12-12 00:22:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765498928;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765498928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 00:36:23","2025-12-12 00:36:23","0",NULL),
("32832","image-optimization/cleanup/stuck-operation","complete","2025-12-12 00:41:24","2025-12-12 00:41:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765500084;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765500084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 01:47:16","2025-12-12 01:47:16","0",NULL),
("32833","image-optimization/cleanup/stuck-operation","complete","2025-12-12 01:52:16","2025-12-12 01:52:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765504336;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765504336;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 02:19:30","2025-12-12 02:19:30","0",NULL),
("32834","image-optimization/cleanup/stuck-operation","complete","2025-12-12 02:24:30","2025-12-12 02:24:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765506270;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765506270;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 02:56:14","2025-12-12 02:56:14","0",NULL),
("32835","image-optimization/cleanup/stuck-operation","complete","2025-12-12 03:01:14","2025-12-12 03:01:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765508474;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765508474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 03:14:16","2025-12-12 03:14:16","0",NULL),
("32836","image-optimization/cleanup/stuck-operation","complete","2025-12-12 03:19:16","2025-12-12 03:19:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765509556;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765509556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 05:27:05","2025-12-12 05:27:05","0",NULL),
("32837","image-optimization/cleanup/stuck-operation","complete","2025-12-12 05:32:05","2025-12-12 05:32:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765517525;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765517525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 06:14:08","2025-12-12 06:14:08","0",NULL),
("32838","image-optimization/cleanup/stuck-operation","complete","2025-12-12 06:19:08","2025-12-12 06:19:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765520348;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765520348;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 07:34:24","2025-12-12 07:34:24","0",NULL),
("32839","image-optimization/cleanup/stuck-operation","complete","2025-12-12 07:39:24","2025-12-12 07:39:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765525164;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765525164;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 09:07:03","2025-12-12 09:07:03","0",NULL),
("32840","image-optimization/cleanup/stuck-operation","complete","2025-12-12 09:12:03","2025-12-12 09:12:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765530723;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765530723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 10:42:24","2025-12-12 10:42:24","0",NULL),
("32841","image-optimization/cleanup/stuck-operation","complete","2025-12-12 10:47:24","2025-12-12 10:47:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765536444;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765536444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 11:05:15","2025-12-12 11:05:15","0",NULL),
("32842","image-optimization/cleanup/stuck-operation","complete","2025-12-12 11:10:15","2025-12-12 11:10:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765537815;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765537815;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 11:15:34","2025-12-12 11:15:34","0",NULL),
("32843","image-optimization/cleanup/stuck-operation","complete","2025-12-12 11:20:34","2025-12-12 11:20:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765538434;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765538434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 11:49:29","2025-12-12 11:49:29","0",NULL),
("32844","image-optimization/cleanup/stuck-operation","complete","2025-12-12 11:54:29","2025-12-12 11:54:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765540469;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765540469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 12:56:53","2025-12-12 12:56:53","0",NULL),
("32845","image-optimization/cleanup/stuck-operation","complete","2025-12-12 13:01:53","2025-12-12 13:01:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765544513;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765544513;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 13:09:00","2025-12-12 13:09:00","0",NULL),
("32846","image-optimization/cleanup/stuck-operation","complete","2025-12-12 13:14:00","2025-12-12 13:14:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765545240;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765545240;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 13:23:44","2025-12-12 13:23:44","0",NULL),
("32847","image-optimization/cleanup/stuck-operation","complete","2025-12-12 13:28:44","2025-12-12 13:28:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765546124;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765546124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 15:15:34","2025-12-12 15:15:34","0",NULL),
("32848","image-optimization/cleanup/stuck-operation","complete","2025-12-12 15:20:34","2025-12-12 15:20:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765552834;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765552834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 18:10:45","2025-12-12 18:10:45","0",NULL),
("32849","image-optimization/cleanup/stuck-operation","complete","2025-12-12 18:15:45","2025-12-12 18:15:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765563345;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765563345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 19:56:48","2025-12-12 19:56:48","0",NULL),
("32850","image-optimization/cleanup/stuck-operation","complete","2025-12-12 20:01:48","2025-12-12 20:01:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765569708;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765569708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 20:02:47","2025-12-12 20:02:47","0",NULL),
("32851","image-optimization/cleanup/stuck-operation","complete","2025-12-12 20:07:47","2025-12-12 20:07:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765570067;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765570067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 20:39:38","2025-12-12 20:39:38","0",NULL),
("32852","image-optimization/cleanup/stuck-operation","complete","2025-12-12 20:44:38","2025-12-12 20:44:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765572278;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765572278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 20:56:58","2025-12-12 20:56:58","0",NULL),
("32853","image-optimization/cleanup/stuck-operation","complete","2025-12-12 21:02:06","2025-12-12 21:02:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765573326;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765573326;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 21:02:33","2025-12-12 21:02:33","0",NULL),
("32854","image-optimization/cleanup/stuck-operation","complete","2025-12-12 21:07:33","2025-12-12 21:07:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765573653;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765573653;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 21:32:36","2025-12-12 21:32:36","0",NULL),
("32855","image-optimization/cleanup/stuck-operation","complete","2025-12-12 21:37:36","2025-12-12 21:37:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765575456;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765575456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 22:34:10","2025-12-12 22:34:10","0",NULL),
("32856","image-optimization/cleanup/stuck-operation","complete","2025-12-12 22:39:10","2025-12-12 22:39:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765579150;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765579150;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-12 23:16:07","2025-12-12 23:16:07","0",NULL),
("32857","image-optimization/cleanup/stuck-operation","complete","2025-12-12 23:21:07","2025-12-12 23:21:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765581667;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765581667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 03:13:49","2025-12-13 03:13:49","0",NULL),
("32858","image-optimization/cleanup/stuck-operation","complete","2025-12-13 03:18:49","2025-12-13 03:18:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765595929;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765595929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 04:47:12","2025-12-13 04:47:12","0",NULL),
("32859","image-optimization/cleanup/stuck-operation","complete","2025-12-13 04:52:12","2025-12-13 04:52:12","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765601532;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765601532;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 05:40:40","2025-12-13 05:40:40","0",NULL),
("32860","image-optimization/cleanup/stuck-operation","complete","2025-12-13 05:45:40","2025-12-13 05:45:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765604740;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765604740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 06:35:13","2025-12-13 06:35:13","0",NULL),
("32861","image-optimization/cleanup/stuck-operation","complete","2025-12-13 06:40:13","2025-12-13 06:40:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765608013;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765608013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 06:50:40","2025-12-13 06:50:40","0",NULL),
("32862","image-optimization/cleanup/stuck-operation","complete","2025-12-13 06:55:40","2025-12-13 06:55:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765608940;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765608940;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 08:13:36","2025-12-13 08:13:36","0",NULL),
("32863","image-optimization/cleanup/stuck-operation","complete","2025-12-13 08:18:36","2025-12-13 08:18:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765613916;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765613916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 09:34:02","2025-12-13 09:34:02","0",NULL),
("32864","image-optimization/cleanup/stuck-operation","complete","2025-12-13 09:39:02","2025-12-13 09:39:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765618742;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765618742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 10:32:58","2025-12-13 10:32:58","0",NULL),
("32865","image-optimization/cleanup/stuck-operation","complete","2025-12-13 10:37:58","2025-12-13 10:37:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765622278;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765622278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 10:46:04","2025-12-13 10:46:04","0",NULL),
("32866","image-optimization/cleanup/stuck-operation","complete","2025-12-13 10:51:04","2025-12-13 10:51:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765623064;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765623064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 11:16:56","2025-12-13 11:16:56","0",NULL),
("32867","image-optimization/cleanup/stuck-operation","complete","2025-12-13 11:21:56","2025-12-13 11:21:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765624916;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765624916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 12:08:41","2025-12-13 12:08:41","0",NULL),
("32868","image-optimization/cleanup/stuck-operation","complete","2025-12-13 12:13:41","2025-12-13 12:13:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765628021;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765628021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 13:55:30","2025-12-13 13:55:30","0",NULL),
("32869","image-optimization/cleanup/stuck-operation","complete","2025-12-13 14:00:30","2025-12-13 14:00:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765634430;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765634430;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 18:14:52","2025-12-13 18:14:52","0",NULL),
("32870","image-optimization/cleanup/stuck-operation","complete","2025-12-13 18:19:52","2025-12-13 18:19:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765649992;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765649992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 19:35:27","2025-12-13 19:35:27","0",NULL),
("32871","image-optimization/cleanup/stuck-operation","complete","2025-12-13 19:40:27","2025-12-13 19:40:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765654827;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765654827;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 21:19:55","2025-12-13 21:19:55","0",NULL),
("32872","image-optimization/cleanup/stuck-operation","complete","2025-12-13 21:24:55","2025-12-13 21:24:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765661095;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765661095;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 21:31:48","2025-12-13 21:31:48","0",NULL),
("32873","image-optimization/cleanup/stuck-operation","complete","2025-12-13 21:36:48","2025-12-13 21:36:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765661808;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765661808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 22:19:05","2025-12-13 22:19:05","0",NULL),
("32874","image-optimization/cleanup/stuck-operation","complete","2025-12-13 22:24:05","2025-12-13 22:24:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765664645;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765664645;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 22:31:28","2025-12-13 22:31:28","0",NULL),
("32875","image-optimization/cleanup/stuck-operation","complete","2025-12-13 22:36:28","2025-12-13 22:36:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765665388;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765665388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-13 23:07:40","2025-12-13 23:07:40","0",NULL),
("32876","image-optimization/cleanup/stuck-operation","complete","2025-12-13 23:12:40","2025-12-13 23:12:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765667560;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765667560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 01:23:38","2025-12-14 01:23:38","0",NULL),
("32877","image-optimization/cleanup/stuck-operation","complete","2025-12-14 01:28:38","2025-12-14 01:28:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765675718;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765675718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 02:10:17","2025-12-14 02:10:17","0",NULL),
("32878","image-optimization/cleanup/stuck-operation","complete","2025-12-14 02:15:17","2025-12-14 02:15:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765678517;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765678517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 04:16:06","2025-12-14 04:16:06","0",NULL),
("32879","image-optimization/cleanup/stuck-operation","complete","2025-12-14 04:21:06","2025-12-14 04:21:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765686066;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765686066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 04:45:00","2025-12-14 04:45:00","0",NULL),
("32880","image-optimization/cleanup/stuck-operation","complete","2025-12-14 04:50:00","2025-12-14 04:50:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765687800;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765687800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 05:28:13","2025-12-14 05:28:13","0",NULL),
("32881","image-optimization/cleanup/stuck-operation","complete","2025-12-14 05:33:13","2025-12-14 05:33:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765690393;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765690393;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 06:10:39","2025-12-14 06:10:39","0",NULL),
("32882","image-optimization/cleanup/stuck-operation","complete","2025-12-14 06:15:39","2025-12-14 06:15:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765692939;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765692939;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 06:36:44","2025-12-14 06:36:44","0",NULL),
("32883","image-optimization/cleanup/stuck-operation","complete","2025-12-14 06:41:44","2025-12-14 06:41:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765694504;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765694504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 07:42:59","2025-12-14 07:42:59","0",NULL),
("32884","image-optimization/cleanup/stuck-operation","complete","2025-12-14 07:47:59","2025-12-14 07:47:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765698479;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765698479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 08:03:21","2025-12-14 08:03:21","0",NULL),
("32885","image-optimization/cleanup/stuck-operation","complete","2025-12-14 08:08:21","2025-12-14 08:08:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765699701;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765699701;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 08:17:13","2025-12-14 08:17:13","0",NULL),
("32886","image-optimization/cleanup/stuck-operation","complete","2025-12-14 08:22:13","2025-12-14 08:22:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765700533;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765700533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 08:57:58","2025-12-14 08:57:58","0",NULL),
("32887","image-optimization/cleanup/stuck-operation","complete","2025-12-14 09:02:58","2025-12-14 09:02:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765702978;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765702978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 09:39:52","2025-12-14 09:39:52","0",NULL),
("32888","image-optimization/cleanup/stuck-operation","complete","2025-12-14 09:44:52","2025-12-14 09:44:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765705492;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765705492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 10:54:50","2025-12-14 10:54:50","0",NULL),
("32889","image-optimization/cleanup/stuck-operation","complete","2025-12-14 10:59:50","2025-12-14 10:59:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765709990;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765709990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 12:56:42","2025-12-14 12:56:42","0",NULL),
("32890","image-optimization/cleanup/stuck-operation","complete","2025-12-14 13:01:42","2025-12-14 13:01:42","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765717302;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765717302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 13:37:38","2025-12-14 13:37:38","0",NULL),
("32891","image-optimization/cleanup/stuck-operation","complete","2025-12-14 13:42:38","2025-12-14 13:42:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765719758;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765719758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 13:58:34","2025-12-14 13:58:34","0",NULL),
("32892","image-optimization/cleanup/stuck-operation","complete","2025-12-14 14:03:34","2025-12-14 14:03:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765721014;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765721014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 14:19:58","2025-12-14 14:19:58","0",NULL),
("32893","image-optimization/cleanup/stuck-operation","complete","2025-12-14 14:24:58","2025-12-14 14:24:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765722298;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765722298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 18:24:14","2025-12-14 18:24:14","0",NULL),
("32894","image-optimization/cleanup/stuck-operation","complete","2025-12-14 18:29:14","2025-12-14 18:29:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765736954;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765736954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 20:00:49","2025-12-14 20:00:49","0",NULL),
("32895","image-optimization/cleanup/stuck-operation","complete","2025-12-14 20:05:49","2025-12-14 20:05:49","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765742749;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765742749;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 20:13:40","2025-12-14 20:13:40","0",NULL),
("32896","image-optimization/cleanup/stuck-operation","complete","2025-12-14 20:18:40","2025-12-14 20:18:40","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765743520;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765743520;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 22:49:17","2025-12-14 22:49:17","0",NULL),
("32897","image-optimization/cleanup/stuck-operation","complete","2025-12-14 22:54:17","2025-12-14 22:54:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765752857;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765752857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-14 22:59:10","2025-12-14 22:59:10","0",NULL),
("32898","image-optimization/cleanup/stuck-operation","complete","2025-12-14 23:04:10","2025-12-14 23:04:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765753450;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765753450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 00:22:52","2025-12-15 00:22:52","0",NULL),
("32899","image-optimization/cleanup/stuck-operation","complete","2025-12-15 00:27:52","2025-12-15 00:27:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765758472;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765758472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 02:31:55","2025-12-15 02:31:55","0",NULL),
("32900","image-optimization/cleanup/stuck-operation","complete","2025-12-15 02:36:55","2025-12-15 02:36:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765766215;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765766215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 03:21:44","2025-12-15 03:21:44","0",NULL),
("32901","image-optimization/cleanup/stuck-operation","complete","2025-12-15 03:26:44","2025-12-15 03:26:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765769204;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765769204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 03:34:27","2025-12-15 03:34:27","0",NULL),
("32902","image-optimization/cleanup/stuck-operation","complete","2025-12-15 03:39:27","2025-12-15 03:39:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765769967;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765769967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 04:00:06","2025-12-15 04:00:06","0",NULL),
("32903","image-optimization/cleanup/stuck-operation","complete","2025-12-15 04:05:06","2025-12-15 04:05:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765771506;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765771506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 04:11:51","2025-12-15 04:11:51","0",NULL),
("32904","image-optimization/cleanup/stuck-operation","complete","2025-12-15 04:16:51","2025-12-15 04:16:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765772211;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765772211;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 04:43:51","2025-12-15 04:43:51","0",NULL),
("32905","image-optimization/cleanup/stuck-operation","complete","2025-12-15 04:48:51","2025-12-15 04:48:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765774131;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765774131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 04:54:11","2025-12-15 04:54:11","0",NULL),
("32906","image-optimization/cleanup/stuck-operation","complete","2025-12-15 04:59:11","2025-12-15 04:59:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765774751;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765774751;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 06:32:47","2025-12-15 06:32:47","0",NULL),
("32907","image-optimization/cleanup/stuck-operation","complete","2025-12-15 06:37:47","2025-12-15 06:37:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765780667;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765780667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 07:31:50","2025-12-15 07:31:50","0",NULL),
("32908","image-optimization/cleanup/stuck-operation","complete","2025-12-15 07:36:50","2025-12-15 07:36:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765784210;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765784210;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 08:19:31","2025-12-15 08:19:31","0",NULL),
("32909","image-optimization/cleanup/stuck-operation","complete","2025-12-15 08:24:31","2025-12-15 08:24:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765787071;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765787071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 09:22:43","2025-12-15 09:22:43","0",NULL),
("32910","image-optimization/cleanup/stuck-operation","complete","2025-12-15 09:27:43","2025-12-15 09:27:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765790863;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765790863;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 09:57:01","2025-12-15 09:57:01","0",NULL),
("32911","image-optimization/cleanup/stuck-operation","complete","2025-12-15 10:02:01","2025-12-15 10:02:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765792921;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765792921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 10:04:05","2025-12-15 10:04:05","0",NULL),
("32912","image-optimization/cleanup/stuck-operation","complete","2025-12-15 10:09:05","2025-12-15 10:09:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765793345;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765793345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 10:13:22","2025-12-15 10:13:22","0",NULL),
("32913","image-optimization/cleanup/stuck-operation","complete","2025-12-15 10:18:22","2025-12-15 10:18:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765793902;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765793902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 10:31:09","2025-12-15 10:31:09","0",NULL),
("32914","image-optimization/cleanup/stuck-operation","complete","2025-12-15 10:36:09","2025-12-15 10:36:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765794969;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765794969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 10:40:57","2025-12-15 10:40:57","0",NULL),
("32915","image-optimization/cleanup/stuck-operation","complete","2025-12-15 10:45:57","2025-12-15 10:45:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765795557;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765795557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 11:01:13","2025-12-15 11:01:13","0",NULL),
("32916","image-optimization/cleanup/stuck-operation","complete","2025-12-15 11:06:13","2025-12-15 11:06:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765796773;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765796773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 11:25:18","2025-12-15 11:25:18","0",NULL),
("32917","image-optimization/cleanup/stuck-operation","complete","2025-12-15 11:30:18","2025-12-15 11:30:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765798218;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765798218;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 12:12:06","2025-12-15 12:12:06","0",NULL),
("32918","image-optimization/cleanup/stuck-operation","complete","2025-12-15 12:17:06","2025-12-15 12:17:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765801026;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765801026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 12:42:55","2025-12-15 12:42:55","0",NULL),
("32919","image-optimization/cleanup/stuck-operation","complete","2025-12-15 12:47:55","2025-12-15 12:47:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765802875;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765802875;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 13:29:41","2025-12-15 13:29:41","0",NULL),
("32920","image-optimization/cleanup/stuck-operation","complete","2025-12-15 13:34:41","2025-12-15 13:34:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765805681;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765805681;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 13:53:36","2025-12-15 13:53:36","0",NULL),
("32921","image-optimization/cleanup/stuck-operation","complete","2025-12-15 13:58:36","2025-12-15 13:58:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765807116;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765807116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 14:10:28","2025-12-15 14:10:28","0",NULL),
("32922","image-optimization/cleanup/stuck-operation","complete","2025-12-15 14:15:28","2025-12-15 14:15:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765808128;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765808128;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 15:27:53","2025-12-15 15:27:53","0",NULL),
("32923","image-optimization/cleanup/stuck-operation","complete","2025-12-15 15:32:53","2025-12-15 15:32:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765812773;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765812773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 15:36:53","2025-12-15 15:36:53","0",NULL),
("32924","image-optimization/cleanup/stuck-operation","complete","2025-12-15 15:41:53","2025-12-15 15:41:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765813313;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765813313;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 17:37:19","2025-12-15 17:37:19","0",NULL),
("32925","image-optimization/cleanup/stuck-operation","complete","2025-12-15 17:42:19","2025-12-15 17:42:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765820539;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765820539;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 18:59:54","2025-12-15 18:59:54","0",NULL),
("32926","image-optimization/cleanup/stuck-operation","complete","2025-12-15 19:04:54","2025-12-15 19:04:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765825494;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765825494;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 19:50:25","2025-12-15 19:50:25","0",NULL),
("32927","image-optimization/cleanup/stuck-operation","complete","2025-12-15 19:55:25","2025-12-15 19:55:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765828525;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765828525;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-15 21:08:17","2025-12-15 21:08:17","0",NULL),
("32928","image-optimization/cleanup/stuck-operation","complete","2025-12-15 21:13:17","2025-12-15 21:13:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765833197;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765833197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 01:08:04","2025-12-16 01:08:04","0",NULL),
("32929","image-optimization/cleanup/stuck-operation","complete","2025-12-16 01:13:04","2025-12-16 01:13:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765847584;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765847584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 02:12:46","2025-12-16 02:12:46","0",NULL),
("32930","image-optimization/cleanup/stuck-operation","complete","2025-12-16 02:17:46","2025-12-16 02:17:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765851466;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765851466;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 02:21:48","2025-12-16 02:21:48","0",NULL),
("32931","image-optimization/cleanup/stuck-operation","complete","2025-12-16 02:26:48","2025-12-16 02:26:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765852008;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765852008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 03:56:30","2025-12-16 03:56:30","0",NULL),
("32932","image-optimization/cleanup/stuck-operation","complete","2025-12-16 04:01:30","2025-12-16 04:01:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765857690;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765857690;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 04:53:20","2025-12-16 04:53:20","0",NULL),
("32933","image-optimization/cleanup/stuck-operation","complete","2025-12-16 04:58:20","2025-12-16 04:58:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765861100;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765861100;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 05:20:55","2025-12-16 05:20:55","0",NULL),
("32934","image-optimization/cleanup/stuck-operation","complete","2025-12-16 05:25:55","2025-12-16 05:25:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765862755;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765862755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 07:41:18","2025-12-16 07:41:18","0",NULL),
("32935","image-optimization/cleanup/stuck-operation","complete","2025-12-16 07:46:18","2025-12-16 07:46:18","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765871178;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765871178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 08:18:15","2025-12-16 08:18:15","0",NULL),
("32936","image-optimization/cleanup/stuck-operation","complete","2025-12-16 08:23:15","2025-12-16 08:23:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765873395;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765873395;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 08:26:48","2025-12-16 08:26:48","0",NULL),
("32937","image-optimization/cleanup/stuck-operation","complete","2025-12-16 08:31:48","2025-12-16 08:31:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765873908;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765873908;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 08:33:05","2025-12-16 08:33:05","0",NULL),
("32938","image-optimization/cleanup/stuck-operation","complete","2025-12-16 08:38:05","2025-12-16 08:38:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765874285;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765874285;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 09:06:15","2025-12-16 09:06:15","0",NULL),
("32939","image-optimization/cleanup/stuck-operation","complete","2025-12-16 09:11:15","2025-12-16 09:11:15","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765876275;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765876275;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 09:31:46","2025-12-16 09:31:46","0",NULL),
("32940","image-optimization/cleanup/stuck-operation","complete","2025-12-16 09:36:46","2025-12-16 09:36:46","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765877806;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765877806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 10:22:53","2025-12-16 10:22:53","0",NULL),
("32941","image-optimization/cleanup/stuck-operation","complete","2025-12-16 10:27:53","2025-12-16 10:27:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765880873;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765880873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 10:42:14","2025-12-16 10:42:14","0",NULL),
("32942","image-optimization/cleanup/stuck-operation","complete","2025-12-16 10:47:14","2025-12-16 10:47:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765882034;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765882034;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 11:41:03","2025-12-16 11:41:03","0",NULL),
("32943","image-optimization/cleanup/stuck-operation","complete","2025-12-16 11:46:03","2025-12-16 11:46:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765885563;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765885563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 12:35:28","2025-12-16 12:35:28","0",NULL),
("32944","image-optimization/cleanup/stuck-operation","complete","2025-12-16 12:40:28","2025-12-16 12:40:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765888828;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765888828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 12:41:44","2025-12-16 12:41:44","0",NULL),
("32945","image-optimization/cleanup/stuck-operation","complete","2025-12-16 12:46:44","2025-12-16 12:46:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765889204;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765889204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 14:05:34","2025-12-16 14:05:34","0",NULL),
("32946","image-optimization/cleanup/stuck-operation","complete","2025-12-16 14:10:34","2025-12-16 14:10:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765894234;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765894234;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 14:17:44","2025-12-16 14:17:44","0",NULL),
("32947","image-optimization/cleanup/stuck-operation","complete","2025-12-16 14:22:44","2025-12-16 14:22:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765894964;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765894964;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 14:53:04","2025-12-16 14:53:04","0",NULL),
("32948","image-optimization/cleanup/stuck-operation","complete","2025-12-16 14:58:04","2025-12-16 14:58:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765897084;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765897084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 15:01:17","2025-12-16 15:01:17","0",NULL),
("32949","image-optimization/cleanup/stuck-operation","complete","2025-12-16 15:06:17","2025-12-16 15:06:17","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765897577;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765897577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 15:38:06","2025-12-16 15:38:06","0",NULL),
("32950","image-optimization/cleanup/stuck-operation","complete","2025-12-16 15:43:06","2025-12-16 15:43:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765899786;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765899786;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 15:46:52","2025-12-16 15:46:52","0",NULL),
("32951","image-optimization/cleanup/stuck-operation","complete","2025-12-16 15:51:52","2025-12-16 15:51:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765900312;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765900312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 15:59:14","2025-12-16 15:59:14","0",NULL),
("32952","image-optimization/cleanup/stuck-operation","complete","2025-12-16 16:04:14","2025-12-16 16:04:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765901054;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765901054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 16:33:04","2025-12-16 16:33:04","0",NULL),
("32953","image-optimization/cleanup/stuck-operation","complete","2025-12-16 16:38:04","2025-12-16 16:38:04","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765903084;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765903084;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 16:45:52","2025-12-16 16:45:52","0",NULL),
("32954","image-optimization/cleanup/stuck-operation","complete","2025-12-16 16:50:52","2025-12-16 16:50:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765903852;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765903852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 16:56:58","2025-12-16 16:56:58","0",NULL),
("32955","image-optimization/cleanup/stuck-operation","complete","2025-12-16 17:01:58","2025-12-16 17:01:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765904518;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765904518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 17:18:58","2025-12-16 17:18:58","0",NULL),
("32956","image-optimization/cleanup/stuck-operation","complete","2025-12-16 17:23:58","2025-12-16 17:23:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765905838;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765905838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 17:36:39","2025-12-16 17:36:39","0",NULL),
("32957","image-optimization/cleanup/stuck-operation","complete","2025-12-16 17:41:39","2025-12-16 17:41:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765906899;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765906899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 18:27:43","2025-12-16 18:27:43","0",NULL),
("32958","image-optimization/cleanup/stuck-operation","complete","2025-12-16 18:32:43","2025-12-16 18:32:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765909963;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765909963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 18:49:00","2025-12-16 18:49:00","0",NULL),
("32959","image-optimization/cleanup/stuck-operation","complete","2025-12-16 18:54:00","2025-12-16 18:54:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765911240;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765911240;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 20:08:20","2025-12-16 20:08:20","0",NULL),
("32960","image-optimization/cleanup/stuck-operation","complete","2025-12-16 20:13:20","2025-12-16 20:13:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765916000;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765916000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 20:43:38","2025-12-16 20:43:38","0",NULL),
("32961","image-optimization/cleanup/stuck-operation","complete","2025-12-16 20:48:38","2025-12-16 20:48:38","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765918118;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765918118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 21:25:45","2025-12-16 21:25:45","0",NULL),
("32962","image-optimization/cleanup/stuck-operation","complete","2025-12-16 21:30:45","2025-12-16 21:30:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765920645;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765920645;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-16 22:26:01","2025-12-16 22:26:01","0",NULL),
("32963","image-optimization/cleanup/stuck-operation","complete","2025-12-16 22:31:01","2025-12-16 22:31:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765924261;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765924261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 00:02:52","2025-12-17 00:02:52","0",NULL),
("32964","image-optimization/cleanup/stuck-operation","complete","2025-12-17 00:07:52","2025-12-17 00:07:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765930072;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765930072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 00:58:32","2025-12-17 00:58:32","0",NULL),
("32965","image-optimization/cleanup/stuck-operation","complete","2025-12-17 01:03:32","2025-12-17 01:03:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765933412;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765933412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 01:22:58","2025-12-17 01:22:58","0",NULL),
("32966","image-optimization/cleanup/stuck-operation","complete","2025-12-17 01:27:58","2025-12-17 01:27:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765934878;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765934878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 01:40:16","2025-12-17 01:40:16","0",NULL),
("32967","image-optimization/cleanup/stuck-operation","complete","2025-12-17 01:45:16","2025-12-17 01:45:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765935916;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765935916;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 01:46:08","2025-12-17 01:46:08","0",NULL),
("32968","image-optimization/cleanup/stuck-operation","complete","2025-12-17 01:51:08","2025-12-17 01:51:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765936268;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765936268;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 02:18:53","2025-12-17 02:18:53","0",NULL),
("32969","image-optimization/cleanup/stuck-operation","complete","2025-12-17 02:23:53","2025-12-17 02:23:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765938233;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765938233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 02:39:01","2025-12-17 02:39:01","0",NULL),
("32970","image-optimization/cleanup/stuck-operation","complete","2025-12-17 02:44:01","2025-12-17 02:44:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765939441;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765939441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 03:06:39","2025-12-17 03:06:39","0",NULL),
("32971","image-optimization/cleanup/stuck-operation","complete","2025-12-17 03:11:39","2025-12-17 03:11:39","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765941099;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765941099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 03:31:52","2025-12-17 03:31:52","0",NULL),
("32972","image-optimization/cleanup/stuck-operation","complete","2025-12-17 03:36:52","2025-12-17 03:36:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765942612;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765942612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 04:13:27","2025-12-17 04:13:27","0",NULL),
("32973","image-optimization/cleanup/stuck-operation","complete","2025-12-17 04:18:27","2025-12-17 04:18:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765945107;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765945107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 05:55:45","2025-12-17 05:55:45","0",NULL),
("32974","image-optimization/cleanup/stuck-operation","complete","2025-12-17 06:00:45","2025-12-17 06:00:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765951245;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765951245;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 06:14:53","2025-12-17 06:14:53","0",NULL),
("32975","image-optimization/cleanup/stuck-operation","complete","2025-12-17 06:19:53","2025-12-17 06:19:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765952393;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765952393;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 08:54:03","2025-12-17 08:54:03","0",NULL),
("32976","image-optimization/cleanup/stuck-operation","complete","2025-12-17 08:59:03","2025-12-17 08:59:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765961943;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765961943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 09:22:16","2025-12-17 09:22:16","0",NULL),
("32977","image-optimization/cleanup/stuck-operation","complete","2025-12-17 09:27:16","2025-12-17 09:27:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765963636;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765963636;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 09:45:30","2025-12-17 09:45:30","0",NULL),
("32978","image-optimization/cleanup/stuck-operation","complete","2025-12-17 09:50:30","2025-12-17 09:50:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765965030;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765965030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 10:35:16","2025-12-17 10:35:16","0",NULL),
("32979","image-optimization/cleanup/stuck-operation","complete","2025-12-17 10:40:16","2025-12-17 10:40:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765968016;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765968016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 10:53:01","2025-12-17 10:53:01","0",NULL),
("32980","image-optimization/cleanup/stuck-operation","complete","2025-12-17 10:58:01","2025-12-17 10:58:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765969081;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765969081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 11:29:33","2025-12-17 11:29:33","0",NULL),
("32981","image-optimization/cleanup/stuck-operation","complete","2025-12-17 11:34:33","2025-12-17 11:34:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765971273;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765971273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 12:29:09","2025-12-17 12:29:09","0",NULL),
("32982","image-optimization/cleanup/stuck-operation","complete","2025-12-17 12:34:09","2025-12-17 12:34:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765974849;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765974849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 12:56:05","2025-12-17 12:56:05","0",NULL),
("32983","image-optimization/cleanup/stuck-operation","complete","2025-12-17 13:01:05","2025-12-17 13:01:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765976465;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765976465;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 13:42:47","2025-12-17 13:42:47","0",NULL),
("32984","image-optimization/cleanup/stuck-operation","complete","2025-12-17 13:47:47","2025-12-17 13:47:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765979267;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765979267;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 14:02:16","2025-12-17 14:02:16","0",NULL),
("32985","image-optimization/cleanup/stuck-operation","complete","2025-12-17 14:07:16","2025-12-17 14:07:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765980436;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765980436;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 14:14:22","2025-12-17 14:14:22","0",NULL),
("32986","image-optimization/cleanup/stuck-operation","complete","2025-12-17 14:19:22","2025-12-17 14:19:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765981162;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765981162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 14:35:34","2025-12-17 14:35:34","0",NULL);

INSERT IGNORE INTO `wplp_actionscheduler_actions` VALUES 
("32987","image-optimization/cleanup/stuck-operation","complete","2025-12-17 14:40:34","2025-12-17 14:40:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765982434;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765982434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 14:59:05","2025-12-17 14:59:05","0",NULL),
("32988","image-optimization/cleanup/stuck-operation","complete","2025-12-17 15:04:05","2025-12-17 15:04:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765983845;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765983845;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 15:39:06","2025-12-17 15:39:06","0",NULL),
("32989","image-optimization/cleanup/stuck-operation","complete","2025-12-17 15:44:06","2025-12-17 15:44:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765986246;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765986246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 16:40:21","2025-12-17 16:40:21","0",NULL),
("32990","image-optimization/cleanup/stuck-operation","complete","2025-12-17 16:45:21","2025-12-17 16:45:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765989921;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765989921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 17:39:59","2025-12-17 17:39:59","0",NULL),
("32991","image-optimization/cleanup/stuck-operation","complete","2025-12-17 17:44:59","2025-12-17 17:44:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765993499;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765993499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 18:27:43","2025-12-17 18:27:43","0",NULL),
("32992","image-optimization/cleanup/stuck-operation","complete","2025-12-17 18:32:43","2025-12-17 18:32:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765996363;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765996363;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 18:55:05","2025-12-17 18:55:05","0",NULL),
("32993","image-optimization/cleanup/stuck-operation","complete","2025-12-17 19:00:05","2025-12-17 19:00:05","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765998005;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765998005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 20:47:03","2025-12-17 20:47:03","0",NULL),
("32994","image-optimization/cleanup/stuck-operation","complete","2025-12-17 20:52:03","2025-12-17 20:52:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766004723;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766004723;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 21:08:48","2025-12-17 21:08:48","0",NULL),
("32995","image-optimization/cleanup/stuck-operation","complete","2025-12-17 21:13:48","2025-12-17 21:13:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766006028;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766006028;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 22:36:30","2025-12-17 22:36:30","0",NULL),
("32996","image-optimization/cleanup/stuck-operation","complete","2025-12-17 22:41:30","2025-12-17 22:41:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766011290;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766011290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 23:28:47","2025-12-17 23:28:47","0",NULL),
("32997","image-optimization/cleanup/stuck-operation","complete","2025-12-17 23:33:48","2025-12-17 23:33:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766014428;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766014428;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-17 23:56:13","2025-12-17 23:56:13","0",NULL),
("32998","image-optimization/cleanup/stuck-operation","complete","2025-12-18 00:01:13","2025-12-18 00:01:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766016073;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766016073;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 01:07:27","2025-12-18 01:07:27","0",NULL),
("32999","image-optimization/cleanup/stuck-operation","complete","2025-12-18 01:12:27","2025-12-18 01:12:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766020347;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766020347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 01:50:50","2025-12-18 01:50:50","0",NULL),
("33000","image-optimization/cleanup/stuck-operation","complete","2025-12-18 01:55:50","2025-12-18 01:55:50","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766022950;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766022950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 02:01:44","2025-12-18 02:01:44","0",NULL),
("33001","image-optimization/cleanup/stuck-operation","complete","2025-12-18 02:06:44","2025-12-18 02:06:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766023604;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766023604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 03:10:28","2025-12-18 03:10:28","0",NULL),
("33002","image-optimization/cleanup/stuck-operation","complete","2025-12-18 03:15:28","2025-12-18 03:15:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766027728;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766027728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 03:53:41","2025-12-18 03:53:41","0",NULL),
("33003","image-optimization/cleanup/stuck-operation","complete","2025-12-18 03:58:41","2025-12-18 03:58:41","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766030321;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766030321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 04:08:32","2025-12-18 04:08:32","0",NULL),
("33004","image-optimization/cleanup/stuck-operation","complete","2025-12-18 04:13:32","2025-12-18 04:13:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766031212;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766031212;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 04:14:31","2025-12-18 04:14:31","0",NULL),
("33005","image-optimization/cleanup/stuck-operation","complete","2025-12-18 04:19:31","2025-12-18 04:19:31","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766031571;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766031571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 04:21:59","2025-12-18 04:21:59","0",NULL),
("33006","image-optimization/cleanup/stuck-operation","complete","2025-12-18 04:26:59","2025-12-18 04:26:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766032019;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766032019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 04:55:22","2025-12-18 04:55:22","0",NULL),
("33007","image-optimization/cleanup/stuck-operation","complete","2025-12-18 05:00:22","2025-12-18 05:00:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766034022;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766034022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 05:17:11","2025-12-18 05:17:11","0",NULL),
("33008","image-optimization/cleanup/stuck-operation","complete","2025-12-18 05:22:11","2025-12-18 05:22:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766035331;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766035331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 05:32:54","2025-12-18 05:32:54","0",NULL),
("33009","image-optimization/cleanup/stuck-operation","complete","2025-12-18 05:37:54","2025-12-18 05:37:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766036274;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766036274;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 06:05:14","2025-12-18 06:05:14","0",NULL),
("33010","image-optimization/cleanup/stuck-operation","complete","2025-12-18 06:10:14","2025-12-18 06:10:14","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766038214;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766038214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 06:18:55","2025-12-18 06:18:55","0",NULL),
("33011","image-optimization/cleanup/stuck-operation","complete","2025-12-18 06:23:55","2025-12-18 06:23:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766039035;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766039035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 06:34:10","2025-12-18 06:34:10","0",NULL),
("33012","image-optimization/cleanup/stuck-operation","complete","2025-12-18 06:39:10","2025-12-18 06:39:10","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766039950;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766039950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 06:46:56","2025-12-18 06:46:56","0",NULL),
("33013","image-optimization/cleanup/stuck-operation","complete","2025-12-18 06:51:57","2025-12-18 06:51:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766040717;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766040717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 07:07:09","2025-12-18 07:07:09","0",NULL),
("33014","image-optimization/cleanup/stuck-operation","complete","2025-12-18 07:12:09","2025-12-18 07:12:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766041929;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766041929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 07:22:11","2025-12-18 07:22:11","0",NULL),
("33015","image-optimization/cleanup/stuck-operation","complete","2025-12-18 07:27:11","2025-12-18 07:27:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766042831;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766042831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 08:06:44","2025-12-18 08:06:44","0",NULL),
("33016","image-optimization/cleanup/stuck-operation","complete","2025-12-18 08:11:44","2025-12-18 08:11:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766045504;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766045504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 08:49:53","2025-12-18 08:49:53","0",NULL),
("33017","image-optimization/cleanup/stuck-operation","complete","2025-12-18 08:54:53","2025-12-18 08:54:53","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766048093;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766048093;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 09:49:03","2025-12-18 09:49:03","0",NULL),
("33018","image-optimization/cleanup/stuck-operation","complete","2025-12-18 09:54:03","2025-12-18 09:54:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766051643;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766051643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 10:36:16","2025-12-18 10:36:16","0",NULL),
("33019","image-optimization/cleanup/stuck-operation","complete","2025-12-18 10:41:16","2025-12-18 10:41:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766054476;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766054476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 11:15:00","2025-12-18 11:15:00","0",NULL),
("33020","image-optimization/cleanup/stuck-operation","complete","2025-12-18 11:20:00","2025-12-18 11:20:00","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766056800;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766056800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 11:25:32","2025-12-18 11:25:32","0",NULL),
("33021","image-optimization/cleanup/stuck-operation","complete","2025-12-18 11:30:32","2025-12-18 11:30:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766057432;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766057432;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 12:17:43","2025-12-18 12:17:43","0",NULL),
("33022","image-optimization/cleanup/stuck-operation","complete","2025-12-18 12:22:43","2025-12-18 12:22:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766060563;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766060563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 13:12:02","2025-12-18 13:12:02","0",NULL),
("33023","image-optimization/cleanup/stuck-operation","complete","2025-12-18 13:17:02","2025-12-18 13:17:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766063822;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766063822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 13:40:27","2025-12-18 13:40:27","0",NULL),
("33024","image-optimization/cleanup/stuck-operation","complete","2025-12-18 13:45:27","2025-12-18 13:45:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766065527;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766065527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 13:48:13","2025-12-18 13:48:13","0",NULL),
("33025","image-optimization/cleanup/stuck-operation","complete","2025-12-18 13:53:13","2025-12-18 13:53:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766065993;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766065993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 14:10:25","2025-12-18 14:10:25","0",NULL),
("33026","image-optimization/cleanup/stuck-operation","complete","2025-12-18 14:15:25","2025-12-18 14:15:25","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766067325;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766067325;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 14:22:32","2025-12-18 14:22:32","0",NULL),
("33027","image-optimization/cleanup/stuck-operation","complete","2025-12-18 14:27:32","2025-12-18 14:27:32","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766068052;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766068052;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 14:35:16","2025-12-18 14:35:16","0",NULL),
("33028","image-optimization/cleanup/stuck-operation","complete","2025-12-18 14:40:16","2025-12-18 14:40:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766068816;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766068816;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 15:39:09","2025-12-18 15:39:09","0",NULL),
("33029","image-optimization/cleanup/stuck-operation","complete","2025-12-18 15:44:09","2025-12-18 15:44:09","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766072649;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766072649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 16:28:21","2025-12-18 16:28:21","0",NULL),
("33030","image-optimization/cleanup/stuck-operation","complete","2025-12-18 16:33:21","2025-12-18 16:33:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766075601;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766075601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 17:02:23","2025-12-18 17:02:23","0",NULL),
("33031","image-optimization/cleanup/stuck-operation","complete","2025-12-18 17:07:23","2025-12-18 17:07:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766077643;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766077643;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 17:16:55","2025-12-18 17:16:55","0",NULL),
("33032","image-optimization/cleanup/stuck-operation","complete","2025-12-18 17:21:55","2025-12-18 17:21:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766078515;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766078515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 17:25:44","2025-12-18 17:25:44","0",NULL),
("33033","image-optimization/cleanup/stuck-operation","complete","2025-12-18 17:30:44","2025-12-18 17:30:44","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766079044;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766079044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 17:54:24","2025-12-18 17:54:24","0",NULL),
("33034","image-optimization/cleanup/stuck-operation","complete","2025-12-18 17:59:24","2025-12-18 17:59:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766080764;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766080764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 18:31:56","2025-12-18 18:31:56","0",NULL),
("33035","image-optimization/cleanup/stuck-operation","complete","2025-12-18 18:36:56","2025-12-18 18:36:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766083016;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766083016;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 19:15:33","2025-12-18 19:15:33","0",NULL),
("33036","image-optimization/cleanup/stuck-operation","complete","2025-12-18 19:20:33","2025-12-18 19:20:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766085633;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766085633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 21:45:58","2025-12-18 21:45:58","0",NULL),
("33037","image-optimization/cleanup/stuck-operation","complete","2025-12-18 21:50:58","2025-12-18 21:50:58","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766094658;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766094658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 23:15:51","2025-12-18 23:15:51","0",NULL),
("33038","image-optimization/cleanup/stuck-operation","complete","2025-12-18 23:20:51","2025-12-18 23:20:51","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766100051;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766100051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 23:23:57","2025-12-18 23:23:57","0",NULL),
("33039","image-optimization/cleanup/stuck-operation","complete","2025-12-18 23:28:57","2025-12-18 23:28:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766100537;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766100537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-18 23:44:43","2025-12-18 23:44:43","0",NULL),
("33040","image-optimization/cleanup/stuck-operation","complete","2025-12-18 23:49:43","2025-12-18 23:49:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766101783;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766101783;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 01:27:16","2025-12-19 01:27:16","0",NULL),
("33041","image-optimization/cleanup/stuck-operation","complete","2025-12-19 01:32:16","2025-12-19 01:32:16","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766107936;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766107936;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 02:55:35","2025-12-19 02:55:35","0",NULL),
("33042","image-optimization/cleanup/stuck-operation","complete","2025-12-19 03:00:55","2025-12-19 03:00:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766113255;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766113255;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 03:16:20","2025-12-19 03:16:20","0",NULL),
("33043","image-optimization/cleanup/stuck-operation","complete","2025-12-19 03:21:20","2025-12-19 03:21:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766114480;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766114480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 04:24:56","2025-12-19 04:24:56","0",NULL),
("33044","image-optimization/cleanup/stuck-operation","complete","2025-12-19 04:29:56","2025-12-19 04:29:56","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766118596;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766118596;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 05:24:45","2025-12-19 05:24:45","0",NULL),
("33045","image-optimization/cleanup/stuck-operation","complete","2025-12-19 05:29:45","2025-12-19 05:29:45","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766122185;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766122185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 05:49:28","2025-12-19 05:49:28","0",NULL),
("33046","image-optimization/cleanup/stuck-operation","complete","2025-12-19 05:54:28","2025-12-19 05:54:28","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766123668;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766123668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 06:25:22","2025-12-19 06:25:22","0",NULL),
("33047","image-optimization/cleanup/stuck-operation","complete","2025-12-19 06:30:22","2025-12-19 06:30:22","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766125822;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766125822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 06:39:36","2025-12-19 06:39:36","0",NULL),
("33048","image-optimization/cleanup/stuck-operation","complete","2025-12-19 06:44:36","2025-12-19 06:44:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766126676;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766126676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 07:11:54","2025-12-19 07:11:54","0",NULL),
("33049","image-optimization/cleanup/stuck-operation","complete","2025-12-19 07:16:54","2025-12-19 07:16:54","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766128614;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766128614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 08:16:07","2025-12-19 08:16:07","0",NULL),
("33050","image-optimization/cleanup/stuck-operation","complete","2025-12-19 08:21:07","2025-12-19 08:21:07","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766132467;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766132467;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 08:29:24","2025-12-19 08:29:24","0",NULL),
("33051","image-optimization/cleanup/stuck-operation","complete","2025-12-19 08:34:24","2025-12-19 08:34:24","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766133264;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766133264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 08:41:48","2025-12-19 08:41:48","0",NULL),
("33052","image-optimization/cleanup/stuck-operation","complete","2025-12-19 08:46:48","2025-12-19 08:46:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766134008;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766134008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 09:07:36","2025-12-19 09:07:36","0",NULL),
("33053","image-optimization/cleanup/stuck-operation","complete","2025-12-19 09:12:36","2025-12-19 09:12:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766135556;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766135556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 11:40:02","2025-12-19 11:40:02","0",NULL),
("33054","image-optimization/cleanup/stuck-operation","complete","2025-12-19 11:45:02","2025-12-19 11:45:02","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766144702;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766144702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 12:35:11","2025-12-19 12:35:11","0",NULL),
("33055","image-optimization/cleanup/stuck-operation","complete","2025-12-19 12:40:11","2025-12-19 12:40:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766148011;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766148011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 13:00:01","2025-12-19 13:00:01","0",NULL),
("33056","image-optimization/cleanup/stuck-operation","complete","2025-12-19 13:05:01","2025-12-19 13:05:01","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766149501;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766149501;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 13:15:59","2025-12-19 13:15:59","0",NULL),
("33057","image-optimization/cleanup/stuck-operation","complete","2025-12-19 13:20:59","2025-12-19 13:20:59","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766150459;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766150459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 13:48:08","2025-12-19 13:48:08","0",NULL),
("33058","image-optimization/cleanup/stuck-operation","complete","2025-12-19 13:53:08","2025-12-19 13:53:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766152388;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766152388;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 15:19:36","2025-12-19 15:19:36","0",NULL),
("33059","image-optimization/cleanup/stuck-operation","complete","2025-12-19 15:24:36","2025-12-19 15:24:36","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766157876;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766157876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 15:30:11","2025-12-19 15:30:11","0",NULL),
("33060","image-optimization/cleanup/stuck-operation","complete","2025-12-19 15:35:11","2025-12-19 15:35:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766158511;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766158511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 18:41:33","2025-12-19 18:41:33","0",NULL),
("33061","image-optimization/cleanup/stuck-operation","complete","2025-12-19 18:46:33","2025-12-19 18:46:33","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766169993;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766169993;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 19:39:55","2025-12-19 19:39:55","0",NULL),
("33062","image-optimization/cleanup/stuck-operation","complete","2025-12-19 19:44:55","2025-12-19 19:44:55","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766173495;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766173495;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 20:31:52","2025-12-19 20:31:52","0",NULL),
("33063","image-optimization/cleanup/stuck-operation","complete","2025-12-19 20:36:52","2025-12-19 20:36:52","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766176612;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766176612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 20:37:34","2025-12-19 20:37:34","0",NULL),
("33064","image-optimization/cleanup/stuck-operation","complete","2025-12-19 20:42:34","2025-12-19 20:42:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766176954;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766176954;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 21:58:20","2025-12-19 21:58:20","0",NULL),
("33065","image-optimization/cleanup/stuck-operation","complete","2025-12-19 22:03:20","2025-12-19 22:03:20","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766181800;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766181800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 22:14:03","2025-12-19 22:14:03","0",NULL),
("33066","image-optimization/cleanup/stuck-operation","complete","2025-12-19 22:19:03","2025-12-19 22:19:03","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766182743;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766182743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 22:26:27","2025-12-19 22:26:27","0",NULL),
("33067","image-optimization/cleanup/stuck-operation","complete","2025-12-19 22:31:27","2025-12-19 22:31:27","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766183487;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766183487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 23:16:47","2025-12-19 23:16:47","0",NULL),
("33068","image-optimization/cleanup/stuck-operation","complete","2025-12-19 23:21:47","2025-12-19 23:21:47","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766186507;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766186507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-19 23:32:11","2025-12-19 23:32:11","0",NULL),
("33069","image-optimization/cleanup/stuck-operation","complete","2025-12-19 23:37:11","2025-12-19 23:37:11","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766187431;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766187431;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 00:26:43","2025-12-20 00:26:43","0",NULL),
("33070","image-optimization/cleanup/stuck-operation","complete","2025-12-20 00:31:43","2025-12-20 00:31:43","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766190703;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766190703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 00:41:57","2025-12-20 00:41:57","0",NULL),
("33071","image-optimization/cleanup/stuck-operation","complete","2025-12-20 00:46:57","2025-12-20 00:46:57","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766191617;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766191617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 01:03:21","2025-12-20 01:03:21","0",NULL),
("33072","image-optimization/cleanup/stuck-operation","complete","2025-12-20 01:08:21","2025-12-20 01:08:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766192901;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766192901;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 01:27:08","2025-12-20 01:27:08","0",NULL),
("33073","image-optimization/cleanup/stuck-operation","complete","2025-12-20 01:32:08","2025-12-20 01:32:08","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766194328;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766194328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 03:01:23","2025-12-20 03:01:23","0",NULL),
("33074","image-optimization/cleanup/stuck-operation","complete","2025-12-20 03:06:23","2025-12-20 03:06:23","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766199983;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766199983;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 03:36:21","2025-12-20 03:36:21","0",NULL),
("33075","image-optimization/cleanup/stuck-operation","complete","2025-12-20 03:41:21","2025-12-20 03:41:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766202081;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766202081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 04:54:19","2025-12-20 04:54:19","0",NULL),
("33076","image-optimization/cleanup/stuck-operation","complete","2025-12-20 04:59:19","2025-12-20 04:59:19","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766206759;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766206759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 04:59:30","2025-12-20 04:59:30","0",NULL),
("33077","image-optimization/cleanup/stuck-operation","complete","2025-12-20 05:04:30","2025-12-20 05:04:30","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766207070;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766207070;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 05:49:13","2025-12-20 05:49:13","0",NULL),
("33078","image-optimization/cleanup/stuck-operation","complete","2025-12-20 05:54:13","2025-12-20 05:54:13","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766210053;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766210053;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 06:24:29","2025-12-20 06:24:29","0",NULL),
("33079","image-optimization/cleanup/stuck-operation","complete","2025-12-20 06:29:29","2025-12-20 06:29:29","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766212169;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766212169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 07:29:48","2025-12-20 07:29:48","0",NULL),
("33080","image-optimization/cleanup/stuck-operation","complete","2025-12-20 07:34:48","2025-12-20 07:34:48","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766216088;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766216088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 07:54:06","2025-12-20 07:54:06","0",NULL),
("33081","image-optimization/cleanup/stuck-operation","complete","2025-12-20 07:59:06","2025-12-20 07:59:06","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766217546;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766217546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 08:25:34","2025-12-20 08:25:34","0",NULL),
("33082","image-optimization/cleanup/stuck-operation","complete","2025-12-20 08:30:34","2025-12-20 08:30:34","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766219434;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766219434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 08:39:21","2025-12-20 08:39:21","0",NULL),
("33083","image-optimization/cleanup/stuck-operation","complete","2025-12-20 08:44:21","2025-12-20 08:44:21","10","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766220261;s:18:\"\0*\0first_timestamp\";i:1761187170;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766220261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}","2","1","2025-12-20 08:45:21","2025-12-20 08:45:21","0",NULL),
("33084","image-optimization/cleanup/stuck-operation","com