<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4>Reminder Display Test</h4>
                        <hr>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="panel panel-warning">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">
                                            <i class="fa fa-bell text-warning"></i> Today's Reminders
                                            <span class="badge badge-warning">2</span>
                                        </h5>
                                    </div>
                                    <div class="panel-body" id="todays-reminders-test">
                                        <!-- Test content will be loaded here -->
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="panel panel-danger">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">
                                            <i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders
                                            <span class="badge badge-danger">1</span>
                                        </h5>
                                    </div>
                                    <div class="panel-body" id="due-reminders-test">
                                        <!-- Test content will be loaded here -->
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="panel panel-info">
                                    <div class="panel-heading">
                                        <h5 class="panel-title">
                                            <i class="fa fa-calendar text-info"></i> Upcoming Reminders
                                            <span class="badge badge-info">3</span>
                                        </h5>
                                    </div>
                                    <div class="panel-body" id="upcoming-reminders-test">
                                        <!-- Test content will be loaded here -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row" style="margin-top: 20px;">
                            <div class="col-md-12">
                                <button class="btn btn-primary" onclick="loadTestReminders()">
                                    <i class="fa fa-refresh"></i> Load Test Reminders
                                </button>
                                <a href="<?= admin_url('reporting_dashboard'); ?>" class="btn btn-success">
                                    <i class="fa fa-dashboard"></i> Back to Dashboard
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
/* Enhanced reminder styling */
.reminder-item {
    border-radius: 4px;
    margin-bottom: 2px;
    transition: all 0.2s ease;
    cursor: pointer;
}

.reminder-item:hover {
    background-color: #f8f9fa !important;
    transform: translateX(2px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.reminder-item .row {
    margin: 0;
}

.reminder-item .col-md-8,
.reminder-item .col-md-4 {
    padding: 8px 12px;
}

.reminder-item .text-muted {
    font-size: 0.85em;
    margin-bottom: 2px;
}

.reminder-item .fa {
    width: 12px;
    text-align: center;
    margin-right: 4px;
}

.reminder-item strong {
    color: #2c3e50;
}
</style>

<script>
function loadTestReminders() {
    // Sample reminder data with enhanced fields
    var testData = {
        todays: [
            {
                id: '1',
                description: 'Follow up with client about project requirements',
                date: '2025-08-26',
                rel_type: 'lead',
                rel_id: '123',
                staff_name: 'John Smith',
                related_name: 'ABC Corporation Lead',
                related_email: 'contact@abc-corp.com'
            },
            {
                id: '2',
                description: 'Review and submit proposal',
                date: '2025-08-26',
                rel_type: 'proposal',
                rel_id: '456',
                staff_name: 'Sarah Johnson',
                related_name: 'Web Development Proposal',
                related_email: null
            }
        ],
        due: [
            {
                id: '3',
                description: 'Complete project milestone review',
                date: '2025-08-24',
                rel_type: 'project',
                rel_id: '789',
                staff_name: 'Mike Davis',
                related_name: 'E-commerce Website Project',
                related_email: null
            }
        ],
        upcoming: [
            {
                id: '4',
                description: 'Client meeting for requirements gathering',
                date: '2025-08-28',
                rel_type: 'customer',
                rel_id: '101',
                staff_name: 'Lisa Wilson',
                related_name: 'TechStart Inc.',
                related_email: 'info@techstart.com'
            },
            {
                id: '5',
                description: 'Invoice payment follow-up',
                date: '2025-08-30',
                rel_type: 'invoice',
                rel_id: '202',
                staff_name: 'Robert Brown',
                related_name: 'Invoice #INV-2025-0202',
                related_email: null
            },
            {
                id: '6',
                description: 'Contract renewal discussion',
                date: '2025-09-02',
                rel_type: 'contract',
                rel_id: '303',
                staff_name: 'Emma Taylor',
                related_name: 'Annual Support Contract',
                related_email: null
            }
        ]
    };
    
    // Helper function to format reminder item
    function formatReminderItem(reminder, borderColor, dateColor, dateIcon) {
        var staffInfo = reminder.staff_name ? 
            '<small class="text-muted"><i class="fa fa-user"></i> ' + reminder.staff_name + '</small><br>' : '';
        
        var relatedInfo = '';
        if (reminder.related_name && reminder.related_name !== reminder.rel_type + ' #' + reminder.rel_id) {
            relatedInfo = '<small class="text-muted"><i class="fa fa-link"></i> ' + 
                         reminder.rel_type.charAt(0).toUpperCase() + reminder.rel_type.slice(1) + 
                         ': <strong>' + reminder.related_name + '</strong></small><br>';
        }
        
        var emailInfo = reminder.related_email ? 
            '<small class="text-muted"><i class="fa fa-envelope"></i> ' + reminder.related_email + '</small>' : '';
        
        return '<div class="list-group-item reminder-item" style="border-left: 4px solid ' + borderColor + ';">' +
               '<div class="row">' +
               '<div class="col-md-8">' +
                   '<strong>' + (reminder.description || 'No description') + '</strong><br>' +
                   staffInfo +
                   relatedInfo +
                   emailInfo +
               '</div>' +
               '<div class="col-md-4 text-right">' +
                   '<small class="' + dateColor + '"><i class="fa ' + dateIcon + '"></i> ' + reminder.date + '</small><br>' +
                   '<small class="text-primary"><i class="fa fa-external-link"></i> Click to view</small>' +
               '</div>' +
               '</div></div>';
    }
    
    // Load today's reminders
    var html = '<div class="list-group">';
    testData.todays.forEach(function(reminder) {
        html += formatReminderItem(reminder, '#f39c12', 'text-warning', 'fa-clock-o');
    });
    html += '</div>';
    document.getElementById('todays-reminders-test').innerHTML = html;
    
    // Load due reminders
    html = '<div class="list-group">';
    testData.due.forEach(function(reminder) {
        html += formatReminderItem(reminder, '#e74c3c', 'text-danger', 'fa-exclamation-triangle');
    });
    html += '</div>';
    document.getElementById('due-reminders-test').innerHTML = html;
    
    // Load upcoming reminders
    html = '<div class="list-group">';
    testData.upcoming.forEach(function(reminder) {
        html += formatReminderItem(reminder, '#3498db', 'text-info', 'fa-calendar');
    });
    html += '</div>';
    document.getElementById('upcoming-reminders-test').innerHTML = html;
    
    console.log('Test reminders loaded with enhanced data:', testData);
}

// Load test data on page load
document.addEventListener('DOMContentLoaded', function() {
    loadTestReminders();
});
</script>

<?php init_tail(); ?>
