<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Test_reminders extends AdminController
{
    public function index()
    {
        if (!is_staff_logged_in()) {
            redirect(admin_url('authentication'));
        }
        
        echo "<h3>Reminders Test</h3>";
        
        // Check if reminders table exists
        $table = db_prefix() . 'reminders';
        if (!$this->db->table_exists(str_replace(db_prefix(), '', $table))) {
            echo "<p style='color: red;'>Reminders table does not exist</p>";
            return;
        }
        
        echo "<h4>Sample Reminders Query</h4>";
        
        // Test the enhanced query
        $this->db->select('
            r.id, 
            r.description, 
            r.date, 
            r.rel_type, 
            r.rel_id, 
            r.isnotified,
            r.staff,
            CONCAT(s.firstname, " ", s.lastname) as staff_name,
            CASE 
                WHEN r.rel_type = "lead" THEN l.name
                WHEN r.rel_type = "customer" THEN c.company
                WHEN r.rel_type = "project" THEN p.name
                WHEN r.rel_type = "proposal" THEN pr.subject
                WHEN r.rel_type = "estimate" THEN CONCAT("Estimate #", e.number)
                WHEN r.rel_type = "invoice" THEN CONCAT("Invoice #", i.number)
                WHEN r.rel_type = "contract" THEN co.subject
                ELSE CONCAT(r.rel_type, " #", r.rel_id)
            END as related_name,
            CASE 
                WHEN r.rel_type = "lead" THEN l.email
                WHEN r.rel_type = "customer" THEN c.email
                ELSE NULL
            END as related_email
        ');
        $this->db->from($table . ' r');
        
        // Join with staff table for staff names
        $this->db->join(db_prefix() . 'staff s', 's.staffid = r.staff', 'left');
        
        // Join with leads table
        $this->db->join(db_prefix() . 'leads l', 'l.id = r.rel_id AND r.rel_type = "lead"', 'left');
        
        // Join with customers table
        $this->db->join(db_prefix() . 'clients c', 'c.userid = r.rel_id AND r.rel_type = "customer"', 'left');
        
        // Join with projects table
        $this->db->join(db_prefix() . 'projects p', 'p.id = r.rel_id AND r.rel_type = "project"', 'left');
        
        // Join with proposals table
        $this->db->join(db_prefix() . 'proposals pr', 'pr.id = r.rel_id AND r.rel_type = "proposal"', 'left');
        
        // Join with estimates table
        $this->db->join(db_prefix() . 'estimates e', 'e.id = r.rel_id AND r.rel_type = "estimate"', 'left');
        
        // Join with invoices table
        $this->db->join(db_prefix() . 'invoices i', 'i.id = r.rel_id AND r.rel_type = "invoice"', 'left');
        
        // Join with contracts table
        $this->db->join(db_prefix() . 'contracts co', 'co.id = r.rel_id AND r.rel_type = "contract"', 'left');
        
        // Exclude reminders for leads that are marked as junk or lost
        $this->db->where('(r.rel_type != "lead" OR (l.junk = 0 AND l.lost = 0))');
        
        $this->db->limit(10);
        $this->db->order_by('r.date', 'DESC');
        
        $query = $this->db->get();
        
        if ($query->num_rows() > 0) {
            echo "<table border='1' style='width: 100%; border-collapse: collapse;'>";
            echo "<tr>";
            echo "<th>ID</th>";
            echo "<th>Description</th>";
            echo "<th>Date</th>";
            echo "<th>Staff Name</th>";
            echo "<th>Related Type</th>";
            echo "<th>Related Name</th>";
            echo "<th>Related Email</th>";
            echo "<th>Notified</th>";
            echo "</tr>";
            
            foreach ($query->result_array() as $row) {
                echo "<tr>";
                echo "<td>" . $row['id'] . "</td>";
                echo "<td>" . ($row['description'] ?: 'No description') . "</td>";
                echo "<td>" . $row['date'] . "</td>";
                echo "<td><strong>" . ($row['staff_name'] ?: 'Unknown') . "</strong></td>";
                echo "<td>" . $row['rel_type'] . "</td>";
                echo "<td><strong>" . ($row['related_name'] ?: 'N/A') . "</strong></td>";
                echo "<td>" . ($row['related_email'] ?: 'N/A') . "</td>";
                echo "<td>" . ($row['isnotified'] ? 'Yes' : 'No') . "</td>";
                echo "</tr>";
            }
            echo "</table>";
            
            echo "<h4>JSON Sample (for JavaScript):</h4>";
            echo "<pre>" . json_encode($query->result_array(), JSON_PRETTY_PRINT) . "</pre>";
        } else {
            echo "<p>No reminders found</p>";
        }
        
        // Test the model method directly
        echo "<h4>Testing Model Method:</h4>";
        
        // Load the model manually since controller models aren't working
        require_once(__DIR__ . '/../models/Reporting_dashboard_model.php');
        $model = new Reporting_dashboard_model();
        
        $filters = [];
        $reminders = $model->get_reminders($filters);
        
        echo "<h5>Today's Reminders:</h5>";
        if (!empty($reminders['todays'])) {
            echo "<ul>";
            foreach ($reminders['todays'] as $r) {
                echo "<li><strong>" . $r['description'] . "</strong> - " . 
                     ($r['staff_name'] ?: 'Unknown Staff') . " - " . 
                     ($r['related_name'] ?: 'No related entity') . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>No today's reminders</p>";
        }
        
        echo "<h5>Due Reminders:</h5>";
        if (!empty($reminders['due'])) {
            echo "<ul>";
            foreach ($reminders['due'] as $r) {
                echo "<li><strong>" . $r['description'] . "</strong> - " . 
                     ($r['staff_name'] ?: 'Unknown Staff') . " - " . 
                     ($r['related_name'] ?: 'No related entity') . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>No due reminders</p>";
        }
        
        echo "<h5>Upcoming Reminders:</h5>";
        if (!empty($reminders['upcoming'])) {
            echo "<ul>";
            foreach ($reminders['upcoming'] as $r) {
                echo "<li><strong>" . $r['description'] . "</strong> - " . 
                     ($r['staff_name'] ?: 'Unknown Staff') . " - " . 
                     ($r['related_name'] ?: 'No related entity') . "</li>";
            }
            echo "</ul>";
        } else {
            echo "<p>No upcoming reminders</p>";
        }
    }
    
    public function visual()
    {
        if (!is_staff_logged_in()) {
            redirect(admin_url('authentication'));
        }
        
        $this->load->view('reminder_test');
    }
}
?>
