# How to View Schedule Logs - User Guide

## Quick Start

Want to see if your scheduled reports are running? Follow these simple steps:

### Step 1: Open Manage Schedules
1. Go to **Reporting Dashboard**
2. Scroll to the **"Staff AI Report & WhatsApp Delivery"** section
3. Click the **"Manage Schedules"** button (top right of the section)

### Step 2: View Logs
1. In the schedules table, find your schedule
2. Click the **blue icon (📄)** button in the Actions column
3. A modal will open showing:
   - **Statistics** (how many times it ran, success rate, etc.)
   - **Detailed logs** (every execution with timestamps)

## Understanding the Logs

### Statistics Cards

When you open the logs, you'll see 4 summary cards at the top:

1. **Total Executions** (Green)
   - How many times this schedule has run

2. **Successful** (Blue)
   - Executions where report was generated AND WhatsApp messages were sent

3. **Partial** (Yellow)
   - Executions where report was generated BUT WhatsApp delivery failed

4. **Failed** (Red)
   - Executions where report generation failed

### WhatsApp Statistics

Below the main stats, you'll see:
- **WhatsApp Messages Sent**: Total successful deliveries
- **WhatsApp Failures**: Total failed deliveries

### Logs Table

The table shows every execution with these columns:

| Column | Description |
|--------|-------------|
| **Execution Time** | When the schedule ran |
| **Status** | Success (green), Partial (yellow), or Failed (red) |
| **Report** | Was the report generated? (Yes/No) |
| **WhatsApp** | How many messages were sent/failed |
| **Recipients** | Phone numbers (first 3 shown) |
| **Duration** | How long it took to execute |
| **Error / Notes** | Any error messages (if failed) |

## Common Scenarios

### ✅ Everything is Working
**What you'll see:**
- Status: **Success** (green badge)
- Report: **✓ Yes**
- WhatsApp: **✓ 3 sent** (or however many recipients you have)
- Error: **-** (no errors)

**What this means:**
Your schedule is running perfectly! Reports are being generated and sent.

---

### ⚠️ Partial Success
**What you'll see:**
- Status: **Partial** (yellow badge)
- Report: **✓ Yes**
- WhatsApp: **Not sent** or **X failed**
- Error: WhatsApp API error message

**What this means:**
The report was generated, but WhatsApp delivery failed. Possible reasons:
- Invalid phone numbers
- WhatsApp API credentials issue
- Network problem

**What to do:**
1. Check if phone numbers are in international format (+1234567890)
2. Verify WhatsApp API credentials in AutographFeedbackInsights module
3. Contact your administrator if the issue persists

---

### ❌ Complete Failure
**What you'll see:**
- Status: **Failed** (red badge)
- Report: **No**
- WhatsApp: **Not sent**
- Error: Error message explaining what went wrong

**What this means:**
The schedule couldn't generate the report. Possible reasons:
- No data available for the selected date range
- Database error
- Server issue

**What to do:**
1. Read the error message in the "Error / Notes" column
2. If it says "No staff activity data", adjust your date range or staff filters
3. If it's a technical error, contact your administrator

---

### 🤔 No Logs Yet
**What you'll see:**
- Message: "No execution logs yet. This schedule has not run."

**What this means:**
The schedule exists but hasn't executed yet. Check the "Next Run" time in the schedules table.

**What to do:**
1. Go back to the schedules table
2. Check the "Next Run" column
3. Wait for that time to pass
4. If it's past the "Next Run" time but still no logs:
   - Contact your administrator (cron jobs might not be running)

## Troubleshooting Tips

### Issue: "You do not have permission to view schedule logs"
**Solution:** Ask your administrator to grant you the "Can Generate & Schedule Reports" permission in the Permissions Management section.

### Issue: Logs show successful but I didn't receive the WhatsApp message
**Solution:** 
1. Check if your phone number is in the recipients list (click "View Logs" to see)
2. Verify the number format is correct (+country code + number)
3. Check your WhatsApp app for messages from the business account

### Issue: Schedule shows "Paused" status
**Solution:** The schedule is inactive. Click the "Activate" button to resume it.

### Issue: Last execution was days ago
**Solution:** 
1. Check if the schedule is active (green badge)
2. If active but not running, contact your administrator (server cron jobs may be disabled)

## Tips for Success

1. **Regular Monitoring**: Check logs weekly to ensure schedules are running
2. **Read Error Messages**: They usually explain exactly what went wrong
3. **Test First**: Create a test schedule with your number only before adding multiple recipients
4. **International Format**: Always use +countrycode format for WhatsApp numbers
5. **Reasonable Ranges**: Don't use very old date ranges (may be too much data)

## Need Help?

If logs show repeated failures or you don't understand an error message:

1. **Take a screenshot** of the logs modal
2. **Note the error message** from the "Error / Notes" column
3. **Contact your system administrator** with:
   - Schedule name
   - When it last ran successfully (if ever)
   - The error message
   - Your screenshot

## Advanced: Understanding Execution Duration

The "Duration" column shows how long each execution took:
- **< 3 seconds**: Very fast (small report)
- **3-10 seconds**: Normal (medium report)
- **10-30 seconds**: Slow (large report or slow connection)
- **> 30 seconds**: Very slow (consider reducing date range or staff count)

If you consistently see very long durations, ask your administrator to optimize the schedule configuration.

---

## Summary

✅ **To view logs:** Manage Schedules → Blue icon (📄)  
✅ **Success = Green badge:** Everything worked  
✅ **Partial = Yellow badge:** Report worked, WhatsApp failed  
✅ **Failed = Red badge:** Report didn't generate  
✅ **No logs:** Schedule hasn't run yet (check "Next Run" time)

**Remember:** Logs help you verify your scheduled reports are working. Check them regularly!

---

**Questions?** Contact your system administrator or refer to the full documentation in `SCHEDULE_LOGGING_FEATURE.md`

