<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php include_once APPPATH . 'views/admin/includes/modals/post_likes.php'; ?>
<?php include_once APPPATH . 'views/admin/includes/modals/post_comment_likes.php'; ?>
<div id="event"></div>
<div id="newsfeed" class="animated fadeIn hide" <?php if ($this->session->flashdata('newsfeed_auto')) {
    echo 'data-newsfeed-auto';
} ?>>
</div>
<!-- Task modal view -->
<div class="modal fade task-modal-single" id="task-modal" tabindex="-1" role="dialog"
  aria-labelledby="myLargeModalLabel">
  <div
    class="modal-dialog <?= get_option('task_modal_class'); ?>">
    <div class="modal-content data">

    </div>
  </div>
</div>

<!--Add/edit task modal-->
<div id="_task"></div>

<!-- Lead Data Add/Edit-->
<div class="modal fade lead-modal" id="lead-modal" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel">
  <div
    class="modal-dialog <?= get_option('lead_modal_class'); ?>">
    <div class="modal-content data">

    </div>
  </div>
</div>

<div id="timers-logout-template-warning" class="hide">
  <h3 class="bold">
    <?= _l('timers_started_confirm_logout'); ?>
  </h3>
  <hr />
  <a href="<?= admin_url('authentication/logout'); ?>"
    class="btn btn-danger">
    <?= _l('confirm_logout'); ?>
  </a>
</div>

<!--Lead convert to customer modal-->
<div id="lead_convert_to_customer"></div>

<!--Lead reminder modal-->
<div id="lead_reminder_modal"></div>

<!-- Reminder Notification Modal -->
<div class="modal fade" id="reminder-notification-modal" tabindex="-1" role="dialog" aria-labelledby="reminderNotificationLabel">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content">
      <div class="modal-header bg-warning">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
        <h4 class="modal-title" id="reminderNotificationLabel">
          <i class="fa fa-bell text-warning"></i>
          <?= _l('reminder_notification_title', 'Reminder Notification'); ?>
        </h4>
      </div>
      <div class="modal-body">
        <div id="reminder-notification-content">
          <!-- Reminder content will be populated by JavaScript -->
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">
          <?= _l('reminder_snooze_5min', 'Snooze 5 min'); ?>
        </button>
        <button type="button" class="btn btn-success" id="mark-reminder-complete">
          <?= _l('reminder_mark_complete', 'Mark as Complete'); ?>
        </button>
      </div>
    </div>
  </div>
</div>

<!-- Reminder Sound Toggle Button -->
<button type="button" class="reminder-sound-toggle" id="reminder-sound-toggle" 
        title="<?= _l('toggle_reminder_sound', 'Toggle Reminder Sound'); ?>" 
        onclick="toggleReminderSoundButton()" 
        style="position: fixed; bottom: 20px; right: 20px; z-index: 9999; 
               background: #337ab7; color: white; border: none; border-radius: 50%; 
               width: 50px; height: 50px; cursor: pointer; box-shadow: 0 2px 10px rgba(0,0,0,0.3);
               transition: all 0.3s ease;">
  <i class="fa fa-volume-up" id="reminder-sound-icon"></i>
</button>

<style>
.reminder-sound-toggle {
  position: fixed !important;
  bottom: 20px !important;
  right: 20px !important;
  z-index: 9999 !important;
  background: #337ab7 !important;
  color: white !important;
  border: none !important;
  border-radius: 50% !important;
  width: 50px !important;
  height: 50px !important;
  cursor: pointer !important;
  box-shadow: 0 2px 10px rgba(0,0,0,0.3) !important;
  transition: all 0.3s ease !important;
  font-size: 16px !important;
  display: flex !important;
  align-items: center !important;
  justify-content: center !important;
}

.reminder-sound-toggle:hover {
  background: #23527c !important;
  transform: scale(1.1) !important;
  text-decoration: none !important;
}

.reminder-sound-toggle:focus {
  outline: none !important;
  box-shadow: 0 0 0 3px rgba(51, 122, 183, 0.5) !important;
}

.reminder-sound-toggle.muted {
  background: #d9534f !important;
}

.reminder-sound-toggle.muted:hover {
  background: #c9302c !important;
}

.reminder-sound-toggle i {
  margin: 0 !important;
  color: white !important;
}

/* Ensure it doesn't conflict with other fixed elements */
@media (max-width: 768px) {
  .reminder-sound-toggle {
    bottom: 70px !important;
    right: 15px !important;
    width: 45px !important;
    height: 45px !important;
    font-size: 14px !important;
  }
}
</style>

<script>
// Sound toggle functionality - wrapped in proper jQuery ready check
function toggleReminderSoundButton() {
  if (typeof reminderSoundEnabled !== 'undefined' && typeof toggleReminderSound === 'function') {
    var isEnabled = !reminderSoundEnabled;
    toggleReminderSound(isEnabled);
    updateSoundToggleButton(isEnabled);
  } else {
    console.warn('Reminder sound system not yet loaded');
  }
}

function updateSoundToggleButton(enabled) {
  // Use vanilla JavaScript instead of jQuery to avoid dependency issues
  var button = document.getElementById('reminder-sound-toggle');
  var icon = document.getElementById('reminder-sound-icon');
  
  if (button && icon) {
    if (enabled) {
      button.classList.remove('muted');
      icon.classList.remove('fa-volume-off');
      icon.classList.add('fa-volume-up');
      button.setAttribute('title', '<?= _l('disable_reminder_sound', 'Disable Reminder Sound'); ?>');
    } else {
      button.classList.add('muted');
      icon.classList.remove('fa-volume-up');
      icon.classList.add('fa-volume-off');
      button.setAttribute('title', '<?= _l('enable_reminder_sound', 'Enable Reminder Sound'); ?>');
    }
  }
}

// Initialize sound toggle button state - use multiple methods to ensure it works
function initializeSoundToggle() {
  if (typeof reminderSoundEnabled !== 'undefined') {
    updateSoundToggleButton(reminderSoundEnabled);
  } else {
    // Retry after a delay
    setTimeout(initializeSoundToggle, 1000);
  }
}

// Try different initialization methods
if (typeof jQuery !== 'undefined') {
  jQuery(document).ready(function() {
    setTimeout(initializeSoundToggle, 2500);
  });
} else {
  // Fallback for when jQuery isn't available yet
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', function() {
      setTimeout(initializeSoundToggle, 2500);
    });
  } else {
    setTimeout(initializeSoundToggle, 2500);
  }
}

// Also try when window loads
window.addEventListener('load', function() {
  setTimeout(initializeSoundToggle, 1000);
});

// Additional safety check - retry initialization every few seconds until it works
var initRetryCount = 0;
var maxInitRetries = 10;

function retryInitialization() {
  if (initRetryCount >= maxInitRetries) {
    console.warn('Reminder sound toggle: Max initialization retries reached');
    return;
  }
  
  initRetryCount++;
  
  if (typeof reminderSoundEnabled !== 'undefined' && typeof toggleReminderSound === 'function') {
    console.log('Reminder sound toggle: Successfully initialized on retry', initRetryCount);
    updateSoundToggleButton(reminderSoundEnabled);
  } else {
    console.log('Reminder sound toggle: Retry', initRetryCount, 'failed, trying again...');
    setTimeout(retryInitialization, 2000);
  }
}

// Start retry process
setTimeout(retryInitialization, 3000);
</script>