<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Controller to update attachment descriptions
 */
class Update_attachment_description extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('misc_model');
    }

    /**
     * Update attachment description
     * @param  integer $attachment_id Attachment ID
     * @return json
     */
    public function index($attachment_id)
    {
        if (!is_staff_member()) {
            ajax_access_denied();
        }

        $description = $this->input->post('description');
        
        // Update the description in the database
        $this->db->where('id', $attachment_id);
        $this->db->update(db_prefix() . 'files', ['description' => $description]);
        
        if ($this->db->affected_rows() > 0) {
            // Log the successful update
            error_log("Successfully updated description for attachment ID: " . $attachment_id . " - " . $description);
            
            echo json_encode([
                'success' => true,
                'message' => _l('attachment_description_updated')
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => _l('attachment_description_not_updated')
            ]);
        }
    }
}
