<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Simple reporting dashboard without complex model dependencies
class Simple_dashboard extends AdminController
{
    public function index()
    {
        if (!is_staff_logged_in()) {
            redirect(admin_url('authentication'));
        }
        
        $data['title'] = 'Reporting Dashboard';
        
        // Get current user info
        $current_staff_id = get_staff_user_id();
        $data['user_staff_id'] = $current_staff_id;
        
        // Check permissions using direct database queries
        $permission_type = 'view_own_only'; // default
        $allowed_staff_ids = [$current_staff_id]; // default
        
        // Check if user has custom permissions
        $this->db->select('*');
        $this->db->from(db_prefix() . 'reporting_dashboard_permissions');
        $this->db->where('staff_id', $current_staff_id);
        $permission_query = $this->db->get();
        
        if ($permission_query->num_rows() > 0) {
            $permission = $permission_query->row();
            $permission_type = $permission->permission_type;
            
            if ($permission_type === 'view_specific_staff') {
                $allowed_staff_ids = json_decode($permission->allowed_staff_ids, true) ?: [];
                // Always include current user
                if (!in_array($current_staff_id, $allowed_staff_ids)) {
                    $allowed_staff_ids[] = $current_staff_id;
                }
            } elseif ($permission_type === 'view_all_staff') {
                $allowed_staff_ids = []; // empty means all
            }
        }
        
        // Admins always have view_all_staff permission
        if (is_admin($current_staff_id)) {
            $permission_type = 'view_all_staff';
            $allowed_staff_ids = [];
        }
        
        // Get staff list based on permissions
        $this->db->select('staffid, firstname, lastname, email, admin, active');
        $this->db->from(db_prefix() . 'staff');
        $this->db->where('active', 1);
        
        if (!empty($allowed_staff_ids)) {
            // Filter to specific staff only
            $this->db->where_in('staffid', $allowed_staff_ids);
        }
        
        $staff_query = $this->db->get();
        $data['staff_list'] = $staff_query->result_array();
        
        $data['can_view_all_staff'] = ($permission_type === 'view_all_staff');
        
        // Debug info
        $data['debug_info'] = [
            'current_staff_id' => $current_staff_id,
            'permission_type' => $permission_type,
            'allowed_staff_ids' => $allowed_staff_ids,
            'staff_count' => count($data['staff_list'])
        ];
        
        $this->load->view('simple_dashboard', $data);
    }
}
?>
