<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Simple_reminder_test extends AdminController
{
    public function index()
    {
        if (!is_staff_logged_in()) {
            redirect(admin_url('authentication'));
        }
        
        echo "<h2>Simple Reminder Test</h2>";
        
        try {
            // Test basic reminders query
            $this->db->select('*');
            $this->db->from(db_prefix() . 'reminders');
            $this->db->limit(10);
            $query = $this->db->get();
            
            echo "<p><strong>Total reminders found:</strong> " . $query->num_rows() . "</p>";
            
            if ($query->num_rows() > 0) {
                echo "<table border='1' style='border-collapse: collapse;'>";
                echo "<tr><th>ID</th><th>Description</th><th>Date</th><th>Staff</th><th>Type</th></tr>";
                
                foreach ($query->result() as $r) {
                    echo "<tr>";
                    echo "<td>{$r->id}</td>";
                    echo "<td>{$r->description}</td>";
                    echo "<td>{$r->date}</td>";
                    echo "<td>{$r->staff}</td>";
                    echo "<td>{$r->rel_type}</td>";
                    echo "</tr>";
                }
                echo "</table>";
            }
            
            // Test the categorization
            $today = date('Y-m-d');
            echo "<h3>Categorization Test (Today: $today)</h3>";
            
            $this->db->select('*');
            $this->db->from(db_prefix() . 'reminders');
            $query = $this->db->get();
            
            $todays = 0;
            $due = 0;
            $upcoming = 0;
            
            foreach ($query->result() as $r) {
                if ($r->date == $today) {
                    $todays++;
                } elseif ($r->date < $today) {
                    $due++;
                } else {
                    $upcoming++;
                }
            }
            
            echo "<ul>";
            echo "<li>Today's reminders: $todays</li>";
            echo "<li>Due reminders: $due</li>";
            echo "<li>Upcoming reminders: $upcoming</li>";
            echo "</ul>";
            
        } catch (Exception $e) {
            echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
        }
        
        echo "<p><a href='" . admin_url('reporting_dashboard') . "'>← Back to Dashboard</a></p>";
    }
    
    public function json()
    {
        if (!is_staff_logged_in()) {
            header('HTTP/1.1 403 Forbidden');
            echo json_encode(['error' => 'Access denied']);
            return;
        }
        
        try {
            // Simple reminders query
            $this->db->select('*');
            $this->db->from(db_prefix() . 'reminders');
            $query = $this->db->get();
            $reminders = $query->result_array();
            
            // Categorize
            $today = date('Y-m-d');
            $result = [
                'todays' => [],
                'due' => [],
                'upcoming' => []
            ];
            
            foreach ($reminders as $reminder) {
                // Add basic staff name
                $this->db->select('firstname, lastname');
                $this->db->from(db_prefix() . 'staff');
                $this->db->where('staffid', $reminder['staff']);
                $staff_query = $this->db->get();
                if ($staff_query->num_rows() > 0) {
                    $staff = $staff_query->row();
                    $reminder['staff_name'] = $staff->firstname . ' ' . $staff->lastname;
                } else {
                    $reminder['staff_name'] = 'Unknown Staff';
                }
                
                $reminder['related_name'] = $reminder['rel_type'] . ' #' . $reminder['rel_id'];
                $reminder['related_email'] = null;
                
                if ($reminder['date'] == $today) {
                    $result['todays'][] = $reminder;
                } elseif ($reminder['date'] < $today) {
                    $result['due'][] = $reminder;
                } else {
                    $result['upcoming'][] = $reminder;
                }
            }
            
            header('Content-Type: application/json');
            echo json_encode($result);
            
        } catch (Exception $e) {
            header('Content-Type: application/json');
            http_response_code(500);
            echo json_encode([
                'error' => true,
                'message' => $e->getMessage(),
                'todays' => [],
                'due' => [],
                'upcoming' => []
            ]);
        }
    }
}
?>
