<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Debug_permissions extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('reporting_dashboard/Reporting_dashboard_permissions_model', 'reporting_dashboard_permissions_model');
        $this->load->model('staff_model');
    }

    public function index()
    {
        if (!is_admin()) {
            access_denied('Debug Permissions');
        }

        echo "<h3>Reporting Dashboard Permissions Debug</h3>";
        
        $current_staff_id = get_staff_user_id();
        echo "<p><strong>Current Staff ID:</strong> $current_staff_id</p>";
        
        // Check current user's permission
        $permission = $this->reporting_dashboard_permissions_model->get_staff_permission($current_staff_id);
        echo "<p><strong>Current User Permission:</strong></p>";
        echo "<pre>" . print_r($permission, true) . "</pre>";
        
        // Get allowed staff IDs
        $allowed_staff_ids = $this->reporting_dashboard_permissions_model->get_allowed_staff_ids($current_staff_id);
        echo "<p><strong>Allowed Staff IDs for current user:</strong></p>";
        echo "<pre>" . print_r($allowed_staff_ids, true) . "</pre>";
        
        // Check if can view all staff
        $can_view_all = $this->reporting_dashboard_permissions_model->can_view_all_staff($current_staff_id);
        echo "<p><strong>Can View All Staff:</strong> " . ($can_view_all ? 'YES' : 'NO') . "</p>";
        
        // Get all staff
        $all_staff = $this->staff_model->get('', ['active' => 1]);
        echo "<h4>All Active Staff:</h4>";
        echo "<table border='1'>";
        echo "<tr><th>Staff ID</th><th>Name</th><th>Email</th><th>Admin</th></tr>";
        foreach ($all_staff as $staff) {
            echo "<tr>";
            echo "<td>" . $staff['staffid'] . "</td>";
            echo "<td>" . $staff['firstname'] . ' ' . $staff['lastname'] . "</td>";
            echo "<td>" . $staff['email'] . "</td>";
            echo "<td>" . (is_admin($staff['staffid']) ? 'Yes' : 'No') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Simulate filtering logic from controller
        echo "<h4>Filtered Staff (based on permissions):</h4>";
        if (empty($allowed_staff_ids)) {
            $filtered_staff = $all_staff;
            echo "<p>Empty allowed_staff_ids array = View ALL staff</p>";
        } else {
            $filtered_staff = array_filter($all_staff, function($staff) use ($allowed_staff_ids) {
                return in_array($staff['staffid'], $allowed_staff_ids);
            });
            echo "<p>Filtered to specific staff only</p>";
        }
        
        echo "<table border='1'>";
        echo "<tr><th>Staff ID</th><th>Name</th><th>Email</th></tr>";
        foreach ($filtered_staff as $staff) {
            echo "<tr>";
            echo "<td>" . $staff['staffid'] . "</td>";
            echo "<td>" . $staff['firstname'] . ' ' . $staff['lastname'] . "</td>";
            echo "<td>" . $staff['email'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        // Get all permissions from database
        echo "<h4>All Staff Permissions:</h4>";
        $all_permissions = $this->reporting_dashboard_permissions_model->get_all_staff_permissions();
        echo "<table border='1'>";
        echo "<tr><th>Staff ID</th><th>Name</th><th>Permission Type</th><th>Allowed Staff IDs</th></tr>";
        foreach ($all_permissions as $perm) {
            echo "<tr>";
            echo "<td>" . $perm['staffid'] . "</td>";
            echo "<td>" . $perm['firstname'] . ' ' . $perm['lastname'] . "</td>";
            echo "<td>" . ($perm['permission_type'] ?: 'view_own_only (default)') . "</td>";
            echo "<td>" . ($perm['allowed_staff_ids'] ?: 'N/A') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
}
?>
