<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<?php
$CI = &get_instance();
// Ensure security library loaded
if (!isset($CI->security)) {
  $CI->load->library('security');
}
if (isset($CI->security)) {
  $rd_csrf_token_name = $CI->security->get_csrf_token_name();
  $rd_csrf_hash = $CI->security->get_csrf_hash();
?>
<script>
// Expose CodeIgniter CSRF token (used by direct-api.js auto injection)
var csrf_token_name = <?= json_encode($rd_csrf_token_name); ?>;
var csrf_hash = <?= json_encode($rd_csrf_hash); ?>;
console.log('[Reporting Dashboard] CSRF vars injected', csrf_token_name);

// Helper function to add CSRF token to data
function addCSRFToken(data) {
    var result = Object.assign({}, data);
    result[csrf_token_name] = csrf_hash;
    return result;
}

// Helper function to make CSRF-safe fetch requests
function safeFetch(url, options) {
    options = options || {};
    if (options.method === 'POST' && options.body) {
        // If body is URLSearchParams, convert to object, add CSRF, convert back
        if (options.body instanceof URLSearchParams) {
            var data = {};
            for (var pair of options.body.entries()) {
                data[pair[0]] = pair[1];
            }
            data[csrf_token_name] = csrf_hash;
            options.body = new URLSearchParams(data);
        }
    }
    return fetch(url, options);
}
</script>
<?php } ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
<!-- Include direct-api helper -->
<script src="<?= module_dir_url('reporting_dashboard', 'assets/js/direct-api.js'); ?>"></script>
<style>
/* Fix for activity log table display */
#activity-log-table {
    width: 100% !important;
    table-layout: auto !important;
    display: table !important;
    visibility: visible !important;
}

.table-responsive {
    overflow-x: auto;
    clear: both;
    display: block !important;
    min-height: 200px;
}

/* Ensure table shows immediately */
#activity-log-table tbody {
    display: table-row-group !important;
}

#activity-log-table thead {
    display: table-header-group !important;
}

/* Ensure proper spacing */
.reporting-dashboard .panel_s {
    margin-bottom: 20px;
}

/* Fix for date filter form */
.form-inline .form-group {
    display: inline-block;
    margin-bottom: 0;
    vertical-align: middle;
}

/* Reminder count badges */
.panel-title .badge {
    font-size: 11px;
    margin-left: 8px;
    padding: 3px 7px;
    border-radius: 10px;
    font-weight: 600;
}

.badge-warning {
    background-color: #f39c12;
    color: white;
}

.badge-danger {
    background-color: #e74c3c;
    color: white;
}

.badge-info {
    background-color: #3498db;
    color: white;
}

/* Ensure buttons don't break layout */
.btn-group-sm > .btn {
    white-space: nowrap;
}

/* Fix clearfix issues */
.clearfix::after {
    content: "";
    display: table;
    clear: both;
}

/* Reminder styling */
.reminder-item:hover {
    background-color: #f8f9fa !important;
    transform: translateX(2px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.reminder-item {
    border-radius: 4px;
    margin-bottom: 2px;
    transition: all 0.2s ease;
}

.reminder-item:hover .text-primary {
    color: #007bff !important;
    font-weight: bold;
}

/* Activity table styling */
#activity-log-table tbody tr:hover {
    background-color: #f8f9fa;
}

#activity-log-table .btn:hover {
    transform: scale(1.05);
}

/* Follow-up type styling */
#activity-log-table .followup-type-col {
    min-width: 120px;
    text-align: center;
}

.followup-type-icon {
    font-size: 14px;
    margin-right: 5px;
}

/* Activity type badges */
.activity-type-badge {
    padding: 3px 8px;
    border-radius: 3px;
    font-size: 11px;
    font-weight: bold;
}

/* Dropdown fixes */
.bootstrap-select {
    width: 100% !important;
}

.bootstrap-select .dropdown-toggle {
    width: 100%;
    padding: 6px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Fallback for regular select if bootstrap-select fails */
select[multiple] {
    height: auto !important;
    min-height: 34px;
}

#staff-filter, #activity-type-filter {
    width: 100%;
}

/* Ensure dropdowns are visible */
.selectpicker {
    display: block !important;
}

/* Date picker styling */
.datepicker {
    width: 100%;
}

/* Fallback styling for date inputs */
input[type="date"] {
    width: 100%;
    padding: 6px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Ensure all form controls have consistent styling */
#date-from, #date-to, #activity-date-from, #activity-date-to {
    width: 100%;
}

/* Loading state for filters */
.filters-loading {
    opacity: 0.6;
    pointer-events: none;
}
</style>
<div id="wrapper">
  <div class="content reporting-dashboard">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <div class="clearfix">
              <div class="pull-left">
                <h4 class="tw-font-semibold tw-text-lg tw-text-neutral-800"><?= _l('Reporting Dashboard'); ?></h4>
                <?php if (isset($show_permission_link) && $show_permission_link): ?>
                  <a href="<?= admin_url('reporting_dashboard/permissions'); ?>" class="btn btn-warning btn-xs">
                    <i class="fa fa-lock"></i> Manage Permissions
                  </a>
                <?php endif; ?>
              </div>
              <div class="pull-right">
                <div class="btn-group">
                  <button id="export-pdf" class="btn btn-danger btn-sm"><i class="fa fa-file-pdf-o"></i> Download PDF</button>
                  <button id="export-csv" class="btn btn-default btn-sm"><i class="fa fa-download"></i> CSV</button>
                  <button id="export-excel" class="btn btn-default btn-sm"><i class="fa fa-file-excel-o"></i> Excel</button>
                  <button id="export-print" class="btn btn-default btn-sm"><i class="fa fa-print"></i> Print</button>
                </div>
              </div>
            </div>
            <hr class="mtop15 mbot15">

            <!-- Filters -->
            <div class="panel_s">
              <div class="panel-body">
                <h5 class="tw-font-medium tw-text-neutral-800 tw-mb-3"><?= _l('Filters'); ?></h5>
                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Date Range'); ?></label>
                      <div class="btn-group btn-group-sm mbot10" style="display: block;">
                        <button type="button" class="btn btn-default preset-btn" data-preset="today">Today</button>
                        <button type="button" class="btn btn-default preset-btn" data-preset="week">This Week</button>
                        <button type="button" class="btn btn-default preset-btn active" data-preset="month">This Month</button>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <input type="date" class="form-control" id="date-from" placeholder="From" autocomplete="off">
                        </div>
                        <div class="col-md-6">
                          <input type="date" class="form-control" id="date-to" placeholder="To" autocomplete="off">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Staff'); ?></label>
                      <select id="staff-filter" class="form-control selectpicker" data-live-search="true" data-actions-box="true" multiple>
                        <?php if (!empty($staff_list)) : ?>
                          <?php foreach ($staff_list as $s): ?>
                            <option value="<?= (int)$s['staffid']; ?>" title="<?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?>">
                              <?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?>
                            </option>
                          <?php endforeach; ?>
                        <?php else: ?>
                          <option value="" disabled>No staff available</option>
                        <?php endif; ?>
                      </select>
                      <small class="text-muted">
                        <?php if (!empty($staff_list)): ?>
                          <?= count($staff_list); ?> staff member(s) available
                        <?php else: ?>
                          No staff members available based on your permissions
                        <?php endif; ?>
                      </small>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Activity Type'); ?></label>
                      <select id="activity-type-filter" class="form-control selectpicker" multiple>
                        <option value="Lead" selected>Lead Activities</option>
                        <option value="Task">Tasks</option>
                        <option value="Project">Projects</option>
                        <option value="Invoice">Invoices</option>
                        <option value="Auth">Login/Logout</option>
                        <option value="Other">Other</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="control-label">&nbsp;</label>
                      <button id="apply-filters" class="btn btn-primary btn-block"><i class="fa fa-filter"></i> <?= _l('Apply'); ?></button>
                      <button id="refresh-dropdowns" class="btn btn-default btn-block btn-xs" style="margin-top: 5px;"><i class="fa fa-refresh"></i> Refresh Filters</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Detailed Activity Log -->
            <div class="panel_s mtop20">
              <div class="panel-body">
                <div class="clearfix">
                  <div class="pull-left">
                    <h5 class="panel-title">Detailed Activity Log</h5>
                  </div>
                  <div class="pull-right">
                    <div class="btn-group btn-group-sm">
                      <button class="btn btn-default" id="table-export-csv"><i class="fa fa-download"></i> CSV</button>
                      <button class="btn btn-default" id="table-export-excel"><i class="fa fa-file-excel-o"></i> Excel</button>
                    </div>
                  </div>
                </div>
                <div class="row mtop10">
                  <div class="col-md-12">
                    <div class="form-inline pull-right">
                      <div class="form-group">
                        <label for="activity-date-from" style="margin-right: 5px;">From:</label>
                        <input type="date" id="activity-date-from" class="form-control input-sm" style="width: 140px;">
                      </div>
                      <div class="form-group" style="margin-left: 10px;">
                        <label for="activity-date-to" style="margin-right: 5px;">To:</label>
                        <input type="date" id="activity-date-to" class="form-control input-sm" style="width: 140px;">
                      </div>
                      <button type="button" id="activity-apply-filter" class="btn btn-primary btn-sm" style="margin-left: 10px;">
                        <i class="fa fa-filter"></i> Filter
                      </button>
                    </div>
                  </div>
                </div>
                <hr class="mtop15 mbot15">
                <div class="table-responsive">
                  <table id="activity-log-table" class="table table-striped table-bordered dt-table">
                    <thead>
                      <tr>
                        <th><?= _l('Date & Time'); ?></th>
                        <th><?= _l('Staff Member'); ?></th>
                        <th><?= _l('Activity Type'); ?></th>
                        <th><?= _l('Related Entity'); ?></th>
                        <th><?= _l('Follow-up Type'); ?></th>
                        <th><?= _l('Description'); ?></th>
                        <th><?= _l('IP Address'); ?></th>
                        <th><?= _l('Actions'); ?></th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>

            <!-- KPIs -->
            <div class="row mtop20">
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-primary">
                      <i class="fa fa-calendar fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-today">0</h3>
                    <p class="text-muted mbot0">Activities Today</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-success">
                      <i class="fa fa-calendar-check-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-week">0</h3>
                    <p class="text-muted mbot0">This Week</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-info">
                      <i class="fa fa-calendar-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-month">0</h3>
                    <p class="text-muted mbot0">This Month</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-warning">
                      <i class="fa fa-sign-in fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-logins">0</h3>
                    <p class="text-muted mbot0">Logins Today</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- Charts -->
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities by Staff</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities Over Time</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesOverTimeChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activity Type Distribution</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activityTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-users"></i> Top Active Staff</h5>
                    <div id="top-staff-list">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Staff Performance Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bar-chart"></i> Staff Performance by Activity Type</h5>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="staffPerformanceChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Follow-up Types Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">
                      <i class="fa fa-phone text-success"></i> Follow-up Types by Staff
                    </h5>
                    <p class="text-muted">Shows the breakdown of different follow-up types (calls, WhatsApp, emails, meetings, etc.) performed by each staff member in the selected date range.</p>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="followupTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Reminders & Followups Section -->
            <div class="row mtop20">
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bell text-warning"></i> Today's Reminders</h5>
                    <div id="todays-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders</h5>
                    <div id="due-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-calendar text-info"></i> Upcoming Reminders</h5>
                    <div id="upcoming-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>



<!-- Modal -->
<div class="modal fade" id="rdLogModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Log Details</h4>
      </div>
      <div class="modal-body" id="rd-log-details">
        <div class="text-center"><i class="fa fa-spinner fa-spin"></i></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
      </div>
    </div>
  </div>
</div>

<script>
// Global variables
var baseUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/';
var currentFilters = {};

// Function to force table rendering
// Add safeguard to prevent multiple simultaneous renders
var isTableRendering = false;

function forceTableRender() {
    if (isTableRendering) {
        // Table render already in progress, skipping...
        return;
    }
    
    isTableRendering = true;
    
    var table = document.getElementById('activity-log-table');
    var container = document.querySelector('.table-responsive');
    
    if (table && container) {
        // Force visibility
        table.style.display = 'table';
        table.style.visibility = 'visible';
        container.style.display = 'block';
        
        // Force reflow
        table.offsetHeight;
        container.offsetHeight;
        
        // Table rendering completed
    }
    
    // Reset the flag after a short delay
    setTimeout(function() {
        isTableRendering = false;
    }, 500);
}

// Function to normalize chart responses from real API (labels+data) or mock (chart_data)
function normalizeSimpleToDataset(obj, type){
  if(!obj) return null;
  // Mock shape already nested
  if(obj.chart_data) return obj.chart_data;
  // Real shape: {labels:[], data:[]} -> wrap
  if(Array.isArray(obj.labels) && Array.isArray(obj.data)){
    var colorSets = {
      bar: '#4e73df',
      line: '#1cc88a',
      pie: ['#4e73df','#1cc88a','#36b9cc','#f6c23e','#e74a3b','#858796']
    };
    var ds = {labels: obj.labels, datasets: []};
    if(type==='pie'){
      ds.datasets.push({data: obj.data, backgroundColor: colorSets.pie.slice(0, obj.data.length)});
    } else if(type==='line') {
      ds.datasets.push({label:'Activities', data: obj.data, borderColor: colorSets.line, fill:false});
    } else { // bar default
      ds.datasets.push({label:'Activities', data: obj.data, backgroundColor: colorSets.bar});
    }
    return ds;
  }
  return null;
}

// Function to load charts
function loadCharts(baseUrl, filters) {
    // Load Activities by Staff Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'bar');
    if(chartData) createActivitiesByStaffChart(chartData);
    })
    .catch(error => {
        console.error('Activities by staff chart failed:', error.message);
    });
    
    // Load Activities Over Time Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_over_time_chart', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'line');
    if(chartData) createActivitiesOverTimeChart(chartData);
    })
    .catch(error => {
        console.error('Activities over time chart failed:', error.message);
    });
    
    // Load Activity Types Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_type_pie', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'pie');
    if(chartData) createActivityTypesChart(chartData);
    })
    .catch(error => {
        console.error('Activity types chart failed:', error.message);
    });
    
    // Load Reminders data
    safeFetch(baseUrl + 'reporting_dashboard/get_reminders', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
    .then(data => {
        loadReminders(data);
    })
    .catch(error => {
        console.error('Reminders load failed:', error.message);
    });
}

// Function to apply filters and load data
function applyFilters() {
    // Ensure selectpickers are refreshed before getting values
    if (typeof $ !== 'undefined' && $.fn.selectpicker) {
        $('#staff-filter').selectpicker('refresh');
        $('#activity-type-filter').selectpicker('refresh');
    }
    
    var filters = {
        from: document.getElementById('date-from').value,
        to: document.getElementById('date-to').value,
        staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
        activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
    };
    
    // Synchronize activity log date filters with main date filters
    if (filters.from) {
        document.getElementById('activity-date-from').value = filters.from;
    }
    if (filters.to) {
        document.getElementById('activity-date-to').value = filters.to;
    }
    
    // Debug: Log filters being sent
    console.log('Apply Filters called with:', filters);
    console.log('Staff filter array:', filters.staff);
    console.log('Staff filter length:', filters.staff.length);
    
    currentFilters = filters;
    
    // Load KPIs
    var kpiUrl = baseUrl + 'reporting_dashboard/get_kpis';
    
    safeFetch(kpiUrl, {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
    .then(data => {
        // Update KPI displays
        document.getElementById('kpi-today').textContent = data.today || 0;
        document.getElementById('kpi-week').textContent = data.week || 0;
        document.getElementById('kpi-month').textContent = data.month || 0;
        document.getElementById('kpi-logins').textContent = data.logins_today || 0;
        
        // Update top staff list
        if (data.top_staff && data.top_staff.length > 0) {
            var staffHtml = '<div class="list-group">';
            data.top_staff.forEach(function(staff) {
                staffHtml += '<div class="list-group-item">' +
                    '<div class="row">' +
                    '<div class="col-md-8">' + staff.staff_name + '</div>' +
                    '<div class="col-md-4 text-right"><span class="badge badge-primary">' + staff.total + '</span></div>' +
                    '</div></div>';
            });
            staffHtml += '</div>';
            document.getElementById('top-staff-list').innerHTML = staffHtml;
        }
        
        // Load activity log table
        safeFetch(baseUrl + 'reporting_dashboard/get_activity_table', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            loadActivityLog(data);
        })
        .catch(error => {
            console.error('Activity log load failed:', error.message);
        });
        
        // Load staff performance chart
        safeFetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
    .then(data => {
      // Reuse by creating normalized dataset with single bar series
      var chartData = normalizeSimpleToDataset(data,'bar');
      if(chartData){
        // For staff performance we want stacked? If only one dataset, just pass
        createStaffPerformanceChart({labels: chartData.labels, datasets: {'Activities': chartData.datasets[0]}});
      }
    })
        .catch(error => {
            console.error('Staff performance load failed:', error.message);
        });
        
        // Load follow-up types chart
        safeFetch(baseUrl + 'reporting_dashboard/get_followup_types_chart', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            createFollowupTypesChart(data);
        })
        .catch(error => {
            console.error('Follow-up types load failed:', error.message);
        });
    })
    .catch(error => {
        console.error('KPI load failed:', error.message);
    });
}

// Function to get follow-up type with appropriate icon
function getFollowupTypeWithIcon(followupType, activityType) {
    if (!followupType || followupType.trim() === '') {
        // Return appropriate icon for non-followup activities
        switch(activityType) {
            case 'Reminder Created':
                return '<span class="text-warning"><i class="fa fa-bell"></i> Reminder</span>';
            case 'Lead Created':
                return '<span class="text-success"><i class="fa fa-plus-circle"></i> New Lead</span>';
            case 'Lead Assigned':
                return '<span class="text-info"><i class="fa fa-user"></i> Assignment</span>';
            default:
                return '<span class="text-muted"><i class="fa fa-circle-o"></i> N/A</span>';
        }
    }
    
    // Get appropriate icon and color for follow-up types
    var icon = 'fa-comment';
    var colorClass = 'text-primary';
    var typeText = followupType.toLowerCase();
    
    if (typeText.includes('call') || typeText.includes('phone')) {
        icon = 'fa-phone';
        colorClass = 'text-success';
    } else if (typeText.includes('email') || typeText.includes('mail')) {
        icon = 'fa-envelope';
        colorClass = 'text-info';
    } else if (typeText.includes('meeting') || typeText.includes('visit')) {
        icon = 'fa-calendar';
        colorClass = 'text-warning';
    } else if (typeText.includes('whatsapp') || typeText.includes('message')) {
        icon = 'fa-whatsapp';
        colorClass = 'text-success';
    } else if (typeText.includes('sms') || typeText.includes('text')) {
        icon = 'fa-mobile';
        colorClass = 'text-primary';
    } else if (typeText.includes('proposal') || typeText.includes('quote')) {
        icon = 'fa-file-text';
        colorClass = 'text-warning';
    } else if (typeText.includes('contract') || typeText.includes('agreement')) {
        icon = 'fa-handshake-o';
        colorClass = 'text-danger';
    }
    
    return '<span class="' + colorClass + '"><i class="fa ' + icon + '"></i> ' + followupType + '</span>';
}

// Function to load activity log
function loadActivityLog(data) {
    var tbody = document.querySelector('#activity-log-table tbody');
    if (!tbody) {
        console.error('Activity table tbody not found!');
        return;
    }
    
    tbody.innerHTML = '';
    
    if (data.data && data.data.length > 0) {
        data.data.forEach(function(activity) {
            var row = document.createElement('tr');
            
            // Format date
            var date = new Date(activity.date);
            var dateStr = date.toLocaleDateString() + ' ' + date.toLocaleTimeString();
            
            // Get follow-up type with icon
            var followupTypeHtml = getFollowupTypeWithIcon(activity.followup_type, activity.activity_type);
            
            row.innerHTML = `
                <td>${dateStr}</td>
                <td>${activity.staff_name || 'Unknown'}</td>
                <td>${activity.activity_type || 'Unknown'}</td>
                <td>${activity.related || 'N/A'}</td>
                <td>${followupTypeHtml}</td>
                <td>${activity.description || 'No description available'}</td>
                <td>${activity.ip_address || 'N/A'}</td>
                <td>
                    ${activity.lead_id && activity.lead_id > 0 ? 
                        `<a href="<?php echo admin_url(); ?>${activity.view_link}" class="btn btn-xs btn-default">
                            <i class="fa fa-eye"></i> View
                        </a>` :
                        `<button class="btn btn-xs btn-default" disabled>
                            <i class="fa fa-eye"></i> View
                        </button>`
                    }
                </td>
            `;
            
            tbody.appendChild(row);
        });
    } else {
        tbody.innerHTML = '<tr><td colspan="8" class="text-center text-muted">No activity data found for the selected filters.</td></tr>';
    }
}

// Function to load reminders
function loadReminders(data) {
    // Helper function to build reminder item HTML
    function buildReminderItem(reminder, borderColor, dateClass, dateIcon, dateText) {
        var staffName = reminder.staff_name || 'Unknown Staff';
        var leadName = reminder.lead_name || '';
        var relatedText = '';
        
        // Build related information text
        if (reminder.rel_type && reminder.rel_id) {
            switch(reminder.rel_type) {
                case 'lead':
                    relatedText = leadName ? '<i class="fa fa-user"></i> Lead: ' + leadName : '<i class="fa fa-user"></i> Lead ID: ' + reminder.rel_id;
                    break;
                case 'customer':
                    relatedText = reminder.customer_name ? '<i class="fa fa-building"></i> Customer: ' + reminder.customer_name : '<i class="fa fa-building"></i> Customer ID: ' + reminder.rel_id;
                    break;
                case 'project':
                    relatedText = reminder.project_name ? '<i class="fa fa-tasks"></i> Project: ' + reminder.project_name : '<i class="fa fa-tasks"></i> Project ID: ' + reminder.rel_id;
                    break;
                case 'invoice':
                    relatedText = '<i class="fa fa-file-text"></i> Invoice #' + reminder.rel_id;
                    break;
                case 'estimate':
                    relatedText = '<i class="fa fa-file-o"></i> Estimate #' + reminder.rel_id;
                    break;
                case 'proposal':
                    relatedText = '<i class="fa fa-file-pdf-o"></i> Proposal #' + reminder.rel_id;
                    break;
                case 'contract':
                    relatedText = '<i class="fa fa-file-text-o"></i> Contract #' + reminder.rel_id;
                    break;
                default:
                    relatedText = '<i class="fa fa-link"></i> ' + reminder.rel_type.charAt(0).toUpperCase() + reminder.rel_type.slice(1) + ' #' + reminder.rel_id;
            }
        }
        
        return '<div class="list-group-item reminder-item" onclick="viewReminderDetails(\'' + reminder.id + '\', \'' + reminder.rel_type + '\', \'' + reminder.rel_id + '\')" style="cursor: pointer; transition: background-color 0.2s; border-left: 4px solid ' + borderColor + ';">' +
            '<div class="row">' +
            '<div class="col-md-8">' +
                '<strong>' + (reminder.description || 'No description') + '</strong><br>' +
                '<small class="text-muted"><i class="fa fa-user-circle"></i> Assigned to: <strong>' + staffName + '</strong></small>' +
                (relatedText ? '<br><small class="text-muted">' + relatedText + '</small>' : '') +
            '</div>' +
            '<div class="col-md-4 text-right">' +
                '<small class="' + dateClass + '"><i class="fa ' + dateIcon + '"></i> ' + dateText + '</small><br>' +
                '<small class="text-primary"><i class="fa fa-external-link"></i> Click to view</small>' +
            '</div>' +
            '</div></div>';
    }
    
    // Load today's reminders
    if (data.todays && data.todays.length > 0) {
        var html = '<div class="list-group">';
        data.todays.forEach(function(reminder) {
            html += buildReminderItem(reminder, '#f39c12', 'text-warning', 'fa-clock-o', reminder.date);
        });
        html += '</div>';
        document.getElementById('todays-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#todays-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-bell text-warning"></i> Today\'s Reminders <span class="badge badge-warning">' + data.todays.length + '</span>';
        }
    } else {
        document.getElementById('todays-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-calendar-check-o fa-2x"></i><br>No reminders for today</div>';
    }
    
    // Load due reminders
    if (data.due && data.due.length > 0) {
        var html = '<div class="list-group">';
        data.due.forEach(function(reminder) {
            html += buildReminderItem(reminder, '#e74c3c', 'text-danger', 'fa-exclamation-triangle', 'Overdue');
        });
        html += '</div>';
        document.getElementById('due-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#due-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders <span class="badge badge-danger">' + data.due.length + '</span>';
        }
    } else {
        document.getElementById('due-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-check-circle fa-2x"></i><br>No overdue reminders</div>';
    }
    
    // Load upcoming reminders
    if (data.upcoming && data.upcoming.length > 0) {
        var html = '<div class="list-group">';
        data.upcoming.forEach(function(reminder) {
            html += buildReminderItem(reminder, '#3498db', 'text-info', 'fa-calendar', reminder.date);
        });
        html += '</div>';
        document.getElementById('upcoming-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#upcoming-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-calendar text-info"></i> Upcoming Reminders <span class="badge badge-info">' + data.upcoming.length + '</span>';
        }
    } else {
        document.getElementById('upcoming-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-calendar-o fa-2x"></i><br>No upcoming reminders</div>';
    }
}

// Chart creation functions
function createActivitiesByStaffChart(chartData) {
    var ctx = document.getElementById('activitiesChart');
    if (!ctx) return;
    
    if (window.activitiesChart && typeof window.activitiesChart.destroy === 'function') {
        window.activitiesChart.destroy();
    }
    
    window.activitiesChart = new Chart(ctx, {
        type: 'bar',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createActivitiesOverTimeChart(chartData) {
    var ctx = document.getElementById('activitiesOverTimeChart');
    if (!ctx) return;
    
    if (window.activitiesOverTimeChart && typeof window.activitiesOverTimeChart.destroy === 'function') {
        window.activitiesOverTimeChart.destroy();
    }
    
    window.activitiesOverTimeChart = new Chart(ctx, {
        type: 'line',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createActivityTypesChart(chartData) {
    var ctx = document.getElementById('activityTypesChart');
    if (!ctx) return;
    
    if (window.activityTypesChart && typeof window.activityTypesChart.destroy === 'function') {
        window.activityTypesChart.destroy();
    }
    
    window.activityTypesChart = new Chart(ctx, {
        type: 'pie',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
}

function createStaffPerformanceChart(chartData) {
    var ctx = document.getElementById('staffPerformanceChart');
    if (!ctx) return;
    
    if (window.staffPerformanceChart && typeof window.staffPerformanceChart.destroy === 'function') {
        window.staffPerformanceChart.destroy();
    }
    
    // Convert data format for stacked bar chart
    var datasets = [];
    if (chartData.datasets) {
        Object.keys(chartData.datasets).forEach(function(key) {
            datasets.push(chartData.datasets[key]);
        });
    }
    
    window.staffPerformanceChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartData.labels || [],
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    stacked: true
                }],
                yAxes: [{
                    stacked: true,
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createFollowupTypesChart(chartData) {
    var ctx = document.getElementById('followupTypesChart');
    if (!ctx) return;
    
    if (window.followupTypesChart && typeof window.followupTypesChart.destroy === 'function') {
        window.followupTypesChart.destroy();
    }
    
    // Convert data format for stacked bar chart
    var datasets = [];
    if (chartData.datasets) {
        chartData.datasets.forEach(function(dataset) {
            datasets.push(dataset);
        });
    }
    
    window.followupTypesChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartData.labels || [],
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    stacked: true
                }],
                yAxes: [{
                    stacked: true,
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

// Function to view activity details
function viewActivityDetails(activityId) {
    // For now, just show basic info
    var modal = document.getElementById('rdLogModal');
    var modalBody = document.getElementById('rd-log-details');
    
    if (modal && modalBody) {
        modalBody.innerHTML = '<div class="text-center">' +
            '<h4>Activity Details</h4>' +
            '<p><strong>Activity ID:</strong> ' + activityId + '</p>' +
            '<p>Detailed information for this activity would be displayed here.</p>' +
            '</div>';
        
        // Show the modal using vanilla JavaScript
        modal.style.display = 'block';
    }
}

// Function to view reminder details
function viewReminderDetails(reminderId, relType, relId) {
    // Get the admin base URL from PHP
    var adminBaseUrl = '<?php echo admin_url(); ?>';
    
    // Determine the appropriate URL based on the related type
    var targetUrl = '';
    
    switch(relType) {
        case 'lead':
            targetUrl = adminBaseUrl + 'leads/index/' + relId;
            break;
        case 'client':
            targetUrl = adminBaseUrl + 'clients/client/' + relId;
            break;
        case 'task':
            targetUrl = adminBaseUrl + 'tasks/view/' + relId;
            break;
        case 'project':
            targetUrl = adminBaseUrl + 'projects/view/' + relId;
            break;
        case 'invoice':
            targetUrl = adminBaseUrl + 'invoices/list_invoices/' + relId;
            break;
        case 'estimate':
            targetUrl = adminBaseUrl + 'estimates/list_estimates/' + relId;
            break;
        case 'proposal':
            targetUrl = adminBaseUrl + 'proposals/list_proposals/' + relId;
            break;
        case 'contract':
            targetUrl = adminBaseUrl + 'contracts/contract/' + relId;
            break;
        case 'expense':
            targetUrl = adminBaseUrl + 'expenses/expense/' + relId;
            break;
        case 'credit_note':
            targetUrl = adminBaseUrl + 'credit_notes/list_credit_notes/' + relId;
            break;
        default:
            // For unknown types, try to show in a modal
            showReminderModal(reminderId, relType, relId);
            return;
    }
    
    // Navigate to the target page
    if (targetUrl) {
        window.open(targetUrl, '_blank');
    }
}

// Function to show reminder details in modal
function showReminderModal(reminderId, relType, relId) {
    var modal = document.getElementById('rdLogModal');
    var modalBody = document.getElementById('rd-log-details');
    
    if (modal && modalBody) {
        modalBody.innerHTML = '<div class="text-center">' +
            '<i class="fa fa-bell fa-3x text-warning" style="margin-bottom: 15px;"></i>' +
            '<h4>Reminder Details</h4>' +
            '<div class="well text-left" style="margin: 20px 0;">' +
                '<p><strong><i class="fa fa-hashtag"></i> Reminder ID:</strong> ' + reminderId + '</p>' +
                '<p><strong><i class="fa fa-tag"></i> Type:</strong> ' + relType.charAt(0).toUpperCase() + relType.slice(1) + '</p>' +
                '<p><strong><i class="fa fa-link"></i> Related ID:</strong> ' + relId + '</p>' +
            '</div>' +
            '<div class="alert alert-info">' +
                '<i class="fa fa-info-circle"></i> This reminder is linked to a <strong>' + relType + '</strong> with ID <strong>' + relId + '</strong>.' +
                '<br>The system could not determine the exact page to navigate to for this item type.' +
            '</div>' +
            '<div class="text-center">' +
                '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>' +
            '</div>' +
            '</div>';
        
        // Show the modal using Bootstrap if available, otherwise vanilla JS
        if (typeof $ !== 'undefined' && $.fn.modal) {
            $(modal).modal('show');
        } else {
            modal.style.display = 'block';
            modal.classList.add('in');
        }
    }
}

// Function to set up event listeners
function setupEventListeners() {
    // Apply filters button
    document.getElementById('apply-filters').addEventListener('click', applyFilters);
    
    // Refresh dropdowns button
    document.getElementById('refresh-dropdowns').addEventListener('click', function() {
        console.log('[Reporting Dashboard] Manual refresh requested');
        
        // Reinitialize date pickers
        try {
            console.log('[Reporting Dashboard] Refreshing date inputs');
            // Ensure HTML5 date inputs are properly set
            if (typeof $ !== 'undefined') {
                $('#date-from, #date-to, #activity-date-from, #activity-date-to').attr('type', 'date');
                
                // Optional: Refresh Bootstrap datepicker if it exists
                if ($.fn.datepicker && $('.datepicker').length > 0) {
                    $('.datepicker').datepicker('destroy');
                    $('.datepicker').datepicker({
                        format: 'yyyy-mm-dd',
                        autoclose: true,
                        todayHighlight: true,
                        clearBtn: true,
                        orientation: 'bottom auto'
                    });
                }
            } else {
                // Fallback for vanilla JS
                var dateInputs = document.querySelectorAll('#date-from, #date-to, #activity-date-from, #activity-date-to');
                for (var i = 0; i < dateInputs.length; i++) {
                    dateInputs[i].type = 'date';
                }
            }
            console.log('[Reporting Dashboard] Date inputs refreshed');
        } catch (error) {
            console.error('[Reporting Dashboard] Date input refresh failed:', error);
        }
        
        // Reinitialize dropdowns
        try {
            if (typeof $ !== 'undefined' && $.fn.selectpicker) {
                $('#staff-filter, #activity-type-filter').selectpicker('destroy');
                
                setTimeout(function() {
                    // Set Bootstrap version manually
                    if ($.fn.selectpicker.Constructor) {
                        $.fn.selectpicker.Constructor.BootstrapVersion = '3.3.7';
                    }
                    
                    $('#staff-filter').selectpicker({
                        liveSearch: true,
                        actionsBox: true,
                        noneSelectedText: 'Select Staff Members',
                        style: 'btn-default'
                    });
                    
                    $('#activity-type-filter').selectpicker({
                        noneSelectedText: 'Select Activity Types',
                        style: 'btn-default'
                    });
                    
                    console.log('[Reporting Dashboard] Dropdowns manually refreshed');
                }, 100);
            }
        } catch (error) {
            console.error('[Reporting Dashboard] Dropdown refresh failed:', error);
        }
    });
    
    // Selectpicker change events
    if (typeof $ !== 'undefined' && $.fn.selectpicker) {
        $('#staff-filter').on('changed.bs.select', function() {
            console.log('Staff filter changed');
        });
        
        $('#activity-type-filter').on('changed.bs.select', function() {
            console.log('Activity type filter changed');
        });
    }
    
    // Sync main date filters with activity date filters
    document.getElementById('date-from').addEventListener('change', function() {
        document.getElementById('activity-date-from').value = this.value;
    });
    
    document.getElementById('date-to').addEventListener('change', function() {
        document.getElementById('activity-date-to').value = this.value;
    });
    
    // Sync activity date filters with main date filters
    document.getElementById('activity-date-from').addEventListener('change', function() {
        document.getElementById('date-from').value = this.value;
    });
    
    document.getElementById('activity-date-to').addEventListener('change', function() {
        document.getElementById('date-to').value = this.value;
    });
    
    // Date preset buttons
    document.querySelectorAll('.preset-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.preset-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            var preset = this.dataset.preset;
            var today = new Date();
            var fromDate, toDate;
            
            switch(preset) {
                case 'today':
                    fromDate = today.toISOString().split('T')[0];
                    toDate = today.toISOString().split('T')[0];
                    break;
                case 'week':
                    var dayOfWeek = today.getDay();
                    var diff = today.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1);
                    fromDate = new Date(today.setDate(diff)).toISOString().split('T')[0];
                    toDate = new Date().toISOString().split('T')[0];
                    break;
                case 'month':
                    fromDate = new Date(today.getFullYear(), today.getMonth(), 1).toISOString().split('T')[0];
                    toDate = new Date().toISOString().split('T')[0];
                    break;
            }
            
            document.getElementById('date-from').value = fromDate;
            document.getElementById('date-to').value = toDate;
            
            // Apply filters
            applyFilters();
        });
    });
    
    // Activity log date filter
    document.getElementById('activity-apply-filter').addEventListener('click', function() {
        var activityFilters = {
            from: document.getElementById('activity-date-from').value,
            to: document.getElementById('activity-date-to').value,
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
        };
        
        // Synchronize main date filters with activity log date filters
        if (activityFilters.from) {
            document.getElementById('date-from').value = activityFilters.from;
        }
        if (activityFilters.to) {
            document.getElementById('date-to').value = activityFilters.to;
        }
        
        // Apply all filters (this will reload everything including activity log)
        applyFilters();
    });
    
    // PDF export button
    document.getElementById('export-pdf').addEventListener('click', function() {
        var currentFilters = {
            from: document.getElementById('date-from').value,
            to: document.getElementById('date-to').value,
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
        };
        
        var pdfUrl = baseUrl + 'reporting_dashboard/download_pdf?' + new URLSearchParams(currentFilters);
        window.open(pdfUrl, '_blank');
    });
    
    // CSV export button
    document.getElementById('export-csv').addEventListener('click', function() {
        // Implement CSV export
        alert('CSV export functionality will be implemented here');
    });
    
    // Excel export button
    document.getElementById('export-excel').addEventListener('click', function() {
        // Implement Excel export
        alert('Excel export functionality will be implemented here');
    });
    
    // Print button
    document.getElementById('export-print').addEventListener('click', function() {
        window.print();
    });
    
    // Table export buttons
    document.getElementById('table-export-csv').addEventListener('click', function() {
        // Implement table CSV export
        alert('Table CSV export functionality will be implemented here');
    });
    
    document.getElementById('table-export-excel').addEventListener('click', function() {
        // Implement table Excel export
        alert('Table Excel export functionality will be implemented here');
    });
}

// Initialize when document is ready - with jQuery safety
(function() {
    'use strict';
    
    var initAttempts = 0;
    var maxAttempts = 50; // 5 seconds maximum wait
    
    function waitForJQuery() {
        initAttempts++;
        
        if (typeof jQuery !== 'undefined' && jQuery.fn && jQuery.fn.jquery) {
            console.log('[Reporting Dashboard] jQuery available after', initAttempts, 'attempts, version:', jQuery.fn.jquery);
            jQuery(document).ready(function($) {
                initializeDashboard($);
            });
            return;
        }
        
        if (initAttempts >= maxAttempts) {
            console.error('[Reporting Dashboard] jQuery not available after', maxAttempts, 'attempts');
            // Try to initialize with basic JavaScript
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    initializeDashboard(null);
                });
            } else {
                initializeDashboard(null);
            }
            return;
        }
        
        setTimeout(waitForJQuery, 100);
    }
    
    function initializeDashboard($) {
        console.log('[Reporting Dashboard] Document ready, initializing...');
        
        // Debug: Staff list data passed from PHP
        var staffListData = <?php echo json_encode($staff_list ?? []); ?>;
        var canViewAllStaff = <?php echo json_encode($can_view_all_staff ?? false); ?>;
        var userStaffId = <?php echo json_encode($user_staff_id ?? 0); ?>;
        console.log('[Reporting Dashboard] Staff list data:', staffListData);
        console.log('[Reporting Dashboard] Can view all staff:', canViewAllStaff);
        console.log('[Reporting Dashboard] Current user staff ID:', userStaffId);
        
        if (!$ && typeof jQuery !== 'undefined') {
            $ = jQuery;
        }
        
        // Initialize date pickers (simplified for HTML5 date inputs)
        function initializeDatePickers() {
            console.log('[Reporting Dashboard] Initializing date pickers...');
            
            // If jQuery is not available, use vanilla JavaScript fallback
            if (!$) {
                var dateInputs = document.querySelectorAll('#date-from, #date-to, #activity-date-from, #activity-date-to');
                for (var i = 0; i < dateInputs.length; i++) {
                    dateInputs[i].type = 'date';
                }
                return dateInputs.length > 0;
            }
            
            try {
                // Since we're using HTML5 date inputs, just ensure they're properly set up
                var dateInputs = $('#date-from, #date-to, #activity-date-from, #activity-date-to');
                dateInputs.attr('type', 'date');
                
                // Optional: Try to enhance with Bootstrap datepicker if available
                if ($.fn.datepicker && dateInputs.hasClass('datepicker')) {
                console.log('[Reporting Dashboard] Enhancing with Bootstrap datepicker');
                $('.datepicker').datepicker({
                    format: 'yyyy-mm-dd',
                    autoclose: true,
                    todayHighlight: true,
                    clearBtn: true,
                    orientation: 'bottom auto'
                });
            }
            
            console.log('[Reporting Dashboard] Date inputs initialized successfully');
            return true;
        } catch (error) {
            console.error('[Reporting Dashboard] Date picker initialization failed:', error);
            // Ensure HTML5 date inputs as fallback
            $('#date-from, #date-to, #activity-date-from, #activity-date-to').attr('type', 'date');
            return true;
        }
    }
    
    // Initialize selectpicker dropdowns using multiple methods
    function initializeDropdowns() {
        console.log('[Reporting Dashboard] Initializing dropdowns...');
        
        try {
            // Method 1: Manual Bootstrap Select initialization (more reliable)
            if ($.fn.selectpicker) {
                console.log('[Reporting Dashboard] Using direct selectpicker initialization');
                
                // Destroy any existing instances first
                $('#staff-filter, #activity-type-filter').selectpicker('destroy');
                
                // Set Bootstrap version manually to avoid detection issues
                if ($.fn.selectpicker.Constructor && !$.fn.selectpicker.Constructor.BootstrapVersion) {
                    $.fn.selectpicker.Constructor.BootstrapVersion = '3.3.7';
                }
                
                // Initialize staff filter
                $('#staff-filter').selectpicker({
                    liveSearch: true,
                    actionsBox: true,
                    noneSelectedText: 'Select Staff Members',
                    selectAllText: 'Select All',
                    deselectAllText: 'Deselect All',
                    countSelectedText: function(numSelected, numTotal) {
                        return numSelected + ' of ' + numTotal + ' selected';
                    },
                    style: 'btn-default',
                    size: 10
                });
                
                // Initialize activity type filter  
                $('#activity-type-filter').selectpicker({
                    noneSelectedText: 'Select Activity Types',
                    countSelectedText: function(numSelected, numTotal) {
                        return numSelected + ' of ' + numTotal + ' selected';
                    },
                    style: 'btn-default',
                    size: 10
                });
                
                console.log('[Reporting Dashboard] Direct selectpicker initialization successful');
                return true;
            }
        } catch (error) {
            console.warn('[Reporting Dashboard] Direct selectpicker failed:', error);
        }
        
        try {
            // Method 2: Try Perfex's init_selectpicker function as fallback
            if (typeof init_selectpicker === 'function') {
                console.log('[Reporting Dashboard] Trying Perfex init_selectpicker as fallback');
                init_selectpicker();
                console.log('[Reporting Dashboard] Perfex init_selectpicker successful');
                return true;
            }
        } catch (error) {
            console.warn('[Reporting Dashboard] Perfex init_selectpicker failed:', error);
        }
        
        // Method 3: Fallback - ensure dropdowns are at least functional
        console.warn('[Reporting Dashboard] Using fallback dropdown initialization');
        $('#staff-filter, #activity-type-filter').addClass('form-control');
        
        return false;
    }
    
    // Initialize both date pickers and dropdowns
    var datePickersInitialized = initializeDatePickers();
    var dropdownsInitialized = initializeDropdowns();
    
    // Set initial date values
    function setInitialDates() {
        var today = new Date();
        var firstDay = new Date(today.getFullYear(), today.getMonth(), 1);
        var todayStr = today.toISOString().split('T')[0];
        var firstDayStr = firstDay.toISOString().split('T')[0];
        
        // Set main filter dates
        $('#date-from').val(firstDayStr);
        $('#date-to').val(todayStr);
        
        // Set activity log filter dates
        $('#activity-date-from').val(firstDayStr);
        $('#activity-date-to').val(todayStr);
        
        console.log('[Reporting Dashboard] Initial dates set:', firstDayStr, 'to', todayStr);
    }
    
    // Set dates after a brief delay to ensure elements are ready
    setTimeout(setInitialDates, 100);
    
    // Add change event handlers for dropdowns
    $('#staff-filter').on('changed.bs.select change', function() {
        console.log('[Reporting Dashboard] Staff filter changed');
    });
    
    $('#activity-type-filter').on('changed.bs.select change', function() {
        console.log('[Reporting Dashboard] Activity type filter changed'); 
    });
    
    // Add change event handlers for date inputs
    $('#date-from, #date-to').on('change changeDate', function() {
        console.log('[Reporting Dashboard] Date filter changed');
    });
    
    // Add diagnostic information to console
    setTimeout(function() {
        console.log('[Reporting Dashboard] DIAGNOSTIC INFO:');
        console.log('- jQuery available:', typeof $ !== 'undefined');
        console.log('- jQuery version:', typeof $ !== 'undefined' ? $.fn.jquery : 'N/A');
        console.log('- Bootstrap Select available:', typeof $ !== 'undefined' && $.fn.selectpicker);
        console.log('- Datepicker available:', typeof $ !== 'undefined' && $.fn.datepicker);
        console.log('- appDatepicker function available:', typeof appDatepicker === 'function');
        console.log('- init_selectpicker function available:', typeof init_selectpicker === 'function');
        console.log('- Staff filter element exists:', $('#staff-filter').length > 0);
        console.log('- Activity filter element exists:', $('#activity-type-filter').length > 0);
        console.log('- Date from element exists:', $('#date-from').length > 0);
        console.log('- Date to element exists:', $('#date-to').length > 0);
        console.log('- Staff options count:', $('#staff-filter option').length);
        console.log('- Activity options count:', $('#activity-type-filter option').length);
        
        // Check if elements are properly initialized
        var staffBootstrap = $('#staff-filter').parent().hasClass('bootstrap-select');
        var activityBootstrap = $('#activity-type-filter').parent().hasClass('bootstrap-select');
        console.log('- Staff filter has bootstrap-select wrapper:', staffBootstrap);
        console.log('- Activity filter has bootstrap-select wrapper:', activityBootstrap);
        
        // Check date picker initialization
        var dateFromInit = $('#date-from').hasClass('hasDatepicker') || $('#date-from').attr('type') === 'date';
        var dateToInit = $('#date-to').hasClass('hasDatepicker') || $('#date-to').attr('type') === 'date';
        console.log('- Date from initialized:', dateFromInit);
        console.log('- Date to initialized:', dateToInit);
        
        // Retry initialization if needed
        if (!staffBootstrap || !activityBootstrap) {
            console.warn('[Reporting Dashboard] Dropdowns not properly initialized, retrying...');
            setTimeout(function() {
                initializeDropdowns();
            }, 500);
        }
        
        if (!dateFromInit || !dateToInit) {
            console.warn('[Reporting Dashboard] Date pickers not properly initialized, retrying...');
            setTimeout(function() {
                initializeDatePickers();
            }, 500);
        }
    }, 1000);
    
    // Wait a moment for everything to settle, then initialize charts and data
    setTimeout(function() {
        // Initialize charts if Chart.js is available
        if (typeof Chart !== 'undefined') {
            loadCharts(baseUrl, {});
        } else {
            console.error('[Reporting Dashboard] Chart.js not loaded');
        }
        
        // Load initial data
        applyFilters();
        
        // Set up event listeners
        setupEventListeners();
        
        // Force table render
        setTimeout(function() {
            forceTableRender();
        }, 1000);
        
    }, 1500);
    
    } // End initializeDashboard function
    
    // Start waiting for jQuery
    waitForJQuery();
})();
</script>

<?php init_tail(); ?>
