<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Simple test page for dropdown functionality
require_once(__DIR__ . '/../../application/config/config.php');
?>
<!DOCTYPE html>
<html>
<head>
    <title>Dropdown Test - Reporting Dashboard</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Load Perfex CRM's standard assets -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/bootstrap-select/css/bootstrap-select.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    
    <script src="<?php echo base_url(); ?>assets/js/jquery/jquery.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
    <script src="<?php echo base_url(); ?>assets/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>
</head>
<body>
    <div class="container" style="margin-top: 50px;">
        <div class="panel panel-default">
            <div class="panel-heading">
                <h3 class="panel-title">Dropdown Functionality Test</h3>
            </div>
            <div class="panel-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Staff Filter Test:</label>
                            <select id="test-staff-filter" class="form-control selectpicker" data-live-search="true" data-actions-box="true" multiple>
                                <option value="1">John Doe</option>
                                <option value="2">Jane Smith</option>
                                <option value="3">Bob Johnson</option>
                                <option value="4">Alice Wilson</option>
                                <option value="5">Charlie Brown</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Activity Type Filter Test:</label>
                            <select id="test-activity-filter" class="form-control selectpicker" multiple>
                                <option value="Lead">Lead Activities</option>
                                <option value="Task">Tasks</option>
                                <option value="Project">Projects</option>
                                <option value="Invoice">Invoices</option>
                                <option value="Auth">Login/Logout</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <button id="test-btn" class="btn btn-primary">Test Selection</button>
                        <button id="refresh-btn" class="btn btn-default">Refresh Dropdowns</button>
                        <button id="check-status" class="btn btn-info">Check Status</button>
                    </div>
                </div>
                
                <div id="result" style="margin-top: 20px; padding: 10px; background: #f5f5f5; border-radius: 4px;">
                    <strong>Results will appear here...</strong>
                </div>
                
                <div id="debug-info" style="margin-top: 20px; padding: 10px; background: #e7e7e7; border-radius: 4px;">
                    <strong>Debug Information:</strong>
                    <div id="debug-content"></div>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            console.log('Document ready');
            
            function updateDebugInfo() {
                var debugInfo = [];
                debugInfo.push('jQuery version: ' + $.fn.jquery);
                debugInfo.push('Bootstrap Select available: ' + ($.fn.selectpicker ? 'Yes' : 'No'));
                debugInfo.push('Staff options count: ' + $('#test-staff-filter option').length);
                debugInfo.push('Activity options count: ' + $('#test-activity-filter option').length);
                
                $('#debug-content').html('<ul><li>' + debugInfo.join('</li><li>') + '</li></ul>');
            }
            
            // Initialize selectpicker
            function initDropdowns() {
                if ($.fn.selectpicker) {
                    $('.selectpicker').selectpicker({
                        liveSearch: true,
                        actionsBox: true
                    });
                    console.log('Selectpicker initialized');
                    updateDebugInfo();
                } else {
                    console.error('Bootstrap Select not available');
                    updateDebugInfo();
                }
            }
            
            // Initialize on load
            initDropdowns();
            
            // Test button click
            $('#test-btn').click(function() {
                var staffSelected = $('#test-staff-filter').val();
                var activitySelected = $('#test-activity-filter').val();
                
                var result = '<strong>Selected Values:</strong><br>';
                result += 'Staff: ' + JSON.stringify(staffSelected) + '<br>';
                result += 'Activity Types: ' + JSON.stringify(activitySelected);
                
                $('#result').html(result);
                console.log('Staff Selected:', staffSelected);
                console.log('Activity Selected:', activitySelected);
            });
            
            // Refresh button
            $('#refresh-btn').click(function() {
                console.log('Refreshing dropdowns...');
                $('.selectpicker').selectpicker('destroy');
                setTimeout(function() {
                    initDropdowns();
                }, 100);
            });
            
            // Check status button
            $('#check-status').click(function() {
                updateDebugInfo();
            });
            
            // Test change events
            $('#test-staff-filter').on('changed.bs.select', function() {
                console.log('Staff selection changed');
            });
            
            $('#test-activity-filter').on('changed.bs.select', function() {
                console.log('Activity selection changed');
            });
        });
    </script>
</body>
</html>
