/**
 * Direct API Helper for Reporting Dashboard
 * Handles CSRF tokens and API requests
 */

(function() {
    'use strict';
    
    console.log('[Direct API] Loading...');
    
    // Simple helper to add CSRF tokens to requests
    window.addCSRFToData = function(data) {
        if (typeof csrf_token_name !== 'undefined' && typeof csrf_hash !== 'undefined') {
            data = data || {};
            data[csrf_token_name] = csrf_hash;
        }
        return data;
    };
    
    // Simple helper for safe fetch with CSRF
    window.safeFetch = function(url, options) {
        options = options || {};
        
        if (options.method === 'POST' && options.body) {
            if (options.body instanceof URLSearchParams) {
                var data = {};
                for (var pair of options.body.entries()) {
                    data[pair[0]] = pair[1];
                }
                data = window.addCSRFToData(data);
                options.body = new URLSearchParams(data);
            }
        }
        
        return fetch(url, options);
    };
    
    console.log('[Direct API] Loaded successfully');
})();
