<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
<style>
/* Fix for activity log table display */
#activity-log-table {
    width: 100% !important;
    table-layout: auto !important;
    display: table !important;
    visibility: visible !important;
}

.table-responsive {
    overflow-x: auto;
    clear: both;
    display: block !important;
    min-height: 200px;
}

/* Ensure table shows immediately */
#activity-log-table tbody {
    display: table-row-group !important;
}

#activity-log-table thead {
    display: table-header-group !important;
}

/* Ensure proper spacing */
.reporting-dashboard .panel_s {
    margin-bottom: 20px;
}

/* Fix for date filter form */
.form-inline .form-group {
    display: inline-block;
    margin-bottom: 0;
    vertical-align: middle;
}

/* Reminder count badges */
.panel-title .badge {
    font-size: 11px;
    margin-left: 8px;
    padding: 3px 7px;
    border-radius: 10px;
    font-weight: 600;
}

.badge-warning {
    background-color: #f39c12;
    color: white;
}

.badge-danger {
    background-color: #e74c3c;
    color: white;
}

.badge-info {
    background-color: #3498db;
    color: white;
}

/* Ensure buttons don't break layout */
.btn-group-sm > .btn {
    white-space: nowrap;
}

/* Fix clearfix issues */
.clearfix::after {
    content: "";
    display: table;
    clear: both;
}
</style>
<div id="wrapper">
  <div class="content reporting-dashboard">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <div class="clearfix">
              <div class="pull-left">
                <h4 class="tw-font-semibold tw-text-lg tw-text-neutral-800"><?= _l('Reporting Dashboard'); ?></h4>
              </div>
              <div class="pull-right">
                <div class="btn-group">
                  <button id="export-pdf" class="btn btn-danger btn-sm"><i class="fa fa-file-pdf-o"></i> Download PDF</button>
                  <button id="export-csv" class="btn btn-default btn-sm"><i class="fa fa-download"></i> CSV</button>
                  <button id="export-excel" class="btn btn-default btn-sm"><i class="fa fa-file-excel-o"></i> Excel</button>
                  <button id="export-print" class="btn btn-default btn-sm"><i class="fa fa-print"></i> Print</button>
                </div>
              </div>
            </div>
            <hr class="mtop15 mbot15">

            <!-- Filters -->
            <div class="panel_s">
              <div class="panel-body">
                <h5 class="tw-font-medium tw-text-neutral-800 tw-mb-3"><?= _l('Filters'); ?></h5>
                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Date Range'); ?></label>
                      <div class="btn-group btn-group-sm mbot10" style="display: block;">
                        <button type="button" class="btn btn-default preset-btn" data-preset="today">Today</button>
                        <button type="button" class="btn btn-default preset-btn" data-preset="week">This Week</button>
                        <button type="button" class="btn btn-default preset-btn active" data-preset="month">This Month</button>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <input type="text" class="form-control datepicker" id="date-from" placeholder="From" autocomplete="off">
                        </div>
                        <div class="col-md-6">
                          <input type="text" class="form-control datepicker" id="date-to" placeholder="To" autocomplete="off">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Staff'); ?></label>
                      <select id="staff-filter" class="form-control selectpicker" data-live-search="true" data-actions-box="true" multiple>
                        <?php if (!empty($staff_list)) : foreach ($staff_list as $s): ?>
                          <option value="<?= (int)$s['staffid']; ?>"><?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?></option>
                        <?php endforeach; endif; ?>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Activity Type'); ?></label>
                      <select id="activity-type-filter" class="form-control selectpicker" multiple>
                        <option value="Lead" selected>Lead Activities</option>
                        <option value="Task">Tasks</option>
                        <option value="Project">Projects</option>
                        <option value="Invoice">Invoices</option>
                        <option value="Auth">Login/Logout</option>
                        <option value="Other">Other</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="control-label">&nbsp;</label>
                      <button id="apply-filters" class="btn btn-primary btn-block"><i class="fa fa-filter"></i> <?= _l('Apply'); ?></button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- KPIs -->
            <div class="row mtop20">
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-primary">
                      <i class="fa fa-calendar fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-today">0</h3>
                    <p class="text-muted mbot0">Activities Today</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-success">
                      <i class="fa fa-calendar-check-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-week">0</h3>
                    <p class="text-muted mbot0">This Week</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-info">
                      <i class="fa fa-calendar-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-month">0</h3>
                    <p class="text-muted mbot0">This Month</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-warning">
                      <i class="fa fa-sign-in fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-logins">0</h3>
                    <p class="text-muted mbot0">Logins Today</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- Charts -->
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities by Staff</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities Over Time</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesOverTimeChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activity Type Distribution</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activityTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-users"></i> Top Active Staff</h5>
                    <div id="top-staff-list">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Staff Performance Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bar-chart"></i> Staff Performance by Activity Type</h5>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="staffPerformanceChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Follow-up Types Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">
                      <i class="fa fa-phone text-success"></i> Follow-up Types by Staff
                    </h5>
                    <p class="text-muted">Shows the breakdown of different follow-up types (calls, WhatsApp, emails, meetings, etc.) performed by each staff member in the selected date range.</p>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="followupTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Reminders & Followups Section -->
            <div class="row mtop20">
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bell text-warning"></i> Today's Reminders</h5>
                    <div id="todays-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders</h5>
                    <div id="due-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-calendar text-info"></i> Upcoming Reminders</h5>
                    <div id="upcoming-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Activity Log Table -->
            <div class="panel_s mtop20">
              <div class="panel-body">
                <div class="clearfix">
                  <div class="pull-left">
                    <h5 class="panel-title">Detailed Activity Log</h5>
                  </div>
                  <div class="pull-right">
                    <div class="btn-group btn-group-sm">
                      <button class="btn btn-default" id="table-export-csv"><i class="fa fa-download"></i> CSV</button>
                      <button class="btn btn-default" id="table-export-excel"><i class="fa fa-file-excel-o"></i> Excel</button>
                    </div>
                  </div>
                </div>
                <div class="row mtop10">
                  <div class="col-md-12">
                    <div class="form-inline pull-right">
                      <div class="form-group">
                        <label for="activity-date-from" style="margin-right: 5px;">From:</label>
                        <input type="date" id="activity-date-from" class="form-control input-sm" style="width: 140px;">
                      </div>
                      <div class="form-group" style="margin-left: 10px;">
                        <label for="activity-date-to" style="margin-right: 5px;">To:</label>
                        <input type="date" id="activity-date-to" class="form-control input-sm" style="width: 140px;">
                      </div>
                      <button type="button" id="activity-apply-filter" class="btn btn-primary btn-sm" style="margin-left: 10px;">
                        <i class="fa fa-filter"></i> Filter
                      </button>
                    </div>
                  </div>
                </div>
                <hr class="mtop15 mbot15">
                <div class="table-responsive">
                  <table id="activity-log-table" class="table table-striped table-bordered dt-table">
                    <thead>
                      <tr>
                        <th><?= _l('Date & Time'); ?></th>
                        <th><?= _l('Staff Member'); ?></th>
                        <th><?= _l('Activity Type'); ?></th>
                        <th><?= _l('Related Entity'); ?></th>
                        <th><?= _l('Description'); ?></th>
                        <th><?= _l('IP Address'); ?></th>
                        <th><?= _l('Actions'); ?></th>
                      </tr>
                    </thead>
                    <tbody></tbody>
                  </table>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Debug Panel (remove in production) -->
<div class="panel_s mtop20" id="debug-panel" style="display: none;">
  <div class="panel-body">
    <h5>Debug Information</h5>
    <div id="debug-content">
      <p><strong>Button Status:</strong> <span id="debug-button-status">Not checked</span></p>
      <p><strong>Last Click:</strong> <span id="debug-last-click">None</span></p>
      <p><strong>Current Filters:</strong> <span id="debug-filters">None</span></p>
      <p><strong>AJAX URLs:</strong> <span id="debug-urls">None</span></p>
      <p><strong>Last Error:</strong> <span id="debug-error">None</span></p>
    </div>
    <button id="toggle-debug" class="btn btn-warning btn-sm">Hide Debug</button>
    <button id="test-ajax" class="btn btn-info btn-sm">Test AJAX</button>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="rdLogModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Log Details</h4>
      </div>
      <div class="modal-body" id="rd-log-details">
        <div class="text-center"><i class="fa fa-spinner fa-spin"></i></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
      </div>
    </div>
  </div>
</div>

<script>
// Debug script - inline to ensure it loads
window.reportingDashboardDebug = {
    log: function(message, data) {
        console.log('[RD Debug]', message, data || '');
        var debugContent = document.getElementById('debug-content');
        if (debugContent) {
            var time = new Date().toLocaleTimeString();
            debugContent.innerHTML += '<br><small>' + time + ': ' + message + (data ? ' - ' + JSON.stringify(data) : '') + '</small>';
        }
    },
    updateStatus: function(field, value) {
        var element = document.getElementById('debug-' + field);
        if (element) {
            element.textContent = value;
        }
    }
};

// Show debug panel by default for troubleshooting
// Function to force table rendering
// Add safeguard to prevent multiple simultaneous renders
var isTableRendering = false;

function forceTableRender() {
    if (isTableRendering) {
        console.log('Table render already in progress, skipping...');
        return;
    }
    
    isTableRendering = true;
    
    var table = document.getElementById('activity-log-table');
    var container = document.querySelector('.table-responsive');
    
    if (table && container) {
        // Force visibility
        table.style.display = 'table';
        table.style.visibility = 'visible';
        container.style.display = 'block';
        
        // Force reflow
        table.offsetHeight;
        container.offsetHeight;
        
        console.log('Table rendering completed');
    }
    
    // Reset the flag after a short delay
    setTimeout(function() {
        isTableRendering = false;
    }, 500);
}

// Wait for Chart.js to load
setTimeout(function() {
    console.log('Chart.js available:', typeof Chart !== 'undefined');
    
    if (typeof Chart === 'undefined') {
        console.error('Chart.js is not loaded! Charts will not work.');
        document.getElementById('debug-panel').style.display = 'block';
        var debugContent = document.getElementById('debug-content');
        if (debugContent) {
            debugContent.innerHTML += '<div style="color: red;"><strong>ERROR:</strong> Chart.js not loaded!</div>';
        }
        return;
    }
    
    document.getElementById('debug-panel').style.display = 'block';
    
    // Force table render after a short delay
    setTimeout(forceTableRender, 500);
    
    document.getElementById('toggle-debug').addEventListener('click', function() {
        var panel = document.getElementById('debug-panel');
        if (panel.style.display === 'none') {
            panel.style.display = 'block';
            this.textContent = 'Hide Debug';
        } else {
            panel.style.display = 'none';
            this.textContent = 'Show Debug';
        }
    });
    
    document.getElementById('test-ajax').addEventListener('click', function() {
        var baseUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/';
        var testUrl = baseUrl + 'reporting_dashboard/debug';
        
        window.reportingDashboardDebug.log('Testing AJAX to: ' + testUrl);
        
        fetch(testUrl)
            .then(response => response.text())
            .then(data => {
                window.reportingDashboardDebug.log('AJAX Test Success', 'Response length: ' + data.length);
                window.reportingDashboardDebug.updateStatus('error', 'AJAX test passed');
            })
            .catch(error => {
                window.reportingDashboardDebug.log('AJAX Test Failed', error.message);
                window.reportingDashboardDebug.updateStatus('error', error.message);
            });
    });
    
    // Add manual apply button test
    var manualTestBtn = document.createElement('button');
    manualTestBtn.textContent = 'Manual Apply Test';
    manualTestBtn.className = 'btn btn-success btn-sm';
    manualTestBtn.style.marginLeft = '10px';
    manualTestBtn.addEventListener('click', function() {
        window.reportingDashboardDebug.log('Manual apply button test triggered');
        
        // Try to find and trigger the apply button
        var applyBtn = document.getElementById('apply-filters');
        if (applyBtn) {
            window.reportingDashboardDebug.log('Found apply button, triggering click');
            applyBtn.click();
        } else {
            window.reportingDashboardDebug.log('Apply button not found!');
        }
    });
    
    // Add the manual test button next to other buttons
    document.getElementById('test-ajax').parentNode.appendChild(manualTestBtn);
    
    window.reportingDashboardDebug.log('Debug panel initialized');
    
                // Function to load all charts
            function loadCharts(baseUrl, filters) {
                // Load Activities by Staff Chart
                fetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => {
                    window.reportingDashboardDebug.log('Activities by staff response status:', response.status);
                    return response.text();
                })
                .then(text => {
                    window.reportingDashboardDebug.log('Activities by staff raw response:', text.substring(0, 200));
                    var chartData = JSON.parse(text);
                    window.reportingDashboardDebug.log('Activities by staff parsed data:', chartData);
                    
                    var ctx1 = document.getElementById('activitiesChart');
                    if (ctx1 && chartData.chart_data) {
                        if (window.activitiesChart && typeof window.activitiesChart.destroy === 'function') {
                            window.activitiesChart.destroy();
                        }
                        
                        if (typeof Chart === 'undefined') {
                            window.reportingDashboardDebug.log('Chart.js not available - cannot create chart');
                            return;
                        }
                        
                        window.reportingDashboardDebug.log('Creating activities by staff chart...');
                        window.activitiesChart = new Chart(ctx1, {
                            type: 'bar',
                            data: chartData.chart_data,
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                scales: {
                                    yAxes: [{
                                        ticks: { beginAtZero: true }
                                    }]
                                },
                                legend: { display: true }
                            }
                        });
                        window.reportingDashboardDebug.log('Activities by staff chart created successfully!');
                    } else {
                        window.reportingDashboardDebug.log('Missing canvas or chart data for activities by staff');
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Activities by staff chart failed', error.message);
                    console.error('Activities by staff chart error:', error);
                });
                
                // Load Activities Over Time Chart
                fetch(baseUrl + 'reporting_dashboard/get_activity_over_time_chart', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => response.text())
                .then(text => {
                    window.reportingDashboardDebug.log('Activities over time raw response:', text.substring(0, 200));
                    var chartData = JSON.parse(text);
                    window.reportingDashboardDebug.log('Activities over time parsed data:', chartData);
                    
                    var ctx2 = document.getElementById('activitiesOverTimeChart');
                    if (ctx2 && chartData.chart_data) {
                        if (window.activitiesOverTimeChart && typeof window.activitiesOverTimeChart.destroy === 'function') {
                            window.activitiesOverTimeChart.destroy();
                        }
                        window.activitiesOverTimeChart = new Chart(ctx2, {
                            type: 'line',
                            data: chartData.chart_data,
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                scales: {
                                    yAxes: [{
                                        ticks: { beginAtZero: true }
                                    }]
                                },
                                legend: { display: true }
                            }
                        });
                        window.reportingDashboardDebug.log('Activities over time chart created successfully!');
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Activities over time chart failed', error.message);
                    console.error('Activities over time chart error:', error);
                });
                
                // Load Activity Types Chart
                fetch(baseUrl + 'reporting_dashboard/get_activity_type_pie', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => response.text())
                .then(text => {
                    window.reportingDashboardDebug.log('Activity types raw response:', text.substring(0, 200));
                    var chartData = JSON.parse(text);
                    window.reportingDashboardDebug.log('Activity types parsed data:', chartData);
                    
                    var ctx3 = document.getElementById('activityTypesChart');
                    if (ctx3 && chartData.chart_data) {
                        if (window.activityTypesChart && typeof window.activityTypesChart.destroy === 'function') {
                            window.activityTypesChart.destroy();
                        }
                        window.activityTypesChart = new Chart(ctx3, {
                            type: 'pie',
                            data: chartData.chart_data,
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                legend: { 
                                    display: true,
                                    position: 'right'
                                }
                            }
                        });
                        window.reportingDashboardDebug.log('Activity types chart created successfully!');
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Activity types chart failed', error.message);
                    console.error('Activity types chart error:', error);
                });
                
                // Load Reminders data
                fetch(baseUrl + 'reporting_dashboard/get_reminders', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => response.json())
                .then(data => {
                    // Update reminder section headings with counts
                    if (data.counts) {
                        // Find and update Today's Reminders heading
                        var todayHeading = document.querySelector('#todays-reminders').parentNode.querySelector('h5');
                        if (todayHeading) {
                            todayHeading.innerHTML = '<i class="fa fa-bell text-warning"></i> Today\'s Reminders <span class="badge badge-warning">' + data.counts.today + '</span>';
                        }
                        
                        // Find and update Due Reminders heading
                        var dueHeading = document.querySelector('#due-reminders').parentNode.querySelector('h5');
                        if (dueHeading) {
                            dueHeading.innerHTML = '<i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders <span class="badge badge-danger">' + data.counts.due + '</span>';
                        }
                        
                        // Find and update Upcoming Reminders heading
                        var upcomingHeading = document.querySelector('#upcoming-reminders').parentNode.querySelector('h5');
                        if (upcomingHeading) {
                            upcomingHeading.innerHTML = '<i class="fa fa-calendar text-info"></i> Upcoming Reminders <span class="badge badge-info">' + data.counts.upcoming + '</span>';
                        }
                    }
                    
                    // Today's reminders
                    var todayDiv = document.getElementById('todays-reminders');
                    if (data.todays_reminders && data.todays_reminders.length > 0) {
                        var todayHtml = '';
                        data.todays_reminders.forEach(function(reminder) {
                            todayHtml += '<div class="reminder-item clickable-reminder" data-reminder-id="' + reminder.id + '" data-rel-type="' + reminder.rel_type + '" data-rel-id="' + reminder.rel_id + '" style="border-left: 3px solid #f39c12; padding: 8px; margin-bottom: 5px; background: #fff9f0; cursor: pointer; transition: background-color 0.3s;" onmouseover="this.style.backgroundColor=\'#fff4e0\'" onmouseout="this.style.backgroundColor=\'#fff9f0\'" onclick="viewReminderDetails(' + reminder.id + ', \'' + reminder.rel_type + '\', ' + reminder.rel_id + ')">';
                            todayHtml += '<div style="font-size: 12px; color: #666;"><i class="fa fa-clock-o"></i> ' + reminder.time + ' - ' + reminder.staff_name + '</div>';
                            todayHtml += '<div style="font-weight: bold; color: #333;"><i class="fa fa-bell"></i> ' + reminder.related_name + '</div>';
                            todayHtml += '<div style="font-size: 11px; color: #777;">' + reminder.description.substring(0, 50) + '...</div>';
                            todayHtml += '<div style="font-size: 10px; color: #999; margin-top: 3px;"><i class="fa fa-hand-pointer-o"></i> Click to view details</div>';
                            todayHtml += '</div>';
                        });
                        todayDiv.innerHTML = todayHtml;
                    } else {
                        todayDiv.innerHTML = '<div class="text-muted text-center">No reminders today</div>';
                    }
                    
                    // Due reminders
                    var dueDiv = document.getElementById('due-reminders');
                    if (data.due_reminders && data.due_reminders.length > 0) {
                        var dueHtml = '';
                        data.due_reminders.forEach(function(reminder) {
                            dueHtml += '<div class="reminder-item clickable-reminder" data-reminder-id="' + reminder.id + '" data-rel-type="' + reminder.rel_type + '" data-rel-id="' + reminder.rel_id + '" style="border-left: 3px solid #e74c3c; padding: 8px; margin-bottom: 5px; background: #fff0f0; cursor: pointer; transition: background-color 0.3s;" onmouseover="this.style.backgroundColor=\'#ffe0e0\'" onmouseout="this.style.backgroundColor=\'#fff0f0\'" onclick="viewReminderDetails(' + reminder.id + ', \'' + reminder.rel_type + '\', ' + reminder.rel_id + ')">';
                            dueHtml += '<div style="font-size: 12px; color: #666;"><i class="fa fa-exclamation-triangle"></i> ' + reminder.date + ' (' + reminder.days_overdue + ' days ago) - ' + reminder.staff_name + '</div>';
                            dueHtml += '<div style="font-weight: bold; color: #333;"><i class="fa fa-bell text-danger"></i> ' + reminder.related_name + '</div>';
                            dueHtml += '<div style="font-size: 11px; color: #777;">' + reminder.description.substring(0, 50) + '...</div>';
                            dueHtml += '<div style="font-size: 10px; color: #999; margin-top: 3px;"><i class="fa fa-hand-pointer-o"></i> Click to view details</div>';
                            dueHtml += '</div>';
                        });
                        dueDiv.innerHTML = dueHtml;
                    } else {
                        dueDiv.innerHTML = '<div class="text-muted text-center">No overdue reminders</div>';
                    }
                    
                    // Upcoming reminders
                    var upcomingDiv = document.getElementById('upcoming-reminders');
                    if (data.upcoming_reminders && data.upcoming_reminders.length > 0) {
                        var upcomingHtml = '';
                        data.upcoming_reminders.forEach(function(reminder) {
                            upcomingHtml += '<div class="reminder-item clickable-reminder" data-reminder-id="' + reminder.id + '" data-rel-type="' + reminder.rel_type + '" data-rel-id="' + reminder.rel_id + '" style="border-left: 3px solid #3498db; padding: 8px; margin-bottom: 5px; background: #f0f8ff; cursor: pointer; transition: background-color 0.3s;" onmouseover="this.style.backgroundColor=\'#e0f0ff\'" onmouseout="this.style.backgroundColor=\'#f0f8ff\'" onclick="viewReminderDetails(' + reminder.id + ', \'' + reminder.rel_type + '\', ' + reminder.rel_id + ')">';
                            upcomingHtml += '<div style="font-size: 12px; color: #666;"><i class="fa fa-calendar"></i> ' + reminder.date + ' ' + reminder.time + ' - ' + reminder.staff_name + '</div>';
                            upcomingHtml += '<div style="font-weight: bold; color: #333;"><i class="fa fa-bell text-info"></i> ' + reminder.related_name + '</div>';
                            upcomingHtml += '<div style="font-size: 11px; color: #777;">' + reminder.description.substring(0, 50) + '...</div>';
                            upcomingHtml += '<div style="font-size: 10px; color: #999; margin-top: 3px;"><i class="fa fa-hand-pointer-o"></i> Click to view details</div>';
                            upcomingHtml += '</div>';
                        });
                        upcomingDiv.innerHTML = upcomingHtml;
                    } else {
                        upcomingDiv.innerHTML = '<div class="text-muted text-center">No upcoming reminders</div>';
                    }
                })
                .catch(error => window.reportingDashboardDebug.log('Reminders load failed', error.message));
            }
            
            // Direct inline apply functionality as backup
            setTimeout(function() {
        var applyBtn = document.getElementById('apply-filters');
        if (applyBtn && !applyBtn.hasAttribute('data-initialized')) {
            window.reportingDashboardDebug.log('Setting up direct apply button handler');
            
            applyBtn.setAttribute('data-initialized', 'true');
            applyBtn.addEventListener('click', function(e) {
                e.preventDefault();
                window.reportingDashboardDebug.log('Direct apply button clicked');
                window.reportingDashboardDebug.updateStatus('last-click', new Date().toLocaleTimeString());
                
                // Get filter values directly
                var filters = {
                    from: document.getElementById('date-from').value || '',
                    to: document.getElementById('date-to').value || '',
                    staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(o => o.value),
                    activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(o => o.value)
                };
                
                window.reportingDashboardDebug.updateStatus('filters', JSON.stringify(filters));
                
                // Use proper module endpoints
                var baseUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/';
                var kpiUrl = baseUrl + 'reporting_dashboard/get_kpis';
                
                window.reportingDashboardDebug.log('Attempting to load KPIs from: ' + kpiUrl);
                window.reportingDashboardDebug.updateStatus('urls', kpiUrl);
                
                // Load KPIs
                fetch(kpiUrl, {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => {
                    window.reportingDashboardDebug.log('Response status: ' + response.status);
                    return response.text(); // Get as text first to see what we're getting
                })
                .then(text => {
                    window.reportingDashboardDebug.log('Raw response: ' + text.substring(0, 200) + '...');
                    
                    try {
                        var data = JSON.parse(text);
                        window.reportingDashboardDebug.log('KPIs parsed successfully', data);
                        
                        document.getElementById('kpi-today').textContent = data.today || 0;
                        document.getElementById('kpi-week').textContent = data.week || 0;
                        document.getElementById('kpi-month').textContent = data.month || 0;
                        document.getElementById('kpi-logins').textContent = data.logins_today || 0;
                        
                        // Update top staff
                        var topStaffEl = document.getElementById('top-staff-list');
                        var topStaffHtml = '';
                        if (data.top_staff && data.top_staff.length > 0) {
                            data.top_staff.forEach(function(staff) {
                                topStaffHtml += '<div class="staff-item">';
                                topStaffHtml += '<span class="staff-name">' + (staff.staff_name || 'Unknown') + '</span>';
                                topStaffHtml += '<span class="staff-count">' + (staff.total || 0) + '</span>';
                                topStaffHtml += '</div>';
                            });
                        } else {
                            topStaffHtml = '<div class="text-muted text-center">No data available</div>';
                        }
                        topStaffEl.innerHTML = topStaffHtml;
                        
                        window.reportingDashboardDebug.updateStatus('error', 'Direct load SUCCESS at ' + new Date().toLocaleTimeString());
                        
                        // Now load the charts
                        loadCharts(baseUrl, filters);
                        
                    } catch (parseError) {
                        window.reportingDashboardDebug.log('JSON parse failed', parseError.message);
                        window.reportingDashboardDebug.updateStatus('error', 'Parse error: ' + parseError.message);
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Direct KPI load failed', error.message);
                    window.reportingDashboardDebug.updateStatus('error', 'Fetch error: ' + error.message);
                });
                
                // Load activity log table
                fetch(baseUrl + 'reporting_dashboard/get_activity_table', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => response.json())
                .then(data => {
                    window.reportingDashboardDebug.log('Activity log loaded', data.data.length + ' entries');
                    
                    // Clear existing table body
                    var tbody = document.querySelector('#activity-log-table tbody');
                    if (!tbody) {
                        window.reportingDashboardDebug.log('ERROR: Activity table tbody not found!');
                        return;
                    }
                    
                    tbody.innerHTML = '';
                    window.reportingDashboardDebug.log('Activity table tbody cleared, populating with data...');
                    
                    // Populate table with enhanced data
                    if (data.data && data.data.length > 0) {
                        data.data.forEach(function(row) {
                            var tr = document.createElement('tr');
                            
                            // Create view button with link
                            var viewBtn = '<button class="btn btn-sm btn-default" onclick="window.open(\'/crm.ibrayagroup.com/' + row.view_link + '\', \'_blank\')">' +
                                         '<i class="fa fa-eye"></i></button>';
                            
                            // Enhanced activity type display with follow-up type information
                            var activityTypeDisplay = (row.action_icon || '') + ' ' + row.activity_type;
                            if (row.followup_type) {
                                activityTypeDisplay += ' <span class="label label-info" style="font-size: 10px; margin-left: 5px;">' + row.followup_type + '</span>';
                            }
                            
                            tr.innerHTML = 
                                '<td>' + row.date + '</td>' +
                                '<td>' + row.staff_name + '</td>' +
                                '<td>' + activityTypeDisplay + '</td>' +
                                '<td>' + row.related + '</td>' +
                                '<td>' + row.description + '</td>' +
                                '<td>-</td>' +
                                '<td>' + viewBtn + '</td>';
                            tbody.appendChild(tr);
                        });
                        window.reportingDashboardDebug.log('Activity table populated with ' + data.data.length + ' rows');
                        
                        // Force table to be visible and trigger reflow
                        var table = document.getElementById('activity-log-table');
                        if (table) {
                            table.style.display = 'table';
                            table.style.width = '100%';
                            
                            // Force browser reflow/repaint
                            table.offsetHeight; // Reading this property forces reflow
                            table.style.visibility = 'visible';
                            
                            // Trigger resize event to ensure responsive table works
                            window.dispatchEvent(new Event('resize'));
                        }
                        
                        // Also ensure the table container is visible
                        var tableContainer = document.querySelector('.table-responsive');
                        if (tableContainer) {
                            tableContainer.style.display = 'block';
                            tableContainer.style.overflow = 'auto';
                        }
                    } else {
                        tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted">No activity data found</td></tr>';
                        window.reportingDashboardDebug.log('No activity data found - showing empty message');
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Activity log load failed', error.message);
                });
                
                // Force table render after data loading
                setTimeout(function() {
                    forceTableRender();
                }, 200);
                
                // Load staff performance chart
                fetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => response.json())
                .then(data => {
                    window.reportingDashboardDebug.log('Staff performance data loaded', data);
                    
                    // Initialize or update staff performance chart
                    var ctx = document.getElementById('staffPerformanceChart');
                    if (ctx && data.chart_data) {
                        // Destroy existing chart if it exists
                        if (window.staffPerfChart && typeof window.staffPerfChart.destroy === 'function') {
                            window.staffPerfChart.destroy();
                        }
                        
                        // Convert datasets object to array for Chart.js compatibility
                        var datasets = [];
                        if (data.chart_data.datasets) {
                            Object.values(data.chart_data.datasets).forEach(function(dataset) {
                                datasets.push(dataset);
                            });
                        }
                        
                        var chartConfig = {
                            type: 'bar',
                            data: {
                                labels: data.chart_data.labels,
                                datasets: datasets
                            },
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                scales: {
                                    xAxes: [{
                                        stacked: true,
                                        scaleLabel: {
                                            display: true,
                                            labelString: 'Staff Members'
                                        }
                                    }],
                                    yAxes: [{
                                        stacked: true,
                                        ticks: {
                                            beginAtZero: true
                                        },
                                        scaleLabel: {
                                            display: true,
                                            labelString: 'Number of Activities'
                                        }
                                    }]
                                },
                                legend: {
                                    display: true,
                                    position: 'top'
                                },
                                tooltips: {
                                    mode: 'index',
                                    intersect: false
                                }
                            }
                        };
                        
                        window.staffPerfChart = new Chart(ctx, chartConfig);
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Staff performance load failed', error.message);
                });
                
                // Load follow-up types chart
                fetch(baseUrl + 'reporting_dashboard/get_followup_types_chart', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams(filters)
                })
                .then(response => response.json())
                .then(data => {
                    window.reportingDashboardDebug.log('Follow-up types data loaded', data);
                    
                    // Initialize or update follow-up types chart
                    var ctx = document.getElementById('followupTypesChart');
                    if (ctx && data.chart_data) {
                        // Destroy existing chart if it exists
                        if (window.followupTypesChart && typeof window.followupTypesChart.destroy === 'function') {
                            window.followupTypesChart.destroy();
                        }
                        
                        var chartConfig = {
                            type: 'bar',
                            data: {
                                labels: data.chart_data.labels,
                                datasets: data.chart_data.datasets
                            },
                            options: {
                                responsive: true,
                                maintainAspectRatio: false,
                                scales: {
                                    xAxes: [{
                                        stacked: true,
                                        scaleLabel: {
                                            display: true,
                                            labelString: 'Staff Members'
                                        }
                                    }],
                                    yAxes: [{
                                        stacked: true,
                                        ticks: {
                                            beginAtZero: true
                                        },
                                        scaleLabel: {
                                            display: true,
                                            labelString: 'Number of Follow-ups'
                                        }
                                    }]
                                },
                                legend: {
                                    display: true,
                                    position: 'top'
                                },
                                title: {
                                    display: true,
                                    text: 'Follow-up Types Distribution by Staff'
                                },
                                tooltips: {
                                    mode: 'index',
                                    intersect: false,
                                    callbacks: {
                                        label: function(tooltipItem, data) {
                                            var label = data.datasets[tooltipItem.datasetIndex].label || '';
                                            if (label) {
                                                label += ': ';
                                            }
                                            label += tooltipItem.yLabel + ' follow-ups';
                                            return label;
                                        }
                                    }
                                }
                            }
                        };
                        
                        window.followupTypesChart = new Chart(ctx, chartConfig);
                        window.reportingDashboardDebug.log('Follow-up types chart created successfully');
                    } else {
                        window.reportingDashboardDebug.log('Follow-up types chart: Missing canvas or data');
                    }
                })
                .catch(error => {
                    window.reportingDashboardDebug.log('Follow-up types load failed', error.message);
                });
            });
            
            window.reportingDashboardDebug.updateStatus('button-status', 'Direct handler attached');
            
            // Auto-trigger with this month data
            var today = new Date();
            var monthStart = new Date(today.getFullYear(), today.getMonth(), 1);
            
            document.getElementById('date-from').value = monthStart.toISOString().split('T')[0];
            document.getElementById('date-to').value = today.toISOString().split('T')[0];
            
            // Mark This Month as active
            document.querySelectorAll('.preset-btn').forEach(btn => btn.classList.remove('active'));
            document.querySelector('.preset-btn[data-preset="month"]').classList.add('active');
            
            // Auto-trigger apply
            setTimeout(function() {
                applyBtn.click();
            }, 200);
        }
    }, 200);
    
    // Date range preset button handlers
    document.querySelectorAll('.preset-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var preset = this.getAttribute('data-preset');
            var today = new Date();
            var fromDate, toDate;
            
            // Remove active class from all buttons
            document.querySelectorAll('.preset-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            switch(preset) {
                case 'today':
                    fromDate = new Date(today);
                    toDate = new Date(today);
                    break;
                case 'week':
                    var weekStart = new Date(today);
                    weekStart.setDate(today.getDate() - today.getDay()); // Start of this week (Sunday)
                    fromDate = weekStart;
                    toDate = new Date(today);
                    break;
                case 'month':
                    var monthStart = new Date(today.getFullYear(), today.getMonth(), 1);
                    fromDate = monthStart;
                    toDate = new Date(today);
                    break;
            }
            
            // Set date inputs
            if (fromDate && toDate) {
                document.getElementById('date-from').value = fromDate.toISOString().split('T')[0];
                document.getElementById('date-to').value = toDate.toISOString().split('T')[0];
                
                // Auto-trigger apply after a short delay
                setTimeout(function() {
                    var applyBtn = document.getElementById('apply-filters');
                    if (applyBtn) {
                        applyBtn.click();
                    }
                }, 300);
            }
        });
    });

    // Activity log date filter handler
    document.getElementById('activity-apply-filter').addEventListener('click', function() {
        var activityFrom = document.getElementById('activity-date-from').value;
        var activityTo = document.getElementById('activity-date-to').value;
        
        if (!activityFrom || !activityTo) {
            alert('Please select both from and to dates');
            return;
        }
        
        // Get current staff filter
        var staffFilter = Array.from(document.getElementById('staff-filter').selectedOptions).map(o => o.value);
        
        var activityFilters = {
            from: activityFrom,
            to: activityTo,
            staff: staffFilter,
            activity_type: ['Lead']
        };
        
        window.reportingDashboardDebug.log('Loading activity log with custom date range', activityFilters);
        
        var baseUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/';
        
        // Load activity log with custom date range
        fetch(baseUrl + 'reporting_dashboard/get_activity_table', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(activityFilters)
        })
        .then(response => response.json())
        .then(data => {
            window.reportingDashboardDebug.log('Custom activity log loaded', data.data.length + ' entries');
            
            // Clear existing table body
            var tbody = document.querySelector('#activity-log-table tbody');
            if (!tbody) {
                window.reportingDashboardDebug.log('ERROR: Activity table tbody not found in custom filter!');
                return;
            }
            
            tbody.innerHTML = '';
            
            // Populate table with enhanced data
            if (data.data && data.data.length > 0) {
                data.data.forEach(function(row) {
                    var tr = document.createElement('tr');
                    
                    // Create view button with link
                    var viewBtn = '<button class="btn btn-sm btn-default" onclick="window.open(\'/crm.ibrayagroup.com/' + row.view_link + '\', \'_blank\')">' +
                                 '<i class="fa fa-eye"></i></button>';
                    
                    // Enhanced activity type display with follow-up type information
                    var activityTypeDisplay = (row.action_icon || '') + ' ' + row.activity_type;
                    if (row.followup_type) {
                        activityTypeDisplay += ' <span class="label label-info" style="font-size: 10px; margin-left: 5px;">' + row.followup_type + '</span>';
                    }
                    
                    tr.innerHTML = 
                        '<td>' + row.date + '</td>' +
                        '<td>' + row.staff_name + '</td>' +
                        '<td>' + activityTypeDisplay + '</td>' +
                        '<td>' + row.related + '</td>' +
                        '<td>' + row.description + '</td>' +
                        '<td>-</td>' +
                        '<td>' + viewBtn + '</td>';
                    tbody.appendChild(tr);
                });
            } else {
                tbody.innerHTML = '<tr><td colspan="7" class="text-center text-muted">No activity data found for selected date range</td></tr>';
            }
        })
        .catch(error => {
            window.reportingDashboardDebug.log('Custom activity log load failed', error.message);
        });
    });
    
    // Initialize activity log date inputs with current month
    var today = new Date();
    var firstDay = new Date(today.getFullYear(), today.getMonth(), 1);
    var lastDay = new Date(today.getFullYear(), today.getMonth() + 1, 0);
    
    document.getElementById('activity-date-from').value = firstDay.toISOString().split('T')[0];
    document.getElementById('activity-date-to').value = today.toISOString().split('T')[0];
    
    // PDF Export handler
    document.getElementById('export-pdf').addEventListener('click', function() {
        var currentFilters = {
            from: document.getElementById('date-from').value || '',
            to: document.getElementById('date-to').value || '',
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(o => o.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(o => o.value)
        };
        
        // Build URL with current filters
        var baseUrl = window.location.origin + window.location.pathname;
        var pdfUrl = baseUrl + '/download_pdf';
        
        // Build query parameters
        var params = new URLSearchParams();
        if (currentFilters.from) params.append('from', currentFilters.from);
        if (currentFilters.to) params.append('to', currentFilters.to);
        if (currentFilters.staff.length > 0) {
            currentFilters.staff.forEach(function(staffId) {
                params.append('staff[]', staffId);
            });
        }
        if (currentFilters.activity_type.length > 0) {
            currentFilters.activity_type.forEach(function(actType) {
                params.append('activity_type[]', actType);
            });
        }
        
        // Add query parameters if any exist
        if (params.toString()) {
            pdfUrl += '?' + params.toString();
        }
        
        // Open in new window to download
        window.open(pdfUrl, '_blank');
        
        window.reportingDashboardDebug.log('PDF download initiated with filters', currentFilters);
    });

    // Remove the problematic resize listener that was causing infinite loops
    // Tables should render properly without forcing resize events
    
    // Initial table render only (no repeated renders)
    setTimeout(function() {
        forceTableRender();
        console.log('Initial table render completed');
    }, 1500);
    
}, 1000); // Wait 1 second for all libraries to load

// Function to view reminder details
function viewReminderDetails(reminderId, relType, relId) {
    console.log('Viewing reminder:', reminderId, relType, relId);
    
    // Determine the appropriate URL based on the related type
    var targetUrl = '';
    
    switch(relType) {
        case 'lead':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/leads/index/' + relId;
            break;
        case 'customer':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/clients/client/' + relId;
            break;
        case 'project':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/projects/view/' + relId;
            break;
        case 'task':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/tasks/view/' + relId;
            break;
        case 'invoice':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/invoices/list_invoices/' + relId;
            break;
        case 'estimate':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/estimates/list_estimates/' + relId;
            break;
        case 'proposal':
            targetUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/proposals/list_proposals/' + relId;
            break;
        default:
            // If we can't determine the type, try to show reminder details
            showReminderModal(reminderId);
            return;
    }
    
    // Open the related record in a new tab
    if (targetUrl) {
        window.open(targetUrl, '_blank');
    }
}

// Function to show reminder details in a modal
function showReminderModal(reminderId) {
    // Create modal HTML
    var modalHtml = '<div id="reminderModal" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999; display: flex; align-items: center; justify-content: center;">';
    modalHtml += '<div style="background: white; padding: 20px; border-radius: 5px; max-width: 500px; width: 90%;">';
    modalHtml += '<div style="display: flex; justify-content: between; align-items: center; margin-bottom: 15px;">';
    modalHtml += '<h4 style="margin: 0;">Reminder Details</h4>';
    modalHtml += '<button onclick="closeReminderModal()" style="background: none; border: none; font-size: 20px; cursor: pointer; float: right;">&times;</button>';
    modalHtml += '</div>';
    modalHtml += '<div id="reminderModalContent">Loading reminder details...</div>';
    modalHtml += '<div style="margin-top: 15px; text-align: right;">';
    modalHtml += '<button onclick="closeReminderModal()" class="btn btn-default">Close</button>';
    modalHtml += '</div>';
    modalHtml += '</div>';
    modalHtml += '</div>';
    
    // Add modal to page
    document.body.insertAdjacentHTML('beforeend', modalHtml);
    
    // Load reminder details via AJAX
    fetch('admin/misc/get_reminder/' + reminderId)
        .then(response => response.json())
        .then(data => {
            var content = '<div>';
            content += '<p><strong>Description:</strong> ' + (data.description || 'No description') + '</p>';
            content += '<p><strong>Date:</strong> ' + (data.date || 'No date') + '</p>';
            content += '<p><strong>Related to:</strong> ' + (data.rel_type || 'Unknown') + ' #' + (data.rel_id || 'Unknown') + '</p>';
            content += '<p><strong>Staff:</strong> ' + (data.staff_name || 'Unknown') + '</p>';
            content += '</div>';
            document.getElementById('reminderModalContent').innerHTML = content;
        })
        .catch(error => {
            document.getElementById('reminderModalContent').innerHTML = '<div class="alert alert-danger">Failed to load reminder details</div>';
        });
}

// Function to close reminder modal
function closeReminderModal() {
    var modal = document.getElementById('reminderModal');
    if (modal) {
        modal.remove();
    }
}
</script>

<?php init_tail(); ?>
