<?php
/*
 Module Name: Reporting Dashboard
 Module URI: https://example.com/reporting-dashboard
 Description: Centralized staff activity tracking and reporting with KPIs, charts, and detailed logs.
 Version: 1.0.0
 Requires at least: 3.0.*
*/

defined('BASEPATH') or exit('No direct script access allowed');

// Module constants
define('REPORTING_DASHBOARD_MODULE_NAME', 'reporting_dashboard');
define('REPORTING_DASHBOARD_MODULE', 'reporting_dashboard');

// Register language files (none for now but keep for future)
if (function_exists('register_language_files')) {
    register_language_files(REPORTING_DASHBOARD_MODULE, [REPORTING_DASHBOARD_MODULE]);
}

// Register activation hook
if (function_exists('register_activation_hook')) {
    register_activation_hook(REPORTING_DASHBOARD_MODULE, 'reporting_dashboard_activate');
}

function reporting_dashboard_activate()
{
    // Default options for scheduled emails
    add_option('reporting_dashboard_schedule_enabled', 0);
    add_option('reporting_dashboard_schedule_frequency', 'daily'); // daily|weekly
    add_option('reporting_dashboard_schedule_recipients', '');
}

// Include module pieces
require_once __DIR__ . '/includes/staff_permissions.php';
require_once __DIR__ . '/includes/sidebar_menu_links.php';
require_once __DIR__ . '/includes/assets.php';

// Cron hook for scheduled email reports
hooks()->add_action('after_cron_run', function () {
    $CI = &get_instance();
    if ((int) get_option('reporting_dashboard_schedule_enabled') !== 1) {
        return;
    }

    $recipients = trim((string) get_option('reporting_dashboard_schedule_recipients'));
    if ($recipients === '') {
        return;
    }

    // Run once per day/week based on frequency using a transient option
    $frequency = get_option('reporting_dashboard_schedule_frequency');
    $last_run  = (int) get_option('reporting_dashboard_last_email_ts');
    $now       = time();

    $interval = $frequency === 'weekly' ? 7 * 24 * 60 * 60 : 24 * 60 * 60;

    if ($last_run && ($now - $last_run) < $interval) {
        return;
    }

    update_option('reporting_dashboard_last_email_ts', $now);

    $CI->load->model('reporting_dashboard/reporting_dashboard_model');
    $summary = $CI->reporting_dashboard_model->get_email_summary_data();

    // Build a simple HTML summary (keep light-weight)
    $html = '<h2>Activity Summary</h2>';
    $html .= '<p>Total Activities Today: ' . (int) $summary['kpis']['today'] . '</p>';
    $html .= '<p>Total Activities This Week: ' . (int) $summary['kpis']['week'] . '</p>';
    $html .= '<p>Total Activities This Month: ' . (int) $summary['kpis']['month'] . '</p>';
    $html .= '<p>Total Logins Today: ' . (int) $summary['kpis']['logins_today'] . '</p>';

    $subject = 'Reporting Dashboard - Scheduled Summary';

    $emails = array_filter(array_map('trim', explode(',', $recipients)));
    foreach ($emails as $email) {
        send_mail_template('simple', $email, $subject, $html);
    }
});
