<?php
// Simple debug script to test module endpoints
defined('BASEPATH') or exit('No direct script access allowed');

echo "<h1>Reporting Dashboard - Endpoint Debug</h1>";

$base_url = admin_url('reporting_dashboard/');

echo "<h2>Available Endpoints:</h2>";
echo "<ul>";
echo "<li><a href='{$base_url}get_kpis' target='_blank'>Test KPIs</a></li>";
echo "<li><a href='{$base_url}get_staff_activity_chart' target='_blank'>Test Staff Activity Chart</a></li>";
echo "<li><a href='{$base_url}get_activity_over_time_chart' target='_blank'>Test Activity Over Time</a></li>";
echo "<li><a href='{$base_url}get_activity_type_pie' target='_blank'>Test Activity Types</a></li>";
echo "<li><a href='{$base_url}get_reminders' target='_blank'>Test Reminders</a></li>";
echo "<li><a href='{$base_url}get_followup_types_chart' target='_blank'>Test Follow-up Types</a></li>";
echo "<li><a href='{$base_url}get_activity_table' target='_blank'>Test Activity Table</a></li>";
echo "</ul>";

echo "<h2>Current User Info:</h2>";
echo "<p>User ID: " . get_staff_user_id() . "</p>";
echo "<p>Is Admin: " . (is_admin() ? 'Yes' : 'No') . "</p>";
echo "<p>Has Permission: " . (has_permission('view_reporting_dashboard') ? 'Yes' : 'No') . "</p>";

echo "<h2>Database Info:</h2>";
echo "<p>DB Prefix: " . db_prefix() . "</p>";

// Test database connection
try {
    $CI = &get_instance();
    $CI->load->database();
    
    $query = $CI->db->query("SELECT COUNT(*) as count FROM " . db_prefix() . "lead_activity_log");
    $result = $query->row();
    echo "<p>Lead Activity Log Records: " . $result->count . "</p>";
    
    $query = $CI->db->query("SELECT COUNT(*) as count FROM " . db_prefix() . "staff");
    $result = $query->row();
    echo "<p>Staff Records: " . $result->count . "</p>";
    
    echo "<p style='color: green;'>✅ Database connection successful!</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Database error: " . $e->getMessage() . "</p>";
}

echo "<h2>Module Status:</h2>";
$modules = $this->app_modules->get();
$found = false;
foreach ($modules as $module) {
    if (isset($module['system_name']) && $module['system_name'] == 'reporting_dashboard') {
        echo "<p style='color: green;'>✅ Module found and loaded</p>";
        echo "<pre>" . print_r($module, true) . "</pre>";
        $found = true;
        break;
    }
}

if (!$found) {
    echo "<p style='color: red;'>❌ Module not found in loaded modules</p>";
}
?>
