<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <?php echo _l('facebook_leads_settings'); ?>
                        </h4>
                        <hr class="hr-panel-heading" />

                        <!-- Statistics Cards -->
                        <div class="row mtop20 mbot20">
                            <div class="col-md-4">
                                <div class="alert alert-info">
                                    <h4 class="bold"><?php echo $stats['total_imported']; ?></h4>
                                    <p class="mbot0">Total Leads Imported</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="alert alert-success">
                                    <h4 class="bold"><?php echo $stats['this_month']; ?></h4>
                                    <p class="mbot0">Leads This Month</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="alert alert-warning">
                                    <h4 class="bold"><?php echo $stats['last_fetch'] ?: 'Never'; ?></h4>
                                    <p class="mbot0">Last Fetch</p>
                                </div>
                            </div>
                        </div>

                        <!-- Settings Form -->
                        <?php echo form_open(admin_url('facebook_leads_integration/settings')); ?>

                        <div class="row">
                            <div class="col-md-6">
                                <h5 class="bold"><?php echo _l('fbl_enabled'); ?></h5>
                                <div class="form-group">
                                    <div class="onoffswitch">
                                        <input type="checkbox" name="enabled" class="onoffswitch-checkbox" id="enabled" 
                                            <?php echo $settings['enabled'] == '1' ? 'checked' : ''; ?>>
                                        <label class="onoffswitch-label" for="enabled"></label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <hr />

                        <h5 class="bold">Facebook App Configuration</h5>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_input('app_id', 'fbl_app_id', $settings['app_id'], 'text', [
                                    'placeholder' => 'Enter Facebook App ID'
                                ]); ?>
                                <p class="text-muted"><?php echo _l('fbl_help_app_id'); ?></p>
                            </div>

                            <div class="col-md-6">
                                <?php echo render_input('app_secret', 'fbl_app_secret', $settings['app_secret'], 'password', [
                                    'placeholder' => 'Enter Facebook App Secret'
                                ]); ?>
                                <p class="text-muted"><?php echo _l('fbl_help_app_secret'); ?></p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <?php echo render_input('page_id', 'fbl_page_id', $settings['page_id'], 'text', [
                                    'placeholder' => 'Enter Facebook Page ID'
                                ]); ?>
                                <p class="text-muted"><?php echo _l('fbl_help_page_id'); ?></p>
                            </div>

                            <div class="col-md-6">
                                <?php echo render_input('page_access_token', 'fbl_page_access_token', $settings['page_access_token'], 'password', [
                                    'placeholder' => 'Enter Page Access Token'
                                ]); ?>
                                <p class="text-muted"><?php echo _l('fbl_help_page_token'); ?></p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <?php echo render_input('form_ids', 'fbl_form_ids', $settings['form_ids'], 'text', [
                                    'placeholder' => 'e.g., 123456789,987654321'
                                ]); ?>
                                <p class="text-muted"><?php echo _l('fbl_help_form_ids'); ?></p>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <button type="button" class="btn btn-info" id="test-connection">
                                    <i class="fa fa-plug"></i> <?php echo _l('fbl_test_connection'); ?>
                                </button>
                                <span id="connection-result" class="mleft10"></span>
                            </div>
                        </div>

                        <hr />

                        <h5 class="bold">Lead Import Settings</h5>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="default_assigned_staff"><?php echo _l('fbl_default_assigned_staff'); ?></label>
                                    <select name="default_assigned_staff" id="default_assigned_staff" class="selectpicker form-control" data-live-search="true">
                                        <option value=""><?php echo _l('not_assigned'); ?></option>
                                        <?php foreach ($staff_members as $staff) { ?>
                                            <option value="<?php echo $staff['staffid']; ?>" 
                                                <?php echo $settings['default_assigned_staff'] == $staff['staffid'] ? 'selected' : ''; ?>>
                                                <?php echo $staff['firstname'] . ' ' . $staff['lastname']; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="lead_status"><?php echo _l('fbl_lead_status'); ?></label>
                                    <select name="lead_status" id="lead_status" class="selectpicker form-control">
                                        <?php foreach ($lead_statuses as $status) { ?>
                                            <option value="<?php echo $status['id']; ?>" 
                                                <?php echo $settings['lead_status'] == $status['id'] ? 'selected' : ''; ?>>
                                                <?php echo $status['name']; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="lead_source"><?php echo _l('fbl_lead_source'); ?></label>
                                    <select name="lead_source" id="lead_source" class="selectpicker form-control">
                                        <?php foreach ($lead_sources as $source) { ?>
                                            <option value="<?php echo $source->id; ?>" 
                                                <?php echo $settings['lead_source'] == $source->id ? 'selected' : ''; ?>>
                                                <?php echo $source->name; ?>
                                            </option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <?php echo render_input('cron_interval', 'fbl_cron_interval', $settings['cron_interval'], 'number', [
                                    'min' => '1',
                                    'max' => '1440'
                                ]); ?>
                                <p class="text-muted"><?php echo _l('fbl_help_cron'); ?></p>
                            </div>
                        </div>

                        <hr />

                        <h5 class="bold">Webhook Configuration (Optional - For Real-Time Leads)</h5>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label><?php echo _l('fbl_webhook_url'); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" readonly 
                                            value="<?php echo site_url('facebook_leads_integration/webhook'); ?>" id="webhook-url">
                                        <span class="input-group-addon">
                                            <a href="javascript:void(0);" onclick="copyToClipboard('#webhook-url')">
                                                <i class="fa fa-copy"></i>
                                            </a>
                                        </span>
                                    </div>
                                    <p class="text-muted mtop10"><?php echo _l('fbl_webhook_info'); ?></p>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label><?php echo _l('fbl_webhook_verify_token'); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" readonly 
                                            value="<?php echo $settings['webhook_verify_token']; ?>" id="verify-token">
                                        <span class="input-group-addon">
                                            <a href="javascript:void(0);" onclick="copyToClipboard('#verify-token')">
                                                <i class="fa fa-copy"></i>
                                            </a>
                                        </span>
                                    </div>
                                    <p class="text-muted mtop10"><?php echo _l('fbl_help_webhook'); ?></p>
                                </div>
                            </div>
                        </div>

                        <hr />

                        <div class="row">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-check"></i> <?php echo _l('fbl_save_settings'); ?>
                                </button>
                                <button type="button" class="btn btn-success" id="fetch-now">
                                    <i class="fa fa-download"></i> <?php echo _l('fbl_fetch_now'); ?>
                                </button>
                                <a href="<?php echo admin_url('facebook_leads_integration/logs'); ?>" class="btn btn-default">
                                    <i class="fa fa-list"></i> <?php echo _l('fbl_logs'); ?>
                                </a>
                            </div>
                        </div>

                        <?php echo form_close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
// Ensure jQuery is loaded and use proper scope
(function($) {
    'use strict';
    
    $(document).ready(function() {
        // Test Connection
        $('#test-connection').on('click', function() {
            var btn = $(this);
            var resultSpan = $('#connection-result');
            
            btn.prop('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Testing...');
            resultSpan.html('');
            
            $.ajax({
                url: '<?php echo admin_url('facebook_leads_integration/test_connection'); ?>',
                type: 'POST',
                data: {
                    page_access_token: $('input[name="page_access_token"]').val(),
                    page_id: $('input[name="page_id"]').val()
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        resultSpan.html('<span class="text-success"><i class="fa fa-check-circle"></i> ' + response.message + '</span>');
                    } else {
                        resultSpan.html('<span class="text-danger"><i class="fa fa-times-circle"></i> ' + response.message + '</span>');
                    }
                },
                error: function() {
                    resultSpan.html('<span class="text-danger"><i class="fa fa-times-circle"></i> Connection failed</span>');
                },
                complete: function() {
                    btn.prop('disabled', false).html('<i class="fa fa-plug"></i> <?php echo _l('fbl_test_connection'); ?>');
                }
            });
        });
        
        // Fetch Now
        $('#fetch-now').on('click', function() {
            var btn = $(this);
            
            if (!confirm('Fetch leads from Facebook now?')) {
                return;
            }
            
            btn.prop('disabled', true).html('<i class="fa fa-spin fa-spinner"></i> Fetching...');
            
            $.ajax({
                url: '<?php echo admin_url('facebook_leads_integration/fetch_leads'); ?>',
                type: 'POST',
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        alert_float('success', response.message);
                        setTimeout(function() {
                            location.reload();
                        }, 1500);
                    } else {
                        alert_float('danger', response.message);
                    }
                },
                error: function() {
                    alert_float('danger', 'An error occurred while fetching leads');
                },
                complete: function() {
                    btn.prop('disabled', false).html('<i class="fa fa-download"></i> <?php echo _l('fbl_fetch_now'); ?>');
                }
            });
        });
    });
    
    // Expose copyToClipboard to global scope for inline onclick handlers
    window.copyToClipboard = function(element) {
        var $temp = $("<input>");
        $("body").append($temp);
        $temp.val($(element).val()).select();
        document.execCommand("copy");
        $temp.remove();
        alert_float('success', 'Copied to clipboard!');
    };
    
})(jQuery);
</script>

