<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <?php echo _l('facebook_leads_logs'); ?>
                        </h4>
                        <hr class="hr-panel-heading" />

                        <div class="row">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="table table-striped dt-table" id="leads-logs-table">
                                        <thead>
                                            <tr>
                                                <th><?php echo _l('fbl_facebook_lead_id'); ?></th>
                                                <th><?php echo _l('fbl_form_id'); ?></th>
                                                <th><?php echo _l('fbl_perfex_lead_id'); ?></th>
                                                <th><?php echo _l('fbl_status'); ?></th>
                                                <th><?php echo _l('fbl_created_at'); ?></th>
                                                <th><?php echo _l('options'); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (!empty($logs)) { ?>
                                                <?php foreach ($logs as $log) { ?>
                                                    <tr>
                                                        <td><?php echo $log->facebook_lead_id; ?></td>
                                                        <td><?php echo $log->form_id; ?></td>
                                                        <td>
                                                            <?php if ($log->lead_id) { ?>
                                                                <a href="<?php echo admin_url('leads/index/' . $log->lead_id); ?>" target="_blank">
                                                                    #<?php echo $log->lead_id; ?> <i class="fa fa-external-link"></i>
                                                                </a>
                                                            <?php } else { ?>
                                                                <span class="text-muted">N/A</span>
                                                            <?php } ?>
                                                        </td>
                                                        <td>
                                                            <?php if ($log->status === 'success') { ?>
                                                                <span class="label label-success">Success</span>
                                                            <?php } elseif ($log->status === 'duplicate') { ?>
                                                                <span class="label label-warning">Duplicate</span>
                                                            <?php } else { ?>
                                                                <span class="label label-danger">Failed</span>
                                                            <?php } ?>
                                                        </td>
                                                        <td><?php echo date('M d, Y H:i', strtotime($log->created_at)); ?></td>
                                                        <td>
                                                            <button type="button" class="btn btn-default btn-xs view-log-data" data-log-id="<?php echo $log->id; ?>">
                                                                <i class="fa fa-eye"></i> <?php echo _l('fbl_view_data'); ?>
                                                            </button>
                                                            <?php if ($log->error_message) { ?>
                                                                <button type="button" class="btn btn-danger btn-xs view-error" 
                                                                    data-toggle="tooltip" title="<?php echo htmlspecialchars($log->error_message); ?>">
                                                                    <i class="fa fa-exclamation-circle"></i> Error
                                                                </button>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <tr>
                                                    <td colspan="6" class="text-center">
                                                        <p class="text-muted">No logs found</p>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="row mtop20">
                            <div class="col-md-12">
                                <a href="<?php echo admin_url('facebook_leads_integration/settings'); ?>" class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Settings
                                </a>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Log Data Modal -->
<div class="modal fade" id="logDataModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Facebook Lead Data</h4>
            </div>
            <div class="modal-body">
                <pre id="log-data-content" style="max-height: 500px; overflow-y: auto;"></pre>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
$(function() {
    // Initialize DataTable
    $('#leads-logs-table').DataTable({
        "order": [[4, "desc"]],
        "pageLength": 25,
        "language": {
            "emptyTable": "No logs available"
        }
    });
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // View log data
    $('.view-log-data').on('click', function() {
        var logId = $(this).data('log-id');
        
        $.ajax({
            url: '<?php echo admin_url('facebook_leads_integration/view_log_data/'); ?>' + logId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $('#log-data-content').text(JSON.stringify(response.data, null, 2));
                    $('#logDataModal').modal('show');
                } else {
                    alert_float('danger', response.message || 'Failed to load log data');
                }
            },
            error: function() {
                alert_float('danger', 'An error occurred while loading log data');
            }
        });
    });
});
</script>

<?php init_tail(); ?>

