<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Facebook Leads Integration
Description: Automatically fetch leads from Facebook Lead Forms and import them into Perfex CRM
Version: 1.0.0
Author: Your Company
Requires at least: 3.0.*
*/

define('FACEBOOK_LEADS_MODULE_NAME', 'facebook_leads_integration');
define('FACEBOOK_LEADS_MODULE_VERSION', '1.0.0');

/**
 * Register activation module hook
 */
register_activation_hook(FACEBOOK_LEADS_MODULE_NAME, 'facebook_leads_integration_activation_hook');

function facebook_leads_integration_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files
 */
register_language_files(FACEBOOK_LEADS_MODULE_NAME, [FACEBOOK_LEADS_MODULE_NAME]);

/**
 * Register module menu items
 */
hooks()->add_action('admin_init', 'facebook_leads_integration_init_menu_items');

function facebook_leads_integration_init_menu_items()
{
    $CI = &get_instance();
    
    if (has_permission('facebook_leads_integration', '', 'view')) {
        $CI->app_menu->add_setup_menu_item('facebook-leads-integration', [
            'collapse' => true,
            'name'     => _l('facebook_leads_integration'),
            'position' => 35,
        ]);
        
        $CI->app_menu->add_setup_children_item('facebook-leads-integration', [
            'slug'     => 'facebook-leads-settings',
            'name'     => _l('settings'),
            'href'     => admin_url('facebook_leads_integration/settings'),
            'position' => 1,
        ]);
        
        $CI->app_menu->add_setup_children_item('facebook-leads-integration', [
            'slug'     => 'facebook-leads-logs',
            'name'     => _l('logs'),
            'href'     => admin_url('facebook_leads_integration/logs'),
            'position' => 2,
        ]);
    }
}

/**
 * Add dashboard widget
 */
hooks()->add_action('admin_init', 'facebook_leads_integration_dashboard_widget');

function facebook_leads_integration_dashboard_widget()
{
    if (has_permission('facebook_leads_integration', '', 'view')) {
        $CI = &get_instance();
        $CI->load->model('facebook_leads_integration/facebook_leads_integration_model');
        
        // Register widget
        if (is_admin() || has_permission('facebook_leads_integration', '', 'view')) {
            hooks()->add_action('after_dashboard_top_row', 'facebook_leads_widget_html');
        }
    }
}

function facebook_leads_widget_html()
{
    $CI = &get_instance();
    $CI->load->model('facebook_leads_integration/facebook_leads_integration_model');
    
    $stats = $CI->facebook_leads_integration_model->get_statistics();
    
    echo '<div class="col-md-3">
        <div class="panel_s">
            <div class="panel-body">
                <h4 class="bold">Facebook Leads</h4>
                <hr class="hr-panel-heading">
                <p class="mbot5">Total Imported: <span class="bold">' . $stats['total_imported'] . '</span></p>
                <p class="mbot5">This Month: <span class="bold">' . $stats['this_month'] . '</span></p>
                <p class="mbot5">Last Fetch: <span class="bold">' . ($stats['last_fetch'] ?: 'Never') . '</span></p>
                <a href="' . admin_url('facebook_leads_integration/settings') . '" class="btn btn-info btn-xs mtop10">Manage</a>
            </div>
        </div>
    </div>';
}

/**
 * Add settings link in module manager
 */
hooks()->add_filter('module_' . FACEBOOK_LEADS_MODULE_NAME . '_action_links', 'module_facebook_leads_integration_action_links');

function module_facebook_leads_integration_action_links($actions)
{
    $actions[] = '<a href="' . admin_url('facebook_leads_integration/settings') . '">' . _l('settings') . '</a>';
    return $actions;
}

