-- Facebook Leads Integration - Database Tables
-- Run this SQL in your database to create the required tables

-- Table: facebook_leads_settings
CREATE TABLE IF NOT EXISTS `tblfacebook_leads_settings` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `setting_name` varchar(100) NOT NULL,
    `setting_value` text,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `setting_name` (`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Table: facebook_leads_logs
CREATE TABLE IF NOT EXISTS `tblfacebook_leads_logs` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `facebook_lead_id` varchar(255) NOT NULL,
    `form_id` varchar(255) NOT NULL,
    `lead_id` int(11) DEFAULT NULL COMMENT 'Perfex Lead ID',
    `data` text NOT NULL COMMENT 'JSON data from Facebook',
    `status` enum('success','failed','duplicate') DEFAULT 'success',
    `error_message` text,
    `created_at` datetime NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `facebook_lead_id` (`facebook_lead_id`),
    KEY `form_id` (`form_id`),
    KEY `lead_id` (`lead_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Insert default settings
INSERT INTO `tblfacebook_leads_settings` (`setting_name`, `setting_value`, `updated_at`) VALUES
('app_id', '', NOW()),
('app_secret', '', NOW()),
('page_access_token', '', NOW()),
('page_id', '', NOW()),
('form_ids', '', NOW()),
('default_assigned_staff', '', NOW()),
('lead_status', '1', NOW()),
('lead_source', '', NOW()),
('cron_interval', '15', NOW()),
('webhook_verify_token', MD5(RAND()), NOW()),
('last_fetch_time', '', NOW()),
('enabled', '0', NOW())
ON DUPLICATE KEY UPDATE `updated_at` = NOW();

-- Create Facebook lead source if it doesn't exist
INSERT INTO `tblleads_sources` (`name`) 
SELECT 'Facebook' FROM DUAL
WHERE NOT EXISTS (SELECT * FROM `tblleads_sources` WHERE `name` = 'Facebook');

-- Update lead_source setting with the Facebook source ID
UPDATE `tblfacebook_leads_settings` 
SET `setting_value` = (SELECT `id` FROM `tblleads_sources` WHERE `name` = 'Facebook' LIMIT 1)
WHERE `setting_name` = 'lead_source';

