# Setup Checklist - Facebook Leads Integration

Use this checklist to ensure everything is configured correctly.

## Pre-Installation

- [ ] Perfex CRM version 3.0 or higher installed
- [ ] PHP 7.2+ with cURL extension enabled
- [ ] MySQL 5.7+ or MariaDB 10.2+ database
- [ ] Admin access to Perfex CRM
- [ ] SSH or cPanel access to server
- [ ] Facebook Developer Account created
- [ ] Facebook Page with Lead Forms set up

## Module Installation

- [ ] Module files uploaded to `/modules/facebook_leads_integration/`
- [ ] File permissions set correctly (755 for folders, 644 for files)
- [ ] Logs directory created and writable (chmod 777)
- [ ] Module activated in Perfex CRM (Setup → Modules)
- [ ] Database tables created successfully
- [ ] "Facebook" lead source created in Perfex
- [ ] No error messages during activation

## Facebook App Setup

- [ ] Facebook App created (Business type)
- [ ] App ID obtained from Settings → Basic
- [ ] App Secret obtained from Settings → Basic
- [ ] Leads Retrieval product added to app
- [ ] App reviewed and approved (if required)
- [ ] App is in Live mode (not Development)

## Facebook Permissions & Tokens

- [ ] Page Access Token generated
- [ ] Token has `leads_retrieval` permission
- [ ] Token has `pages_read_engagement` permission
- [ ] Token has `pages_manage_ads` permission (optional)
- [ ] Token is long-lived (60 days+) or page token (never expires)
- [ ] Token tested in Graph API Explorer

## Facebook IDs Collection

- [ ] Facebook Page ID obtained
- [ ] Lead Form ID(s) obtained from Publishing Tools
- [ ] Form IDs verified in Graph API Explorer
- [ ] Multiple form IDs separated by commas (if applicable)

## Module Configuration

- [ ] Navigated to Setup → Integrations → Facebook Leads Integration
- [ ] App ID entered correctly
- [ ] App Secret entered correctly
- [ ] Page Access Token entered correctly
- [ ] Page ID entered correctly
- [ ] Form IDs entered correctly (comma-separated, no spaces)
- [ ] Default Assigned Staff selected
- [ ] Default Lead Status selected
- [ ] Lead Source set to "Facebook"
- [ ] Cron Interval configured (default: 15 minutes)
- [ ] "Test Connection" button clicked → SUCCESS shown
- [ ] Integration enabled (toggle switched ON)
- [ ] Settings saved successfully

## Cron Job Setup

- [ ] Cron job script path identified
- [ ] PHP CLI path identified (`which php`)
- [ ] Cron job added to crontab or Task Scheduler
- [ ] Cron interval matches module settings
- [ ] Cron job tested manually from command line
- [ ] Cron job executes without errors
- [ ] Cron log file being created (optional)
- [ ] Verify cron job runs automatically after waiting interval

## Webhook Setup (Optional)

- [ ] Website has valid SSL certificate (HTTPS)
- [ ] Webhook URL is publicly accessible
- [ ] Webhook URL copied from module settings
- [ ] Verify Token copied from module settings
- [ ] Webhook configured in Facebook App Dashboard
- [ ] Callback URL added: `https://yourdomain.com/index.php/facebook_leads_integration/webhook`
- [ ] Verify Token entered in Facebook webhook settings
- [ ] Subscription field "leadgen" selected
- [ ] Webhook verification successful (green checkmark)
- [ ] Page subscribed to app via Graph API
- [ ] POST to `{PAGE_ID}/subscribed_apps` with `subscribed_fields=leadgen`
- [ ] Webhook test lead submitted
- [ ] Webhook test lead received in CRM

## Testing & Verification

### Basic Functionality
- [ ] Manual "Fetch Now" button works
- [ ] Test lead appears in Perfex Leads section
- [ ] Lead has correct source ("Facebook")
- [ ] Lead assigned to correct staff member
- [ ] Lead has correct status
- [ ] Lead fields populated correctly (name, email, phone)

### Logs & Monitoring
- [ ] Logs tab shows imported leads
- [ ] Log entries show "success" status
- [ ] "View Data" button displays raw Facebook data
- [ ] No error entries in logs
- [ ] Log files created in `/logs/` directory
- [ ] Error log file checked for issues

### Dashboard & UI
- [ ] Facebook Leads widget appears on dashboard
- [ ] Widget shows correct statistics
- [ ] Total imported count is accurate
- [ ] "This Month" count is accurate
- [ ] "Last Fetch" timestamp updates

### Duplicate Prevention
- [ ] Same lead submitted twice
- [ ] Second submission marked as "duplicate" in logs
- [ ] Only one lead created in Perfex
- [ ] Email duplicate detection works

### Cron Job Verification
- [ ] Cron job runs automatically at scheduled interval
- [ ] New leads imported without manual intervention
- [ ] "Last Fetch" timestamp updates automatically
- [ ] No errors in cron log file

### Webhook Verification (if enabled)
- [ ] Test lead submitted on Facebook form
- [ ] Lead appears in CRM within 10 seconds
- [ ] Webhook log entry created
- [ ] Facebook webhook shows successful delivery
- [ ] No errors in Facebook webhook debug

## Security Checks

- [ ] `.htaccess` files protecting sensitive directories
- [ ] Log files not accessible via browser
- [ ] App Secret not visible in browser source
- [ ] Page Access Token not visible in browser source
- [ ] Module settings page requires admin login
- [ ] File permissions set correctly (not 777 except logs)
- [ ] SSL certificate valid (for webhooks)

## Performance Checks

- [ ] Lead import completes in reasonable time (< 30 seconds)
- [ ] Dashboard loads quickly
- [ ] Logs page loads without timeout
- [ ] Multiple leads imported successfully
- [ ] No PHP memory errors
- [ ] No database timeout errors

## Documentation Review

- [ ] README.md read and understood
- [ ] INSTALLATION.md followed step-by-step
- [ ] QUICK_START.md reviewed
- [ ] FAQ.md bookmarked for reference
- [ ] Cron command documented for future reference
- [ ] Webhook URLs saved securely
- [ ] Facebook App credentials backed up securely

## Training & Handoff

- [ ] Staff trained on where to find new leads
- [ ] Staff knows how to manually fetch leads if needed
- [ ] Admin knows how to check logs
- [ ] Admin knows how to troubleshoot common issues
- [ ] Support documentation shared with team
- [ ] Emergency contact for technical issues identified

## Ongoing Maintenance

- [ ] Calendar reminder to check logs weekly
- [ ] Calendar reminder to verify token validity monthly
- [ ] Backup strategy includes module database tables
- [ ] Update plan in place for module upgrades
- [ ] Facebook API version upgrade plan documented

## Troubleshooting Preparation

- [ ] Facebook App credentials saved in password manager
- [ ] Backup of module files created
- [ ] Database backup includes module tables
- [ ] Know where to check error logs
- [ ] Know how to run cron job manually
- [ ] Facebook Developer support resources bookmarked
- [ ] Perfex CRM support resources available

## Optional Enhancements

- [ ] Custom field mapping configured (if needed)
- [ ] Email notifications set up for new leads
- [ ] Lead assignment rules customized
- [ ] Integration with other CRM workflows
- [ ] Monitoring/alerting set up for failures
- [ ] Analytics tracking configured

## Sign-Off

- [ ] All checklist items completed
- [ ] Module functioning as expected
- [ ] Team trained and ready
- [ ] Documentation accessible
- [ ] Support plan in place

**Installation Date:** _______________

**Installed By:** _______________

**Verified By:** _______________

**Status:** _______________

---

## Quick Reference

**Module Location:** `/modules/facebook_leads_integration/`

**Settings Page:** Setup → Integrations → Facebook Leads Integration

**Logs Location:** `/modules/facebook_leads_integration/logs/`

**Cron Command:**
```bash
*/15 * * * * php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
```

**Webhook URL:**
```
https://yourdomain.com/index.php/facebook_leads_integration/webhook
```

**Support Resources:**
- Module Documentation: README.md
- Installation Guide: INSTALLATION.md
- FAQ: FAQ.md
- Facebook Docs: https://developers.facebook.com/docs/marketing-api/guides/lead-ads

---

**Notes:**
_Use this space for any specific configuration notes or customizations_


