# Facebook Leads Integration for Perfex CRM

Automatically fetch leads from Facebook Lead Forms and import them into Perfex CRM in real-time or via scheduled intervals.

## Features

- ✅ **Automatic Lead Import** - Fetch leads from Facebook Lead Forms automatically
- ✅ **Real-time Webhooks** - Receive leads instantly via Facebook webhooks
- ✅ **Scheduled Cron Jobs** - Auto-fetch leads at configurable intervals
- ✅ **Duplicate Prevention** - Automatically detect and skip duplicate leads
- ✅ **Custom Field Mapping** - Maps Facebook form fields to Perfex CRM lead fields
- ✅ **Lead Assignment** - Auto-assign leads to specific staff members
- ✅ **Detailed Logging** - Track all imported leads with status and error logging
- ✅ **Test Connection** - Verify Facebook API credentials before going live
- ✅ **Dashboard Widget** - View import statistics at a glance

## Requirements

- Perfex CRM v3.0 or higher
- PHP 7.2 or higher with cURL enabled
- Facebook Developer Account
- Facebook Page with Lead Forms
- SSL Certificate (required for webhooks)

## Installation

### Step 1: Upload Module Files

1. Download or clone this module
2. Upload the `facebook_leads_integration` folder to your Perfex CRM installation:
   ```
   /path/to/perfex/modules/facebook_leads_integration/
   ```

### Step 2: Activate Module

1. Log in to Perfex CRM admin panel
2. Navigate to **Setup → Modules**
3. Find "Facebook Leads Integration" in the list
4. Click **Activate**

The module will automatically:
- Create required database tables
- Set up default settings
- Create a "Facebook" lead source

### Step 3: Configure Facebook App

#### Create Facebook App

1. Go to [Facebook Developers](https://developers.facebook.com/)
2. Click **My Apps** → **Create App**
3. Choose **Business** type
4. Fill in app details and create

#### Configure App Settings

1. In your Facebook App dashboard, note down:
   - **App ID**
   - **App Secret** (in Settings → Basic)

2. Add **Leads Retrieval** product:
   - Click **Add Product**
   - Select **Leads Retrieval**

3. Generate **Page Access Token**:
   - Go to Tools → Graph API Explorer
   - Select your app
   - Select your page
   - Add permissions: `leads_retrieval`, `pages_read_engagement`, `pages_manage_ads`
   - Click **Generate Access Token**
   - Copy the token

4. Get **Page ID**:
   - Visit your Facebook Page
   - Click **About**
   - Scroll to find Page ID (or use Graph API Explorer to get it)

5. Get **Form IDs**:
   - Go to your Page → Publishing Tools → Forms Library
   - Click on a form → Note the Form ID from URL or use Graph API Explorer

### Step 4: Configure Module in Perfex CRM

1. Go to **Setup → Integrations → Facebook Leads Integration**
2. Fill in the following:
   - **Facebook App ID** - Your app ID
   - **Facebook App Secret** - Your app secret
   - **Page Access Token** - The token you generated
   - **Facebook Page ID** - Your page ID
   - **Lead Form IDs** - Form IDs (comma-separated if multiple)
3. Configure lead settings:
   - **Default Assigned Staff** - Who should receive the leads
   - **Default Lead Status** - Initial status for new leads
   - **Lead Source** - Should be "Facebook" (auto-created)
   - **Cron Interval** - How often to check for new leads (in minutes)
4. Click **Test Connection** to verify settings
5. Enable the integration by toggling the switch
6. Click **Save Settings**

### Step 5: Set Up Cron Job (for Scheduled Fetching)

#### Linux/Unix Crontab

Add this line to your crontab to run every 15 minutes:

```bash
*/15 * * * * php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php >> /path/to/perfex/modules/facebook_leads_integration/logs/cron.log 2>&1
```

Edit crontab:
```bash
crontab -e
```

#### Windows Task Scheduler

1. Open Task Scheduler
2. Create Basic Task
3. Set trigger to run every 15 minutes
4. Action: Start a program
5. Program: `C:\path\to\php.exe`
6. Arguments: `C:\path\to\perfex\modules\facebook_leads_integration\cron\fetch_facebook_leads.php`

#### Manual Test

Test the cron job manually:
```bash
php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
```

### Step 6: Set Up Webhooks (Optional - For Real-Time)

Webhooks allow Facebook to send leads to your CRM instantly when someone submits a form.

#### Configure Webhook in Facebook App

1. In your Facebook App dashboard
2. Go to **Webhooks** (under Products)
3. Click **Add Subscriptions** for Page
4. Enter callback URL:
   ```
   https://your-domain.com/index.php/facebook_leads_integration/webhook
   ```
5. Enter **Verify Token** (copy from module settings page)
6. Select subscription field: **leadgen**
7. Click **Verify and Save**

#### Subscribe to Page

1. In Graph API Explorer:
   ```
   POST /{page-id}/subscribed_apps
   ```
2. Add parameter: `subscribed_fields` = `leadgen`
3. Use your Page Access Token
4. Submit

Now leads will be sent to your CRM in real-time!

## Usage

### Manual Fetch

1. Go to **Setup → Integrations → Facebook Leads Integration**
2. Click **Fetch Leads Now** button
3. New leads will be imported immediately

### Automatic Fetch (Cron)

If you set up the cron job, leads will be fetched automatically at the configured interval.

### Real-Time (Webhook)

If webhooks are configured, leads arrive instantly when submitted.

### View Logs

1. Go to **Setup → Integrations → Facebook Leads Integration**
2. Click **Logs** tab
3. View all imported leads with status and details

## Field Mapping

The module automatically maps common Facebook form fields:

| Facebook Field | Perfex CRM Field |
|----------------|------------------|
| full_name, name | Lead Name |
| email, e-mail | Lead Email |
| phone, phone_number, mobile | Lead Phone |
| first_name + last_name | Lead Name (combined) |
| Other custom fields | Stored in description |

## Troubleshooting

### Connection Test Fails

- Verify App ID and App Secret are correct
- Check Page Access Token has not expired
- Ensure token has `leads_retrieval` permission
- Verify Page ID is correct

### No Leads Being Fetched

- Check if integration is enabled
- Verify Form IDs are correct (comma-separated, no spaces)
- Check error logs in `/modules/facebook_leads_integration/logs/`
- Run cron job manually to see errors

### Webhook Not Working

- Ensure your site has valid SSL certificate (HTTPS required)
- Check webhook verify token matches
- Look for errors in Facebook App Dashboard → Webhooks
- Verify subscription is active for leadgen field

### Duplicates Not Being Detected

- Module checks Facebook Lead ID first
- Then checks email in Perfex CRM
- Check logs to see why duplicates might be getting through

## Support

For issues, feature requests, or questions:

1. Check the logs in `/modules/facebook_leads_integration/logs/`
2. Enable debug mode in Perfex CRM
3. Review Facebook Graph API documentation

## Security Notes

- Always use HTTPS for webhook endpoints
- Keep App Secret secure (never commit to public repos)
- Regularly rotate access tokens
- Review Facebook API permissions regularly
- Monitor logs for suspicious activity

## Changelog

### Version 1.0.0
- Initial release
- Basic lead fetching from Facebook
- Webhook support
- Cron job automation
- Admin settings interface
- Logging and statistics

## License

This module is provided as-is for use with Perfex CRM.

## Credits

Developed for Perfex CRM integration with Facebook Lead Ads.

