# Quick Start Guide - Facebook Leads Integration

Get up and running in **15 minutes**!

## Prerequisites Checklist

Before you begin, make sure you have:

- ✅ Perfex CRM 3.0+ installed
- ✅ Admin access to Perfex CRM
- ✅ Facebook Developer Account
- ✅ Facebook Page with Lead Forms
- ✅ Server with PHP 7.2+ and cURL
- ✅ SSH or cPanel access (for cron setup)
- ✅ SSL certificate (optional, for webhooks)

## Step-by-Step Setup

### 1️⃣ Install Module (2 minutes)

```bash
# Upload module folder to:
/path/to/perfex/modules/facebook_leads_integration/

# In Perfex CRM:
Setup → Modules → Facebook Leads Integration → Activate
```

✅ **Done!** Tables created automatically.

---

### 2️⃣ Get Facebook Credentials (5 minutes)

#### Quick Method:

1. **Create App**: [Facebook Developers](https://developers.facebook.com/) → Create App → Business
2. **Get Credentials**: Settings → Basic
   - Copy **App ID**
   - Copy **App Secret**
3. **Add Product**: Add Product → Leads Retrieval → Set Up
4. **Get Token**: [Graph API Explorer](https://developers.facebook.com/tools/explorer/)
   - Select your app
   - Get Page Access Token
   - Permissions needed: `leads_retrieval`, `pages_read_engagement`
5. **Get IDs**:
   - **Page ID**: Your Page → About → Page ID
   - **Form ID**: Page → Publishing Tools → Forms Library → Form ID in URL

---

### 3️⃣ Configure Module (3 minutes)

In Perfex CRM:

```
Setup → Integrations → Facebook Leads Integration

Fill in:
✓ App ID: [from step 2]
✓ App Secret: [from step 2]
✓ Page Access Token: [from step 2]
✓ Page ID: [from step 2]
✓ Form IDs: [from step 2, comma-separated]

Configure:
✓ Default Assigned Staff: [select staff]
✓ Lead Status: [select "New" or similar]
✓ Lead Source: Facebook
✓ Cron Interval: 15 minutes

Click "Test Connection" → Should show success ✓
Toggle "Enable Integration" → ON
Click "Save Settings"
```

---

### 4️⃣ Set Up Cron Job (3 minutes)

#### For Linux/cPanel:

```bash
# Add to crontab:
*/15 * * * * php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
```

#### For cPanel:
- Cron Jobs → Add New
- Minute: `*/15`
- Command: `/usr/bin/php /home/user/public_html/modules/facebook_leads_integration/cron/fetch_facebook_leads.php`

#### Test It:
```bash
php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
```

---

### 5️⃣ Test Everything (2 minutes)

1. **Manual Test**:
   - In module settings, click **"Fetch Leads Now"**
   - Check Leads section → Should see imported leads
   
2. **Check Logs**:
   - Click **"Logs"** tab
   - Should show successful imports

3. **Verify Dashboard**:
   - Go to Dashboard
   - Should see "Facebook Leads" widget

---

## 🎉 You're Done!

Leads will now be imported automatically every 15 minutes.

---

## Optional: Real-Time Webhooks (5 minutes)

For **instant** lead delivery:

### Requirements:
- HTTPS website (SSL required)
- Public URL

### Setup:

1. **Copy Webhook Info** (from module settings):
   - Webhook URL: `https://yourdomain.com/index.php/facebook_leads_integration/webhook`
   - Verify Token: `[shown in settings]`

2. **Configure in Facebook**:
   - App Dashboard → Webhooks
   - Add Subscription → Page
   - Paste Webhook URL and Verify Token
   - Select field: `leadgen`
   - Verify and Save

3. **Subscribe Page**:
   - [Graph API Explorer](https://developers.facebook.com/tools/explorer/)
   - POST to: `{PAGE_ID}/subscribed_apps`
   - Parameter: `subscribed_fields=leadgen`
   - Submit

4. **Test**:
   - Submit test lead on Facebook form
   - Should appear in CRM within seconds!

---

## Common Commands

```bash
# Test cron manually
php modules/facebook_leads_integration/cron/fetch_facebook_leads.php

# Check logs
tail -f modules/facebook_leads_integration/logs/info_*.log
tail -f modules/facebook_leads_integration/logs/error_*.log

# Set permissions
chmod -R 755 modules/facebook_leads_integration
chmod -R 777 modules/facebook_leads_integration/logs
```

---

## Quick Troubleshooting

| Issue | Solution |
|-------|----------|
| Connection test fails | Check App ID, Secret, Token are correct |
| No leads fetched | Verify Form IDs are correct (no spaces) |
| Webhook fails | Ensure HTTPS and valid SSL certificate |
| Cron not running | Check PHP path and file permissions |
| Duplicates | Module automatically prevents by Facebook ID + email |

---

## Support

- 📖 Full docs: See [README.md](README.md)
- 🔧 Detailed install: See [INSTALLATION.md](INSTALLATION.md)
- 📝 Check logs: `modules/facebook_leads_integration/logs/`
- 🐛 Debug: Enable debug mode in Perfex config

---

## Security Tips

- ✅ Never share App Secret publicly
- ✅ Use HTTPS for webhooks
- ✅ Regularly rotate access tokens
- ✅ Monitor logs for suspicious activity
- ✅ Keep Perfex CRM updated

---

**Happy Lead Collecting! 🚀**

For questions or issues, check the logs first, then refer to the full documentation.

