# Installation Guide - Facebook Leads Integration

## Quick Installation Steps

### 1. Upload Module (5 minutes)

1. Extract the module files
2. Upload the entire `facebook_leads_integration` folder to:
   ```
   /path/to/perfex/modules/facebook_leads_integration/
   ```

3. Verify folder structure:
   ```
   modules/
   └── facebook_leads_integration/
       ├── controllers/
       │   └── Facebook_leads_integration.php
       ├── models/
       │   └── Facebook_leads_integration_model.php
       ├── views/
       │   ├── settings.php
       │   └── logs.php
       ├── helpers/
       │   └── facebook_helper.php
       ├── cron/
       │   └── fetch_facebook_leads.php
       ├── language/
       │   └── english/
       │       └── facebook_leads_integration_lang.php
       ├── logs/ (will be created automatically)
       ├── facebook_leads_integration.php
       ├── install.php
       └── README.md
   ```

### 2. Activate Module (1 minute)

1. Login to Perfex CRM as administrator
2. Go to **Setup → Modules**
3. Find "Facebook Leads Integration"
4. Click **Activate** button

✅ Module is now installed! Database tables and settings have been created automatically.

### 3. Get Facebook Credentials (10 minutes)

#### A. Create Facebook App

1. Visit [Facebook Developers](https://developers.facebook.com/)
2. Click **My Apps** → **Create App**
3. Select **Business** as app type
4. Enter display name and contact email
5. Click **Create App**

#### B. Get App Credentials

1. Go to **Settings → Basic**
2. Copy your **App ID**
3. Click **Show** next to App Secret, copy **App Secret**

#### C. Add Leads Retrieval Product

1. In left menu, click **Add Product**
2. Find **Leads Retrieval** and click **Set Up**

#### D. Generate Page Access Token

**Method 1: Using Graph API Explorer (Recommended)**

1. Go to [Graph API Explorer](https://developers.facebook.com/tools/explorer/)
2. Select your app from dropdown
3. Click "Generate Access Token"
4. Select permissions:
   - `leads_retrieval`
   - `pages_read_engagement`
   - `pages_manage_ads`
   - `pages_show_list`
5. Click **Generate Access Token**
6. Authorize with your Facebook account
7. Copy the token

**Method 2: Using Access Token Tool**

1. Go to [Access Token Tool](https://developers.facebook.com/tools/accesstoken/)
2. Find your page
3. Click **Generate Token**
4. Copy the Page Access Token

#### E. Get Page ID

**Method 1: From Page About Section**
1. Go to your Facebook Page
2. Click **About** tab
3. Scroll down to find **Page ID**

**Method 2: Using Graph API Explorer**
1. In Graph API Explorer, enter: `me/accounts`
2. Find your page in the response
3. Copy the `id` field

#### F. Get Form IDs

**Method 1: From Page Publishing Tools**
1. Go to your Facebook Page
2. Click **Publishing Tools**
3. Click **Forms Library**
4. Click on a form
5. Look at the URL: `facebook.com/.../?form_id=XXXXX`
6. Copy the Form ID

**Method 2: Using Graph API Explorer**
1. Enter endpoint: `{PAGE_ID}/leadgen_forms`
2. Add fields: `id,name`
3. Submit request
4. Copy Form IDs from response

### 4. Configure Module (5 minutes)

1. In Perfex CRM, go to **Setup → Integrations → Facebook Leads Integration**

2. Fill in **Facebook App Configuration**:
   ```
   App ID: [Your App ID from step 3B]
   App Secret: [Your App Secret from step 3B]
   Page ID: [Your Page ID from step 3E]
   Page Access Token: [Your token from step 3D]
   Lead Form IDs: [Form IDs from step 3F, comma-separated]
   ```

3. Fill in **Lead Import Settings**:
   ```
   Default Assigned Staff: [Select staff member]
   Default Lead Status: [Select status, e.g., "New"]
   Lead Source: [Select "Facebook"]
   Cron Interval: [15 minutes recommended]
   ```

4. Click **Test Connection** button
   - Should show: "Connection successful! Page: [Your Page Name]"
   - If error, double-check credentials

5. Toggle **Enable Integration** to ON

6. Click **Save Settings**

### 5. Set Up Cron Job (5 minutes)

Choose your server type:

#### For Linux/Unix Servers

1. SSH into your server
2. Edit crontab:
   ```bash
   crontab -e
   ```

3. Add this line (adjust path to your Perfex installation):
   ```bash
   */15 * * * * /usr/bin/php /var/www/html/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php >> /var/www/html/perfex/modules/facebook_leads_integration/logs/cron.log 2>&1
   ```

4. Save and exit

5. Verify cron job is added:
   ```bash
   crontab -l
   ```

#### For cPanel Hosting

1. Login to cPanel
2. Find **Cron Jobs** section
3. Add new cron job:
   - **Minute**: `*/15` (every 15 minutes)
   - **Hour**: `*`
   - **Day**: `*`
   - **Month**: `*`
   - **Weekday**: `*`
   - **Command**:
     ```
     /usr/bin/php /home/username/public_html/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
     ```
4. Click **Add New Cron Job**

#### For Windows Server

1. Open **Task Scheduler**
2. Click **Create Basic Task**
3. Name: "Fetch Facebook Leads"
4. Trigger: **Daily** (we'll adjust frequency next)
5. Action: **Start a program**
6. Program: `C:\php\php.exe` (your PHP path)
7. Arguments: `C:\inetpub\wwwroot\perfex\modules\facebook_leads_integration\cron\fetch_facebook_leads.php`
8. Click **Finish**
9. Right-click task → **Properties**
10. Go to **Triggers** → **Edit**
11. Check **Repeat task every**: 15 minutes
12. Duration: **Indefinitely**
13. Click **OK**

#### Test Cron Job Manually

Run this command to test:
```bash
php /path/to/perfex/modules/facebook_leads_integration/cron/fetch_facebook_leads.php
```

Expected output:
```
[2024-01-15 10:30:00] Facebook Leads Cron Job Started
[2024-01-15 10:30:00] Fetching leads from Facebook...
[2024-01-15 10:30:02] Fetch completed:
  - Imported: 5
  - Duplicates: 2
  - Errors: 0
[2024-01-15 10:30:02] Cron job finished successfully
```

### 6. Set Up Webhooks (Optional - 10 minutes)

For **real-time** lead delivery (recommended for best user experience):

#### Prerequisites

- ✅ Your Perfex CRM must be accessible via HTTPS (SSL required)
- ✅ Valid SSL certificate (Let's Encrypt works fine)

#### Configure Webhook

1. In Perfex CRM, go to module settings
2. Copy these values:
   - **Webhook URL**: `https://yourdomain.com/index.php/facebook_leads_integration/webhook`
   - **Verify Token**: (shown in settings)

3. Go to Facebook App Dashboard
4. Click **Webhooks** (under Products in left menu)
5. Click **Add Subscriptions** for **Page**

6. Enter webhook details:
   ```
   Callback URL: [Your Webhook URL from step 2]
   Verify Token: [Your Verify Token from step 2]
   ```

7. Check subscription field: **leadgen**

8. Click **Verify and Save**
   - Should show success message
   - If fails, check SSL certificate and URL accessibility

9. Subscribe App to Page:
   - Open [Graph API Explorer](https://developers.facebook.com/tools/explorer/)
   - Select your app
   - Use your Page Access Token
   - Make POST request to: `{PAGE_ID}/subscribed_apps`
   - Add parameter: `subscribed_fields` = `leadgen`
   - Click **Submit**
   - Should return: `{"success": true}`

#### Test Webhook

1. Submit a test lead on your Facebook form
2. Check in Perfex CRM:
   - Go to **Leads** section
   - New lead should appear within seconds
3. Check logs:
   - Go to module **Logs** tab
   - Should show successful import

## Verification Checklist

After installation, verify everything works:

- [ ] Module is activated in Perfex
- [ ] "Facebook" lead source exists
- [ ] Test connection shows success
- [ ] Integration is enabled
- [ ] Cron job is scheduled
- [ ] Manual "Fetch Now" button works
- [ ] Leads appear in CRM after fetch
- [ ] Logs show successful imports
- [ ] Dashboard widget displays statistics
- [ ] Webhook verification passed (if using webhooks)
- [ ] Test lead appears in real-time (if using webhooks)

## Common Installation Issues

### Issue: "Connection failed" on test

**Solution**: 
- Verify App ID and App Secret are correct
- Check Page Access Token hasn't expired
- Ensure token has `leads_retrieval` permission
- Try regenerating the token

### Issue: Module not appearing in Setup menu

**Solution**:
- Clear Perfex CRM cache
- Log out and log back in
- Check file permissions (755 for folders, 644 for files)
- Verify folder structure is correct

### Issue: Cron job not running

**Solution**:
- Test manually first to check for PHP errors
- Check PHP path is correct
- Verify file permissions (755 for cron script)
- Check cron logs for errors
- Ensure PHP has curl extension enabled

### Issue: Webhook verification fails

**Solution**:
- Ensure site is HTTPS (not HTTP)
- Check SSL certificate is valid
- Verify webhook URL is accessible publicly
- Check Verify Token matches exactly (case-sensitive)
- Look for errors in module logs

### Issue: Database tables not created

**Solution**:
- Deactivate and reactivate module
- Check database user has CREATE TABLE permission
- Look for errors in Perfex error logs
- Manually run install.php if needed

## Getting Help

If you encounter issues:

1. **Check logs**:
   ```
   /modules/facebook_leads_integration/logs/error_[date].log
   /modules/facebook_leads_integration/logs/info_[date].log
   ```

2. **Enable Perfex debug mode**:
   - Edit `application/config/config.php`
   - Set: `$config['debug'] = true;`

3. **Test manually**:
   ```bash
   php cron/fetch_facebook_leads.php
   ```

4. **Check permissions**:
   ```bash
   chmod -R 755 modules/facebook_leads_integration
   chmod -R 777 modules/facebook_leads_integration/logs
   ```

## Next Steps

After successful installation:

1. **Test the integration**: Click "Fetch Leads Now" to import existing leads
2. **Monitor logs**: Check the Logs tab to ensure everything works
3. **Configure notifications**: Set up email notifications for new leads in Perfex
4. **Train staff**: Show your team where to find imported leads
5. **Set up automation**: Create workflows for follow-up actions

## Security Recommendations

After installation:

- [ ] Keep App Secret secure (never share publicly)
- [ ] Use environment variables for sensitive data (optional)
- [ ] Regularly check Facebook App permissions
- [ ] Monitor logs for unauthorized access attempts
- [ ] Keep Perfex CRM updated
- [ ] Use strong passwords for Facebook account
- [ ] Enable two-factor authentication on Facebook account

---

**Installation Complete!** 🎉

Your Facebook Leads Integration is now ready to automatically import leads into Perfex CRM.

