<?php
/**
 * Follow-up Functionality Validation Script
 * Tests the core components of the follow-up fix
 */

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>CRM Follow-up Functionality Validation</h1>\n";
echo "<h2>Testing Core Components</h2>\n";

// Test 1: Check if modified files exist and are readable
echo "<h3>1. File Existence Check</h3>\n";
$files_to_check = [
    'Controller' => 'c:\xampp\htdocs\crm.ibrayagroup.com\application\controllers\admin\Leads.php',
    'JavaScript' => 'c:\xampp\htdocs\crm.ibrayagroup.com\assets\js\leads.js',
    'Lead View' => 'c:\xampp\htdocs\crm.ibrayagroup.com\application\views\admin\leads\lead.php',
    'Misc Model' => 'c:\xampp\htdocs\crm.ibrayagroup.com\application\models\Misc_model.php'
];

foreach ($files_to_check as $type => $file) {
    $file = str_replace('c:', '', $file); // Remove C: for relative path
    $file = __DIR__ . str_replace('\\', '/', $file);
    if (file_exists($file)) {
        echo "✅ $type: File exists and is readable<br>\n";
    } else {
        echo "❌ $type: File missing or not accessible - $file<br>\n";
    }
}

// Test 2: Check PHP syntax of controller
echo "<h3>2. PHP Syntax Validation</h3>\n";
$controller_file = __DIR__ . '/application/controllers/admin/Leads.php';
if (file_exists($controller_file)) {
    $syntax_check = shell_exec("php -l \"$controller_file\" 2>&1");
    if (strpos($syntax_check, 'No syntax errors') !== false) {
        echo "✅ Controller PHP syntax is valid<br>\n";
    } else {
        echo "❌ Controller has syntax errors:<br>\n<pre>$syntax_check</pre>\n";
    }
} else {
    echo "❌ Controller file not found for syntax check<br>\n";
}

// Test 3: Check for required functions
echo "<h3>3. Function Availability Check</h3>\n";
if (file_exists($controller_file)) {
    $controller_content = file_get_contents($controller_file);
    
    // Check for add_note function
    if (strpos($controller_content, 'public function add_note') !== false) {
        echo "✅ add_note() function found<br>\n";
    } else {
        echo "❌ add_note() function not found<br>\n";
    }
    
    // Check for JSON response
    if (strpos($controller_content, 'json_encode') !== false) {
        echo "✅ JSON response implementation found<br>\n";
    } else {
        echo "❌ JSON response implementation not found<br>\n";
    }
    
    // Check if redirect was removed
    if (strpos($controller_content, 'redirect(admin_url(\'leads/index/\'') === false) {
        echo "✅ Problematic redirect code has been removed<br>\n";
    } else {
        echo "❌ Problematic redirect code still present<br>\n";
    }
}

// Test 4: JavaScript validation
echo "<h3>4. JavaScript Implementation Check</h3>\n";
$js_file = __DIR__ . '/assets/js/leads.js';
if (file_exists($js_file)) {
    $js_content = file_get_contents($js_file);
    
    // Check for proper response handling
    if (strpos($js_content, 'response.leadView.data') !== false) {
        echo "✅ Correct response data access implemented<br>\n";
    } else {
        echo "❌ Response data access needs correction<br>\n";
    }
    
    // Check for message handling
    if (strpos($js_content, 'response.message') !== false) {
        echo "✅ Message handling implemented<br>\n";
    } else {
        echo "❌ Message handling not found<br>\n";
    }
} else {
    echo "❌ JavaScript file not found<br>\n";
}

// Test 5: Database configuration check
echo "<h3>5. Database Configuration</h3>\n";
$config_file = __DIR__ . '/application/config/app-config.php';
if (file_exists($config_file)) {
    echo "✅ App configuration file exists<br>\n";
    $config_content = file_get_contents($config_file);
    if (strpos($config_content, 'APP_DB_HOSTNAME') !== false) {
        echo "✅ Database configuration constants found<br>\n";
    } else {
        echo "❌ Database configuration incomplete<br>\n";
    }
} else {
    echo "❌ App configuration file not found<br>\n";
}

// Test 6: Required CodeIgniter files
echo "<h3>6. CodeIgniter Framework Check</h3>\n";
$ci_files = [
    'index.php' => __DIR__ . '/index.php',
    'CI System' => __DIR__ . '/system/core/CodeIgniter.php',
    'Base Controller' => __DIR__ . '/application/core/Admin_controller.php'
];

foreach ($ci_files as $name => $file) {
    if (file_exists($file)) {
        echo "✅ $name: Available<br>\n";
    } else {
        echo "❌ $name: Missing<br>\n";
    }
}

echo "<h2>Validation Summary</h2>\n";
echo "<p>The validation checks the core components required for the follow-up functionality fix.</p>\n";
echo "<p><strong>Next Steps:</strong></p>\n";
echo "<ul>\n";
echo "<li>If all checks pass: Deploy to production environment</li>\n";
echo "<li>If checks fail: Review the specific error messages above</li>\n";
echo "<li>Test the actual functionality using a browser</li>\n";
echo "</ul>\n";

echo "<h2>Manual Testing Instructions</h2>\n";
echo "<ol>\n";
echo "<li>Navigate to the CRM admin panel</li>\n";
echo "<li>Open any lead detail page</li>\n";
echo "<li>Add a follow-up note with a follow-up type</li>\n";
echo "<li>Verify the page doesn't redirect</li>\n";
echo "<li>Check that a success message appears</li>\n";
echo "<li>Confirm the note appears in the notes section with the follow-up type</li>\n";
echo "</ol>\n";

?>
