<?php
// Simple test to check if template is working
// Direct access to test template loading

// Include the template directly with test data
$notes = [
    [
        'id' => 999,
        'description' => 'Test WhatsApp message to verify enhanced template',
        'addedfrom' => 1,
        'dateadded' => date('Y-m-d H:i:s')
    ]
];

// Function stubs for testing
function get_staff_full_name($id) {
    return 'Test User';
}

function staff_profile_image($id, $classes) {
    return '<img src="data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7" width="32" height="32" class="' . implode(' ', $classes) . '">';
}

function _dt($date) {
    return date('M d, Y H:i', strtotime($date));
}

function process_text_content_for_display($text) {
    return nl2br(htmlspecialchars($text));
}

function has_permission($module, $capability, $action) {
    return true; // Always true for test
}

function get_staff_user_id() {
    return 1;
}

echo '<!DOCTYPE html>
<html>
<head>
    <title>Template Test</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; }
        h1 { color: #333; }
        .test-info { background: #f0f0f0; padding: 10px; margin: 20px 0; border-radius: 5px; }
    </style>
    <link rel="stylesheet" href="assets/css/custom.css">
</head>
<body>
    <h1>Direct Template Test</h1>
    <div class="test-info">
        <strong>Testing:</strong> admin/leads/_notes_template.php<br>
        <strong>Timestamp:</strong> ' . date('Y-m-d H:i:s') . '<br>
        <strong>Notes count:</strong> ' . count($notes) . '
    </div>
    
    <div class="lead-notes-wrapper">
';

// Include the template
include 'application/views/admin/leads/_notes_template.php';

echo '
    </div>
</body>
</html>';
?>
