<?php
// Simple database version checker and manual migration runner
// WARNING: Always backup your database before running migrations!

error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Database Migration Helper</h2>";
echo "<p style='color: red;'><strong>WARNING:</strong> Always backup your database before proceeding!</p>";

// Database credentials - Update these if needed
$db_host = 'localhost';
$db_user = 'autographcom_crmm';  // Update with your actual username
$db_pass = ')[p-K*neSz^G';  // Update with your actual password
$db_name = 'autographcom_crmmmm';  // Update with your actual database name
$db_prefix = 'tbl';

// Allow user to override credentials via URL parameters (for testing)
if (isset($_GET['host'])) $db_host = $_GET['host'];
if (isset($_GET['user'])) $db_user = $_GET['user'];
if (isset($_GET['pass'])) $db_pass = $_GET['pass'];
if (isset($_GET['name'])) $db_name = $_GET['name'];
if (isset($_GET['prefix'])) $db_prefix = $_GET['prefix'];

try {
    // Connect to database
    $conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
    
    if ($conn->connect_error) {
        throw new Exception("Connection failed: " . $conn->connect_error);
    }
    
    echo "<p><strong>✅ Database Connected:</strong> $db_name on $db_host</p>";
    
    // Get current migration version
    $result = $conn->query("SELECT version FROM {$db_prefix}migrations ORDER BY version DESC LIMIT 1");
    
    if (!$result) {
        throw new Exception("Error reading migrations table: " . $conn->error);
    }
    
    $row = $result->fetch_assoc();
    $currentVersion = $row ? (int)$row['version'] : 0;
    
    echo "<p><strong>Current Database Version:</strong> $currentVersion (" . wordwrap($currentVersion, 1, '.', true) . ")</p>";
    echo "<p><strong>Target Version:</strong> 332 (3.3.2)</p>";
    
    if ($currentVersion >= 332) {
        echo "<p style='color: green;'><strong>✅ Database is up to date!</strong></p>";
        echo "<p>No migration needed. Your database is already at version 3.3.2 or higher.</p>";
    } else {
        $missingMigrations = 332 - $currentVersion;
        echo "<p style='color: orange;'><strong>⚠️ Migration Required:</strong> $missingMigrations migrations needed</p>";
        
        // Check which migration files exist
        echo "<h3>Available Migration Files:</h3>";
        for ($version = $currentVersion + 1; $version <= 332; $version++) {
            $versionFormatted = sprintf('%03d', $version);
            $migrationFile = "application/migrations/{$versionFormatted}_version_{$versionFormatted}.php";
            
            if (file_exists($migrationFile)) {
                echo "<p>✅ Migration $versionFormatted: <strong>Found</strong></p>";
            } else {
                echo "<p>❌ Migration $versionFormatted: <strong>Missing</strong></p>";
            }
        }
        
        echo "<hr>";
        echo "<h3>🔧 How to Complete the Upgrade:</h3>";
        echo "<div style='background: #f0f0f0; padding: 15px; border-radius: 5px;'>";
        echo "<p><strong>Option 1 - Use CRM's Built-in Upgrade (Recommended):</strong></p>";
        echo "<ol>";
        echo "<li>Go to your admin panel: <a href='https://crm.ibrayagroup.com/admin' target='_blank'><strong>https://crm.ibrayagroup.com/admin</strong></a></li>";
        echo "<li>You should see a database upgrade prompt</li>";
        echo "<li>Click '<strong>Upgrade now</strong>' button</li>";
        echo "<li>The system will automatically run migrations " . ($currentVersion + 1) . " through 332</li>";
        echo "</ol>";
        echo "</div>";
        
        // If user wants to manually run specific migrations
        if (isset($_POST['run_migration'])) {
            echo "<hr>";
            echo "<h3>🔄 Manual Migration Execution:</h3>";
            
            $migrationToRun = (int)$_POST['migration_version'];
            if ($migrationToRun > $currentVersion && $migrationToRun <= 332) {
                echo "<p>Attempting to run migration $migrationToRun...</p>";
                
                // This is a simplified example - you'd need proper migration logic here
                if ($migrationToRun == 331) {
                    // Migration 331 logic would go here
                    echo "<p style='color: blue;'>Migration 331 would run here (update to 3.3.1)</p>";
                } elseif ($migrationToRun == 332) {
                    // Migration 332 - Add item_id to leads table
                    $sql = "ALTER TABLE {$db_prefix}leads ADD COLUMN item_id int(11) NULL DEFAULT NULL, ADD INDEX(item_id)";
                    
                    // Check if column already exists
                    $checkResult = $conn->query("SHOW COLUMNS FROM {$db_prefix}leads LIKE 'item_id'");
                    if ($checkResult->num_rows == 0) {
                        if ($conn->query($sql)) {
                            echo "<p style='color: green;'>✅ Migration 332: Added item_id column to leads table</p>";
                            
                            // Update migration version
                            $updateSql = "UPDATE {$db_prefix}migrations SET version = 332";
                            if ($conn->query($updateSql)) {
                                echo "<p style='color: green;'>✅ Database version updated to 332</p>";
                            } else {
                                echo "<p style='color: red;'>❌ Failed to update migration version: " . $conn->error . "</p>";
                            }
                        } else {
                            echo "<p style='color: red;'>❌ Failed to add item_id column: " . $conn->error . "</p>";
                        }
                    } else {
                        echo "<p style='color: blue;'>ℹ️ item_id column already exists in leads table</p>";
                    }
                }
            } else {
                echo "<p style='color: red;'>Invalid migration version specified</p>";
            }
        }
        
        echo "<hr>";
        echo "<div style='background: #fff3cd; padding: 15px; border-radius: 5px; border-left: 4px solid #ffc107;'>";
        echo "<h4>⚠️ Manual Migration (Advanced Users Only):</h4>";
        echo "<p>If the automatic upgrade fails, you can manually run specific migrations:</p>";
        echo "<form method='post'>";
        echo "<label for='migration_version'>Migration Version to Run:</label> ";
        echo "<select name='migration_version' id='migration_version'>";
        for ($v = $currentVersion + 1; $v <= 332; $v++) {
            echo "<option value='$v'>$v</option>";
        }
        echo "</select> ";
        echo "<button type='submit' name='run_migration' onclick='return confirm(\"Are you sure? Make sure you have a database backup!\")'>Run Migration</button>";
        echo "</form>";
        echo "<p><small>⚠️ Only use this if you understand database migrations and have a backup!</small></p>";
        echo "</div>";
    }
    
    $conn->close();
    
} catch (Exception $e) {
    echo "<p style='color: red;'><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<p>Please check your database credentials and try again.</p>";
}

echo "<hr>";
echo "<p><small>🗑️ Remember to delete this file after completing the upgrade for security!</small></p>";
?>
