<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<?php
$CI = &get_instance();
// Ensure security library loaded
if (!isset($CI->security)) {
  $CI->load->library('security');
}
if (isset($CI->security)) {
  $rd_csrf_token_name = $CI->security->get_csrf_token_name();
  $rd_csrf_hash = $CI->security->get_csrf_hash();
?>
<script>
// Expose CodeIgniter CSRF token (used by direct-api.js auto injection)
var csrf_token_name = <?= json_encode($rd_csrf_token_name); ?>;
var csrf_hash = <?= json_encode($rd_csrf_hash); ?>;
console.log('[Reporting Dashboard] CSRF vars injected', csrf_token_name);

// Helper function to add CSRF token to data
function addCSRFToken(data) {
    var result = Object.assign({}, data);
    result[csrf_token_name] = csrf_hash;
    return result;
}

// Helper function to make CSRF-safe fetch requests
function safeFetch(url, options) {
    options = options || {};
    if (options.method === 'POST' && options.body) {
        // If body is URLSearchParams, convert to object, add CSRF, convert back
        if (options.body instanceof URLSearchParams) {
            var data = {};
            for (var pair of options.body.entries()) {
                data[pair[0]] = pair[1];
            }
            data[csrf_token_name] = csrf_hash;
            options.body = new URLSearchParams(data);
        }
    }
    return fetch(url, options);
}
</script>
<?php } ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js@2.9.4/dist/Chart.min.js"></script>
<!-- Include direct-api helper -->
<script src="<?= module_dir_url('reporting_dashboard', 'assets/js/direct-api.js'); ?>"></script>
<style>
/* Enhanced Activity Table Styling */
#activity-log-table {
    width: 100% !important;
    table-layout: auto !important;
    display: table !important;
    visibility: visible !important;
    font-size: 13px;
}

.modern-activity-table {
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.modern-activity-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.modern-activity-table thead th {
    border: none;
    padding: 15px 8px;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 11px;
    letter-spacing: 0.5px;
}

.modern-activity-table thead th i {
    margin-right: 5px;
    opacity: 0.8;
}

.table-responsive {
    overflow-x: auto;
    clear: both;
    display: block !important;
    min-height: 200px;
    position: relative;
}

/* Ensure table shows immediately */
#activity-log-table tbody {
    display: table-row-group !important;
    background: #fff;
}

#activity-log-table tbody tr {
    transition: all 0.2s ease;
    border-bottom: 1px solid #f0f0f0;
}

#activity-log-table tbody tr:hover {
    background-color: #f8f9ff !important;
    transform: scale(1.01);
    box-shadow: 0 2px 8px rgba(102, 126, 234, 0.15);
}

#activity-log-table thead {
    display: table-header-group !important;
}

#activity-log-table .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
}

/* Activity type specific row styling */
.activity-recent {
    border-left: 4px solid #28a745;
}

.activity-today {
    border-left: 4px solid #17a2b8;
}

.activity-type-whatsapp {
    background-color: #e8f5e9;
}

.activity-type-phone-call {
    background-color: #e3f2fd;
}

.activity-type-email {
    background-color: #fff3e0;
}

.activity-type-sms {
    background-color: #f3e5f5;
}

/* Loading overlay */
.loading-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.9);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
}

.loading-content {
    text-align: center;
    color: #667eea;
}

.loading-content i {
    margin-bottom: 10px;
}

/* Badge styling for time ago and types */
.badge {
    border-radius: 20px;
    padding: 4px 8px;
    font-size: 10px;
    font-weight: 500;
}

.badge-success {
    background-color: #28a745;
}

.badge-info {
    background-color: #17a2b8;
}

.badge-warning {
    background-color: #ffc107;
    color: #212529;
}

.badge-secondary {
    background-color: #6c757d;
}

#activity-log-table .followup-type-col {
    min-width: 120px;
}

/* Ensure proper spacing */
.reporting-dashboard .panel_s {
    margin-bottom: 20px;
}

/* Fix for date filter form */
.form-inline .form-group {
    display: inline-block;
    margin-bottom: 0;
    vertical-align: middle;
}

/* Reminder count badges */
.panel-title .badge {
    font-size: 11px;
    margin-left: 8px;
    padding: 3px 7px;
    border-radius: 10px;
    font-weight: 600;
}

.badge-warning {
    background-color: #f39c12;
    color: white;
}

.badge-danger {
    background-color: #e74c3c;
    color: white;
}

.badge-info {
    background-color: #3498db;
    color: white;
}

/* Ensure buttons don't break layout */
.btn-group-sm > .btn {
    white-space: nowrap;
}

/* Fix clearfix issues */
.clearfix::after {
    content: "";
    display: table;
    clear: both;
}

/* Reminder styling */
.reminder-item:hover {
    background-color: #f8f9fa !important;
    transform: translateX(2px);
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.reminder-item {
    border-radius: 4px;
    margin-bottom: 2px;
    transition: all 0.2s ease;
}

.reminder-item:hover .text-primary {
    color: #007bff !important;
    font-weight: bold;
}

.reminder-item .row {
    margin: 0;
}

.reminder-item .col-md-8,
.reminder-item .col-md-4 {
    padding: 8px 12px;
}

/* Enhanced reminder info styling */
.reminder-item .text-muted {
    font-size: 0.85em;
    margin-bottom: 2px;
}

.reminder-item .fa {
    width: 12px;
    text-align: center;
    margin-right: 4px;
}

.reminder-item strong {
    color: #2c3e50;
}

/* Reminder badges */
.reminder-item .badge {
    font-size: 10px;
    padding: 2px 6px;
}

/* Activity table styling */
#activity-log-table tbody tr:hover {
    background-color: #f8f9fa;
}

#activity-log-table .btn:hover {
    transform: scale(1.05);
}

/* Follow-up type styling */
#activity-log-table .followup-type-col {
    min-width: 120px;
    text-align: center;
}

.followup-type-icon {
    font-size: 14px;
    margin-right: 5px;
}

/* Activity type badges */
.activity-type-badge {
    padding: 3px 8px;
    border-radius: 3px;
    font-size: 11px;
    font-weight: bold;
}

/* Dropdown fixes */
.bootstrap-select {
    width: 100% !important;
}

.bootstrap-select .dropdown-toggle {
    width: 100%;
    padding: 6px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Fallback for regular select if bootstrap-select fails */
select[multiple] {
    height: auto !important;
    min-height: 34px;
}

#staff-filter, #activity-type-filter {
    width: 100%;
}

/* Ensure dropdowns are visible */
.selectpicker {
    display: block !important;
}

/* Date picker styling */
.datepicker {
    width: 100%;
}

/* Fallback styling for date inputs */
input[type="date"] {
    width: 100%;
    padding: 6px 12px;
    border: 1px solid #ddd;
    border-radius: 4px;
}

/* Ensure all form controls have consistent styling */
#date-from, #date-to, #activity-date-from, #activity-date-to {
    width: 100%;
}

/* Loading state for filters */
.filters-loading {
    opacity: 0.6;
    pointer-events: none;
}
</style>
<div id="wrapper">
  <div class="content reporting-dashboard">
    <div class="row">
      <div class="col-md-12">
        <div class="panel_s">
          <div class="panel-body">
            <div class="clearfix">
              <div class="pull-left">
                <h4 class="tw-font-semibold tw-text-lg tw-text-neutral-800"><?= _l('Reporting Dashboard'); ?></h4>
                <?php if (isset($show_permission_link) && $show_permission_link): ?>
                  <a href="<?= admin_url('reporting_dashboard/permissions'); ?>" class="btn btn-warning btn-xs">
                    <i class="fa fa-lock"></i> Manage Permissions
                  </a>
                <?php endif; ?>
              </div>
              <div class="pull-right">
                <div class="btn-group">
                  <button id="export-pdf" class="btn btn-danger btn-sm"><i class="fa fa-file-pdf-o"></i> Download PDF</button>
                  <button id="export-csv" class="btn btn-default btn-sm"><i class="fa fa-download"></i> CSV</button>
                  <button id="export-excel" class="btn btn-default btn-sm"><i class="fa fa-file-excel-o"></i> Excel</button>
                  <button id="export-print" class="btn btn-default btn-sm"><i class="fa fa-print"></i> Print</button>
                </div>
              </div>
            </div>
            <hr class="mtop15 mbot15">

            <!-- Filters -->
            <div class="panel_s">
              <div class="panel-body">
                <h5 class="tw-font-medium tw-text-neutral-800 tw-mb-3"><?= _l('Filters'); ?></h5>
                <div class="row">
                  <div class="col-md-4">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Date Range'); ?></label>
                      <div class="btn-group btn-group-sm mbot10" style="display: block;">
                        <button type="button" class="btn btn-default preset-btn" data-preset="today">Today</button>
                        <button type="button" class="btn btn-default preset-btn" data-preset="week">This Week</button>
                        <button type="button" class="btn btn-default preset-btn active" data-preset="month">This Month</button>
                      </div>
                      <div class="row">
                        <div class="col-md-6">
                          <input type="date" class="form-control" id="date-from" placeholder="From" autocomplete="off">
                        </div>
                        <div class="col-md-6">
                          <input type="date" class="form-control" id="date-to" placeholder="To" autocomplete="off">
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Staff'); ?></label>
                      <select id="staff-filter" class="form-control selectpicker" data-live-search="true" data-actions-box="true" multiple>
                        <?php if (!empty($staff_list)) : ?>
                          <?php foreach ($staff_list as $s): ?>
                            <option value="<?= (int)$s['staffid']; ?>" title="<?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?>">
                              <?= e(($s['firstname'] ?? '') . ' ' . ($s['lastname'] ?? '')); ?>
                            </option>
                          <?php endforeach; ?>
                        <?php else: ?>
                          <option value="" disabled>No staff available</option>
                        <?php endif; ?>
                      </select>
                      <small class="text-muted">
                        <?php if (!empty($staff_list)): ?>
                          <?= count($staff_list); ?> staff member(s) available
                        <?php else: ?>
                          No staff members available based on your permissions
                        <?php endif; ?>
                      </small>
                    </div>
                  </div>
                  <div class="col-md-3">
                    <div class="form-group">
                      <label class="control-label"><?= _l('Activity Type'); ?></label>
                      <select id="activity-type-filter" class="form-control selectpicker" multiple>
                        <option value="Lead">Lead Activities</option>
                        <option value="Task">Tasks</option>
                        <option value="Project">Projects</option>
                        <option value="Invoice">Invoices</option>
                        <option value="Auth">Login/Logout</option>
                        <option value="Other">Other</option>
                      </select>
                    </div>
                  </div>
                  <div class="col-md-2">
                    <div class="form-group">
                      <label class="control-label">&nbsp;</label>
                      <button id="apply-filters" class="btn btn-primary btn-block"><i class="fa fa-filter"></i> <?= _l('Apply'); ?></button>
                      <button id="refresh-dropdowns" class="btn btn-default btn-block btn-xs" style="margin-top: 5px;"><i class="fa fa-refresh"></i> Refresh Filters</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Detailed Activity Log -->
            <div class="panel_s mtop20">
              <div class="panel-body">
                <div class="clearfix">
                  <div class="pull-left">
                    <h5 class="panel-title">Activity Log</h5>
                  </div>
                  <div class="pull-right">
                    <button class="btn btn-default btn-sm" id="refresh-activities">
                      <i class="fa fa-refresh"></i> Refresh
                    </button>
                  </div>
                </div>
                
                <!-- Simple Filters -->
                <div class="row mtop15">
                  <div class="col-md-3">
                    <label>Staff Member:</label>
                    <select id="staff-filter" class="form-control">
                      <option value="">All Staff</option>
                    </select>
                  </div>
                  <div class="col-md-2">
                    <label>From Date:</label>
                    <input type="date" id="activity-date-from" class="form-control">
                  </div>
                  <div class="col-md-2">
                    <label>To Date:</label>
                    <input type="date" id="activity-date-to" class="form-control">
                  </div>
                  <div class="col-md-3">
                    <label>Search:</label>
                    <input type="text" id="activity-search" class="form-control" placeholder="Search activities...">
                  </div>
                  <div class="col-md-2">
                    <label>&nbsp;</label>
                    <button type="button" id="apply-filters" class="btn btn-primary btn-block">
                      <i class="fa fa-filter"></i> Apply Filters
                    </button>
                  </div>
                </div>
                
                <hr class="mtop15 mbot15">
                
                <!-- Activity Count -->
                <div class="mbot10">
                  <small class="text-muted">
                    <i class="fa fa-info-circle"></i> 
                    Showing <span id="activity-count">0</span> activities
                    <span class="pull-right">Last updated: <span id="last-update-time">-</span></span>
                  </small>
                </div>
                
                <!-- Scrollable Activity Container -->
                <div id="activity-container" style="max-height: 600px; overflow-y: auto; border: 1px solid #ddd; border-radius: 4px;">
                  <div id="activity-loading" class="text-center" style="padding: 40px;">
                    <i class="fa fa-spinner fa-spin fa-2x"></i>
                    <p class="mtop10">Loading activities...</p>
                  </div>
                  <div id="activity-list" style="display: none;"></div>
                  <div id="no-activities" class="text-center" style="padding: 40px; display: none;">
                    <i class="fa fa-info-circle fa-2x text-muted"></i>
                    <p class="mtop10 text-muted">No activities found</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- KPIs -->
            <div class="row mtop20">
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-primary">
                      <i class="fa fa-calendar fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-today">0</h3>
                    <p class="text-muted mbot0">Activities Today</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-success">
                      <i class="fa fa-calendar-check-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-week">0</h3>
                    <p class="text-muted mbot0">This Week</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-info">
                      <i class="fa fa-calendar-o fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-month">0</h3>
                    <p class="text-muted mbot0">This Month</p>
                  </div>
                </div>
              </div>
              <div class="col-md-3">
                <div class="panel_s">
                  <div class="panel-body text-center">
                    <div class="text-warning">
                      <i class="fa fa-sign-in fa-2x"></i>
                    </div>
                    <h3 class="mtop10 mbot5" id="kpi-logins">0</h3>
                    <p class="text-muted mbot0">Logins Today</p>
                  </div>
                </div>
              </div>
            </div>

            <!-- Charts -->
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities by Staff</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activities Over Time</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activitiesOverTimeChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="row mtop20">
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">Activity Type Distribution</h5>
                    <div class="chart-container" style="position: relative; height: 300px;">
                      <canvas id="activityTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-users"></i> Top Active Staff</h5>
                    <div id="top-staff-list">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            
            <!-- Staff Performance Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bar-chart"></i> Staff Performance by Activity Type</h5>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="staffPerformanceChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Follow-up Types Chart -->
            <div class="row mtop20">
              <div class="col-md-12">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15">
                      <i class="fa fa-phone text-success"></i> Follow-up Types by Staff
                    </h5>
                    <p class="text-muted">Shows the breakdown of different follow-up types (calls, WhatsApp, emails, meetings, etc.) performed by each staff member in the selected date range.</p>
                    <div class="chart-container" style="position: relative; height: 400px;">
                      <canvas id="followupTypesChart"></canvas>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <!-- Reminders & Followups Section -->
            <div class="row mtop20">
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-bell text-warning"></i> Today's Reminders</h5>
                    <div id="todays-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders</h5>
                    <div id="due-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="col-md-4">
                <div class="panel_s">
                  <div class="panel-body">
                    <h5 class="panel-title mbot15"><i class="fa fa-calendar text-info"></i> Upcoming Reminders</h5>
                    <div id="upcoming-reminders">
                      <div class="text-muted text-center">Loading...</div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>



<!-- Modal -->
<div class="modal fade" id="rdLogModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">Log Details</h4>
      </div>
      <div class="modal-body" id="rd-log-details">
        <div class="text-center"><i class="fa fa-spinner fa-spin"></i></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal"><?= _l('close'); ?></button>
      </div>
    </div>
  </div>
</div>

<script>
// Global variables
var baseUrl = window.location.origin + window.location.pathname.split('/admin/')[0] + '/admin/';
var currentFilters = {};

// Function to force table rendering
// Add safeguard to prevent multiple simultaneous renders
var isTableRendering = false;

function forceTableRender() {
    if (isTableRendering) {
        // Table render already in progress, skipping...
        return;
    }
    
    isTableRendering = true;
    
    var table = document.getElementById('activity-log-table');
    var container = document.querySelector('.table-responsive');
    
    if (table && container) {
        // Force visibility
        table.style.display = 'table';
        table.style.visibility = 'visible';
        container.style.display = 'block';
        
        // Force reflow
        table.offsetHeight;
        container.offsetHeight;
        
        // Table rendering completed
    }
    
    // Reset the flag after a short delay
    setTimeout(function() {
        isTableRendering = false;
    }, 500);
}

// Function to normalize chart responses from real API (labels+data) or mock (chart_data)
function normalizeSimpleToDataset(obj, type){
  if(!obj) return null;
  // Mock shape already nested
  if(obj.chart_data) return obj.chart_data;
  // Real shape: {labels:[], data:[]} -> wrap
  if(Array.isArray(obj.labels) && Array.isArray(obj.data)){
    var colorSets = {
      bar: '#4e73df',
      line: '#1cc88a',
      pie: ['#4e73df','#1cc88a','#36b9cc','#f6c23e','#e74a3b','#858796']
    };
    var ds = {labels: obj.labels, datasets: []};
    if(type==='pie'){
      ds.datasets.push({data: obj.data, backgroundColor: colorSets.pie.slice(0, obj.data.length)});
    } else if(type==='line') {
      ds.datasets.push({label:'Activities', data: obj.data, borderColor: colorSets.line, fill:false});
    } else { // bar default
      ds.datasets.push({label:'Activities', data: obj.data, backgroundColor: colorSets.bar});
    }
    return ds;
  }
  return null;
}

// Function to load charts
function loadCharts(baseUrl, filters) {
    // Load Activities by Staff Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'bar');
    if(chartData) createActivitiesByStaffChart(chartData);
    })
    .catch(error => {
        console.error('Activities by staff chart failed:', error.message);
    });
    
    // Load Activities Over Time Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_over_time_chart', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'line');
    if(chartData) createActivitiesOverTimeChart(chartData);
    })
    .catch(error => {
        console.error('Activities over time chart failed:', error.message);
    });
    
    // Load Activity Types Chart
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_type_pie', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
  .then(data => {
    var chartData = normalizeSimpleToDataset(data,'pie');
    if(chartData) createActivityTypesChart(chartData);
    })
    .catch(error => {
        console.error('Activity types chart failed:', error.message);
    });
    
    // Load Reminders data
    console.log('Loading reminders with filters:', filters);
    safeFetch(baseUrl + 'reporting_dashboard/get_reminders', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => {
        console.log('Reminders response status:', response.status);
        return response.json();
    })
    .then(data => {
        console.log('Reminders data received:', data);
        loadReminders(data);
    })
    .catch(error => {
        console.error('Reminders load failed:', error);
        // Show error in UI
        document.getElementById('todays-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
        document.getElementById('due-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
        document.getElementById('upcoming-reminders').innerHTML = '<div class="alert alert-danger">Failed to load reminders: ' + error.message + '</div>';
    });
}

// Function to apply filters and load data
function applyFilters() {
    // Ensure selectpickers are refreshed before getting values
    if (typeof $ !== 'undefined' && $.fn.selectpicker) {
        $('#staff-filter').selectpicker('refresh');
        $('#activity-type-filter').selectpicker('refresh');
    }
    
    var filters = {
        from: document.getElementById('date-from').value,
        to: document.getElementById('date-to').value,
        staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
        activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value),
        // Remove manual pagination parameters - DataTables will handle this
    };
    
    // Synchronize activity log date filters with main date filters
    if (filters.from) {
        document.getElementById('activity-date-from').value = filters.from;
    }
    if (filters.to) {
        document.getElementById('activity-date-to').value = filters.to;
    }
    
    // Debug: Log filters being sent
    console.log('Apply Filters called with:', filters);
    console.log('Staff filter array:', filters.staff);
    console.log('Staff filter length:', filters.staff.length);
    
    currentFilters = filters;
    
    // Load KPIs
    var kpiUrl = baseUrl + 'reporting_dashboard/get_kpis';
    
    console.log('[KPI] Starting KPI load...');
    console.log('[KPI] URL:', kpiUrl);
    console.log('[KPI] Filters:', filters);
    
    safeFetch(kpiUrl, {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => {
        console.log('[KPI] Response status:', response.status);
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}: ${response.statusText}`);
        }
        return response.json();
    })
    .then(data => {
        console.log('[KPI] Data received:', data);
        // Update KPI displays
        document.getElementById('kpi-today').textContent = data.today || 0;
        document.getElementById('kpi-week').textContent = data.week || 0;
        document.getElementById('kpi-month').textContent = data.month || 0;
        document.getElementById('kpi-logins').textContent = data.logins_today || 0;
        
        // Update top staff list
        if (data.top_staff && data.top_staff.length > 0) {
            var staffHtml = '<div class="list-group">';
            data.top_staff.forEach(function(staff) {
                staffHtml += '<div class="list-group-item">' +
                    '<div class="row">' +
                    '<div class="col-md-8">' + staff.staff_name + '</div>' +
                    '<div class="col-md-4 text-right"><span class="badge badge-primary">' + staff.total + '</span></div>' +
                    '</div></div>';
            });
            staffHtml += '</div>';
            document.getElementById('top-staff-list').innerHTML = staffHtml;
        }
        
        console.log('[KPI] KPI update completed, loading activity table...');
        
        // Load activity table with current page size
        var pageSize = parseInt(localStorage.getItem('reporting_dashboard_page_length') || '25');
        var activityFilters = Object.assign({}, filters);
        activityFilters.length = pageSize == -1 ? 1000 : pageSize;
        activityFilters.start = 0;
        activityFilters.draw = 1;
        
        safeFetch(baseUrl + 'reporting_dashboard/get_activity_table', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(activityFilters)
        })
        .then(response => response.json())
        .then(data => {
            console.log('Activity table data received:', data);
            loadActivityLog(data);
        })
        .catch(error => {
            console.error('Activity table load failed:', error);
        });
        
        // Load charts
        safeFetch(baseUrl + 'reporting_dashboard/get_staff_activity_chart', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            // Reuse by creating normalized dataset with single bar series
            var chartData = normalizeSimpleToDataset(data,'bar');
            if(chartData){
                // For staff performance we want stacked? If only one dataset, just pass
                createStaffPerformanceChart({labels: chartData.labels, datasets: {'Activities': chartData.datasets[0]}});
            }
        })
        .catch(error => {
            console.error('Staff performance load failed:', error.message);
        });
        
        // Load follow-up types chart
        safeFetch(baseUrl + 'reporting_dashboard/get_followup_types_chart', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: new URLSearchParams(filters)
        })
        .then(response => response.json())
        .then(data => {
            createFollowupTypesChart(data);
        })
        .catch(error => {
            console.error('Follow-up types load failed:', error.message);
        });
    })
    .catch(error => {
        console.error('[KPI] Load failed:', error.message);
    });
}

// Function to get follow-up type with appropriate icon
function getFollowupTypeWithIcon(followupType, activityType) {
    if (!followupType || followupType.trim() === '') {
        // Return appropriate icon for non-followup activities
        switch(activityType) {
            case 'Reminder Created':
                return '<span class="text-warning"><i class="fa fa-bell"></i> Reminder</span>';
            case 'Lead Created':
                return '<span class="text-success"><i class="fa fa-plus-circle"></i> New Lead</span>';
            case 'Lead Assigned':
                return '<span class="text-info"><i class="fa fa-user"></i> Assignment</span>';
            default:
                return '<span class="text-muted"><i class="fa fa-circle-o"></i> N/A</span>';
        }
    }
    
    // Get appropriate icon and color for follow-up types
    var icon = 'fa-comment';
    var colorClass = 'text-primary';
    var typeText = followupType.toLowerCase();
    
    if (typeText.includes('call') || typeText.includes('phone')) {
        icon = 'fa-phone';
        colorClass = 'text-success';
    } else if (typeText.includes('email') || typeText.includes('mail')) {
        icon = 'fa-envelope';
        colorClass = 'text-info';
    } else if (typeText.includes('meeting') || typeText.includes('visit')) {
        icon = 'fa-calendar';
        colorClass = 'text-warning';
    } else if (typeText.includes('whatsapp') || typeText.includes('message')) {
        icon = 'fa-whatsapp';
        colorClass = 'text-success';
    } else if (typeText.includes('sms') || typeText.includes('text')) {
        icon = 'fa-mobile';
        colorClass = 'text-primary';
    } else if (typeText.includes('proposal') || typeText.includes('quote')) {
        icon = 'fa-file-text';
        colorClass = 'text-warning';
    } else if (typeText.includes('contract') || typeText.includes('agreement')) {
        icon = 'fa-handshake-o';
        colorClass = 'text-danger';
    }
    
    return '<span class="' + colorClass + '"><i class="fa ' + icon + '"></i> ' + followupType + '</span>';
}

// Function to load activity log
function loadActivityLog(data) {
    console.log('Enhanced loadActivityLog called with:', data);
    console.log('Data array length:', data.data ? data.data.length : 'No data array');
    
    // TEMPORARY: Use basic table with manual pagination until DataTables issues are resolved
    console.log('Using basic table with manual pagination');
    loadActivityLogWithPagination(data);
    return;
}

// Fallback function for when DataTables is not available
function loadActivityLogBasic(data) {
    console.log('Using basic table fallback');
    console.log('Data received:', data);
    console.log('Data array:', data.data);
    
    var tbody = document.querySelector('#activity-log-table tbody');
    if (!tbody) {
        console.error('Activity table tbody not found!');
        console.log('Trying to find table element...');
        var table = document.querySelector('#activity-log-table');
        console.log('Table element found:', table);
        if (table) {
            console.log('Table innerHTML:', table.innerHTML.substring(0, 200));
        }
        return;
    }
    
    console.log('tbody element found:', tbody);
    
    // Update activity statistics
    updateActivityStats(data);
    
    tbody.innerHTML = '';
    console.log('tbody cleared');
    
    if (data.data && data.data.length > 0) {
        console.log('Processing', data.data.length, 'activities');
        console.log('createEnhancedActivityRow function available:', typeof createEnhancedActivityRow !== 'undefined');
        
        data.data.forEach(function(activity, index) {
            console.log('Creating row for activity', index, ':', activity);
            try {
                var row = createEnhancedActivityRow(activity);
                tbody.appendChild(row);
                console.log('Row', index, 'added successfully');
                
                // Debug: Check if row is actually visible
                if (index === 0) {
                    console.log('First row HTML:', row.outerHTML.substring(0, 200));
                    console.log('First row style:', window.getComputedStyle(row));
                }
            } catch (error) {
                console.error('Error creating row', index, ':', error);
                console.log('Activity data that failed:', activity);
                
                // Fallback: Create a simple row
                try {
                    var simpleRow = document.createElement('tr');
                    simpleRow.innerHTML = `
                        <td>${activity.date || 'N/A'}</td>
                        <td>${activity.staff || 'N/A'}</td>
                        <td>${activity.lead || 'N/A'}</td>
                        <td>${activity.followup_type || 'N/A'}</td>
                        <td>${activity.description || 'N/A'}</td>
                        <td>Actions</td>
                    `;
                    tbody.appendChild(simpleRow);
                    console.log('Simple fallback row', index, 'added');
                } catch (fallbackError) {
                    console.error('Even simple row creation failed:', fallbackError);
                }
            }
        });
        console.log('All rows processed');
        
        // Debug: Check table visibility after all rows added
        var table = document.querySelector('#activity-log-table');
        console.log('Table after rows added:');
        console.log('- Table display style:', window.getComputedStyle(table).display);
        console.log('- Table visibility style:', window.getComputedStyle(table).visibility);
        console.log('- Table height:', window.getComputedStyle(table).height);
        console.log('- Table content:', table.innerHTML.substring(0, 300));
        
        // Force table to be visible
        table.style.display = 'table';
        table.style.visibility = 'visible';
        tbody.style.display = 'table-row-group';
        tbody.style.visibility = 'visible';
        
        console.log('Forced table visibility');
    } else {
        console.log('No data available, showing empty message');
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center text-muted" style="padding: 40px;">
                    <i class="fa fa-info-circle fa-2x" style="margin-bottom: 10px; opacity: 0.5;"></i><br>
                    No activity data found for the selected filters.<br>
                    <small>Try adjusting your date range or removing filters.</small>
                </td>
            </tr>
        `;
    }
    
    // Update last update time
    document.getElementById('last-update-time').textContent = new Date().toLocaleTimeString();
    
    console.log('Basic table loading completed');
}

// Function to load activity log with manual pagination
function loadActivityLogWithPagination(data) {
    console.log('Loading activity log with manual pagination');
    console.log('Data received:', data);
    
    var tbody = document.querySelector('#activity-log-table tbody');
    if (!tbody) {
        console.error('Activity table tbody not found!');
        return;
    }
    
    // Update activity statistics
    updateActivityStats(data);
    
    // Clear existing content
    tbody.innerHTML = '';
    
    // Get current page size preference
    var pageSize = parseInt(localStorage.getItem('reporting_dashboard_page_length') || '25');
    
    // Show message if we need to load more data
    if (data.data && data.data.length >= pageSize && pageSize > 25) {
        console.log('Need to reload data for page size:', pageSize);
        reloadDataWithPageSize(pageSize);
        return;
    }
    
    if (data.data && data.data.length > 0) {
        console.log('Displaying', data.data.length, 'activities');
        data.data.forEach(function(activity, index) {
            try {
                var row = createSimpleActivityRow(activity);
                tbody.appendChild(row);
            } catch (error) {
                console.error('Error creating row', index, ':', error);
            }
        });
        
        // Add pagination controls
        addPaginationControls(data);
    } else {
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center text-muted" style="padding: 40px;">
                    <i class="fa fa-info-circle fa-2x" style="margin-bottom: 10px; opacity: 0.5;"></i><br>
                    No activity data found for the selected filters.<br>
                    <small>Try adjusting your date range or removing filters.</small>
                </td>
            </tr>
        `;
    }
    
    // Update last update time
    document.getElementById('last-update-time').textContent = new Date().toLocaleTimeString();
}

// Function to create a simple activity row
function createSimpleActivityRow(activity) {
    var row = document.createElement('tr');
    
    var date = activity.date || 'N/A';
    var staff = activity.staff || 'System';
    var lead = activity.lead || 'N/A';
    var type = activity.followup_type || 'General';
    var description = activity.description || 'No description';
    
    row.innerHTML = `
        <td>
            <strong>${date}</strong><br>
            <small class="text-muted">${activity.readable_date || ''}</small>
        </td>
        <td>
            <i class="fa fa-user"></i> ${staff}
        </td>
        <td>${lead}</td>
        <td>
            <span class="text-info">
                <i class="fa fa-phone"></i> ${type}
            </span>
        </td>
        <td>${description}</td>
        <td>
            <div class="btn-group btn-group-sm">
                <button class="btn btn-xs btn-primary" title="View Details">
                    <i class="fa fa-eye"></i>
                </button>
            </div>
        </td>
    `;
    
    return row;
}

// Function to add pagination controls
function addPaginationControls(data) {
    // Find or create pagination container
    var paginationContainer = document.getElementById('activity-pagination');
    if (!paginationContainer) {
        paginationContainer = document.createElement('div');
        paginationContainer.id = 'activity-pagination';
        paginationContainer.className = 'row';
        paginationContainer.style.marginTop = '15px';
        document.querySelector('#activity-log-table').parentNode.appendChild(paginationContainer);
    }
    
    var pageSize = parseInt(localStorage.getItem('reporting_dashboard_page_length') || '25');
    var totalRecords = data.recordsTotal || data.data.length;
    
    paginationContainer.innerHTML = `
        <div class="col-md-6">
            <div class="form-inline">
                <label>Show 
                    <select id="page-size-selector" class="form-control input-sm" style="width: auto; display: inline-block;">
                        <option value="25" ${pageSize == 25 ? 'selected' : ''}>25</option>
                        <option value="50" ${pageSize == 50 ? 'selected' : ''}>50</option>
                        <option value="100" ${pageSize == 100 ? 'selected' : ''}>100</option>
                        <option value="-1" ${pageSize == -1 ? 'selected' : ''}>All</option>
                    </select>
                 entries</label>
            </div>
        </div>
        <div class="col-md-6 text-right">
            <p class="text-muted">Showing 1 to ${Math.min(pageSize, totalRecords)} of ${totalRecords} activities</p>
        </div>
    `;
    
    // Add event listener for page size change
    document.getElementById('page-size-selector').addEventListener('change', function() {
        var newPageSize = this.value;
        console.log('Page size changed to:', newPageSize);
        localStorage.setItem('reporting_dashboard_page_length', newPageSize);
        
        // Reload data with new page size
        reloadDataWithPageSize(newPageSize);
    });
}

// Function to reload data with specific page size
function reloadDataWithPageSize(pageSize) {
    console.log('Reloading data with page size:', pageSize);
    
    var filters = getCurrentFilters();
    filters.length = pageSize == -1 ? 1000 : parseInt(pageSize);
    filters.start = 0;
    filters.draw = 1;
    
    safeFetch(baseUrl + 'reporting_dashboard/get_activity_table', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams(filters)
    })
    .then(response => response.json())
    .then(data => {
        console.log('Data reloaded with new page size:', data);
        loadActivityLogWithPagination(data);
    })
    .catch(error => {
        console.error('Error reloading data:', error);
    });
}

// Function to get current filters
function getCurrentFilters() {
    return {
        from: document.getElementById('date-from').value,
        to: document.getElementById('date-to').value,
        staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
        activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
    };
}function createEnhancedActivityRow(activity) {
    var row = document.createElement('tr');
    
    // Add CSS classes for enhanced styling
    if (activity.DT_RowClass) {
        row.className = activity.DT_RowClass;
    }
    
    if (activity.DT_RowId) {
        row.id = activity.DT_RowId;
    }
    
    // Enhanced date display with time ago
    var dateHtml = `
        <div>
            <strong>${activity.date || 'N/A'}</strong><br>
            <small class="text-muted">${activity.readable_date || ''}</small><br>
            ${activity.time_ago || ''}
        </div>
    `;
    
    // Enhanced staff display
    var staffHtml = `
        <div>
            <i class="fa fa-user"></i> ${activity.staff || 'System'}
            ${activity.staff_id ? `<br><small class="text-muted">ID: ${activity.staff_id}</small>` : ''}
        </div>
    `;
    
    // Enhanced lead display with contact info
    var leadHtml = activity.lead || 'N/A';
    
    // Enhanced followup type with icon and priority
    var followupTypeHtml = getEnhancedFollowupType(activity.followup_type, activity.priority);
    
    // Enhanced description with truncation
    var descriptionHtml = getEnhancedDescription(activity.description || activity.raw_description || 'No description');
    
    // Enhanced actions
    var actionsHtml = createEnhancedActions(activity);
    
    row.innerHTML = `
        <td>${dateHtml}</td>
        <td>${staffHtml}</td>
        <td>${leadHtml}</td>
        <td>${followupTypeHtml}</td>
        <td>${descriptionHtml}</td>
        <td>${actionsHtml}</td>
    `;
    
    return row;
}

function getEnhancedFollowupType(type, priority) {
    var icons = {
        'WhatsApp Message': 'fa-whatsapp',
        'WhatsApp Call': 'fa-whatsapp',
        'Phone Call': 'fa-phone',
        'Call': 'fa-phone',
        'Email': 'fa-envelope',
        'Message': 'fa-comment',
        'SMS': 'fa-comment',
        'Visit': 'fa-map-marker',
        'Meeting': 'fa-handshake-o',
        'Reminder': 'fa-clock-o',
        'Status Update': 'fa-refresh',
        'Proposal': 'fa-file-text',
        'Contract': 'fa-file-contract',
        'Invoice': 'fa-money',
        'Note': 'fa-sticky-note',
        'Assignment': 'fa-user-plus',
        'Demo': 'fa-play-circle',
        'Site Visit': 'fa-map-marker',
        'Activity Created': 'fa-plus-circle',
        'Activity Added': 'fa-plus',
        'General': 'fa-info-circle'
    };
    
    var colors = {
        'WhatsApp Message': 'success',
        'WhatsApp Call': 'success',
        'Phone Call': 'primary',
        'Call': 'primary',
        'Email': 'warning',
        'Message': 'info',
        'SMS': 'info',
        'Visit': 'danger',
        'Meeting': 'danger',
        'Reminder': 'default',
        'Status Update': 'info',
        'Note': 'default',
        'Activity Created': 'success',
        'Activity Added': 'success',
        'General': 'default'
    };
    
    var icon = icons[type] || 'fa-info-circle';
    var color = colors[type] || 'default';
    
    // Show only the followup type without priority indicators
    return `
        <span class="label label-${color}" style="font-size: 11px;">
            <i class="fa ${icon}"></i> ${type || 'General'}
        </span>
    `;
}

function getEnhancedDescription(description) {
    var maxLength = 100;
    var truncated = description.length > maxLength ? description.substring(0, maxLength) + '...' : description;
    
    return `
        <div title="${description}">
            ${truncated}
            ${description.length > maxLength ? 
                `<br><small><a href="#" onclick="showFullDescription('${description.replace(/'/g, "\\'")}'); return false;">Show more</a></small>` : 
                ''
            }
        </div>
    `;
}

function createEnhancedActions(activity) {
    var actions = [];
    
    if (activity.lead_id && activity.lead_id > 0) {
        actions.push(`
            <a href="${baseUrl}leads/index/${activity.lead_id}" class="btn btn-xs btn-primary" title="View Lead">
                <i class="fa fa-eye"></i>
            </a>
        `);
    }
    
    actions.push(`
        <button class="btn btn-xs btn-default" onclick="showActivityDetails(${activity.id})" title="Details">
            <i class="fa fa-info-circle"></i>
        </button>
    `);
    
    if (activity.followup_type !== 'General') {
        actions.push(`
            <button class="btn btn-xs btn-success" onclick="createFollowup(${activity.lead_id})" title="Create Follow-up">
                <i class="fa fa-plus"></i>
            </button>
        `);
    }
    
    return actions.join(' ');
}

function updateActivityStats(data) {
    var countElement = document.getElementById('activity-count');
    if (countElement && data) {
        var total = data.recordsTotal || 0;
        var filtered = data.recordsFiltered || 0;
        var displayed = (data.data && data.data.length) || 0;
        
        countElement.innerHTML = `
            Showing ${displayed} of ${filtered} activities
            ${total !== filtered ? ` (${total} total)` : ''}
        `;
    }
}

// Enhanced utility functions
function showFullDescription(description) {
    alert(description);
}

function showActivityDetails(activityId) {
    console.log('Show details for activity:', activityId);
    // Implement activity details modal
}

function createFollowup(leadId) {
    if (leadId) {
        window.location.href = baseUrl + 'leads/index/' + leadId + '#tab_notes';
    }
}

// Auto-refresh functionality
var autoRefreshInterval = null;
var autoRefreshEnabled = false;

function toggleAutoRefresh() {
    var button = document.getElementById('toggle-auto-refresh');
    var status = document.getElementById('auto-refresh-status');
    
    if (autoRefreshEnabled) {
        clearInterval(autoRefreshInterval);
        autoRefreshEnabled = false;
        status.textContent = 'OFF';
        button.classList.remove('btn-success');
        button.classList.add('btn-default');
    } else {
        autoRefreshInterval = setInterval(function() {
            applyFilters();
        }, 30000); // Refresh every 30 seconds
        autoRefreshEnabled = true;
        status.textContent = 'ON';
        button.classList.remove('btn-default');
        button.classList.add('btn-success');
    }
}

// Enhanced event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Refresh button
    var refreshBtn = document.getElementById('refresh-activity-table');
    if (refreshBtn) {
        refreshBtn.addEventListener('click', function() {
            applyFilters();
        });
    }
    
    // Auto-refresh toggle
    var autoRefreshBtn = document.getElementById('toggle-auto-refresh');
    if (autoRefreshBtn) {
        autoRefreshBtn.addEventListener('click', toggleAutoRefresh);
    }
    
    // Search functionality
    var searchInput = document.getElementById('activity-search');
    var searchBtn = document.getElementById('search-activity');
    
    if (searchInput && searchBtn) {
        searchBtn.addEventListener('click', function() {
            // Implement search functionality
            console.log('Search for:', searchInput.value);
        });
        
        searchInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                searchBtn.click();
            }
        });
    }
});

// Function to load reminders
function loadReminders(data) {
    console.log('loadReminders called with data:', data);
    
    // Check if data has the expected structure
    if (!data || typeof data !== 'object') {
        console.error('Invalid reminders data:', data);
        return;
    }
    
    // Helper function to format reminder item
    function formatReminderItem(reminder, borderColor, dateColor, dateIcon) {
        var staffInfo = reminder.staff_name ? 
            '<small class="text-muted"><i class="fa fa-user"></i> ' + reminder.staff_name + '</small><br>' : '';
        
        var relatedInfo = '';
        if (reminder.related_name && reminder.related_name !== reminder.rel_type + ' #' + reminder.rel_id) {
            relatedInfo = '<small class="text-muted"><i class="fa fa-link"></i> ' + 
                         reminder.rel_type.charAt(0).toUpperCase() + reminder.rel_type.slice(1) + 
                         ': <strong>' + reminder.related_name + '</strong></small><br>';
        }
        
        var emailInfo = reminder.related_email ? 
            '<small class="text-muted"><i class="fa fa-envelope"></i> ' + reminder.related_email + '</small>' : '';
        
        return '<div class="list-group-item reminder-item" onclick="viewReminderDetails(\'' + 
               reminder.id + '\', \'' + reminder.rel_type + '\', \'' + reminder.rel_id + 
               '\')" style="cursor: pointer; transition: all 0.2s; border-left: 4px solid ' + borderColor + ';">' +
               '<div class="row">' +
               '<div class="col-md-8">' +
                   '<strong>' + (reminder.description || 'No description') + '</strong><br>' +
                   staffInfo +
                   relatedInfo +
                   emailInfo +
               '</div>' +
               '<div class="col-md-4 text-right">' +
                   '<small class="' + dateColor + '"><i class="fa ' + dateIcon + '"></i> ' + reminder.date + '</small><br>' +
                   '<small class="text-primary"><i class="fa fa-external-link"></i> Click to view</small>' +
               '</div>' +
               '</div></div>';
    }
    
    // Load today's reminders
    console.log('Processing today\'s reminders:', data.todays);
    if (data.todays && data.todays.length > 0) {
        var html = '<div class="list-group">';
        data.todays.forEach(function(reminder) {
            html += formatReminderItem(reminder, '#f39c12', 'text-warning', 'fa-clock-o');
        });
        html += '</div>';
        document.getElementById('todays-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#todays-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-bell text-warning"></i> Today\'s Reminders <span class="badge badge-warning">' + data.todays.length + '</span>';
        }
    } else {
        console.log('No today\'s reminders found');
        document.getElementById('todays-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-calendar-check-o fa-2x"></i><br>No reminders for today</div>';
    }
    
    // Load due reminders
    console.log('Processing due reminders:', data.due);
    if (data.due && data.due.length > 0) {
        var html = '<div class="list-group">';
        data.due.forEach(function(reminder) {
            html += formatReminderItem(reminder, '#e74c3c', 'text-danger', 'fa-exclamation-triangle');
        });
        html += '</div>';
        document.getElementById('due-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#due-reminders').previousElementSibling;
        // Update heading with count
        var heading = document.querySelector('#due-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-exclamation-triangle text-danger"></i> Due Reminders <span class="badge badge-danger">' + data.due.length + '</span>';
        }
    } else {
        console.log('No due reminders found');
        document.getElementById('due-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-check-circle fa-2x"></i><br>No overdue reminders</div>';
    }
    
    // Load upcoming reminders
    if (data.upcoming && data.upcoming.length > 0) {
        var html = '<div class="list-group">';
        data.upcoming.forEach(function(reminder) {
            html += formatReminderItem(reminder, '#3498db', 'text-info', 'fa-calendar');
        });
        html += '</div>';
        document.getElementById('upcoming-reminders').innerHTML = html;
        
        // Update heading with count
        var heading = document.querySelector('#upcoming-reminders').previousElementSibling;
        if (heading) {
            heading.innerHTML = '<i class="fa fa-calendar text-info"></i> Upcoming Reminders <span class="badge badge-info">' + data.upcoming.length + '</span>';
        }
    } else {
        document.getElementById('upcoming-reminders').innerHTML = '<div class="text-muted text-center" style="padding: 20px;"><i class="fa fa-calendar-o fa-2x"></i><br>No upcoming reminders</div>';
    }
}

// Chart creation functions
function createActivitiesByStaffChart(chartData) {
    var ctx = document.getElementById('activitiesChart');
    if (!ctx) return;
    
    if (window.activitiesChart && typeof window.activitiesChart.destroy === 'function') {
        window.activitiesChart.destroy();
    }
    
    window.activitiesChart = new Chart(ctx, {
        type: 'bar',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createActivitiesOverTimeChart(chartData) {
    var ctx = document.getElementById('activitiesOverTimeChart');
    if (!ctx) return;
    
    if (window.activitiesOverTimeChart && typeof window.activitiesOverTimeChart.destroy === 'function') {
        window.activitiesOverTimeChart.destroy();
    }
    
    window.activitiesOverTimeChart = new Chart(ctx, {
        type: 'line',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createActivityTypesChart(chartData) {
    var ctx = document.getElementById('activityTypesChart');
    if (!ctx) return;
    
    if (window.activityTypesChart && typeof window.activityTypesChart.destroy === 'function') {
        window.activityTypesChart.destroy();
    }
    
    window.activityTypesChart = new Chart(ctx, {
        type: 'pie',
        data: chartData,
        options: {
            responsive: true,
            maintainAspectRatio: false
        }
    });
}

function createStaffPerformanceChart(chartData) {
    var ctx = document.getElementById('staffPerformanceChart');
    if (!ctx) return;
    
    if (window.staffPerformanceChart && typeof window.staffPerformanceChart.destroy === 'function') {
        window.staffPerformanceChart.destroy();
    }
    
    // Convert data format for stacked bar chart
    var datasets = [];
    if (chartData.datasets) {
        Object.keys(chartData.datasets).forEach(function(key) {
            datasets.push(chartData.datasets[key]);
        });
    }
    
    window.staffPerformanceChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartData.labels || [],
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    stacked: true
                }],
                yAxes: [{
                    stacked: true,
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

function createFollowupTypesChart(chartData) {
    var ctx = document.getElementById('followupTypesChart');
    if (!ctx) return;
    
    if (window.followupTypesChart && typeof window.followupTypesChart.destroy === 'function') {
        window.followupTypesChart.destroy();
    }
    
    // Convert data format for stacked bar chart
    var datasets = [];
    if (chartData.datasets) {
        chartData.datasets.forEach(function(dataset) {
            datasets.push(dataset);
        });
    }
    
    window.followupTypesChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: chartData.labels || [],
            datasets: datasets
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                xAxes: [{
                    stacked: true
                }],
                yAxes: [{
                    stacked: true,
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
}

// Function to view activity details
function viewActivityDetails(activityId) {
    // For now, just show basic info
    var modal = document.getElementById('rdLogModal');
    var modalBody = document.getElementById('rd-log-details');
    
    if (modal && modalBody) {
        modalBody.innerHTML = '<div class="text-center">' +
            '<h4>Activity Details</h4>' +
            '<p><strong>Activity ID:</strong> ' + activityId + '</p>' +
            '<p>Detailed information for this activity would be displayed here.</p>' +
            '</div>';
        
        // Show the modal using vanilla JavaScript
        modal.style.display = 'block';
    }
}

// Function to view reminder details
function viewReminderDetails(reminderId, relType, relId) {
    // Get the admin base URL from PHP
    var adminBaseUrl = '<?php echo admin_url(); ?>';
    
    // Determine the appropriate URL based on the related type
    var targetUrl = '';
    
    switch(relType) {
        case 'lead':
            targetUrl = adminBaseUrl + 'leads/index/' + relId;
            break;
        case 'client':
            targetUrl = adminBaseUrl + 'clients/client/' + relId;
            break;
        case 'task':
            targetUrl = adminBaseUrl + 'tasks/view/' + relId;
            break;
        case 'project':
            targetUrl = adminBaseUrl + 'projects/view/' + relId;
            break;
        case 'invoice':
            targetUrl = adminBaseUrl + 'invoices/list_invoices/' + relId;
            break;
        case 'estimate':
            targetUrl = adminBaseUrl + 'estimates/list_estimates/' + relId;
            break;
        case 'proposal':
            targetUrl = adminBaseUrl + 'proposals/list_proposals/' + relId;
            break;
        case 'contract':
            targetUrl = adminBaseUrl + 'contracts/contract/' + relId;
            break;
        case 'expense':
            targetUrl = adminBaseUrl + 'expenses/expense/' + relId;
            break;
        case 'credit_note':
            targetUrl = adminBaseUrl + 'credit_notes/list_credit_notes/' + relId;
            break;
        default:
            // For unknown types, try to show in a modal
            showReminderModal(reminderId, relType, relId);
            return;
    }
    
    // Navigate to the target page
    if (targetUrl) {
        window.open(targetUrl, '_blank');
    }
}

// Function to show reminder details in modal
function showReminderModal(reminderId, relType, relId) {
    var modal = document.getElementById('rdLogModal');
    var modalBody = document.getElementById('rd-log-details');
    
    if (modal && modalBody) {
        modalBody.innerHTML = '<div class="text-center">' +
            '<i class="fa fa-bell fa-3x text-warning" style="margin-bottom: 15px;"></i>' +
            '<h4>Reminder Details</h4>' +
            '<div class="well text-left" style="margin: 20px 0;">' +
                '<p><strong><i class="fa fa-hashtag"></i> Reminder ID:</strong> ' + reminderId + '</p>' +
                '<p><strong><i class="fa fa-tag"></i> Type:</strong> ' + relType.charAt(0).toUpperCase() + relType.slice(1) + '</p>' +
                '<p><strong><i class="fa fa-link"></i> Related ID:</strong> ' + relId + '</p>' +
            '</div>' +
            '<div class="alert alert-info">' +
                '<i class="fa fa-info-circle"></i> This reminder is linked to a <strong>' + relType + '</strong> with ID <strong>' + relId + '</strong>.' +
                '<br>The system could not determine the exact page to navigate to for this item type.' +
            '</div>' +
            '<div class="text-center">' +
                '<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>' +
            '</div>' +
            '</div>';
        
        // Show the modal using Bootstrap if available, otherwise vanilla JS
        if (typeof $ !== 'undefined' && $.fn.modal) {
            $(modal).modal('show');
        } else {
            modal.style.display = 'block';
            modal.classList.add('in');
        }
    }
}

// Function to set up event listeners
function setupEventListeners() {
    // Apply filters button
    document.getElementById('apply-filters').addEventListener('click', applyFilters);
    
    // Refresh dropdowns button
    document.getElementById('refresh-dropdowns').addEventListener('click', function() {
        console.log('[Reporting Dashboard] Manual refresh requested');
        
        // Reinitialize date pickers
        try {
            console.log('[Reporting Dashboard] Refreshing date inputs');
            // Ensure HTML5 date inputs are properly set
            if (typeof $ !== 'undefined') {
                $('#date-from, #date-to, #activity-date-from, #activity-date-to').attr('type', 'date');
                
                // Optional: Refresh Bootstrap datepicker if it exists
                if ($.fn.datepicker && $('.datepicker').length > 0) {
                    $('.datepicker').datepicker('destroy');
                    $('.datepicker').datepicker({
                        format: 'yyyy-mm-dd',
                        autoclose: true,
                        todayHighlight: true,
                        clearBtn: true,
                        orientation: 'bottom auto'
                    });
                }
            } else {
                // Fallback for vanilla JS
                var dateInputs = document.querySelectorAll('#date-from, #date-to, #activity-date-from, #activity-date-to');
                for (var i = 0; i < dateInputs.length; i++) {
                    dateInputs[i].type = 'date';
                }
            }
            console.log('[Reporting Dashboard] Date inputs refreshed');
        } catch (error) {
            console.error('[Reporting Dashboard] Date input refresh failed:', error);
        }
        
        // Reinitialize dropdowns
        try {
            if (typeof $ !== 'undefined' && $.fn.selectpicker) {
                $('#staff-filter, #activity-type-filter').selectpicker('destroy');
                
                setTimeout(function() {
                    // Set Bootstrap version manually
                    if ($.fn.selectpicker.Constructor) {
                        $.fn.selectpicker.Constructor.BootstrapVersion = '3.3.7';
                    }
                    
                    $('#staff-filter').selectpicker({
                        liveSearch: true,
                        actionsBox: true,
                        noneSelectedText: 'Select Staff Members',
                        style: 'btn-default'
                    });
                    
                    $('#activity-type-filter').selectpicker({
                        noneSelectedText: 'Select Activity Types',
                        style: 'btn-default'
                    });
                    
                    console.log('[Reporting Dashboard] Dropdowns manually refreshed');
                }, 100);
            }
        } catch (error) {
            console.error('[Reporting Dashboard] Dropdown refresh failed:', error);
        }
    });
    
    // Selectpicker change events
    if (typeof $ !== 'undefined' && $.fn.selectpicker) {
        $('#staff-filter').on('changed.bs.select', function() {
            console.log('Staff filter changed');
        });
        
        $('#activity-type-filter').on('changed.bs.select', function() {
            console.log('Activity type filter changed');
        });
    }
    
    // Sync main date filters with activity date filters
    document.getElementById('date-from').addEventListener('change', function() {
        document.getElementById('activity-date-from').value = this.value;
    });
    
    document.getElementById('date-to').addEventListener('change', function() {
        document.getElementById('activity-date-to').value = this.value;
    });
    
    // Sync activity date filters with main date filters
    document.getElementById('activity-date-from').addEventListener('change', function() {
        document.getElementById('date-from').value = this.value;
    });
    
    document.getElementById('activity-date-to').addEventListener('change', function() {
        document.getElementById('date-to').value = this.value;
    });
    
    // Date preset buttons
    document.querySelectorAll('.preset-btn').forEach(function(btn) {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.preset-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            var preset = this.dataset.preset;
            var today = new Date();
            var fromDate, toDate;
            
            switch(preset) {
                case 'today':
                    fromDate = today.toISOString().split('T')[0];
                    toDate = today.toISOString().split('T')[0];
                    break;
                case 'week':
                    var dayOfWeek = today.getDay();
                    var diff = today.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1);
                    fromDate = new Date(today.setDate(diff)).toISOString().split('T')[0];
                    toDate = new Date().toISOString().split('T')[0];
                    break;
                case 'month':
                    fromDate = new Date(today.getFullYear(), today.getMonth(), 1).toISOString().split('T')[0];
                    toDate = new Date().toISOString().split('T')[0];
                    break;
            }
            
            document.getElementById('date-from').value = fromDate;
            document.getElementById('date-to').value = toDate;
            
            // Apply filters
            applyFilters();
        });
    });
    
    // Activity log date filter
    document.getElementById('activity-apply-filter').addEventListener('click', function() {
        var activityFilters = {
            from: document.getElementById('activity-date-from').value,
            to: document.getElementById('activity-date-to').value,
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
        };
        
        // Synchronize main date filters with activity log date filters
        if (activityFilters.from) {
            document.getElementById('date-from').value = activityFilters.from;
        }
        if (activityFilters.to) {
            document.getElementById('date-to').value = activityFilters.to;
        }
        
        // Apply all filters (this will reload everything including activity log)
        applyFilters();
    });
    
    // PDF export button
    document.getElementById('export-pdf').addEventListener('click', function() {
        var currentFilters = {
            from: document.getElementById('date-from').value,
            to: document.getElementById('date-to').value,
            staff: Array.from(document.getElementById('staff-filter').selectedOptions).map(opt => opt.value),
            activity_type: Array.from(document.getElementById('activity-type-filter').selectedOptions).map(opt => opt.value)
        };
        
        var pdfUrl = baseUrl + 'reporting_dashboard/download_pdf?' + new URLSearchParams(currentFilters);
        window.open(pdfUrl, '_blank');
    });
    
    // CSV export button
    document.getElementById('export-csv').addEventListener('click', function() {
        // Implement CSV export
        alert('CSV export functionality will be implemented here');
    });
    
    // Excel export button
    document.getElementById('export-excel').addEventListener('click', function() {
        // Implement Excel export
        alert('Excel export functionality will be implemented here');
    });
    
    // Print button
    document.getElementById('export-print').addEventListener('click', function() {
        window.print();
    });
    
    // Table export buttons
    document.getElementById('table-export-csv').addEventListener('click', function() {
        // Implement table CSV export
        alert('Table CSV export functionality will be implemented here');
    });
    
    document.getElementById('table-export-excel').addEventListener('click', function() {
        // Implement table Excel export
        alert('Table Excel export functionality will be implemented here');
    });
}

// Initialize when document is ready - with jQuery safety
(function() {
    'use strict';
    
    var initAttempts = 0;
    var maxAttempts = 50; // 5 seconds maximum wait
    
    function waitForJQuery() {
        initAttempts++;
        
        if (typeof jQuery !== 'undefined' && jQuery.fn && jQuery.fn.jquery) {
            console.log('[Reporting Dashboard] jQuery available after', initAttempts, 'attempts, version:', jQuery.fn.jquery);
            jQuery(document).ready(function($) {
                initializeDashboard($);
            });
            return;
        }
        
        if (initAttempts >= maxAttempts) {
            console.error('[Reporting Dashboard] jQuery not available after', maxAttempts, 'attempts');
            // Try to initialize with basic JavaScript
            if (document.readyState === 'loading') {
                document.addEventListener('DOMContentLoaded', function() {
                    initializeDashboard(null);
                });
            } else {
                initializeDashboard(null);
            }
            return;
        }
        
        setTimeout(waitForJQuery, 100);
    }
    
    function initializeDashboard($) {
        console.log('[Reporting Dashboard] Document ready, initializing...');
        
        // Debug: Staff list data passed from PHP
        var staffListData = <?php echo json_encode($staff_list ?? []); ?>;
        var canViewAllStaff = <?php echo json_encode($can_view_all_staff ?? false); ?>;
        var userStaffId = <?php echo json_encode($user_staff_id ?? 0); ?>;
        console.log('[Reporting Dashboard] Staff list data:', staffListData);
        console.log('[Reporting Dashboard] Can view all staff:', canViewAllStaff);
        console.log('[Reporting Dashboard] Current user staff ID:', userStaffId);
        
        if (!$ && typeof jQuery !== 'undefined') {
            $ = jQuery;
        }
        
        // Initialize date pickers (simplified for HTML5 date inputs)
        function initializeDatePickers() {
            console.log('[Reporting Dashboard] Initializing date pickers...');
            
            // If jQuery is not available, use vanilla JavaScript fallback
            if (!$) {
                var dateInputs = document.querySelectorAll('#date-from, #date-to, #activity-date-from, #activity-date-to');
                for (var i = 0; i < dateInputs.length; i++) {
                    dateInputs[i].type = 'date';
                }
                return dateInputs.length > 0;
            }
            
            try {
                // Since we're using HTML5 date inputs, just ensure they're properly set up
                var dateInputs = $('#date-from, #date-to, #activity-date-from, #activity-date-to');
                dateInputs.attr('type', 'date');
                
                // Optional: Try to enhance with Bootstrap datepicker if available
                if ($.fn.datepicker && dateInputs.hasClass('datepicker')) {
                console.log('[Reporting Dashboard] Enhancing with Bootstrap datepicker');
                $('.datepicker').datepicker({
                    format: 'yyyy-mm-dd',
                    autoclose: true,
                    todayHighlight: true,
                    clearBtn: true,
                    orientation: 'bottom auto'
                });
            }
            
            console.log('[Reporting Dashboard] Date inputs initialized successfully');
            return true;
        } catch (error) {
            console.error('[Reporting Dashboard] Date picker initialization failed:', error);
            // Ensure HTML5 date inputs as fallback
            $('#date-from, #date-to, #activity-date-from, #activity-date-to').attr('type', 'date');
            return true;
        }
    }
    
    // Initialize selectpicker dropdowns using multiple methods
    function initializeDropdowns() {
        console.log('[Reporting Dashboard] Initializing dropdowns...');
        
        try {
            // Method 1: Manual Bootstrap Select initialization (more reliable)
            if ($.fn.selectpicker) {
                console.log('[Reporting Dashboard] Using direct selectpicker initialization');
                
                // Destroy any existing instances first
                $('#staff-filter, #activity-type-filter').selectpicker('destroy');
                
                // Set Bootstrap version manually to avoid detection issues
                if ($.fn.selectpicker.Constructor && !$.fn.selectpicker.Constructor.BootstrapVersion) {
                    $.fn.selectpicker.Constructor.BootstrapVersion = '3.3.7';
                }
                
                // Initialize staff filter
                $('#staff-filter').selectpicker({
                    liveSearch: true,
                    actionsBox: true,
                    noneSelectedText: 'Select Staff Members',
                    selectAllText: 'Select All',
                    deselectAllText: 'Deselect All',
                    countSelectedText: function(numSelected, numTotal) {
                        return numSelected + ' of ' + numTotal + ' selected';
                    },
                    style: 'btn-default',
                    size: 10
                });
                
                // Initialize activity type filter  
                $('#activity-type-filter').selectpicker({
                    noneSelectedText: 'Select Activity Types',
                    countSelectedText: function(numSelected, numTotal) {
                        return numSelected + ' of ' + numTotal + ' selected';
                    },
                    style: 'btn-default',
                    size: 10
                });
                
                console.log('[Reporting Dashboard] Direct selectpicker initialization successful');
                return true;
            }
        } catch (error) {
            console.warn('[Reporting Dashboard] Direct selectpicker failed:', error);
        }
        
        try {
            // Method 2: Try Perfex's init_selectpicker function as fallback
            if (typeof init_selectpicker === 'function') {
                console.log('[Reporting Dashboard] Trying Perfex init_selectpicker as fallback');
                init_selectpicker();
                console.log('[Reporting Dashboard] Perfex init_selectpicker successful');
                return true;
            }
        } catch (error) {
            console.warn('[Reporting Dashboard] Perfex init_selectpicker failed:', error);
        }
        
        // Method 3: Fallback - ensure dropdowns are at least functional
        console.warn('[Reporting Dashboard] Using fallback dropdown initialization');
        $('#staff-filter, #activity-type-filter').addClass('form-control');
        
        return false;
    }
    
    // Initialize both date pickers and dropdowns
    var datePickersInitialized = initializeDatePickers();
    var dropdownsInitialized = initializeDropdowns();
    
    // Set initial date values
    function setInitialDates() {
        var today = new Date();
        // Use last 60 days instead of current month to capture more test data
        var startDay = new Date(today);
        startDay.setDate(today.getDate() - 60);
        var todayStr = today.toISOString().split('T')[0];
        var startDayStr = startDay.toISOString().split('T')[0];
        
        // Set main filter dates
        $('#date-from').val(startDayStr);
        $('#date-to').val(todayStr);
        
        // Set activity log filter dates
        $('#activity-date-from').val(startDayStr);
        $('#activity-date-to').val(todayStr);
        
        console.log('[Reporting Dashboard] Initial dates set:', startDayStr, 'to', todayStr);
    }
    
    // Set dates after a brief delay to ensure elements are ready
    setTimeout(setInitialDates, 100);
    
    // Add change event handlers for dropdowns
    $('#staff-filter').on('changed.bs.select change', function() {
        console.log('[Reporting Dashboard] Staff filter changed');
    });
    
    $('#activity-type-filter').on('changed.bs.select change', function() {
        console.log('[Reporting Dashboard] Activity type filter changed'); 
    });
    
    // Add change event handlers for date inputs
    $('#date-from, #date-to').on('change changeDate', function() {
        console.log('[Reporting Dashboard] Date filter changed');
    });
    
    // Add diagnostic information to console
    setTimeout(function() {
        console.log('[Reporting Dashboard] DIAGNOSTIC INFO:');
        console.log('- jQuery available:', typeof $ !== 'undefined');
        console.log('- jQuery version:', typeof $ !== 'undefined' ? $.fn.jquery : 'N/A');
        console.log('- Bootstrap Select available:', typeof $ !== 'undefined' && $.fn.selectpicker);
        console.log('- Datepicker available:', typeof $ !== 'undefined' && $.fn.datepicker);
        console.log('- appDatepicker function available:', typeof appDatepicker === 'function');
        console.log('- init_selectpicker function available:', typeof init_selectpicker === 'function');
        
        // Only run jQuery-dependent diagnostics if $ is available
        if (typeof $ !== 'undefined') {
            console.log('- Staff filter element exists:', $('#staff-filter').length > 0);
            console.log('- Activity filter element exists:', $('#activity-type-filter').length > 0);
            console.log('- Date from element exists:', $('#date-from').length > 0);
            console.log('- Date to element exists:', $('#date-to').length > 0);
            console.log('- Staff options count:', $('#staff-filter option').length);
            console.log('- Activity options count:', $('#activity-type-filter option').length);
            
            // Check if elements are properly initialized
            var staffBootstrap = $('#staff-filter').parent().hasClass('bootstrap-select');
            var activityBootstrap = $('#activity-type-filter').parent().hasClass('bootstrap-select');
            console.log('- Staff filter has bootstrap-select wrapper:', staffBootstrap);
            console.log('- Activity filter has bootstrap-select wrapper:', activityBootstrap);
            
            // Check date picker initialization
            if (typeof $ !== 'undefined') {
                var dateFromInit = $('#date-from').hasClass('hasDatepicker') || $('#date-from').attr('type') === 'date';
                var dateToInit = $('#date-to').hasClass('hasDatepicker') || $('#date-to').attr('type') === 'date';
                console.log('- Date from initialized:', dateFromInit);
                console.log('- Date to initialized:', dateToInit);
            }
        } else {
            console.log('- Skipping jQuery-dependent diagnostics ($ not available)');
        }
        
        // Retry initialization if needed (only if jQuery is available)
        if (typeof $ !== 'undefined') {
            if (!staffBootstrap || !activityBootstrap) {
                console.warn('[Reporting Dashboard] Dropdowns not properly initialized, retrying...');
                setTimeout(function() {
                    initializeDropdowns();
                }, 500);
            }
            
            if (!dateFromInit || !dateToInit) {
                console.warn('[Reporting Dashboard] Date pickers not properly initialized, retrying...');
                setTimeout(function() {
                    initializeDatePickers();
                }, 500);
            }
        }
    }, 1000);
    
    // Wait a moment for everything to settle, then initialize charts and data
    setTimeout(function() {
        // Initialize charts if Chart.js is available
        if (typeof Chart !== 'undefined') {
            loadCharts(baseUrl, {});
        } else {
            console.error('[Reporting Dashboard] Chart.js not loaded');
        }
        
        // Load initial data
        applyFilters();
        
        // Set up event listeners
        setupEventListeners();
        
        // Force table render
        setTimeout(function() {
            forceTableRender();
        }, 1000);
        
    }, 1500);
    
    } // End initializeDashboard function
    
    // Start waiting for jQuery
    waitForJQuery();
})();
</script>

<?php init_tail(); ?>
