<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s glass-card">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="no-margin">
                                    <span style="background: linear-gradient(135deg, #06b6d4 0%, #14b8a6 100%); -webkit-background-clip: text; -webkit-text-fill-color: transparent; background-clip: text;">
                                        🎨 Dark Glass Theme Settings
                                    </span>
                                </h4>
                                <hr class="hr-panel-heading" />
                            </div>
                        </div>

                        <?php echo form_open(admin_url('darkglass_theme/settings'), ['class' => 'darkglass-settings-form']); ?>
                        
                        <div class="row">
                            <!-- General Settings -->
                            <div class="col-md-6">
                                <div class="panel panel-primary glass-card">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">General Settings</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="form-group">
                                            <div class="checkbox checkbox-primary">
                                                <input type="checkbox" 
                                                       id="theme_activated" 
                                                       name="theme_activated" 
                                                       value="1" 
                                                       <?php echo $settings['theme_activated'] == 1 ? 'checked' : ''; ?>>
                                                <label for="theme_activated">
                                                    <strong>Enable Dark Glass Theme</strong>
                                                    <br>
                                                    <small class="text-muted">Activate the dark glassmorphism theme across the CRM</small>
                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="animation_speed">Animation Speed</label>
                                            <select name="animation_speed" id="animation_speed" class="form-control selectpicker">
                                                <option value="slow" <?php echo $settings['animation_speed'] == 'slow' ? 'selected' : ''; ?>>Slow</option>
                                                <option value="normal" <?php echo $settings['animation_speed'] == 'normal' ? 'selected' : ''; ?>>Normal</option>
                                                <option value="fast" <?php echo $settings['animation_speed'] == 'fast' ? 'selected' : ''; ?>>Fast</option>
                                                <option value="disabled" <?php echo $settings['animation_speed'] == 'disabled' ? 'selected' : ''; ?>>Disabled</option>
                                            </select>
                                        </div>

                                        <div class="form-group">
                                            <div class="checkbox checkbox-primary">
                                                <input type="checkbox" 
                                                       id="orbs_enabled" 
                                                       name="orbs_enabled" 
                                                       value="1" 
                                                       <?php echo $settings['orbs_enabled'] == 1 ? 'checked' : ''; ?>>
                                                <label for="orbs_enabled">
                                                    Enable Animated Background Orbs
                                                </label>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <div class="checkbox checkbox-primary">
                                                <input type="checkbox" 
                                                       id="particles_enabled" 
                                                       name="particles_enabled" 
                                                       value="1" 
                                                       <?php echo $settings['particles_enabled'] == 1 ? 'checked' : ''; ?>>
                                                <label for="particles_enabled">
                                                    Enable Floating Particles
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Color Settings -->
                            <div class="col-md-6">
                                <div class="panel panel-info glass-card">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">Color Customization</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="form-group">
                                            <label for="primary_color">Primary Color</label>
                                            <div class="input-group">
                                                <input type="text" 
                                                       class="form-control colorpicker" 
                                                       id="primary_color" 
                                                       name="primary_color" 
                                                       value="<?php echo $settings['primary_color']; ?>">
                                                <span class="input-group-addon">
                                                    <i style="background-color: <?php echo $settings['primary_color']; ?>; width: 20px; height: 20px; display: inline-block; border-radius: 3px;"></i>
                                                </span>
                                            </div>
                                            <small class="text-muted">Main theme color (Default: #06b6d4)</small>
                                        </div>

                                        <div class="form-group">
                                            <label for="secondary_color">Secondary Color</label>
                                            <div class="input-group">
                                                <input type="text" 
                                                       class="form-control colorpicker" 
                                                       id="secondary_color" 
                                                       name="secondary_color" 
                                                       value="<?php echo $settings['secondary_color']; ?>">
                                                <span class="input-group-addon">
                                                    <i style="background-color: <?php echo $settings['secondary_color']; ?>; width: 20px; height: 20px; display: inline-block; border-radius: 3px;"></i>
                                                </span>
                                            </div>
                                            <small class="text-muted">Secondary theme color (Default: #14b8a6)</small>
                                        </div>

                                        <div class="form-group">
                                            <label for="accent_color">Accent Color</label>
                                            <div class="input-group">
                                                <input type="text" 
                                                       class="form-control colorpicker" 
                                                       id="accent_color" 
                                                       name="accent_color" 
                                                       value="<?php echo $settings['accent_color']; ?>">
                                                <span class="input-group-addon">
                                                    <i style="background-color: <?php echo $settings['accent_color']; ?>; width: 20px; height: 20px; display: inline-block; border-radius: 3px;"></i>
                                                </span>
                                            </div>
                                            <small class="text-muted">Accent color for warnings (Default: #fb923c)</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <!-- Glass Effect Settings -->
                            <div class="col-md-6">
                                <div class="panel panel-success glass-card">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">Glass Effect Settings</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="form-group">
                                            <label for="blur_intensity">Blur Intensity</label>
                                            <div class="row">
                                                <div class="col-sm-8">
                                                    <input type="range" 
                                                           id="blur_intensity" 
                                                           name="blur_intensity" 
                                                           min="0" 
                                                           max="40" 
                                                           value="<?php echo $settings['blur_intensity']; ?>" 
                                                           class="form-control">
                                                </div>
                                                <div class="col-sm-4">
                                                    <span id="blur_value" class="label label-info"><?php echo $settings['blur_intensity']; ?>px</span>
                                                </div>
                                            </div>
                                            <small class="text-muted">Controls the backdrop blur effect intensity</small>
                                        </div>

                                        <div class="form-group">
                                            <label for="glass_opacity">Glass Opacity</label>
                                            <div class="row">
                                                <div class="col-sm-8">
                                                    <input type="range" 
                                                           id="glass_opacity" 
                                                           name="glass_opacity" 
                                                           min="0" 
                                                           max="0.2" 
                                                           step="0.01" 
                                                           value="<?php echo $settings['glass_opacity']; ?>" 
                                                           class="form-control">
                                                </div>
                                                <div class="col-sm-4">
                                                    <span id="opacity_value" class="label label-info"><?php echo $settings['glass_opacity']; ?></span>
                                                </div>
                                            </div>
                                            <small class="text-muted">Background opacity for glass elements</small>
                                        </div>

                                        <div class="form-group">
                                            <label for="border_opacity">Border Opacity</label>
                                            <div class="row">
                                                <div class="col-sm-8">
                                                    <input type="range" 
                                                           id="border_opacity" 
                                                           name="border_opacity" 
                                                           min="0" 
                                                           max="0.3" 
                                                           step="0.01" 
                                                           value="<?php echo $settings['border_opacity']; ?>" 
                                                           class="form-control">
                                                </div>
                                                <div class="col-sm-4">
                                                    <span id="border_value" class="label label-info"><?php echo $settings['border_opacity']; ?></span>
                                                </div>
                                            </div>
                                            <small class="text-muted">Border opacity for glass elements</small>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Import/Export Settings -->
                            <div class="col-md-6">
                                <div class="panel panel-warning glass-card">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">Settings Management</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="form-group">
                                            <label>Export Current Settings</label>
                                            <br>
                                            <a href="<?php echo admin_url('darkglass_theme/export_settings'); ?>" 
                                               class="btn btn-info glass-btn">
                                                <i class="fa fa-download"></i> Export Settings
                                            </a>
                                            <p class="text-muted mtop10">Download your current theme configuration</p>
                                        </div>

                                        <hr>

                                        <div class="form-group">
                                            <label>Import Settings</label>
                                            <?php echo form_open_multipart(admin_url('darkglass_theme/import_settings')); ?>
                                                <div class="input-group">
                                                    <input type="file" name="settings_file" accept=".json" class="form-control">
                                                    <span class="input-group-btn">
                                                        <button type="submit" class="btn btn-success">
                                                            <i class="fa fa-upload"></i> Import
                                                        </button>
                                                    </span>
                                                </div>
                                            <?php echo form_close(); ?>
                                            <p class="text-muted mtop10">Upload a previously exported settings file</p>
                                        </div>

                                        <hr>

                                        <div class="form-group">
                                            <label>Reset to Defaults</label>
                                            <br>
                                            <a href="<?php echo admin_url('darkglass_theme/reset_settings'); ?>" 
                                               class="btn btn-danger glass-btn"
                                               onclick="return confirm('Are you sure you want to reset all theme settings to defaults?');">
                                                <i class="fa fa-refresh"></i> Reset Settings
                                            </a>
                                            <p class="text-muted mtop10">Restore original theme settings</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Preview Section -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default glass-card">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">Live Preview</h3>
                                    </div>
                                    <div class="panel-body" style="min-height: 200px;">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="glass-card" style="padding: 20px; text-align: center;">
                                                    <i class="fa fa-chart-bar" style="font-size: 40px; color: var(--dg-primary);"></i>
                                                    <h4>Glass Card</h4>
                                                    <p class="text-muted">Sample glass effect</p>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <button class="btn btn-primary btn-block glass-btn">Primary Button</button>
                                                <button class="btn btn-success btn-block glass-btn mtop10">Success Button</button>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="glass-neon" style="padding: 20px; border-radius: 10px;">
                                                    <h5>Neon Glow Effect</h5>
                                                    <p class="text-muted">Glowing border style</p>
                                                </div>
                                            </div>
                                            <div class="col-md-3">
                                                <div class="frosted-glass" style="padding: 20px; border-radius: 10px;">
                                                    <h5>Frosted Glass</h5>
                                                    <p class="text-muted">Heavy blur effect</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Save Button -->
                        <div class="row">
                            <div class="col-md-12">
                                <hr>
                                <button type="submit" class="btn btn-primary btn-lg glass-btn">
                                    <i class="fa fa-save"></i> Save Theme Settings
                                </button>
                            </div>
                        </div>

                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Initialize color pickers
    $('.colorpicker').colorpicker({
        format: 'hex'
    });

    // Update range slider values
    $('#blur_intensity').on('input', function() {
        $('#blur_value').text($(this).val() + 'px');
    });

    $('#glass_opacity').on('input', function() {
        $('#opacity_value').text($(this).val());
    });

    $('#border_opacity').on('input', function() {
        $('#border_value').text($(this).val());
    });

    // Live preview updates
    $('.colorpicker').on('changeColor', function(e) {
        updatePreview();
    });

    $('input[type="range"]').on('input', function() {
        updatePreview();
    });

    function updatePreview() {
        // Update CSS variables for live preview
        document.documentElement.style.setProperty('--dg-primary', $('#primary_color').val());
        document.documentElement.style.setProperty('--dg-secondary', $('#secondary_color').val());
        document.documentElement.style.setProperty('--dg-accent', $('#accent_color').val());
        document.documentElement.style.setProperty('--dg-blur', $('#blur_intensity').val() + 'px');
        document.documentElement.style.setProperty('--dg-glass-bg', 'rgba(255, 255, 255, ' + $('#glass_opacity').val() + ')');
        document.documentElement.style.setProperty('--dg-glass-border', 'rgba(255, 255, 255, ' + $('#border_opacity').val() + ')');
    }
});
</script>

<?php init_tail(); ?>
