<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<?php init_head(); ?>

<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">Automated Report Schedules</h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <a href="<?php echo admin_url('autograph_feedback_insights'); ?>" 
                                   class="btn btn-default">
                                    <i class="fa fa-arrow-left"></i> Back to Dashboard
                                </a>
                                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#scheduleModal" onclick="resetScheduleForm()">
                                    <i class="fa fa-plus"></i> New Schedule
                                </button>
                            </div>
                        </div>
                        <hr class="hr-panel-heading" />

                        <!-- Schedules Table -->
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Schedule Name</th>
                                        <th>Status Filter</th>
                                        <th>Date Range</th>
                                        <th>Frequency</th>
                                        <th>Next Run</th>
                                        <th>Recipients</th>
                                        <th>Status</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (!empty($schedules)): ?>
                                        <?php foreach ($schedules as $schedule): ?>
                                            <tr>
                                                <td><strong><?php echo html_escape($schedule->schedule_name); ?></strong></td>
                                                <td>
                                                    <?php 
                                                    $status_ids = json_decode($schedule->status_filter, true);
                                                    if (!empty($status_ids)) {
                                                        $status_names = [];
                                                        foreach ($lead_statuses as $status) {
                                                            if (in_array($status['id'], $status_ids)) {
                                                                $status_names[] = $status['name'];
                                                            }
                                                        }
                                                        echo html_escape(implode(', ', $status_names));
                                                    } else {
                                                        echo '<em>All (Autograph mentions)</em>';
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    if ($schedule->date_range_type == 'custom') {
                                                        echo date('M j', strtotime($schedule->custom_start_date)) . ' - ' . date('M j, Y', strtotime($schedule->custom_end_date));
                                                    } else {
                                                        echo ucwords(str_replace('_', ' ', $schedule->date_range_type));
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    echo ucfirst($schedule->schedule_frequency);
                                                    if ($schedule->schedule_frequency == 'weekly') {
                                                        $days = ['', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'];
                                                        echo ' (' . $days[$schedule->schedule_day] . ')';
                                                    } elseif ($schedule->schedule_frequency == 'monthly') {
                                                        echo ' (Day ' . $schedule->schedule_day . ')';
                                                    }
                                                    echo ' at ' . date('g:i A', strtotime($schedule->schedule_time));
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    if ($schedule->next_run) {
                                                        echo date('M j, Y g:i A', strtotime($schedule->next_run));
                                                    } else {
                                                        echo '-';
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php 
                                                    $numbers = json_decode($schedule->whatsapp_numbers, true);
                                                    echo count($numbers) . ' number(s)';
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php if ($schedule->active): ?>
                                                        <span class="label label-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="label label-default">Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-default" 
                                                            onclick="editSchedule(<?php echo $schedule->id; ?>)">
                                                        <i class="fa fa-edit"></i>
                                                    </button>
                                                    <button type="button" 
                                                            class="btn btn-sm btn-danger" 
                                                            onclick="deleteSchedule(<?php echo $schedule->id; ?>)">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="8" class="text-center">No schedules configured yet. Click "New Schedule" to create one.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Schedule Modal -->
<div class="modal fade" id="scheduleModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <?php echo form_open(admin_url('autograph_feedback_insights/schedules'), ['id' => 'schedule-form']); ?>
            <input type="hidden" name="save_schedule" value="1">
            <input type="hidden" name="schedule_id" id="schedule_id">
            
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title" id="scheduleModalLabel">Create Automated Schedule</h4>
            </div>
            
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="schedule_name">Schedule Name *</label>
                            <input type="text" 
                                   name="schedule_name" 
                                   id="schedule_name"
                                   class="form-control"
                                   required
                                   placeholder="e.g., Weekly Dealer Status Report">
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="status_filter_schedule">Filter by Lead Status</label>
                            <select name="status_filter[]" 
                                    id="status_filter_schedule" 
                                    class="form-control selectpicker" 
                                    multiple 
                                    data-actions-box="true">
                                <?php foreach ($lead_statuses as $status): ?>
                                    <option value="<?php echo $status['id']; ?>">
                                        <?php echo html_escape($status['name']); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <small class="help-block">Select lead statuses to analyze (leave empty to analyze all leads with Autograph mentions)</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="date_range_type">Date Range for Lead Notes</label>
                            <select name="date_range_type" id="date_range_type" class="form-control selectpicker">
                                <option value="last_7_days">Last 7 Days</option>
                                <option value="last_30_days">Last 30 Days</option>
                                <option value="last_90_days">Last 90 Days</option>
                                <option value="this_month">This Month</option>
                                <option value="last_month">Last Month</option>
                                <option value="custom">Custom Range</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6" id="custom_date_range" style="display:none;">
                        <div class="form-group">
                            <label>Custom Date Range</label>
                            <div class="row">
                                <div class="col-md-6">
                                    <input type="date" name="custom_start_date" id="custom_start_date" class="form-control" placeholder="Start Date">
                                </div>
                                <div class="col-md-6">
                                    <input type="date" name="custom_end_date" id="custom_end_date" class="form-control" placeholder="End Date">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="schedule_frequency">Frequency *</label>
                            <select name="schedule_frequency" id="schedule_frequency" class="form-control selectpicker" required>
                                <option value="daily">Daily</option>
                                <option value="weekly">Weekly</option>
                                <option value="monthly">Monthly</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4" id="schedule_day_container" style="display:none;">
                        <div class="form-group">
                            <label for="schedule_day" id="schedule_day_label">Day</label>
                            <select name="schedule_day" id="schedule_day" class="form-control selectpicker">
                                <!-- Will be populated by JavaScript -->
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="schedule_time">Time *</label>
                            <input type="time" 
                                   name="schedule_time" 
                                   id="schedule_time"
                                   class="form-control"
                                   required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="whatsapp_numbers_schedule">WhatsApp Numbers (one per line) *</label>
                            <textarea name="whatsapp_numbers" 
                                      id="whatsapp_numbers_schedule"
                                      class="form-control"
                                      rows="4"
                                      required
                                      placeholder="+971501234567&#10;+971509876543&#10;+971501112222"></textarea>
                            <small class="help-block">Enter each phone number on a new line with country code (e.g., +971501234567)</small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>
                                <input type="checkbox" name="active" id="active" value="1" checked> 
                                Enable this schedule
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="submit" class="btn btn-primary">Save Schedule</button>
            </div>
            
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<?php init_tail(); ?>

<script>
$(document).ready(function() {
    // Toggle custom date range
    $('#date_range_type').on('change', function() {
        if ($(this).val() == 'custom') {
            $('#custom_date_range').show();
        } else {
            $('#custom_date_range').hide();
        }
    });

    // Toggle schedule day based on frequency
    $('#schedule_frequency').on('change', function() {
        var frequency = $(this).val();
        var $dayContainer = $('#schedule_day_container');
        var $daySelect = $('#schedule_day');
        var $dayLabel = $('#schedule_day_label');
        
        if (frequency == 'daily') {
            $dayContainer.hide();
        } else if (frequency == 'weekly') {
            $dayContainer.show();
            $dayLabel.text('Day of Week');
            $daySelect.html(`
                <option value="1">Monday</option>
                <option value="2">Tuesday</option>
                <option value="3">Wednesday</option>
                <option value="4">Thursday</option>
                <option value="5">Friday</option>
                <option value="6">Saturday</option>
                <option value="7">Sunday</option>
            `);
            $daySelect.selectpicker('refresh');
        } else if (frequency == 'monthly') {
            $dayContainer.show();
            $dayLabel.text('Day of Month');
            var options = '';
            for (var i = 1; i <= 31; i++) {
                options += '<option value="' + i + '">' + i + '</option>';
            }
            $daySelect.html(options);
            $daySelect.selectpicker('refresh');
        }
    });
});

function resetScheduleForm() {
    $('#schedule-form')[0].reset();
    $('#schedule_id').val('');
    $('#scheduleModalLabel').text('Create Automated Schedule');
    $('#custom_date_range').hide();
    $('#schedule_day_container').hide();
    $('.selectpicker').selectpicker('refresh');
}

function editSchedule(scheduleId) {
    $.ajax({
        url: '<?php echo admin_url('autograph_feedback_insights/get_schedule/'); ?>' + scheduleId,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.success) {
                var schedule = response.schedule;
                
                $('#schedule_id').val(schedule.id);
                $('#schedule_name').val(schedule.schedule_name);
                $('#date_range_type').val(schedule.date_range_type).selectpicker('refresh');
                $('#schedule_frequency').val(schedule.schedule_frequency).selectpicker('refresh');
                $('#schedule_time').val(schedule.schedule_time);
                $('#whatsapp_numbers_schedule').val(schedule.whatsapp_numbers_text);
                $('#active').prop('checked', schedule.active == 1);
                
                // Set status filter
                $('#status_filter_schedule').val(schedule.status_filter).selectpicker('refresh');
                
                // Handle custom date range
                if (schedule.date_range_type == 'custom') {
                    $('#custom_date_range').show();
                    $('#custom_start_date').val(schedule.custom_start_date);
                    $('#custom_end_date').val(schedule.custom_end_date);
                }
                
                // Handle schedule day
                $('#schedule_frequency').trigger('change');
                if (schedule.schedule_day) {
                    setTimeout(function() {
                        $('#schedule_day').val(schedule.schedule_day).selectpicker('refresh');
                    }, 100);
                }
                
                $('#scheduleModalLabel').text('Edit Schedule: ' + schedule.schedule_name);
                $('#scheduleModal').modal('show');
            } else {
                alert_float('danger', response.message);
            }
        }
    });
}

function deleteSchedule(scheduleId) {
    if (confirm('Are you sure you want to delete this schedule?')) {
        var form = $('<form method="post" action="<?php echo admin_url('autograph_feedback_insights/schedules'); ?>"></form>');
        form.append('<input type="hidden" name="delete_schedule" value="1">');
        form.append('<input type="hidden" name="schedule_id" value="' + scheduleId + '">');
        $('body').append(form);
        form.submit();
    }
}
</script>




