<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Autograph Feedback Insights Module - Installation Script
 * This script runs automatically when the module is activated
 * All database tables are created automatically - NO manual SQL needed!
 */

$CI = &get_instance();

// 1. Create feedback report table
if (!$CI->db->table_exists(db_prefix() . 'autograph_feedback_report')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'autograph_feedback_report` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `sentiment` enum("positive","neutral","negative") NOT NULL,
        `sentiment_score` decimal(5,2) DEFAULT NULL,
        `summary` text NOT NULL,
        `positive_highlights` text,
        `negative_concerns` text,
        `market_narrative` text,
        `action_suggestions` text,
        `notes_analyzed` int(11) DEFAULT 0,
        `leads_analyzed` int(11) DEFAULT 0,
        `analysis_date` datetime NOT NULL,
        `created_at` datetime NOT NULL,
        `updated_at` datetime DEFAULT NULL,
        PRIMARY KEY (`id`),
        KEY `analysis_date` (`analysis_date`)
    ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

// 2. Create settings table for OpenAI configuration
if (!$CI->db->table_exists(db_prefix() . 'autograph_feedback_settings')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'autograph_feedback_settings` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `setting_name` varchar(100) NOT NULL,
        `setting_value` text,
        `updated_at` datetime DEFAULT NULL,
        PRIMARY KEY (`id`),
        UNIQUE KEY `setting_name` (`setting_name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
    
    // Insert default settings
    $default_settings = [
        ['setting_name' => 'openai_api_key', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'openai_model', 'setting_value' => 'gpt-4-turbo-preview', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'cron_enabled', 'setting_value' => '0', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'last_analysis_date', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'status_filter', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
        ['setting_name' => 'whatsapp_phone', 'setting_value' => '', 'updated_at' => date('Y-m-d H:i:s')],
    ];
    
    $CI->db->insert_batch(db_prefix() . 'autograph_feedback_settings', $default_settings);
}

// 3. Create automated schedules table
if (!$CI->db->table_exists(db_prefix() . 'autograph_feedback_schedules')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . 'autograph_feedback_schedules` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        `schedule_name` varchar(255) NOT NULL,
        `status_filter` text COMMENT "JSON array of status IDs to filter",
        `date_range_type` enum("last_7_days","last_30_days","last_90_days","this_month","last_month","custom") DEFAULT "last_7_days",
        `custom_start_date` date DEFAULT NULL,
        `custom_end_date` date DEFAULT NULL,
        `schedule_time` time NOT NULL COMMENT "Time to send report (HH:MM:SS)",
        `schedule_frequency` enum("daily","weekly","monthly") DEFAULT "daily",
        `schedule_day` int(2) DEFAULT NULL COMMENT "Day of week (1-7) for weekly, day of month (1-31) for monthly",
        `whatsapp_numbers` text NOT NULL COMMENT "JSON array of phone numbers",
        `active` tinyint(1) DEFAULT 1,
        `last_run` datetime DEFAULT NULL,
        `next_run` datetime DEFAULT NULL,
        `created_at` datetime NOT NULL,
        `updated_at` datetime DEFAULT NULL,
        PRIMARY KEY (`id`),
        KEY `active` (`active`),
        KEY `next_run` (`next_run`)
    ) ENGINE=InnoDB DEFAULT CHARSET=' . $CI->db->char_set . ';');
}

// Installation complete - all tables created automatically!

/**
 * Summary of what was installed:
 * 
 * Tables Created:
 * - tblautograph_feedback_report (stores analysis reports)
 * - tblautograph_feedback_settings (stores module configuration)
 * - tblautograph_feedback_schedules (stores automated schedules)
 * 
 * Default Settings Initialized:
 * - openai_api_key (empty - you need to configure)
 * - openai_model (gpt-4-turbo-preview)
 * - cron_enabled (disabled by default)
 * - status_filter (empty - analyze all by default)
 * - whatsapp_phone (empty - configure if needed)
 * 
 * Menu Items Added:
 * - Autograph Insights (independent sidebar menu)
 *   - Dashboard
 *   - Automated Schedules
 * 
 * Ready to use! Just configure your OpenAI API key in the Dashboard.
 */

