<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Autograph Feedback Insights
Description: Analyzes customer feedback from lead notes about Autograph Serviced Apartments using OpenAI API to generate sentiment and market narrative reports
Version: 1.0.0
Author: Your Company
Requires at least: 3.0.*
*/

define('AUTOGRAPH_FEEDBACK_MODULE_NAME', 'autograph_feedback_insights');
define('AUTOGRAPH_FEEDBACK_MODULE_VERSION', '1.0.0');

/**
 * Register activation module hook
 */
register_activation_hook(AUTOGRAPH_FEEDBACK_MODULE_NAME, 'autograph_feedback_insights_activation_hook');

function autograph_feedback_insights_activation_hook()
{
    $CI = &get_instance();
    require_once(__DIR__ . '/install.php');
}

/**
 * Register language files
 */
register_language_files(AUTOGRAPH_FEEDBACK_MODULE_NAME, ['autograph_feedback_insights']);

/**
 * Load menu links from separate file
 */
require_once __DIR__ . '/includes/sidebar_menu_links.php';

