-- Complete setup SQL for Autograph Feedback Insights Module
-- Run all these queries in phpMyAdmin

-- 1. Create feedback report table
CREATE TABLE IF NOT EXISTS `tblautograph_feedback_report` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `sentiment` enum('positive','neutral','negative') NOT NULL,
    `sentiment_score` decimal(5,2) DEFAULT NULL,
    `summary` text NOT NULL,
    `positive_highlights` text,
    `negative_concerns` text,
    `market_narrative` text,
    `action_suggestions` text,
    `notes_analyzed` int(11) DEFAULT 0,
    `leads_analyzed` int(11) DEFAULT 0,
    `analysis_date` datetime NOT NULL,
    `created_at` datetime NOT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `analysis_date` (`analysis_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 2. Create settings table
CREATE TABLE IF NOT EXISTS `tblautograph_feedback_settings` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `setting_name` varchar(100) NOT NULL,
    `setting_value` text,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `setting_name` (`setting_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- 3. Insert default settings
INSERT INTO `tblautograph_feedback_settings` (`setting_name`, `setting_value`, `updated_at`) VALUES
('openai_api_key', '', NOW()),
('openai_model', 'gpt-4-turbo-preview', NOW()),
('cron_enabled', '0', NOW()),
('last_analysis_date', '', NOW()),
('status_filter', '', NOW()),
('whatsapp_phone', '', NOW())
ON DUPLICATE KEY UPDATE `updated_at` = NOW();

-- 4. Create automated schedules table
CREATE TABLE IF NOT EXISTS `tblautograph_feedback_schedules` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `schedule_name` varchar(255) NOT NULL,
    `status_filter` text COMMENT 'JSON array of status IDs to filter',
    `date_range_type` enum('last_7_days','last_30_days','last_90_days','this_month','last_month','custom') DEFAULT 'last_7_days',
    `custom_start_date` date DEFAULT NULL,
    `custom_end_date` date DEFAULT NULL,
    `schedule_time` time NOT NULL COMMENT 'Time to send report (HH:MM:SS)',
    `schedule_frequency` enum('daily','weekly','monthly') DEFAULT 'daily',
    `schedule_day` int(2) DEFAULT NULL COMMENT 'Day of week (1-7) for weekly, day of month (1-31) for monthly',
    `whatsapp_numbers` text NOT NULL COMMENT 'JSON array of phone numbers',
    `active` tinyint(1) DEFAULT 1,
    `last_run` datetime DEFAULT NULL,
    `next_run` datetime DEFAULT NULL,
    `created_at` datetime NOT NULL,
    `updated_at` datetime DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `active` (`active`),
    KEY `next_run` (`next_run`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




