<?php
define('BASEPATH', __DIR__);
require_once('application/config/app-config.php');

if(!defined('APP_DB_HOSTNAME')){
    die('Database config not loaded properly.');
}

$db_host = APP_DB_HOSTNAME;
$db_user = APP_DB_USERNAME;
$db_pass = APP_DB_PASSWORD;
$db_name = APP_DB_NAME;

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h2>Debug: Dealer Interest Statistics</h2>";

// Get table prefix from config (same logic as CodeIgniter)
$prefix = defined('APP_DB_PREFIX') ? APP_DB_PREFIX : 'tbl';
echo "<p>Database prefix: <strong>" . $prefix . "</strong></p>";
echo "<p>Database name: <strong>" . $db_name . "</strong></p>";

// First, let's see what tables actually exist
echo "<h3>0. Available Tables</h3>";
$sql = "SHOW TABLES LIKE '{$prefix}%'";
echo "<pre>$sql</pre>";
$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    echo "<ul>";
    while ($row = $result->fetch_array()) {
        echo "<li>" . $row[0] . "</li>";
    }
    echo "</ul>";
} else {
    echo "<p style='color:red'>No tables found with prefix '{$prefix}'</p>";
    
    // Try to find tables with any prefix
    echo "<h4>All tables in database:</h4>";
    $sql = "SHOW TABLES";
    $result = $conn->query($sql);
    if ($result && $result->num_rows > 0) {
        echo "<ul>";
        $firstTable = '';
        while ($row = $result->fetch_array()) {
            echo "<li>" . $row[0] . "</li>";
            if (empty($firstTable)) $firstTable = $row[0];
        }
        echo "</ul>";
        
        // Try to detect the actual prefix
        if (!empty($firstTable)) {
            if (preg_match('/^([a-z_]+)leads$/', $firstTable, $matches)) {
                $detectedPrefix = $matches[1];
                echo "<p style='color:orange'><strong>Detected prefix might be: '{$detectedPrefix}'</strong></p>";
                $prefix = $detectedPrefix;
            }
        }
    }
}

echo "<hr>";

// Verify critical tables exist before proceeding
$requiredTables = ['leads', 'leads_status', 'lead_notes'];
$missingTables = [];
foreach ($requiredTables as $table) {
    $fullTableName = $prefix . $table;
    $sql = "SHOW TABLES LIKE '$fullTableName'";
    $result = $conn->query($sql);
    if (!$result || $result->num_rows == 0) {
        $missingTables[] = $fullTableName;
    }
}

if (!empty($missingTables)) {
    echo "<div style='background: #ffebee; padding: 15px; border-left: 4px solid #f44336; margin: 20px 0;'>";
    echo "<h3 style='color: #c62828; margin-top: 0;'>⚠️ Missing Required Tables</h3>";
    echo "<p>The following tables are required but not found:</p>";
    echo "<ul>";
    foreach ($missingTables as $table) {
        echo "<li><code>$table</code></li>";
    }
    echo "</ul>";
    echo "<p><strong>Cannot proceed with dealer statistics queries.</strong></p>";
    echo "<p>Please check your database prefix configuration or ensure the CRM is properly installed.</p>";
    echo "</div>";
    $conn->close();
    exit;
}

echo "<div style='background: #e8f5e9; padding: 15px; border-left: 4px solid #4caf50; margin: 20px 0;'>";
echo "<p style='color: #2e7d32; margin: 0;'>✓ All required tables found. Proceeding with queries...</p>";
echo "</div>";

// 1. Check total dealers
$sql = "SELECT COUNT(*) as total_dealers 
        FROM {$prefix}leads l
        LEFT JOIN {$prefix}leads_status ls ON ls.id = l.status
        WHERE LOWER(ls.name) = 'dealer'";

echo "<h3>1. Total Dealers Query</h3>";
echo "<pre>$sql</pre>";

$result = $conn->query($sql);
if ($result) {
    $row = $result->fetch_assoc();
    echo "<p><strong>Total Dealers:</strong> " . $row['total_dealers'] . "</p>";
} else {
    echo "<p style='color:red'>Error: " . $conn->error . "</p>";
}

// 2. Check interested dealers
$sql = "SELECT COUNT(DISTINCT l.id) as interested_dealers
        FROM {$prefix}leads l
        LEFT JOIN {$prefix}leads_status ls ON ls.id = l.status
        LEFT JOIN {$prefix}lead_notes ln ON ln.leadid = l.id
        WHERE LOWER(ls.name) = 'dealer'
        AND ln.dealer_interest = 'interested'";

echo "<h3>2. Interested Dealers Query</h3>";
echo "<pre>$sql</pre>";

$result = $conn->query($sql);
if ($result) {
    $row = $result->fetch_assoc();
    echo "<p><strong>Interested Dealers:</strong> " . $row['interested_dealers'] . "</p>";
} else {
    echo "<p style='color:red'>Error: " . $conn->error . "</p>";
}

// 3. Check not interested dealers
$sql = "SELECT COUNT(DISTINCT l.id) as not_interested_dealers
        FROM {$prefix}leads l
        LEFT JOIN {$prefix}leads_status ls ON ls.id = l.status
        LEFT JOIN {$prefix}lead_notes ln ON ln.leadid = l.id
        WHERE LOWER(ls.name) = 'dealer'
        AND ln.dealer_interest = 'not_interested'";

echo "<h3>3. Not Interested Dealers Query</h3>";
echo "<pre>$sql</pre>";

$result = $conn->query($sql);
if ($result) {
    $row = $result->fetch_assoc();
    echo "<p><strong>Not Interested Dealers:</strong> " . $row['not_interested_dealers'] . "</p>";
} else {
    echo "<p style='color:red'>Error: " . $conn->error . "</p>";
}

// 4. Check dealer_interest column existence
$sql = "SHOW COLUMNS FROM {$prefix}lead_notes LIKE 'dealer_interest'";
echo "<h3>4. Check dealer_interest Column</h3>";
echo "<pre>$sql</pre>";

$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    echo "<p style='color:green'><strong>Column EXISTS</strong></p>";
    $row = $result->fetch_assoc();
    echo "<pre>" . print_r($row, true) . "</pre>";
} else {
    echo "<p style='color:red'><strong>Column DOES NOT EXIST!</strong></p>";
}

// 5. Sample dealer_interest values
$sql = "SELECT DISTINCT dealer_interest, COUNT(*) as count
        FROM {$prefix}lead_notes
        WHERE dealer_interest IS NOT NULL
        GROUP BY dealer_interest";

echo "<h3>5. Dealer Interest Values Distribution</h3>";
echo "<pre>$sql</pre>";

$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Interest Status</th><th>Count</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr><td>" . htmlspecialchars($row['dealer_interest']) . "</td><td>" . $row['count'] . "</td></tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color:orange'>No dealer_interest data found</p>";
}

// 6. Sample leads with dealer_interest
$sql = "SELECT l.id, l.name, ln.dealer_interest, ln.dateadded
        FROM {$prefix}leads l
        LEFT JOIN {$prefix}leads_status ls ON ls.id = l.status
        LEFT JOIN {$prefix}lead_notes ln ON ln.leadid = l.id
        WHERE LOWER(ls.name) = 'dealer'
        AND ln.dealer_interest IS NOT NULL
        LIMIT 10";

echo "<h3>6. Sample Dealers with Interest Status</h3>";
echo "<pre>$sql</pre>";

$result = $conn->query($sql);
if ($result && $result->num_rows > 0) {
    echo "<table border='1' cellpadding='5'>";
    echo "<tr><th>Lead ID</th><th>Name</th><th>Interest</th><th>Date Added</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . htmlspecialchars($row['name']) . "</td>";
        echo "<td>" . htmlspecialchars($row['dealer_interest']) . "</td>";
        echo "<td>" . $row['dateadded'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p style='color:orange'>No dealer leads with interest status found</p>";
}

$conn->close();
