<?php
define('BASEPATH', __DIR__);
require_once('application/config/app-config.php');

if(!defined('APP_DB_HOSTNAME')){
    die('Database config not loaded properly.');
}

$db_host = APP_DB_HOSTNAME;
$db_user = APP_DB_USERNAME;
$db_pass = APP_DB_PASSWORD;
$db_name = APP_DB_NAME;

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

echo "<h1>Follow-up Data Investigation</h1>";
echo "<style>body{font-family:Arial;margin:20px;} table{border-collapse:collapse;width:100%;margin:20px 0;} th,td{border:1px solid #ddd;padding:8px;text-align:left;} th{background:#4CAF50;color:white;} .alert{padding:15px;margin:10px 0;border-radius:5px;} .success{background:#d4edda;border-left:4px solid #28a745;} .warning{background:#fff3cd;border-left:4px solid #ffc107;} .danger{background:#f8d7da;border-left:4px solid #dc3545;}</style>";

$prefix = defined('APP_DB_PREFIX') ? APP_DB_PREFIX : 'tbl';

// 1. Check recent activity log entries
echo "<h2>1. Recent Lead Activity Log (Last 50 entries)</h2>";
$sql = "SELECT * FROM {$prefix}lead_activity_log 
        ORDER BY date DESC 
        LIMIT 50";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<div class='alert success'>Found " . $result->num_rows . " recent activity entries</div>";
    echo "<table><tr><th>ID</th><th>Lead ID</th><th>Description</th><th>Date</th><th>Staff ID</th><th>Full Name</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['leadid'] . "</td>";
        echo "<td>" . htmlspecialchars($row['description']) . "</td>";
        echo "<td>" . $row['date'] . "</td>";
        echo "<td>" . ($row['staffid'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['full_name'] ?? 'N/A') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert danger'>No recent activity log entries found!</div>";
}

// 2. Check recent lead notes
echo "<h2>2. Recent Lead Notes (Last 50 entries)</h2>";
$sql = "SELECT * FROM {$prefix}lead_notes 
        ORDER BY dateadded DESC 
        LIMIT 50";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<div class='alert success'>Found " . $result->num_rows . " recent notes</div>";
    echo "<table><tr><th>ID</th><th>Lead ID</th><th>Description</th><th>Date Added</th><th>Staff ID</th><th>Followup Type</th><th>Dealer Interest</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>" . $row['leadid'] . "</td>";
        echo "<td>" . htmlspecialchars(substr($row['description'] ?? '', 0, 100)) . "...</td>";
        echo "<td>" . $row['dateadded'] . "</td>";
        echo "<td>" . ($row['addedfrom'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['followup_type'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['dealer_interest'] ?? 'N/A') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert danger'>No recent notes found!</div>";
}

// 3. Check activity count by date
echo "<h2>3. Activity Count by Date (Last 30 days)</h2>";
$sql = "SELECT DATE(date) as activity_date, COUNT(*) as count 
        FROM {$prefix}lead_activity_log 
        WHERE date >= DATE_SUB(NOW(), INTERVAL 30 DAY)
        GROUP BY DATE(date) 
        ORDER BY activity_date DESC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<table><tr><th>Date</th><th>Activity Count</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr><td>" . $row['activity_date'] . "</td><td>" . $row['count'] . "</td></tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert warning'>No activity in last 30 days</div>";
}

// 4. Check notes count by date
echo "<h2>4. Notes Count by Date (Last 30 days)</h2>";
$sql = "SELECT DATE(dateadded) as note_date, COUNT(*) as count 
        FROM {$prefix}lead_notes 
        WHERE dateadded >= DATE_SUB(NOW(), INTERVAL 30 DAY)
        GROUP BY DATE(dateadded) 
        ORDER BY note_date DESC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<table><tr><th>Date</th><th>Notes Count</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr><td>" . $row['note_date'] . "</td><td>" . $row['count'] . "</td></tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert warning'>No notes in last 30 days</div>";
}

// 5. Check for today's activities
echo "<h2>5. Today's Activities</h2>";
$sql = "SELECT COUNT(*) as count FROM {$prefix}lead_activity_log WHERE DATE(date) = CURDATE()";
$result = $conn->query($sql);
$today_count = $result->fetch_assoc()['count'];

if ($today_count > 0) {
    echo "<div class='alert success'>Found {$today_count} activities today</div>";
} else {
    echo "<div class='alert warning'>No activities recorded today</div>";
}

// 6. Check for today's notes
$sql = "SELECT COUNT(*) as count FROM {$prefix}lead_notes WHERE DATE(dateadded) = CURDATE()";
$result = $conn->query($sql);
$today_notes = $result->fetch_assoc()['count'];

if ($today_notes > 0) {
    echo "<div class='alert success'>Found {$today_notes} notes today</div>";
} else {
    echo "<div class='alert warning'>No notes recorded today</div>";
}

// 7. Check total records
echo "<h2>6. Total Records Summary</h2>";
$sql = "SELECT 
    (SELECT COUNT(*) FROM {$prefix}lead_activity_log) as total_activities,
    (SELECT COUNT(*) FROM {$prefix}lead_notes) as total_notes,
    (SELECT COUNT(*) FROM {$prefix}leads) as total_leads";
$result = $conn->query($sql);
$totals = $result->fetch_assoc();

echo "<table>";
echo "<tr><th>Metric</th><th>Count</th></tr>";
echo "<tr><td>Total Activities</td><td>" . $totals['total_activities'] . "</td></tr>";
echo "<tr><td>Total Notes</td><td>" . $totals['total_notes'] . "</td></tr>";
echo "<tr><td>Total Leads</td><td>" . $totals['total_leads'] . "</td></tr>";
echo "</table>";

// 8. Check if there are any activities with specific staff
echo "<h2>7. Activities by Staff (Last 7 days)</h2>";
$sql = "SELECT 
            staffid, 
            full_name,
            COUNT(*) as activity_count,
            MAX(date) as last_activity
        FROM {$prefix}lead_activity_log 
        WHERE date >= DATE_SUB(NOW(), INTERVAL 7 DAY)
        GROUP BY staffid, full_name
        ORDER BY activity_count DESC";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    echo "<table><tr><th>Staff ID</th><th>Name</th><th>Activity Count</th><th>Last Activity</th></tr>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr>";
        echo "<td>" . ($row['staffid'] ?? 'N/A') . "</td>";
        echo "<td>" . htmlspecialchars($row['full_name'] ?? 'Unknown') . "</td>";
        echo "<td>" . $row['activity_count'] . "</td>";
        echo "<td>" . $row['last_activity'] . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<div class='alert warning'>No staff activity in last 7 days</div>";
}

// 9. Check error log if exists
echo "<h2>8. Recent PHP Error Log</h2>";
$error_log_path = __DIR__ . '/error_log';
if (file_exists($error_log_path)) {
    $error_lines = array_slice(file($error_log_path), -50);
    echo "<div class='alert warning'>Last 50 lines of error log:</div>";
    echo "<pre style='background:#f4f4f4;padding:10px;overflow-x:auto;'>";
    echo htmlspecialchars(implode('', $error_lines));
    echo "</pre>";
} else {
    echo "<div class='alert success'>No error_log file found in root directory</div>";
}

// 10. Check MySQL error log access (may not be accessible)
echo "<h2>9. Database Status</h2>";
$sql = "SHOW STATUS LIKE 'Uptime'";
$result = $conn->query($sql);
if ($result) {
    $uptime = $result->fetch_assoc();
    $hours = floor($uptime['Value'] / 3600);
    echo "<div class='alert success'>Database has been running for {$hours} hours</div>";
}

$conn->close();

echo "<hr>";
echo "<p><strong>Investigation Complete:</strong> " . date('Y-m-d H:i:s') . "</p>";
echo "<p><em>If data is missing, check:</em></p>";
echo "<ul>";
echo "<li>Date range filters in the dashboard</li>";
echo "<li>User permissions (some users may only see their own data)</li>";
echo "<li>Recent database backups or migrations</li>";
echo "<li>Server logs for any deletion queries</li>";
echo "</ul>";
?>
