<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">&times;</span>
    </button>
    <link href="<?php echo base_url('assets/css/lead_notes_enhanced.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/lead_attachments.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/ai_lead_analysis.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <link href="<?php echo base_url('assets/css/ai_lead_analysis_v2.css?v=' . time()); ?>" rel="stylesheet" type="text/css" />
    <script src="<?php echo base_url('assets/js/lead_attachment_fix.js?v=' . time()); ?>"></script>
    <script src="<?php echo base_url('assets/js/ai_lead_analysis.js?v=' . time()); ?>"></script>
    <script src="<?php echo base_url('assets/js/ai_lead_analysis_v2.js?v=' . time()); ?>"></script>
    
    <!-- Chart.js for Advanced Analytics -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- CSRF Token for AJAX requests -->
    <script>
        window.csrfToken = '<?= $this->security->get_csrf_hash(); ?>';
        window.csrfName = '<?= $this->security->get_csrf_token_name(); ?>';
    </script>
    <?php
    // Add monitoring script if enabled in session
    if (isset($_SESSION['enable_description_monitor']) && $_SESSION['enable_description_monitor']) {
        echo '<script src="' . base_url('assets/js/description_monitor.js?v=' . time()) . '"></script>';
        echo '<!-- Description monitoring enabled -->';
        // Clear flag after one use
        unset($_SESSION['enable_description_monitor']);
    }
    ?>
    <div class="tw-flex tw-justify-between tw-items-center">
        <h4 class="modal-title tw-flex tw-items-center">
            <?php if (isset($lead)) { ?>
            <?php $name = ! empty($lead->name) ? $lead->name : (! empty($lead->company) ? $lead->company : _l('lead')); ?>
            #<?= $lead->id; ?> -
            <?= e($name); ?>
            <div class="tw-ml-3 -tw-mt-px">
                <?php if ($lead->lost == 1) { ?>
                <span
                    class="label label-danger"><?= _l('lead_lost'); ?></span>
                <?php } elseif ($lead->junk == 1) { ?>
                <span
                    class="label label-warning"><?= _l('lead_junk'); ?></span>
                <?php } elseif (total_rows(db_prefix() . 'clients', ['leadid' => $lead->id])) { ?>
                <span
                    class="label label-success"><?= _l('lead_is_client'); ?></span>
                <?php } ?>
            </div>
            <?php } else { ?>
            <?= _l('add_new', _l('lead_lowercase')); ?>
            <?php } ?>
        </h4>

        <?php if (isset($lead)) { ?>
        <a href="#"
            class="lead-print-btn tw-text-neutral-500 hover:tw-text-neutral-800 focus:tw-text-neutral-800 tw-mt-1 tw-space-x-1.5 tw-mx-4"
            onclick="print_lead_information(); return false;">
            <i class="fa-solid fa-print"></i>
            <span><?= _l('print'); ?></span>
        </a>
        <?php } ?>
    </div>

</div>
<div class="modal-body">
    <div class="row">
        <div class="col-md-12">
            <?php if (isset($lead)) {
                echo form_hidden('leadid', $lead->id);
            } ?>
            <div class="top-lead-menu">
                <?php if (isset($lead)) { ?>
                <div class="horizontal-scrollable-tabs tw-mb-10">
                    <div class="scroller arrow-left"><i class="fa fa-angle-left"></i></div>
                    <div class="scroller arrow-right"><i class="fa fa-angle-right"></i></div>
                    <div class="horizontal-tabs">
                        <ul class="nav nav-tabs nav-tabs-horizontal nav-tabs-segmented<?= ! isset($lead) ? ' lead-new' : ''?>"
                            role="tablist">
                            <li role="presentation" class="active">
                                <a href="#tab_lead_profile" aria-controls="tab_lead_profile" role="tab"
                                    data-toggle="tab">
                                    <i class="fa-regular fa-user menu-icon"></i>
                                    <?= _l('lead_profile'); ?>
                                </a>
                            </li>
                            <?php if (isset($lead)) { ?>
                            <?php if (count($mail_activity) > 0 || isset($show_email_activity) && $show_email_activity) { ?>
                            <li role="presentation">
                                <a href="#tab_email_activity" aria-controls="tab_email_activity" role="tab"
                                    data-toggle="tab">
                                    <i class="fa-regular fa-envelope menu-icon"></i>
                                    <?= hooks()->apply_filters('lead_email_activity_subject', _l('lead_email_activity')); ?>
                                </a>
                            </li>
                            <?php } ?>
                            <li role="presentation">
                                <a href="#tab_proposals_leads"
                                    onclick="initDataTable('.table-proposals-lead', admin_url + 'proposals/proposal_relations/' + <?= e($lead->id); ?> + '/lead','undefined', 'undefined','undefined',[6,'desc']);"
                                    aria-controls="tab_proposals_leads" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-file-lines menu-icon"></i>
                                    <?= _l('proposals');
                                if ($total_proposals > 0) {
                                    echo ' <span class="badge">' . $total_proposals . '</span>';
                                }
                                ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#tab_tasks_leads"
                                    onclick="init_rel_tasks_table(<?= e($lead->id); ?>,'lead','.table-rel-tasks-leads');"
                                    aria-controls="tab_tasks_leads" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-circle-check menu-icon"></i>
                                    <?= _l('tasks');
                                if ($total_tasks > 0) {
                                    echo ' <span class="badge">' . $total_tasks . '</span>';
                                }
                                ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#attachments" aria-controls="attachments" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-paperclip menu-icon"></i>
                                    <?= _l('lead_attachments');
                                if ($total_attachments > 0) {
                                    echo ' <span class="badge">' . $total_attachments . '</span>';
                                }
                                ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#lead_reminders" 
                                    onclick="initDataTable('.table-reminders-leads', admin_url + 'misc/get_reminders/' + <?= e($lead->id); ?> + '/' + 'lead', undefined, undefined, undefined,[1,'asc']); return false;"
                                    aria-controls="lead_reminders" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-bell menu-icon"></i>
                                    <?= _l('reminders');
                                    // You could add a badge here if needed, similar to other tabs
                                    ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#lead_notes" aria-controls="lead_notes" role="tab" data-toggle="tab">
                                    <i class="fa-regular fa-note-sticky menu-icon"></i>
                                    <?= _l('Followups');
                                    if ($total_notes > 0) {
                                        echo ' <span class="badge">' . $total_notes . '</span>';
                                    }
                                    ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#lead_activity" aria-controls="lead_activity" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-grip-lines-vertical menu-icon"></i>
                                    <?= _l('lead_add_edit_activity'); ?>
                                </a>
                            </li>
                            <li role="presentation">
                                <a href="#ai_analysis" aria-controls="ai_analysis" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-brain menu-icon"></i>
                                    AI Analysis
                                </a>
                            </li>
                            <?php if (is_gdpr() && (get_option('gdpr_enable_lead_public_form') == '1' || get_option('gdpr_enable_consent_for_leads') == '1')) { ?>
                            <li role="presentation">
                                <a href="#gdpr" aria-controls="gdpr" role="tab" data-toggle="tab">
                                    <i class="fa-solid fa-gavel menu-icon"></i>
                                    <?= _l('gdpr_short'); ?>
                                </a>
                            </li>
                            <?php } ?>
                            <?php } ?>
                            <?php hooks()->do_action('after_lead_lead_tabs', $lead ?? null); ?>
                        </ul>
                    </div>
                </div>
                <?php } ?>
            </div>
            <!-- Tab panes -->
            <div class="tab-content">
                <!-- from leads modal -->
                <div role="tabpanel" class="tab-pane active" id="tab_lead_profile">
                    <?php $this->load->view('admin/leads/profile'); ?>
                </div>
                <?php if (isset($lead)) { ?>
                <?php if (count($mail_activity) > 0 || isset($show_email_activity) && $show_email_activity) { ?>
                <div role="tabpanel" class="tab-pane" id="tab_email_activity">
                    <?php hooks()->do_action('before_lead_email_activity', ['lead' => $lead, 'email_activity' => $mail_activity]); ?>
                    <?php foreach ($mail_activity as $_mail_activity) { ?>
                    <div class="lead-email-activity">
                        <div class="media-left">
                            <i class="fa-regular fa-envelope"></i>
                        </div>
                        <div class="media-body">
                            <h4 class="bold no-margin lead-mail-activity-subject">
                                <?= e($_mail_activity['subject']); ?>
                                <br />
                                <small
                                    class="text-muted display-block mtop5 font-medium-xs"><?= e(_dt($_mail_activity['dateadded'])); ?></small>
                            </h4>
                            <div class="lead-mail-activity-body">
                                <hr />
                                <?= process_text_content_for_display($_mail_activity['body']); ?>
                            </div>
                            <hr />
                        </div>
                    </div>
                    <div class="clearfix"></div>
                    <?php } ?>
                    <?php hooks()->do_action('after_lead_email_activity', ['lead_id' => $lead->id, 'emails' => $mail_activity]); ?>
                </div>
                <?php } ?>
                <?php if (is_gdpr() && (get_option('gdpr_enable_lead_public_form') == '1' || get_option('gdpr_enable_consent_for_leads') == '1' || (get_option('gdpr_data_portability_leads') == '1') && is_admin())) { ?>
                <div role="tabpanel" class="tab-pane" id="gdpr">
                    <?php if (get_option('gdpr_enable_lead_public_form') == '1') { ?>
                    <a href="<?= e($lead->public_url); ?>"
                        target="_blank" class="mtop5">
                        <?= _l('view_public_form'); ?>
                    </a>
                    <?php } ?>
                    <?php if (get_option('gdpr_data_portability_leads') == '1' && is_admin()) { ?>
                    <?php
                                if (get_option('gdpr_enable_lead_public_form') == '1') {
                                    echo ' | ';
                                }
                        ?>
                    <a
                        href="<?= admin_url('leads/export/' . $lead->id); ?>">
                        <?= _l('dt_button_export'); ?>
                    </a>
                    <?php } ?>
                    <?php if (get_option('gdpr_enable_lead_public_form') == '1' || (get_option('gdpr_data_portability_leads') == '1' && is_admin())) { ?>
                    <hr class="-tw-mx-3.5" />
                    <?php } ?>
                    <?php if (get_option('gdpr_enable_consent_for_leads') == '1') { ?>
                    <h4 class="no-mbot">
                        <?= _l('gdpr_consent'); ?>
                    </h4>
                    <?php $this->load->view('admin/gdpr/lead_consent'); ?>
                    <hr />
                    <?php } ?>
                </div>
                <?php } ?>
                <div role="tabpanel" class="tab-pane" id="lead_activity">
                    <div>
                        <div class="activity-feed">
                            <?php foreach ($activity_log as $log) { ?>
                            <div class="feed-item">
                                <div class="date">
                                    <span class="text-has-action" data-toggle="tooltip"
                                        data-title="<?= e(_dt($log['date'])); ?>">
                                        <?= e(time_ago($log['date'])); ?>
                                    </span>
                                </div>
                                <div class="text">
                                    <?php if ($log['staffid'] != 0) { ?>
                                    <a
                                        href="<?= admin_url('profile/' . $log['staffid']); ?>">
                                        <?= staff_profile_image($log['staffid'], ['staff-profile-xs-image pull-left mright5']);
                                        ?>
                                    </a>
                                    <?php
                                    }
                                $additional_data = '';
                                if (! empty($log['additional_data'])) {
                                    $additional_data = unserialize($log['additional_data']);
                                    echo ($log['staffid'] == 0) ? _l($log['description'], $additional_data) : e($log['full_name']) . ' - ' . _l($log['description'], $additional_data);
                                } else {
                                    echo e($log['full_name']) . ' - ';

                                    if ($log['custom_activity'] == 0) {
                                        echo e(_l($log['description']));
                                    } else {
                                        echo process_text_content_for_display(_l($log['description'], '', false));
                                    }
                                }
                                ?>
                                </div>
                            </div>
                            <?php } ?>
                        </div>
                        <div class="col-md-12">
                            <?= render_textarea('lead_activity_textarea', '', '', ['placeholder' => _l('enter_activity')], [], 'mtop15'); ?>
                            <div class="text-right">
                                <button id="lead_enter_activity"
                                    class="btn btn-primary"><?= _l('submit'); ?></button>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_proposals_leads">
                    <?php if (staff_can('create', 'proposals')) { ?>
                    <a href="<?= admin_url('proposals/proposal?rel_type=lead&rel_id=' . $lead->id); ?>"
                        class="btn btn-primary mbot25"><?= _l('new_proposal'); ?></a>
                    <?php } ?>
                    <?php if (total_rows(db_prefix() . 'proposals', ['rel_type' => 'lead', 'rel_id' => $lead->id]) > 0 && (staff_can('create', 'proposals') || staff_can('edit', 'proposals'))) { ?>
                    <a href="#" class="btn btn-primary mbot25" data-toggle="modal"
                        data-target="#sync_data_proposal_data"><?= _l('sync_data'); ?></a>
                    <?php $this->load->view('admin/proposals/sync_data', ['related' => $lead, 'rel_id' => $lead->id, 'rel_type' => 'lead']); ?>
                    <?php } ?>
                    <?php
                        $table_data = [
                            _l('proposal') . ' #',
                            _l('proposal_subject'),
                            _l('proposal_total'),
                            _l('proposal_date'),
                            _l('proposal_open_till'),
                            _l('tags'),
                            _l('proposal_date_created'),
                            _l('proposal_status'),
                        ];
                    $custom_fields = get_custom_fields('proposal', ['show_on_table' => 1]);

                    foreach ($custom_fields as $field) {
                        array_push($table_data, [
                            'name'     => $field['name'],
                            'th_attrs' => ['data-type' => $field['type'], 'data-custom-field' => 1],
                        ]);
                    }
                    $table_data = hooks()->apply_filters('proposals_relation_table_columns', $table_data);
                    render_datatable($table_data, 'proposals-lead', [], [
                        'data-last-order-identifier' => 'proposals-relation',
                        'data-default-order'         => get_table_last_order('proposals-relation'),
                    ]);
                    ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="tab_tasks_leads">
                    <?php init_relation_tasks_table(['data-new-rel-id' => $lead->id, 'data-new-rel-type' => 'lead'], 'tasksFilters'); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="lead_reminders">
                    <a href="#" data-toggle="modal" class="btn btn-primary"
                        data-target=".reminder-modal-lead-<?= e($lead->id); ?>"><i
                            class="fa-regular fa-bell"></i>
                        <?= _l('lead_set_reminder_title'); ?></a>
                    <hr />
                    <?php render_datatable([_l('reminder_description'), _l('reminder_date'), _l('reminder_staff'), _l('reminder_is_notified')], 'reminders-leads'); ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="attachments">
                    <div class="form-group">
                        <label for="attachment_description"><?= _l('lead_attachment_description'); ?></label>
                        <textarea id="attachment_description" name="attachment_description" class="form-control" rows="3" placeholder="<?= _l('lead_attachment_description_placeholder'); ?>"></textarea>
                    </div>
                    <?= form_open('admin/leads/add_lead_attachment', ['class' => 'dropzone mtop15 mbot15', 'id' => 'lead-attachment-upload']); ?>
                    <?= form_close(); ?>
                    <?php if (get_option('dropbox_app_key') != '') { ?>
                    <hr />
                    <div class=" pull-left">
                        <?php if (count($lead->attachments) > 0) { ?>
                        <a href="<?= admin_url('leads/download_files/' . $lead->id); ?>"
                            class="bold">
                            <?= _l('download_all'); ?>
                            (.zip)
                        </a>
                        <?php } ?>
                    </div>
                    <div class="tw-flex tw-justify-end tw-items-center tw-space-x-2">
                        <button class="gpicker">
                            <i class="fa-brands fa-google" aria-hidden="true"></i>
                            <?= _l('choose_from_google_drive'); ?>
                        </button>
                        <div id="dropbox-chooser-lead"></div>
                    </div>
                    <div class=" clearfix"></div>
                    <?php } ?>
                    <?php if (count($lead->attachments) > 0) { ?>
                    <div class="mtop20" id="lead_attachments">
                        <?php $this->load->view('admin/leads/leads_attachments_template', ['attachments' => $lead->attachments]); ?>
                    </div>
                    <?php } ?>
                </div>
                <div role="tabpanel" class="tab-pane" id="ai_analysis">
                    <!-- AI Analysis Interface - Styles and functionality loaded from external files -->
                    <div class="ai-analysis-container">
                        <div class="alert alert-info">
                            <h4><i class="fa fa-brain"></i> AI Lead Analysis</h4>
                            <p>Advanced artificial intelligence analysis for lead assessment and recommendations.</p>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <!-- Analysis Controls -->
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><i class="fa fa-cogs"></i> Analysis Controls</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <button type="button" class="btn btn-primary btn-block" id="start-ai-analysis" data-lead-id="<?= $lead->id; ?>">
                                                    <i class="fa fa-play"></i> Start Analysis
                                                </button>
                                            </div>
                                            <div class="col-md-6">
                                                <button type="button" class="btn btn-info btn-block" id="quick-analyze">
                                                    <i class="fa fa-bolt"></i> Quick Analyze
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <!-- Analysis Options -->
                                        <div class="mtop15">
                                            <label>Analysis Type:</label>
                                            <div class="radio">
                                                <label><input type="radio" name="analysis_type" value="standard" checked> Standard Analysis</label>
                                            </div>
                                            <div class="radio">
                                                <label><input type="radio" name="analysis_type" value="deep"> Deep Analysis</label>
                                            </div>
                                        </div>
                                        
                                        <!-- Context Input -->
                                        <div class="mtop15">
                                            <label for="analysis-context">Additional Context (Optional):</label>
                                            <textarea class="form-control" id="analysis-context" rows="3" 
                                                      placeholder="Provide specific questions or areas to focus on..."></textarea>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Results Panel -->
                                <div class="panel panel-default" id="results-panel" style="display: none;">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><i class="fa fa-chart-bar"></i> Analysis Results</h3>
                                    </div>
                                    <div class="panel-body" id="analysis-results">
                                        <!-- Results will be loaded here -->
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <!-- Status Panel -->
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><i class="fa fa-info-circle"></i> Status</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div id="ai-status">
                                            <p class="text-muted"><i class="fa fa-check-circle text-success"></i> System Ready</p>
                                            <p class="text-muted" id="config-status">Loading configuration...</p>
                                        </div>
                                        
                                        <!-- Quick Stats -->
                                        <hr>
                                        <h5>Quick Stats</h5>
                                        <div class="row">
                                            <div class="col-xs-6">
                                                <div class="text-center">
                                                    <h4 id="total-analyses">0</h4>
                                                    <small>Total Analyses</small>
                                                </div>
                                            </div>
                                            <div class="col-xs-6">
                                                <div class="text-center">
                                                    <h4 id="avg-score">--</h4>
                                                    <small>Avg Score</small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- History Panel -->
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><i class="fa fa-history"></i> Recent History</h3>
                                    </div>
                                    <div class="panel-body">
                                        <div id="analysis-history">
                                            <p class="text-muted">No previous analyses</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?= form_open_multipart(admin_url('leads/add_note/' . $lead->id), ['id' => 'lead-modal-note-form']); ?>
                            <!-- Primary Metrics Row -->
                            <div class="metrics-primary-row">
                                <!-- Lead Score with Advanced Visualization -->
                                <div class="metric-card metric-lead-score">
                                    <div class="card-header">
                                        <div class="metric-icon lead-score-icon">
                                            <i class="fa fa-star"></i>
                                        </div>
                                        <div class="metric-meta">
                                            <h4>Lead Score</h4>
                                            <span class="metric-trend" id="score-trend">
                                                <i class="fa fa-arrow-up text-success"></i> +12%
                                            </span>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="score-display">
                                            <div class="score-value" id="ai-lead-score">--</div>
                                            <div class="score-max">/100</div>
                                        </div>
                                        <div class="score-visualization">
                                            <div class="circular-progress" data-score="0">
                                                <svg viewBox="0 0 36 36">
                                                    <path class="circle-bg" d="M18 2.0845
                                                      a 15.9155 15.9155 0 0 1 0 31.831
                                                      a 15.9155 15.9155 0 0 1 0 -31.831" />
                                                    <path class="circle" d="M18 2.0845
                                                      a 15.9155 15.9155 0 0 1 0 31.831
                                                      a 15.9155 15.9155 0 0 1 0 -31.831" />
                                                </svg>
                                            </div>
                                        </div>
                                        <div class="score-breakdown">
                                            <div class="breakdown-item">
                                                <span class="item-label">Engagement</span>
                                                <span class="item-value" id="engagement-score">--</span>
                                            </div>
                                            <div class="breakdown-item">
                                                <span class="item-label">Authority</span>
                                                <span class="item-value" id="authority-score">--</span>
                                            </div>
                                            <div class="breakdown-item">
                                                <span class="item-label">Budget</span>
                                                <span class="item-value" id="budget-score">--</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Conversion Probability with Prediction -->
                                <div class="metric-card metric-conversion">
                                    <div class="card-header">
                                        <div class="metric-icon conversion-icon">
                                            <i class="fa fa-chart-line"></i>
                                        </div>
                                        <div class="metric-meta">
                                            <h4>Conversion Probability</h4>
                                            <span class="confidence-level" id="confidence-level">High Confidence</span>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="probability-display">
                                            <div class="probability-value" id="ai-conversion-rate">--</div>
                                            <div class="probability-trend" id="conversion-trend-detail">
                                                <i class="fa fa-trending-up"></i>
                                                <span>Trending up</span>
                                            </div>
                                        </div>
                                        <div class="probability-chart">
                                            <canvas id="conversion-chart" width="200" height="100"></canvas>
                                        </div>
                                        <div class="prediction-timeline">
                                            <div class="timeline-item">
                                                <span class="period">7 days</span>
                                                <span class="probability" id="prob-7d">--</span>
                                            </div>
                                            <div class="timeline-item">
                                                <span class="period">30 days</span>
                                                <span class="probability" id="prob-30d">--</span>
                                            </div>
                                            <div class="timeline-item">
                                                <span class="period">90 days</span>
                                                <span class="probability" id="prob-90d">--</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Risk Assessment with Heat Map -->
                                <div class="metric-card metric-risk">
                                    <div class="card-header">
                                        <div class="metric-icon risk-icon">
                                            <i class="fa fa-shield-alt"></i>
                                        </div>
                                        <div class="metric-meta">
                                            <h4>Risk Assessment</h4>
                                            <span class="risk-level" id="overall-risk-level">Low Risk</span>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="risk-radar">
                                            <canvas id="risk-radar-chart" width="200" height="200"></canvas>
                                        </div>
                                        <div class="risk-factors">
                                            <div class="factor-item" data-risk="budget">
                                                <div class="factor-icon"><i class="fa fa-dollar-sign"></i></div>
                                                <div class="factor-content">
                                                    <span class="factor-name">Budget Constraints</span>
                                                    <div class="factor-level level-low"></div>
                                                </div>
                                            </div>
                                            <div class="factor-item" data-risk="timeline">
                                                <div class="factor-icon"><i class="fa fa-clock"></i></div>
                                                <div class="factor-content">
                                                    <span class="factor-name">Timeline Pressure</span>
                                                    <div class="factor-level level-medium"></div>
                                                </div>
                                            </div>
                                            <div class="factor-item" data-risk="competition">
                                                <div class="factor-icon"><i class="fa fa-users"></i></div>
                                                <div class="factor-content">
                                                    <span class="factor-name">Competition Risk</span>
                                                    <div class="factor-level level-high"></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Secondary Metrics Row -->
                            <div class="metrics-secondary-row">
                                <!-- Engagement Analytics -->
                                <div class="metric-card metric-engagement">
                                    <div class="card-header">
                                        <h4><i class="fa fa-users"></i> Engagement Analytics</h4>
                                        <div class="card-actions">
                                            <button class="btn btn-sm btn-outline-primary" id="refresh-engagement">
                                                <i class="fa fa-sync"></i>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="engagement-overview">
                                            <div class="engagement-score-large" id="ai-engagement">--</div>
                                            <div class="engagement-indicators">
                                                <div class="indicator email-indicator" data-type="email">
                                                    <i class="fa fa-envelope"></i>
                                                    <span class="indicator-value" id="email-engagement">--</span>
                                                    <span class="indicator-label">Email</span>
                                                </div>
                                                <div class="indicator calls-indicator" data-type="calls">
                                                    <i class="fa fa-phone"></i>
                                                    <span class="indicator-value" id="calls-engagement">--</span>
                                                    <span class="indicator-label">Calls</span>
                                                </div>
                                                <div class="indicator meetings-indicator" data-type="meetings">
                                                    <i class="fa fa-calendar"></i>
                                                    <span class="indicator-value" id="meetings-engagement">--</span>
                                                    <span class="indicator-label">Meetings</span>
                                                </div>
                                                <div class="indicator social-indicator" data-type="social">
                                                    <i class="fa fa-share-alt"></i>
                                                    <span class="indicator-value" id="social-engagement">--</span>
                                                    <span class="indicator-label">Social</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="engagement-timeline">
                                            <canvas id="engagement-timeline-chart" width="400" height="120"></canvas>
                                        </div>
                                    </div>
                                </div>

                                <!-- Market Intelligence -->
                                <div class="metric-card metric-market">
                                    <div class="card-header">
                                        <h4><i class="fa fa-globe"></i> Market Intelligence</h4>
                                        <div class="card-actions">
                                            <span class="last-updated" id="market-updated">Updated 2h ago</span>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <div class="market-overview">
                                            <div class="market-position">
                                                <h5>Market Position</h5>
                                                <div class="position-indicator" id="market-position">
                                                    <div class="position-value">Leader</div>
                                                    <div class="position-trend">
                                                        <i class="fa fa-arrow-up text-success"></i>
                                                        <span>Growing</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="competitive-analysis">
                                                <h5>Competitive Landscape</h5>
                                                <div class="competitor-item">
                                                    <span class="competitor-name">Primary Competitor</span>
                                                    <div class="threat-level threat-medium">Medium</div>
                                                </div>
                                                <div class="competitor-item">
                                                    <span class="competitor-name">Secondary Threats</span>
                                                    <div class="threat-level threat-low">Low</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Advanced Analysis Interface -->
                        <div class="ai-analysis-interface">
                            <div class="interface-container">
                                <!-- Left Panel: Analysis Tools & Configuration -->
                                <div class="analysis-left-panel">
                                    <!-- Analysis Mode Selector -->
                                    <div class="analysis-mode-section">
                                        <h3 class="section-title">
                                            <i class="fa fa-microscope"></i> Analysis Modes
                                        </h3>
                                        <div class="mode-selector-grid">
                                            <div class="mode-card active" data-mode="comprehensive">
                                                <div class="mode-header">
                                                    <div class="mode-icon comprehensive-icon">
                                                        <i class="fa fa-chart-pie"></i>
                                                    </div>
                                                    <div class="mode-badge">Recommended</div>
                                                </div>
                                                <div class="mode-content">
                                                    <h4>360° Analysis</h4>
                                                    <p>Complete lead evaluation with scoring, risk assessment, and strategic recommendations</p>
                                                    <div class="mode-features">
                                                        <span class="feature-tag">Lead Scoring</span>
                                                        <span class="feature-tag">Risk Analysis</span>
                                                        <span class="feature-tag">Recommendations</span>
                                                    </div>
                                                </div>
                                                <div class="mode-footer">
                                                    <span class="duration">~5-7 minutes</span>
                                                    <span class="accuracy">98% accurate</span>
                                                </div>
                                            </div>

                                            <div class="mode-card" data-mode="document">
                                                <div class="mode-header">
                                                    <div class="mode-icon document-icon">
                                                        <i class="fa fa-file-alt"></i>
                                                    </div>
                                                </div>
                                                <div class="mode-content">
                                                    <h4>Document Intelligence</h4>
                                                    <p>Analyze contracts, proposals, emails, and communication documents</p>
                                                    <div class="mode-features">
                                                        <span class="feature-tag">NLP Analysis</span>
                                                        <span class="feature-tag">Sentiment</span>
                                                        <span class="feature-tag">Key Terms</span>
                                                    </div>
                                                </div>
                                                <div class="mode-footer">
                                                    <span class="duration">~2-4 minutes</span>
                                                    <span class="accuracy">95% accurate</span>
                                                </div>
                                            </div>

                                            <div class="mode-card" data-mode="conversation">
                                                <div class="mode-header">
                                                    <div class="mode-icon conversation-icon">
                                                        <i class="fa fa-comments"></i>
                                                    </div>
                                                </div>
                                                <div class="mode-content">
                                                    <h4>Conversation Analytics</h4>
                                                    <p>Deep analysis of call transcripts, meeting notes, and email exchanges</p>
                                                    <div class="mode-features">
                                                        <span class="feature-tag">Sentiment Analysis</span>
                                                        <span class="feature-tag">Intent Detection</span>
                                                        <span class="feature-tag">Follow-ups</span>
                                                    </div>
                                                </div>
                                                <div class="mode-footer">
                                                    <span class="duration">~3-5 minutes</span>
                                                    <span class="accuracy">92% accurate</span>
                                                </div>
                                            </div>

                                            <div class="mode-card" data-mode="competitive">
                                                <div class="mode-header">
                                                    <div class="mode-icon competitive-icon">
                                                        <i class="fa fa-sword"></i>
                                                    </div>
                                                </div>
                                                <div class="mode-content">
                                                    <h4>Market Intelligence</h4>
                                                    <p>Competitive analysis, market research, and positioning insights</p>
                                                    <div class="mode-features">
                                                        <span class="feature-tag">Competitor Analysis</span>
                                                        <span class="feature-tag">Market Trends</span>
                                                        <span class="feature-tag">Positioning</span>
                                                    </div>
                                                </div>
                                                <div class="mode-footer">
                                                    <span class="duration">~8-12 minutes</span>
                                                    <span class="accuracy">90% accurate</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Smart Upload Zone -->
                                    <div class="smart-upload-section">
                                        <h3 class="section-title">
                                            <i class="fa fa-cloud-upload-alt"></i> Smart Document Upload
                                        </h3>
                                        <div class="upload-zone-enhanced" id="ai-upload-zone-v2">
                                            <div class="upload-area">
                                                <div class="upload-visual">
                                                    <div class="upload-animation">
                                                        <i class="fa fa-cloud-upload-alt"></i>
                                                    </div>
                                                </div>
                                                <div class="upload-content">
                                                    <h4>Drag & Drop Files or Click to Upload</h4>
                                                    <p>AI supports PDF, DOC/DOCX, images, audio files, and more</p>
                                                    <div class="supported-formats">
                                                        <span class="format-badge">PDF</span>
                                                        <span class="format-badge">DOC</span>
                                                        <span class="format-badge">MP3</span>
                                                        <span class="format-badge">IMG</span>
                                                        <span class="format-badge">+10 more</span>
                                                    </div>
                                                </div>
                                                <button type="button" class="btn btn-upload-primary">
                                                    <i class="fa fa-plus"></i> Select Files
                                                </button>
                                            </div>
                                            <div class="upload-progress-area" style="display: none;">
                                                <div class="progress-header">
                                                    <span class="progress-title">Processing Files...</span>
                                                    <span class="progress-percentage">0%</span>
                                                </div>
                                                <div class="progress progress-enhanced">
                                                    <div class="progress-bar progress-bar-striped progress-bar-animated"></div>
                                                </div>
                                                <div class="file-list" id="uploaded-files-list"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Advanced Parameters -->
                                    <div class="advanced-parameters-section">
                                        <h3 class="section-title">
                                            <i class="fa fa-sliders-h"></i> Analysis Configuration
                                        </h3>
                                        <div class="parameters-grid">
                                            <div class="parameter-group">
                                                <label class="parameter-label">
                                                    <i class="fa fa-bullseye"></i> Focus Areas
                                                </label>
                                                <div class="focus-areas-selector">
                                                    <div class="focus-item" data-focus="budget">
                                                        <input type="checkbox" id="focus-budget" checked>
                                                        <label for="focus-budget">
                                                            <i class="fa fa-dollar-sign"></i>
                                                            <span>Budget Analysis</span>
                                                        </label>
                                                    </div>
                                                    <div class="focus-item" data-focus="authority">
                                                        <input type="checkbox" id="focus-authority" checked>
                                                        <label for="focus-authority">
                                                            <i class="fa fa-crown"></i>
                                                            <span>Decision Authority</span>
                                                        </label>
                                                    </div>
                                                    <div class="focus-item" data-focus="need">
                                                        <input type="checkbox" id="focus-need" checked>
                                                        <label for="focus-need">
                                                            <i class="fa fa-search"></i>
                                                            <span>Need Assessment</span>
                                                        </label>
                                                    </div>
                                                    <div class="focus-item" data-focus="timeline">
                                                        <input type="checkbox" id="focus-timeline">
                                                        <label for="focus-timeline">
                                                            <i class="fa fa-clock"></i>
                                                            <span>Timeline Evaluation</span>
                                                        </label>
                                                    </div>
                                                    <div class="focus-item" data-focus="competition">
                                                        <input type="checkbox" id="focus-competition">
                                                        <label for="focus-competition">
                                                            <i class="fa fa-users"></i>
                                                            <span>Competitive Position</span>
                                                        </label>
                                                    </div>
                                                    <div class="focus-item" data-focus="technical">
                                                        <input type="checkbox" id="focus-technical">
                                                        <label for="focus-technical">
                                                            <i class="fa fa-cogs"></i>
                                                            <span>Technical Requirements</span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="parameter-group">
                                                <label class="parameter-label">
                                                    <i class="fa fa-layer-group"></i> Analysis Depth
                                                </label>
                                                <div class="depth-selector">
                                                    <div class="depth-option" data-depth="quick">
                                                        <input type="radio" name="analysis-depth" id="depth-quick" value="quick">
                                                        <label for="depth-quick">
                                                            <div class="depth-icon"><i class="fa fa-bolt"></i></div>
                                                            <div class="depth-content">
                                                                <span class="depth-name">Quick Scan</span>
                                                                <span class="depth-time">2-3 minutes</span>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    <div class="depth-option active" data-depth="standard">
                                                        <input type="radio" name="analysis-depth" id="depth-standard" value="standard" checked>
                                                        <label for="depth-standard">
                                                            <div class="depth-icon"><i class="fa fa-balance-scale"></i></div>
                                                            <div class="depth-content">
                                                                <span class="depth-name">Standard</span>
                                                                <span class="depth-time">5-7 minutes</span>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    <div class="depth-option" data-depth="deep">
                                                        <input type="radio" name="analysis-depth" id="depth-deep" value="deep">
                                                        <label for="depth-deep">
                                                            <div class="depth-icon"><i class="fa fa-search"></i></div>
                                                            <div class="depth-content">
                                                                <span class="depth-name">Deep Analysis</span>
                                                                <span class="depth-time">10-15 minutes</span>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    <div class="depth-option" data-depth="comprehensive">
                                                        <input type="radio" name="analysis-depth" id="depth-comprehensive" value="comprehensive">
                                                        <label for="depth-comprehensive">
                                                            <div class="depth-icon"><i class="fa fa-infinity"></i></div>
                                                            <div class="depth-content">
                                                                <span class="depth-name">Comprehensive</span>
                                                                <span class="depth-time">20+ minutes</span>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="parameter-group">
                                                <label class="parameter-label">
                                                    <i class="fa fa-comment-alt"></i> Additional Context
                                                </label>
                                                <div class="context-input-area">
                                                    <textarea class="form-control context-textarea" id="ai-context-v2" 
                                                              placeholder="Provide specific questions, areas of concern, or context for the AI to focus on..."></textarea>
                                                    <div class="context-suggestions">
                                                        <span class="suggestion-tag" data-suggestion="What is the likelihood of closing this deal?">Closing Likelihood</span>
                                                        <span class="suggestion-tag" data-suggestion="Identify any red flags or risks">Risk Factors</span>
                                                        <span class="suggestion-tag" data-suggestion="What next steps should we take?">Next Steps</span>
                                                        <span class="suggestion-tag" data-suggestion="Analyze competitor threats">Competition</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Action Center -->
                                    <div class="action-center">
                                        <div class="primary-actions">
                                            <button type="button" class="btn btn-ai-primary btn-xl" id="start-ai-analysis-v2">
                                                <div class="btn-content">
                                                    <i class="fa fa-play"></i>
                                                    <span>Start AI Analysis</span>
                                                </div>
                                                <div class="btn-loader" style="display: none;">
                                                    <i class="fa fa-spinner fa-spin"></i>
                                                </div>
                                            </button>
                                        </div>
                                        <div class="secondary-actions">
                                            <button type="button" class="btn btn-ai-secondary" id="schedule-analysis-v2">
                                                <i class="fa fa-clock"></i> Schedule Analysis
                                            </button>
                                            <button type="button" class="btn btn-ai-secondary" id="save-template-v2">
                                                <i class="fa fa-save"></i> Save Template
                                            </button>
                                            <button type="button" class="btn btn-ai-secondary" id="load-template-v2">
                                                <i class="fa fa-folder-open"></i> Load Template
                                            </button>
                                        </div>
                                    </div>
                                </div>

                                <!-- Right Panel: Results & Intelligence -->
                                <div class="analysis-right-panel">
                                    <!-- Real-time Results -->
                                    <div class="results-section">
                                        <div class="results-header">
                                            <h3 class="section-title">
                                                <i class="fa fa-chart-bar"></i> Live Results
                                            </h3>
                                            <div class="results-actions">
                                                <button class="btn btn-sm btn-outline-primary" id="refresh-results">
                                                    <i class="fa fa-sync"></i>
                                                </button>
                                                <button class="btn btn-sm btn-outline-primary" id="export-results">
                                                    <i class="fa fa-download"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <div class="results-content" id="ai-latest-results-v2">
                                            <div class="no-results-state">
                                                <div class="no-results-icon">
                                                    <i class="fa fa-chart-bar"></i>
                                                </div>
                                                <h4>Ready to Analyze</h4>
                                                <p>Start an AI analysis to see detailed insights and recommendations here</p>
                                                <button class="btn btn-sm btn-primary" id="start-quick-analysis">
                                                    <i class="fa fa-play"></i> Quick Start
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- AI Insights & Recommendations -->
                                    <div class="insights-section">
                                        <div class="insights-header">
                                            <h3 class="section-title">
                                                <i class="fa fa-lightbulb"></i> AI Insights
                                            </h3>
                                            <div class="insights-confidence">
                                                <span class="confidence-badge high">High Confidence</span>
                                            </div>
                                        </div>
                                        <div class="insights-content" id="ai-recommendations-v2">
                                            <div class="insight-placeholder">
                                                <div class="placeholder-animation">
                                                    <div class="pulse-icon">
                                                        <i class="fa fa-brain"></i>
                                                    </div>
                                                </div>
                                                <p>AI insights and strategic recommendations will appear here after analysis</p>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Smart Actions -->
                                    <div class="smart-actions-section">
                                        <div class="actions-header">
                                            <h3 class="section-title">
                                                <i class="fa fa-magic"></i> Smart Actions
                                            </h3>
                                        </div>
                                        <div class="actions-content">
                                            <div class="action-card" data-action="follow-up">
                                                <div class="action-icon">
                                                    <i class="fa fa-envelope"></i>
                                                </div>
                                                <div class="action-content">
                                                    <h5>Auto Follow-up</h5>
                                                    <p>Generate personalized follow-up email</p>
                                                </div>
                                                <div class="action-trigger">
                                                    <button class="btn btn-sm btn-outline-primary">Generate</button>
                                                </div>
                                            </div>
                                            <div class="action-card" data-action="proposal">
                                                <div class="action-icon">
                                                    <i class="fa fa-file-contract"></i>
                                                </div>
                                                <div class="action-content">
                                                    <h5>Smart Proposal</h5>
                                                    <p>Create targeted proposal template</p>
                                                </div>
                                                <div class="action-trigger">
                                                    <button class="btn btn-sm btn-outline-primary">Create</button>
                                                </div>
                                            </div>
                                            <div class="action-card" data-action="research">
                                                <div class="action-icon">
                                                    <i class="fa fa-search"></i>
                                                </div>
                                                <div class="action-content">
                                                    <h5>Deep Research</h5>
                                                    <p>Extended market & competitor analysis</p>
                                                </div>
                                                <div class="action-trigger">
                                                    <button class="btn btn-sm btn-outline-primary">Research</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Analysis History -->
                                    <div class="history-section">
                                        <div class="history-header">
                                            <h3 class="section-title">
                                                <i class="fa fa-history"></i> Analysis Timeline
                                            </h3>
                                            <div class="history-filter">
                                                <div class="filter-dropdown">
                                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" data-toggle="dropdown">
                                                        All Time <i class="fa fa-caret-down"></i>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a href="#" data-filter="all">All Time</a></li>
                                                        <li><a href="#" data-filter="today">Today</a></li>
                                                        <li><a href="#" data-filter="week">This Week</a></li>
                                                        <li><a href="#" data-filter="month">This Month</a></li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="history-content" id="ai-history-list-v2">
                                            <div class="history-placeholder">
                                                <div class="placeholder-icon">
                                                    <i class="fa fa-clock"></i>
                                                </div>
                                                <p>No analysis history available</p>
                                                <small class="text-muted">Previous analyses will appear here</small>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Quick Stats Widget -->
                                    <div class="quick-stats-section">
                                        <div class="stats-header">
                                            <h3 class="section-title">
                                                <i class="fa fa-tachometer-alt"></i> Quick Stats
                                            </h3>
                                        </div>
                                        <div class="stats-grid">
                                            <div class="stat-item">
                                                <div class="stat-icon">
                                                    <i class="fa fa-chart-line"></i>
                                                </div>
                                                <div class="stat-content">
                                                    <span class="stat-value" id="monthly-analyses">0</span>
                                                    <span class="stat-label">This Month</span>
                                                </div>
                                            </div>
                                            <div class="stat-item">
                                                <div class="stat-icon">
                                                    <i class="fa fa-clock"></i>
                                                </div>
                                                <div class="stat-content">
                                                    <span class="stat-value" id="avg-analysis-time">--</span>
                                                    <span class="stat-label">Avg Time</span>
                                                </div>
                                            </div>
                                            <div class="stat-item">
                                                <div class="stat-icon">
                                                    <i class="fa fa-star"></i>
                                                </div>
                                                <div class="stat-content">
                                                    <span class="stat-value" id="accuracy-score">--</span>
                                                    <span class="stat-label">Accuracy</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Analysis Progress Modal -->
                        <!-- Enhanced AI Analysis Modals -->
                        
                        <!-- Advanced Progress Modal -->
                        <div class="modal fade" id="ai-progress-modal-v2" tabindex="-1" data-backdrop="static" data-keyboard="false">
                            <div class="modal-dialog modal-xl">
                                <div class="modal-content ai-progress-content">
                                    <div class="modal-header ai-progress-header">
                                        <div class="progress-header-content">
                                            <div class="progress-icon">
                                                <div class="icon-pulse">
                                                    <i class="fa fa-brain"></i>
                                                </div>
                                            </div>
                                            <div class="progress-title-section">
                                                <h3 class="modal-title">AI Analysis in Progress</h3>
                                                <p class="progress-subtitle">Advanced machine learning analysis of lead data</p>
                                            </div>
                                        </div>
                                        <div class="progress-stats">
                                            <div class="stat-item">
                                                <span class="stat-label">Elapsed Time</span>
                                                <span class="stat-value" id="elapsed-time">00:00</span>
                                            </div>
                                            <div class="stat-item">
                                                <span class="stat-label">Est. Remaining</span>
                                                <span class="stat-value" id="remaining-time">--:--</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-body ai-progress-body">
                                        <div class="progress-visualization">
                                            <!-- Overall Progress -->
                                            <div class="overall-progress-section">
                                                <div class="progress-header">
                                                    <h4>Analysis Progress</h4>
                                                    <span class="progress-percentage" id="progress-percentage-display">0%</span>
                                                </div>
                                                <div class="progress progress-enhanced">
                                                    <div class="progress-bar progress-bar-animated" id="overall-progress-bar-v2"></div>
                                                </div>
                                            </div>
                                            
                                            <!-- Stage Progress -->
                                            <div class="stages-container">
                                                <div class="progress-stage active" id="stage-1-v2" data-stage="1">
                                                    <div class="stage-indicator">
                                                        <div class="stage-number">1</div>
                                                        <div class="stage-icon">
                                                            <i class="fa fa-upload"></i>
                                                        </div>
                                                    </div>
                                                    <div class="stage-content">
                                                        <h5>Document Processing</h5>
                                                        <p>Extracting and analyzing uploaded content</p>
                                                        <div class="stage-details">
                                                            <span class="detail-item" id="files-processed">0 files processed</span>
                                                            <span class="detail-item" id="content-extracted">0 KB extracted</span>
                                                        </div>
                                                    </div>
                                                    <div class="stage-status">
                                                        <i class="fa fa-spinner fa-spin"></i>
                                                    </div>
                                                </div>
                                                
                                                <div class="progress-stage" id="stage-2-v2" data-stage="2">
                                                    <div class="stage-indicator">
                                                        <div class="stage-number">2</div>
                                                        <div class="stage-icon">
                                                            <i class="fa fa-search"></i>
                                                        </div>
                                                    </div>
                                                    <div class="stage-content">
                                                        <h5>Data Analysis</h5>
                                                        <p>Analyzing lead patterns and behavioral data</p>
                                                        <div class="stage-details">
                                                            <span class="detail-item" id="patterns-found">0 patterns identified</span>
                                                            <span class="detail-item" id="data-points">0 data points analyzed</span>
                                                        </div>
                                                    </div>
                                                    <div class="stage-status">
                                                        <i class="fa fa-clock"></i>
                                                    </div>
                                                </div>
                                                
                                                <div class="progress-stage" id="stage-3-v2" data-stage="3">
                                                    <div class="stage-indicator">
                                                        <div class="stage-number">3</div>
                                                        <div class="stage-icon">
                                                            <i class="fa fa-chart-line"></i>
                                                        </div>
                                                    </div>
                                                    <div class="stage-content">
                                                        <h5>Insight Generation</h5>
                                                        <p>Creating recommendations and scoring models</p>
                                                        <div class="stage-details">
                                                            <span class="detail-item" id="insights-generated">0 insights created</span>
                                                            <span class="detail-item" id="recommendations">0 recommendations</span>
                                                        </div>
                                                    </div>
                                                    <div class="stage-status">
                                                        <i class="fa fa-clock"></i>
                                                    </div>
                                                </div>
                                                
                                                <div class="progress-stage" id="stage-4-v2" data-stage="4">
                                                    <div class="stage-indicator">
                                                        <div class="stage-number">4</div>
                                                        <div class="stage-icon">
                                                            <i class="fa fa-check"></i>
                                                        </div>
                                                    </div>
                                                    <div class="stage-content">
                                                        <h5>Report Finalization</h5>
                                                        <p>Preparing comprehensive analysis report</p>
                                                        <div class="stage-details">
                                                            <span class="detail-item" id="report-sections">0 sections complete</span>
                                                            <span class="detail-item" id="quality-score">Quality: --</span>
                                                        </div>
                                                    </div>
                                                    <div class="stage-status">
                                                        <i class="fa fa-clock"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- Real-time Activity Feed -->
                                            <div class="activity-feed-section">
                                                <h5><i class="fa fa-stream"></i> Real-time Activity</h5>
                                                <div class="activity-feed" id="progress-activity-feed">
                                                    <div class="activity-item">
                                                        <span class="activity-time">00:00</span>
                                                        <span class="activity-message">Analysis initialized</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer ai-progress-footer">
                                        <div class="footer-left">
                                            <div class="ai-branding">
                                                <i class="fa fa-brain"></i>
                                                <span>Powered by Advanced AI</span>
                                            </div>
                                        </div>
                                        <div class="footer-right">
                                            <button type="button" class="btn btn-secondary" id="minimize-progress">
                                                <i class="fa fa-minus"></i> Minimize
                                            </button>
                                            <button type="button" class="btn btn-warning" id="cancel-analysis-v2">
                                                <i class="fa fa-stop"></i> Cancel Analysis
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Advanced Settings Modal -->
                        <div class="modal fade" id="ai-advanced-settings" tabindex="-1">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title">
                                            <i class="fa fa-cog"></i> Advanced AI Settings
                                        </h4>
                                        <button type="button" class="close" data-dismiss="modal">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="settings-tabs">
                                            <ul class="nav nav-tabs">
                                                <li class="active"><a href="#settings-analysis" data-toggle="tab">Analysis</a></li>
                                                <li><a href="#settings-api" data-toggle="tab">API Config</a></li>
                                                <li><a href="#settings-notifications" data-toggle="tab">Notifications</a></li>
                                                <li><a href="#settings-export" data-toggle="tab">Export</a></li>
                                            </ul>
                                            <div class="tab-content">
                                                <div class="tab-pane active" id="settings-analysis">
                                                    <h5>Analysis Preferences</h5>
                                                    <div class="form-group">
                                                        <label>Default Analysis Mode</label>
                                                        <select class="form-control" id="default-analysis-mode">
                                                            <option value="comprehensive">360° Analysis</option>
                                                            <option value="document">Document Intelligence</option>
                                                            <option value="conversation">Conversation Analytics</option>
                                                            <option value="competitive">Market Intelligence</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Auto-Analysis Triggers</label>
                                                        <div class="checkbox">
                                                            <input type="checkbox" id="auto-new-lead" checked>
                                                            <label for="auto-new-lead">New lead created</label>
                                                        </div>
                                                        <div class="checkbox">
                                                            <input type="checkbox" id="auto-document-upload">
                                                            <label for="auto-document-upload">Document uploaded</label>
                                                        </div>
                                                        <div class="checkbox">
                                                            <input type="checkbox" id="auto-status-change">
                                                            <label for="auto-status-change">Status changed</label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Additional tabs content would go here -->
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                        <button type="button" class="btn btn-primary" id="save-ai-settings">Save Settings</button>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Results Modal -->
                        <div class="modal fade" id="ai-results-modal" tabindex="-1">
                            <div class="modal-dialog modal-xl">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title">
                                            <i class="fa fa-chart-bar"></i> AI Analysis Results
                                        </h4>
                                        <button type="button" class="close" data-dismiss="modal">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div id="analysis-results-content">
                                            <!-- Results will be populated here -->
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                        <button type="button" class="btn btn-primary" id="export-full-report">
                                            <i class="fa fa-download"></i> Export Report
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div role="tabpanel" class="tab-pane" id="lead_notes">
                    <?= form_open_multipart(admin_url('leads/add_note/' . $lead->id), ['id' => 'lead-modal-note-form']); ?>
                    <div class="form-group">
                        <label for="followup_type"><?= _l('followup_type'); ?></label>
                        <select id="followup_type" name="followup_type" class="form-control">
                            <?php foreach($followup_types as $type): ?>
                                <option value="<?= htmlspecialchars($type); ?>"><?= htmlspecialchars($type); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <textarea id="description" name="description" class="form-control" rows="4"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="file" class="control-label"><?php echo _l('lead_note_add_attachment'); ?></label>
                        <input type="file" id="file" name="file" class="form-control">
                    </div>
                    
                    <div class="lead-select-date-contacted hide">
                        <?= render_datetime_input('custom_contact_date', 'lead_add_edit_datecontacted', '', ['data-date-end-date' => date('Y-m-d')]); ?>
                    </div>
                    <div class="radio radio-primary">
                        <input type="radio" name="contacted_indicator" id="contacted_indicator_yes" value="yes">
                        <label for="contacted_indicator_yes"><?= _l('lead_add_edit_contacted_this_lead'); ?></label>
                    </div>
                    <div class="radio radio-primary">
                        <input type="radio" name="contacted_indicator" id="contacted_indicator_no" value="no" checked>
                        <label for="contacted_indicator_no"><?= _l('lead_not_contacted'); ?></label>
                    </div>
                    <button type="submit" class="btn btn-primary pull-right"><?= _l('Add followup'); ?></button>
                    <?= form_close(); ?>
                    
                    <div class="clearfix"></div>
                    <hr />
                    
                    <?php
                    $len = count($notes);
                    $i   = 0;
                    foreach ($notes as $note) { ?>
                    <?php
                        // Detect communication type from note content
                        $note_text = strtolower($note['description']);
                        $communication_type = 'general';
                        $icon = 'fa-regular fa-note-sticky';
                        $color_class = 'note-general';
                        
                        if (strpos($note_text, 'whatsapp') !== false || strpos($note_text, 'whats app') !== false) {
                            $communication_type = 'whatsapp';
                            $icon = 'fa-brands fa-whatsapp';
                            $color_class = 'note-whatsapp';
                        } elseif (strpos($note_text, 'call') !== false || strpos($note_text, 'phone') !== false || strpos($note_text, 'rang') !== false) {
                            $communication_type = 'call';
                            $icon = 'fa-solid fa-phone';
                            $color_class = 'note-call';
                        } elseif (strpos($note_text, 'message') !== false || strpos($note_text, 'sms') !== false || strpos($note_text, 'text') !== false) {
                            $communication_type = 'message';
                            $icon = 'fa-solid fa-comment';
                            $color_class = 'note-message';
                        } elseif (strpos($note_text, 'email') !== false || strpos($note_text, 'mail') !== false) {
                            $communication_type = 'email';
                            $icon = 'fa-regular fa-envelope';
                            $color_class = 'note-email';
                        } elseif (strpos($note_text, 'meeting') !== false || strpos($note_text, 'visit') !== false) {
                            $communication_type = 'meeting';
                            $icon = 'fa-solid fa-users';
                            $color_class = 'note-meeting';
                        }
                    ?>
                    <div class="media lead-note <?php echo $color_class; ?>">
                        <a href="<?= admin_url('profile/' . $note['addedfrom']); ?>" target="_blank">
                            <?= staff_profile_image($note['addedfrom'], ['staff-profile-image-small', 'pull-left mright10']); ?>
                        </a>
                        <!-- Add communication type icon -->
                        <span class="comm-icon" style="margin-right: 8px; font-size: 16px; color: <?php 
                            if ($color_class == 'note-whatsapp') echo '#25D366';
                            elseif ($color_class == 'note-call') echo '#007bff';
                            elseif ($color_class == 'note-message') echo '#6f42c1';
                            elseif ($color_class == 'note-email') echo '#fd7e14';
                            elseif ($color_class == 'note-meeting') echo '#20c997';
                            else echo '#6c757d';
                        ?>;">
                            <i class="<?php echo $icon; ?>"></i>
                        </span>
                        <div class="media-body">
                            <?php if ($note['addedfrom'] == get_staff_user_id() || is_admin()) { ?>
                            <a href="#" class="pull-right text-muted" onclick="delete_lead_note(this,<?= e($note['id']); ?>, <?= e($lead->id); ?>);return false;" style="margin-left: 8px; font-size: 16px;">
                                <i class="fa-regular fa-trash-can"></i>
                            </a>
                            <a href="#" class="pull-right text-muted" onclick="toggle_edit_note(<?= e($note['id']); ?>);return false;" style="margin-left: 8px; font-size: 16px;">
                                <i class="fa-regular fa-pen-to-square"></i>
                            </a>
                            <?php } ?>
                            <div class="media-heading">
                                <strong><?= get_staff_full_name($note['addedfrom']); ?></strong>
                                <small class="text-muted mleft5"><?= _dt($note['dateadded']); ?></small>
                                    <?php if (!empty($note['followup_type'])): ?>
                                    <span class="label label-info mleft10">
                                    <?= _l('Type:'); ?> <?= ucfirst($note['followup_type']); ?>
                                              </span>
                                              <?php endif; ?>
                            </div>
                            <div data-note-description="<?= e($note['id']); ?>" class="text-muted tw-leading-relaxed mtop10">
                                <?= process_text_content_for_display($note['description']); ?>
                                
                                <?php if (!empty($note['file_name'])): ?>
                                <div class="mtop10 note-attachment-wrapper">
                                    <?php
                                    $attachment_url = base_url('uploads/leads/notes/' . $note['id'] . '/' . $note['file_name']);
                                    $file_ext = strtolower(pathinfo($note['file_name'], PATHINFO_EXTENSION));
                                    
                                    if (in_array($file_ext, ['jpg', 'jpeg', 'png', 'gif'])): ?>
                                        <div class="note-image-preview">
                                            <a href="<?= $attachment_url; ?>" target="_blank" data-lightbox="lead-note-<?= $note['id']; ?>">
                                                <img src="<?= $attachment_url; ?>" alt="Image Attachment" class="img-responsive img-thumbnail" style="max-width:300px;max-height:200px;" />
                                            </a>
                                        </div>
                                    <?php elseif (in_array($file_ext, ['mp3', 'wav', 'ogg'])): ?>
                                        <div class="note-audio-preview">
                                            <audio controls class="audio-control">
                                                <source src="<?= $attachment_url; ?>" type="audio/<?= $file_ext; ?>">
                                                <?= _l('Your browser does not support the audio element.'); ?>
                                            </audio>
                                        </div>
                                    <?php else: ?>
                                        <div class="note-file-attachment">
                                            <a href="<?= $attachment_url; ?>" target="_blank" class="btn btn-link">
                                                <i class="fa fa-download"></i> <?= _l('Download Attachment'); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                            <div data-note-edit-textarea="<?= e($note['id']); ?>" class="hide mtop15">
                                <?= render_textarea('note', '', $note['description']); ?>
                                <div class="text-right">
                                    <button type="button" class="btn btn-default" onclick="toggle_edit_note(<?= e($note['id']); ?>);return false;">
                                        <?= _l('cancel'); ?>
                                    </button>
                                    <button type="button" class="btn btn-primary" onclick="edit_note(<?= e($note['id']); ?>);">
                                        <?= _l('update_note'); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <?php if ($i >= 0 && $i != $len - 1) {
                            echo '<hr />';
                        }
                        ?>
                    </div>
                    <?php 
                        $i++;
                    } ?>
                    <?php // End of foreach loop for notes ?>
                </div>
                <?php hooks()->do_action('after_lead_tabs_content', $lead ?? null); ?>
            </div>
        </div>
    </div>
</div>

<script>
function delete_lead_note(el, note_id, lead_id) {
    if (!confirm('Are you sure you want to delete this note?')) return;
    $.post(admin_url + 'leads/delete_note/' + note_id + '/' + lead_id)
        .done(function(response) {
            var res = JSON.parse(response);
            if (res.success) {
                $(el).closest('.lead-note').fadeOut(300, function() { $(this).remove(); });
                alert_float('success', res.message || 'Note deleted successfully');
            } else {
                alert_float('danger', res.message || 'Failed to delete note');
            }
        })
        .fail(function() {
            alert_float('danger', 'Failed to delete note');
        });
}

<!-- AI Analysis styles are loaded from external CSS files -->


<!-- JavaScript functionality is loaded from external files -->

<?php if (isset($lead)) { ?>
<script>
$(document).ready(function() {
    // AI Analysis tab initialization - simplified
    $('a[href="#ai_analysis"]').on('shown.bs.tab', function() {
        if (typeof window.initAIAnalysisV2 === 'function') {
            window.initAIAnalysisV2(<?= $lead->id; ?>);
        }
    });
});
</script>
<?php } ?>








/* AI Insights Dashboard */
.ai-insights-dashboard {
    padding: 30px;
    background: white;
    margin: -20px 30px 30px 30px;
    border-radius: 12px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.1);
}

.ai-metric-card {
    background: white;
    border-radius: 12px;
    padding: 25px;
    border: 1px solid #e9ecef;
    transition: all 0.3s ease;
    height: 160px;
    display: flex;
    align-items: center;
    gap: 20px;
    position: relative;
    overflow: hidden;
}

.ai-metric-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 4px;
    height: 100%;
    background: var(--card-color, #6c757d);
    transition: width 0.3s ease;
}

.ai-metric-card:hover::before {
    width: 8px;
}

.ai-metric-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0,0,0,0.1);
}

.lead-score-card { --card-color: #28a745; }
.conversion-card { --card-color: #007bff; }
.engagement-card { --card-color: #ffc107; }
.risk-card { --card-color: #dc3545; }

.metric-icon {
    font-size: 2.5rem;
    color: var(--card-color, #6c757d);
    opacity: 0.8;
    min-width: 60px;
}

.metric-content h3 {
    font-size: 2.2rem;
    font-weight: 600;
    margin: 0;
    color: #2c3e50;
}

.metric-content p {
    margin: 5px 0;
    color: #6c757d;
    font-weight: 500;
}

.score-bar {
    width: 100%;
    height: 6px;
    background: #e9ecef;
    border-radius: 3px;
    overflow: hidden;
    margin-top: 10px;
}

.score-fill {
    height: 100%;
    background: var(--card-color);
    border-radius: 3px;
    transition: width 0.6s ease;
    width: 0%;
}

.engagement-indicators {
    display: flex;
    gap: 8px;
    margin-top: 10px;
}

.indicator {
    width: 12px;
    height: 12px;
    border-radius: 50%;
    background: #e9ecef;
    transition: background 0.3s ease;
}

.indicator.active { background: var(--card-color); }

/* Main Interface */
.ai-main-interface {
    padding: 0 30px 30px 30px;
}

/* Analysis Types Grid */
.analysis-type-selector h4 {
    color: #2c3e50;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.analysis-types-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.analysis-type-card {
    background: white;
    border: 2px solid #e9ecef;
    border-radius: 12px;
    padding: 25px;
    text-align: center;
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
}

.analysis-type-card:hover {
    border-color: #667eea;
    transform: translateY(-3px);
    box-shadow: 0 10px 25px rgba(102, 126, 234, 0.15);
}

.analysis-type-card.active {
    border-color: #667eea;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.type-icon {
    font-size: 2.5rem;
    margin-bottom: 15px;
    color: #667eea;
}

.analysis-type-card.active .type-icon {
    color: white;
}

.analysis-type-card h5 {
    margin: 0 0 10px 0;
    font-weight: 600;
}

.analysis-type-card p {
    margin: 0;
    font-size: 0.9rem;
    opacity: 0.8;
}

/* Upload Zone */
.ai-upload-zone {
    background: white;
    border-radius: 12px;
    margin-bottom: 30px;
}

.upload-area {
    border: 3px dashed #dee2e6;
    border-radius: 12px;
    padding: 60px 30px;
    text-align: center;
    transition: all 0.3s ease;
    cursor: pointer;
}

.upload-area:hover {
    border-color: #667eea;
    background: #f8f9ff;
}

.upload-area.drag-over {
    border-color: #667eea;
    background: #f0f8ff;
    transform: scale(1.02);
}

.upload-icon {
    font-size: 3rem;
    color: #6c757d;
    margin-bottom: 20px;
}

.upload-area h4 {
    color: #2c3e50;
    margin-bottom: 10px;
}

.upload-area p {
    color: #6c757d;
    margin-bottom: 20px;
}

/* Analysis Parameters */
.analysis-parameters {
    background: white;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 30px;
}

.analysis-parameters h5 {
    color: #2c3e50;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

/* Action Buttons */
.analysis-actions {
    text-align: center;
    margin-bottom: 30px;
}

.analysis-actions .btn {
    margin: 0 10px;
    border-radius: 25px;
    padding: 15px 30px;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    transition: all 0.3s ease;
}

.analysis-actions .btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}

/* Results Panels */
.ai-results-panel,
.ai-recommendations-panel,
.ai-history-panel {
    background: white;
    border-radius: 12px;
    padding: 25px;
    margin-bottom: 20px;
    border: 1px solid #e9ecef;
}

.ai-results-panel h5,
.ai-recommendations-panel h5,
.ai-history-panel h5 {
    color: #2c3e50;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 10px;
}

.no-results-placeholder,
.recommendation-placeholder,
.history-placeholder {
    text-align: center;
    padding: 40px 20px;
    color: #6c757d;
}

.no-results-placeholder i {
    font-size: 3rem;
    margin-bottom: 15px;
    opacity: 0.5;
}

/* History Controls */
.history-controls {
    margin-bottom: 20px;
}

.history-controls .btn-group {
    width: 100%;
}

.history-controls .btn {
    flex: 1;
    border-radius: 6px;
}

/* Progress Modal */
.ai-progress-container {
    padding: 20px 0;
}

.progress-stage {
    display: flex;
    align-items: center;
    gap: 20px;
    padding: 20px;
    margin-bottom: 15px;
    border-radius: 8px;
    transition: all 0.3s ease;
    opacity: 0.5;
}

.progress-stage.active {
    opacity: 1;
    background: #f8f9ff;
    border-left: 4px solid #667eea;
}

.progress-stage.completed {
    opacity: 0.8;
    background: #f8f9fa;
}

.stage-icon {
    font-size: 1.5rem;
    color: #667eea;
    min-width: 40px;
}

.stage-content h5 {
    margin: 0 0 5px 0;
    color: #2c3e50;
}

.stage-content p {
    margin: 0;
    color: #6c757d;
    font-size: 0.9rem;
}

.overall-progress {
    margin-top: 30px;
}

.overall-progress .progress {
    height: 12px;
    border-radius: 6px;
    background: #e9ecef;
}

.overall-progress .progress-bar {
    background: linear-gradient(90deg, #667eea 0%, #764ba2 100%);
    border-radius: 6px;
}

/* Responsive Design */
@media (max-width: 768px) {
    .hero-content {
        flex-direction: column;
        text-align: center;
        gap: 20px;
    }
    
    .hero-actions {
        margin-left: 0;
    }
    
    .ai-insights-dashboard {
        margin: -10px 15px 20px 15px;
        padding: 20px;
    }
    
    .ai-main-interface {
        padding: 0 15px 20px 15px;
    }
    
    .analysis-types-grid {
        grid-template-columns: 1fr;
    }
    
    .hero-text h2 {
        font-size: 2rem;
    }
}

/* Animation Classes */
.fade-in {
    animation: fadeIn 0.5s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(20px); }
    to { opacity: 1; transform: translateY(0); }
}

.slide-up {
    animation: slideUp 0.4s ease-out;
}

@keyframes slideUp {
    from { transform: translateY(30px); opacity: 0; }
    to { transform: translateY(0); opacity: 1; }
}

/* Additional Result Styles */
.analysis-result-card {
    border: 1px solid #e9ecef;
    border-radius: 8px;
    padding: 20px;
    background: white;
}

.result-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}

.result-header h4 {
    margin: 0;
    color: #2c3e50;
    display: flex;
    align-items: center;
    gap: 10px;
}

.result-summary p {
    margin: 8px 0;
    color: #495057;
}

.result-actions {
    margin-top: 15px;
    text-align: right;
}

.result-actions .btn {
    margin-left: 8px;
}

.recommendation-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 12px 0;
    border-bottom: 1px solid #f8f9fa;
}

.recommendation-item:last-child {
    border-bottom: none;
}

.recommendation-item i {
    font-size: 1.2rem;
    min-width: 20px;
}

.history-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px 0;
    border-bottom: 1px solid #f8f9fa;
    cursor: pointer;
    transition: all 0.3s ease;
}

.history-item:hover {
    background: #f8f9fa;
    margin: 0 -15px;
    padding: 15px;
    border-radius: 8px;
}

.history-item:last-child {
    border-bottom: none;
}

.history-icon {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #667eea;
}

.history-content h6 {
    margin: 0 0 5px 0;
    color: #2c3e50;
}

.history-content p {
    margin: 0;
    font-size: 0.85rem;
}

.uploaded-files-list {
    margin-top: 20px;
    padding: 20px;
    background: #f8f9fa;
    border-radius: 8px;
}

.uploaded-file-item {
    display: flex;
    align-items: center;
    gap: 10px;
    padding: 8px 0;
    border-bottom: 1px solid #dee2e6;
}

.uploaded-file-item:last-child {
    border-bottom: none;
}

.uploaded-file-item i {
    color: #667eea;
}

.uploaded-file-item .remove-file {
    margin-left: auto;
    padding: 2px 6px;
}
</style>

<script>
<?php if (isset($lead)) { ?>
// Initialize AI Analysis when the tab is shown
$(document).ready(function() {
    // Initialize AI analysis functionality when the AI tab is clicked
    $('a[href="#ai_analysis"]').on('shown.bs.tab', function() {
        // Use new V2 initialization if available, fallback to V1
        if (typeof window.initAIAnalysisV2 === 'function') {
            window.initAIAnalysisV2(<?= $lead->id; ?>);
        } else if (typeof window.initAIAnalysis === 'function') {
            window.initAIAnalysis(<?= $lead->id; ?>);
        }
        initializeAIInterface();
    });
    
    // Load AI analysis history when modal opens
    if (typeof window.loadAIAnalysisHistory === 'function') {
        window.loadAIAnalysisHistory(<?= $lead->id; ?>);
    }
    
    // Enhanced AI Interface Functions
    function initializeAIInterface() {
        // Analysis type selection
        $('.analysis-type-card').on('click', function() {
            $('.analysis-type-card').removeClass('active');
            $(this).addClass('active');
            $(this).addClass('fade-in');
        });
        
        // Quick analyze button
        $('.ai-quick-analyze').on('click', function() {
            const leadId = $(this).data('lead-id');
            startQuickAnalysis(leadId);
        });
        
        // File upload handling
        const uploadZone = $('#ai-upload-zone .upload-area');
        
        uploadZone.on('dragover', function(e) {
            e.preventDefault();
            $(this).addClass('drag-over');
        });
        
        uploadZone.on('dragleave', function(e) {
            e.preventDefault();
            $(this).removeClass('drag-over');
        });
        
        uploadZone.on('drop', function(e) {
            e.preventDefault();
            $(this).removeClass('drag-over');
            const files = e.originalEvent.dataTransfer.files;
            handleFileUpload(files);
        });
        
        // Start analysis button
        $('#start-ai-analysis').on('click', function() {
            startAIAnalysis();
        });
        
        // History filter buttons
        $('.history-controls .btn').on('click', function() {
            $('.history-controls .btn').removeClass('active');
            $(this).addClass('active');
            const filter = $(this).data('filter');
            filterAnalysisHistory(filter);
        });
        
        // Load initial data
        loadAIMetrics();
        loadAnalysisHistory();
    }
    
    function startQuickAnalysis(leadId) {
        // Show progress modal
        $('#ai-progress-modal').modal('show');
        
        // Simulate analysis stages
        const stages = ['stage-1', 'stage-2', 'stage-3', 'stage-4'];
        let currentStage = 0;
        let progress = 0;
        
        const progressInterval = setInterval(function() {
            progress += Math.random() * 15 + 5;
            
            if (progress >= 100) {
                progress = 100;
                clearInterval(progressInterval);
                
                // Complete analysis
                setTimeout(function() {
                    $('#ai-progress-modal').modal('hide');
                    showAnalysisResults();
                    updateAIMetrics();
                }, 1000);
            }
            
            // Update stage
            if (progress > (currentStage + 1) * 25 && currentStage < stages.length - 1) {
                $(`#${stages[currentStage]}`).removeClass('active').addClass('completed');
                currentStage++;
                $(`#${stages[currentStage]}`).addClass('active');
            }
            
            // Update progress bar
            $('#overall-progress-bar').css('width', progress + '%');
            $('#progress-percentage').text(Math.round(progress));
        }, 500);
    }
    
    function startAIAnalysis() {
        const analysisType = $('.analysis-type-card.active').data('type');
        const focusAreas = $('#ai-focus-areas').val();
        const depth = $('#ai-analysis-depth').val();
        const context = $('#ai-context').val();
        
        // Validate inputs
        if (!analysisType) {
            alert('Please select an analysis type');
            return;
        }
        
        // Start analysis with parameters
        startQuickAnalysis(<?= $lead->id; ?>);
    }
    
    function handleFileUpload(files) {
        if (files.length === 0) return;
        
        // Show upload progress
        const uploadProgress = $('#ai-upload-zone .upload-progress');
        uploadProgress.show();
        
        // Simulate file upload
        let progress = 0;
        const uploadInterval = setInterval(function() {
            progress += Math.random() * 10 + 5;
            if (progress >= 100) {
                progress = 100;
                clearInterval(uploadInterval);
                
                setTimeout(function() {
                    uploadProgress.hide();
                    showUploadedFiles(files);
                }, 500);
            }
            
            uploadProgress.find('.progress-bar').css('width', progress + '%');
        }, 200);
    }
    
    function showUploadedFiles(files) {
        const fileList = $('<div class="uploaded-files-list"></div>');
        
        for (let i = 0; i < files.length; i++) {
            const file = files[i];
            const fileItem = $(`
                <div class="uploaded-file-item">
                    <i class="fa fa-file"></i>
                    <span>${file.name}</span>
                    <button type="button" class="btn btn-sm btn-danger remove-file">
                        <i class="fa fa-times"></i>
                    </button>
                </div>
            `);
            fileList.append(fileItem);
        }
        
        $('#ai-upload-zone').append(fileList);
    }
    
    function loadAIMetrics() {
        // Simulate loading AI metrics
        setTimeout(function() {
            updateAIMetrics({
                score: 75,
                conversion: '68%',
                engagement: 'High',
                risk: 'Low'
            });
        }, 1000);
    }
    
    function updateAIMetrics(metrics = null) {
        if (!metrics) {
            metrics = {
                score: Math.floor(Math.random() * 40) + 60,
                conversion: Math.floor(Math.random() * 30) + 50 + '%',
                engagement: ['Low', 'Medium', 'High'][Math.floor(Math.random() * 3)],
                risk: ['Low', 'Medium', 'High'][Math.floor(Math.random() * 3)]
            };
        }
        
        // Update metrics with animation
        $('#ai-lead-score').text(metrics.score);
        $('#score-progress').css('width', metrics.score + '%');
        
        $('#ai-conversion-rate').text(metrics.conversion);
        $('#ai-engagement').text(metrics.engagement);
        $('#ai-risk-level').text(metrics.risk);
        
        // Add animation class
        $('.ai-metric-card').addClass('slide-up');
    }
    
    function showAnalysisResults() {
        const resultsHtml = `
            <div class="analysis-result-card">
                <div class="result-header">
                    <h4><i class="fa fa-chart-bar"></i> Analysis Complete</h4>
                    <span class="badge badge-success">Success</span>
                </div>
                <div class="result-summary">
                    <p><strong>Overall Score:</strong> 78/100</p>
                    <p><strong>Conversion Probability:</strong> 65%</p>
                    <p><strong>Recommended Action:</strong> Schedule follow-up call within 48 hours</p>
                </div>
                <div class="result-actions">
                    <button class="btn btn-primary btn-sm">View Full Report</button>
                    <button class="btn btn-secondary btn-sm">Export Results</button>
                </div>
            </div>
        `;
        
        $('#ai-latest-results').html(resultsHtml);
        
        // Show recommendations
        const recommendationsHtml = `
            <div class="recommendation-item">
                <i class="fa fa-lightbulb text-warning"></i>
                <span>Follow up within 48 hours for optimal conversion</span>
            </div>
            <div class="recommendation-item">
                <i class="fa fa-users text-info"></i>
                <span>Include decision makers in next meeting</span>
            </div>
            <div class="recommendation-item">
                <i class="fa fa-file-alt text-success"></i>
                <span>Prepare detailed proposal with pricing</span>
            </div>
        `;
        
        $('#ai-recommendations').html(recommendationsHtml);
    }
    
    function loadAnalysisHistory() {
        // Simulate loading history
        const historyHtml = `
            <div class="history-item">
                <div class="history-icon">
                    <i class="fa fa-chart-bar"></i>
                </div>
                <div class="history-content">
                    <h6>Comprehensive Analysis</h6>
                    <p class="text-muted">Score: 78 • 2 hours ago</p>
                </div>
            </div>
            <div class="history-item">
                <div class="history-icon">
                    <i class="fa fa-file-alt"></i>
                </div>
                <div class="history-content">
                    <h6>Document Analysis</h6>
                    <p class="text-muted">Score: 72 • 1 day ago</p>
                </div>
            </div>
        `;
        
        $('#ai-history-list').html(historyHtml);
    }
    
    function filterAnalysisHistory(filter) {
        // Filter history based on selection
        console.log('Filtering history by:', filter);
        loadAnalysisHistory(); // Reload with filter
    }
});
<?php } ?>
</script>
