<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin">
                            <i class="fa fa-brain"></i> <?php echo $title; ?>
                        </h4>
                        <hr class="hr-panel-heading">
                        
                        <div class="row">
                            <div class="col-md-12">
                                <p>Welcome to the AI Lead Analysis setup. Use the options below to configure and manage your AI analysis features.</p>
                            </div>
                        </div>
                        
                        <!-- Database Status -->
                        <div class="row mtop15">
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-database"></i> Database Status
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if ($table_status['ai_reports'] && $table_status['ai_queue']): ?>
                                            <div class="alert alert-success">
                                                <i class="fa fa-check"></i> Database tables are properly configured
                                            </div>
                                        <?php else: ?>
                                            <div class="alert alert-warning">
                                                <i class="fa fa-exclamation-triangle"></i> Database tables need to be created
                                            </div>
                                        <?php endif; ?>
                                        
                                        <ul class="list-unstyled">
                                            <li>
                                                <i class="fa fa-<?php echo $table_status['ai_reports'] ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                AI Reports Table
                                            </li>
                                            <li>
                                                <i class="fa fa-<?php echo $table_status['ai_queue'] ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                AI Analysis Queue Table
                                            </li>
                                        </ul>
                                        
                                        <a href="<?php echo admin_url('ai_setup/fix_database'); ?>" class="btn btn-primary">
                                            <i class="fa fa-wrench"></i> Fix Database Structure
                                        </a>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- OpenAI Configuration -->
                            <div class="col-md-6">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-brain"></i> OpenAI Configuration
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php if ($openai_configured): ?>
                                            <div class="alert alert-success">
                                                <i class="fa fa-check"></i> OpenAI API key is configured
                                            </div>
                                            <p><strong>Current API Key:</strong> <?php echo $openai_key_masked; ?></p>
                                        <?php else: ?>
                                            <div class="alert alert-warning">
                                                <i class="fa fa-exclamation-triangle"></i> OpenAI API key is not configured
                                            </div>
                                        <?php endif; ?>
                                        
                                        <div class="btn-group-vertical btn-block">
                                            <a href="<?php echo admin_url('ai_setup/setup_openai'); ?>" class="btn btn-success">
                                                <i class="fa fa-cog"></i> Configure OpenAI
                                            </a>
                                            <a href="<?php echo admin_url('openai_settings'); ?>" class="btn btn-info">
                                                <i class="fa fa-key"></i> Manage OpenAI Settings
                                            </a>
                                            <a href="<?php echo admin_url('ai_setup/fine_tuning'); ?>" class="btn btn-warning">
                                                <i class="fa fa-cogs"></i> Fine-Tuning Management
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Quick Actions -->
                        <div class="row mtop15">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-bolt"></i> Quick Actions
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <a href="<?php echo admin_url('leads'); ?>" class="btn btn-block btn-info">
                                                    <i class="fa fa-users"></i><br>
                                                    Go to Leads
                                                </a>
                                                <p class="text-muted text-center mtop5">Test AI analysis on your leads</p>
                                            </div>
                                            <div class="col-md-4">
                                                <a href="<?php echo admin_url('settings'); ?>" class="btn btn-block btn-default">
                                                    <i class="fa fa-cogs"></i><br>
                                                    General Settings
                                                </a>
                                                <p class="text-muted text-center mtop5">Access general CRM settings</p>
                                            </div>
                                            <div class="col-md-4">
                                                <a href="<?php echo admin_url(); ?>" class="btn btn-block btn-default">
                                                    <i class="fa fa-home"></i><br>
                                                    Admin Dashboard
                                                </a>
                                                <p class="text-muted text-center mtop5">Return to main dashboard</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- System Status -->
                        <div class="row mtop15">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-info-circle"></i> System Status
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h5>Database Tables:</h5>
                                                <ul class="list-unstyled">
                                                    <li>
                                                        <i class="fa fa-<?php echo $table_status['ai_reports'] ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                        <?php echo db_prefix(); ?>leads_ai_reports
                                                    </li>
                                                    <li>
                                                        <i class="fa fa-<?php echo $table_status['ai_queue'] ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                        <?php echo db_prefix(); ?>leads_ai_analysis_queue
                                                    </li>
                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                <h5>Configuration:</h5>
                                                <ul class="list-unstyled">
                                                    <li>
                                                        <i class="fa fa-<?php echo $openai_configured ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                        OpenAI API Key: <?php echo $openai_configured ? 'Configured' : 'Not Set'; ?>
                                                    </li>
                                                    <li>
                                                        <i class="fa fa-<?php echo file_exists(APPPATH . 'models/Leads_ai_model.php') ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                        AI Model: <?php echo file_exists(APPPATH . 'models/Leads_ai_model.php') ? 'Available' : 'Missing'; ?>
                                                    </li>
                                                    <li>
                                                        <i class="fa fa-<?php echo file_exists('assets/js/ai_lead_analysis.js') ? 'check text-success' : 'times text-danger'; ?>"></i>
                                                        Frontend JS: <?php echo file_exists('assets/js/ai_lead_analysis.js') ? 'Available' : 'Missing'; ?>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- AI Model & Prompt Configuration -->
                        <div class="row mtop15">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h4 class="panel-title">
                                            <i class="fa fa-cogs"></i> AI Model & Prompt Configuration
                                        </h4>
                                    </div>
                                    <div class="panel-body">
                                        <?php echo form_open(admin_url('ai_setup/save_model_config')); ?>
                                        
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ai_model">AI Model</label>
                                                    <select name="ai_model" id="ai_model" class="form-control" onchange="checkDeprecatedModel()">
                                                        <option value="gpt-4o" <?php echo $current_ai_model == 'gpt-4o' ? 'selected' : ''; ?>>GPT-4o (Recommended)</option>
                                                        <option value="gpt-4o-mini" <?php echo $current_ai_model == 'gpt-4o-mini' ? 'selected' : ''; ?>>GPT-4o Mini (Faster)</option>
                                                        <option value="gpt-4-turbo" <?php echo $current_ai_model == 'gpt-4-turbo' ? 'selected' : ''; ?>>GPT-4 Turbo</option>
                                                        <option value="gpt-4" <?php echo $current_ai_model == 'gpt-4' ? 'selected' : ''; ?>>GPT-4</option>
                                                        <option value="gpt-3.5-turbo" <?php echo $current_ai_model == 'gpt-3.5-turbo' ? 'selected' : ''; ?>>GPT-3.5 Turbo</option>
                                                        <option value="gpt-4-vision-preview" <?php echo $current_ai_model == 'gpt-4-vision-preview' ? 'selected' : ''; ?>>GPT-4 Vision (Deprecated)</option>
                                                        <optgroup label="Fine-tuned Models">
                                                            <?php 
                                                            $fine_tuned_models = get_option('ai_fine_tuned_models');
                                                            if (!empty($fine_tuned_models)) {
                                                                $models = json_decode($fine_tuned_models, true);
                                                                foreach ($models as $model_id => $model_name) {
                                                                    $selected = $current_ai_model == $model_id ? 'selected' : '';
                                                                    echo "<option value=\"{$model_id}\" {$selected}>{$model_name}</option>";
                                                                }
                                                            }
                                                            ?>
                                                        </optgroup>
                                                    </select>
                                                    <small class="text-muted">Select the AI model to use for lead analysis. GPT-4o supports both text and vision.</small>
                                                    <div id="deprecatedModelWarning" class="alert alert-warning" style="display: none; margin-top: 10px;">
                                                        <strong>Warning:</strong> This model has been deprecated by OpenAI and may not work. Please select a current model like GPT-4o.
                                                    </div>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="custom_model_id">Custom/Fine-tuned Model ID</label>
                                                    <input type="text" name="custom_model_id" id="custom_model_id" class="form-control" 
                                                           placeholder="ft:gpt-3.5-turbo-1106:your-org:custom-model:abc123" 
                                                           value="<?php echo get_option('ai_custom_model_id'); ?>">
                                                    <small class="text-muted">Enter your fine-tuned model ID if you have one. This will override the model selection above.</small>
                                                    <button type="button" class="btn btn-xs btn-info mtop5" onclick="addFinetuneModel()">
                                                        <i class="fa fa-plus"></i> Add to Model List
                                                    </button>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="ai_temperature">Temperature</label>
                                                    <input type="number" name="ai_temperature" id="ai_temperature" class="form-control" 
                                                           value="<?php echo $current_ai_temperature; ?>" 
                                                           min="0" max="2" step="0.1">
                                                    <small class="text-muted">Controls randomness (0.0 = deterministic, 2.0 = very random)</small>
                                                </div>
                                                
                                                <div class="form-group">
                                                    <label for="ai_max_tokens">Max Tokens</label>
                                                    <input type="number" name="ai_max_tokens" id="ai_max_tokens" class="form-control" 
                                                           value="<?php echo $current_ai_max_tokens; ?>" 
                                                           min="100" max="4000">
                                                    <small class="text-muted">Maximum number of tokens in the response</small>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="ai_analysis_prompt">Analysis Prompt Template</label>
                                                    <textarea name="ai_analysis_prompt" id="ai_analysis_prompt" class="form-control" rows="12" placeholder="Enter your custom prompt template..."><?php echo htmlspecialchars($current_ai_prompt); ?></textarea>                                    <small class="text-muted">
                                        Use placeholders: {lead_name}, {lead_email}, {lead_phone}, {lead_company}, {lead_source}, {lead_value}, {lead_description}, {lead_date_added}, {lead_last_contact}, {follow_up_notes}, {activity_log}, {file_content}
                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fa fa-save"></i> Save Configuration
                                                </button>
                                                <button type="button" class="btn btn-default" onclick="resetToDefault()">
                                                    <i class="fa fa-refresh"></i> Reset to Default
                                                </button>
                                                <button type="button" class="btn btn-info" onclick="testPrompt()">
                                                    <i class="fa fa-test-tube"></i> Test Prompt
                                                </button>
                                                <a href="<?php echo admin_url('ai_setup/set_defaults'); ?>" class="btn btn-warning" onclick="return confirm('This will reset all AI settings to default values. Continue?')">
                                                    <i class="fa fa-cog"></i> Force Set Defaults
                                                </a>
                                            </div>
                                        </div>
                                        
                                        <?php echo form_close(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>

<script>
function checkDeprecatedModel() {
    var selectedModel = $('#ai_model').val();
    var deprecatedModels = ['gpt-4-vision-preview', 'gpt-4-32k', 'gpt-3.5-turbo-16k'];
    
    if (deprecatedModels.includes(selectedModel)) {
        $('#deprecatedModelWarning').show();
    } else {
        $('#deprecatedModelWarning').hide();
    }
}

// Check on page load
$(document).ready(function() {
    checkDeprecatedModel();
});

function resetToDefault() {
    if (confirm('Are you sure you want to reset the prompt to default? This will overwrite your current prompt.')) {
        $('#ai_analysis_prompt').val(`<?php echo addslashes($default_prompt); ?>`);
        $('#ai_model').val('gpt-4o');
        $('#ai_temperature').val('0.3');
        $('#ai_max_tokens').val('1000');
        checkDeprecatedModel();
    }
}

function testPrompt() {
    var prompt = $('#ai_analysis_prompt').val();
    var model = $('#ai_model').val();
    
    if (!prompt.trim()) {
        alert('Please enter a prompt to test');
        return;
    }
    
    // Show loading
    var originalText = event.target.innerHTML;
    event.target.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Testing...';
    event.target.disabled = true;
    
    $.ajax({
        url: admin_url + 'ai_setup/test_prompt',
        type: 'POST',
        data: {
            prompt: prompt,
            model: model,
            temperature: $('#ai_temperature').val(),
            max_tokens: $('#ai_max_tokens').val(),
            csrf_token_name: $('input[name="csrf_token_name"]').val()
        },
        success: function(response) {
            if (response.success) {
                alert('Prompt test successful!\n\nResponse preview:\n' + response.preview);
            } else {
                alert('Prompt test failed: ' + response.message);
            }
        },
        error: function() {
            alert('Error testing prompt. Please check your configuration.');
        },
        complete: function() {
            event.target.innerHTML = originalText;
            event.target.disabled = false;
        }
    });
}
</script>
