<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-8">
                                <h4 class="no-margin">
                                    <i class="fa fa-brain"></i> <?php echo $title; ?>
                                </h4>
                            </div>
                            <div class="col-md-4 text-right">
                                <!-- Export buttons -->
                                <div class="btn-group">
                                    <a href="<?php echo admin_url('ai_reports/export?format=csv&' . http_build_query($filters)); ?>" 
                                       class="btn btn-default btn-sm">
                                        <i class="fa fa-file-excel-o"></i> Export CSV
                                    </a>
                                    <a href="<?php echo admin_url('ai_reports/export?format=pdf&' . http_build_query($filters)); ?>" 
                                       class="btn btn-default btn-sm">
                                        <i class="fa fa-file-pdf-o"></i> Export PDF
                                    </a>
                                </div>
                            </div>
                        </div>
                        <hr class="hr-panel-heading">
                        
                        <!-- Statistics Overview -->
                        <?php if (isset($stats)): ?>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="alert alert-info">
                                    <h4 class="no-margin"><?php echo $stats['total']; ?></h4>
                                    <small>Total Reports</small>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="alert alert-success">
                                    <h4 class="no-margin"><?php echo $stats['average_confidence']; ?>%</h4>
                                    <small>Average Confidence</small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="alert alert-warning">
                                    <strong>Verdict Distribution:</strong>
                                    <?php if (!empty($stats['verdict_distribution'])): ?>
                                        <?php foreach ($stats['verdict_distribution'] as $verdict): ?>
                                            <span class="label label-default"><?php echo e($verdict->verdict); ?> (<?php echo $verdict->count; ?>)</span>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        No data available
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Filters -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title">
                                            <i class="fa fa-filter"></i> Filters
                                            <button type="button" class="btn btn-xs btn-link pull-right" onclick="toggleFilters()">
                                                <span id="filter-toggle-text">Show</span> <i class="fa fa-chevron-down" id="filter-toggle-icon"></i>
                                            </button>
                                        </h3>
                                    </div>
                                    <div class="panel-body" id="filters-panel" style="display: none;">
                                        <form method="GET" action="<?php echo admin_url('ai_reports'); ?>">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label for="verdict">Verdict</label>
                                                        <select name="verdict" id="verdict" class="form-control">
                                                            <option value="">All Verdicts</option>
                                                            <?php if (!empty($verdicts)): ?>
                                                                <?php foreach ($verdicts as $verdict): ?>
                                                                    <option value="<?php echo e($verdict['verdict']); ?>" 
                                                                            <?php echo ($filters['verdict'] == $verdict['verdict']) ? 'selected' : ''; ?>>
                                                                        <?php echo e(ucfirst($verdict['verdict'])); ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            <?php endif; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="form-group">
                                                        <label for="analysis_type">Analysis Type</label>
                                                        <select name="analysis_type" id="analysis_type" class="form-control">
                                                            <option value="">All Types</option>
                                                            <?php if (!empty($analysis_types)): ?>
                                                                <?php foreach ($analysis_types as $type): ?>
                                                                    <option value="<?php echo e($type['analysis_type']); ?>" 
                                                                            <?php echo ($filters['analysis_type'] == $type['analysis_type']) ? 'selected' : ''; ?>>
                                                                        <?php echo e(ucfirst(str_replace('_', ' ', $type['analysis_type']))); ?>
                                                                    </option>
                                                                <?php endforeach; ?>
                                                            <?php endif; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label for="date_from">Date From</label>
                                                        <input type="date" name="date_from" id="date_from" 
                                                               class="form-control" value="<?php echo e($filters['date_from']); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label for="date_to">Date To</label>
                                                        <input type="date" name="date_to" id="date_to" 
                                                               class="form-control" value="<?php echo e($filters['date_to']); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-md-2">
                                                    <div class="form-group">
                                                        <label>&nbsp;</label>
                                                        <div>
                                                            <button type="submit" class="btn btn-primary btn-sm">
                                                                <i class="fa fa-filter"></i> Apply
                                                            </button>
                                                            <a href="<?php echo admin_url('ai_reports'); ?>" class="btn btn-default btn-sm">
                                                                <i class="fa fa-refresh"></i> Clear
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Reports Table -->
                        <div class="table-responsive">
                            <!-- Bulk Actions Bar -->
                            <?php if (is_admin()): ?>
                            <div class="bulk-actions-bar" id="bulk-actions-bar" style="display: none; margin-bottom: 10px;">
                                <div class="alert alert-info">
                                    <span id="selected-count">0</span> reports selected
                                    <div class="btn-group pull-right">
                                        <button type="button" class="btn btn-danger btn-sm" onclick="bulkDeleteReports()">
                                            <i class="fa fa-trash"></i> Delete Selected
                                        </button>
                                        <button type="button" class="btn btn-default btn-sm" onclick="clearSelection()">
                                            <i class="fa fa-times"></i> Clear Selection
                                        </button>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <table class="table table-striped table-bordered ai-reports-table" id="ai-reports-static">
                                <thead>
                                    <tr>
                                        <?php if (is_admin()): ?>
                                        <th width="30">
                                            <input type="checkbox" id="select-all" onchange="toggleSelectAll(this)">
                                        </th>
                                        <?php endif; ?>
                                        <th>Report ID</th>
                                        <th>Lead</th>
                                        <th>Confidence Score</th>
                                        <th>Verdict</th>
                                        <th>Analysis Type</th>
                                        <th>Created Date</th>
                                        <th>Created By</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    // SIMPLIFIED APPROACH: Get reports directly with minimal processing
                                    $this->load->database();
                                    
                                    // First, let's see what columns we actually have
                                    $fields = $this->db->list_fields(db_prefix() . 'leads_ai_reports');
                                    
                                    // Build a simple query
                                    $query = "SELECT r.*, l.name as lead_name, l.company as lead_company, l.email as lead_email, 
                                             CONCAT(s.firstname, ' ', s.lastname) as created_by_name 
                                             FROM " . db_prefix() . "leads_ai_reports r 
                                             LEFT JOIN " . db_prefix() . "leads l ON l.id = r.lead_id 
                                             LEFT JOIN " . db_prefix() . "staff s ON s.staffid = r.created_by 
                                             ORDER BY r.id DESC 
                                             LIMIT 100";
                                    
                                    $reports = $this->db->query($query)->result();
                                    
                                    if (empty($reports)): ?>
                                        <tr>
                                            <td colspan="<?php echo is_admin() ? '9' : '8'; ?>" class="text-center">
                                                <div class="alert alert-info">
                                                    <i class="fa fa-info-circle"></i> No AI reports found.
                                                    <?php if (!empty(array_filter($filters))): ?>
                                                        Try adjusting your filters or <a href="<?php echo admin_url('ai_reports'); ?>">clear all filters</a>.
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php else: ?>
                                        <?php foreach ($reports as $report): ?>
                                        <tr data-report-id="<?php echo $report->id; ?>">
                                            <?php if (is_admin()): ?>
                                            <td>
                                                <input type="checkbox" name="report_ids[]" value="<?php echo $report->id; ?>" 
                                                       onchange="updateSelectionCount()">
                                            </td>
                                            <?php endif; ?>>
                                            <td>
                                                <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>" class="font-medium">
                                                    #<?php echo $report->id; ?>
                                                </a>
                                            </td>
                                            <td>
                                                <?php if (!empty($report->lead_name)): ?>
                                                    <a href="<?php echo admin_url('leads/index/' . $report->lead_id); ?>" class="font-medium">
                                                        <?php echo e($report->lead_name); ?>
                                                    </a>
                                                    <?php if (!empty($report->lead_company)): ?>
                                                        <br><small class="text-muted"><?php echo e($report->lead_company); ?></small>
                                                    <?php endif; ?>
                                                    <?php if (!empty($report->lead_email)): ?>
                                                        <br><small class="text-muted"><?php echo e($report->lead_email); ?></small>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="text-muted">Lead #<?php echo $report->lead_id; ?> (Deleted)</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php
                                                // SIMPLIFIED: Check all possible score columns directly
                                                $score = 0;
                                                $score_found = false;
                                                
                                                // Check each possible column name
                                                if (property_exists($report, 'score') && is_numeric($report->score)) {
                                                    $score = (float)$report->score;
                                                    $score_found = true;
                                                } elseif (property_exists($report, 'confidence_score') && is_numeric($report->confidence_score)) {
                                                    $score = (float)$report->confidence_score;
                                                    $score_found = true;
                                                }
                                                
                                                if ($score_found && $score > 0): 
                                                    $score_class = $score >= 80 ? 'success' : ($score >= 60 ? 'warning' : 'danger');
                                                ?>
                                                    <div class="progress" style="margin-bottom: 5px; height: 20px;">
                                                        <div class="progress-bar progress-bar-<?php echo $score_class; ?>" 
                                                             style="width: <?php echo $score; ?>%; line-height: 20px;">
                                                            <?php echo $score; ?>%
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <span class="text-muted">No Score</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php
                                                // SIMPLIFIED: Check all possible verdict columns directly
                                                $verdict = 'Unknown';
                                                
                                                if (property_exists($report, 'verdict') && !empty($report->verdict)) {
                                                    $verdict = $report->verdict;
                                                } elseif (property_exists($report, 'purchase_likelihood') && !empty($report->purchase_likelihood)) {
                                                    $verdict = $report->purchase_likelihood;
                                                }
                                                
                                                $badge_class = '';
                                                switch (strtolower($verdict)) {
                                                    case 'hot':
                                                    case 'high':
                                                        $badge_class = 'success';
                                                        break;
                                                    case 'warm':
                                                    case 'medium':
                                                        $badge_class = 'warning';
                                                        break;
                                                    case 'cold':
                                                    case 'low':
                                                        $badge_class = 'danger';
                                                        break;
                                                    default:
                                                        $badge_class = 'default';
                                                        break;
                                                }
                                                ?>
                                                <span class="label label-<?php echo $badge_class; ?>">
                                                    <?php echo e(ucfirst($verdict)); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <?php echo e(ucfirst(str_replace('_', ' ', $report->analysis_type))); ?>
                                            </td>
                                            <td>
                                                <?php echo e(_dt($report->created_at)); ?>
                                            </td>
                                            <td>
                                                <?php echo !empty($report->created_by_name) ? e($report->created_by_name) : 'Unknown'; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="<?php echo admin_url('ai_reports/view/' . $report->id); ?>" 
                                                       class="btn btn-default btn-xs" 
                                                       title="View Report">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    <?php if (is_admin()): ?>
                                                    <a href="<?php echo admin_url('ai_reports/delete/' . $report->id); ?>" 
                                                       class="btn btn-danger btn-xs" 
                                                       onclick="return confirm('Are you sure you want to delete this AI report? This action cannot be undone.')" 
                                                       title="Delete Report">
                                                        <i class="fa fa-trash"></i>
                                                    </a>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Results Info -->
                        <div class="row">
                            <div class="col-md-6">
                                <p class="text-muted">
                                    <i class="fa fa-info-circle"></i> 
                                    Showing <?php echo count($reports); ?> reports
                                    <?php if (!empty(array_filter($filters))): ?>
                                        (filtered)
                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="col-md-6 text-right">
                                <!-- Bulk actions are now in the table header area -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- CSS to ensure table visibility and prevent DataTables interference -->
<style>
/* Prevent any external scripts from hiding table rows */
.ai-reports-table tbody tr {
    display: table-row !important;
    visibility: visible !important;
    opacity: 1 !important;
}

.ai-reports-table {
    width: 100% !important;
    table-layout: auto !important;
}

/* Progress bar styling */
.progress {
    background-color: #f5f5f5;
    border-radius: 4px;
    box-shadow: inset 0 1px 2px rgba(0,0,0,.1);
}

/* Button styling */
.btn-group .btn {
    margin-right: 2px;
}

/* Filter panel styling */
#filters-panel {
    border-top: 1px solid #ddd;
    margin-top: 10px;
    padding-top: 15px;
}

/* Bulk actions bar styling */
.bulk-actions-bar {
    margin-bottom: 15px;
}

.bulk-actions-bar .alert {
    margin-bottom: 0;
    padding: 10px 15px;
}

/* Checkbox styling */
input[type="checkbox"] {
    margin: 0;
    cursor: pointer;
}

#select-all {
    margin: 0;
}

/* Selection highlight */
tr.selected {
    background-color: #f0f8ff !important;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .table-responsive {
        font-size: 12px;
    }
    
    .btn-group .btn {
        padding: 2px 6px;
        font-size: 11px;
    }
}
</style>

<!-- JavaScript for enhanced functionality -->
<script>
// Prevent DataTables or other scripts from interfering
document.addEventListener('DOMContentLoaded', function() {
    // Ensure all table rows remain visible
    var rows = document.querySelectorAll('.ai-reports-table tbody tr');
    rows.forEach(function(row) {
        row.style.display = 'table-row';
        row.style.visibility = 'visible';
        row.style.opacity = '1';
    });
    
    // Prevent any script from modifying confidence score cells
    var scoreCells = document.querySelectorAll('.ai-reports-table tbody tr td:nth-child(' + (<?php echo is_admin() ? '4' : '3'; ?>) + ')');
    scoreCells.forEach(function(cell) {
        // If the cell contains "undefined", fix it
        if (cell.innerHTML.includes('undefined')) {
            console.log('Found undefined in cell, original content:', cell.innerHTML);
            cell.innerHTML = '<span class="text-muted">No Score Available</span>';
        }
    });
    
    // Check if filters are applied and show panel if so
    var hasFilters = <?php echo !empty(array_filter($filters)) ? 'true' : 'false'; ?>;
    if (hasFilters) {
        toggleFilters();
    }
    
    // Debug: Log all progress bars to see their values
    var progressBars = document.querySelectorAll('.progress-bar');
    progressBars.forEach(function(bar, index) {
        console.log('Progress bar ' + index + ':', bar.textContent, 'Width:', bar.style.width);
    });
    
    // Add event listeners for individual checkboxes
    var reportCheckboxes = document.querySelectorAll('input[name="report_ids[]"]');
    reportCheckboxes.forEach(function(checkbox) {
        checkbox.addEventListener('change', updateSelectionCount);
    });
    
    // Initialize selection count
    updateSelectionCount();
});

// Toggle filters panel
function toggleFilters() {
    var panel = document.getElementById('filters-panel');
    var icon = document.getElementById('filter-toggle-icon');
    var text = document.getElementById('filter-toggle-text');
    
    if (panel.style.display === 'none') {
        panel.style.display = 'block';
        icon.className = 'fa fa-chevron-up';
        text.textContent = 'Hide';
    } else {
        panel.style.display = 'none';
        icon.className = 'fa fa-chevron-down';
        text.textContent = 'Show';
    }
}

// Bulk delete functionality
function bulkDeleteReports() {
    var checkboxes = document.querySelectorAll('input[name="report_ids[]"]:checked');
    if (checkboxes.length === 0) {
        alert('Please select at least one report to delete.');
        return;
    }
    
    if (!confirm('Are you sure you want to delete ' + checkboxes.length + ' selected reports? This action cannot be undone.')) {
        return;
    }
    
    var reportIds = [];
    checkboxes.forEach(function(checkbox) {
        reportIds.push(checkbox.value);
    });
    
    console.log('Sending report IDs for deletion:', reportIds);
    
    // Show loading state
    var deleteButton = document.querySelector('.btn-danger');
    if (deleteButton) {
        deleteButton.disabled = true;
        deleteButton.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Deleting...';
    }
    
    // Get CSRF token name and value from CodeIgniter
    var csrfTokenName = '<?php echo $this->security->get_csrf_token_name(); ?>';
    var csrfToken = '<?php echo $this->security->get_csrf_hash(); ?>';
    
    // Prepare form data with CSRF token
    var formData = new FormData();
    formData.append('report_ids', JSON.stringify(reportIds));
    formData.append(csrfTokenName, csrfToken);
    
    // Send AJAX request for bulk delete
    var xhr = new XMLHttpRequest();
    xhr.open('POST', '<?php echo admin_url("ai_reports/bulk_delete"); ?>');
    xhr.timeout = 30000; // 30 second timeout
    
    xhr.onload = function() {
        console.log('Response status:', xhr.status);
        console.log('Response text:', xhr.responseText);
        
        // Reset button state
        if (deleteButton) {
            deleteButton.disabled = false;
            deleteButton.innerHTML = '<i class="fa fa-trash"></i> Delete Selected';
        }
        
        if (xhr.status === 200) {
            try {
                var response = JSON.parse(xhr.responseText);
                if (response.success) {
                    alert(response.message);
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                    console.error('Server error details:', response);
                }
            } catch (e) {
                console.error('Parse error:', e);
                console.error('Response text:', xhr.responseText);
                alert('An error occurred while processing the response. Please check the console for details.');
            }
        } else if (xhr.status === 403) {
            alert('Access denied (403). CSRF token might be invalid or expired. Please refresh the page and try again.');
        } else {
            alert('HTTP error: ' + xhr.status + ' - ' + xhr.statusText);
        }
    };
    
    xhr.onerror = function() {
        alert('Network error occurred. Please try again.');
        
        // Reset button state
        if (deleteButton) {
            deleteButton.disabled = false;
            deleteButton.innerHTML = '<i class="fa fa-trash"></i> Delete Selected';
        }
    };
    
    xhr.ontimeout = function() {
        alert('Request timeout. Please try again.');
        
        // Reset button state
        if (deleteButton) {
            deleteButton.disabled = false;
            deleteButton.innerHTML = '<i class="fa fa-trash"></i> Delete Selected';
        }
    };
    
    xhr.send(formData);
}

// Toggle select all checkboxes
function toggleSelectAll(checkbox) {
    var reportCheckboxes = document.querySelectorAll('input[name="report_ids[]"]');
    
    reportCheckboxes.forEach(function(cb) {
        cb.checked = checkbox.checked;
        // Add/remove selection highlight
        var row = cb.closest('tr');
        if (checkbox.checked) {
            row.classList.add('selected');
        } else {
            row.classList.remove('selected');
        }
    });
    
    updateSelectionCount();
}

// Update selection count and show/hide bulk actions
function updateSelectionCount() {
    var checkedBoxes = document.querySelectorAll('input[name="report_ids[]"]:checked');
    var selectedCount = checkedBoxes.length;
    var bulkActionsBar = document.getElementById('bulk-actions-bar');
    var selectedCountSpan = document.getElementById('selected-count');
    var selectAllCheckbox = document.getElementById('select-all');
    var totalCheckboxes = document.querySelectorAll('input[name="report_ids[]"]').length;
    
    // Update selection count
    if (selectedCountSpan) {
        selectedCountSpan.textContent = selectedCount;
    }
    
    // Show/hide bulk actions bar
    if (selectedCount > 0) {
        if (bulkActionsBar) {
            bulkActionsBar.style.display = 'block';
        }
    } else {
        if (bulkActionsBar) {
            bulkActionsBar.style.display = 'none';
        }
    }
    
    // Update select all checkbox state
    if (selectAllCheckbox) {
        if (selectedCount === 0) {
            selectAllCheckbox.indeterminate = false;
            selectAllCheckbox.checked = false;
        } else if (selectedCount === totalCheckboxes) {
            selectAllCheckbox.indeterminate = false;
            selectAllCheckbox.checked = true;
        } else {
            selectAllCheckbox.indeterminate = true;
        }
    }
    
    // Update row highlighting
    checkedBoxes.forEach(function(checkbox) {
        checkbox.closest('tr').classList.add('selected');
    });
    
    var uncheckedBoxes = document.querySelectorAll('input[name="report_ids[]"]:not(:checked)');
    uncheckedBoxes.forEach(function(checkbox) {
        checkbox.closest('tr').classList.remove('selected');
    });
}

// Clear all selections
function clearSelection() {
    var checkboxes = document.querySelectorAll('input[name="report_ids[]"]');
    checkboxes.forEach(function(checkbox) {
        checkbox.checked = false;
        checkbox.closest('tr').classList.remove('selected');
    });
    
    var selectAllCheckbox = document.getElementById('select-all');
    if (selectAllCheckbox) {
        selectAllCheckbox.checked = false;
        selectAllCheckbox.indeterminate = false;
    }
    
    updateSelectionCount();
}

// Periodic check to ensure table visibility (protection against dynamic interference)
setInterval(function() {
    var rows = document.querySelectorAll('.ai-reports-table tbody tr');
    rows.forEach(function(row) {
        if (row.style.display === 'none' || row.style.visibility === 'hidden') {
            row.style.display = 'table-row';
            row.style.visibility = 'visible';
            row.style.opacity = '1';
        }
    });
}, 1000);
</script>

<?php init_tail(); ?>
