<?php
defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Endpoint for refreshing lead attachments
 */
class Refresh_attachments extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('leads_model');
    }

    public function index($lead_id)
    {
        if (!is_staff_member() || !$this->leads_model->staff_can_access_lead($lead_id)) {
            echo json_encode(['error' => 'Access denied']);
            die;
        }

        $lead = $this->leads_model->get($lead_id);
        $lead->attachments = $this->leads_model->get_lead_attachments($lead_id);
        
        $this->load->view('admin/leads/leads_attachments_template', ['attachments' => $lead->attachments]);
    }
}
