<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Lead_debug extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('leads_model');
        $this->load->model('staff_model');        if (is_dir(FCPATH . 'modules/whatsapp_api')) {
            $this->load->model('whatsapp_api/whatsapp_api_model');
        }
    }

    public function index()
    {
        if (!is_admin()) {
            access_denied('Admin access required');
        }

        $data['title'] = 'Lead Name Parameter Debug';
        
        // Get diagnostic data
        $data['leads'] = $this->leads_model->get('', ['limit' => 5]);
        $data['staff'] = $this->staff_model->get('', ['active' => 1, 'limit' => 5]);
          // Check WhatsApp module
        if (is_dir(FCPATH . 'modules/whatsapp_api')) {
            $data['whatsapp_enabled'] = true;
            $data['templates'] = $this->whatsapp_api_model->get_template_data();
            
            // Check reminders
            $this->db->select('r.*, l.name as lead_name');
            $this->db->from(db_prefix() . 'reminders r');
            $this->db->join(db_prefix() . 'leads l', 'l.id = r.rel_id', 'left');
            $this->db->where('r.rel_type', 'lead');
            $this->db->limit(5);
            $data['lead_reminders'] = $this->db->get()->result();
        } else {
            $data['whatsapp_enabled'] = false;
        }

        $this->load->view('admin/lead_debug/index', $data);
    }

    public function test_merge_fields($lead_id = null)
    {
        if (!is_admin()) {
            access_denied('Admin access required');
        }

        header('Content-Type: application/json');

        if (!$lead_id) {
            // Get first available lead
            $lead = $this->leads_model->get('', ['limit' => 1]);
            if (empty($lead)) {
                echo json_encode(['error' => 'No leads found in database']);
                return;
            }
            $lead_id = $lead[0]['id'];
        }

        $lead_data = $this->leads_model->get($lead_id);
        if (!$lead_data) {
            echo json_encode(['error' => 'Lead not found']);
            return;
        }

        // Simulate the merge fields as created in WhatsApp API library
        $merge_fields = [
            '{lead_name}' => $lead_data->name,
            '{lead_email}' => $lead_data->email,
            '{lead_position}' => $lead_data->title,
            '{lead_website}' => $lead_data->website,
            '{lead_description}' => $lead_data->description,
            '{lead_phonenumber}' => $lead_data->phonenumber,
            '{lead_company}' => $lead_data->company,
            '{lead_country}' => get_country_short_name($lead_data->country),
            '{lead_zip}' => $lead_data->zip,
            '{lead_city}' => $lead_data->city,
            '{lead_state}' => $lead_data->state,
            '{lead_address}' => $lead_data->address,
            '{lead_assigned}' => get_staff_full_name($lead_data->assigned),
            '{lead_status}' => $lead_data->status,
            '{lead_source}' => $lead_data->source,
            '{lead_dateadded}' => date('F j, Y g:i A', strtotime($lead_data->dateadded)),
            '{lead_link}' => admin_url('leads/index/' . $lead_id),
            '{lead_public_form_url}' => leads_public_url($lead_id)
        ];

        // Test message replacement
        $test_messages = [
            'Hello {lead_name}, welcome!',
            'Dear {lead_name}, thank you for contacting {lead_company}',
            'Follow up with {lead_name} at {lead_email}',
            'Reminder: Contact {lead_name} from {lead_company} about {lead_description}'
        ];

        $results = [];
        foreach ($test_messages as $message) {
            $original = $message;
            $processed = $message;
            
            foreach ($merge_fields as $field => $value) {
                $processed = str_replace($field, $value, $processed);
            }
            
            $results[] = [
                'original' => $original,
                'processed' => $processed,
                'replaced' => $processed !== $original
            ];
        }

        echo json_encode([
            'lead_data' => $lead_data,
            'merge_fields' => $merge_fields,
            'test_results' => $results
        ]);
    }

    public function fix_templates()
    {
        if (!is_admin()) {
            access_denied('Admin access required');
        }        if (!is_dir(FCPATH . 'modules/whatsapp_api')) {
            echo json_encode(['error' => 'WhatsApp API module not found']);
            return;
        }

        header('Content-Type: application/json');

        // Get all templates
        $templates = $this->whatsapp_api_model->get_template_data();
        $fixed_count = 0;
        $results = [];

        foreach ($templates as $template) {
            if ($template->rel_type == 'staff_reminder' || $template->rel_type == 'leads') {
                $needs_fix = false;
                $current_params = $template->body_params;
                
                if (empty($current_params)) {
                    $needs_fix = true;
                    $new_params = '[{"type":"text","value":"{lead_name}"}]';
                } else {
                    $params = json_decode($current_params, true);
                    if (json_last_error() === JSON_ERROR_NONE && is_array($params)) {
                        $has_lead_name = false;
                        foreach ($params as $param) {
                            if (isset($param['value']) && strpos($param['value'], '{lead_name}') !== false) {
                                $has_lead_name = true;
                                break;
                            }
                        }
                        
                        if (!$has_lead_name) {
                            $needs_fix = true;
                            // Add {lead_name} as the first parameter
                            array_unshift($params, ["type" => "text", "value" => "{lead_name}"]);
                            $new_params = json_encode($params);
                        }
                    } else {
                        $needs_fix = true;
                        $new_params = '[{"type":"text","value":"{lead_name}"}]';
                    }
                }
                
                if ($needs_fix) {
                    $param_count = count(json_decode($new_params, true));
                    
                    $this->db->where('id', $template->id);
                    $updated = $this->db->update(db_prefix() . 'whatsapp_api_template_mapping', [
                        'body_params' => $new_params,
                        'body_params_count' => $param_count
                    ]);
                    
                    if ($updated) {
                        $fixed_count++;
                        $results[] = [
                            'template_name' => $template->template_name,
                            'status' => 'fixed',
                            'new_params' => $new_params
                        ];
                    } else {
                        $results[] = [
                            'template_name' => $template->template_name,
                            'status' => 'error',
                            'message' => 'Failed to update'
                        ];
                    }
                } else {
                    $results[] = [
                        'template_name' => $template->template_name,
                        'status' => 'ok',
                        'message' => 'Already contains {lead_name}'
                    ];
                }
            }
        }

        echo json_encode([
            'fixed_count' => $fixed_count,
            'results' => $results
        ]);
    }
}
